/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./library","sap/ui/core/AnimationMode","sap/ui/core/Control","./MessageStripUtilities","./Text","./Link","./FormattedText","sap/ui/core/ControlBehavior","sap/ui/core/Lib","sap/ui/core/message/MessageType","./MessageStripRenderer","sap/base/Log","sap/m/Button","sap/ui/core/InvisibleText"],function(e,t,i,s,o,a,n,r,l,p,g,u,d,c){"use strict";var f=e.ButtonType;var y=i.extend("sap.m.MessageStrip",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MessageStrip.designtime",properties:{text:{type:"string",group:"Data",defaultValue:""},type:{type:"sap.ui.core.message.MessageType",group:"Appearance",defaultValue:p.Information},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},showIcon:{type:"boolean",group:"Appearance",defaultValue:false},showCloseButton:{type:"boolean",group:"Appearance",defaultValue:false},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"},controls:{type:"sap.m.Link",multiple:true,singularName:"control",forwarding:{idSuffix:"-formattedText",aggregation:"controls"}},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_closeButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{close:{}},dnd:{draggable:true,droppable:false}},renderer:g});y.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this.setAggregation("_text",new o);this._initCloseButton()};y.prototype.onBeforeRendering=function(){this._normalizeType(this.getType());this._setButtonAriaLabelledBy(this.getType())};y.prototype.setText=function(e){var t=this.getAggregation("_formattedText");if(t){t.setHtmlText(e)}this.getAggregation("_text").setText(e);return this.setProperty("text",e)};y.prototype.close=function(){var e=r.getAnimationMode(),i=e!==t.none&&e!==t.minimal;var o=function(){this.setVisible(false);this.fireClose()}.bind(this);if(!i){o();return}s.closeTransitionWithCSS.call(this,o)};y.prototype.setEnableFormattedText=function(e){var t=this.getAggregation("_formattedText");if(e){if(!t){t=new n(this.getId()+"-formattedText");t._setUseLimitedRenderingRules(true);this.setAggregation("_formattedText",t)}t.setHtmlText(this.getText())}return this.setProperty("enableFormattedText",e)};y.prototype.setAggregation=function(e,t,s){if(e==="link"&&t instanceof a){var o=this._ariaReferenceId(),n=t.getAriaDescribedBy();if(!n.includes(o)){t.addAriaDescribedBy(o)}}i.prototype.setAggregation.call(this,e,t,s);return this};g.getAccessibilityState=function(){var e=s.getAccessibilityState.call(this),t=this.getLink(),i=l.getResourceBundleFor("sap.m");if(!t){e.labelledby=this._ariaReferenceId()}e.roledescription=i.getText("MESSAGE_STRIP_ARIA_ROLE_DESCRIPTION");return e};y.prototype.ontouchmove=function(e){e.setMarked()};y.prototype._normalizeType=function(e){if(e===p.None){u.warning(s.MESSAGES.TYPE_NOT_SUPPORTED);this.setProperty("type",p.Information,true)}};y.prototype._initCloseButton=function(){var e=l.getResourceBundleFor("sap.m"),t=this.getAggregation("_closeButton");if(!t){var i=new d({type:f.Transparent,tooltip:e.getText("MESSAGE_STRIP_TITLE"),icon:"sap-icon://decline",press:this.close.bind(this)}).addStyleClass(s.CLASSES.CLOSE_BUTTON).addStyleClass("sapUiSizeCompact");this.setAggregation("_closeButton",i);this._setButtonAriaLabelledBy(this.getType())}};y.prototype._setButtonAriaLabelledBy=function(e){var t=this.getAggregation("_closeButton"),i=l.getResourceBundleFor("sap.m"),s=i.getText("MESSAGE_STRIP_"+e.toUpperCase()+"_CLOSE_BUTTON");if(!this._oInvisibleText){this._oInvisibleText=new c({text:s}).toStatic()}else{this._oInvisibleText.setText(s)}if(t){t.removeAllAssociation("ariaLabelledBy",true);t.addAssociation("ariaLabelledBy",this._oInvisibleText.getId(),true)}};y.prototype._ariaReferenceId=function(){return this.getId()+"-info"+" "+this.getAggregation("_text").getId()};y.prototype.exit=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};return y});
//# sourceMappingURL=MessageStrip.js.map