/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./InstanceManager","sap/ui/base/DataType","sap/ui/core/AnimationMode","sap/ui/core/ControlBehavior","sap/ui/core/Popup","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/UIArea","sap/ui/Device","sap/base/Log","sap/ui/thirdparty/jquery"],function(e,t,o,i,n,s,a,r,u,l,f,jQuery){"use strict";var d=t.getType("sap.ui.core.Popup.Dock");var c=s.CSSSize;var p={};var m="0 -64",v="sapMMessageToast",_="sapUiSelectable",y="sapContrast",g="sapContrastPlus";p._mSettings={duration:3e3,width:"15em",my:"center bottom",at:"center bottom",of:document.defaultView,offset:"0 0",collision:"fit fit",onClose:null,animationTimingFunction:"ease",animationDuration:1e3,autoClose:true,closeOnBrowserNavigation:true};p._aPopups=[];p._iOpenedPopups=0;p._bBoundedEvents=false;p._mOptions={};p._sMessage="";p._validateSettings=function(e){p._isFiniteInteger(e.duration);p._validateWidth(e.width);p._validateDockPosition(e.my);p._validateDockPosition(e.at);p._validateOf(e.of);p._validateOffset(e.offset);p._validateCollision(e.collision);p._validateOnClose(e.onClose);p._validateAutoClose(e.autoClose);p._validateAnimationTimingFunction(e.animationTimingFunction);p._isFiniteInteger(e.animationDuration)};p._isFiniteInteger=function(e){if(typeof e!=="number"||!isFinite(e)||!(Math.floor(e)===e)||e<=0){f.error('"iNumber" needs to be a finite positive nonzero integer on '+p+"._isFiniteInteger")}};p._validateWidth=function(e){if(!c.isValid(e)){f.error(e+" is not of type "+'"sap.ui.core.CSSSize" for property "width" on '+p+"._validateWidth")}};p._validateDockPosition=function(e){if(!d.isValid(e)){f.error('"'+e+'"'+" is not of type "+'"sap.ui.core.Popup.Dock" on '+p+"._validateDockPosition")}};p._validateOf=function(e){if(!(e instanceof jQuery)&&!(e&&e.nodeType===1)&&!(e instanceof a)&&e!==window){f.error('"of" needs to be an instance of sap.ui.core.Control or an Element or a jQuery object or the window on '+p+"._validateOf")}};p._validateOffset=function(e){if(typeof e!=="string"){f.error(e+" is of type "+typeof e+', expected "string" for property "offset" on '+p+"._validateOffset")}};p._validateCollision=function(e){var t=/^(fit|flip|none|flipfit|flipflip|flip flip|flip fit|fitflip|fitfit|fit fit|fit flip)$/i;if(!t.test(e)){f.error('"collision" needs to be a single value “fit”, “flip”, or “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none", "flipfit" on '+p+"._validateOffset")}};p._validateOnClose=function(e){if(typeof e!=="function"&&e!==null){f.error('"onClose" should be a function or null on '+p+"._validateOnClose")}};p._validateAutoClose=function(e){if(typeof e!=="boolean"){f.error('"autoClose" should be a boolean on '+p+"._validateAutoClose")}};p._validateAnimationTimingFunction=function(e){var t=/^(ease|linear|ease-in|ease-out|ease-in-out)$/i;if(!t.test(e)){f.error('"animationTimingFunction" should be a string, expected values: '+"ease, linear, ease-in, ease-out, ease-in-out on "+p+"._validateAnimationTimingFunction")}};function h(e){for(var t=["my","at","of","offset"],o=0;o<t.length;o++){if(e[t[o]]!==undefined){return false}}return true}function b(e){var t=document.createElement("div");t.className=v+" "+_+" "+y+" "+g;if(i.isAccessibilityEnabled()){t.setAttribute("role","alert")}t.style.width=e.width;t.appendChild(document.createTextNode(e.message));return t}function C(e){if(e){if(h(e)){e.offset=m}if(e.of&&e.of.nodeType===9){e.of=document.defaultView}}else{e={offset:m}}return e}p._handleResizeEvent=function(){if(l.system.phone||l.system.tablet){p._resetPosition(p._aPopups)}setTimeout(p["_applyPositions"].bind(p,p._aPopups),0)};p._handleMouseDownEvent=function(e){var t=e.target.hasAttribute("class")&&e.target.getAttribute("class").indexOf(v)!==-1;if(t||e.isMarked("delayedMouseEvent")){return}p._aPopups.forEach(function(e){e&&e.__bAutoClose&&e.close()})};p._resetPosition=function(e){for(var t=0,o;t<e.length;t++){o=e[t]&&e[t].getContent();if(o){o.style.visibility="hidden";o.style.left=0}}};p._applyPositions=function(e){for(var t=0,o,i;t<e.length;t++){o=e[t];if(o){i=o._oPosition;if(l.system.phone||l.system.tablet){setTimeout(p["_applyPosition"].bind(p,o,i),0)}else{o.setPosition(i.my,i.at,i.of,i.offset)}}}};p._applyPosition=function(e,t){t=t||e._oPosition;var o=e.getContent();e.setPosition(t.my,t.at,t.of,t.offset);o.style.visibility="visible"};p._setCloseAnimation=function(e,t,n,s){var a="opacity "+s.animationTimingFunction+" "+s.animationDuration+"ms",r="webkitTransitionEnd."+v+" transitionend."+v,u=i.getAnimationMode(),l=u!==o.none&&u!==o.minimal;if(l&&s.animationDuration>0){e[0].style.webkitTransition=a;e[0].style.transition=a;e[0].style.opacity=0;e.on(r,function t(){e.off(r);n()})}else{n()}};p._fnKeyDown=function(e){var t;var o=this._aPopups[0];var i=e.shiftKey;var n=l.os.macintosh?e.metaKey:e.ctrlKey;if(o&&o.isOpen()&&i&&n&&e.code==="KeyM"){e.preventDefault();t=document.querySelector(".sapMMessageToastHiddenFocusable");o.getContent().classList.add("sapMFocus");t.focus();clearTimeout(this._iCloseTimeoutId)}};function P(e){var t=e.shiftKey;var o=l.os.macintosh?e.metaKey:e.ctrlKey;var i=this._aPopups[0];if(e.code==="Escape"||t&&o&&e.code==="KeyM"){e.preventDefault();setTimeout(function(){this._mSettings.opener&&this._mSettings.opener.focus()}.bind(this),0);i.close()}}p.show=function(t,o){if(/sap-ui-xx-no-toasts=true/.test(document.location.search)){return}var i=r.closestTo(document.activeElement);var s=i&&i.getUIArea&&i.getUIArea();var a;var u=p,f=jQuery.extend({},p._mSettings,{message:t}),d=new n,c,m,_="mousedown."+v+" touchstart."+v,y;p._mSettings.opener=i;if(!this._oRootNode||this._oRootNode&&s&&s.getRootNode()!==this._oRootNode){this._oRootNode=s?s.getRootNode():document.documentElement}o=C(o);jQuery.extend(f,o);p._validateSettings(f);m=b(f);c=p._aPopups.push(d)-1;d.setContent(m);d.setPosition(f.my,f.at,f.of,f.offset,f.collision);d.setAnimations(function e(t,o,i){i()},function e(t,o,i){u._setCloseAnimation(t,o,i,f)});d.setShadow(false);d.__bAutoClose=f.autoClose;if(f.closeOnBrowserNavigation){e.addPopoverInstance(d)}if(!p._bBoundedEvents){jQuery(window).on("resize."+v,p._handleResizeEvent.bind(p));jQuery(document).on(_,p._handleMouseDownEvent.bind(p));p._bBoundedEvents=true}a=document.createElement("span");a.setAttribute("tabIndex",0);a.setAttribute("class","sapMMessageToastHiddenFocusable");d.getContent().prepend(a);if(this._oRootNode){this._oRootNode.removeEventListener("keydown",u._fnKeyDown.bind(u));this._oRootNode.addEventListener("keydown",u._fnKeyDown.bind(u));a.addEventListener("keydown",P.bind(this))}d.open();p._iOpenedPopups++;function g(){e.removePopoverInstance(u._aPopups[c]);jQuery(u._aPopups[c].getContent()).remove();u._aPopups[c].detachClosed(g);u._aPopups[c].destroy();u._aPopups[c]=null;u._iOpenedPopups--;if(u._iOpenedPopups===0){u._aPopups=[];jQuery(window).off("resize."+v);jQuery(document).off(_);u._bBoundedEvents=false}if(typeof f.onClose==="function"){f.onClose.call(u)}}d.attachClosed(g);this._iCloseTimeoutId=setTimeout(d["close"].bind(d),f.duration);function h(){clearTimeout(u._iCloseTimeoutId);u._iCloseTimeoutId=null;function e(){y=setTimeout(d["close"].bind(d),f.duration);d.getContent().removeEventListener("mouseleave",e)}d.getContent().addEventListener("mouseleave",e);clearTimeout(y);y=null}d.getContent().addEventListener("touchstart",h);d.getContent().addEventListener("mouseover",h);if(l.system.desktop){d.getContent().addEventListener("mouseleave",function(){if(document.activeElement!==d.getContent()){this._iCloseTimeoutId=setTimeout(d["close"].bind(d),f.duration)}})}};p.toString=function(){return"sap.m.MessageToast"};return p},true);
//# sourceMappingURL=MessageToast.js.map