/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./InputBase","./ComboBoxBase","./Tokenizer","./Token","./Popover","./CheckBox","./Toolbar","./library","sap/ui/core/Element","sap/ui/core/EnabledPropagator","sap/ui/core/IconPool","sap/ui/core/Lib","sap/ui/core/library","sap/ui/Device","sap/ui/core/Item","sap/ui/core/ResizeHandler","./MultiComboBoxRenderer","sap/ui/dom/containsOrEquals","sap/m/inputUtils/completeTextSelected","sap/m/inputUtils/inputsDefaultFilter","sap/m/inputUtils/typeAhead","sap/m/inputUtils/ListHelpers","sap/m/inputUtils/filterItems","sap/m/inputUtils/itemsVisibilityHandler","sap/m/inputUtils/forwardItemPropertiesToToken","sap/m/inputUtils/getTokenByItem","sap/ui/events/KeyCodes","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/InvisibleText","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos"],function(e,t,i,s,n,o,r,a,l,h,u,c,g,p,d,f,m,I,y,v,S,_,k,T,b,C,E,P,A,V,O,jQuery){"use strict";var D=a.ListMode;var x=g.ValueState;var F=g.OpenState;var L=a.TokenizerRenderMode;var R=t.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiComboBox.designtime",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]},hasSelection:{type:"boolean",visibility:"hidden",defaultValue:false},showSelectAll:{type:"boolean",defaultValue:false}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},aggregations:{tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},changedItems:{type:"sap.ui.core.Item[]"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}},dnd:{draggable:false,droppable:true}},renderer:m});u.insertFontFaceStyle();h.apply(R.prototype,[true]);R.prototype.clone=function(e){var i=t.prototype.clone.apply(this,arguments),s=this._getList();if(s){i.syncPickerContent()}return i};R.prototype.open=function(){if(!this.isOpen()){this._bPickerIsOpening=true}this.syncPickerContent();return t.prototype.open.apply(this,arguments)};R.prototype.onsapend=function(e){if(e.isMarked("forwardFocusToParent")){this.focus()}};R.prototype.onsaphome=function(e){if(!this.getFocusDomRef().selectionStart&&this._hasTokens()){i.prototype.onsaphome.apply(this.getAggregation("tokenizer"),arguments)}e.setMarked()};R.prototype.onsapdown=function(e){if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();e.preventDefault();this.syncPickerContent();if(!this.isOpen()){this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem&&!this.isFocusInTokenizer()&&!this.isComposingCharacter()){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length)}return}setTimeout(this.handleDownEvent.bind(this,e),0)};R.prototype.onsapup=function(e){if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();e.preventDefault();this.syncPickerContent();if(this.isFocusInTokenizer()||this.isOpen()){return}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length)}};R.prototype.handleDownEvent=function(e){if(!this.isOpen()){return}var t=e.srcControl,i=t&&t.getDomRef(),s=I(this.getDomRef(),i);e.setMarked();e.preventDefault();if(s&&this.getShowSelectAll()){this.focusSelectAll();return}this.focusFirstItemInList()};R.prototype.handleEndEvent=function(e){e.setMarked();e.preventDefault();var t=_.getVisibleItems(this.getItems()),i=t.length&&_.getListItem(t[t.length-1]);i&&i.focus()};R.prototype.handleHomeEvent=function(e){e.setMarked();e.preventDefault();if(this.getShowSelectAll()){this.focusSelectAll();e.stopPropagation(true);return}this.focusFirstItemInList()};R.prototype.focusFirstItemInList=function(){var e=_.getVisibleItems(this.getItems()),t=e.length&&_.getListItem(e[0]);t&&t.focus()};R.prototype.isFocusInTokenizer=function(){return jQuery.contains(this.getAggregation("tokenizer").getFocusDomRef(),document.activeElement)};R.prototype.onsapshow=function(e){e.preventDefault();this._handleItemToFocus();t.prototype.onsapshow.apply(this,arguments)};R.prototype._handlePopupOpenAndItemsLoad=function(){this._handleItemToFocus();t.prototype._handlePopupOpenAndItemsLoad.apply(this,arguments)};R.prototype._closePickerDelegate={onsaptabnext:function(){this.close();setTimeout(function(){this.closeValueStateMessage()}.bind(this),0)}};R.prototype._formattedTextLinksNav=function(){return{onsapup:this.focus,onsapdown:this.handleDownEvent}};R.prototype._handleFormattedTextNav=function(){var e=this.getPicker().getCustomHeader();var t=this.getValueStateLinks();if(!e.getDomRef()||t.length===0){return}const i=t[t.length-1];const s=t[0];s.focus();if(!this.bSetLinksDelegates){this.bSetLinksDelegates=true;t.forEach(function(e){e.addEventDelegate(this._formattedTextLinksNav(),this)},this);const e={onsaptabprevious:function(e){e.preventDefault();this.getFocusDomRef().focus()}};i.addEventDelegate(this._closePickerDelegate,this);s.addEventDelegate(e,this)}};R.prototype.onsaphide=function(e){this.onsapshow(e)};R.prototype._selectItemByKey=function(e){var t,i,s,n,o,r;if(!this.getEnabled()||!this.getEditable()){return}if(e){e.setMarked()}t=this._getUnselectedItems();for(n=0;n<t.length;n++){r=!(t[n].getKey()===undefined||t[n].getKey()===null)&&!t[n].isA("sap.ui.core.SeparatorItem");if(t[n].getText().toUpperCase()===this.getValue().toUpperCase()&&r){s=t[n];o=true;break}}if(o){i={item:s,id:s.getId(),key:s.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||typeof this.getValue()==="string"&&s.getText().toLowerCase().startsWith(this.getValue().toLowerCase())){if(_.getListItem(s).getSelected()){this.setValue("")}else{this.setSelection(i)}}}else{this._bPreventValueRemove=true}if(e){this.close()}};R.prototype.onsapenter=function(t){var i=this.getAggregation("tokenizer");e.prototype.onsapenter.apply(this,arguments);this._showAlreadySelectedVisualEffect();if(this.getValue()&&!this.isComposingCharacter()){this._selectItemByKey(t)}if(!this.getEditable()&&i.getHiddenTokensCount()&&t.target===this.getFocusDomRef()){i._togglePopup(i.getTokensPopup(),this.getDomRef())}};R.prototype.onsaptabnext=function(e){var t=this.getValue();if(t){var i=this._getUnselectedItemsStartingText(t);if(i.length){this._selectItemByKey(e)}else{this._showWrongValueVisualEffect()}}};R.prototype.onsaptabprevious=R.prototype.onsaptabnext;R.prototype.onsapfocusleave=function(e){var t=this.isPlatformTablet(),i=l.getElementById(e.relatedControlId),s=i&&i.getFocusDomRef(),n=this.getPicker(),o=this.getAggregation("tokenizer");if(!this._bPickerIsOpening&&(!n||!n.getFocusDomRef()||!s||!jQuery.contains(n.getFocusDomRef(),s))){if(!jQuery.contains(this.getDomRef(),document.activeElement)){o.setRenderMode(L.Narrow)}}if(n&&s){if(P(n.getFocusDomRef(),s)&&!t&&!this.isPickerDialog()){this.focus()}}};R.prototype.onfocusin=function(e){var t=this.getPicker();var i=false;var s=t&&t.getFocusDomRef();var n=t&&t.oPopup.getOpenState()||F.CLOSED;var o=n===F.CLOSING||n===F.CLOSED;var r=this.getPickerType()==="Dropdown";var a=this.getAggregation("tokenizer");if(r){i=s&&jQuery.contains(s,e.relatedTarget)}if(this.getEditable()&&e.target===this.getDomRef("inner")){a.setRenderMode(L.Loose);setTimeout(a["scrollToEnd"].bind(a),0)}if(e.target===this.getFocusDomRef()){a.hasOneTruncatedToken()&&a.setFirstTokenTruncated(false);this.getEnabled()&&this.addStyleClass("sapMFocus");!o&&i&&this.handleInputValidation(e,false)}if(e.target===this.getOpenArea()&&r&&!this.isPlatformTablet()){this.focus()}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage()}};R.prototype._handleItemTap=function(e){var t=l.closestTo(e.target);if(!t.isA("sap.m.CheckBox")&&!t.isA("sap.m.GroupHeaderListItem")){this._bCheckBoxClicked=false}};R.prototype._handleItemPress=function(e){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==F.CLOSING){this.clearFilter();var t=this._getLastSelectedItem();if(t){_.getListItem(t).focus()}}};R.prototype._handleSelectionLiveChange=function(e){if(e.getParameter("selectAll")){return}var t=e.getParameter("listItem");var i=e.getParameter("listItems");var s=i&&i[i.length-1]||t;var n=this.isPickerDialog()?this.getPickerTextField():this;var o=this._getIsClick()&&!!s;var r=e.getParameter("selected");var a=_.getItemByListItem(this.getItems(),t);var l;if(i&&i.length){l=[];i.forEach(function(e){if(e.getType()==="Active"){l.push(_.getItemByListItem(this.getItems(),e))}},this)}if(t.getType()==="Inactive"){return}A(a,"The corresponding mapped item was not found on "+this);if(!a){return}var h={item:a,items:l,id:a.getId(),key:a.getKey(),selectAll:false,fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(r){this.fireChangeEvent(a.getText());this.setSelection(h)}else{this.fireChangeEvent(a.getText());this.removeSelection(h)}if(this._bCheckBoxClicked){n.setValue(this._sOldInput);if(o&&this.isOpen()&&this.getPicker().oPopup.getOpenState()!==F.CLOSING){s.focus();this._setIsClick(false)}}else{this._bCheckBoxClicked=true;this.setValue("");this.close()}};R.prototype.onkeydown=function(e){if(this.areHotKeysPressed(e)&&this.isOpen()){this._handleFormattedTextNav();return}var i=this.getEditable(),s=this.getAggregation("tokenizer"),n=s.getTokens().length;t.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()){return}if((e.ctrlKey||e.metaKey)&&e.which===E.I&&n){e.preventDefault();if(i){this._togglePopover()}else{this._handleIndicatorPress()}return}this._bIsPasteEvent=(e.ctrlKey||e.metaKey)&&e.which===E.V;if(this.getValue().length===0&&(e.ctrlKey||e.metaKey)&&e.which===E.A&&this._hasTokens()){s.focus();s.selectAllTokens(true);e.preventDefault()}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=jQuery(this.getFocusDomRef()).cursorPos()}this._bDoTypeAhead=!p.os.android&&e.which!==E.BACKSPACE&&e.which!==E.DELETE};R.prototype.oninput=function(e){t.prototype.oninput.apply(this,arguments);var i=e.srcControl,s=this.isPickerDialog(),n=s?this.getPickerTextField():this,o=n.getValueState();if(o===x.Error&&this._bAlreadySelected){n.setValueState(this._sInitialValueState);n.setValueStateText(this._sInitialValueStateText);this._bAlreadySelected=false}if(!this.getEnabled()||!this.getEditable()){return}this.syncPickerContent();this.handleInputValidation(e,this.isComposingCharacter());if(this._bIsPasteEvent){i.updateDomValue(this._sOldValue||e.target.value||"");return}if(this.isOpen()){setTimeout(this.highlightList.bind(this,this._sOldInput))}if(this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true)}};R.prototype.filterItems=function(e){return k(this,e.items,e.value,true,false,this.fnFilter||v)};R.prototype.onkeyup=function(e){t.prototype.onkeyup.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return}this._sOldValue=this.getValue();this._iOldCursorPos=jQuery(this.getFocusDomRef()).cursorPos()};R.prototype._showWrongValueVisualEffect=function(){var e=this._getSuggestionsPopover();var t=this._sInitialValueStateText;var i=this._sInitialValueState;var s=t||this._oRbC.getText("VALUE_STATE_ERROR");var n=this;if(i===x.Error){return}if(e){e.updateValueState(x.Error,s,true);setTimeout(e.updateValueState.bind(e,n.getValueState(),s,true),1e3)}if(!this.isPickerDialog()){this.setValueState(x.Error);this.setValueStateText(this.getValueStateText()||s);setTimeout(this["setValueState"].bind(this,i||x.Error),1e3)}this._syncInputWidth(this.getAggregation("tokenizer"))};R.prototype._showAlreadySelectedVisualEffect=function(){var e=this._oRb.getText("VALUE_STATE_ERROR_ALREADY_SELECTED");if(!this.getValue()){return}var t=!!this.getSelectedItems().filter(function(e){return e.getText().toLowerCase()===this.getValue().toLowerCase()},this).length;var i=this.getItems().filter(function(e){return e.getText().toLowerCase()===this.getValue().toLowerCase()},this).length;if(t){if(!this._bAlreadySelected){this._sInitialValueState=this.getValueState();this._sInitialValueStateText=this.getValueStateText()}this._bAlreadySelected=true;this.setValueStateText(e);this.setValueState("Error");return}else if(i){return}else{this._showWrongValueVisualEffect()}};R.prototype._hasShowSelectedButton=function(){return true};R.prototype.forwardEventHandlersToSuggPopover=function(e){t.prototype.forwardEventHandlersToSuggPopover.apply(this,arguments);e.setShowSelectedPressHandler(this._filterSelectedItems.bind(this))};R.prototype.configPicker=function(e){var t=this.getRenderer(),i=t.CSS_CLASS_MULTICOMBOBOX;e.setHorizontalScrolling(false).addStyleClass(t.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(i+"Picker").addStyleClass(i+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this)};R.prototype._configureList=function(e){var t=10;if(!e){return}e.applyAriaRole("listbox");e.setMode(D.MultiSelect);e.setIncludeItemInSelection(true);e.setGrowingThreshold(t);e.attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);e.addEventDelegate({onAfterRendering:this.onAfterRenderingList,onfocusin:this.onFocusinList},this);this.getShowSelectAll()&&this.createSelectAllHeaderToolbar(e)};R.prototype._decoratePopupInput=function(e){t.prototype._decoratePopupInput.apply(this,arguments);if(!e||!e.isA(["sap.m.InputBase"])){return}e.attachSubmit(function(t){var i=e.getValue();if(i){this.setValue(i);this._selectItemByKey();this.setValue(this._sOldInput);this.close()}}.bind(this));e.addEventDelegate({onfocusout:this._handleInputFocusOut},this);e.attachChange(this._handleInnerInputChange.bind(this));return e};R.prototype._handleOkPress=function(){t.prototype._handleOkPress.apply(this,arguments);if(this.getValue()){this._selectItemByKey()}};R.prototype._handleInnerInputChange=function(e){if(e.getParameter("value")===""){this._sOldInput="";this.clearFilter()}};R.prototype.onBeforeRendering=function(){var e=this.getEditable();var i=this.getAggregation("tokenizer");var s=this.getItems();t.prototype.onBeforeRendering.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=true;i.setEnabled(this.getEnabled());i.setEditable(e);this._updatePopoverBasedOnEditMode(e);if(!s.length){this._clearTokenizer()}if(this._getList()){this.syncPickerContent(true)}this.toggleSelectAllVisibility(this.getShowSelectAll());if(this._sOldInput&&s.length&&this.isOpen()){T(this.getItems(),this.filterItems({value:this._sOldInput,items:s}));setTimeout(this.highlightList.bind(this,this._sOldInput))}this._deregisterResizeHandler();this._synchronizeSelectedItemAndKey();this.setProperty("hasSelection",!!this.getSelectedItems().length);if(!this._bAlreadySelected){this._sInitialValueStateText=this.getValueStateText()}if(this.getValueState()!==x.Error){this._sInitialValueState=this.getValueState()}if(this.getShowClearIcon()){this._getClearIcon().setVisible(this.shouldShowClearIcon())}else if(this._oClearIcon){this._getClearIcon().setVisible(false)}};R.prototype.syncPickerContent=function(e){var t,i;var s=this.getPicker();var n=this.getAggregation("tokenizer");if(!s){s=this.createPicker(this.getPickerType());this._updateSuggestionsPopoverValueState();e=true}if(e){i=this._getList();t=this.getEditable()?this.getItems():this.getSelectedItems();this._synchronizeSelectedItemAndKey();var o=n.getTokens();var r=o.findIndex(function(e){return document.activeElement===e.getDomRef()});i.destroyItems();this._clearTokenizer();this._fillList(t);this.bShouldRestoreTokenizerFocus=r>-1;this.iFocusedIndex=r;if(i.getItemNavigation()){this._iFocusedIndex=i.getItemNavigation().getFocusedIndex()}}return s};R.prototype._registerResizeHandler=function(){A(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=f.register(this,this._onResize.bind(this))};R.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){f.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null}};R.prototype._onResize=function(){var e=this.getAggregation("tokenizer");e.setMaxWidth(this._calculateSpaceForTokenizer());this._syncInputWidth(e);this._handleNMoreAccessibility()};R.prototype.onAfterRenderingPicker=function(){var e=this["_onAfterRendering"+this.getPickerType()];var t=this.getDomRef().getBoundingClientRect().width;var i=getComputedStyle(this.getDomRef()).getPropertyValue("--sPopoverMaxWidth");if(e){e.call(this)}if(t<=parseInt(i)&&!p.system.phone){this.getPicker().addStyleClass("sapMSuggestionPopoverDefaultWidth")}else{this.getPicker().getDomRef().style.setProperty("max-width",t+"px");this.getPicker().addStyleClass("sapMSuggestionPopoverInputWidth")}};R.prototype.onBeforeOpen=function(){t.prototype.onBeforeOpen.apply(this,arguments);var e=this._getSuggestionsPopover();var i=this["_onBeforeOpen"+this.getPickerType()],s=this.getFocusDomRef();if(s){s.setAttribute("aria-controls",this.getPicker().getId())}this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();this._synchronizeSelectedItemAndKey();if(i){i.call(this)}e.resizePopup(this)};R.prototype.onAfterOpen=function(){var e=this.getFocusDomRef();e&&this.getFocusDomRef().setAttribute("aria-expanded","true");this._bPickerIsOpening=false;this.closeValueStateMessage()};R.prototype.onBeforeClose=function(){t.prototype.onBeforeClose.apply(this,arguments)};R.prototype.onAfterClose=function(){var e=!jQuery.contains(this.getDomRef(),document.activeElement)||this.isPickerDialog(),t=this.getFocusDomRef();t&&this.getFocusDomRef().setAttribute("aria-expanded","false");this.toggleIconPressedStyle(false);this.clearFilter();!this.isComposingCharacter()&&!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";this._sOldInput="";this._getSuggestionsPopover()._sTypedInValue="";if(this.isPickerDialog()){this.getPickerTextField().setValue("");this.getFilterSelectedButton()&&this.getFilterSelectedButton().setPressed(false)}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});this.getAggregation("tokenizer").setRenderMode(e?L.Narrow:L.Loose);if(this.getValueState()==x.Error&&document.activeElement===this.getFocusDomRef()){this.selectText(0,this.getValue().length)}};R.prototype._onBeforeOpenDialog=function(){};R.prototype._onBeforeOpenDropdown=function(){var e=this.getPicker(),t=this.getDomRef(),i;if(t&&e){i=t.offsetWidth/parseFloat(a.BaseFontSize)+"rem";e.setContentMinWidth(i)}};R.prototype.getFilterSelectedButton=function(){return this._getSuggestionsPopover().getFilterSelectedButton()};R.prototype._filterSelectedItems=function(e,t){var i=e.oSource,s,n,o=this.getPickerTextField()?this.getPickerTextField().getValue():"",r=i&&i.getPressed&&i.getPressed()||t,a=_.getVisibleItems(this.getItems()),l=this.getItems(),h=this.getSelectedItems(),u=null;if(r){a.forEach(function(e){n=h.indexOf(e)>-1?true:false;s=_.getListItem(e);if(!s){return}if(s.isA("sap.m.GroupHeaderListItem")){s.setVisible(false);u=s}else{s.setVisible(n);if(n&&u){u.setVisible(true)}}},this)}else{T(this.getItems(),this.filterItems({value:o,items:l}))}this.manageSelectAllCheckBoxState()};R.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems)};R.prototype.setSelection=function(e){var t=this._getList(),i;if(e.item&&this.isItemSelected(e.item)){return}if(!e.item){return}if(!e.items||!e.items.length||e.selectAll){i=[e.item]}else{i=e.items}i.forEach(function(i){if(!e.listItemUpdated&&_.getListItem(i)&&t){t.setSelectedItem(_.getListItem(i),true)}var n=new s({key:i.getKey()});n.setText(i.getText());i.data(_.CSS_CLASS+"Token",n);this.getAggregation("tokenizer").addToken(n);this.addAssociation("selectedItems",i,e.suppressInvalidate);var o=this.getSelectedKeys();var r=this.getKeys([i])[0];if(r===""||o.indexOf(r)===-1){o.push(r);this.setProperty("selectedKeys",o,e.suppressInvalidate)}if(e.fireChangeEvent){this.fireSelectionChange({changedItem:e.item,changedItems:e.items,selectAll:e.selectAll,selected:true})}},this);if(!this.getProperty("hasSelection")&&this.getSelectedItems().length){this.setProperty("hasSelection",true)}this.setValue("");if(e.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()})}}};R.prototype.removeSelection=function(e){var t,i,s;if(e.item&&!this.isItemSelected(e.item)){return}if(!e.item){return}if(!e.items||!e.items.length||e.selectAll){t=[e.item]}else{t=e.items}t.forEach(function(t){this.removeAssociation("selectedItems",t,e.suppressInvalidate);i=this.getSelectedKeys();s=i.indexOf(t.getKey());i.splice(s,1);this.setProperty("selectedKeys",i,e.suppressInvalidate);if(!e.listItemUpdated&&_.getListItem(t)){var n=_.getListItem(t);this._getList().setSelectedItem(n,false)}if(!e.tokenUpdated){var o=C(t);t.data(_.CSS_CLASS+"Token",null);this.getAggregation("tokenizer").removeToken(o)}if(e.fireChangeEvent){this.fireSelectionChange({changedItem:e.item,changedItems:e.items,selectAll:e.selectAll,selected:false})}},this);if(this.getProperty("hasSelection")&&!this.getSelectedItems().length){this.setProperty("hasSelection",false)}if(e.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()})}}};R.prototype._synchronizeSelectedItemAndKey=function(){var e=this.getSelectedKeys();var t=this.getKeys(this.getSelectedItems());if(!e.length){V.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return}for(var i=0,s=null,n=null,o=e.length;i<o;i++){s=e[i];if(t.indexOf(s)>-1){continue}n=this.getItemByKey(""+s);if(n){this.setSelection({item:n,id:n.getId(),key:n.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false})}}};R.prototype.updateItems=function(e){var i=function(e){return e&&e.getKey&&e.getKey()},s,n=this.getSelectedItems().map(i),o=this.getSelectedKeys();var r=t.prototype.updateItems.apply(this,arguments);n=this.getSelectedItems().map(i).filter(function(e){return n.indexOf(e)>-1});s=o.concat(n);this.setSelectedKeys(s);return r};R.prototype._getSelectedItemsOf=function(e){for(var t=0,i=e.length,s=[];t<i;t++){if(_.getListItem(e[t]).getSelected()){s.push(e[t])}}return s};R.prototype._getLastSelectedItem=function(){var e=this.getAggregation("tokenizer").getTokens();var t=e.length?e[e.length-1]:null;if(!t){return null}return this._getItemByToken(t)};R.prototype._getFocusedListItem=function(){if(!document.activeElement){return null}var e=l.getElementById(document.activeElement.id);if(this._getList()&&I(this._getList().getFocusDomRef(),e.getFocusDomRef())){return e}return null};R.prototype._getFocusedItem=function(){return _.getItemByListItem(this.getItems(),this._getFocusedListItem())};R.prototype._hasTokens=function(){return this.getAggregation("tokenizer").getTokens().length>0};R.prototype._decorateListItem=function(e){e.addDelegate({onkeydown:function(e){if((e.ctrlKey||e.metaKey)&&e.which==E.A){e.setMarked();e.preventDefault();var t=_.getSelectableItems(this.getItems());var i=this._getSelectedItemsOf(t);if(i.length!==t.length){t.forEach(function(e){this.setSelection({item:e,items:t,selectAll:true,id:e.getId(),key:e.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false})},this)}else{t.forEach(function(e){this.removeSelection({item:e,items:t,selectAll:true,id:e.getId(),key:e.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false})},this)}}if(this.areHotKeysPressed(e)){this._handleFormattedTextNav(e)}},onmousedown:function(e){this._setIsClick(true)},onkeyup:function(e){var t=null;if(e.which==E.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();t=this._getLastSelectedItem();if(t){_.getListItem(t).focus()}return}}},true,this);e.addEventDelegate({onsapbackspace:function(e){e.preventDefault()},onsapshow:function(e){e.setMarked();this.close()},onsaphide:function(e){this.onsapshow(e)},onsapenter:function(e){e.setMarked();if(e.srcControl&&e.srcControl.isA("sap.m.GroupHeaderListItem")){return}this.close()},onsaphome:this.handleHomeEvent.bind(this),onsapend:this.handleEndEvent.bind(this),onsapup:function(e){e.setMarked();e.preventDefault();var t=_.getVisibleItems(this.getItems());var i=t[0];var s=l.closestTo(document.activeElement);if(s!==_.getListItem(i)){return}if(this.getShowSelectAll()){this.focusSelectAll()}else{this.focus()}e.stopPropagation(true)},onfocusin:function(e){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused")},onfocusout:function(e){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused")},onsapfocusleave:function(e){var t=this.getAggregation("picker");var i=l.getElementById(e.relatedControlId);if(t&&i&&P(t.getFocusDomRef(),i.getFocusDomRef())){if(e.srcControl){e.srcControl.focus()}}},onsaptabnext:function(){this.getPicker().close()},onsaptabprevious:function(){this.getPicker().close()}},this);if(p.support.touch){e.addEventDelegate({ontouchstart:function(e){e.setMark("cancelAutoClose")}})}};R.prototype._handleInputFocusOut=function(e){var t=this.isPickerDialog(),i=t?this.getPickerTextField():this,s=this._sOldInput||this._sOldValue||"",n=t&&e&&e.relatedTarget&&e.relatedTarget.id.includes("-popup-closeButton");if(!n){i.updateDomValue(s)}this._bIsPasteEvent=null};R.prototype.onItemChange=function(e){var i=t.prototype.onItemChange.call(this,e,this.getShowSecondaryValues());var s=e.getParameters();b({item:e.getSource(),propName:s.name,propValue:s.newValue});return i};R.prototype._handleIndicatorPress=function(){var e,t=this.getAggregation("tokenizer");if(this.getEditable()){this.syncPickerContent();this._filterSelectedItems({},true);this.focus();e=this.getPicker();e.open()}else{t._togglePopup(t.getTokensPopup(),this.getDomRef())}if(this.isPickerDialog()){this.getFilterSelectedButton().setPressed(true);this.bOpenedByKeyboardOrButton=true}};R.prototype._togglePopover=function(){var e=this.getPicker();if(!e){e=this.syncPickerContent(true)}if(e.isOpen()){e.close()}else{e.open()}};R.prototype._createTokenizer=function(){var e=new i({renderMode:L.Narrow}).attachTokenDelete(this._handleTokenDelete,this);e.getTokensPopup().attachAfterOpen(function(){if(e.hasOneTruncatedToken()){e.setFirstTokenTruncated(false)}}).attachAfterClose(function(){var t=e.getTokens();if(t.length===1&&!t[0].getTruncated()){e.setFirstTokenTruncated(true)}});e.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);e.setShouldRenderTabIndex(false);return e};R.prototype._onAfterRenderingTokenizer=function(){var e=this.getAggregation("tokenizer");if(this.getEditable()){e.addStyleClass("sapMTokenizerIndicatorDisabled")}else{e.removeStyleClass("sapMTokenizerIndicatorDisabled")}setTimeout(this._syncInputWidth.bind(this,e),0);setTimeout(this._handleNMoreAccessibility.bind(this),0)};R.prototype._handleTokenDelete=function(e){var t=e.getParameter("tokens");var i=this.getSelectedItems();this._removeSelection(t);if(i.length!==_.getSelectableItems(this.getItems())){!this.isPickerDialog()&&!this.isFocusInTokenizer()&&this.focus();this.fireChangeEvent("")}};R.prototype._removeSelection=function(e){var t=this.getAggregation("tokenizer");e.forEach(function(e){var i=e&&this._getItemByToken(e);if(!this.getEditable()||!this.getEnabled()||!i||!this.isItemSelected(i)||!i.getEnabled()||!e.getEditable()){return}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});e.destroy();if(this.getSelectedItems().length>0){var s=t.getTokens();s[s.length-1].focus()}else{this.focus()}},this)};R.prototype.onAfterRenderingList=function(){var e=document.activeElement===this.getFocusDomRef();var t=l.closestTo(document.activeElement);var i=t&&t.isA("sap.m.Token");var s=this._getList();var n=s?s.getVisibleItems():[];if(this.getEditable()&&!e&&!i&&n[this._iFocusedIndex]){n[this._iFocusedIndex].focus();this._iFocusedIndex=null}this.manageSelectAllCheckBoxState()};R.prototype.onFocusinList=function(){var e=this._getList();if(this._bListItemNavigationInvalidated&&this._getList().getItemNavigation()){e.getItemNavigation().setSelectedIndex(this._iInitialItemFocus);this._bListItemNavigationInvalidated=false}this._getSuggestionsPopover().updateListDataAttributes(e)};R.prototype.onAfterRendering=function(){var e=this.getAggregation("tokenizer");var i;t.prototype.onAfterRendering.apply(this,arguments);this._registerResizeHandler();setTimeout(function(){e.setMaxWidth(this._calculateSpaceForTokenizer())}.bind(this),0);if(this.bShouldRestoreTokenizerFocus){i=e.getTokens()[this.iFocusedIndex];if(i){i.focus()}this.bShouldRestoreTokenizerFocus=false}};R.prototype.onfocusout=function(e){this.isOpen()&&this._handleInputFocusOut();this.removeStyleClass("sapMFocus");if(this.getValueState()===x.Error&&this.getValueStateText()===this._oRb.getText("VALUE_STATE_ERROR_ALREADY_SELECTED")){this.setValueState(this._sInitialValueState);this.setValueStateText(this._sInitialValueStateText)}t.prototype.onfocusout.apply(this,arguments);var i=this.getValue(),s=this.getPicker(),n=e.relatedTarget;if(!I(s?.getDomRef(),n)&&!I(this.getDomRef(),n)){this.setValue(null);if(i){this.fireChangeEvent("",{value:i})}}};R.prototype.onpaste=function(e){var t;var i=false;var s=this.getSelectedItems();var n=_.getSelectableItems(this.getItems());if(!n.length){this.syncPickerContent(true)}n=_.getSelectableItems(this.getItems());t=e.originalEvent.clipboardData.getData("text/plain");if(t.length&&t.endsWith("\r\n")){t=t.substring(0,t.lastIndexOf("\r\n"))}var o=t.split(/\r\n|\r|\n|\t/g);if(o&&o.length>1){n.filter(function(e){return s.indexOf(e)===-1}).forEach(function(e){if(o.indexOf(e.getText())>-1){i=true;this.setSelection({item:e,id:e.getId(),key:e.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false})}},this)}if(i){e.stopPropagation();e.preventDefault()}};R.prototype.onsapbackspace=function(e){var t=this.getAggregation("tokenizer");var i=t.getTokens();var s=i.filter(function(e){return e.getSelected()});if(!this.getEnabled()||!this.getEditable()){e.preventDefault();return}if(this.getCursorPosition()>0||this.getValue().length>0){return}if(s.length>0){this._removeAllTokens();return}if(document.activeElement===this.getFocusDomRef()){i[i.length-1]&&i[i.length-1].focus()}e.preventDefault()};R.prototype._removeAllTokens=function(){var e=this.getAggregation("tokenizer");var t=e.getTokens().filter(function(e){return e.getSelected()});if(!t.length){return}this._removeSelection(t);this.fireChangeEvent("");this.invalidate()};R.prototype.onsapdelete=R.prototype.onsapbackspace;R.prototype.onsapnext=function(e){var t=this.getAggregation("tokenizer");if(e.isMarked()){return}var i=l.closestTo(document.activeElement);if(!i){return}if(i===t||t.$().find(i.$()).length>0&&this.getEditable()){t.scrollToEnd();this.focus()}};R.prototype.onsapprevious=function(e){if(this.getCursorPosition()===0&&!y(this.getFocusDomRef())){if(e.srcControl===this){i.prototype.onsapprevious.apply(this.getAggregation("tokenizer"),arguments)}}};R.prototype.onclick=function(e){var t=this.getEditable(),i=this.getEnabled(),s=e.target.className.indexOf("sapMTokenizerIndicator")>-1;if(t&&i&&s){e.preventDefault();this._handleIndicatorPress()}};R.prototype.ontap=function(e){t.prototype.ontap.apply(this,arguments);var i=this.getOpenArea();if(!this.getEnabled()||!this.getEditable()){return}e.setMarked();if(this.isPickerDialog()&&i.contains(e.target)){this.open()}};R.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef()}else{return t.prototype.getOpenArea.apply(this,arguments)}};R.prototype._getItemsStartingWithPerTerm=function(e,t){var i=[],s=t?_.getEnabledItems(this.getItems()):_.getSelectableItems(this.getItems()),n=this.fnFilter?this.fnFilter:v;s.forEach(function(t){if(n(e,t)){i.push(t)}},this);return i};R.prototype._getItemsStartingWith=function(e,t){var i=[],s=t?_.getEnabledItems(this.getItems()):_.getSelectableItems(this.getItems());s.forEach(function(t){if(typeof e==="string"&&e!==""&&t.getText().toLowerCase().startsWith(e.toLowerCase())){i.push(t)}},this);return i};R.prototype._getUnselectedItemsStartingText=function(e){var t=[];this._getUnselectedItems().forEach(function(i){if(typeof e==="string"&&e!==""&&i.getText().toLowerCase().startsWith(e.toLowerCase())){t.push(i)}},this);return t};R.prototype.getCursorPosition=function(){return this._$input.cursorPos()};R.prototype._selectPreviousItemsOf=function(e){var t;do{t=true;var i=this._getPreviousVisibleItemOf(e);if(i){var s=_.getListItem(i);if(s){t=_.getListItem(i).getSelected()}}this.setSelection({item:e,id:e.getId(),key:e.getKey(),fireChangeEvent:true,suppressInvalidate:true});e=i}while(!t)};R.prototype._getNextVisibleItemOf=function(e){var t=_.getSelectableItems(this.getItems());var i=t.indexOf(e)+1;if(i<=0||i>t.length-1){return null}return t[i]};R.prototype._getPreviousVisibleItemOf=function(e){var t=_.getSelectableItems(this.getItems());var i=t.indexOf(e)-1;if(i<0){return null}return t[i]};R.prototype._getNextUnselectedItemOf=function(e){var t=this._getUnselectedItems();var i=t.indexOf(e)+1;if(i<=0||i>t.length-1){return null}return t[i]};R.prototype._getPreviousUnselectedItemOf=function(e){var t=this._getUnselectedItems();var i=t.indexOf(e)-1;if(i<0){return null}return t[i]};R.prototype._getNextTraversalItem=function(){var e=this.getValue();var t=this._getUnselectedItemsPerTerm(e);if(t.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem)}return t[0]};R.prototype._getPreviousTraversalItem=function(){var e=this.getValue();var t=this._getUnselectedItemsPerTerm(e);if(t.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem)}return t[t.length-1]};R.prototype.setSelectedItems=function(e){this.removeAllSelectedItems();if(!e||!e.length){return this}if(!Array.isArray(e)){V.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this}e.forEach(function(e){if(!(e instanceof d)&&typeof e!=="string"){V.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return}if(typeof e==="string"){e=l.getElementById(e)}this.setSelection({item:e?e:null,id:e?e.getId():"",key:e?e.getKey():"",suppressInvalidate:true})},this);return this};R.prototype.addSelectedItem=function(e){if(!e){return this}if(typeof e==="string"){e=l.getElementById(e)}this.setSelection({item:e?e:null,id:e?e.getId():"",key:e?e.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this};R.prototype.removeSelectedItem=function(e){if(!e){return null}if(typeof e==="string"){e=l.getElementById(e)}if(!this.isItemSelected(e)){return null}this.removeSelection({item:e,id:e.getId(),key:e.getKey(),fireChangeEvent:false,suppressInvalidate:true});return e};R.prototype.removeAllSelectedItems=function(){var e=[];var t=this.getAssociation("selectedItems",[]);t.forEach(function(t){var i=this.removeSelectedItem(t);if(i){e.push(i.getId())}},this);return e};R.prototype.removeSelectedKeys=function(e){var t,i=[];if(!e||!e.length||!Array.isArray(e)){return i}e.forEach(function(e){t=this.getItemByKey(e);if(t){this.removeSelection({item:t?t:null,id:t?t.getId():"",key:t?t.getKey():"",fireChangeEvent:false,suppressInvalidate:true});i.push(t)}},this);return i};R.prototype.setSelectedKeys=function(e){if(this._bInitialSelectedKeysSettersCompleted){this.setProperty("selectedKeys",[],true);this.removeAllSelectedItems()}this.addSelectedKeys(e);this._bInitialSelectedKeysSettersCompleted=true;return this};R.prototype.addSelectedKeys=function(e){var t,i=[];e=this.validateProperty("selectedKeys",e);e.forEach(function(e){var t=this.getItemByKey(e);if(t){this.addSelectedItem(t)}else if(e!=null){i.push(e)}},this);if(i.length>0){t=this.getProperty("selectedKeys").filter(function(e){return i.indexOf(e)===-1});i=t.concat(i);this.setProperty("selectedKeys",i,true)}return this};R.prototype._getUnselectedItems=function(){var e=jQuery(_.getSelectableItems(this.getItems())).not(this.getSelectedItems()).get();if(!this.isOpen()){return e.filter(function(e){return!e.isA("sap.ui.core.SeparatorItem")})}return e};R.prototype._getUnselectedItemsPerTerm=function(e){var t=jQuery(_.getSelectableItems(this.getItems())).not(this.getSelectedItems()).get();var i=[];var s=this.fnFilter?this.fnFilter:v;if(!this.isOpen()){t=t.filter(function(e){return!e.isA("sap.ui.core.SeparatorItem")})}t.forEach(function(t){if(s(e,t)){i.push(t)}},this);return i};R.prototype.getSelectedItems=function(){var e=[],t=this.getAssociation("selectedItems")||[];t.forEach(function(t){var i=l.getElementById(t);if(i){e.push(i)}},this);return e};R.prototype.getWidth=function(){return this.getProperty("width")||"100%"};R.prototype._updatePopoverBasedOnEditMode=function(e){var t=this._getList(),i=this._getSuggestionsPopover();if(t&&e!==this._bPrevEditable&&e){i.addContent(t)}this._bPrevEditable=e};R.prototype._mapItemToListItem=function(e){var t,i,s,n=this.getRenderer();if(!e){return null}t=_.createListItemFromCoreItem(e,this.getShowSecondaryValues());this._decorateListItem(t);if(e.isA("sap.ui.core.SeparatorItem")){return t}i=n.CSS_CLASS_MULTICOMBOBOX+"Item";s=this.isItemSelected(e)?i+"Selected":"";t.addStyleClass(i+" "+s);this.setSelectable(e,e.getEnabled());return t};R.prototype.setSelectable=function(e,i){t.prototype.setSelectable.call(this,e,i);var s=C(e);if(s){s.setVisible(i)}};R.prototype._fillList=function(){var e;var t;var i;var n=this._getList();var o=this.getEditable()?this.getItems():this.getSelectedItems();if(!n){return}n.destroyItems();for(var r=0,a,l=o.length;r<l;r++){a=this._mapItemToListItem(o[r]);if(a.isA("sap.m.GroupHeaderListItem")){this._getList().addItemGroup(null,a)}else{this._getList().addItem(a)}if(this.isItemSelected(o[r])){this._getList().setSelectedItem(a,true)}}e=this.getAggregation("tokenizer");t=this.getSelectedItems();for(var h=0;h<t.length;h++){i=t[h];var u=new s({key:i.getKey(),text:i.getText()});i.data(_.CSS_CLASS+"Token",u);e.addToken(u,true)}};R.prototype.handleInputValidation=function(e,t){var i=e.target.value,s=this.isValueValid(i),n,o,r;var a=e.srcControl;if(!s&&i!==""&&!t){this._handleFieldValidationState(a);return}r=this._getItemsStartingWith(i,true);if(!t||this._bIsPasteEvent){this._handleTypeAhead(i,r,a)}n=this.getItems();if(this.isPickerDialog()){o=this.getFilterSelectedButton();if(o!=null&&o.getPressed()){o.setPressed(false)}}T(this.getItems(),this.filterItems({value:i,items:n}));this.manageSelectAllCheckBoxState();this._sOldInput=i;if((!this.getValue()||!s)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close()}else{this.open()}};R.prototype.isValueValid=function(e){var t=this._getItemsStartingWith(e,true);var i=this._getItemsStartingWithPerTerm(e,true);return t.length||i.length};R.prototype._handleTypeAhead=function(e,t,i){var s,n;if(!this._bDoTypeAhead){return}s=this.getSelectedItems();n=t.filter(function(e){return s.indexOf(e)===-1});S(e,i,n)};R.prototype._handleFieldValidationState=function(e){if(this._sOldInput&&this.isValueValid(this._sOldInput)){e.updateDomValue(this._sOldInput)}else if(this._sOldValue&&this.isValueValid(this._sOldValue)){e.updateDomValue(this._sOldValue)}else{e.updateDomValue("");e.setProperty("effectiveShowClearIcon",false)}if(this._iOldCursorPos){jQuery(e.getFocusDomRef()).cursorPos(this._iOldCursorPos)}this._showWrongValueVisualEffect()};R.prototype.init=function(){t.prototype.init.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=false;this._bListItemNavigationInvalidated=false;this._iInitialItemFocus=-1;this._bCheckBoxClicked=true;this._bPreventValueRemove=false;this._oTokenizer=this._createTokenizer();this._oTokenizer.onfocusfail=function(){};this.setAggregation("tokenizer",this._oTokenizer);this._aInitiallySelectedItems=[];this._oRbC=c.getResourceBundleFor("sap.ui.core");this._fillList()};R.prototype.handleItemRemoval=function(e){this.removeSelection({item:e,id:e?e.getId():"",key:e?e.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true})};R.prototype.isItemSelected=function(e){return this.getSelectedItems().indexOf(e)>-1};R.prototype._clearTokenizer=function(){this.getAggregation("tokenizer").destroyTokens()};R.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._deregisterResizeHandler();if(this._oTokenizer){this._oTokenizer.destroy();this._oTokenizer=null}this._oRbC=null;this.oValueStateNavDelegate=null;this._sInitialValueState=null};R.prototype.destroyItems=function(){this.setProperty("selectedKeys",[]);this._clearTokenizer();return this.destroyAggregation("items")};R.prototype._getItemByToken=function(e){return _.getItemBy(this.getItems(),e,"Token")};R.prototype._getItemByValue=function(e){var t=_.getSelectableItems(this.getItems());for(var i=0;i<t.length;i++){if(t[i].getText().toLowerCase()===e.toLowerCase()){return t[i]}}};R.prototype._handleItemToFocus=function(){if(this.isOpen()){return}this.syncPickerContent();var e,t,i=l.getElementById(document.activeElement.id),s=this.getSelectedItems(),n=_.getSelectableItems(this.getItems()),o=this._getList(),r=o&&o.getItemNavigation(),a=this.getValue(),h=this.getPicker();if(i&&i.isA("sap.m.Token")){t=this._getItemByToken(i)}else if(a){t=this._getItemByValue(a)}if(!t){t=s.length?_.getItemByListItem(this.getItems(),this._getList().getSelectedItems()[0]):n[0]}e=_.getVisibleItems(this.getItems()).indexOf(t);if(r){r.setSelectedIndex(e)}else{this._bListItemNavigationInvalidated=true;this._iInitialItemFocus=e}if(!t){h.setInitialFocus(this)}else{h.setInitialFocus(o)}};R.prototype.getAccessibilityInfo=function(){var e=this.getSelectedItems().map(function(e){return e.getText()}).join(" ");var i=t.prototype.getAccessibilityInfo.apply(this,arguments);i.type=c.getResourceBundleFor("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");i.description=(this.getValueDescriptionInfo()+" "+e).trim();return i};R.prototype.getValueDescriptionInfo=function(){if(this.getValue()){return this.getValue()}return this._hasTokens()?"":c.getResourceBundleFor("sap.m").getText("INPUTBASE_VALUE_EMPTY")};R.prototype._setIsClick=function(e){this._bIsClick=e};R.prototype._getIsClick=function(){return this._bIsClick};R.prototype._calculateSpaceForTokenizer=function(){if(this.getDomRef()){var e,t=this.getDomRef().getBoundingClientRect().width,i=this._calculateIconsSpace(),s=this.$().find(".sapMInputBaseInner"),n=["min-width","padding-right","padding-left"],o=n.reduce(function(e,t){return e+(parseInt(s.css(t))||0)},0);e=t-(i+o);e=e<0?0:e;return e+"px"}else{return null}};R.prototype._syncInputWidth=function(e){var t=this.getDomRef("inner"),i,s;if(!t||e&&!e.getDomRef()){return}s=parseFloat(e.getDomRef().getBoundingClientRect().width.toFixed(2));i=this._calculateIconsSpace();t.style.width="calc(100% - "+parseFloat(i+s)+"px)"};R.prototype._handleNMoreAccessibility=function(){var e=O.getStaticId("sap.m","MULTICOMBOBOX_OPEN_NMORE_POPOVER"),t=this.getAggregation("tokenizer"),i=this.getFocusDomRef(),s=i&&i.getAttribute("aria-describedby"),n=s?s.split(" "):[],o=n.indexOf(e),r=this.getEnabled(),a=!this.getEditable()&&t&&t.getHiddenTokensCount();if(a&&o===-1){n.push(e);r&&this.getFocusDomRef().setAttribute("aria-keyshortcuts","Enter")}else if(o!==-1&&!a){n.splice(o,1);this.getFocusDomRef().removeAttribute("aria-keyshortcuts")}if(i&&n.length){i.setAttribute("aria-describedby",n.join(" ").trim())}};R.prototype.applyShowItemsFilters=function(){this.syncPickerContent();T(this.getItems(),this.filterItems({value:this.getValue()||"_",items:this.getItems()}));this.manageSelectAllCheckBoxState()};R.prototype.showItems=function(e){var i=true,s=this.fnFilter;if(typeof e==="function"){this.syncPickerContent();this.setFilterFunction(e||function(){return true});i=this.filterItems({value:this.getValue()||"_",items:this.getItems()}).items.length>0;this.setFilterFunction(s)}if(i){t.prototype.showItems.apply(this,arguments)}};R.prototype.createSelectAllHeaderToolbar=function(e){e=e||this._getList();if(!e||e.getHeaderToolbar()){return}var t=new o({select:function(e){var t=e.getSource(),i=_.getSelectableItems(this.getItems()),s=this._getSelectedItemsOf(i);if(e.getParameter("selected")){var n=i.filter(function(e){return s.indexOf(e)===-1});n.forEach(function(e){this.setSelection({item:e,items:n,selectAll:true,id:e.getId(),key:e.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false})},this)}else{s.forEach(function(e){this.removeSelection({item:e,items:s,selectAll:true,id:e.getId(),key:e.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false})},this)}t.focus()}.bind(this)});t.addEventDelegate(this._selectAllDelegate(),this);e.setHeaderToolbar(new r({content:t}).addStyleClass("sapMMultiComboBoxSelectAll")).setSticky(["HeaderToolbar"]);this.attachSelectionChange(this.manageSelectAllCheckBoxState.bind(this))};R.prototype.manageSelectAllCheckBoxState=function(){var e=this.getSelectAllCheckbox();if(!e){return}var t=this.getItems(),i=this.getSelectedItems(),s=_.getSelectableItems(t).filter(function(e){return i.indexOf(e)>-1}).length===_.getSelectableItems(t).length;e.setText(this._oRb.getText("MULTICOMBOBOX_SELECT_ALL_CHECKBOX",[i.length,_.getAllSelectableItems(t).length])).setSelected(s)};R.prototype.getSelectAllToolbar=function(){var e=this._getList();return e&&e.getHeaderToolbar()};R.prototype.getSelectAllCheckbox=function(){var e=this.getSelectAllToolbar();return e&&e.getContent()[0]};R.prototype._selectAllDelegate=function(){return{onsapdown:this.handleDownEvent,onsapup:function(e){e.preventDefault();this.getFocusDomRef().focus()},onsaphome:this.handleHomeEvent,onsapend:this.handleEndEvent,onfocusin:function(){var e=this.getRenderer(),t=this.getSelectAllToolbar();t&&t.addStyleClass(e.CSS_CLASS_MULTICOMBOBOX+"SelectAllFocused")},onfocusout:function(){var e=this.getRenderer(),t=this.getSelectAllToolbar();t&&t.removeStyleClass(e.CSS_CLASS_MULTICOMBOBOX+"SelectAllFocused")},onsapshow:this.close,onsaphide:this.close}};R.prototype.focusSelectAll=function(){var e=this.getSelectAllCheckbox();e&&e.focus()};R.prototype.toggleSelectAllVisibility=function(e){var t=this.getSelectAllToolbar();if(t){t.setVisible(e);return}e&&this.createSelectAllHeaderToolbar()};R.prototype.handleClearIconPress=function(){if(!(this.getEnabled()&&this.getEditable())){return}if(this.getValue()!==""){this.setValue("");this._sOldInput="";this.bOpenedByKeyboardOrButton?this.clearFilter():this.close();this.setProperty("effectiveShowClearIcon",false)}};R.prototype.getFormFormattedValue=function(){return this.getSelectedItems().map(function(e){return e.getText()}).join(", ")};R.prototype.getFormObservingProperties=function(){return["value","selectedKeys"]};return R});
//# sourceMappingURL=MultiComboBox.js.map