/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Input","./Tokenizer","./Token","./library","sap/ui/core/Element","sap/ui/core/EnabledPropagator","sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectMetadata","sap/ui/base/ManagedObjectObserver","sap/ui/core/Lib","sap/ui/core/ResizeHandler","sap/ui/core/IconPool","sap/ui/Device","./MultiInputRenderer","sap/ui/dom/containsOrEquals","sap/m/inputUtils/completeTextSelected","sap/ui/events/KeyCodes","sap/ui/core/InvisibleText","sap/ui/core/util/PasteHelper","sap/ui/dom/jquery/cursorPos"],function(e,t,i,o,n,s,r,a,g,l,p,u,h,d,f,c,k,T,y){"use strict";var v=o.TokenizerRenderMode;var _=e.extend("sap.m.MultiInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiInput.designtime",properties:{enableMultiLineMode:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:true},maxTokens:{type:"int",group:"Behavior"},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:true},_semanticFormValue:{type:"string",group:"Behavior",defaultValue:"",visibility:"hidden"}},aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}},deprecated:true},tokenUpdate:{allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}}},dnd:{draggable:false,droppable:true}},renderer:d});s.apply(_.prototype,[true]);var m=l.getResourceBundleFor("sap.m");_.prototype.init=function(){var i=this;this._bShowListWithTokens=false;e.prototype.init.call(this);this._getClearIcon();this._bIsValidating=false;var o=this._initTokenizer();o.updateTokens=function(){var e=i.getDomRef();if(e&&e.contains(document.activeElement)){i.bTokensUpdated=true}this.destroyTokens();this.updateAggregation("tokens")};o.onfocusfail=function(){if(i.bTokensUpdated){return undefined}else{return n.prototype.onfocusfail.apply(this,arguments)}};o.setShouldRenderTabIndex(false);this.setAggregation("tokenizer",o);o.afterPopupClose=this._onAfterCloseTokensPicker.bind(this);o.getTokensPopup().attachBeforeOpen(this._onBeforeOpenTokensPicker.bind(this))._getPopup().setExtraContent([o,this]);o.getTokensPopup().addEventDelegate({onAfterRendering:function(){var e=this.getDomRef().getBoundingClientRect().width;var t=getComputedStyle(this.getDomRef()).getPropertyValue("--sPopoverMaxWidth");if(e<=parseInt(t)&&!h.system.phone){o.getTokensPopup().getDomRef().style.setProperty("max-width","40rem")}else{o.getTokensPopup().getDomRef().style.setProperty("max-width",e+"px")}o.getTokensPopup().getDomRef().style.setProperty("min-width",e+"px");o.getTokensPopup().setContentWidth(e+"px")}},this);this.setAggregation("tokenizer",o);this._oTokenizerObserver=new g(function(e){var i=e.mutation;var o=e.child;switch(i){case"insert":o.attachEvent("_change",this.invalidate,this);this.fireTokenChange({type:t.TokenChangeType.Added,token:o,tokens:[o],removedTokens:[]});break;case"remove":var n=e.object.getTokens().length?t.TokenChangeType.Removed:t.TokenChangeType.RemovedAll;o.detachEvent("_change",this.invalidate,this);this.fireTokenChange({type:n,token:o,removedTokens:[o]});break;default:break}this.updateFormValueProperty();this.invalidate()}.bind(this));this._oTokenizerObserver.observe(o,{aggregations:["tokens"]});this._bShowListWithTokens=false;this._bIsValidating=false;o.addEventDelegate({onThemeChanged:this._handleInnerVisibility.bind(this),onAfterRendering:function(){var e=this.getEditable()&&document.activeElement===this.getDomRef("inner");if(this.isMobileDevice()&&this.getEditable()){o.addStyleClass("sapMTokenizerIndicatorDisabled")}else{o.removeStyleClass("sapMTokenizerIndicatorDisabled")}this._syncInputWidth(o);if(this.getEditable()){o.addStyleClass("sapMTokenizerIndicatorDisabled")}else{o.removeStyleClass("sapMTokenizerIndicatorDisabled")}if(this.getTokens().length){this._handleInnerVisibility();this._handleNMoreAccessibility();this._registerTokenizerResizeHandler()}if(!this.isMobileDevice()&&!this._getIsSuggestionPopupOpen()&&e){o.scrollToEnd()}}.bind(this)},this);this._aTokenValidators=[];this.setShowValueHelp(true);this._getSuggestionsPopover().getPopover().attachBeforeOpen(function(){if(i.isMobileDevice()!==true){return}var e=o._getTokensList();o._fillTokensList(e);this.addContent(e);i._manageListsVisibility(!!o.getTokens().length)}).attachAfterOpen(function(){var e=i.getTokens().length?m.getText("MULTIINPUT_NAVIGATION_POPUP_AND_TOKENS"):m.getText("MULTIINPUT_NAVIGATION_POPUP");i._oInvisibleMessage.announce(e)});this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(this._onValueHelpRequested,this);this._getValueHelpIcon().setProperty("visible",true,true);this._onResize=this._onResize.bind(this)};_.prototype.exit=function(){this._deregisterResizeHandler();this._deregisterTokenizerResizeHandler();this._oTokenizerObserver.disconnect();this._oTokenizerObserver.destroy();this._oTokenizerObserver=null;e.prototype.exit.call(this)};_.prototype.onAfterRendering=function(){var t=this.getAggregation("tokenizer");this._bTokenIsValidated=false;t.setMaxWidth(this._calculateSpaceForTokenizer());this._registerResizeHandler();e.prototype.onAfterRendering.apply(this,arguments);if(this.bTokensUpdated&&this.bDeletePressed){var i=t.getTokens();if(i[this.iFocusedIndexBeforeUpdate]){i[this.iFocusedIndexBeforeUpdate].focus()}else{this.focus()}}this.bTokensUpdated=false};_.prototype._initTokenizer=function(){return new t({renderMode:v.Narrow,tokenDelete:this._tokenDelete.bind(this)})};_.prototype._tokenDelete=function(e){if(!this.getEditable()||!this.getEnabled()){return}this._deleteTokens(e.getParameter("tokens"),e.getParameters())};_.prototype._deleteTokens=function(e,i){var o=this.getAggregation("tokenizer");var n=0;var s=i.keyCode===k.BACKSPACE;var r=e[e.length-1];var a=e[0];n=this.getTokens().indexOf(s?a:r);this.iFocusedIndexBeforeUpdate=n;this.bDeletePressed=!s;o.focusToken(n,i,function(){this.focus()}.bind(this));this.fireTokenUpdate({type:t.TokenUpdateType.Removed,addedTokens:[],removedTokens:e});e.filter(function(e){return this.getEditable()&&this.getEnabled()&&e.getEditable()}.bind(this)).forEach(function(e){e.destroy()});if(this.getTokens().length===0){o.getTokensPopup().close()}if(!i.keyCode){this.focus()}};_.prototype._handleInnerVisibility=function(){var e=!!this.getAggregation("tokenizer").getHiddenTokensCount();this._setValueVisible(!e)};_.prototype.oninput=function(t){this.setProperty("selectedKey","",true);e.prototype.oninput.call(this,t);if(t.isMarked("invalid")||!this.getEditable()){return}this._setValueVisible(true);this._manageListsVisibility(false);this.getAggregation("tokenizer").getTokensPopup().close()};_.prototype._registerResizeHandler=function(){if(!this._iResizeHandlerId){this._iResizeHandlerId=p.register(this,this._onResize)}};_.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){p.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null}};_.prototype._registerTokenizerResizeHandler=function(){if(!this._iTokenizerResizeHandler){this._iTokenizerResizeHandler=p.register(this.getAggregation("tokenizer"),this._onResize)}};_.prototype._deregisterTokenizerResizeHandler=function(){if(this._iTokenizerResizeHandler){p.deregister(this._iTokenizerResizeHandler);this._iTokenizerResizeHandler=null}};_.prototype._onResize=function(){this.getAggregation("tokenizer").setMaxWidth(this._calculateSpaceForTokenizer())};_.prototype._onSuggestionItemSelected=function(e){var t=this.getAggregation("tokenizer"),o=null,n=null,s=t.getTokens().length;if(this.getMaxTokens()&&s>=this.getMaxTokens()||this._bValueHelpOpen){return}if(this._hasTabularSuggestions()){o=e.getParameter("selectedRow")}else{o=e.getParameter("selectedItem");if(o){n=new i({text:r.escapeSettingsValue(o.getText()),key:r.escapeSettingsValue(o.getKey())})}}if(o&&!this._bTokenIsAdded){var a=this.getValue();this.addValidateToken({text:a,token:n,suggestionObject:o,validationCallback:this._validationCallback.bind(this,s)})}if(this.isMobileDevice()){var g=t.getTokens().length;if(s<g){this.setValue("")}if(this._getSuggestionsList().isA("sap.m.Table")){this._getSuggestionsList().addStyleClass("sapMInputSuggestionTableHidden")}else{this._getSuggestionsList().destroyItems()}var l=this.getAggregation("tokenizer").getScrollDelegate();if(l){l.scrollTo(0,0,0)}this._getSuggestionsPopover().getInput().focus()}this._bTokenIsAdded=false};_.prototype._onValueHelpRequested=function(){this._bValueHelpOpen=true};_.prototype._onLiveChange=function(e){var i=this.getAggregation("tokenizer").getTokens();var o=i.length>0&&i.every(e=>e.getSelected());if(!o){return}this.fireTokenUpdate({type:t.TokenUpdateType.Removed,addedTokens:[],removedTokens:i});this.removeAllTokens()};_.prototype._setValueVisible=function(e){var t=e?"1":"0";this.$("inner").css("opacity",t)};_.prototype.onmousedown=function(e){if(e.target==this.getDomRef("content")){e.preventDefault();e.stopPropagation()}};_.prototype.openMultiLine=function(){};_.prototype.closeMultiLine=function(){};_.prototype.showItems=function(){e.prototype.showItems.apply(this,arguments);this._manageListsVisibility(false)};_.prototype.onBeforeRendering=function(){var t=this.getAggregation("tokenizer");var i=t._getTokensList();e.prototype.onBeforeRendering.apply(this,arguments);this._hideTokensOverLimit();t.setEnabled(this.getEnabled());t._fillTokensList(i)};_.prototype._hideTokensOverLimit=function(){if(!this.getMaxTokens()){return}this.getTokens().forEach(function(e,t){if(t>=this.getMaxTokens()){return e.setVisible(false)}return e.setVisible(true)},this)};_.prototype.onsapnext=function(e){var t=this.getAggregation("tokenizer");if(e.isMarked()){return}var i=n.closestTo(document.activeElement);if(!i){return}if(t===i||t.$().find(i.$()).length>0){t.scrollToEnd();this.$().find("input").trigger("focus")}};_.prototype.onsapbackspace=function(e){var t=this.getValue();var i=this.getFocusDomRef()===document.activeElement;var o=this.getTokens();var n=o[o.length-1];if(!this.getEnabled()||!this.getEditable()){e.preventDefault();return}if(t===""&&i&&n&&e.srcControl===this){var s=o.filter(function(e){return e.getSelected()}).length===o.length;if(s){return this._deleteTokens(o,{keyCode:k.BACKSPACE})}n.focus();e.preventDefault()}};_.prototype.onsapdelete=function(e){if(!this.getEditable()){return}if(this.getValue()&&!c(this.getFocusDomRef())){return}if(e.isMarked("forwardFocusToParent")){this.focus()}};_.prototype.onsapright=function(e){const t=this.getAggregation("tokenizer").getTokens();if(!t.length){return}if(e.isMarked("forwardFocusToParent")){e.preventDefault()}};_.prototype.onkeydown=function(t){var i=this.getAggregation("tokenizer");e.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()){return}if(t.which===k.TAB){i.selectAllTokens(false)}if((t.ctrlKey||t.metaKey)&&t.which===k.A&&i.getTokens().length>0){i.focus();i.selectAllTokens(true);t.preventDefault()}if((t.ctrlKey||t.metaKey)&&(t.which===k.C||t.which===k.INSERT)){i._copy()}if((t.ctrlKey||t.metaKey)&&t.which===k.X||t.shiftKey&&t.which===k.DELETE){if(this.getEditable()){i._cut()}else{i._copy()}}if((t.ctrlKey||t.metaKey)&&t.which===k.I&&i.getTokens().length){i._togglePopup(i.getTokensPopup(),this.getDomRef());t.preventDefault()}};_.prototype.onpaste=function(e){var i,o,n,s,r=[];if(this.getValueHelpOnly()){return}i=e.originalEvent.clipboardData.getData("text/plain");if(i.length&&i.endsWith("\r\n")){i=i.substring(0,i.lastIndexOf("\r\n"))}n=i.split(/\r\n|\r|\n|\t/g);s=y.getPastedDataAs2DArray(e.originalEvent);if(n.length<=1){return}const a=this.getMaxTokens();if(a){n=n.slice(0,a)}setTimeout(function(){if(n){if(this.fireEvent("_validateOnPaste",{texts:n,textRows:s},true)){var e="";for(o=0;o<n.length;o++){if(n[o]){var i=this._convertTextToToken(n[o],true);if(this._addUniqueToken(i)){r.push(i)}else{e=n[o]}}}this.updateDomValue(e);if(r.length>0){this.fireTokenUpdate({addedTokens:r,removedTokens:[],type:t.TokenUpdateType.Added});this.fireTokenChange({addedTokens:r,removedTokens:[],type:t.TokenChangeType.TokensChanged})}}if(r.length){this.cancelPendingSuggest()}}}.bind(this),0)};_.prototype._validationCallback=function(e,t){var i=this.getAggregation("tokenizer").getTokens().length;var o=this._getSuggestionsPopover();this._bIsValidating=false;if(t){this.setValue("");this._bTokenIsValidated=true;if(this.isMobileDevice()&&o&&o.getInput()&&e<i){o.getInput().setValue("")}}};_.prototype.onsapprevious=function(e){if(this._getIsSuggestionPopupOpen()){return}if(this._$input.cursorPos()===0){if(e.srcControl===this){t.prototype.onsapprevious.apply(this.getAggregation("tokenizer"),arguments)}}if(e.keyCode===k.ARROW_UP){e.preventDefault()}};_.prototype.onsaphome=function(i){if(!this.getFocusDomRef().selectionStart){t.prototype.onsaphome.apply(this.getAggregation("tokenizer"),arguments)}e.prototype.onsaphome.apply(this,arguments)};_.prototype.onsapend=function(t){if(t.isMarked("forwardFocusToParent")){this.focus()}e.prototype.onsapend.apply(this,arguments)};_.prototype.onsapenter=function(t){var i=this.getDOMValue(),o=this._getSuggestionsPopover(),n=o&&o.getFocusedListItem();e.prototype.onsapenter.apply(this,arguments);if(n&&n.isA("sap.m.GroupHeaderListItem")){return}var s=true,r=this.getAggregation("tokenizer");if(this._getIsSuggestionPopupOpen()){if(this._hasTabularSuggestions()){s=!this._getSuggestionsTable().getSelectedItem()}else{s=!this._getSuggestionsList().getSelectedItem()}}if(s&&!this.isComposingCharacter()){this._validateCurrentText()}if(t&&t.setMarked&&(this._bTokenIsValidated||i)){t.setMarked()}if(!this.getEditable()&&r.getHiddenTokensCount()&&t.target===this.getFocusDomRef()){r._togglePopup(r.getTokensPopup(),this.getDomRef())}if(!f(r.getFocusDomRef(),document.activeElement)){this.focus()}};_.prototype.onsapfocusleave=function(t){var i=this._getSuggestionsPopoverPopup(),o=this.getAggregation("tokenizer"),s=o.getTokensPopup(),r=false,a=false,g=this.getDomRef()&&f(this.getDomRef(),document.activeElement),l,p,u;if(i&&i.isA("sap.m.Popover")){if(t.relatedControlId){p=n.getElementById(t.relatedControlId).getFocusDomRef();r=f(i.getFocusDomRef(),p);a=f(o.getFocusDomRef(),p);if(s){u=f(s.getFocusDomRef(),p)}}}e.prototype.onsapfocusleave.apply(this,arguments);if(this._bIsValidating||this._bValueHelpOpen){return}l=!r&&t.relatedControlId!==this.getId()&&!a;if(l&&(this.isMobileDevice()&&!this.getShowSuggestion()||!this.isMobileDevice())){this._validateCurrentText(true)}if(!this.isMobileDevice()&&this.getEditable()){if(g||r){return}}if(!u&&!a){s.isOpen()&&!this.isMobileDevice()&&o._togglePopup(s,this.getDomRef());o.setRenderMode(v.Narrow)}this._handleInnerVisibility()};_.prototype.ontap=function(t){const i=this.getAggregation("tokenizer");const o=t.target?.className&&t.target.className.indexOf("sapMTokenizerIndicator")>-1;if(o){this._handleNMoreIndicatorPress()}if(document.activeElement===this._$input[0]||document.activeElement===i.getDomRef()){i.selectAllTokens(false)}if(t&&t.isMarked("tokenDeletePress")){return}e.prototype.ontap.apply(this,arguments)};_.prototype.onfocusin=function(t){var i=this.getAggregation("tokenizer");this._deregisterTokenizerResizeHandler();this._bValueHelpOpen=false;if(t.target===this.getFocusDomRef()){e.prototype.onfocusin.apply(this,arguments);if(i.hasOneTruncatedToken()&&this.getEnabled()&&this.getEditable()){i.getTokens()[0].setSelected(false);!this.isMobileDevice()&&i.setFirstTokenTruncated(false)}}if(!this.isMobileDevice()&&this.getEditable()&&t.target===this.getDomRef("inner")&&!this._getIsSuggestionPopupOpen()){i.setRenderMode(v.Loose);this._setValueVisible(true)}this._registerResizeHandler()};_.prototype.onsapescape=function(t){var i=this.getAggregation("tokenizer"),o=i.getTokensPopup();this.getAggregation("tokenizer").selectAllTokens(false);this.selectText(0,0);if(o.isOpen()){i._togglePopup(o,this.getDomRef())}e.prototype.onsapescape.apply(this,arguments)};_.prototype._getIsSuggestionPopupOpen=function(){var e=this._getSuggestionsPopover(),t=this._getSuggestionsPopoverPopup();return e&&t&&t.isOpen()};_.prototype.setEditable=function(t){var i=this.getAggregation("tokenizer");t=this.validateProperty("editable",t);if(t===this.getEditable()){return this}if(e.prototype.setEditable){e.prototype.setEditable.apply(this,arguments)}i.setEditable(t);return this};_.prototype._findItem=function(e,t,i,o){if(!e){return}if(!(t&&t.length)){return}e=e.toLowerCase();var n=t.length;for(var s=0;s<n;s++){var r=t[s];var a=o(r);if(!a){continue}a=a.toLowerCase();if(a===e){return r}if(!i&&a.indexOf(e)===0){return r}}};_.prototype._getSuggestionItem=function(e,t){var i=null;var o=null;if(this._hasTabularSuggestions()){i=this.getSuggestionRows();o=this._findItem(e,i,t,function(e){var t=e.getCells();var i=null;if(t){var o;for(o=0;o<t.length;o++){if(t[o].getText){i=t[o].getText();break}}}return i})}else{i=this.getSuggestionItems();o=this._findItem(e,i,t,function(e){return e.getText()})}return o};_.prototype.clone=function(){var t;this.detachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.detachLiveChange(this._onLiveChange,this);this.detachValueHelpRequest(this._onValueHelpRequested,this);t=e.prototype.clone.apply(this,arguments);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(this._onValueHelpRequested,this);return t};_.getMetadata().forwardAggregation("tokens",{getter:function(){return this.getAggregation("tokenizer")},aggregation:"tokens",forwardBinding:true});_.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("content")};_.prototype.setTokens=function(e){if(!Array.isArray(e)){return}this.removeAllTokens();e.forEach(function(e){a.addAPIParentInfoBegin(e,this,"tokens")},this);e.forEach(function(e){this.addToken(e)},this);e.forEach(function(e){a.addAPIParentInfoEnd(e)},this);this.fireTokenChange({type:t.TokenChangeType.TokensChanged,addedTokens:e,removedTokens:[]});return this};_.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};_.prototype.getWaitForAsyncValidation=function(){return _.WaitForAsyncValidation};_.WaitForAsyncValidation="sap.m.MultiInput.WaitForAsyncValidation";_.prototype.getDomRefForValueStateMessage=_.prototype.getPopupAnchorDomRef;_.prototype.updateInputField=function(t){e.prototype.updateInputField.call(this,t);if(this.isMobileDevice()){this.updateInputFieldOnMobile()}else{this.updateInputFieldOnDesktop(t)}};_.prototype.updateInputFieldOnMobile=function(){var e=this._getSuggestionsPopover();if(e.getInput()){e.getInput().setDOMValue("")}};_.prototype.updateInputFieldOnDesktop=function(e){e=this._getInputValue(e);this.setDOMValue("");this.onChange(null,null,e)};_.prototype.onChange=function(e,t,i){t=t||this.getChangeEventParams();if(!this.getEditable()||!this.getEnabled()){return}var o=this._getInputValue(i);if(o===this.getLastValue()){this._bCheckDomValue=false;return}if(!this._bTokenIsValidated){this.setValue(o);o=this.getValue();this.setLastValue(o)}this.fireChangeEvent(o,t);return true};_.prototype.getAccessibilityInfo=function(){var t=this.getTokens().map(function(e){return e.getText()}).join(" ");var i=e.prototype.getAccessibilityInfo.apply(this,arguments);i.type=m.getText("ACC_CTR_TYPE_MULTIINPUT");i.description=(this.getValueDescriptionInfo()+" "+t).trim();return i};_.prototype.getValueDescriptionInfo=function(){var e=this.getTokens().length;var t=this.getDescription()||"";var i=this.getValue();if(i){return i}if(e>0){return t}else{return t?t:l.getResourceBundleFor("sap.m").getText("INPUTBASE_VALUE_EMPTY")}};_.prototype._decoratePopupInput=function(t){e.prototype._decoratePopupInput.apply(this,arguments);if(!t){return}if(!this._oPopupInputDelegate){this._oPopupInputDelegate={oninput:this._manageListsVisibility.bind(this,false),onsapenter:this._handleConfirmation.bind(this,false)}}t.addEventDelegate(this._oPopupInputDelegate,this);return t};_.prototype._hasShowSelectedButton=function(){return true};_.prototype.forwardEventHandlersToSuggPopover=function(e){e.setShowSelectedPressHandler(this._handleShowSelectedPress.bind(this));e.setOkPressHandler(this._handleConfirmation.bind(this,true));e.setCancelPressHandler(this._revertPopupSelection.bind(this))};_.prototype._handleConfirmation=function(e,t){var i=this._getSuggestionsPopover().getInput();if(e||!e&&i.getValue()){this._closeSuggestionPopup()}this._validateCurrentText();this._setValueVisible(false);this.onChange(t,null,i.getValue())};_.prototype._handleShowSelectedPress=function(e){this._bShowListWithTokens=e.getSource().getPressed();this._manageListsVisibility(this._bShowListWithTokens)};_.prototype._onBeforeOpenTokensPicker=function(){this._setValueVisible(false);this._manageListsVisibility(true)};_.prototype._onAfterCloseTokensPicker=function(){var e=this.getAggregation("tokenizer");if(document.activeElement!==this.getDomRef("inner")&&!e.checkFocus()){e.setRenderMode(v.Narrow)}};_.prototype.getDialogTitle=function(){var e=this._getSuggestionsPopoverPopup(),t=e&&e.getCustomHeader();if(t){return t.getContentMiddle()[0]}return null};_.prototype._updatePickerHeaderTitle=function(){var e,t;t=this.getLabels();if(t.length){e=t[0];if(e&&typeof e.getText==="function"){this.getDialogTitle().setText(e.getText())}}else{this.getDialogTitle().setText(m.getText("COMBOBOX_PICKER_TITLE"))}};_.prototype._getSuggestionsList=function(){var e=this._getSuggestionsPopover();return e&&e.getItemsContainer()};_.prototype._getSuggestionsPopoverPopup=function(){return this._oSuggestionPopup};_.prototype._manageListsVisibility=function(e){if(!this.isMobileDevice()){return}this.getAggregation("tokenizer")._getTokensList().setVisible(e);this._getSuggestionsList()&&this._getSuggestionsList().setVisible(!e);this._getSuggestionsPopover().getFilterSelectedButton().setPressed(e)};_.prototype._handleNMoreAccessibility=function(){var e=T.getStaticId("sap.m","MULTICOMBOBOX_OPEN_NMORE_POPOVER"),t=this.getFocusDomRef(),i=t&&t.getAttribute("aria-describedby"),o=i?i.split(" "):[],n=o.indexOf(e),s=this.getEnabled(),r=!this.getEditable()&&this.getAggregation("tokenizer").getHiddenTokensCount();if(r&&n===-1){o.push(e);s&&this.getFocusDomRef().setAttribute("aria-keyshortcuts","Enter")}else if(n!==-1&&!r){o.splice(n,1);this.getFocusDomRef().removeAttribute("aria-keyshortcuts")}if(t&&o.length){t.setAttribute("aria-describedby",o.join(" ").trim())}};_.prototype._handleNMoreIndicatorPress=function(){const e=this.getAggregation("tokenizer");e._bIsOpenedByNMoreIndicator=true;e._togglePopup(e.getTokensPopup(),this.getDomRef())};_.prototype.shouldSuggetionsPopoverOpenOnMobile=function(e){var t=this.getAggregation("tokenizer");return this.isMobileDevice()&&this.getEditable()&&this.getEnabled()&&(this.getShowSuggestion()||t.getHiddenTokensCount()||t.hasOneTruncatedToken())&&!this._bClearButtonPressed&&e.target.id!==this.getId()+"-vhi"};_.prototype._calculateSpaceForTokenizer=function(){var e=this.getDomRef();if(e){var t,i=this.$().find(".sapMInputDescriptionWrapper"),o=this.$().find(".sapMInputBaseInner"),n=e.offsetWidth||0,s=i.width()||0,r=this._calculateIconsSpace(),a=["min-width","padding-right","padding-left"],g=a.reduce(function(e,t){return e+(parseInt(o.css(t))||0)},0);t=n-(r+g+s);t=t<0?0:t;return t+"px"}else{return null}};_.prototype._syncInputWidth=function(e){var t=this.getDomRef("inner"),i,o;if(!t||e&&!e.getDomRef()){return}i=this._calculateIconsSpace();o=e.getDomRef().scrollWidth;t.style.width="calc(100% - "+Math.floor(i+o)+"px"};_.prototype.isValueHelpOnlyOpener=function(e){return[this._$input[0],this._getValueHelpIcon().getDomRef()].indexOf(e)>-1};_.prototype._shouldTriggerSuggest=function(){var t=e.prototype._shouldTriggerSuggest.apply(this,arguments);return t&&!this._bShowListWithTokens};_.prototype.addValidator=function(e){if(typeof e==="function"){this._aTokenValidators.push(e)}};_.prototype.removeValidator=function(e){var t=this._aTokenValidators.indexOf(e);if(t!==-1){this._aTokenValidators.splice(t,1)}};_.prototype.removeAllValidators=function(){this._aTokenValidators=[]};_.prototype.getValidators=function(){return this._aTokenValidators};_.prototype.addValidateToken=function(e,i){var o=this._validateToken(e,i),n=this._addUniqueToken(o,e.validationCallback);if(n){this.fireTokenUpdate({addedTokens:[o],removedTokens:[],type:t.TokenUpdateType.Added});this.fireTokenChange({addedTokens:[o],removedTokens:[],type:t.TokenChangeType.TokensChanged})}};_.prototype._validateToken=function(e,t){var i=e.token,o=e.validationCallback,n=e.suggestionObject,s=i&&i.getText(),r=s?s:e.text,a;t=t?t:this._aTokenValidators;a=t.length;if(!a){if(!i&&o){o(false)}return i}for(var g=0;g<a;g++){i=t[g]({text:r,suggestedToken:i,suggestionObject:n,asyncCallback:this._getAsyncValidationCallback(t,g,r,n,o)});if(!i){if(o){o(false)}return null}if(i===this.getWaitForAsyncValidation()){return null}}return i};_.prototype._addUniqueToken=function(e,t){if(!e){return false}var i=!this._tokenExists(e);i&&this.addToken(e);if(t){t(i)}return i};_.prototype._tokenExists=function(e){var t=this.getTokens(),i=t.length,o=e&&e.getKey();if(!o){return false}for(var n=0;n<i;n++){if(t[n].getKey()===o){return true}}return false};_.prototype._convertTextToToken=function(e,t){var i=this.getAggregation("tokenizer"),o=i.getTokens().length,n=this._configureTokenOptions(e,false,t),s=n.text,r=n.item,a=n.token;if(!s){return null}return this._validateToken({text:s,token:a,suggestionObject:r,validationCallback:this._validationCallback.bind(this,o)})};_.prototype._validateCurrentText=function(e){var t=this.getAggregation("tokenizer"),i=t.getTokens().length,o=this._configureTokenOptions(this.getValue(),e),n=o.text,s=o.item,a=o.token;if(!n){return null}if(s){this._bTokenIsAdded=true}if(!this.getMaxTokens()||this.getTokens().length<this.getMaxTokens()){this._bIsValidating=true;this.addValidateToken({text:r.escapeSettingsValue(n),token:a,suggestionObject:s,validationCallback:this._validationCallback.bind(this,i)})}};_.prototype._configureTokenOptions=function(e,t,o){var n,s;if(e&&this.getEditable()){e=e.trim()}if(e&&(t||o||this._getIsSuggestionPopupOpen())){if(this._hasTabularSuggestions()){n=this._getSuggestionsTable().getSelectedItem()}else{n=this._getSuggestionItem(e,t)}}if(n&&n.getText&&n.getKey){s=new i({text:r.escapeSettingsValue(n.getText()),key:n.getKey()})}return{text:e,item:n,token:s}};_.prototype._getAsyncValidationCallback=function(e,t,i,o,n){var s=this;return function(r){if(r){r=s.addValidateToken({text:i,token:r,suggestionObject:o,validationCallback:n},e.slice(t+1))}else{n&&n(false)}}};_.prototype.getFormFormattedValue=function(){return this.getTokens().map(function(e){return e.getText()}).join(", ")};_.prototype.getFormValueProperty=function(){return"_semanticFormValue"};_.prototype.getFormObservingProperties=function(){return["_semanticFormValue"]};_.prototype.updateFormValueProperty=function(){this.setProperty("_semanticFormValue",this.getFormFormattedValue(),true)};return _});
//# sourceMappingURL=MultiInput.js.map