/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/core/ControlBehavior","sap/ui/core/Element","sap/ui/core/RenderManager","./NavContainerRenderer","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/dom/jquery/Focusable"],function(e,t,i,a,n,s,o,jQuery,r){"use strict";var l=i.extend("sap.m.NavContainer",{metadata:{interfaces:["sap.ui.core.IPlaceholderSupport"],library:"sap.m",properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},visible:{type:"boolean",group:"Appearance",defaultValue:true},defaultTransitionName:{type:"string",group:"Appearance",defaultValue:"slide"}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{initialPage:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},navigationFinished:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}},renderer:o});var d={onAfterRendering:function(){if(this._placeholder){this._placeholder.show(this)}}};var p=function(e){var i=a.getAnimationMode(),n=i!==t.AnimationMode.none&&i!==t.AnimationMode.minimal;return n?e:0},g=function(e){return!!(e&&e.getParent())},h=function(e,t){if(g(e)){e.$().css({"-webkit-animation-direction":t,"animation-direction":t})}};l.TransitionDirection={BACK:"back",TO:"to"};l.prototype.init=function(){this._pageStack=[];this._aQueue=[];this._mVisitedPages={};this._mFocusObject={};this._iTransitionsCompleted=0;this._bNeverRendered=true;this._bNavigating=false;this._bRenderingInProgress=false};l.prototype.exit=function(){this._mFocusObject=null;this._placeholder=undefined};l.prototype.onBeforeRendering=function(){var e=this.getCurrentPage();if(this._bNeverRendered&&e){var t=e.getId();if(!this._mVisitedPages[t]){this._mVisitedPages[t]=true;var i={from:null,fromId:null,to:e,toId:t,firstTime:true,isTo:false,isBack:false,isBackToPage:false,isBackToTop:false,direction:"initial"};var a=jQuery.Event("BeforeFirstShow",i);a.srcControl=this;a.data=this._oToDataBeforeRendering||{};a.backData={};e._handleEvent(a);a=jQuery.Event("BeforeShow",i);a.srcControl=this;a.data=this._oToDataBeforeRendering||{};a.backData={};e._handleEvent(a)}}};l.prototype.onAfterRendering=function(){var e=this.getCurrentPage(),t,i,a,n;if(this._bNeverRendered&&e){this._bNeverRendered=false;delete this._bNeverRendered;a=e.getId();if(!this._isInsideAPopup()&&this.getAutoFocus()){t=l._applyAutoFocusTo(a);if(t){this._mFocusObject[a]=t}}i={from:null,fromId:null,to:e,toId:a,firstTime:true,isTo:false,isBack:false,isBackToTop:false,isBackToPage:false,direction:"initial"};n=jQuery.Event("AfterShow",i);n.srcControl=this;n.data=this._oToDataBeforeRendering||{};n.backData={};e._handleEvent(n)}};l.prototype._getActualInitialPage=function(){var e=this.getInitialPage();if(e){var t=n.getElementById(e);if(t){return t}else{r.error("NavContainer: control with ID '"+e+"' was set as 'initialPage' but was not found as a DIRECT child of this NavContainer (number of current children: "+this.getPages().length+").")}}var i=this.getPages();return i.length>0?i[0]:null};l.prototype.getPage=function(e){var t=this.getPages();for(var i=0;i<t.length;i++){if(t[i]&&t[i].getId()==e){return t[i]}}return null};l.prototype._ensurePageStackInitialized=function(e){if(this._pageStack.length===0){var t=this._getActualInitialPage();if(t){this._pageStack.push({id:t.getId(),isInitial:true,data:e||{}})}}return this._pageStack};l.prototype.getCurrentPage=function(){var e=this._ensurePageStackInitialized();if(e.length>=1){return this.getPage(e[e.length-1].id)}else{r.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");return undefined}};l.prototype.getPreviousPage=function(){var e=this._ensurePageStackInitialized();if(e.length>1){return this.getPage(e[e.length-2].id)}else if(e.length==1){return undefined}else{r.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display")}};l.prototype.currentPageIsTopPage=function(){var e=this._ensurePageStackInitialized();return e.length===1};l.prototype.insertPreviousPage=function(e,t,i){var a=this._ensurePageStackInitialized();if(this._pageStack.length>0){var n=a.length-1;var s={id:e,transition:t,data:i};if(n===0){s.isInitial=true;delete a[a.length-1].isInitial}a.splice(n,0,s)}else{r.warning(this+": insertPreviousPage called with empty page stack; ignoring")}return this};l._applyAutoFocusTo=function(e){var t=jQuery(document.getElementById(e)).firstFocusableDomRef();if(t){t.focus()}return t};l.prototype._applyAutoFocus=function(e){var t=e.toId,i,a=e.isBack||e.isBackToPage||e.isBackToTop;if(!e.bFocusInsideFromPage){return}if(a){i=this._mFocusObject!=null?this._mFocusObject[t]:null;if(i){i.focus()}else{l._applyAutoFocusTo(t)}}else if(e.isTo){l._applyAutoFocusTo(t)}};l.prototype._afterNavigation=function(e,t,i){var a=jQuery.Event("AfterShow",e);a.data=t||{};a.backData=i||{};a.srcControl=this;e.to._handleEvent(a);a=jQuery.Event("AfterHide",e);a.srcControl=this;e.from._handleEvent(a);if(this.getAutoFocus()){this._applyAutoFocus(e)}this.enhancePagesAccessibility();this.fireNavigationFinished(e);this.fireAfterNavigate(e);this._dequeueNavigation()};l.prototype._afterTransitionCallback=function(e,t,i){this._iTransitionsCompleted++;this._bNavigating=false;this._afterNavigation(e,t,i);r.info(this+": _afterTransitionCallback called, to: "+e.toId);if(e.to.hasStyleClass("sapMNavItemHidden")){r.warning(this.toString()+": target page '"+e.toId+"' still has CSS class 'sapMNavItemHidden' after transition. This should not be the case, please check the preceding log statements.");e.to.removeStyleClass("sapMNavItemHidden")}};l.prototype.enhancePagesAccessibility=function(){var e=this.getCurrentPage();this.getPages().forEach(function(t){var i=t?.getFocusDomRef();if(e===t){i?.removeAttribute("aria-hidden")}else{i?.setAttribute("aria-hidden",true)}})};l.prototype._dequeueNavigation=function(){var e=this._aQueue.shift();if(typeof e==="function"){e()}};l.prototype._isInPageStack=function(e){return this._pageStack.some(function(t){return t.id===e})};l.prototype._safeBackToPage=function(e,t,i,a){var n;if(!this.getPage(e)){return this}n=this.getCurrentPage();if(n&&n.getId()===e){return this}if(this._isInPageStack(e)){return this.backToPage(e,i,a)}else{i=i||{};i.safeBackToPage=true;return this.to(e,t,i,a)}};l.prototype._isFocusInControl=function(e){return jQuery(document.activeElement).closest(e.$()).length>0};l.prototype.to=function(t,a,n,o,d){if(t instanceof i){t=t.getId()}if(typeof a!=="string"){o=n;n=a}a=a||this.getDefaultTransitionName();o=o||{};n=n||{};var g={id:t,transition:a,data:n};this._ensurePageStackInitialized(n);if(this._bNavigating){r.info(this.toString()+": Cannot navigate to page "+t+" because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(jQuery.proxy(function(){this.to(t,a,n,o,true)},this));return this}if(this._bNeverRendered){this._oToDataBeforeRendering=n}var h=this.getCurrentPage();if(h&&h.getId()===t){r.warning(this.toString()+": Cannot navigate to page "+t+" because this is the current page.");if(d){this._dequeueNavigation()}if(this._pageStack.length===1){this._pageStack[0].transition=g.transition}return this}var u=this.getPage(t);if(u){if(!h){r.warning("Navigation triggered to page with ID '"+t+"', but the current page is not known/aggregated by "+this);return this}var f={from:h,fromId:h.getId(),to:u,toId:t,firstTime:!this._mVisitedPages[t],isTo:true,isBack:false,isBackToTop:false,isBackToPage:false,direction:"to",bFocusInsideFromPage:this._isFocusInControl(h)};if(f.bFocusInsideFromPage){this._mFocusObject[h.getId()]=document.activeElement}var c=this.fireNavigate(f);if(c){e.closeKeyboard();var v=jQuery.Event("BeforeHide",f);v.srcControl=this;h._handleEvent(v);if(!this._mVisitedPages[t]){v=jQuery.Event("BeforeFirstShow",f);v.srcControl=this;v.data=n||{};v.backData={};u._handleEvent(v)}v=jQuery.Event("BeforeShow",f);v.srcControl=this;v.data=n||{};v.backData={};u._handleEvent(v);this._pageStack.push(g);r.info(this.toString()+": navigating to page '"+t+"': "+u.toString());this._mVisitedPages[t]=true;if(!this.getDomRef()){r.info("'Hidden' 'to' navigation in not-rendered NavContainer "+this.toString());this.fireNavigationFinished(f);if(this._bRenderingInProgress){setTimeout(this.invalidate.bind(this),0)}return this}var m;if(!(m=u.getDomRef())||m.parentNode!=this.getDomRef()||s.isPreservedContent(m)){u.addStyleClass("sapMNavItemRendering");r.debug("Rendering 'to' page '"+u.toString()+"' for 'to' navigation");var y=(new s).getInterface();y.render(u,this.getDomRef());y.destroy();u.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering")}var b=l.transitions[a]||l.transitions["slide"];var C=this._iTransitionsCompleted;var I=this;window.setTimeout(function(){if(I&&I._iTransitionsCompleted<C+1){r.warning("Transition '"+a+"' 'to' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.")}},p(5e3));this._bNavigating=true;var S=n.safeBackToPage||o.safeBackToPage?"back":"to";this._cacheTransitionInfo(a,S);b[S].call(this,h,u,jQuery.proxy(function(){this._afterTransitionCallback(f,n)},this),o)}else{r.info("Navigation to page with ID '"+t+"' has been aborted by the application")}}else{r.warning("Navigation triggered to page with ID '"+t+"', but this page is not known/aggregated by "+this)}return this};l.prototype.back=function(e,t){this._backTo("back",e,t);return this};l.prototype.backToPage=function(e,t,i){this._backTo("backToPage",t,i,e);return this};l.prototype.backToTop=function(e,t){this._backTo("backToTop",e,t);return this};l.prototype._backTo=function(t,a,o,d){if(this._bNavigating){r.warning(this.toString()+": Cannot navigate back because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(jQuery.proxy(function(){this._backTo(t,a,o,d)},this));return this}if(this._pageStack.length<=1){if(this._pageStack.length===1&&!this._pageStack[0].isInitial){throw new Error("Initial page not found on the stack. How did this happen?")}this._aQueue=[];return this}else{if(d instanceof i){d=d.getId()}var g=this._pageStack[this._pageStack.length-1];var h=g.transition;var u=this.getPage(g.id);var f;var c;if(t==="backToTop"){f=this._getActualInitialPage();c=null}else if(t==="backToPage"){var v=this._findClosestPreviousPageInfo(d);if(!v){r.error(this.toString()+": Cannot navigate backToPage('"+d+"') because target page was not found among the previous pages.");return this}f=n.getElementById(v.id);if(!f){r.error(this.toString()+": Cannot navigate backToPage('"+d+"') because target page does not exist anymore.");return this}c=v.data}else{f=this.getPreviousPage();c=this._pageStack[this._pageStack.length-2].data}if(!f){r.error("NavContainer back navigation: target page is not defined or not aggregated by this NavContainer. Aborting navigation.");return}var m=f.getId();a=a||{};o=o||{};var y={from:u,fromId:u.getId(),to:f,toId:m,firstTime:!this._mVisitedPages[m],isTo:false,isBack:t==="back",isBackToPage:t==="backToPage",isBackToTop:t==="backToTop",direction:t,bFocusInsideFromPage:this._isFocusInControl(u)};var b=this.fireNavigate(y);if(b){e.closeKeyboard();var C=jQuery.Event("BeforeHide",y);C.srcControl=this;u._handleEvent(C);if(!this._mVisitedPages[m]){C=jQuery.Event("BeforeFirstShow",y);C.srcControl=this;C.backData=a||{};C.data={};f._handleEvent(C)}C=jQuery.Event("BeforeShow",y);C.srcControl=this;C.backData=a||{};C.data=c||{};f._handleEvent(C);this._pageStack.pop();r.info(this.toString()+": navigating back to page "+f.toString());this._mVisitedPages[m]=true;if(t==="backToTop"){this._pageStack=[];r.info(this.toString()+": navigating back to top");this.getCurrentPage()}else if(t==="backToPage"){var I=[],S;while(this._pageStack[this._pageStack.length-1].id!==d){S=this._pageStack.pop();I.push(S.id)}r.info(this.toString()+": navigating back to specific page "+f.toString()+" across the pages: "+I.join(", "))}if(!this.getDomRef()){r.info("'Hidden' back navigation in not-rendered NavContainer "+this.toString());this._afterNavigation(y,c,a);return this}var _=l.transitions[h]||l.transitions["slide"];var T=this._iTransitionsCompleted;var k=this;window.setTimeout(function(){if(k&&k._iTransitionsCompleted<T+1){r.warning("Transition '"+h+"' 'back' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.")}},p(5e3));this._bNavigating=true;var N;if(!(N=f.getDomRef())||N.parentNode!=this.getDomRef()||s.isPreservedContent(N)){f.addStyleClass("sapMNavItemRendering");r.debug("Rendering 'to' page '"+f.toString()+"' for back navigation");var P=(new s).getInterface();var w=this.$().children().index(u.getDomRef());P.renderControl(f);P.flush(this.getDomRef(),false,w);P.destroy();f.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering")}if(u.getId()===f.getId()){r.info("Transition is skipped when navigating back to the same page instance"+f.toString());this._afterTransitionCallback(y,c,a);return this}this._cacheTransitionInfo(h,l.TransitionDirection.BACK);_.back.call(this,u,f,jQuery.proxy(function(){this._afterTransitionCallback(y,c,a)},this),o)}}return this};l.prototype._findClosestPreviousPageInfo=function(e){for(var t=this._pageStack.length-2;t>=0;t--){var i=this._pageStack[t];if(i.id===e){return i}}return null};l.prototype._cacheTransitionInfo=function(e,t){this._sTransitionName=e;this._sTransitionDirection=t};l.prototype._fadeTransition=function(e,t,i){this.oFromPage=e;this.oToPage=t;this.fCallback=i;this._fadeOutAnimation()};l.prototype._fadeOutAnimation=function(){var e=this,t=this.oFromPage,i=this.oToPage;i.addStyleClass("sapMNavItemTransparent");if(this._sTransitionName==="slide"){if(this._sTransitionDirection===l.TransitionDirection.TO){i.addStyleClass("sapMNavItemSlideLeft");t.addStyleClass("sapMNavItemSlideRight")}else{i.addStyleClass("sapMNavItemSlideRight");t.addStyleClass("sapMNavItemSlideLeft")}}i.removeStyleClass("sapMNavItemHidden");t.addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){t.$().on("webkitTransitionEnd transitionend",e._fadeOutAnimationEnd.bind(e));e.bTransition1EndPending=true;t.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque").addStyleClass("sapMNavItemTransparent");window.setTimeout(function(){if(e.bTransition1EndPending){e._fadeOutAnimationEnd()}},p(150))},p(10))};l.prototype._fadeOutAnimationEnd=function(e){var t=this.oFromPage;if(e&&e.originalEvent&&e.originalEvent.propertyName!=="opacity"){return}this.bTransition1EndPending=false;jQuery(t.$()).off("webkitTransitionEnd transitionend");t.removeStyleClass("sapMNavItemSlideLeft").removeStyleClass("sapMNavItemSlideRight");this._fadeInAnimation()};l.prototype._fadeInAnimation=function(){var e=this,t=this.oToPage;window.setTimeout(function(){t.$().on("webkitTransitionEnd transitionend",e._fadeInAnimationEnd.bind(e));e.bTransition2EndPending=true;t.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent").addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){if(e.bTransition2EndPending){e._fadeInAnimationEnd()}},p(150))},p(10))};l.prototype._fadeInAnimationEnd=function(e){var t=this.oToPage,i=this.oFromPage;if(e&&e.originalEvent&&e.originalEvent.propertyName!=="opacity"){return}this.bTransition2EndPending=false;if(g(i)){i.addStyleClass("sapMNavItemHidden");i.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent")}jQuery(t.$()).off("webkitTransitionEnd transitionend");if(g(t)){t.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque").removeStyleClass("sapMNavItemSlideLeft").removeStyleClass("sapMNavItemSlideRight")}this.fCallback()};l.prototype._baseSlideAnimation=function(e,t,i){var a=false,n=true,s=this._sTransitionDirection===l.TransitionDirection.BACK,o=s?"reverse":"normal",r=s?"sapMNavItemSlideCenterToLeft":"sapMNavItemSlideRightToCenter",d=!s?"sapMNavItemSlideCenterToLeft":"sapMNavItemSlideRightToCenter",u=function(){jQuery(this).off("webkitAnimationEnd animationend");if(!a){a=true;return a}n=false;h(t,"");h(e,"");if(g(t)){t.removeStyleClass(r)}if(g(e)){e.removeStyleClass(d).addStyleClass("sapMNavItemHidden")}i()};e.$().on("webkitAnimationEnd animationend",u);t.$().on("webkitAnimationEnd animationend",u);h(t,o);h(e,o);e.addStyleClass(d);t.addStyleClass(r).removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){if(n){a=true;u.apply(e.$().add(t.$()))}},p(400))};l.transitions=l.transitions||{};l.transitions["show"]={to:function(e,t,i){t.removeStyleClass("sapMNavItemHidden");e&&e.addStyleClass("sapMNavItemHidden");i()},back:function(e,t,i){t.removeStyleClass("sapMNavItemHidden");e&&e.addStyleClass("sapMNavItemHidden");i()}};l.transitions["baseSlide"]={to:l.prototype._baseSlideAnimation,back:l.prototype._baseSlideAnimation};l.transitions["slide"]={to:l.prototype._fadeTransition,back:l.prototype._fadeTransition};l.transitions["fade"]={to:l.prototype._fadeTransition,back:l.prototype._fadeTransition};l.transitions["flip"]={to:function(e,t,i){var a=this;window.setTimeout(function(){a.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var n=false;var s=true;var o=null;o=function(){jQuery(this).off("webkitTransitionEnd transitionend");if(!n){n=true}else{s=false;if(g(t)){t.removeStyleClass("sapMNavItemFlipping")}if(g(e)){e.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipPrevious")}a.$().removeClass("sapMNavFlip");i()}};e.$().on("webkitTransitionEnd transitionend",o);t.$().on("webkitTransitionEnd transitionend",o);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipNext");e.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipPrevious");window.setTimeout(function(){if(s){n=true;o.apply(e.$().add(t.$()))}},p(600))},p(60))},0)},back:function(e,t,i){var a=this;a.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipPrevious");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var n=false;var s=true;var o=null;o=function(){jQuery(this).off("webkitTransitionEnd transitionend");if(!n){n=true}else{s=false;if(g(t)){t.removeStyleClass("sapMNavItemFlipping")}if(g(e)){e.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipNext")}a.$().removeClass("sapMNavFlip");i()}};e.$().on("webkitTransitionEnd transitionend",o);t.$().on("webkitTransitionEnd transitionend",o);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipPrevious");e.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipNext");window.setTimeout(function(){if(s){n=true;o.apply(e.$().add(t.$()))}},p(600))},p(60))}};l.transitions["door"]={to:function(e,t,i){var a=this;window.setTimeout(function(){a.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorInNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var n=false;var s=true;var o=null;o=function(){jQuery(this).off("webkitAnimationEnd animationend");if(!n){n=true}else{s=false;if(g(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorInNext")}if(g(e)){e.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorInPrevious")}a.$().removeClass("sapMNavDoor");i()}};e.$().on("webkitAnimationEnd animationend",o);t.$().on("webkitAnimationEnd animationend",o);t.addStyleClass("sapMNavItemDooring");e.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorInPrevious");window.setTimeout(function(){if(s){n=true;o.apply(e.$().add(t.$()))}},p(1e3))},p(60))},0)},back:function(e,t,i){var a=this;a.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorOutNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var n=false;var s=true;var o=null;o=function(){jQuery(this).off("webkitAnimationEnd animationend");if(!n){n=true}else{s=false;if(g(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorOutNext")}if(g(e)){e.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorOutPrevious")}a.$().removeClass("sapMNavDoor");i()}};e.$().on("webkitAnimationEnd animationend",o);t.$().on("webkitAnimationEnd animationend",o);t.addStyleClass("sapMNavItemDooring");e.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorOutPrevious");window.setTimeout(function(){if(s){n=true;o.apply(e.$().add(t.$()))}},p(1e3))},p(60))}};l.prototype.addCustomTransition=function(e,t,i){if(l.transitions[e]){r.warning("Transition with name "+e+" already exists in "+this+". It is now being replaced by custom transition.")}l.transitions[e]={to:t,back:i};return this};l.addCustomTransition=l.prototype.addCustomTransition;l.prototype.invalidate=function(e){if(e==this){}else if(e instanceof i){var t=false,a=this.getPages(),n=a.length;for(var s=0;s<n;s++){if(a[s]===e){t=true;break}}if((!t||e===this.getCurrentPage())&&!this._isInsideAPopup()){i.prototype.invalidate.call(this,e)}}else{i.prototype.invalidate.call(this,e)}};l.prototype._isInsideAPopup=function(){var e;e=function(t){if(!t){return false}if(t.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){return true}return e(t.getParent())};return e(this)};l.prototype.removePage=function(e){var t;if(typeof e=="number"){t=this.getPages()[e]}else if(typeof e=="string"){t=n.getElementById(e)}else{t=e}t=this.removeAggregation("pages",t,t!==this.getCurrentPage());this._onPageRemoved(t);return t};l.prototype._onPageRemoved=function(e){if(!e){return}e.$().remove();e.removeStyleClass("sapMNavItemHidden");e.removeStyleClass("sapMNavItem");var t=this._ensurePageStackInitialized();this._pageStack=t.filter(function(t){return e.getId()!==t.id})};l.prototype.removeAllPages=function(){var e=this.removeAllAggregation("pages");for(var t=0;t<e.length;t++){this._onPageRemoved(e[t])}return e};l.prototype.addPage=function(e){var t=this.getPages(),i=this.invalidate.bind(this);if(t.indexOf(e)>-1){return this}this.addAggregation("pages",e,true);e.addStyleClass("sapMNavItem");var a=t.length;if(a===0&&this.getPages().length===1){this._fireAdaptableContentChange(e);if(this.getDomRef()){this._ensurePageStackInitialized();i=this.rerender.bind(this);i()}}return this};l.prototype.insertPage=function(e,t){var i=this.getPages().length,a=this.invalidate.bind(this);this.insertAggregation("pages",e,t,true);e.addStyleClass("sapMNavItem");if(i===0&&this.getPages().length===1){this._fireAdaptableContentChange(e);if(this.getDomRef()){this._ensurePageStackInitialized();a=this.rerender.bind(this);a()}}return this};l.prototype.showPlaceholder=function(e){var t,i=sap.ui.require("sap/ui/core/Placeholder");if(!i||!i.isEnabled()){return}if(this._placeholder){this.hidePlaceholder()}if(e&&e.placeholder){this._placeholder=e.placeholder;t=this._placeholder._load()}else{t=Promise.resolve()}if(this.getDomRef()&&this._placeholder){this._placeholder.show(this)}this.addEventDelegate(d,this);return t};l.prototype.hidePlaceholder=function(){if(this._placeholder){this._placeholder.hide();this.removeEventDelegate(d)}};l.prototype.needPlaceholder=function(e,t){return!t||this.getCurrentPage()!==t};l.prototype._getAdaptableContent=function(){return this.getCurrentPage()};l.prototype._fireAdaptableContentChange=function(e){if(e&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{parent:this,adaptableContent:e})}};return l});
//# sourceMappingURL=NavContainer.js.map