/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/base/i18n/Localization","sap/ui/core/Control","sap/ui/core/library","sap/m/Text","sap/ui/core/Element","sap/ui/core/Locale","sap/ui/events/KeyCodes","./ObjectAttributeRenderer","sap/base/Log","sap/ui/base/ManagedObjectObserver"],function(t,e,i,o,n,s,r,a,p,u,g){"use strict";var l=o.TextDirection;var c=t.EmptyIndicatorMode;var m=o.aria.HasPopup;var f=t.ReactiveAreaMode;var h=i.extend("sap.m.ObjectAttribute",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ObjectAttribute.designtime",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},active:{type:"boolean",group:"Misc",defaultValue:null},reactiveAreaMode:{type:"sap.m.ReactiveAreaMode",group:"Appearance",defaultValue:f.Inline},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:l.Inherit},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:m.None}},aggregations:{customContent:{type:"sap.ui.core.Control",multiple:false},_textControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{parameters:{domRef:{type:"string"}}}},dnd:{draggable:true,droppable:false}},renderer:p});h.prototype.init=function(){this.setAggregation("_textControl",new n)};h.prototype.exit=function(){if(this._oCustomContentObserver){this._oCustomContentObserver.disconnect();this._oCustomContentObserver=null}if(this._oCustomContentCloning){this._oCustomContentCloning.destroy()}};h.prototype.onBeforeRendering=function(){var t,e=this.getId()+"-title";if(this._isClickable()&&!this._isSimulatedLink()){t=this.getCustomContent();t.setAriaHasPopup(this.getAriaHasPopup());if(!t.getAriaLabelledBy().includes(e)){t.addAriaLabelledBy(e)}}};h.prototype._getUpdatedTextControl=function(){var t=this._oCustomContentCloning||this.getAggregation("_textControl"),i=this.getTitle(),o=this.getAggregation("customContent")?this.getAggregation("customContent").getText():this.getText(),n=this.getTextDirection(),s=this.getParent(),a=e.getRTL(),u,g=true,m="",f;this._bEmptyIndicatorMode=this._isEmptyIndicatorMode();if(n===l.LTR&&a){m="‎"}if(n===l.RTL&&!a){m="‏"}o=m+o+m;if(i){f=i;if(new r(e.getLanguageTag()).getLanguage().toLowerCase()==="fr"){f+=" "}f+=": "+o}else{f=o}if(this._bEmptyIndicatorMode){this.getAggregation("_textControl").setEmptyIndicatorMode(c.On)}t.setText(f);t.setTextDirection(n);if(s&&s.isA("sap.m.ObjectListItem")){g=false;u=p.MAX_LINES.SINGLE_LINE}this._setControlWrapping(t,g,u);return t};h.prototype._isEmptyIndicatorMode=function(){var t=this.getAggregation("customContent");return t&&t.getEmptyIndicatorMode()!==c.Off&&!t.getText()};h.prototype._setControlWrapping=function(t,e,i){if(t.isA("sap.m.Link")){t.setWrapping(e)}if(t.isA("sap.m.Text")){t.setMaxLines(i)}};h.prototype.ontap=function(t){var e=t.target;e=e.id?e:e.parentElement;if(this._isSimulatedLink()&&e.id===this.getId()+"-text"){this.firePress({domRef:this.getDomRef()})}};h.prototype.onsapenter=function(t){if(this._isSimulatedLink()){this.firePress({domRef:this.getDomRef()});t.setMarked()}};h.prototype.onsapspace=function(t){t.preventDefault()};h.prototype.onkeyup=function(t){if(t.which===a.SPACE){this.onsapenter(t)}};h.prototype._isEmpty=function(){if(this.getAggregation("customContent")&&!(this.getAggregation("customContent").isA("sap.m.Link")||this.getAggregation("customContent").isA("sap.m.Text"))){u.warning('Only sap.m.Link or sap.m.Text are allowed in "sap.m.ObjectAttribute.customContent" aggregation');return true}return!(this.getText().trim()||this.getTitle().trim())};h.prototype.ontouchstart=function(t){if(this._isSimulatedLink()){t.originalEvent._sapui_handledByControl=true}};h.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("text")};h.prototype.getFocusDomRef=function(){var t=this.getDomRef();if(t){if(this._isSimulatedLink()){return t.querySelector(".sapMObjectAttributeText")}else if(this._isClickable()){return this.getAggregation("customContent").getDomRef()}}return s.prototype.getFocusDomRef.apply(this,arguments)};h.prototype._isSimulatedLink=function(){return this.getActive()&&this.getText()!==""&&!this.getAggregation("customContent")};h.prototype.setCustomContent=function(t){var e=this.getCustomContent();if(this._oCustomContentCloning){this._oCustomContentCloning.destroy()}this._oCustomContentCloning=t&&t.clone();if(!this._oCustomContentObserver){this._oCustomContentObserver=new g(function(){this.invalidate()}.bind(this))}if(e){this._oCustomContentObserver.unobserve(e)}t&&this._oCustomContentObserver.observe(t,{properties:true});return this.setAggregation("customContent",t)};h.prototype._isClickable=function(){return this.getAggregation("customContent")?this.getAggregation("customContent").isA("sap.m.Link"):this.getActive()&&this.getText()!==""};return h});
//# sourceMappingURL=ObjectAttribute.js.map