/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/core/Control","sap/ui/core/library","sap/m/library","sap/ui/Device","sap/base/Log","sap/m/Link","sap/m/Text","sap/ui/thirdparty/jquery","sap/ui/util/defaultLinkTypes"],function(e,t,i,s,r,n,o,a,jQuery,l){"use strict";var d=i.TextDirection;var p=s.BackgroundDesign;var c=i.TitleLevel;var g={apiVersion:2};g._isEmptyObject=function(e){if(!e){return true}if((!e._isEmpty||!e._isEmpty())&&(!e.getVisible||e.getVisible())){return false}return true};g._isEmptyArray=function(e){if(e){for(var t=0;t<e.length;t++){if(!g._isEmptyObject(e[t])){return false}}}return true};g._isEmptyRow=function(e,t){return g._isEmptyObject(e)&&g._isEmptyArray(t)};g._renderObjects=function(e,i,s){for(var r=0;r<i.length;r++){if(i[r]instanceof t){this._renderChildControl(e,s,i[r])}}};g._computeChildControlsToBeRendered=function(e){e.__controlsToBeRendered={};var t=e.getAttributes(),i;for(var s=0;s<t.length;s++){e.__controlsToBeRendered[t[s].getId()]=t[s]}t=e.getStatuses();for(var s=0;s<t.length;s++){e.__controlsToBeRendered[t[s].getId()]=t[s]}(function(){i=e.getFirstStatus();if(i){e.__controlsToBeRendered[i.getId()]=i}i=e.getSecondStatus();if(i){e.__controlsToBeRendered[i.getId()]=i}})();i=e.getAggregation("_objectNumber");if(i){e.__controlsToBeRendered[i.getId()]=i}};g._cleanupNotRenderedChildControls=function(e,t){for(var i in t.__controlsToBeRendered){e.cleanupControlWithoutRendering(t.__controlsToBeRendered[i])}delete t.__controlsToBeRendered};g._getMarkers=function(e){return e._getVisibleMarkers()};g._renderIntro=function(e,t,i,s){if(t.getIntroActive()){t._introText=new o(t.getId()+"-intro");t._introText.setText(t.getIntro());t._introText.setHref(t.getIntroHref());t._introText.setTarget(t.getIntroTarget());t._introText.press=t.introPress}else{t._introText=new a(t.getId()+"-intro");t._introText.setText(t.getIntro());t._introText.setMaxLines(3)}t._introText.setTextDirection(t.getIntroTextDirection());e.openStart("div");e.class(i);if(t.getIntroActive()){e.class(s)}e.openEnd();this._renderChildControl(e,t,t._introText);e.close("div")};g._renderAttribute=function(e,t,i,s){e.openStart("div");e.class("sapMOHAttr");if(s){e.style("width","100%")}e.openEnd();this._renderChildControl(e,t,i);e.close("div")};g._getVisibleStatuses=function(e){var t=[];if(e.getFirstStatus()&&e.getFirstStatus().getVisible()){t.push([e.getFirstStatus()])}if(e.getSecondStatus()&&e.getSecondStatus().getVisible()){t.push([e.getSecondStatus()])}if(e.getStatuses()){var i=e.getStatuses();for(var s=0;s<i.length;s++){if(!i[s].getVisible||i[s].getVisible()){if(i[s].isA("sap.m.ObjectStatus")&&!i[s]._isEmpty()||i[s].isA("sap.m.ProgressIndicator")){t.push([i[s]])}else{n.warning('Only sap.m.ObjectStatus or sap.m.ProgressIndicator are allowed in "sap.m.ObjectHeader.statuses" aggregation.'+" Current object is "+i[s].constructor.getMetadata().getName()+' with id "'+i[s].getId()+'"')}}}}return t};g._getVisibleAttribsAndStatuses=function(e){var t=[],i=e.getAttributes(),s=[];for(var r=0;r<i.length;r++){if(i[r].getVisible()&&!i[r]._isEmpty()){s.push(i[r])}}var n=this._getVisibleStatuses(e);t[0]=s;t[1]=n;return t};g._renderRow=function(e,t,i,s){if(g._isEmptyRow(i,s)){return}e.openStart("div");e.class("sapMOHAttrRow");e.openEnd();if(!g._isEmptyObject(i)){this._renderAttribute(e,t,i,g._isEmptyArray(s))}else if(g._isEmptyObject(i)&&!g._isEmptyArray(s)){if(s[0]&&s[0].isA("sap.m.ProgressIndicator")){e.openStart("div");e.class("sapMOHAttr");e.openEnd();e.close("div")}}if(!g._isEmptyArray(s)){e.openStart("div");if(s[0]&&s[0].isA("sap.m.ProgressIndicator")){e.class("sapMOHStatusFixedWidth")}else if(s[0]&&s[0].isA("sap.m.ObjectMarker")){e.class("sapMOHStatusFixedWidth");e.class("sapMObjStatusMarker")}else{e.class("sapMOHStatus")}e.openEnd();g._renderObjects(e,s,t);e.close("div")}e.close("div")};g._renderAttributesAndStatuses=function(e,t){var i=t.getAttributes();var s=[];for(var r=0;r<i.length;r++){if(i[r].getVisible()){s.push(i[r])}}var n=s.length;var o=[];var a=g._getMarkers(t);if(!t.getResponsive()&&!g._isEmptyArray(a)){o.push(a)}var l=this._getVisibleStatuses(t);o=o.concat(l);var d=o.length;var p=n>d?n:d;if(!t.getResponsive()){for(var c=0;c<p;c++){this._renderRow(e,t,s[c],o[c])}}};g._renderNumber=function(e,t){var i=t.getAdditionalNumbers();if(!t.getNumber()&&(i&&!i.length)){return}e.openStart("div",t.getId()+"-numberdiv");e.class("sapMOHNumberDiv");e.openEnd();var s=t.getAggregation("_objectNumber");if(s&&s.getNumber()){s.setTextDirection(t.getNumberTextDirection());this._renderChildControl(e,t,s)}e.close("div");if(!t.getCondensed()){this._renderAdditionalNumbers(e,t)}};g._renderAdditionalNumbers=function(e,t){var i=t.getAdditionalNumbers();if(i&&!i.length){return}if(i.length===1){e.openStart("div");e.class("additionalOHNumberSeparatorDiv");e.openEnd();e.close("div")}for(var s=0;s<i.length;s++){e.openStart("div",t.getId()+"-additionalNumber"+s);e.class("sapMOHNumberDiv");e.class("additionalOHNumberDiv");if(i.length===1){e.class("sapMOHOnlyANumber")}e.openEnd();i[s].setTextDirection(t.getNumberTextDirection());this._renderChildControl(e,t,i[s]);e.close("div")}};g._renderTitle=function(e,t){t._oTitleArrowIcon.setVisible(t.getShowTitleSelector());if(t.getShowTitleSelector()&&t._oTitleArrowIcon.getVisible()){e.openStart("div");e.class("sapMOHTitleAndArrow");e.openEnd()}if(t.getTitle()){var i=t.getTitleLevel()===c.Auto?c.H1:t.getTitleLevel();i=i.toLowerCase();t._titleText.setText(t.getTitle());t._titleText.setTextDirection(t.getTitleTextDirection());if(t.getTitleActive()){e.openStart("a",t.getId()+"-title");if(t.getTitleHref()){e.attr("href",t.getTitleHref());if(t.getTitleTarget()){e.attr("target",t.getTitleTarget());e.attr("rel",l("",t.getTitleTarget()))}}e.accessibilityState({role:"link"})}else{e.openStart("div",t.getId()+"-title")}e.class("sapMOHTitle");if(t.getTitleActive()){e.attr("tabindex","0");e.class("sapMOHTitleActive")}if(t.getShowTitleSelector()){e.class("sapMOHTitleFollowArrow")}e.openEnd();e.openStart(i);e.openEnd();this._renderChildControl(e,t,t._titleText);e.close(i);if(t.getTitleActive()){e.close("a")}else{e.close("div")}}if(t.getShowTitleSelector()){e.openStart("span");e.class("sapMOHTitleArrow");e.openEnd();this._renderChildControl(e,t,t._oTitleArrowIcon);e.close("span")}if(t.getShowTitleSelector()&&t._oTitleArrowIcon.getVisible()){e.close("div")}};g._renderFullTitle=function(e,t){var i=t.getAdditionalNumbers();if(!t.getNumber()&&(i&&!i.length)){e.class("sapMOHTitleDivFull")}};g._renderFullOH=function(e,t){if(t.getIntro()){this._renderIntro(e,t,"sapMOHIntro","sapMOHIntroActive")}e.openStart("div");e.class("sapMOHTopRow");e.openEnd();e.openStart("div",t.getId()+"-titlediv");e.class("sapMOHTitleDiv");if(t._hasIcon()){e.class("sapMOHTitleIcon")}this._renderFullTitle(e,t);e.openEnd();if(t._hasIcon()){e.openStart("div");e.class("sapMOHIcon");e.class("sapMOHIcon"+t.getImageShape());if(t.getIconActive()){e.class("sapMPointer")}e.openEnd();this._renderChildControl(e,t,t._getImageControl());e.close("div")}this._renderTitle(e,t);e.close("div");this._renderNumber(e,t);e.openStart("div");e.class("sapMOHDivider");e.openEnd();e.close("div");e.close("div");if(t._hasBottomContent()){e.openStart("div");e.class("sapMOHBottomRow");e.openEnd();this._renderAttributesAndStatuses(e,t);e.openStart("div");e.class("sapMOHDivider");e.openEnd();e.close("div");e.close("div")}};g._renderCondensedOH=function(e,t){e.openStart("div",t.getId()+"-titlediv");e.class("sapMOHTitleDiv");this._renderFullTitle(e,t);e.openEnd();this._renderTitle(e,t);e.close("div");this._renderNumber(e,t);var i=t.getAttributes()[0];if(i&&!i._isEmpty()){this._renderAttribute(e,t,i)}};g.render=function(e,t){if(t.getResponsive()){this._renderResponsive(e,t);return}this._computeChildControlsToBeRendered(t);var i=t.getCondensed();e.openStart("div",t);e.openEnd();e.openStart("div");e.class("sapMOH");if(t._getBackground()!==p.Transparent){e.class("sapContrastPlus")}if(i){e.class("sapMOHC")}e.class("sapMOHBg"+t._getBackground());var s=t.getTooltip_AsString();if(s){e.attr("title",s)}var r={role:"region"};if(t.getTitle()){r.labelledby={value:t.getId()+"-titleText-inner",append:true}}e.accessibilityState(t,r);e.openEnd();if(i){this._renderCondensedOH(e,t)}else{this._renderFullOH(e,t)}e.openStart("div");e.class("sapMOHLastDivider");e.openEnd();e.close("div");e.close("div");e.close("div");this._cleanupNotRenderedChildControls(e,t)};g._renderChildControl=function(e,t,i){e.renderControl(i);if(!t.getResponsive()&&t.__controlsToBeRendered){t.__controlsToBeRendered[i.getId()]=undefined}};g._renderResponsive=function(e,t){var i=this._hasResponsiveStates(t),s=this._hasResponsiveTabs(t),o=t.getHeaderContainer();e.openStart("div",t);e.class("sapMOHROuter");var a=t.getTooltip_AsString();if(a){e.attr("title",a)}e.accessibilityState({role:"region",labelledby:{value:t.getId()+"-txt",append:true}});e.openEnd();e.openStart("div");e.class("sapMOHR");if(t._getBackground()!==p.Transparent){e.class("sapContrastPlus")}if(s){e.class("sapMOHRNoBorder")}e.class("sapMOHRBg"+t._getBackground());e.openEnd();e.openStart("div");e.class("sapMOHRMaxWidth");if(r.system.desktop&&t._isMediaSize("Desktop")&&t.getFullScreenOptimized()&&t._iCountVisAttrStat>=1&&t._iCountVisAttrStat<=3){e.class("sapMOHRStatesOneOrThree")}e.openEnd();this._renderResponsiveTitleBlock(e,t);if(i){this._renderResponsiveStates(e,t)}e.close("div");if(s){this._renderResponsiveTabs(e,t)}e.close("div");if(o&&o.isA("sap.m.IconTabBar")){this._renderChildControl(e,t,o)}e.close("div");if(!t.getTitle()){if(!t.getBinding("title")){n.warning("The title shouldn't be empty!")}}};g._renderResponsiveTitleBlock=function(e,t){e.openStart("div",t.getId()+"-titlenumdiv");e.class("sapMOHRTitleNumberDiv");e.openEnd();e.openStart("div",t.getId()+"-titlediv");e.class("sapMOHRTitleDiv");if(t._hasIcon()){if(r.system.phone||t._isMediaSize("Phone")){if(r.orientation.landscape||t._isMediaSize("Phone")&&!r.system.phone){e.class("sapMOHRTitleIcon")}}else{e.class("sapMOHRTitleIcon")}}if(!t.getNumber()){e.class("sapMOHRTitleDivFull")}e.openEnd();this._renderResponsiveTitle(e,t);if(t._hasIcon()){e.openStart("div",t.getId()+"-titleIcon");e.class("sapMOHRIcon");e.class("sapMOHRIcon"+t.getImageShape());if(r.system.phone&&r.orientation.portrait){e.class("sapMOHRHideIcon")}if(t.getIconActive()){e.class("sapMPointer")}e.openEnd();this._renderChildControl(e,t,t._getImageControl());e.close("div")}e.close("div");this._renderResponsiveNumber(e,t);e.close("div")};g._renderResponsiveStates=function(e,t){e.openStart("div",t.getId()+"-states");e.class("sapMOHRStates");e.openEnd();this._renderResponsiveRow(e,t);e.close("div")};g._renderResponsiveRow=function(e,t){var i=[];i=this._getVisibleAttribsAndStatuses(t);var s=i[0].concat(i[1]),n=i[0].length,o=s.length,a=1,l="";if(o===0){return}if(r.system.desktop){if(!t.getFullScreenOptimized()){if(o>=1&&o<=4){a=2;l="sapMOHRTwoCols"}if(o>=5){a=3;l="sapMOHRThreeCols"}}else{if(o>=1&&o<=3){a=1;l="sapMOHROneCols"}if(o>=4){a=4;l="sapMOHRFourCols"}}}if(r.system.tablet&&!r.system.desktop||r.system.desktop&&t._isMediaSize("Tablet")){if(!t.getFullScreenOptimized()||r.orientation.portrait&&t.getFullScreenOptimized()){a=2;l="sapMOHRTwoCols"}else{if(t.getFullScreenOptimized()&&(r.orientation.landscape||r.system.desktop&&t._isMediaSize("Tablet"))){if(o>=1&&o<=2){a=2;l="sapMOHRTwoCols"}if(o>=3){a=3;l="sapMOHRThreeCols"}}}}if(r.system.phone||r.system.desktop&&t._isMediaSize("Phone")){a=1;l="sapMOHROneCols"}this._renderResponsiveStatesColumn(e,t,a,s,n,l)};g._renderResponsiveStatesColumn=function(e,t,i,s,r,n){var o=Math.floor(s.length/i);var a=s.length%i;var l=0;var d=1;for(var p=0;p<s.length;p++){if(l==0){e.openStart("div");e.class("sapMOHRStatesCont"+d);e.class(n);e.openEnd()}if(p<r){this._renderResponsiveAttribute(e,t,s[p])}else{this._renderResponsiveStatus(e,t,s[p])}l++;if(l==o&&d>a||l==o+1&&d<=a||p==s.length-1){e.close("div");l=0;d++}}};g._renderResponsiveAttribute=function(e,t,i){e.openStart("div");e.class("sapMOHRAttr");e.openEnd();this._renderChildControl(e,t,i);e.close("div")};g._renderResponsiveStatus=function(e,t,i){e.openStart("div");e.class("sapMOHRStatus");e.openEnd();this._renderChildControl(e,t,i[0]);e.close("div")};g._renderResponsiveMarkers=function(t,i){var s=[],r=i.getTitleTextDirection(),n=e.getRTL();s=i._getVisibleMarkers();t.openStart("span",i.getId()+"-markers");t.class("sapMObjStatusMarker");if(r===d.LTR&&n||r===d.RTL&&!n){t.class("sapMObjStatusMarkerOpposite")}t.openEnd();for(var o=0;o<s.length;o++){this._renderChildControl(t,i,s[o])}t.close("span")};g._renderResponsiveNumber=function(e,t){var i=t.getAggregation("_objectNumber");if(i&&i.getNumber()){i.setTextDirection(t.getNumberTextDirection());this._renderChildControl(e,t,i)}};g._hasResponsiveStates=function(e){var t=e.getAttributes(),i=[];if(!(e._hasAttributes()||e._hasStatus())){e._iCountVisAttrStat=0;return false}for(var s=0;s<t.length;s++){if(t[s].getVisible()){i.push(t[s])}}var r=this._getVisibleStatuses(e);e._iCountVisAttrStat=i.length+r.length;return!!(i.length+r.length)};g._hasResponsiveTabs=function(e){var t=e.getHeaderContainer(),i;if(t){if(t.isA("sap.m.IconTabBar")){i=t._getIconTabHeader();if(i.getVisible()){e._iCountVisTabs=i.getItems().length;return!!i.getItems().length}}else if(t.isA("sap.m.HeaderContainer")){return!!t.getContent().length}else if(t.isA("sap.suite.ui.commons.HeaderContainer")){return!!t.getItems().length}}return false};g._renderResponsiveTabs=function(e,t){var i=t.getHeaderContainer(),s;e.openStart("div");e.class("sapMOHRTabs");if(i&&i.isA("sap.m.IconTabBar")){e.class("sapMOHRTabsITB")}e.openEnd();if(i){if(i.isA("sap.m.IconTabBar")){s=i._getIconTabHeader();this._renderChildControl(e,t,s);i._bHideHeader=true}else if(i.isA(["sap.m.HeaderContainer","sap.suite.ui.commons.HeaderContainer"])){this._renderChildControl(e,t,i)}else{n.warning("The control "+i+' is not supported for aggregation "headerContainer"')}}e.close("div")};g._renderResponsiveTitle=function(e,t){var i;t._oTitleArrowIcon.setVisible(t.getShowTitleSelector());e.openStart("div",t.getId()+"-title");e.class("sapMOHRTitle");if(t.getTitle().length&&t.getTitleActive()){e.class("sapMOHRTitleActive")}if(t.getShowTitleSelector()){e.class("sapMOHRTitleFollowArrow")}e.openEnd();if(r.system.phone&&r.orientation.portrait){i=50}else{i=80}e.openStart("div",t.getId()+"-title-arrow");e.style("display","inline-block");e.openEnd();this._renderResponsiveTitleAndArrow(e,t,i);e.close("div");if(t.getIntro()){this._renderIntro(e,t,"sapMOHRIntro","sapMOHRIntroActive")}e.close("div")};g._rerenderTitle=function(e,t,i){var s=t.getId();this._renderResponsiveTitleAndArrow(e,t,i);e.flush(jQuery(document.getElementById(s+"-title-arrow")))};g._renderResponsiveTitleAndArrow=function(e,t,i){var s,r="",n=t.getTitleTextDirection();var o=!!t._getVisibleMarkers().length;var a=t.getTitleLevel()===c.Auto?c.H1:t.getTitleLevel();a=a.toLowerCase();e.openStart(a);e.openEnd();e.openStart("span");e.class("sapMOHRTitleTextContainer");if(n!=d.Inherit){e.attr("dir",n.toLowerCase())}e.openEnd();if(t.getTitle().length&&t.getTitleActive()){e.openStart("a",t.getId()+"-txt");if(t.getTitleHref()){e.attr("href",t.getTitleHref());if(t.getTitleTarget()){e.attr("target",t.getTitleTarget());e.attr("rel",l("",t.getTitleTarget()))}}e.attr("tabindex","0");e.accessibilityState({role:"link"})}else{e.openStart("span",t.getId()+"-txt")}e.class("sapMOHRTitleText");e.openEnd();e.openStart("span",t.getId()+"-titletxtwrap");e.class("sapMOHRTitleTextWrappable");e.openEnd();if(t.getTitle().length>i){s=t.getTitle().substr(0,i).trim();r="..."}else{s=t.getTitle()}if(o){var p=s.substr(s.lastIndexOf(" ")+1);var g=s.substr(0,s.lastIndexOf(" ")+1);if(p.length===1){p=s;g=""}e.text(g);e.close("span");e.text(p);e.text(r);if(t.getTitleActive()){e.close("a")}else{e.close("span")}this._renderResponsiveMarkers(e,t);e.close("span")}else{if(!r){e.text(s)}else{e.text(s+r)}if(t.getTitleActive()){e.close("span");e.close("a");e.close("span")}else{e.close("span");e.close("span");e.close("span")}}if(t.getShowTitleSelector()){e.openStart("span");e.class("sapMOHRTitleArrow");e.openEnd();this._renderChildControl(e,t,t._oTitleArrowIcon);e.close("span")}e.close(a)};g._rerenderResponsiveStates=function(e,t){var i=t.getId(),s=this._getVisibleAttribsAndStatuses(t),n=s[0].concat(s[1]),o=s[0].length,a=n.length,l=1,d="";if(a===0){return}if(r.orientation.portrait){l=2;d="sapMOHRTwoCols"}else{if(a>=1&&a<=2){l=2;d="sapMOHRTwoCols"}if(a>=3){l=3;d="sapMOHRThreeCols"}}this._renderResponsiveStatesColumn(e,t,l,n,o,d);e.flush(jQuery(document.getElementById(i+"-states"))[0])};return g},true);
//# sourceMappingURL=ObjectHeaderRenderer.js.map