/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","./Link","./Text","sap/ui/core/Control","sap/ui/core/ControlBehavior","sap/ui/core/IconPool","sap/ui/core/InvisibleText","sap/ui/core/Lib","sap/ui/core/library","sap/ui/Device","sap/ui/base/ManagedObject","./ObjectIdentifierRenderer","sap/ui/events/KeyCodes"],function(t,e,i,o,r,n,s,a,p,l,c,g,u){"use strict";var d=p.TextDirection;var h=t.EmptyIndicatorMode;var y=t.ReactiveAreaMode;var f=o.extend("sap.m.ObjectIdentifier",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ObjectIdentifier.designtime",properties:{title:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},badgeNotes:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgePeople:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgeAttachments:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},titleActive:{type:"boolean",group:"Misc",defaultValue:false},reactiveAreaMode:{type:"sap.m.ReactiveAreaMode",group:"Appearance",defaultValue:y.Inline},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:h.Off}},aggregations:{_titleControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_textControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{titlePress:{parameters:{domRef:{type:"object"}}}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},dnd:{draggable:true,droppable:false}},renderer:g});f.prototype.init=function(){var t=a.getResourceBundleFor("sap.m");if(r.isAccessibilityEnabled()){f.OI_ARIA_ROLE=t.getText("OI_ARIA_ROLE")}};f.prototype.onBeforeRendering=function(){var t=this._getTitleControl();if(t.isA("sap.m.Link")){t.setProperty("reactiveAreaMode",this.getReactiveAreaMode())}};f.prototype.exit=function(){if(this._attachmentsIcon){this._attachmentsIcon.destroy();this._attachmentsIcon=null}if(this._peopleIcon){this._peopleIcon.destroy();this._peopleIcon=null}if(this._notesIcon){this._notesIcon.destroy();this._notesIcon=null}};f.prototype._getAttachmentsIcon=function(){if(!this._attachmentsIcon){this._attachmentsIcon=this._getIcon(n.getIconURI("attachment"),this.getId()+"-attachments")}return this._attachmentsIcon};f.prototype._getPeopleIcon=function(){if(!this._peopleIcon){this._peopleIcon=this._getIcon(n.getIconURI("group"),this.getId()+"-people")}return this._peopleIcon};f.prototype._getNotesIcon=function(){if(!this._notesIcon){this._notesIcon=this._getIcon(n.getIconURI("notes"),this.getId()+"-notes")}return this._notesIcon};f.prototype._getIcon=function(t,e){var i=l.system.phone?"1em":"1em";var o;o=this._icon||n.createControlByURI({src:t,id:e+"-icon",size:i,useIconTooltip:false},sap.m.Image);o.setSrc(t);return o};f.prototype._getTitleControl=function(){var t=this.getAggregation("_titleControl"),o=this.getId(),r=c.escapeSettingsValue(this.getProperty("title")),n;if(!t){if(this.getProperty("titleActive")){n=this.getAriaLabelledBy().slice();n.push(s.getStaticId("sap.m","OI_ARIA_ROLE"));t=new e({id:o+"-link",text:r,reactiveAreaMode:this.getReactiveAreaMode(),ariaLabelledBy:n});t.addAriaLabelledBy(o+"-text")}else{t=new i({id:o+"-txt",text:r})}this.setAggregation("_titleControl",t,true)}return t};f.prototype.setTitleControl=function(t){this.setAggregation("_titleControl",t);return this};f.prototype.getTitleControl=function(){return this._getTitleControl()};f.prototype._getTextControl=function(){var t=this.getAggregation("_textControl");if(!t){t=new i({text:c.escapeSettingsValue(this.getProperty("text"))});this.setAggregation("_textControl",t,true)}t.setTextDirection(this.getTextDirection());return t};f.prototype.setTitle=function(t){if(t){this._getTitleControl().setProperty("text",t)}return this.setProperty("title",t)};f.prototype.setText=function(t){if(t){this._getTextControl().setProperty("text",t)}return this.setProperty("text",t)};f.prototype.setTitleActive=function(t){var e=this.getTitleActive();this.setProperty("titleActive",t);if(e!=t){this.destroyAggregation("_titleControl");this._getTitleControl()}return this};f.prototype._handlePress=function(t){if(!this.getTitleActive()){return}const e=t.target;const i=this.getTitleControl().getDomRef();const o=e.parentElement.id===i.id||e.id===i.id;if(o){this.fireTitlePress({domRef:i});t.setMarked()}};f.prototype.onsapenter=function(t){f.prototype._handlePress.apply(this,arguments)};f.prototype.onkeyup=function(t){if(t&&t.which===u.SPACE){f.prototype._handlePress.apply(this,arguments)}};f.prototype.ontap=function(t){f.prototype._handlePress.apply(this,arguments)};f.prototype.addAssociation=function(t,i,r){var n=this.getAggregation("_titleControl");if(t==="ariaLabelledBy"){if(this.getTitleActive()&&n instanceof e){n.addAriaLabelledBy(i)}}return o.prototype.addAssociation.apply(this,arguments)};f.prototype.removeAssociation=function(t,i,r){var n=this.getAggregation("_titleControl");if(t==="ariaLabelledBy"){if(this.getTitleActive()&&n instanceof e){n.removeAssociation("ariaLabelledBy",i,true)}}return o.prototype.removeAssociation.apply(this,arguments)};f.prototype.getAccessibilityInfo=function(){var t=this.getAggregation("_titleControl")?this.getAggregation("_titleControl").getAccessibilityInfo():{type:"",description:""},e=(f.OI_ARIA_ROLE+" "+(t.type||"")).trim();if(this.getTitle()||this.getText()){t.type=e}t.description=t.description+" "+this.getText();return t};f.prototype._hasTopRow=function(){return this.getTitle()||this.getBadgeNotes()||this.getBadgePeople()||this.getBadgeAttachments()};return f});
//# sourceMappingURL=ObjectIdentifier.js.map