/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/Renderer","sap/ui/Device","sap/m/library","sap/ui/core/library","sap/ui/core/Icon","sap/m/TextRenderer","sap/m/Text","sap/m/LinkRenderer","sap/m/Link","./ObjectMarkerRenderer"],function(e,t,i,r,n,a,o,s,l,c,p,g){"use strict";var u=a.TextAlign;var y=n.ObjectMarkerVisibility;var d=n.ReactiveAreaMode;var h=e.extend("sap.m.ObjectMarker",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ObjectMarker.designtime",properties:{type:{type:"sap.m.ObjectMarkerType",group:"Misc"},reactiveAreaMode:{type:"sap.m.ReactiveAreaMode",group:"Appearance",defaultValue:d.Inline},visibility:{type:"sap.m.ObjectMarkerVisibility",group:"Misc"},additionalInfo:{type:"string",group:"Misc",defaultValue:""}},aggregations:{_innerControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{parameters:{type:{type:"sap.m.ObjectMarkerType"}}}},dnd:{draggable:true,droppable:false}},renderer:g});h.M_PREDEFINED_TYPES={Flagged:{icon:{src:"sap-icon://flag",visibility:{small:true,large:true}},text:{value:"OM_FLAG",visibility:{small:false,large:false}}},Favorite:{icon:{src:"sap-icon://favorite",visibility:{small:true,large:true}},text:{value:"OM_FAVORITE",visibility:{small:false,large:false}}},Draft:{icon:{src:"sap-icon://request",visibility:{small:false,large:false}},text:{value:"OM_DRAFT",visibility:{small:true,large:true}}},Locked:{icon:{src:"sap-icon://private",visibility:{small:true,large:true}},text:{value:"OM_LOCKED",visibility:{small:false,large:true}}},Unsaved:{icon:{src:"sap-icon://user-edit",visibility:{small:true,large:true}},text:{value:"OM_UNSAVED",visibility:{small:false,large:true}}},LockedBy:{icon:{src:"sap-icon://private",visibility:{small:true,large:true}},text:{value:"OM_LOCKED_BY",visibility:{small:false,large:true}}},UnsavedBy:{icon:{src:"sap-icon://user-edit",visibility:{small:true,large:true}},text:{value:"OM_UNSAVED_BY",visibility:{small:false,large:true}}}};h.prototype.init=function(){r.media.initRangeSet("DeviceSet",[600],"px",["small","large"])};h.prototype.onAfterRendering=function(){this._attachMediaContainerWidthChange(this._handleMediaChange,this,"DeviceSet")};h.prototype.onBeforeRendering=function(){this._cleanup();this._adjustControl(false);var e=this._getInnerControl();if(e&&e.isA("sap.m.internal.ObjectMarkerCustomLink")){e.setProperty("reactiveAreaMode",this.getReactiveAreaMode())}};h.prototype.exit=function(){this._cleanup()};h.prototype.attachPress=function(){var t=this._getInnerControl();Array.prototype.unshift.apply(arguments,["press"]);e.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")&&t&&t instanceof _){t.destroy();this.setAggregation("_innerControl",this._createCustomLink(),true);this._adjustControl()}return this};h.prototype.detachPress=function(){var t=this._getInnerControl();Array.prototype.unshift.apply(arguments,["press"]);e.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")&&t&&t instanceof A){t.destroy();this.setAggregation("_innerControl",this._createCustomText(),true);this._adjustControl()}return this};h.prototype._cleanup=function(){this._detachMediaContainerWidthChange(this._handleMediaChange,this,"DeviceSet")};h.prototype._handleMediaChange=function(){this._adjustControl()};h.prototype._adjustControl=function(e){var t=h.M_PREDEFINED_TYPES[this.getType()],i=this._getInnerControl(),r=i&&i._getIconAggregation(),n=this.getAdditionalInfo(),a=this._isIconVisible(),o=this._isTextVisible(),s=a&&!o,l=this.getType(),c,p;if(!i){return false}if(t){c=this._getMarkerText(t,l,n)}if(a){i.setIcon(t.icon.src,e);r.setDecorative(!s);r.setUseIconTooltip(s);this.addStyleClass("sapMObjectMarkerIcon")}else{i.setIcon(null,e);this.removeStyleClass("sapMObjectMarkerIcon")}if(o){i.setAggregation("tooltip",null,e);r&&r.setAggregation("tooltip",null,e);i.setText(c,e);this.addStyleClass("sapMObjectMarkerText")}else{if(r){i.setAggregation("tooltip",this.getTooltip_AsString()||c,e)}i.setText(null,e);this.removeStyleClass("sapMObjectMarkerText")}i.removeAllAssociation("ariaLabelledBy",e);i.removeAllAssociation("ariaDescribedBy",e);if(s){p=i._getIconAggregation();p.removeAllAssociation("ariaLabelledBy",e);p.removeAllAssociation("ariaDescribedBy",e)}this.getAriaLabelledBy().forEach(function(t){i.addAssociation("ariaLabelledBy",t,e);if(s){i._getIconAggregation().addAssociation("ariaLabelledBy",t,e)}});this.getAriaDescribedBy().forEach(function(t){i.addAssociation("ariaDescribedBy",t,e);if(s){i._getIconAggregation().addAssociation("ariaDescribedBy",t,e)}});return true};h.prototype._getMarkerText=function(e,i,r){var n=t.getResourceBundleFor("sap.m");switch(i){case"LockedBy":return r===""?n.getText("OM_LOCKED_BY_ANOTHER_USER"):n.getText("OM_LOCKED_BY",[r]);case"UnsavedBy":return r===""?n.getText("OM_UNSAVED_BY_ANOTHER_USER"):n.getText("OM_UNSAVED_BY",[r]);default:return r===""?n.getText(e.text.value):n.getText(e.text.value)+" "+r}};h.prototype._isIconVisible=function(){var e=h.M_PREDEFINED_TYPES[this.getType()],t=this.getVisibility(),i=this._getDeviceType(),r=e&&e.icon.visibility[i]||false;return t===y.IconOnly||t===y.IconAndText||t!==y.TextOnly&&r};h.prototype._isTextVisible=function(){var e=h.M_PREDEFINED_TYPES[this.getType()],t=this.getVisibility(),i=this._getDeviceType(),r=e&&e.text.visibility[i]||false;return t===y.TextOnly||t===y.IconAndText||t!==y.IconOnly&&r};h.prototype._getDeviceType=function(){return this._getCurrentMediaContainerRange("DeviceSet").name.toLowerCase()};h.prototype._getInnerControl=function(){var e=this.getAggregation("_innerControl");if(!e&&this.getType()){e=this._createInnerControl();this.setAggregation("_innerControl",e,true);this._adjustControl(true)}return e};h.prototype._createInnerControl=function(){if(this.hasListeners("press")){return this._createCustomLink()}else{return this._createCustomText()}};h.prototype._createCustomLink=function(){var e=new A(this.getId()+"-link",{reactiveAreaMode:this.getReactiveAreaMode(),wrapping:true});e.attachPress(this._firePress,this);return e};h.prototype._firePress=function(){this.firePress({type:this.getType()})};h.prototype._createCustomText=function(){return new _(this.getId()+"-text",{textAlign:u.Initial})};["getAccessibilityInfo"].map(function(e){var t=/^add/.test(e);h.prototype[e]=function(){var i=this._getInnerControl(),r;i=this.hasListeners("press")&&i.getIconOnly()?i._getIconAggregation():i;if(i&&i[e]){r=i[e].apply(i,arguments)}return t?this:r}});var f=i.extend(s);f.apiVersion=2;f.render=function(e,t){if(t.getIconOnly()){var i=t._getIconAggregation(),r=t.getTooltip_AsString();i.setAlt(r);i.setTooltip(r);e.renderControl(i)}else{s.render.call(this,e,t)}};f.renderText=function(e,t){e.renderControl(t._getIconAggregation());s.renderText(e,t)};var _=l.extend("sap.m.internal.ObjectMarkerCustomText",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},iconOnly:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{_iconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}},renderer:f});_.prototype.setIcon=function(e,t){var i=this._getIconAggregation();this.setProperty("icon",e,t);i.setSrc(e);return this};_.prototype._getIconAggregation=function(){var e=this.getAggregation("_iconControl");if(!e){e=new o(this.getId()+"-icon",{});this.setAggregation("_iconControl",e,true)}return e};var v=i.extend(c);v.apiVersion=2;v.render=function(e,t){if(t.getIconOnly()){var i=t._getIconAggregation(),r=t.getTooltip_AsString();i.setAlt(r);i.setTooltip(r);e.renderControl(i)}else{c.render.call(this,e,t)}};v.renderText=function(e,t){e.renderControl(t._getIconAggregation());c.renderText(e,t)};var A=p.extend("sap.m.internal.ObjectMarkerCustomLink",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},iconOnly:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{_iconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}},renderer:v});A.prototype.setIcon=function(e,t){var i=this._getIconAggregation();this.setProperty("icon",e,t);i.setSrc(e);return this};A.prototype._getTabindex=function(){return"0"};A.prototype._getIconAggregation=function(){var e=this.getAggregation("_iconControl");if(!e){e=new o;this.setAggregation("_iconControl",e,true)}return e};A.prototype._determineSelfReferencePresence=function(){if(this.getIcon()&&!this.getText()){return false}else{return p.prototype._determineSelfReferencePresence.apply(this,arguments)}};return h});
//# sourceMappingURL=ObjectMarker.js.map