/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/LabelEnablement","sap/ui/events/KeyCodes","./ObjectNumberRenderer"],function(e,t,i,a,r,s,n){"use strict";var p=a.TextAlign;var o=a.TextDirection;var u=a.ValueState;var l=e.EmptyIndicatorMode;var c=e.ReactiveAreaMode;var d=t.extend("sap.m.ObjectNumber",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/ObjectNumber.designtime",properties:{number:{type:"string",group:"Data",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null,deprecated:true},emphasized:{type:"boolean",group:"Appearance",defaultValue:true},state:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:u.None},unit:{type:"string",group:"Data",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:o.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:p.Begin},active:{type:"boolean",group:"Misc",defaultValue:false},reactiveAreaMode:{type:"sap.m.ReactiveAreaMode",group:"Appearance",defaultValue:c.Inline},inverted:{type:"boolean",group:"Misc",defaultValue:false},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:l.Off}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{press:{}},dnd:{draggable:true,droppable:false}},renderer:n});d.prototype._getStateText=function(){var e=this.getState(),t=i.getResourceBundleFor("sap.m");return t.getText("OBJECTNUMBER_ARIA_VALUE_STATE_"+e.toUpperCase(),[],true)};d.prototype.getAccessibilityInfo=function(){var e="";if(this.getState()!==u.None){e=this._getStateText()}return{description:(this.getNumber()+" "+this.getUnit()+" "+e).trim()}};d.prototype.ontap=function(e){if(this._isClickable(e)){this.firePress()}};d.prototype.ontouchstart=function(e){if(this._isClickable(e)){e.setMarked()}};d.prototype._activeState=function(){this.addStyleClass("sapMObjectNumberPressed")};d.prototype._inactiveState=function(){this.removeStyleClass("sapMObjectNumberPressed")};d.prototype.onkeydown=function(e){if(e.which===s.SPACE||e.which===s.ENTER){e.setMarked();this._activeState();if(e.which===s.ENTER){this.firePress()}else{e.preventDefault();this._bPressedSpace=true}}else if(this._bPressedSpace){if(e.which===s.SHIFT||e.which===s.ESCAPE){this._bPressedEscapeOrShift=true;this._inactiveState()}else{e.preventDefault()}}};d.prototype.onkeyup=function(e){if(e.which===s.ENTER){e.setMarked();this._inactiveState()}else if(e.which===s.SPACE){if(!this._bPressedEscapeOrShift){e.setMarked();this.firePress();this._inactiveState()}else{this._bPressedEscapeOrShift=false}this._bPressedSpace=false}else if(e.which===s.ESCAPE){this._bPressedSpace=false}};d.prototype._isActive=function(){return this.getActive()&&(this.getNumber().trim()||this.getUnit().trim())};d.prototype._isClickable=function(e){var t=e.target.id;return this._isActive()&&(t===this.getId()+"-link"||t===this.getId()+"-number"||t===this.getId()+"-unit")};d.prototype._hasExternalLabelling=function(){return this.getAriaLabelledBy().length>0||r.getReferencingLabels(this).length>0};d.prototype._generateSelfLabellingIds=function(){var e=this.getId(),t="";if(this.getNumber()){t+=e+"-number "}if(this.getUnit()&&this.getEmptyIndicatorMode()===l.Off){t+=e+"-unit "}if(this.getNumber()&&this.getEmphasized()){t+=e+"-emphasized "}if(this.getNumber()&&this.getState()!==u.None){t+=e+"-state"}return t.trim()};return d});
//# sourceMappingURL=ObjectNumber.js.map