/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Theming","sap/ui/core/library","./library","sap/ui/core/Control","sap/ui/core/Element","sap/m/ToggleButton","sap/ui/core/InvisibleText","sap/m/Toolbar","sap/m/OverflowToolbarLayoutData","sap/m/OverflowToolbarAssociativePopover","sap/m/OverflowToolbarAssociativePopoverControls","sap/ui/core/ResizeHandler","sap/ui/core/IconPool","sap/ui/Device","./OverflowToolbarRenderer","sap/base/Log","sap/ui/core/Lib","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Focusable"],function(t,e,o,i,n,r,s,l,a,h,f,u,d,p,_,c,v,jQuery){"use strict";var C=o.PlacementType;var g=o.ButtonType;var y=e.aria.HasPopup;var b=o.OverflowToolbarPriority;var O=l.extend("sap.m.OverflowToolbar",{metadata:{properties:{asyncMode:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{_overflowButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/OverflowToolbar.designtime"},renderer:_});O.TOGGLE_BUTTON_TOOLTIP="OVERFLOW_TOOLBAR_TOGGLE_BUTTON_TOOLTIP";O.CONTENT_SIZE_TOLERANCE=1;O.prototype._callToolbarMethod=function(t,e){return l.prototype[t].apply(this,e)};O.prototype.init=function(){this._callToolbarMethod("init",arguments);this._iPreviousToolbarWidth=null;this._bOverflowButtonNeeded=false;this._bListenForControlPropertyChanges=false;this._bListenForInvalidationEvents=false;this._bControlsInfoCached=false;this._bSkipOptimization=false;this._aControlSizes={};this._iFrameRequest=null;this._iOverflowToolbarButtonSize=0;this._oOverflowToolbarButtonClone=null;this._iToolbarOnlyContentSize=0;this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aPopoverOnlyControls=[];this._aAllCollections=[this._aMovableControls,this._aToolbarOnlyControls,this._aPopoverOnlyControls];this.addStyleClass("sapMOTB");this._fnMediaChangeRef=this._fnMediaChange.bind(this);p.media.attachHandler(this._fnMediaChangeRef);this._handleKeyNavigationBound=this._handleKeyNavigation.bind(this)};O.prototype.exit=function(){var t=this.getAggregation("_popover");if(t){t.destroy()}if(this._oOverflowToolbarButtonClone){this._oOverflowToolbarButtonClone.destroy()}if(this._iFrameRequest){window.cancelAnimationFrame(this._iFrameRequest);this._iFrameRequest=null}p.media.detachHandler(this._fnMediaChangeRef)};O.prototype.enhanceAccessibilityState=function(t,e){l.prototype.enhanceAccessibilityState.apply(this,arguments);if(t===this.getAggregation("_overflowButton")){this._enhanceOverflowButtonAccessibility(e)}};O.prototype._enhanceOverflowButtonAccessibility=function(t){var e=this.getAggregation("_popover"),o=this.getAggregation("_overflowButton");if(!o){return}t.expanded=o.getPressed();delete t.pressed;if(e&&e.getDomRef()){t.controls=e.getId()}};O.prototype.setAsyncMode=function(t){return this.setProperty("asyncMode",t,true)};O.prototype.onBeforeRendering=function(){if(!this.getDomRef()){this._bControlsInfoCached=false}};O.prototype.onAfterRendering=function(){this._bInvalidatedAndNotRendered=false;if(this._bContentVisibilityChanged){this._bControlsInfoCached=false;this._bContentVisibilityChanged=false}if(this.getAsyncMode()){this._doLayoutAsync().then(this._applyFocus.bind(this))}else{this._doLayout();this._applyFocus()}if(this.getDomRef()){this.getDomRef().removeEventListener("keydown",this._handleKeyNavigationBound);this.getDomRef().addEventListener("keydown",this._handleKeyNavigationBound)}};O.prototype.onsapfocusleave=function(){this._resetChildControlFocusInfo()};O.prototype.onfocusfail=function(t){const e=t.srcControl;const o=this._getOverflowButton();const i=this.getDomRef();if(!i.contains(e.getDomRef())){o?.focus();this._bControlWasFocused=false;this._bOverflowButtonWasFocused=!!o;this.sFocusedChildControlId=""}else{const t=this.getContent();const n=t.indexOf(e);if(n!==-1){let e;for(let o=n+1;o<t.length;o++){const n=t[o].getFocusDomRef?.();if(i.contains(n)&&jQuery.expr.pseudos.sapTabbable(n)){e=t[o];break}}e??=o;e?.focus();this._bControlWasFocused=!o;this._bOverflowButtonWasFocused=!!o;this.sFocusedChildControlId=e===o?"":e.getId()}}};O.prototype.setWidth=function(t){this.setProperty("width",t);this._bResized=true;return this};O.prototype._doLayout=function(){var t;this._recalculateOverflowButtonSize();t=this.$().is(":visible")?this.$().width():0;this._bListenForControlPropertyChanges=false;this._bListenForInvalidationEvents=false;this._deregisterToolbarResize();if(this._iPreviousToolbarWidth!==t){this._bResized=true}if(t>0){if(!this._isControlsInfoCached()||this._bNeedUpdateOnControlsCachedSizes&&this._bResized){this._cacheControlsInfo()}if(this._iPreviousToolbarWidth!==t){this._iPreviousToolbarWidth=t;this._setControlsOverflowAndShrinking(t);this.fireEvent("_controlWidthChanged")}}else{this._iPreviousToolbarWidth=t}this._registerToolbarResize();this._bListenForControlPropertyChanges=true;this._bListenForInvalidationEvents=true;this._bResized=false};O.prototype._doLayoutAsync=function(){return new Promise(function(t,e){this._iFrameRequest=window.requestAnimationFrame(function(){this._doLayout();t()}.bind(this))}.bind(this))};O.prototype._applyFocus=function(){var t,e=this.$().lastFocusableDomRef();if(this.sFocusedChildControlId){t=n.getElementById(this.sFocusedChildControlId)}if(t&&t.getDomRef()){t.focus()}else if(this._bControlWasFocused){this._getOverflowButton().focus();this._bControlWasFocused=false;this._bOverflowButtonWasFocused=true}else if(this._bOverflowButtonWasFocused){if(this._getOverflowButtonNeeded()){this._getOverflowButton().focus()}else{e&&e.focus();this._bOverflowButtonWasFocused=false}}};O.prototype._preserveChildControlFocusInfo=function(){var t=n.closestTo(document.activeElement);var e=t?t.getId():null;if(this._getControlsIds().indexOf(e)!==-1){this._bControlWasFocused=true;this.sFocusedChildControlId=e}else if(e===this._getOverflowButton().getId()){this._bOverflowButtonWasFocused=true;this.sFocusedChildControlId=""}};O.prototype._resetChildControlFocusInfo=function(){this._bControlWasFocused=false;this._bOverflowButtonWasFocused=false;this.sFocusedChildControlId=""};O.prototype._registerToolbarResize=function(){if(l.isRelativeWidth(this.getWidth())){var t=this._handleResize.bind(this);this._sResizeListenerId=u.register(this,t)}};O.prototype._deregisterToolbarResize=function(){if(this._sResizeListenerId){u.deregister(this._sResizeListenerId);this._sResizeListenerId=""}};O.prototype._handleResize=function(){this._bResized=true;if(this._bInvalidatedAndNotRendered){return}this._callDoLayout()};O.prototype._fnMediaChange=function(){this._bControlsInfoCached=false;this._iPreviousToolbarWidth=null;this._callDoLayout()};O.prototype._callDoLayout=function(){if(this.getAsyncMode()){this._doLayoutAsync()}else{this._doLayout()}};O.prototype._cacheControlsInfo=function(){var t,e,o=parseInt(this.$().css("padding-right"))||0,i=parseInt(this.$().css("padding-left"))||0,n=this._getOverflowButtonSize(),r=this._iToolbarOnlyContentSize;this._iOldContentSize=this._iContentSize;this._iContentSize=0;this._iToolbarOnlyContentSize=0;this._bNeedUpdateOnControlsCachedSizes=false;this.getContent().forEach(this._updateControlsCachedSizes,this);if(r!==this._iToolbarOnlyContentSize){this.fireEvent("_minWidthChange",{minWidth:this._iToolbarOnlyContentSize>0?this._iToolbarOnlyContentSize+n:0})}if(p.system.phone){this._iContentSize-=1}if(this._aPopoverOnlyControls.length){t=this._aPopoverOnlyControls.filter(function(t){return t.getVisible()});e=t.length>0;if(e){this._iContentSize+=n}}this._bControlsInfoCached=true;if(this._iOldContentSize!==this._iContentSize){this.fireEvent("_contentSizeChange",{contentSize:this._iContentSize+o+i+1})}};O.prototype._updateControlsCachedSizes=function(t){var e,o,i;e=this._getControlPriority(t);o=this._calculateControlSize(t);this._aControlSizes[t.getId()]=o;i=l.getOrigWidth(t.getId());if(i&&l.isRelativeWidth(i)){this._bNeedUpdateOnControlsCachedSizes=true}if(e!==b.AlwaysOverflow){this._iContentSize+=o}if(e===b.NeverOverflow){this._iToolbarOnlyContentSize+=o}};O.prototype._calculateControlSize=function(t){return this._getOptimalControlWidth(t,this._aControlSizes[t.getId()])};O.prototype._isControlsInfoCached=function(){return this._bControlsInfoCached};O.prototype._flushButtonsToPopover=function(){this._aButtonsToMoveToPopover.forEach(this._moveButtonToPopover,this)};O.prototype._invalidateIfHashChanged=function(t){if(typeof t==="undefined"||this._getPopover()._getContentIdsHash()!==t){this._preserveChildControlFocusInfo();this.invalidate()}};O.prototype._addOverflowButton=function(){if(!this._getOverflowButtonNeeded()){this._iCurrentContentSize+=this._getOverflowButtonSize();this._setOverflowButtonNeeded(true)}};O.prototype._aggregateMovableControls=function(){var t={},e=[],o,i,n,r,s;this._aMovableControls.forEach(function(l){o=O._getControlGroup(l);i=O._oPriorityOrder;if(o){n=this._getControlPriority(l);r=this._getControlIndex(l);t[o]=t[o]||[];s=t[o];s.unshift(l);if(!s._priority||i[s._priority]<i[n]){s._priority=n}if(!s._index||s._index<r){s._index=r}}else{e.push(l)}},this);Object.keys(t).forEach(function(o){e.push(t[o])});return e};O.prototype._extractControlsToMoveToOverflow=function(t,e){var o,i;for(o=0;o<t.length;o++){i=t[o];if(i.length){i.forEach(this._addToPopoverArrAndUpdateContentSize,this)}else{this._addToPopoverArrAndUpdateContentSize(i)}if(this._getControlPriority(i)!==b.Disappear&&!i.isA?.("sap.m.ToolbarSeparator")){this._addOverflowButton()}if(this._iCurrentContentSize<=e){break}}};O.prototype._addToPopoverArrAndUpdateContentSize=function(t){this._aButtonsToMoveToPopover.unshift(t);this._iCurrentContentSize-=this._aControlSizes[t.getId()]};O.prototype._sortByPriorityAndIndex=function(t,e){var o=O._oPriorityOrder,i=this._getControlPriority(t),n=this._getControlPriority(e),r=o[i]-o[n];if(r!==0){return r}else{return this._getControlIndex(e)-this._getControlIndex(t)}};O.prototype._setControlsOverflowAndShrinking=function(t){var e;this._iCurrentContentSize=this._iContentSize;this._aButtonsToMoveToPopover=[];if(this._bSkipOptimization){this._bSkipOptimization=false}else{e=this._getPopover()._getContentIdsHash()}this._resetToolbar();this._collectPopoverOnlyControls();this._markControlsWithShrinkableLayoutData();if(this._iCurrentContentSize<=t+O.CONTENT_SIZE_TOLERANCE){this._flushButtonsToPopover();this._invalidateIfHashChanged(e);return}this._moveControlsToPopover(t);this._flushButtonsToPopover();if(this._iCurrentContentSize>t){this._checkContents()}this._invalidateIfHashChanged(e)};O.prototype._markControlsWithShrinkableLayoutData=function(){this.getContent().forEach(this._markControlWithShrinkableLayoutData,this)};O.prototype._collectPopoverOnlyControls=function(){var t=this._aPopoverOnlyControls.length,e,o;if(t){for(e=t-1;e>=0;e--){o=this._aPopoverOnlyControls[e];if(o.getVisible()){this._aButtonsToMoveToPopover.unshift(o)}}if(this._aButtonsToMoveToPopover.length>0){this._setOverflowButtonNeeded(true)}}};O.prototype._moveControlsToPopover=function(t){var e=[];if(this._aMovableControls.length){e=this._aggregateMovableControls();e.sort(this._sortByPriorityAndIndex.bind(this));this._extractControlsToMoveToOverflow(e,t)}};O.prototype._markControlWithShrinkableLayoutData=function(t){var e,o,i,n;t.removeStyleClass(l.shrinkClass);e=l.getOrigWidth(t.getId());if(!l.isRelativeWidth(e)){return}o=t.getLayoutData();i=o&&o.isA("sap.m.ToolbarLayoutData")&&o.getShrinkable();n=t.isA("sap.m.Breadcrumbs");if(i||n){t.addStyleClass(l.shrinkClass)}};O.prototype._resetToolbar=function(){this._getPopover().close();this._getPopover()._getAllContent().forEach(this._restoreButtonInToolbar,this);this._setOverflowButtonNeeded(false);this.getContent().forEach(this._removeShrinkingClass)};O.prototype._removeShrinkingClass=function(t){t.removeStyleClass(l.shrinkClass)};O.prototype._moveButtonToPopover=function(t){this._getPopover().addAssociatedContent(t)};O.prototype._restoreButtonInToolbar=function(t){if(typeof t==="object"){t=t.getId()}this._getPopover().removeAssociatedContent(t)};O.prototype._resetAndInvalidateToolbar=function(t){if(this._bIsBeingDestroyed){return}this._resetToolbar();this._bControlsInfoCached=false;this._iPreviousToolbarWidth=null;if(t){this._bSkipOptimization=true}if(this.$().length){this._preserveChildControlFocusInfo();this.invalidate()}};O.prototype.invalidate=function(){this._bInvalidatedAndNotRendered=true;i.prototype.invalidate.apply(this,arguments)};O.prototype._getVisibleContent=function(){var t=this.getContent(),e=this._getPopover()._getAllContent();return t.filter(function(t){return e.indexOf(t)===-1})};O.prototype._getVisibleAndNonOverflowContent=function(){return this._getVisibleContent().filter(function(t){return t.getVisible()})};O.prototype._getToggleButton=function(t){return new r({ariaHasPopup:y.Menu,id:this.getId()+t,icon:d.getIconURI("overflow"),press:this._overflowButtonPressed.bind(this),tooltip:v.getResourceBundleFor("sap.m").getText(O.TOGGLE_BUTTON_TOOLTIP),type:g.Transparent})};O.prototype._getOverflowButton=function(){var t;if(!this.getAggregation("_overflowButton")){t=this._getToggleButton("-overflowButton");this.setAggregation("_overflowButton",t,true)}return this.getAggregation("_overflowButton")};O.prototype._getOverflowButtonClone=function(){if(!this._oOverflowToolbarButtonClone){this._oOverflowToolbarButtonClone=this._getToggleButton("-overflowButtonClone").addStyleClass("sapMTBHiddenElement")}this._oOverflowToolbarButtonClone._getTooltip=function(){return""};this._oOverflowToolbarButtonClone.removeAllAssociation("ariaLabelledBy");return this._oOverflowToolbarButtonClone};O.prototype._overflowButtonPressed=function(t){var e=this._getPopover(),o=this._getBestPopoverPlacement();if(e.getPlacement()!==o){e.setPlacement(o)}if(e.isOpen()){e.close()}else{e.openBy(t.getSource())}};O.prototype._getPopover=function(){var t;if(!this.getAggregation("_popover")){t=new h(this.getId()+"-popover",{showHeader:false,showArrow:false,modal:false,horizontalScrolling:p.system.phone?false:true,contentWidth:p.system.phone?"100%":"auto",offsetY:this._detireminePopoverVerticalOffset(),ariaLabelledBy:s.getStaticId("sap.m","INPUT_AVALIABLE_VALUES")});t._adaptPositionParams=function(){h.prototype._adaptPositionParams.call(this);this._myPositions=["end top","begin center","end bottom","end center"];this._atPositions=["end bottom","end center","end top","begin center"]};if(p.system.phone){t.attachBeforeOpen(this._shiftPopupShadow,this)}t.attachAfterClose(this._popOverClosedHandler,this);this.setAggregation("_popover",t,true)}return this.getAggregation("_popover")};O.prototype._shiftPopupShadow=function(){var t=this._getPopover(),e=t.getCurrentPosition();if(e===C.Bottom){t.addStyleClass("sapMOTAPopoverNoShadowTop");t.removeStyleClass("sapMOTAPopoverNoShadowBottom")}else if(e===C.Top){t.addStyleClass("sapMOTAPopoverNoShadowBottom");t.removeStyleClass("sapMOTAPopoverNoShadowTop")}};O.prototype._popOverClosedHandler=function(){this._getOverflowButton().setPressed(false);if(n.closestTo(document.activeElement)){return}this._getOverflowButton().focus()};O.prototype._getOverflowButtonNeeded=function(){return this._bOverflowButtonNeeded};O.prototype._setOverflowButtonNeeded=function(t){if(this._bOverflowButtonNeeded!==t){this._bOverflowButtonNeeded=t}return this};O.prototype._getToolbarInteractiveControls=function(){var t=this._getVisibleContent(),e=t.filter(function(t){return this._getControlPriority(t)!==b.AlwaysOverflow&&t.isA("sap.m.IToolbarInteractiveControl")&&typeof t._getToolbarInteractive==="function"&&t._getToolbarInteractive()},this);e.push(this._getOverflowButton());return e};O.prototype._getToolbarInteractiveControlsCount=function(){var t=this._getVisibleAndNonOverflowContent().filter(function(t){return this._getControlPriority(t)!==b.AlwaysOverflow&&t.isA("sap.m.IToolbarInteractiveControl")&&typeof t._getToolbarInteractive==="function"&&t._getToolbarInteractive()},this);return this._getOverflowButtonNeeded()?t.length+1:t.length};O.prototype._updateContentInfoInControlsCollections=function(){this.getContent().forEach(function(t){if(t){this._removeContentFromControlsCollections(t);this._moveControlInSuitableCollection(t,this._getControlPriority(t))}},this)};O.prototype._moveControlInSuitableCollection=function(t,e){var o=e!==b.NeverOverflow,i=e===b.AlwaysOverflow;if(f.supportsControl(t)&&i){this._aPopoverOnlyControls.push(t)}else{if(f.supportsControl(t)&&o&&t.getVisible()){this._aMovableControls.push(t)}else{this._aToolbarOnlyControls.push(t)}}};O.prototype._removeContentFromControlsCollections=function(t){var e,o,i;for(e=0;e<this._aAllCollections.length;e++){o=this._aAllCollections[e];i=o.indexOf(t);if(i!==-1){o.splice(i,1)}}};O.prototype._clearAllControlsCollections=function(){this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aPopoverOnlyControls=[];this._aAllCollections=[this._aMovableControls,this._aToolbarOnlyControls,this._aPopoverOnlyControls]};O.prototype.onLayoutDataChange=function(t){this._resetAndInvalidateToolbar(true);t&&this._updateContentInfoInControlsCollections()};O.prototype.addContent=function(t){this._registerControlListener(t);this._resetAndInvalidateToolbar(false);if(t){this._moveControlInSuitableCollection(t,this._getControlPriority(t))}this._informNewFlexibleContentAdded(t);return this._callToolbarMethod("addContent",arguments)};O.prototype.insertContent=function(t,e){this._registerControlListener(t);this._resetAndInvalidateToolbar(false);if(t){this._moveControlInSuitableCollection(t,this._getControlPriority(t))}this._informNewFlexibleContentAdded(t);return this._callToolbarMethod("insertContent",arguments)};O.prototype.removeContent=function(){var t=this._callToolbarMethod("removeContent",arguments);if(t){this._getPopover().removeAssociatedContent(t.getId())}this._resetAndInvalidateToolbar(false);this._deregisterControlListener(t);this._removeContentFromControlsCollections(t);return t};O.prototype.removeAllContent=function(){var t=this._callToolbarMethod("removeAllContent",arguments);t.forEach(this._deregisterControlListener,this);t.forEach(this._removeContentFromControlsCollections,this);this._resetAndInvalidateToolbar(false);this._clearAllControlsCollections();return t};O.prototype.destroyContent=function(){this._resetAndInvalidateToolbar(false);setTimeout(function(){this._resetAndInvalidateToolbar(false)}.bind(this),0);this._clearAllControlsCollections();return this._callToolbarMethod("destroyContent",arguments)};O.prototype._informNewFlexibleContentAdded=function(t){if(t&&t.isA("sap.m.IOverflowToolbarFlexibleContent")){this.fireEvent("_contentSizeChange",{contentSize:null})}};O.prototype._registerControlListener=function(t){var e;if(t){t.attachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);if(t.isA("sap.m.IOverflowToolbarContent")){e=t.getOverflowToolbarConfig().invalidationEvents;if(e&&Array.isArray(e)){e.forEach(function(e){t.attachEvent(e,this._onInvalidationEventFired,this)},this)}}}};O.prototype._deregisterControlListener=function(t){var e;if(t){t.detachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);if(t.isA("sap.m.IOverflowToolbarContent")){e=t.getOverflowToolbarConfig().invalidationEvents;if(e&&Array.isArray(e)){e.forEach(function(e){t.detachEvent(e,this._onInvalidationEventFired,this)},this)}}}};O.prototype._onContentPropertyChangedOverflowToolbar=function(t){var e=t.getSource(),o,i;this._updateContentInfoInControlsCollections();if(!this._bListenForControlPropertyChanges){return}o=f.getControlConfig(e);i=t.getParameter("name");if(i!=="visible"&&!e.getVisible()){return}if(typeof o!=="undefined"&&o.noInvalidationProps.indexOf(i)!==-1){return}if(i==="visible"){this._bContentVisibilityChanged=true}if(e.isA("sap.m.IOverflowToolbarFlexibleContent")&&e.getVisible()){this.fireEvent("_contentSizeChange",{contentSize:null})}this._resetAndInvalidateToolbar(true)};O.prototype._onInvalidationEventFired=function(t){var e=t.getSource();if(!this._bListenForInvalidationEvents){return}if(e.isA("sap.m.IOverflowToolbarFlexibleContent")){this.fireEvent("_contentSizeChange",{contentSize:null})}this._resetAndInvalidateToolbar(true)};O.prototype._getOverflowButtonSize=function(){return this._iOverflowToolbarButtonSize};O.prototype._getBestPopoverPlacement=function(){var t=this.getHTMLTag();if(t==="Footer"){return C.Top}else if(t==="Header"){return C.Bottom}return C.Vertical};O.prototype._getControlsIds=function(){return this.getContent().map(function(t){return t.getId()})};O.prototype._getControlIndex=function(t){return t.length?t._index:this.indexOfContent(t)};O.prototype._getOptimalControlWidth=function(t,e){var o,i=t.getLayoutData(),n=i&&i.isA("sap.m.ToolbarLayoutData"),r=t.getVisible(),s=t.isA("sap.m.Breadcrumbs"),l=false,a,h;if(s){l=true}else if(n){l=i.getShrinkable()}a=l?this._getMinWidthOfShrinkableControl(t):0;if(t.isA("sap.m.ToolbarSpacer")){h=parseInt(t.$().css("width"));a=t.getWidth()&&h?h:0;o=O._getOptimalWidthOfShrinkableControl(t,a)}else if(l&&a>0&&r){o=O._getOptimalWidthOfShrinkableControl(t,a)}else{o=r?O._getControlWidth(t):0}if(o===null){o=typeof e!=="undefined"?e:0}return o};O.prototype._getMinWidthOfShrinkableControl=function(t){var e=t.$().css("min-width"),o=parseInt(e),i=l.isRelativeWidth(e);if(i){return o*this.$().width()/100}else{return o}};O.prototype._getControlPriority=function(t){var e,o,i,n;if(t.length){return t._priority}e=t.getMetadata().getInterfaces().indexOf("sap.m.IOverflowToolbarContent")>-1;n=e&&t.getOverflowToolbarConfig().getCustomImportance;if(e&&typeof n==="function"){return n()}o=t.getLayoutData&&t.getLayoutData();if(o&&o instanceof a){if(o.getMoveToOverflow()===false){return b.NeverOverflow}if(o.getStayInOverflow()===true){return b.AlwaysOverflow}i=o.getPriority();if(i===b.Never){return b.NeverOverflow}if(i===b.Always){return b.AlwaysOverflow}return i}return b.High};O._getControlMargins=function(t){return t.$().outerWidth(true)-t.$().outerWidth()};O._getOptimalWidthOfShrinkableControl=function(t,e){return e+O._getControlMargins(t)};O._getControlWidth=function(t){var e=t&&t.getDomRef();if(e&&t.$().is(":visible")){return Math.round(e.getBoundingClientRect().width+O._getControlMargins(t))}return null};O.prototype.getAccessibilityInfo=function(){var t=[],e=this._getVisibleAndNonOverflowContent();if(e.length>0){t=t.concat(e)}if(this._getOverflowButtonNeeded()){t.push(this._getOverflowButton())}return{children:t}};O._getControlGroup=function(t){var e=t.getLayoutData();if(e instanceof a){return e.getGroup()}};O._oPriorityOrder=function(){var t={};t[b.Disappear]=1;t[b.Low]=2;t["Medium"]=3;t[b.High]=4;return t}();O.prototype._detireminePopoverVerticalOffset=function(){return this.$().parents().hasClass("sapUiSizeCompact")?2:3};O.prototype._recalculateOverflowButtonSize=function(){var t=this._getOverflowButtonClone().$(),e;if(!this._getOverflowButtonSize()&&t.width()>0){e=t.outerWidth(true);this._iOverflowToolbarButtonSize=e?e:0}};O.prototype.onThemeChanged=function(){this._resetAndInvalidateToolbar();this._iOverflowToolbarButtonSize=0;this._recalculateOverflowButtonSize();for(var t in this._aControlSizes){if(this._aControlSizes.hasOwnProperty(t)){this._aControlSizes[t]=0}}};O.prototype.closeOverflow=function(){this._getPopover().close()};return O});
//# sourceMappingURL=OverflowToolbar.js.map