/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","./P13nConditionPanel","./P13nPanel","./P13nGroupItem","sap/ui/core/Lib","sap/ui/thirdparty/jquery"],function(e,t,o,i,n,jQuery){"use strict";var r=e.P13nPanelType;var a=e.P13nConditionOperation;var s=o.extend("sap.m.P13nGroupPanel",{metadata:{deprecated:true,library:"sap.m",properties:{maxGroups:{type:"string",group:"Misc",defaultValue:"-1"},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},groupItems:{type:"sap.m.P13nGroupItem",multiple:true,singularName:"groupItem",bindable:"bindable"}},events:{addGroupItem:{parameters:{}},removeGroupItem:{},updateGroupItem:{}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("section",t);e.class("sapMGroupPanel");e.openEnd();e.openStart("div");e.class("sapMGroupPanelContent");e.class("sapMGroupPanelBG");e.openEnd();t.getAggregation("content").forEach(function(t){e.renderControl(t)});e.close("div");e.close("section")}}});s.prototype.setMaxGroups=function(e){this.setProperty("maxGroups",e);if(this._oGroupPanel){this._oGroupPanel.setMaxConditions(e)}return this};s.prototype._getConditions=function(){return this._oGroupPanel.getConditions()};s.prototype.setContainerQuery=function(e){this.setProperty("containerQuery",e);this._oGroupPanel.setContainerQuery(e);return this};s.prototype.setLayoutMode=function(e){this.setProperty("layoutMode",e);this._oGroupPanel.setLayoutMode(e);return this};s.prototype.validateConditions=function(){return this._oGroupPanel.validateConditions()};s.prototype.removeInvalidConditions=function(){this._oGroupPanel.removeInvalidConditions()};s.prototype.removeValidationErrors=function(){this._oGroupPanel.removeValidationErrors()};s.prototype.onBeforeNavigationFrom=function(){return this.validateConditions()};s.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions()};s.prototype.setOperations=function(e){this._aOperations=e;if(this._oGroupPanel){this._oGroupPanel.setOperations(this._aOperations)}};s.prototype.init=function(){this.setType(r.group);this.setTitle(n.getResourceBundleFor("sap.m").getText("GROUPPANEL_TITLE"));this._aKeyFields=[];if(!this._aOperations){this.setOperations([a.GroupAscending,a.GroupDescending])}this._oGroupPanel=new t({maxConditions:this.getMaxGroups(),autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange(),validationExecutor:jQuery.proxy(this._callValidationExecutor,this)});this._oGroupPanel.setOperations(this._aOperations);this._oGroupPanel._sAddRemoveIconTooltipKey="GROUP";this.addAggregation("content",this._oGroupPanel)};s.prototype.exit=function(){var e=function(e){if(e&&e.destroy){e.destroy()}return null};this._aKeyFields=e(this._aKeyFields);this._aOperations=e(this._aOperations)};s.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var e=[];var t=(this.getBindingInfo("items")||{}).model;this.getItems().forEach(function(o){var i=o.getBindingContext(t);if(o.getBinding("key")){i.getObject()[o.getBinding("key").getPath()]=o.getKey()}e.push({key:o.getColumnKey(),text:o.getText(),tooltip:o.getTooltip()})});e.splice(0,0,{key:null,text:n.getResourceBundleFor("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oGroupPanel.setKeyFields(e);var o=[];t=(this.getBindingInfo("groupItems")||{}).model;this.getGroupItems().forEach(function(e){var i=e.getBindingContext(t);if(e.getBinding("key")){i.getObject()[e.getBinding("key").getPath()]=e.getKey()}o.push({key:e.getKey(),keyField:e.getColumnKey(),operation:e.getOperation(),showIfGrouped:e.getShowIfGrouped()})});this._oGroupPanel.setConditions(o)}};s.prototype.addItem=function(e){o.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true}return this};s.prototype.removeItem=function(e){var t=o.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true}return t};s.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true}return this};s.prototype.addGroupItem=function(e){this.addAggregation("groupItems",e,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true}return this};s.prototype.insertGroupItem=function(e,t){this.insertAggregation("groupItems",e,t,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true}return this};s.prototype.updateGroupItems=function(e){this.updateAggregation("groupItems");if(e==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate()}};s.prototype.removeGroupItem=function(e){e=this.removeAggregation("groupItems",e,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true}return e};s.prototype.removeAllGroupItems=function(){var e=this.removeAllAggregation("groupItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true}return e};s.prototype.destroyGroupItems=function(){this.destroyAggregation("groupItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true}return this};s.prototype._handleDataChange=function(){var e=this;return function(t){var o=t.getParameter("newData");var n=t.getParameter("operation");var r=t.getParameter("key");var a=t.getParameter("index");var s;if(n==="update"){s=e.getGroupItems()[a];if(s){s.setColumnKey(o.keyField);s.setOperation(o.operation);s.setShowIfGrouped(o.showIfGrouped)}e.fireUpdateGroupItem({key:r,index:a,groupItemData:s});e._notifyChange()}if(n==="add"){s=new i({key:r,columnKey:o.keyField,operation:o.operation,showIfGrouped:o.showIfGrouped});e._bIgnoreBindCalls=true;e.fireAddGroupItem({key:r,index:a,groupItemData:s});e._bIgnoreBindCalls=false;e._notifyChange()}if(n==="remove"){e._bIgnoreBindCalls=true;e.fireRemoveGroupItem({key:r,index:a});e._bIgnoreBindCalls=false;e._notifyChange()}}};s.prototype.getOkPayload=function(){if(!this.getModel()){return null}var e=[];this._oGroupPanel._oConditionsGrid.getContent().forEach(function(t){var o=t.keyField;e.push(o.getSelectedKey())});return{selectedColumnKeys:e}};s.prototype._callValidationExecutor=function(){var e=this.getValidationExecutor();if(e){e()}};s.prototype._updateValidationResult=function(e){this._oGroupPanel._oConditionsGrid.getContent().forEach(function(t){var o=t.keyField;o.setValueStateText("");o.setValueState("None");var i=o.getSelectedKey();e.forEach(function(e){if(e.columnKey===i){o.setValueStateText(e.messageText);o.setValueState(e.messageType)}})})};s.prototype.setValidationListener=function(e){this.setProperty("validationListener",e);if(e){e(this,jQuery.proxy(this._updateValidationResult,this))}return this};s.prototype._notifyChange=function(){var e=this.getChangeNotifier();if(e){e(this)}};return s});
//# sourceMappingURL=P13nGroupPanel.js.map