/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/Device","sap/m/PDFViewerRenderManager","sap/m/PDFViewerRenderer","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery","sap/ui/core/Lib"],function(e,t,r,o,i,s,n,jQuery,a){"use strict";var l=e.PDFViewerDisplayType;var p=t.extend("sap.m.PDFViewer",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},source:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},errorMessage:{type:"string",group:"Misc",defaultValue:null,deprecated:true},errorPlaceholderMessage:{type:"string",group:"Misc",defaultValue:null},popupHeaderTitle:{type:"string",group:"Misc",defaultValue:null,deprecated:true},title:{type:"string",group:"Misc",defaultValue:null},showDownloadButton:{type:"boolean",group:"Misc",defaultValue:true},displayType:{type:"sap.m.PDFViewerDisplayType",group:"Misc",defaultValue:l.Auto},isTrustedSource:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{errorPlaceholder:{type:"sap.ui.core.Control",multiple:false},popupButtons:{type:"sap.m.Button",multiple:true,singularName:"popupButton"},_illustratedMessage:{type:"sap.m.IllustratedMessage",multiple:false,visibility:"hidden"},_nonTrustedIllustratedMessage:{type:"sap.m.IllustratedMessage",multiple:false,visibility:"hidden"}},events:{loaded:{},error:{parameters:{target:{type:"any"}}},sourceValidationFailed:{}}},renderer:i});p.prototype.init=function(){this._objectsRegister={};this._bIsPopupOpen=false;this._isError=false;this._initPopupControl();this._initPopupDownloadButtonControl();this._initErrorPlaceholderIllustratedMessageControl();this._initToolbarDownloadButtonControl();this._initOverflowToolbarControl();this._initControlState()};p.prototype._initControlState=function(){this._bRenderPdfContent=true};p.prototype.setWidth=function(e){this.setProperty("width",e,true);var t=this.$();if(t===null){return this}t.css("width",this._getRenderWidth());return this};p.prototype.setHeight=function(e){this.setProperty("height",e,true);var t=this.$();if(t===null){return this}t.css("height",this._getRenderHeight());return this};p.prototype.onBeforeRendering=function(){try{var e=this._getIframeDOMElement();e.remove()}catch(e){s.info(e)}};p.prototype.onAfterRendering=function(){var e=function(){var e=this._getIframeDOMElement();e.on("load",this._onLoadListener.bind(this));e.on("error",this._onErrorListener.bind(this))}.bind(this);try{this.setBusy(true);e()}catch(e){s.info(e);if(this._isError){this._isError=false;this._objectsRegister.getErrorPlaceholderIllustratedMessageControl().invalidate()}this.setBusy(false)}};p.prototype._fireErrorEvent=function(e){this._renderErrorState();this.fireError({target:e||null})};p.prototype._renderErrorState=function(){var e=this._objectsRegister.getToolbarDownloadButtonControl();e.setEnabled(false);var e=this._objectsRegister.getPopupDownloadButtonControl();e.setEnabled(false);this.setBusy(false);this._bRenderPdfContent=false;t.prototype.invalidate.call(this)};p.prototype._fireLoadedEvent=function(){this._bRenderPdfContent=true;this.setBusy(false);try{this._getIframeDOMElement().removeClass("sapMPDFViewerLoading")}catch(e){s.fatal("Iframe not found in loaded event");s.fatal(e)}this.fireEvent("loaded")};p.prototype._getHeaderInfo=function(e,t){return new Promise((r,o)=>{const i=new XMLHttpRequest;i.open(t,e,false);i.onload=()=>{const e=i.status;if(e===200){const e=i.getAllResponseHeaders().toLowerCase().trim();const t=e.split("\n");const o=[];for(let e=0;e<t.length;e++){const r=t[e].split(": ");o[r[0].trim()]=r[1].trim()}r(o["content-type"])}else{o(new Error(`Error in fetching header with method ${t}, status ${i.status} and statusText ${i.statusText}`))}};i.onerror=e=>{o(new Error(`Error in fetching header with method ${t}, status ${i.status}, statusText ${i.statusText} and error ${e}`))};i.send(null)})};p.prototype._onLoadListener=function(e){try{const n=jQuery(e.target);let a=true,l="";try{var t=n[0]?.contentWindow?.document?.body?.children}catch(e){if(r.browser.firefox){t=[]}}if(t?.length){try{var o=n[0].contentWindow.document.embeds;a=!!o&&o.length===1;if(a){l=o[0].attributes.getNamedItem("type").value}}catch(e){if(!r.browser.firefox&&this.fireEvent("sourceValidationFailed",{},true)){this._fireLoadedEvent();return}}if(a&&i._isSupportedMimeType(l)&&i._isPdfPluginEnabled()){this._fireLoadedEvent()}else{this._fireErrorEvent(e.target)}}else{const t="HEAD";this._getHeaderInfo(this._sParametrizedSource,t).then(t=>{if(i._isSupportedMimeType(t)&&i._isPdfPluginEnabled()){this._fireLoadedEvent()}else{this._fireErrorEvent(e.target)}}).catch(t=>{this._fireErrorEvent(e.target);s.fatal(t);this.fireEvent("sourceValidationFailed",{},true)})}}catch(t){this._fireErrorEvent(e.target);s.fatal(false,"Fatal error during the handling of load event happened.");s.fatal(false,t.message)}};p.prototype._onErrorListener=function(){this._fireErrorEvent()};p.prototype.downloadPDF=function(){var e=window.open(this.getSource());e.opener=null;e.focus()};p.prototype._onAfterPopupClose=function(e){var t=this._objectsRegister.getPopup();t.removeAllContent();this._bIsPopupOpen=false};p.prototype._shouldRenderPdfContent=function(){return i._isPdfPluginEnabled()&&this._bRenderPdfContent&&this._isSourceValidToDisplay()};p.prototype._isSourceValidToDisplay=function(){var e=this.getSource();return e!==null&&e!==""&&typeof e!=="undefined"};p.prototype.invalidate=function(e){this._initControlState();t.prototype.invalidate.call(this,e)};p.prototype.open=function(){if(!this._isSourceValidToDisplay()){n(false,"The PDF file cannot be opened with the given source. Given source: "+this.getSource());return}else if(!i._isPdfPluginEnabled()){s.warning("The PDF plug-in is not available on this device.")}if(this._isEmbeddedModeAllowed()&&this.getIsTrustedSource()){this._openOnDesktop()}else{this._openOnMobile()}};p.prototype._openOnDesktop=function(){var e=this._objectsRegister.getPopup();if(this._bIsPopupOpen){return}this._initControlState();this._preparePopup(e);e.addContent(this);this._bIsPopupOpen=true;e.open()};p.prototype._openOnMobile=function(){var e=window.open(this.getSource());e.opener=null;e.focus()};p.prototype._getIframeDOMElement=function(){var e=this.$("iframe");if(e.length===0){throw Error("Underlying iframe was not found in DOM.")}if(e.length>1){s.fatal("Initialization of iframe fails. Reason: the control somehow renders multiple iframes")}return e};p.prototype._isEmbeddedModeAllowed=function(){return this._isDisplayTypeAuto()?r.system.desktop:this._isDisplayTypeEmbedded()};p.prototype._isDisplayTypeAuto=function(){return this.getDisplayType()===l.Auto};p.prototype._isDisplayTypeEmbedded=function(){return this.getDisplayType()===l.Embedded};p.prototype._isDisplayTypeLink=function(){return this.getDisplayType()===l.Link};p.prototype._isDisplayDownloadButton=function(){return this.getShowDownloadButton()||this._isDisplayTypeLink()||this._isDisplayTypeAuto()&&!this._isEmbeddedModeAllowed()};p.prototype._getLibraryResourceBundle=function(){return a.getResourceBundleFor("sap.m")};p.prototype._getIllustratedMessageErrorMessage=function(){return this.getErrorPlaceholderMessage()?this.getErrorPlaceholderMessage():this._getLibraryResourceBundle().getText("PDF_VIEWER_PLACEHOLDER_ERROR_TEXT")};p.prototype._getRenderWidth=function(){return this._bIsPopupOpen?"100%":this.getWidth()};p.prototype._getRenderHeight=function(){if(this._bIsPopupOpen){return"100%"}if(!this._isEmbeddedModeAllowed()){return"auto"}return this.getHeight()};p.prototype.exit=function(){jQuery.each(this._objectsRegister,function(e,t){var r=t(true);if(r){r.destroy()}});try{var e=this._getIframeDOMElement();e.off()}catch(e){s.info(e)}};o.extendPdfViewer(p);return p});
//# sourceMappingURL=PDFViewer.js.map