/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/AnimationMode","sap/ui/core/Control","sap/ui/core/ControlBehavior","sap/ui/core/Lib","sap/ui/core/delegate/ScrollEnablement","sap/m/Title","sap/m/Button","sap/m/Bar","sap/ui/core/ContextMenuSupport","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/core/library","sap/ui/core/Element","sap/ui/core/InvisibleText","./TitlePropagationSupport","./PageRenderer","sap/ui/thirdparty/jquery"],function(e,t,o,r,a,i,n,s,l,u,p,g,d,h,f,c,jQuery){"use strict";var _=g.AccessibleLandmarkRole;var y=e.ButtonType;var T=e.PageBackgroundDesign;var v=g.TitleLevel;var b=e.TitleAlignment;var A="div";var B="header";var m="footer";var C=o.extend("sap.m.Page",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:v.Auto},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showSubHeader:{type:"boolean",group:"Appearance",defaultValue:true},navButtonText:{type:"string",group:"Misc",defaultValue:null,deprecated:true},navButtonTooltip:{type:"string",group:"Misc",defaultValue:null},enableScrolling:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null,deprecated:true},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:T.Standard},navButtonType:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:y.Back,deprecated:true},showFooter:{type:"boolean",group:"Appearance",defaultValue:true},contentOnlyBusy:{type:"boolean",group:"Appearance",defaultValue:false},floatingFooter:{type:"boolean",group:"Appearance",defaultValue:false},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:b.Auto}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.m.IBar",multiple:false},footer:{type:"sap.m.IBar",multiple:false},subHeader:{type:"sap.m.IBar",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent",forwarding:{getter:"_getInternalHeader",aggregation:"contentRight"}},landmarkInfo:{type:"sap.m.PageAccessibleLandmarkInfo",multiple:false},_internalHeader:{type:"sap.m.IBar",multiple:false,visibility:"hidden"}},events:{navButtonTap:{deprecated:true},navButtonPress:{}},dnd:{draggable:false,droppable:true},designtime:"sap/m/designtime/Page.designtime"},renderer:c});u.apply(C.prototype);p.call(C.prototype,{header:{suffix:"intHeader"},subHeader:{selector:".sapMPageSubHeader .sapMIBar"},content:{suffix:"cont"},footer:{selector:".sapMPageFooter:not(.sapMPageFloatingFooter) .sapMIBar"},floatingFooter:{selector:".sapMPageFloatingFooter.sapMPageFooter"}});f.call(C.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false});C.FOOTER_ANIMATION_DURATION=350;C.SHELLBAR_IN_HEADER_CLASS="sapFShellBar-CTX";C.prototype.init=function(){this._initTitlePropagationSupport();this._initResponsivePaddingsEnablement()};C.prototype._hasScrolling=function(){return this.getEnableScrolling()};C.prototype.onBeforeRendering=function(){var e=this.getCustomHeader()||this.getAggregation("_internalHeader"),t=this.getFooter();if(t&&!t.getAriaLabelledBy().length){t.addAriaLabelledBy(this._getFooterToolbarAriaLabelledBy(t.getId()))}if(this._oScroller&&!this._hasScrolling()){this._oScroller.destroy();this._oScroller=null}else if(this._hasScrolling()&&!this._oScroller){this._oScroller=new i(this,null,{scrollContainerId:this.getId()+"-cont",horizontal:false,vertical:true})}if(this._headerTitle){this._headerTitle.setLevel(this.getTitleLevel())}this._ensureNavButton();if(e&&e.setTitleAlignment){e.setTitleAlignment(this.getTitleAlignment())}};C.prototype.onAfterRendering=function(){this.$().toggleClass("sapMPageBusyCoversAll",!this.getContentOnlyBusy());this._sBusySection=this.getContentOnlyBusy()?"cont":null};C.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null}if(this._navBtn){this._navBtn.destroy();this._navBtn=null}if(this._appIcon){this._appIcon.destroy();this._appIcon=null}if(this._oHeaderToolbarInvisibleText){this._oHeaderToolbarInvisibleText.destroy();this._oHeaderToolbarInvisibleText=null}if(this._oFooterToolbarInvisibleText){this._oFooterToolbarInvisibleText.destroy();this._oFooterToolbarInvisibleText=null}};C.prototype.setBackgroundDesign=function(e){var t=this.getBackgroundDesign();this.setProperty("backgroundDesign",e,true);this.$().removeClass("sapMPageBg"+t).addClass("sapMPageBg"+this.getBackgroundDesign());return this};C.prototype.setTitle=function(e){var t=!this._headerTitle;this._headerTitle=this._headerTitle||new n(this.getId()+"-title",{level:this.getTitleLevel()});this._headerTitle.setText(e);if(t){this._updateHeaderContent(this._headerTitle,"middle",0)}this.setProperty("title",e,true);return this};C.prototype._ensureNavButton=function(){if(!this.getShowNavButton()){return}var e=this.getNavButtonTooltip()||a.getResourceBundleFor("sap.m").getText("PAGE_NAVBUTTON_TEXT");if(!this._navBtn){this._navBtn=new s(this.getId()+"-navButton",{press:function(){this.fireNavButtonPress();this.fireNavButtonTap()}.bind(this)})}this._navBtn.setType(this.getNavButtonType());this._navBtn.setTooltip(e)};C.prototype.setShowNavButton=function(e){var t=!!this.getShowNavButton();if(e===t){return this}this.setProperty("showNavButton",e,true);if(e){this._ensureNavButton();if(this._appIcon){this._updateHeaderContent(this._appIcon,"left",-1)}this._updateHeaderContent(this._navBtn,"left",0)}else if(this._navBtn){this._updateHeaderContent(this._navBtn,"left",-1)}return this};C.prototype.setShowFooter=function(e){if(this.getDomRef()){e?this.$().addClass("sapMPageWithFooter"):this.$().removeClass("sapMPageWithFooter")}var o=jQuery(this.getDomRef()).find(".sapMPageFooter").last(),a=r.getAnimationMode(),i=a!==t.none&&a!==t.minimal;if(!this.getFloatingFooter()){this.setProperty("showFooter",e);return this}this.setProperty("showFooter",e,true);o.removeClass("sapUiHidden");o.toggleClass("sapMPageFooterControlShow",e);o.toggleClass("sapMPageFooterControlHide",!e);if(e){return this}if(i){setTimeout(()=>{o.toggleClass("sapUiHidden",!this.getShowFooter())},C.FOOTER_ANIMATION_DURATION)}else{o.toggleClass("sapUiHidden",!e)}return this};C.prototype._updateHeaderContent=function(e,t,o){var r=this._getInternalHeader();if(r){switch(t){case"left":if(o==-1){if(r.getContentLeft()){r.removeContentLeft(e)}}else{if(r.indexOfContentLeft(e)!=o){r.insertContentLeft(e,o);r.invalidate()}}break;case"middle":if(o==-1){if(r.getContentMiddle()){r.removeContentMiddle(e)}}else{if(r.indexOfContentMiddle(e)!=o){r.insertContentMiddle(e,o);r.invalidate()}}break;case"right":if(o==-1){if(r.getContentRight()){r.removeContentRight(e)}}else{if(r.indexOfContentRight(e)!=o){r.insertContentRight(e,o);r.invalidate()}}break;default:break}}};C.prototype._getInternalHeader=function(){var e=this.getAggregation("_internalHeader");if(!e){var t=this.getId()+"-intHeader";this.setAggregation("_internalHeader",new l(t,{titleAlignment:this.getTitleAlignment(),ariaLabelledBy:this._getHeaderToolbarAriaLabelledBy(t)}),true);e=this.getAggregation("_internalHeader");if(this.getShowNavButton()&&this._navBtn){this._updateHeaderContent(this._navBtn,"left",0)}if(this.getTitle()&&this._headerTitle){this._updateHeaderContent(this._headerTitle,"middle",0)}}return e};C.prototype._getAnyHeader=function(){var e=this.getCustomHeader();if(e){return e.addStyleClass("sapMPageHeader")}return this._getInternalHeader().addStyleClass("sapMPageHeader")};C.prototype.getScrollDelegate=function(){return this._oScroller};C.prototype._formatLandmarkInfo=function(e,t){if(e){var o=e["get"+t+"Role"]()||"",r=e["get"+t+"Label"]()||"";if(o===_.None){o=""}return{role:o.toLowerCase(),label:r}}return{}};C.prototype._getHeaderTag=function(e){if(e&&e.getHeaderRole()){return A}return B};C.prototype._getSubHeaderTag=function(e){if(e&&e.getSubHeaderRole()){return A}return B};C.prototype._getFooterTag=function(e){if(e&&e.getFooterRole()){return A}return m};C.prototype.scrollTo=function(e,t){if(this._oScroller){this._oScroller.scrollTo(0,e,t)}return this};C.prototype.scrollToElement=function(e,t,o){if(e instanceof d){e=e.getDomRef()}if(this._oScroller){this._oScroller.scrollToElement(e,t,o)}return this};C.prototype.setCustomHeader=function(e){this.setAggregation("customHeader",e);this.toggleStyleClass(C.SHELLBAR_IN_HEADER_CLASS,e?.isA("sap.f.ShellBar"));if(e&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{parent:this,adaptableContent:e})}return this};C.prototype.setSubHeader=function(e){this.setAggregation("subHeader",e);this.toggleStyleClass(C.SHELLBAR_IN_HEADER_CLASS,e?.isA("sap.f.ShellBar"));return this};C.prototype.destroyCustomHeader=function(){this.destroyAggregation("customHeader");this.removeStyleClass(C.SHELLBAR_IN_HEADER_CLASS);return this};C.prototype.destroySubHeader=function(){this.destroyAggregation("subHeader");this.removeStyleClass(C.SHELLBAR_IN_HEADER_CLASS);return this};C.prototype._getAdaptableContent=function(){return this._getAnyHeader()};C.prototype._getHeaderToolbarAriaLabelledBy=function(e){if(!this._oHeaderToolbarInvisibleText){this._oHeaderToolbarInvisibleText=new h(e+"-InvisibleText",{text:a.getResourceBundleFor("sap.m").getText("ARIA_LABEL_TOOLBAR_HEADER_ACTIONS")}).toStatic()}return this._oHeaderToolbarInvisibleText};C.prototype._getFooterToolbarAriaLabelledBy=function(e){if(!this._oFooterToolbarInvisibleText){this._oFooterToolbarInvisibleText=new h(e+"-InvisibleText",{text:a.getResourceBundleFor("sap.m").getText("ARIA_LABEL_TOOLBAR_FOOTER_ACTIONS")}).toStatic()}return this._oFooterToolbarInvisibleText};return C});
//# sourceMappingURL=Page.js.map