/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/m/delegate/DateNavigation","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/ui/core/Lib","sap/ui/unified/library","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/DatesRow","sap/ui/unified/calendar/OneMonthDatesRow","sap/ui/unified/calendar/MonthsRow","sap/ui/unified/calendar/TimesRow","sap/ui/unified/DateRange","sap/ui/unified/DateTypeRange","sap/ui/unified/CalendarAppointment","sap/ui/unified/CalendarRow","sap/ui/unified/CalendarRowRenderer","sap/ui/Device","sap/ui/core/Element","sap/ui/core/Renderer","sap/ui/core/ResizeHandler","sap/ui/core/InvisibleText","sap/ui/core/dnd/DragInfo","sap/ui/core/dnd/DropInfo","sap/ui/core/dnd/DragDropInfo","sap/ui/core/format/DateFormat","sap/base/i18n/date/CalendarType","sap/base/i18n/date/CalendarWeekNumbering","sap/ui/core/date/CalendarUtils","sap/ui/core/Locale","sap/ui/core/date/UI5Date","sap/ui/events/KeyCodes","sap/m/Avatar","sap/m/Toolbar","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/ColumnListItemRenderer","sap/m/SegmentedButtonItem","sap/m/StandardListItem","sap/m/PlanningCalendarHeader","sap/m/PlanningCalendarRenderer","sap/m/PlanningCalendarView","sap/m/CheckBox","sap/m/library","sap/base/util/deepEqual","sap/base/Log","sap/m/List","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(e,t,a,i,n,r,s,o,l,g,h,d,p,c,u,f,_,y,m,D,v,w,S,C,T,R,A,I,M,b,P,k,H,O,V,N,E,L,U,W,x,B,z,K,F,J,j,Y,G,jQuery){"use strict";var $=J.Sticky;var q=s.CalendarDayType;var X=J.ListMode;var Q=J.ToolbarDesign;var Z=J.PlanningCalendarBuiltInView;var ee=J.ScreenSize;var te=s.CalendarAppointmentVisualization;var ae=s.GroupAppointmentsMode;var ie=s.CalendarIntervalType;var ne=s.CalendarAppointmentHeight;var re=s.CalendarAppointmentRoundWidth;var se=J.AvatarShape;var oe="DragDropConfig";var le="ResizeConfig";var ge="CreateConfig";var he="-CLI";var de=i.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:ie.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:ae.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},appointmentHeight:{type:"sap.ui.unified.CalendarAppointmentHeight",group:"Appearance",defaultValue:ne.Regular},appointmentRoundWidth:{type:"sap.ui.unified.CalendarAppointmentRoundWidth",group:"Appearance",defaultValue:re.None},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:te.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},calendarWeekNumbering:{type:"sap.base.i18n.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"},multipleAppointmentsSelection:{type:"boolean",group:"Data",defaultValue:false},iconShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:se.Circle}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent",forwarding:{getter:"_getHeader",aggregation:"actions"}},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"},header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",multiple:false,altTypes:["string"],forwarding:{idSuffix:"-Table",aggregation:"noData"}}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{parameters:{headerId:{type:"string"},row:{type:"sap.m.PlanningCalendarRow"}}},rowHeaderPress:{parameters:{headerId:{type:"string"},row:{type:"sap.m.PlanningCalendarRow"}}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(e,t){i.prototype.constructor.apply(this,arguments);if(typeof e!=="string"){t=e}if(t&&typeof t.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=t.customAppointmentsSorterCallback}},renderer:z});var pe=["_oTimesRow","_oDatesRow","_oMonthsRow","_oWeeksRow","_oOneMonthsRow"],ce={};ce[ie.Day]={sInstanceName:"_oDatesRow",sIdSuffix:"-DatesRow",oClass:g};ce[ie.Week]={sInstanceName:"_oWeeksRow",sIdSuffix:"-WeeksRow",oClass:g};ce[ie.OneMonth]={sInstanceName:"_oOneMonthsRow",sIdSuffix:"-OneMonthsRow",oClass:h};var ue=ee.Desktop;var fe=[Z.Hour,Z.Day,Z.Month,Z.Week,Z.OneMonth];var _e={PHONE:"600",TABLET:"1024"};var ye={MONTH:"month",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker",YEAR_RANGE_PICKER:"yearRangePicker"};var me={onAfterRendering:function(){this.setProperty("_currentPicker",ye.MONTH);this.removeDelegate(me)}};var De={onAfterRendering:function(){this.setProperty("_currentPicker",ye.MONTH_PICKER);this.removeDelegate(De)}};var ve={onAfterRendering:function(){this.setProperty("_currentPicker",ye.YEAR_PICKER);this.removeDelegate(ve)}};var we=["sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.OneMonthDatesRow"];var Se=i.extend("sap.m._PlanningCalendarInternalHeader",{metadata:{aggregations:{toolbar:{type:"sap.m.Toolbar",multiple:false},allCheckBox:{type:"sap.m.CheckBox",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.class("sapMPlanCalHead");e.openEnd();var a=t.getToolbar();if(a){e.renderControl(a)}var i=t.getAllCheckBox();if(i){e.renderControl(i)}e.close("div")}}});de.prototype.init=function(){this._dateNav=new a;this._iBreakPointTablet=m.media._predefinedRangeSets[m.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=m.media._predefinedRangeSets[m.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=m.media._predefinedRangeSets[m.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(m.system.phone||jQuery("html").hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0}else if((m.system.tablet||jQuery("html").hasClass("sapUiMedia-Std-Tablet"))&&!(m.system.desktop||jQuery("html").hasClass("sapUiMedia-Std-Desktop"))){this._iSize=1;this._iSizeScreen=1}else{this._iSize=2;this._iSizeScreen=2}this.addStyleClass("sapMSize"+this._iSize);this.setAggregation("header",this._createHeader());this._attachHeaderEvents();this._oRB=r.getResourceBundleFor("sap.m");var e=this.getId();this._oIntervalTypeSelect=this._getHeader()._getOrCreateViewSwitch();this._oIntervalTypeSelect.attachEvent("selectionChange",Ce,this);this._oTodayButton=this._getHeader()._getTodayButton();this._oCalendarHeader=new Se(e+"-CalHead",{});this._oCalendarHeader.isRelative=this.isRelative.bind(this);this._oCalendarHeader._getRelativeInfo=this._getRelativeInfo.bind(this);this._oInfoToolbar=new V(e+"-InfoToolbar",{height:"auto",design:Q.Transparent,content:[this._oCalendarHeader,this._oTimesRow],ariaLabelledBy:S.getStaticId("sap.m","PC_INTERVAL_TOOLBAR")});var t=new N(e+"-Table",{sticky:[],infoToolbar:this._oInfoToolbar,mode:X.SingleSelectMaster,columns:[new E({styleClass:"sapMPlanCalRowHead"}),new E({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:ue,demandPopin:true})],ariaLabelledBy:e+"-Descr"});t.attachEvent("selectionChange",xe,this);t.addDelegate({onBeforeRendering:function(){if(this._rowHeaderPressEventMouse){this._rowHeaderPressEventMouse.off()}if(this._rowHeaderPressEventKeyboard){this._rowHeaderPressEventKeyboard.off()}},onAfterRendering:function(){if(this.hasListeners("rowHeaderPress")){this._addRowHeaderDescription()}const e=t.$().find(".sapMPlanCalRowHead");this._rowHeaderPressEventMouse=e.on("click",function(e){const t=D.closestTo(e.currentTarget),a=Ne(t),i=t.getAggregation("cells")[0].getId();this.fireRowHeaderClick({headerId:i,row:a});this.fireRowHeaderPress({headerId:i,row:a})}.bind(this));this._rowHeaderPressEventKeyboard=e.on("keydown",function(e){if(e.which===H.SPACE||e.which===H.ENTER){e.preventDefault();var t=D.closestTo(e.currentTarget),a=Ne(t),i=t.getAggregation("cells")[0].getId();this.fireRowHeaderPress({headerId:i,row:a})}}.bind(this));this._adjustColumnHeadersTopOffset()}},false,this);t.getStickyFocusOffset=$e.bind(this);this.setAggregation("table",t,true);this.setStartDate(k.getInstance());this._resizeProxy=Ie.bind(this);this._fnCustomSortedAppointments=undefined;this.iWidth=0};de.prototype.exit=function(){if(this._sResizeListener){w.deregister(this._sResizeListener);this._sResizeListener=undefined}m.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined}var e=this.getAggregation("table");e.removeAllItems();pe.forEach(function(e){if(this[e]){this[e]._oPlanningCalendar=undefined;this[e].destroy();this[e]=undefined}},this);if(this._oViews){for(var t in this._oViews){this._oViews[t].destroy()}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy()}if(this._rowHeaderPressEventMouse){this._rowHeaderPressEventMouse.off();this._rowHeaderPressEventMouse=null}if(this._rowHeaderPressEventKeyboard){this._rowHeaderPressEventKeyboard.off();this._rowHeaderPressEventKeyboard=null}};de.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;this._updateHeader();this._adjustViewKey();Ke.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined}this._updatePickerSelection();this._updateHeaderButtons();m.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;this._toggleStickyClasses();We.call(this)};de.prototype._bindAggregation=function(e,t){if(e==="rows"){qe(t,"dataRequested",this._onBindingDataRequestedListener.bind(this));qe(t,"dataReceived",this._onBindingDataReceivedListener.bind(this))}i.prototype._bindAggregation.call(this,e,t)};de.prototype._onBindingDataRequestedListener=function(e){this.getAggregation("table").setBusy(true,"listUl")};de.prototype._onBindingDataReceivedListener=function(e){this.getAggregation("table").setBusy(false,"listUl")};de.prototype._updateHeader=function(){this._getHeader().setProperty("_primaryCalendarType",this._getPrimaryCalendarType());if(this._getSecondaryCalendarType()){this.setShowDayNamesLine(true);this._getHeader().setProperty("_secondaryCalendarType",this.getSecondaryCalendarType())}return this};de.prototype.attachEvent=function(e,t,a,n){i.prototype.attachEvent.call(this,e,t,a,n);if(this.hasListeners("intervalSelect")){pe.forEach(function(e){if(this[e]){this[e]._setAriaRole("columnheader")}},this)}else if(this.hasListeners("rowHeaderPress")&&this.getDomRef()){this._addRowHeaderDescription()}return this};de.prototype.setIconShape=function(e){this.setProperty("iconShape",e);this.getRows().forEach(function(t){var a=Le(t);if(a.getAvatar){a.getAvatar().setDisplayShape(e)}});return this};de.prototype.detachEvent=function(e,t,a){i.prototype.detachEvent.call(this,e,t,a);if(!this.hasListeners("intervalSelect")){pe.forEach(function(e){if(this[e]){this[e]._setAriaRole("gridcell")}},this)}return this};de.prototype._createHeader=function(){var e=new B(this.getId()+"-Header",{calendarWeekNumbering:this.getCalendarWeekNumbering()});e._getRelativeInfo=this._getRelativeInfo.bind(this);e.getAggregation("_actionsToolbar").addAriaLabelledBy(S.getStaticId("sap.m","PC_FUNCTIONS_TOOLBAR"));e.getAggregation("_navigationToolbar").addAriaLabelledBy(S.getStaticId("sap.m","PC_INTERVAL_SELECTION_TOOLBAR"));return e};de.prototype._attachHeaderEvents=function(){var e=this._getHeader();e.attachEvent("pressPrevious",this._handlePressArrow,this);e.attachEvent("pressToday",this._handleTodayPress,this);e.attachEvent("pressNext",this._handlePressArrow,this);e.attachEvent("dateSelect",this._handleDateSelect,this);return this};de.prototype._handlePressArrow=function(e){this._applyArrowsLogic(e.getId()==="pressPrevious")};de.prototype._applyArrowsLogic=function(e){if(e){this._dateNav.previous(this._getPrimaryCalendarType())}else{this._dateNav.next(this._getPrimaryCalendarType())}var t=this._getRowInstanceByViewKey(this.getViewKey());this.setStartDate(this._dateNav.getStart());t.displayDate(this._dateNav.getCurrent());this._updatePickerSelection();this.fireStartDateChange()};de.prototype._addRowHeaderDescription=function(){const e=this.getAggregation("table").getItems();e.forEach(function(e){const t=e.getTimeline().getAssociation("row"),a=D.getElementById(t),i=a.getRowHeaderDescription()||this._oRB.getText("PLANNING_CALENDAR_ROW_HEADER_DESCRIPTION");e.getDomRef().querySelector(".sapMPlanCalRowHead").setAttribute("aria-description",i)},this)};de.prototype._formatPickerText=function(){var e=this._getFirstAndLastRangeDate(),a=o._createLocalDate(e.oStartDate,true),i=o._createLocalDate(e.oEndDate,true),n=this.getViewKey(),r=ie[n]?ie[n]:this._getView(n).getIntervalType(),s=t.getRTL(),l,g,h,d,p,c,u,f;if(this._getSecondaryCalendarType()){p=A.getDateInstance({format:"yMMMMd",calendarType:this.getSecondaryCalendarType()})}switch(r){case ie.Hour:l=A.getDateInstance({format:"yMMMMd",calendarType:this._getPrimaryCalendarType()});h=l.format(a);if(a.getDate()!==i.getDate()){d=l.format(i)}if(this._getSecondaryCalendarType()){c=p.format(a);if(a.getDate()!==i.getDate()){u=p.format(i)}}break;case ie.Day:case ie.Week:var _=this._getRelativeInfo().intervalLabelFormatter;if(this.isRelative()){var y=this.calcIntervalOffset(this.getStartDate());var m=this.calcIntervalOffset(this.getEndDate())-this.calcIntervalOffset(this.getStartDate());h=_?_(y):y;var D=this._getRelativeInfo().iIntervalSize===1?y+m:y+m-1;d=_?_(D):y+m}else{l=A.getDateInstance({format:"yMMMMd",calendarType:this._getPrimaryCalendarType()});h=l.format(a);d=l.format(i);if(this._getSecondaryCalendarType()){c=p.format(a);u=p.format(i)}}break;case ie.OneMonth:case"OneMonth":l=A.getDateInstance({format:"yMMMM",calendarType:this._getPrimaryCalendarType()});h=l.format(a);if(this._getSecondaryCalendarType()){p=A.getDateInstance({format:"yMMMM",calendarType:this.getSecondaryCalendarType()});c=p.format(a)}break;case ie.Month:l=A.getDateInstance({format:"y",calendarType:this._getPrimaryCalendarType()});h=l.format(a);if(this._getSecondaryCalendarType()){p=A.getDateInstance({format:"y",calendarType:this.getSecondaryCalendarType()});c=p.format(a)}if(a.getFullYear()!==i.getFullYear()){d=l.format(i);if(this._getSecondaryCalendarType()){u=p.format(i)}}if(h===d){d=undefined}break;default:throw new Error("Unknown IntervalType: "+n+"; "+this)}if(!s){g=h;f=c;if(d){g+=" - "+d}if(this._getSecondaryCalendarType()&&u){f+=" - "+u}}else{if(d){g=d+" - "+h}else{g=h}if(this._getSecondaryCalendarType()&&u){f=c+" - "+u}else if(this._getSecondaryCalendarType()){f=c}}return{primaryType:g,secondaryType:f}};de.prototype._getPrimaryCalendarType=function(){return this.getProperty("primaryCalendarType")||e.getCalendarType()};de.prototype._getFirstAndLastRangeDate=function(){var e=this.getStartDate(),t=this.getMinDate(),a=e,i,n;if(t&&t.getTime()>e.getTime()&&this._isWeekOrOneMonthView(this.getViewKey())){a=t}i=o._createUniversalUTCDate(a,this._getPrimaryCalendarType(),true);n=o._createUniversalUTCDate(this._dateNav.getEnd(),this._getPrimaryCalendarType(),true);return{oStartDate:i,oEndDate:n}};de.prototype._getHeader=function(){return this.getAggregation("header")};de.prototype._toggleStickyClasses=function(){this.toggleStyleClass("sapMPCSticky",this.getStickyHeader());return this};de.prototype._adjustColumnHeadersTopOffset=function(){var e=this.getStickyHeader(),t=this.getDomRef().querySelector(".sapMListInfoTBarContainer"),a;switch(e){case true:a=this._getHeader().$().outerHeight()+"px";break;default:a="auto";break}t.style.top=a;return this};de.prototype.getEndDate=function(){return this._dateNav.getEnd(this._getPrimaryCalendarType())};de.prototype.getVisibleIntervalsCount=function(){if(this._isOneMonthView(this.getViewKey())&&this._iSize<2){const e=this._oOneMonthsRow._getVisibleDays();return e.length}else{return this._getIntervals(this._getView(this.getViewKey()))}};de.prototype._setAriaRole=function(e){if(this.hasListeners("intervalSelect")){e._setAriaRole("columnheader")}else{e._setAriaRole("gridcell")}};de.prototype._updateTodayButtonState=function(){if(!this._oTodayButton){return}if(this.isRelative()){this._oTodayButton.setEnabled(false);return}this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(k.getInstance(),this.getViewKey()))};de.prototype._dateMatchesVisibleRange=function(e,t){var a=this._getView(t,!this._bBeforeRendering);if(!a){return false}var i=a.getIntervalType(),n=ce[i],r=n?this[n.sInstanceName]:null,s=false;if(r&&t==="One Month"){return o._isSameMonthAndYear(l.fromLocalJSDate(this.getStartDate()),l.fromLocalJSDate(e))}else if(r&&t==="Week"){var g=r.getDays(),h=l.fromLocalJSDate(e),d=l.fromLocalJSDate(this.getStartDate()),p=l.fromLocalJSDate(this.getStartDate());p.setDate(p.getDate()+g);return h.isSameOrAfter(d)&&h.isBefore(p)}return s};de.prototype.onAfterRendering=function(e){e.size={width:this.getDomRef().offsetWidth};Ie.call(this,e,true);if(!this._sResizeListener){this._sResizeListener=w.register(this,this._resizeProxy)}if(m.system.phone&&this.getStickyHeader()){m.orientation.attachHandler(this._updateStickyHeader,this)}this._updateCurrentTimeVisualization(false);if(this.getHeight()){var t=this.getDomRef().querySelector("table");if(this.getHeight().indexOf("%")>-1){t.style.height=this.getHeight();return}var a=this.$().height()-this._oInfoToolbar.$().height()+"px";t.style.height=a}this._adjustColumnHeadersTopOffset();this._updateHeaderButtons()};de.prototype.onThemeChanged=function(){if(this.getDomRef()){this._adjustColumnHeadersTopOffset()}};de.prototype.addToolbarContent=function(e){if(e&&e.isA("sap.m.Title")){this._observeHeaderTitleText(e);this._getHeader().setTitle(e.getText());e.setVisible(false);this.addAriaLabelledBy(e.getId())}this.addAggregation("toolbarContent",e);return this};de.prototype.insertToolbarContent=function(e,t){if(e&&e.isA("sap.m.Title")){this._observeHeaderTitleText(e);this._getHeader().setTitle(e.getText());e.setVisible(false);this.addAriaLabelledBy(e.getId())}this.insertAggregation("toolbarContent",e,t);return this};de.prototype.removeToolbarContent=function(e){var t;if(e&&e.isA("sap.m.Title")){this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver()}else{t=this.removeAggregation("toolbarContent",e)}return t};de.prototype.removeAllToolbarContent=function(){var e=this.removeAllAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return e};de.prototype.destroyToolbarContent=function(){var e=this.destroyAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return e};de.prototype._getHeaderObserver=function(){if(!this._oHeaderObserver){this._oHeaderObserver=new n(this._handleTitleTextChange.bind(this))}return this._oHeaderObserver};de.prototype._observeHeaderTitleText=function(e){this._getHeaderObserver().observe(e,{properties:["text"]})};de.prototype._handleTitleTextChange=function(e){this._getHeader().setTitle(e.current)};de.prototype._disconnectAndDestroyHeaderObserver=function(){if(this._oHeaderObserver){this._oHeaderObserver.disconnect();this._oHeaderObserver.destroy();this._oHeaderObserver=null}};de.prototype.setStartDate=function(e){var t,a=this.getMinDate(),i=this.getViewKey();if(!e){t=k.getInstance()}else{o._checkJSDateObject(e);t=k.getInstance(e.getTime())}t=this._shiftStartDate(t);if(j(t,this.getStartDate())){this._updateTodayButtonState();return this}var n=t.getFullYear();o._checkYearInValidRange(n);if(a&&a.getTime()>t.getTime()){if(!this._isWeekOrOneMonthView(i)){Y.warning("StartDate < minDate -> StartDate set to minDate",this);t=k.getInstance(a.getTime())}}else{var r=this.getMaxDate();if(r&&r.getTime()<t.getTime()){Y.warning("StartDate > maxDate -> StartDate set to minDate",this);if(a){t=k.getInstance(a.getTime())}else{t=k.getInstance(1,0,1);t.setFullYear(1)}}}this.setProperty("startDate",t,true);this._dateNav.setStart(t);this._dateNav.setCurrent(t);this._getHeader().setStartDate(t);pe.forEach(function(e){if(this[e]){this[e].setStartDate(k.getInstance(t.getTime()))}},this);if(this._isOneMonthView(i)&&this._oOneMonthsRow&&this._oOneMonthsRow.getMode()<2&&this._oOneMonthsRow.getSelectedDates().length){this._setRowsStartDate(this._oOneMonthsRow.getSelectedDates()[0].getStartDate())}else{this._setRowsStartDate(k.getInstance(t.getTime()))}if(this._isWeekOrOneMonthView(i)){this._updateTodayButtonState()}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);this._updatePickerSelection()}this._updateHeaderButtons();return this};de.prototype.setPrimaryCalendarType=function(e){this.setProperty("primaryCalendarType",e);if(this._getHeader()){this._getHeader().setProperty("_primaryCalendarType",e)}if(this._oTimesRow){this._oTimesRow.setProperty("primaryCalendarType",e)}if(this._oDatesRow){this._oDatesRow.setPrimaryCalendarType(e)}if(this._oMonthsRow){this._oMonthsRow.setProperty("primaryCalendarType",e)}if(this._oWeeksRow){this._oWeeksRow.setPrimaryCalendarType(e)}if(this._oOneMonthsRow){this._oOneMonthsRow.setPrimaryCalendarType(e)}return this};de.prototype._getSecondaryCalendarType=function(){var e=this.getSecondaryCalendarType();if(e===this._getPrimaryCalendarType()){return undefined}return e};de.prototype.setSecondaryCalendarType=function(e){this.setProperty("secondaryCalendarType",e);if(this._getHeader()){this._getHeader().setProperty("_secondaryCalendarType",e)}if(this._oTimesRow){this._oTimesRow.setProperty("secondaryCalendarType",e)}if(this._oDatesRow){this._oDatesRow.setSecondaryCalendarType(e)}if(this._oMonthsRow){this._oMonthsRow.setSecondaryCalendarType(e)}if(this._oWeeksRow){this._oWeeksRow.setSecondaryCalendarType(e)}if(this._oOneMonthsRow){this._oOneMonthsRow.setSecondaryCalendarType(e)}return this};de.prototype.setMinDate=function(e){if(j(e,this.getMinDate())){return this}var t=this.getMaxDate(),a=this._getHeader(),i;if(e){o._checkJSDateObject(e);var n=e.getFullYear();o._checkYearInValidRange(n);i=k.getInstance(e.getTime());this.setProperty("minDate",i,true);this._bNoStartDateChange=true;a.getAggregation("_calendarPicker").setMinDate(i);a.getAggregation("_monthPicker").setMinDate(i);a.getAggregation("_yearPicker").setMinDate(i);if(this._oDatesRow){this._oDatesRow._oMinDate=i;this._oDatesRow.invalidate()}if(this._oWeeksRow){this._oWeeksRow._oMinDate=i;this._oWeeksRow.invalidate()}if(this._oOneMonthsRow){this._oOneMonthsRow._oMinDate=i;this._oOneMonthsRow.invalidate()}if(t&&t.getTime()<e.getTime()){Y.warning("minDate > maxDate -> maxDate set to end of the month",this);t=i;t.setMonth(t.getMonth()+1,0);t.setHours(23);t.setMinutes(59);t.setSeconds(59);t.setMilliseconds(0);this.setMaxDate(t)}this._bNoStartDateChange=undefined;var r=this.getStartDate();if(r&&r.getTime()<i.getTime()){Y.warning("StartDate < minDate -> StartDate set to minDate",this);r=i;this.setStartDate(r);a.updatePickerText(this._formatPickerText())}}else{this.setProperty("minDate",undefined,true);a.getAggregation("_calendarPicker").setMinDate();a.getAggregation("_monthPicker").setMinDate();a.getAggregation("_yearPicker").setMinDate()}var s=k.getInstance();if(e&&s.getTime()<i.getTime()){this._oTodayButton.setVisible(false)}else if(!t||s.getTime()<t.getTime()){this._oTodayButton.setVisible(true)}if(this.getDomRef()){this._updatePickerSelection();this._updateHeaderButtons()}return this};de.prototype.setMaxDate=function(e){if(j(e,this.getMaxDate())){return this}var t=this.getMinDate(),a=this._getHeader(),i;if(e){o._checkJSDateObject(e);var n=e.getFullYear();o._checkYearInValidRange(n);i=k.getInstance(e.getTime());this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;a.getAggregation("_calendarPicker").setMaxDate(i);a.getAggregation("_monthPicker").setMaxDate(i);a.getAggregation("_yearPicker").setMaxDate(i);if(this._oDatesRow){this._oDatesRow._oMaxDate=i;this._oDatesRow.invalidate()}if(this._oWeeksRow){this._oWeeksRow._oMaxDate=i;this._oWeeksRow.invalidate()}if(this._oOneMonthsRow){this._oOneMonthsRow._oMaxDate=i;this._oOneMonthsRow.invalidate()}if(t&&t.getTime()>i.getTime()){Y.warning("maxDate < minDate -> maxDate set to begin of the month",this);t=i;t.setDate(1);t.setHours(0);t.setMinutes(0);t.setSeconds(0);t.setMilliseconds(0);this.setMinDate(t)}this._bNoStartDateChange=undefined;var r=this.getStartDate();if(r&&r.getTime()>i.getTime()){Y.warning("StartDate > maxDate -> StartDate set to minDate",this);if(t){r=k.getInstance(t.getTime())}else{r=k.getInstance(1,0,1);r.setFullYear(1)}this.setStartDate(r);a.updatePickerText(this._formatPickerText())}}else{this.setProperty("maxDate",undefined,true);a.getAggregation("_calendarPicker").setMaxDate();a.getAggregation("_monthPicker").setMaxDate();a.getAggregation("_yearPicker").setMaxDate()}var s=k.getInstance();if(e&&s.getTime()>i.getTime()){this._oTodayButton.setVisible(false)}else if(!t||s.getTime()>t.getTime()){this._oTodayButton.setVisible(true)}if(this.getDomRef()){this._updatePickerSelection();this._updateHeaderButtons()}return this};de.prototype.setCalendarWeekNumbering=function(e){var t=this._getHeader(),a=t._oPopup&&t._oPopup.getContent()[0],i;this.setProperty("calendarWeekNumbering",e);this._updateWeekConfiguration();t.setCalendarWeekNumbering(e);a&&a.setCalendarWeekNumbering(e);for(i in ce){this[ce[i].sInstanceName]&&this[ce[i].sInstanceName].setCalendarWeekNumbering(e)}this.setStartDate(this.getStartDate());return this};de.prototype.removeIntervalInstanceFromInfoToolbar=function(){var e=this._oInfoToolbar.getContent();e.forEach(function(e){if(e.isA(we)){this._oInfoToolbar.removeContent(e)}}.bind(this))};de.prototype.isRelative=function(){var e=this._getView(this.getViewKey(),true);if(!e){return false}return e.getRelative()};de.prototype.setViewKey=function(e){var t,a,i,n=this.getViewKey(),r=this._getHeader(),s,g,h;this.setProperty("viewKey",e,true);this._oIntervalTypeSelect.setSelectedKey(e);this.removeIntervalInstanceFromInfoToolbar();var c=this.getStartDate();var u=this.getMinDate();var f=this.getMaxDate();var _=this._getView(e,!this._bBeforeRendering);var y;var m=this._getSecondaryCalendarType();if(!_){this._bCheckView=true;this.invalidate()}else{var D=_.getIntervalType();var v=_.getIntervalSize();var w=this._getIntervals(_);this._bCheckView=false;this._dateNav.setUnit(D);this._dateNav.setStep(w*v);this._dateNav.setCurrent(undefined);switch(D){case ie.Hour:if(!this._oTimesRow){this._oTimesRow=new p(this.getId()+"-TimesRow",{startDate:k.getInstance(c.getTime()),items:w,legend:this.getLegend()});this._setAriaRole(this._oTimesRow);this._oTimesRow._setLegendControlOrigin(this);this._oTimesRow.attachEvent("focus",this._handleFocus,this);this._oTimesRow.attachEvent("select",this._handleCalendarSelect,this);this._oTimesRow._oPlanningCalendar=this;this._oTimesRow._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates()};this._oTimesRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates()}}else if(this._oTimesRow.getItems()!==w){this._oTimesRow.setItems(w);this._dateNav.setStep(w*v)}this._insertInterval(this._oTimesRow);y=r.getAggregation("_calendarPicker")?r.getAggregation("_calendarPicker"):r._oPopup.getContent()[0];y.addDelegate(me,y);r.setAssociation("currentPicker",y);break;case ie.Day:case ie.Week:case ie.OneMonth:case"OneMonth":if(c&&u&&c.getTime()<=u.getTime()){if(e===ie.Week){var S=this._getWeekConfigurationValues(),C=o.getFirstDateOfWeek(o._createUniversalUTCDate(u,undefined,true),S),T=o._createLocalDate(C,true);c=k.getInstance(T.getTime())}else if(this._isOneMonthView(e)&&this._iSize&&this._iSize===2){g=o._getFirstDateOfMonth(l.fromLocalJSDate(u,this._getPrimaryCalendarType()));h=g.toLocalJSDate();c=k.getInstance(h.getTime())}else{c=k.getInstance(u.getTime())}this.setStartDate(c)}i=ce[D];t=this[i.sInstanceName];if(!t){t=new i.oClass(this.getId()+i.sIdSuffix,{startDate:k.getInstance(c.getTime()),days:w,showDayNamesLine:this.getShowDayNamesLine(),legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers(),calendarWeekNumbering:this.getCalendarWeekNumbering()});t.isRelative=this.isRelative.bind(this);t._getRelativeInfo=this._getRelativeInfo.bind(this);this._setAriaRole(t);t.attachEvent("select",this._handleCalendarSelect,this);t.attachEvent("focus",this._handleFocus,this);if(this._isOneMonthView(e)){t._setRowsStartDate=this._setRowsStartDate.bind(this)}t._oMinDate=u;t._oMaxDate=f;t._oPlanningCalendar=this;t._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates()};t.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates()}}else if(t.getDays()!==w){t.setDays(w);this._dateNav.setStep(w*v)}this._insertInterval(t);this[i.sInstanceName]=t;if(D===ie.OneMonth||D==="OneMonth"){y=r.getAggregation("_monthPicker")?r.getAggregation("_monthPicker"):r._oPopup.getContent()[0];r.setAssociation("currentPicker",y);y.addDelegate(De,y)}else if(this.isRelative()){var R=r.getAggregation("_indexPicker");y=R?R:r._oPopup.getContent()[0];if(R){var _=this._getView(e);var A=Math.round(this.calcIntervalOffset(c));R.setFormatter(this._getRelativeInfo().intervalLabelFormatter);R.setPeriodSize(t.getDays());R.setSelectedIndex(A)}else{var _=this._getView(e);y.setFormatter(_.getIntervalLabelFormatter());y.setPeriodSize(t.getDays());var A=Math.round(this.calcIntervalOffset(c));y.setSelectedIndex(A)}r.setAssociation("currentPicker",y)}else{y=r.getAggregation("_calendarPicker")?r.getAggregation("_calendarPicker"):r._oPopup.getContent()[0];r.setAssociation("currentPicker",y);y.addDelegate(me,y)}break;case ie.Month:if(!this._oMonthsRow){this._oMonthsRow=new d(this.getId()+"-MonthsRow",{startDate:k.getInstance(c.getTime()),months:w,legend:this.getLegend()});this._oMonthsRow.setProperty("primaryCalendarType",this._getPrimaryCalendarType());if(m){this._oMonthsRow.setProperty("secondaryCalendarType",m)}this._setAriaRole(this._oMonthsRow);this._oMonthsRow._setLegendControlOrigin(this);this._oMonthsRow.attachEvent("focus",this._handleFocus,this);this._oMonthsRow.attachEvent("select",this._handleCalendarSelect,this);this._oMonthsRow._oPlanningCalendar=this;this._oMonthsRow._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates()};this._oMonthsRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates()}}else if(this._oMonthsRow.setMonths()!==w){this._oMonthsRow.setMonths(w);this._dateNav.setStep(w*v)}this._insertInterval(this._oMonthsRow);y=r.getAggregation("_yearPicker")?r.getAggregation("_yearPicker"):r._oPopup.getContent()[0];r.setAssociation("currentPicker",y);y.addDelegate(ve,y);break;default:throw new Error("Unknown IntervalType: "+D+"; "+this)}var I=this.getAggregation("table").getInfoToolbar().getContent()[1];if(I.getMetadata().hasProperty("_primaryCalendarType")){I.setProperty("_primaryCalendarType",this._getPrimaryCalendarType())}else if(I.getMetadata().hasProperty("primaryCalendarType")){I.setPrimaryCalendarType(this._getPrimaryCalendarType())}if(m&&I.getMetadata().hasProperty("_secondaryCalendarType")){I.setProperty("_secondaryCalendarType",m)}else if(m&&I.getMetadata().hasProperty("secondaryCalendarType")){I.setSecondaryCalendarType(m)}if(this._oOneMonthsRow){this._oOneMonthsRow.setPrimaryCalendarType(this._getPrimaryCalendarType())}if(I.setFirstDayOfWeek){I.setFirstDayOfWeek(this.getFirstDayOfWeek())}var M=this.getRows();for(var b=0;b<M.length;b++){var P=M[b];var H=Ue(P);H.setIntervalType(D);H.setIntervals(w);H.setIntervalSize(v);H.setShowSubIntervals(_.getShowSubIntervals())}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);Re.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(e));Ae.call(this,this.getShowDayNamesLine(),!!t)}this._updatePickerSelection()}if(this._isWeekOrOneMonthView(e)||e===Z.Month){a=this.getStartDate();this.setStartDate(k.getInstance(a.getTime()));if(a.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange()}}if(this._oOneMonthsRow&&this._isOneMonthView(e)){this._oOneMonthsRow.setMode(this._iSize);this._adjustSelectedDate(l.fromLocalJSDate(c,this._getPrimaryCalendarType()));if(this._iSize<2){this._setRowsStartDate(c)}}else if(this._oOneMonthsRow&&this._isOneMonthView(n)&&this._oOneMonthsRow.getSelectedDates().length){s=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();if(s){s.setHours(s.getHours());s.setMinutes(s.getMinutes());s.setSeconds(s.getSeconds());s.setMilliseconds(s.getMilliseconds());this.setStartDate(s)}}if(u){r.getAggregation("_calendarPicker")&&r.getAggregation("_calendarPicker").setMinDate(k.getInstance(u.getTime()));r.getAggregation("_yearPicker")&&r.getAggregation("_yearPicker").setMinDate(k.getInstance(u.getTime()));r.getAggregation("_monthPicker")&&r.getAggregation("_monthPicker").setMinDate(k.getInstance(u.getTime()))}if(f){r.getAggregation("_calendarPicker")&&r.getAggregation("_calendarPicker").setMaxDate(k.getInstance(f.getTime()));r.getAggregation("_yearPicker")&&r.getAggregation("_yearPicker").setMaxDate(k.getInstance(f.getTime()));r.getAggregation("_monthPicker")&&r.getAggregation("_monthPicker").setMaxDate(k.getInstance(f.getTime()))}this._updateTodayButtonState();return this};de.prototype.setFirstDayOfWeek=function(e){if(e<-1||e>6){Y.error(""+e+" is not a valid value to the property firstDayOfWeek. Valid values are from -1 to 6.");return}var t=this._getHeader().getAssociation("currentPicker"),a=D.getElementById(t),i=this.getViewKey(),n=this._dateNav,r=n.getStart(),s=this.getStartDate().getDay(),l=i===Z.OneMonth&&this._iSize<2,g=e,h,d,p;a.setFirstDayOfWeek(e);if(i===Z.Week||l){h=this.getAggregation("table").getInfoToolbar().getContent()[1];if(e===-1){d=o.getFirstDateOfWeek(o._createUniversalUTCDate(r,undefined,true));p=o._createLocalDate(d,true);g=p.getDay()}h.setFirstDayOfWeek(e);if(!l){r.setDate(r.getDate()-s+g);h.setStartDate(r)}this.getRows().forEach(function(e){this._updateRowTimeline(e)}.bind(this))}this.setProperty("firstDayOfWeek",e);this._updateWeekConfiguration();return this};de.prototype._updateWeekConfiguration=function(){var e=this._getWeekConfigurationValues();this._dateNav.setWeekConfiguration(e);this.setStartDate(this._dateNav.getStart())};de.prototype._getWeekConfigurationValues=function(){var t=new P(e.getLanguageTag()).toString(),a=this.getCalendarWeekNumbering(),i=this.getFirstDayOfWeek(),n=b.getWeekConfigurationValues(a,new P(t));if(i>-1){n.firstDayOfWeek=i}return n};de.prototype._handleFocus=function(e){var t=e.getParameter("date"),a=e.getParameter("restoreOldDate");if(a){return}this.shiftToDate(t,e.getParameter("otherMonth"));this._addMonthFocusDelegate(this._getRowInstanceByViewKey(this.getViewKey()))};de.prototype.shiftToDate=function(e,t){var a=this._getRowInstanceByViewKey(this.getViewKey()),i,n;this._dateNav.toDate(e,this._getPrimaryCalendarType());i=this._dateNav.getStart();n=this._dateNav.getCurrent();if(this._dateNav.getCurrent()>this._dateNav.getEnd()){i=k.getInstance(this._dateNav.getStart());i.setDate(i.getDate()+1)}if(this.getMaxDate()&&this.getMaxDate()<e||this.getMinDate()&&this.getMinDate()>e){return}if(t){this.fireStartDateChange()}if(a&&!(a.getMode&&a.getMode()<2&&!t)){this.setStartDate(i);a.setStartDate(i);a.setDate(n);this._addMonthFocusDelegate(a)}};de.prototype._addMonthFocusDelegate=function(e){var t={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(t)}};e.addDelegate(t,e)};de.prototype._shiftStartDate=function(e){if(this.getViewKey()===Z.Week){var t=this._getWeekConfigurationValues(),a=o.getFirstDateOfWeek(o._createUniversalUTCDate(e,undefined,true),t),i=o._createLocalDate(a,true);if(this.getFirstDayOfWeek()>-1){i.setDate(i.getDate()-i.getDay()+this.getFirstDayOfWeek())}if(i.getTime()>e.getTime()){i.setDate(i.getDate()-7)}e.setTime(i.getTime())}if(this.getViewKey()===Z.OneMonth||this.getViewKey()===Z.Month||this.getViewKey()==="OneMonth"){var n=o._getFirstDateOfMonth(l.fromLocalJSDate(e,this._getPrimaryCalendarType()));var r=n.toLocalJSDate();r.setHours(e.getHours(),e.getMinutes(),e.getSeconds());e.setTime(r.getTime())}return e};de.prototype._updatePickerSelection=function(){var e=this._getFirstAndLastRangeDate(),t=this._getHeader().getAssociation("currentPicker"),a=D.getElementById(t),i;i=new c({startDate:o._createLocalDate(e.oStartDate,true),endDate:o._createLocalDate(e.oEndDate,true)});if(this.isRelative()){a.setStartIndex(this.calcIntervalOffset(e.oStartDate))}else{a.destroySelectedDates();a.addSelectedDate(i)}this._getHeader().updatePickerText(this._formatPickerText());this._updateTodayButtonState()};de.prototype._adjustSelectedDate=function(e){var t=e.toLocalJSDate(),a=this.getMinDate();if(a&&t.getTime()<a.getTime()){t=k.getInstance(a.getTime())}if(this._oOneMonthsRow.getMode&&this._oOneMonthsRow.getMode()<2){this._oOneMonthsRow.removeAllSelectedDates();this._oOneMonthsRow.addSelectedDate(new c({startDate:t}));this._oOneMonthsRow.selectDate(t)}};de.prototype._insertInterval=function(e){if(this._iSizeScreen>1){this._oInfoToolbar.addContent(e)}else{this._oInfoToolbar.insertContent(e,1)}};de.prototype._viewAllowsWeekNumbers=function(e){var t=this._getView(e).getIntervalType(),a=ce[t];return!!a&&!!a.oClass.prototype.setShowWeekNumbers};de.prototype._viewAllowsDayNamesLine=function(e){var t=this._getView(e).getIntervalType(),a=ce[t];return!!a&&!!a.oClass.prototype.setShowDayNamesLine};de.prototype._getRowInstanceByViewKey=function(e){var t=this._getView(e).getIntervalType(),a=ce[t],i;if(a){i=this[a.sInstanceName]}if(t===ie.Month){i=this._oMonthsRow}if(t===ie.Hour){i=this._oTimesRow}return i};de.prototype.setShowWeekNumbers=function(e){this.setProperty("showWeekNumbers",e,true);this._getViews().forEach(function(t){var a=t.getKey(),i=this._viewAllowsWeekNumbers(a),n=this._getRowInstanceByViewKey(a);if(n&&i){n.setShowWeekNumbers(e)}if(this.getDomRef()&&this.getViewKey()===a){Re.call(this,e,i)}},this);return this};de.prototype.setShowIntervalHeaders=function(e){this.setProperty("showIntervalHeaders",e,true);var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ue(i).setShowIntervalHeaders(e)}return this};de.prototype.setShowEmptyIntervalHeaders=function(e){this.setProperty("showEmptyIntervalHeaders",e,true);var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ue(i).setShowEmptyIntervalHeaders(e)}return this};de.prototype.setGroupAppointmentsMode=function(e){this.setProperty("groupAppointmentsMode",e,true);var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ue(i).setGroupAppointmentsMode(e)}return this};de.prototype.setAppointmentsReducedHeight=function(e){this.setProperty("appointmentsReducedHeight",e,true);var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ue(i).setAppointmentsReducedHeight(e)}return this};de.prototype.setAppointmentHeight=function(e){var t=this.getRows(),a;this.setProperty("appointmentHeight",e);for(a=0;a<t.length;a++){var i=t[a];Ue(i).setAppointmentHeight(e)}return this};de.prototype.setAppointmentRoundWidth=function(e){var t=this.getRows(),a;this.setProperty("appointmentRoundWidth",e);for(a=0;a<t.length;a++){var i=t[a];Ue(i).setAppointmentRoundWidth(e)}return this};de.prototype.setAppointmentsVisualization=function(e){this.setProperty("appointmentsVisualization",e,true);var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ue(i).setAppointmentsVisualization(e)}return this};de.prototype.setShowRowHeaders=function(e){if(this.getShowRowHeaders()===e){return this}this.setProperty("showRowHeaders",e,true);var t=this.getAggregation("table"),a,i;t.getColumns()[0].setVisible(e);this._toggleAppointmentsColumnPopinState(e);this.$().toggleClass("sapMPlanCalNoHead",!e);Ye.call(this);this._setSelectionMode.call(this);t.getItems().forEach(function(t){a=t.getCells()[0];i=t.getCells()[1];if(e){i.addAriaLabelledBy(a.getId())}else{i.removeAriaLabelledBy(a.getId())}});return this};de.prototype.setShowDayNamesLine=function(e){var t,a,i,n=!!this.getDomRef(),r=this.getViewKey();for(t in ce){a=ce[t].sInstanceName;if(this[a]){i=this[a];i.setShowDayNamesLine(e);if(n&&t===r){Ae.call(this,e,true)}}}return this.setProperty("showDayNamesLine",e,false)};de.prototype.setStickyHeader=function(e){if(this.getStickyHeader()===e){return this}this.setProperty("stickyHeader",e,true);if(m.system.phone){if(e){m.orientation.attachHandler(this._updateStickyHeader,this)}else{m.orientation.detachHandler(this._updateStickyHeader,this)}}this._updateStickyHeader();return this};de.prototype._updateStickyHeader=function(){var e=[],t=this.getStickyHeader(),a=this._isOneMonthView(this.getViewKey())&&this._iSize<2,i=t&&!m.system.phone&&!a,n=t&&!(m.system.phone&&m.orientation.landscape)&&!a;if(i){e.push($.HeaderToolbar)}if(this._oInfoToolbar&&n){e.push($.InfoToolbar)}this.getAggregation("table").setSticky(e)};de.prototype._adjustViewKey=function(){if(!this._oTimesRow&&!this._oDatesRow&&!this._oMonthsRow&&!this._oWeeksRow&&!this._oOneMonthsRow||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined}};de.prototype.addView=function(e){this.addAggregation("views",e);if(e.getKey()===this.getViewKey()){this._adjustViewKey()}return this};de.prototype.insertView=function(e,t){this.insertAggregation("views",e,t);if(e.getKey()===this.getViewKey()){this._adjustViewKey()}return this};de.prototype.addRow=function(e){this.addAggregation("rows",e);this.getAggregation("table").addItem(this._createPlanningCalendarListItem(e));return this};de.prototype.insertRow=function(e,t){this.insertAggregation("rows",e,t);this.getAggregation("table").insertItem(this._createPlanningCalendarListItem(e),t,true);return this};de.prototype.removeRow=function(e){var t=this.removeAggregation("rows",e,true),a=this.getAggregation("table");a.removeItem(Ee(t),true);this._handleRowRemoval(t);je.call(this);this._setSelectionMode.call(this);return t};de.prototype.removeAllRows=function(){var e=this.removeAllAggregation("rows",true),t=this.getAggregation("table");t.removeAllItems(true);e.forEach(this._handleRowRemoval,this);je.call(this);this._setSelectionMode.call(this);return e};de.prototype.destroyRows=function(){var e;var t=this.getAggregation("table");t.destroyItems(true);e=this.destroyAggregation("rows");je.call(this);this._setSelectionMode.call(this);return e};de.prototype.setSingleSelection=function(e){this.setProperty("singleSelection",e,true);Ye.call(this);this._setSelectionMode.call(this);if(e){this.selectAllRows(false)}else{je.call(this)}this.$().toggleClass("sapMPlanCalMultiSel",!e);return this};de.prototype.setNoDataText=function(e){this.setProperty("noDataText",e,true);var t=this.getAggregation("table");t.setNoDataText(e);return this};de.prototype.setLegend=function(e){this.setAssociation("legend",e,true);var t=this.getRows(),a=this.getLegend()&&D.getElementById(this.getLegend()),i;for(var r=0;r<t.length;r++){var s=t[r];Ue(s).setLegend(e)}pe.forEach(function(t){if(this[t]){this[t].setLegend(e)}},this);if(a){i=new n(function(e){this.invalidate()}.bind(this));i.observe(a,{destroy:true})}return this};de.prototype.addAriaLabelledBy=function(e){this.addAssociation("ariaLabelledBy",e,true);var t=this.getAggregation("table");t.addAriaLabelledBy(e);return this};de.prototype.removeAriaLabelledBy=function(e){this.removeAssociation("ariaLabelledBy",e,true);var t=this.getAggregation("table");t.removeAriaLabelledBy(e);return this};de.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var e=this.getAggregation("table");e.removeAllAriaLabelledBy();e.addAriaLabelledBy(this.getId()+"-Descr");return this};de.prototype.invalidate=function(e){var t=e&&e instanceof c;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||t)){if(this.getDomRef()){var a=this.getViewKey();var n=this._getView(a);var r=n.getIntervalType();switch(r){case ie.Hour:if(this._oTimesRow){this._oTimesRow.invalidate(arguments)}break;case ie.Day:if(this._oDatesRow){this._oDatesRow.invalidate(arguments)}break;case ie.Month:if(this._oMonthsRow){this._oMonthsRow.invalidate(arguments)}break;case ie.OneMonth:case"OneMonth":if(this._oOneMonthsRow){this._oOneMonthsRow.invalidate(arguments)}break;case ie.Week:if(this._oWeeksRow){this._oWeeksRow.invalidate(arguments)}break;default:throw new Error("Unknown IntervalType: "+r+"; "+this)}}this._bDateRangeChanged=undefined}else{if(e instanceof K){this._bCheckView=true}i.prototype.invalidate.apply(this,arguments)}};de.prototype.addSpecialDate=function(e){this._bDateRangeChanged=true;return i.prototype.addAggregation.call(this,"specialDates",e)};de.prototype.insertSpecialDate=function(e,t){this._bDateRangeChanged=true;return i.prototype.insertAggregation.call(this,"specialDates",e,t)};de.prototype.removeSpecialDate=function(e){this._bDateRangeChanged=true;return i.prototype.removeAggregation.call(this,"specialDates",e)};de.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;return this.removeAllAggregation("specialDates")};de.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;return this.destroyAggregation("specialDates")};de.prototype.removeAllViews=function(){this._bCheckView=true;var e=this.removeAllAggregation("views"),t=this.getBuiltInViews();if(t.length){this.setViewKey(t[0])}else{this.setViewKey(fe[0])}return e};de.prototype.destroyViews=function(){this._bCheckView=true;var e=this.destroyAggregation("views"),t=this.getBuiltInViews();if(t.length){this.setViewKey(t[0])}else{this.setViewKey(fe[0])}return e};de.prototype.getSelectedRows=function(){return this.getRows().filter(function(e){return e.getSelected()})};de.prototype.selectAllRows=function(e){var t=this.getRows();if(!(e&&this.getSingleSelection())){for(var a=0;a<t.length;a++){var i=t[a];i.setSelected(e)}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(e)}}return this};de.prototype.onsaphomemodifiers=function(e){if((e.metaKey||e.ctrlKey)&&!e.altKey&&!e.shiftKey){var t=this.getRows();var a=t[0];var i=new jQuery.Event("saphome");i._bPlanningCalendar=true;Ue(a).onsaphome(i);e.preventDefault();e.stopPropagation()}};de.prototype.onsapendmodifiers=function(e){if((e.metaKey||e.ctrlKey)&&!e.altKey&&!e.shiftKey){var t=this.getRows();var a=t[t.length-1];var i=new jQuery.Event("sapend");i._bPlanningCalendar=true;Ue(a).onsapend(i);e.preventDefault();e.stopPropagation()}};de.prototype.setBuiltInViews=function(e){this.setProperty("builtInViews",e);this.setViewKey(this._getViews()[0].getKey());return this};de.prototype.removeView=function(e){var t=this.removeAggregation("views",e);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey())}return t};de.prototype._isOneMonthView=function(e){return e===Z.OneMonth||e==="OneMonth"};de.prototype._isWeekOrOneMonthView=function(e){return e===Z.Week||this._isOneMonthView(e)};de.prototype._getIntervals=function(e){var t=0;switch(this._iSize){case 0:t=e.getIntervalsS();break;case 1:t=e.getIntervalsM();break;default:t=e.getIntervalsL();break}return t};de.prototype._getView=function(e,t){var a=this._getViews();var i;for(var n=0;n<a.length;n++){i=a[n];if(i.getKey()!=e){i=undefined}else{break}}if(!i&&!t){throw new Error("PlanningCalendarView with key "+e+" not assigned "+this)}return i};de.prototype._changeStartDate=function(e){if(this._bNoStartDateChange){return}this.setStartDate(k.getInstance(e.getTime()));this._updatePickerSelection();this.fireStartDateChange()};de.prototype._updateCurrentTimeVisualization=function(e){if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined}if(e){var t=this.getRows();for(var a=0;a<t.length;a++){var i=t[a];Ue(i).updateCurrentTimeVisualization()}}var n=k.getInstance();var r=this.getStartDate();var s=this.getViewKey();var o=this._getView(s);var l=o.getIntervalType();var g=this._getIntervals(o);var h=0;var d=0;var p=0;switch(l){case ie.Hour:h=6e4;d=r.getTime()-36e5;p=r.getTime()+g*36e5;break;case ie.Day:case ie.Week:case ie.OneMonth:case"OneMonth":h=18e5;d=r.getTime()-36e5;p=r.getTime()+g*864e5;break;default:h=-1;break}if(n.getTime()<=p&&n.getTime()>=d&&h>0){this._sUpdateCurrentTime=setTimeout(this["_updateCurrentTimeVisualization"].bind(this,true),h)}};function Ce(e){this.setViewKey(e.getParameter("item").getKey());this.fireViewChange()}de.prototype._handleTodayPress=function(e){var t=k.getInstance(),a,i=this.getViewKey(),n={onAfterRendering:function(){this._focusDate(l.fromLocalJSDate(k.getInstance(),this._getPrimaryCalendarType()));this.removeDelegate(n)}};if(this._isOneMonthView(i)){a=o._getFirstDateOfMonth(l.fromLocalJSDate(t,this._getPrimaryCalendarType()));this._adjustSelectedDate(l.fromLocalJSDate(t,this._getPrimaryCalendarType()));t=a.toLocalJSDate()}if(i===Z.Week){a=this.getStartDate();t.setHours(a.getHours());t.setMinutes(a.getMinutes());t.setSeconds(a.getSeconds())}this.setStartDate(t);this._dateNav.setCurrent(t);if(i===Z.Week){this._oWeeksRow.addDelegate(n,this._oWeeksRow)}else if(this._isOneMonthView(i)){this._oOneMonthsRow.addDelegate(n,this._oOneMonthsRow)}this._updatePickerSelection();this.fireStartDateChange()};de.prototype._handleStartDateChange=function(e){var t=e.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()!==ie.Hour){var a=this.getStartDate();t.setHours(a.getHours());t.setMinutes(a.getMinutes());t.setSeconds(a.getSeconds())}this._changeStartDate(t)};de.prototype._handleDateSelect=function(e){var t,a=this.getStartDate(),i=this.getViewKey(),n=this._getView(i),r=n.getIntervalType(),s;if(this.isRelative()){t=k.getInstance(this.getMinDate().getTime());t.setDate(t.getDate()+e.getSource()._oIndexPicker.getSelectedIndex()*this._getView(this.getViewKey()).getIntervalSize())}else{t=e.getSource().getStartDate()}if(r===ie.Hour){t.setHours(a.getHours());t.setMinutes(a.getMinutes());t.setSeconds(a.getSeconds())}if(a.getTime()!==t.getTime()){this._changeStartDate(t);if(r===ie.Month){t=this.getStartDate()}this._dateNav.setCurrent(t);if(r==="Hour"){r="Time"}else if(r==="Day"){r="Date"}else if(r==="One Month"){r="OneMonth"}s="_o"+r+"sRow";if(this[s]){this[s].displayDate(t)}}};de.prototype._handleCalendarSelect=function(e){var t=e.getSource().getSelectedDates();if(!t.length){return}var a=k.getInstance(t[0].getStartDate());var i=l.fromLocalJSDate(a,this._getPrimaryCalendarType());var n=o._createUniversalUTCDate(a,this._getPrimaryCalendarType(),true);var r=this.getViewKey();var s=this._getView(r);var g=s.getIntervalType();if(g!==ie.OneMonth&&g!=="OneMonth"||this._iSize>1){t[0].setStartDate()}switch(g){case ie.Hour:n.setUTCHours(n.getUTCHours()+1);break;case ie.Day:case ie.Week:n.setUTCDate(n.getUTCDate()+1);break;case ie.OneMonth:case"OneMonth":if(this._iSize<2){var h=k.getInstance(i.toLocalJSDate().getTime());if(o.monthsDiffer(this.getStartDate(),i.toLocalJSDate())){this.setStartDate(i.toLocalJSDate());this._getHeader().updatePickerText(this._formatPickerText());this.fireStartDateChange()}this._setRowsStartDate(h);this._oOneMonthsRow._focusDate(l.fromLocalJSDate(h,this._getPrimaryCalendarType()),true)}else if(o._isNextMonth(i.toLocalJSDate(),this.getStartDate())){this.shiftToDate(i.toLocalJSDate(),true);this._addMonthFocusDelegate(this._getRowInstanceByViewKey(this.getViewKey()));n.setUTCDate(n.getUTCDate()+1);n.setUTCMilliseconds(n.getUTCMilliseconds()-1);n=o._createLocalDate(n,true);this.fireIntervalSelect({startDate:a,endDate:n,subInterval:false,row:undefined});return}n.setUTCDate(n.getUTCDate()+1);break;case ie.Month:n.setUTCMonth(n.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+g+"; "+this)}n.setUTCMilliseconds(n.getUTCMilliseconds()-1);n=o._createLocalDate(n,true);this._formatPickerText();this.fireIntervalSelect({startDate:a,endDate:n,subInterval:false,row:undefined})};function Te(e){var t=e.getParameter("startDate");var a=this.getViewKey();var i=this._getView(a);var n=i.getIntervalType();if((n===ie.OneMonth||n==="OneMonth")&&o._isNextMonth(t,this.getStartDate())){this.shiftToDate(t);this._addMonthFocusDelegate(this._getRowInstanceByViewKey(this.getViewKey()));return}var r=e.getParameter("endDate");var s=e.getParameter("subInterval");var l=Ne(e.oSource.getParent());this._formatPickerText();this.fireIntervalSelect({startDate:t,endDate:r,subInterval:s,row:l})}de.prototype._applyContextualSettings=function(e){return i.prototype._applyContextualSettings.call(this,e)};function Re(e,t){this.$().toggleClass("sapMPlanCalWithWeekNumbers",e&&t)}function Ae(e,t){this.$().toggleClass("sapMPlanCalWithDayNamesLine",e&&t)}function Ie(e,t){if(e.size.width<=0){return}if(Math.abs(this.iWidth-e.size.width)<15){return}this.iWidth=e.size.width;this._applyContextualSettings({contextualWidth:this.iWidth});var a=this.getRows();var i;var n=0;var r;var s=this._iSize;Be.call(this,e.size.width);if(s!=this._iSize){ze.call(this,this._iSize);var o=this.getViewKey();var g=this._getView(o);var h=g.getIntervalType();var d=g.getIntervalSize();var p=this._getIntervals(g);for(n=0;n<a.length;n++){i=a[n];var c=Ue(i);if(p!=c.getIntervals()){c.setIntervals(p)}else{c.handleResize()}}switch(h){case ie.Hour:if(this._oTimesRow&&this._oTimesRow.getItems()!=p){this._oTimesRow.setItems(p);this._dateNav.setStep(p*d)}break;case ie.Day:if(this._oDatesRow&&this._oDatesRow.getDays()!=p){this._oDatesRow.setDays(p);this._dateNav.setStep(p*d)}break;case ie.Month:if(this._oMonthsRow&&this._oMonthsRow.getMonths()!=p){this._oMonthsRow.setMonths(p);this._dateNav.setStep(p*d)}break;case ie.Week:if(this._oWeeksRow&&this._oWeeksRow.getDays()!=p){this._oWeeksRow.setDays(p);this._dateNav.setStep(p*d)}break;case ie.OneMonth:case"OneMonth":if(this._oOneMonthsRow&&this._oOneMonthsRow.getDays()!=p){this._oOneMonthsRow.setDays(p);this._dateNav.setStep(p*d);if(this._iSize>1){this._setRowsStartDate(k.getInstance(this.getStartDate().getTime()))}}break;default:throw new Error("Unknown IntervalType: "+h+"; "+this)}Ye.call(this);this._updatePickerSelection()}else if(!t){for(n=0;n<a.length;n++){i=a[n];Ue(i).handleResize()}}if(this._oOneMonthsRow&&(this.getViewKey()===ie.OneMonth||this.getViewKey()==="OneMonth")){r=this._getSelectedDates().length&&this._getSelectedDates()[0].getStartDate()?this._getSelectedDates()[0].getStartDate():this.getStartDate();this._oOneMonthsRow.setMode(this._iSize);this._adjustSelectedDate(l.fromLocalJSDate(r,this._getPrimaryCalendarType()))}if(this.getStickyHeader()){this._adjustColumnHeadersTopOffset();this._updateStickyHeader()}}function Me(e){var t=e.getParameter("appointment"),a=e.getParameter("multiSelect")||this.getMultipleAppointmentsSelection(),i=e.getParameter("appointments"),n=e.getParameter("domRefId"),r,s,o,l,g,h,d;if(!a){s=this.getRows();for(h=0;h<s.length;h++){o=s[h];if(e.oSource!=Ue(o)){l=o.getAppointments();for(d=0;d<l.length;d++){g=l[d];g.setSelected(false)}}}}r={appointment:t,appointments:i,multiSelect:a,domRefId:n};this.fireAppointmentSelect(r)}de.prototype._setRowsStartDate=function(e){var t=this.getRows(),a,i;for(i=0;i<t.length;i++){a=t[i];Ue(a).setStartDate(e)}};de.prototype._toggleAppointmentsColumnPopinState=function(e){var t=this.getAggregation("table"),a=t.getColumns()[1];a.setDemandPopin(e);a.setMinScreenWidth(e?ue:"")};de.prototype._getViews=function(){var e=this.getViews(),t=this.getBuiltInViews(),a,i=[],n=Z,r=ie;if(!this._oViews){this._oViews={}}if(t.length){i=t}else{i=e.length?[]:fe}a=i.map(function(e){switch(e){case n.Hour:if(!this._oViews[n.Hour]){this._oViews[n.Hour]=new K(this.getId()+"-HourView",{key:n.Hour,intervalType:r.Hour,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12})}return this._oViews[n.Hour];case n.Day:if(!this._oViews[n.Day]){this._oViews[n.Day]=new K(this.getId()+"-DayView",{key:n.Day,intervalType:r.Day,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14})}return this._oViews[n.Day];case n.Month:if(!this._oViews[n.Month]){this._oViews[n.Month]=new K(this.getId()+"-MonthView",{key:n.Month,intervalType:r.Month,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12})}return this._oViews[n.Month];case n.Week:if(!this._oViews[n.Week]){this._oViews[n.Week]=new K(this.getId()+"-WeekView",{key:n.Week,intervalType:r.Week,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7})}return this._oViews[n.Week];case n.OneMonth:case"OneMonth":if(!this._oViews[n.OneMonth]){this._oViews[n.OneMonth]=new K(this.getId()+"-OneMonthView",{key:n.OneMonth,intervalType:r.OneMonth,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31})}return this._oViews[n.OneMonth];default:Y.error("Cannot get PlanningCalendar views. Invalid view key "+e);break}},this);for(var s in this._oViews){if(i.indexOf(s)<0){this._oViews[s].destroy();delete this._oViews[s]}}if(e.length){a=a.concat(e)}return a};de.prototype.getSelectedAppointments=function(){var e=[];this.getRows().filter(function(t){e.push.apply(e,Ue(t).aSelectedAppointments)});return e};de.prototype.setCustomAppointmentsSorterCallback=function(e){if(typeof e==="function"||e===null||e===undefined){this.getRows().forEach(function(t){Ue(t)._setCustomAppointmentsSorterCallback(e)});this._fnCustomSortedAppointments=e}else{Y.warning("Your custom sort function won't be used, but the old one will be preserved.",this)}return this};de.prototype.setWidth=function(e){var t=this.getStartDate();this.getRows().forEach(function(e){Ue(e).setStartDate(t)});return this.setProperty("width",e)};de.prototype.setMultipleAppointmentsSelection=function(e){this.getRows().forEach(function(t){Ue(t).setMultipleAppointmentsSelection(e)});return this.setProperty("multipleAppointmentsSelection",e)};de.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments};de.prototype._onRowDeselectAppointment=function(){var e=this.getRows();for(var t=0;t<e.length;t++){var a=Ue(e[t]).aSelectedAppointments;for(var i=0;i<a.length;i++){var n=D.getElementById(a[i]);if(n){var r=n.getColor(),s,o,l;n.setProperty("selected",false,true);n.$().removeClass("sapUiCalendarAppSel");if(!r){continue}s=n._getCSSColorForBackground(r);o=n.getDomRef();if(o){l=o.querySelector(".sapUiCalendarAppCont");if(l){l.style.backgroundColor=s}}}}Ue(e[t]).aSelectedAppointments=[]}};de.prototype._updateRowTimeline=function(e){var t=Ue(e),a=this.getViewKey(),i,n,r,s,o=this._isOneMonthView(a)&&this._iSize<2,l=this.getStartDate();t.setNonWorkingDays(e.getNonWorkingDays());t.setNonWorkingHours(e.getNonWorkingHours());if(o&&this._oOneMonthsRow&&this._oOneMonthsRow.getSelectedDates().length){l=this._oOneMonthsRow.getSelectedDates()[0].getStartDate()}t.setStartDate(l);t.setShowIntervalHeaders(this.getShowIntervalHeaders());t.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());t.setGroupAppointmentsMode(this.getGroupAppointmentsMode());t.setProperty("appointmentsReducedHeight",this.getAppointmentsReducedHeight());t.setAppointmentRoundWidth(this.getAppointmentRoundWidth());t.setLegend(this.getLegend());t.setAppointmentsVisualization(this.getAppointmentsVisualization());t.setAppointmentHeight(this.getAppointmentHeight());t.detachEvent("select",Me,this).attachEvent("select",Me,this);t.detachEvent("startDateChange",this._handleStartDateChange,this).attachEvent("startDateChange",this._handleStartDateChange,this);t.detachEvent("leaveRow",Je,this).attachEvent("leaveRow",Je,this);t.detachEvent("intervalSelect",Te,this).attachEvent("intervalSelect",Te,this);je.call(this);if(Ge.call(this)){a=this.getViewKey();i=this._getView(a);n=i.getIntervalType();s=i.getIntervalSize();r=this._getIntervals(i);t.setIntervalType(n);t.setIntervals(r);t.setIntervalSize(s);t.setShowSubIntervals(i.getShowSubIntervals())}this._setSelectionMode.call(this);if(this._fnCustomSortedAppointments){t._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments)}};de.prototype._observeRowChanges=function(e){var t=Ee(e),a=Le(e),i=Ue(e);var r={destroy:function(){t.destroy()},change:{title:function(e){a.setProperty(e.name,e.current)},icon:function(e){if(a.setIcon){a.setIcon(e.current)}else{a.setProperty(e.name,e.current)}a.getAvatar()&&a.getAvatar().setSrc(e.current).setVisible(!!e.current)},text:function(e){i.toggleStyleClass("sapMPlanCalRowLarge",!!e.current);a.setProperty("description",e.current)},enableAppointmentsDragAndDrop:function(t){this._enableAppointmentsDragAndDrop(e)}.bind(this),enableAppointmentsResize:function(t){this._enableAppointmentsResize(e)}.bind(this),enableAppointmentsCreate:function(t){this._enableAppointmentsCreate(e)}.bind(this),nonWorkingDays:function(e){i.setProperty(e.name,e.current)},nonWorkingHours:function(e){i.setProperty(e.name,e.current)},selected:function(e){je.call(this);t.setProperty(e.name,e.current)}.bind(this),tooltip:function(e){if(e.mutation==="insert"){a.setTooltip(e.child)}else if(e.mutation==="remove"){a.setTooltip()}},intervalHeaders:function(e){i.invalidate()},appointments:function(e){i.invalidate()},nonWorkingPeriods:function(e){i.invalidate()}}};new n(function(e){if(e.type==="destroy"){r.destroy()}else if(r.change[e.name]){r.change[e.name](e)}}).observe(e,{properties:["icon","text","title","nonWorkingDays","nonWorkingHours","selected","enableAppointmentsDragAndDrop","enableAppointmentsResize","enableAppointmentsCreate"],aggregations:["tooltip","appointments","nonWorkingPeriods","intervalHeaders","headerContent"],destroy:true});e.invalidate=function(e){if(!e||!(e instanceof f)){D.prototype.invalidate.apply(this,arguments)}else if(t){i.invalidate(e)}};e.applyFocusInfo=function(e){i.applyFocusInfo(e);return this}};de.prototype._createPlanningCalendarListItem=function(e){var t,a,i,n=e.getIcon();if(e.getHeaderContent().length||e.getBindingInfo("headerContent")){a=e._getPlanningCalendarCustomRowHeader()}else{a=new be(e.getId()+"-Head",{avatar:new O({src:n,displayShape:this.getIconShape(),visible:!!n}),icon:n,description:e.getText(),title:e.getTitle(),tooltip:e.getTooltip(),iconDensityAware:false,iconInset:false})}i=new ke(e.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false});if(this.getShowRowHeaders()){i.addAriaLabelledBy(a.getId())}i._getRelativeInfo=this._getRelativeInfo.bind(this);i.getAppointments=function(){return e.getAppointments()};i.getNonWorkingPeriods=function(){return e.getNonWorkingPeriods()};i.getIntervalHeaders=function(){return e.getIntervalHeaders()};i.setAssociation("row",e.getId());t=a.isA("sap.m.CustomListItem")?new Oe(e.getId()+he,{cells:[new G({items:[a]}),i]}):new Oe(e.getId()+he,{cells:[a,i]});this._updateRowTimeline(e);this._observeRowChanges(e);this._enableAppointmentsDragAndDrop(e);this._enableAppointmentsResize(e);this._enableAppointmentsCreate(e);return t};de.prototype._handleRowRemoval=function(e){var t=Ue(e);t.detachEvent("select",Me,this);t.detachEvent("startDateChange",this._handleStartDateChange,this);t.detachEvent("leaveRow",Je,this);t.detachEvent("intervalSelect",Te,this);if(this._fnCustomSortedAppointments){t._fnCustomSortedAppointments=undefined}Ee(e).destroy()};var be=x.extend("sap.m._PlanningCalendarRowHeader",{renderer:{apiVersion:2,renderTabIndex:function(e,t){},getAriaRole:function(e,t){}},TagName:"div"});be.prototype.isSelectable=function(){return false};var Pe=v.extend(y);Pe.apiVersion=2;Pe.getLegendItems=function(e){var t=[],a,i=e.getLegend();if(i){a=D.getElementById(i);if(a){t=a.getAppointmentItems?a.getAppointmentItems():a.getItems()}else{Y.error("PlanningCalendarLegend with id '"+i+"' does not exist!",e)}}return t};Pe.renderBeforeAppointments=function(e,t){var a=Ne(t.getParent()),i;if(!a.getEnableAppointmentsDragAndDrop()&&!a.getEnableAppointmentsResize()&&!a.getEnableAppointmentsCreate()||t._isOneMonthsRowOnSmallSizes()){return}i=t.getAggregation("_intervalPlaceholders");e.openStart("div");e.class("sapUiCalendarRowAppsOverlay");e.openEnd();if(i){for(var n=0;n<i.length;n++){var r=i[n];r.setWidth(100/i.length+"%");e.renderControl(r)}}e.close("div")};Pe.renderResizeHandle=function(e,t,a){if(!Ne(t.getParent()).getEnableAppointmentsResize()||t._isOneMonthsRowOnSmallSizes()||a._aAppointments&&a._aAppointments.length>0){return}e.openStart("span");e.class("sapUiCalendarAppResizeHandle");e.openEnd();e.close("span")};Pe.writeCustomAttributes=function(e,t){if(Ne(t.getParent()).getEnableAppointmentsCreate()){e.attr("draggable","true")}};var ke=_.extend("sap.m._PlanningCalendarRowTimeline",{metadata:{aggregations:{intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true},_intervalPlaceholders:{type:"sap.m._PlanningCalendarIntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},associations:{row:{type:"sap.m.PlanningCalendarRow",multiple:false}},dnd:true},renderer:Pe});ke.prototype._updatePlaceholders=function(){var e=this.getProperty("intervals");if(this.getIntervalType()===ie.Hour){e*=4}this.removeAllAggregation("_intervalPlaceholders");for(var t=0;t<e;t++){this.addAggregation("_intervalPlaceholders",new He)}};ke.prototype._getRelativeInfo=function(){};ke.prototype.onBeforeRendering=function(){_.prototype.onBeforeRendering.call(this);this._updatePlaceholders()};ke.prototype.onmousedown=function(e){var t=e.target.classList;this._isResizeHandleMouseDownTarget=t.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=t.contains("sapUiCalendarRowAppsInt")};ke.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget};ke.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget};ke.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget};ke.prototype._isNonWorkingInterval=function(e,t,a,i){const n=D.getElementById(this.getAssociation("row")),r=l.fromUTCDate(this._getStartDate().getJSDate()),s=n._getSpecialDates(),o=n.getParent()._getSpecialDates();r.setDate(r.getDate()+e);const g=this._isDateOfType(r,q.Working,s),h=this._isDateOfType(r,q.NonWorking,s),d=this._isDateOfType(r,q.Working,o),p=this._isDateOfType(r,q.NonWorking,o),c=_.prototype._isNonWorkingInterval.call(this,e,t,a,i);return h||p&&!g||c&&!g&&!d};ke.prototype._isDateOfType=function(e,t,a){let i,n;const r=a.find(function(t){i=t.getStartDate()?l.fromLocalJSDate(t.getStartDate()):l.fromLocalJSDate(t.getEndDate());n=t.getEndDate()?l.fromLocalJSDate(t.getEndDate()):l.fromLocalJSDate(t.getStartDate());return o._isBetween(e,i,n,true)});return Boolean(r)&&(r.getType()===t||r.getSecondaryType()===t)};var He=i.extend("sap.m._PlanningCalendarIntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:{apiVersion:2,render(e,t){e.openStart("div",t);e.style("width",t.getWidth());e.class("sapUiCalendarRowAppsPlaceholder");e.openEnd();e.close("div")}}});var Oe=L.extend("sap.m.internal.PlanningCalendarRowListItem",{metadata:{library:"sap.m"},renderer:U});Oe.prototype.getHeader=function(){return this.getCells()[0]};Oe.prototype.getTimeline=function(){return this.getCells()[1]};Oe.prototype.getCustomData=function(){return Ne(this).getCustomData()};de.prototype._getSelectedDates=function(){var e=this.getViewKey(),t=this._getView(e),a=t.getIntervalType(),i=ce[a];return this[i.sInstanceName].getSelectedDates()};de.prototype._enableAppointmentsDragAndDrop=function(e){var t=Ue(e),a;if(e.getEnableAppointmentsDragAndDrop()){a=e.getDragDropConfig().some(function(e){return e.getGroupName()===oe});if(!a){this._addDragDropInfo(e,Ue(e))}}else{e.getDragDropConfig().forEach(function(t){if(t.getGroupName()===oe){e.removeDragDropConfig(t);t.destroy()}});t.getDragDropConfig().forEach(function(e){if(e.getGroupName()===oe){t.removeDragDropConfig(e);e.destroy()}})}};de.prototype._enableAppointmentsResize=function(e){var t=e.getEnableAppointmentsResize(),a=this._getConfigFromDragDropConfigAggregation(e.getAggregation("dragDropConfig"),le),i;if(t&&!a){i=this._createResizeConfig(e);e.addAggregation("dragDropConfig",i,true)}if(!t&&a){e.removeAggregation("dragDropConfig",a,true);a.destroy()}};de.prototype._enableAppointmentsCreate=function(e){var t=e.getEnableAppointmentsCreate(),a=Ue(e),i=this._getConfigFromDragDropConfigAggregation(a.getAggregation("dragDropConfig"),ge),n;if(t&&!i){n=this._createAppointmentsCreateConfig(e);a.addAggregation("dragDropConfig",n,true)}if(!t&&i){a.removeAggregation("dragDropConfig",i,true);i.destroy()}};de.prototype._addDragDropInfo=function(e,a){e.addDragDropConfig(new C({groupName:oe,sourceAggregation:"appointments",dragStart:function(e){var t=function(){var e=jQuery(".sapUiCalendarRowAppsOverlay");setTimeout(function(){e.addClass("sapUiCalendarRowAppsOverlayDragging")},0);jQuery(document).one("dragend",function(){e.removeClass("sapUiCalendarRowAppsOverlayDragging")})};if(a._isOneMonthsRowOnSmallSizes()||!a._isDraggingPerformed()){e.preventDefault();return}t()}}));a.addDragDropConfig(new T({groupName:oe,targetAggregation:"_intervalPlaceholders",dragEnter:function(i){var n=i.getParameter("dragSession"),r=n.getDragControl(),s=a.getIntervalType(),o=a.getStartDate(),l=a.indexOfAggregation("_intervalPlaceholders",n.getDropControl()),g=a.getId(),h,d=function(){var e=jQuery(n.getIndicator()),a=n.getDropControl().getDomRef().getBoundingClientRect(),i=D.getElementById(g).getDomRef().getBoundingClientRect(),r=n.getDragControl().$().outerWidth(),s=t.getRTL(),o=s?Math.ceil(a.right)-i.left:i.right-Math.ceil(a.left);e.css("min-width",r<o?r:o).css(s?"border-left-width":"border-right-width",r>o?"0":"").css("margin-left",s?-(e.outerWidth()-parseFloat(e.context.style.width)):"")};if(e.hasListeners("appointmentDragEnter")){if(s===ie.Hour){h=this._calcNewHoursAppPos(o,r.getStartDate(),r.getEndDate(),l)}else if(s===ie.Day||s===ie.Week||(s===ie.OneMonth||s==="OneMonth")&&!a._isOneMonthsRowOnSmallSizes()){h=this._calcNewDaysAppPos(o,r.getStartDate(),r.getEndDate(),l)}else if(s===ie.Month){h=this._calcNewMonthsAppPos(o,r.getStartDate(),r.getEndDate(),l)}var p=e.fireAppointmentDragEnter({appointment:r,startDate:h.startDate,endDate:h.endDate,calendarRow:Ne(a.getParent())});if(!p){i.preventDefault();return}}else if(Ue(r.getParent())!==a){i.preventDefault();return}if(a.getIntervalType()!==ie.Hour){return}if(!n.getIndicator()){setTimeout(d,0)}else{d()}}.bind(this),drop:function(t){var i=t.getParameter("dragSession"),n=i.getDragControl(),r=a.getIntervalType(),s=a.getStartDate(),o=a.indexOfAggregation("_intervalPlaceholders",i.getDropControl()),l,g=t.getParameter("browserEvent"),h=g.metaKey||g.ctrlKey;if(r===ie.Hour){l=this._calcNewHoursAppPos(s,n.getStartDate(),n.getEndDate(),o)}else if(r===ie.Day||r===ie.Week||(r===ie.OneMonth||r==="OneMonth")&&!a._isOneMonthsRowOnSmallSizes()){l=this._calcNewDaysAppPos(s,n.getStartDate(),n.getEndDate(),o)}else if(r===ie.Month){l=this._calcNewMonthsAppPos(s,n.getStartDate(),n.getEndDate(),o)}a.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(n.getStartDate().getTime()===l.startDate.getTime()&&n.getParent()===Ne(a.getParent())){return}e.fireAppointmentDrop({appointment:n,startDate:l.startDate,endDate:l.endDate,calendarRow:Ne(a.getParent()),copy:h})}.bind(this)}))};de.prototype._calcNewHoursAppPos=function(e,t,a,i){var n=o._createUniversalUTCDate(e,null,true),r=o._createUniversalUTCDate(t,null,true),s=o._createUniversalUTCDate(a,null,true),l=k.getInstance(n.setUTCMinutes(0,0,0)+i*15*60*1e3);return{startDate:o._createLocalDate(l,true),endDate:o._createLocalDate(k.getInstance(l.getTime()+s.getTime()-r.getTime()),true)}};de.prototype._calcNewDaysAppPos=function(e,t,a,i){var n=o._createUniversalUTCDate(e,null,true),r=o._createUniversalUTCDate(t,null,true),s=o._createUniversalUTCDate(a,null,true),l=s.getTime()-r.getTime();r.setUTCFullYear(n.getUTCFullYear(),n.getUTCMonth(),n.getUTCDate()+i);s=k.getInstance(r.getTime()+l);return{startDate:o._createLocalDate(r,true),endDate:o._createLocalDate(s,true)}};de.prototype._calcNewMonthsAppPos=function(e,t,a,i){var n=o._createUniversalUTCDate(e,null,true),r=o._createUniversalUTCDate(t,null,true),s=o._createUniversalUTCDate(a,null,true),l=s.getTime()-r.getTime();r.setUTCFullYear(n.getUTCFullYear(),n.getUTCMonth()+i);s=k.getInstance(r.getTime()+l);return{startDate:o._createLocalDate(r,true),endDate:o._createLocalDate(s,true)}};de.prototype._createResizeConfig=function(e){var t=Ue(e),a=new R({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:Ue(e),dragStart:function(a){if(!e.getEnableAppointmentsResize()||t._isOneMonthsRowOnSmallSizes()||!t._isResizingPerformed()){a.preventDefault();return}var i=a.getParameter("dragSession"),n=t.$().find(".sapUiCalendarRowAppsOverlay"),r=jQuery(i.getIndicator()),s=i.getDragControl().$();r.addClass("sapUiDnDIndicatorHide");setTimeout(function(){n.addClass("sapUiCalendarRowAppsOverlayDragging")},0);jQuery(document).one("dragend",function(){n.removeClass("sapUiCalendarRowAppsOverlayDragging");r.removeClass("sapUiDnDIndicatorHide");s.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1})});a.getParameter("browserEvent").dataTransfer.setDragImage(Ve(),0,0)},dragEnter:function(e){var t=e.getParameter("dragSession"),a=this.getTargetElement(),i=function(){var e=jQuery(t.getIndicator());e.addClass("sapUiDnDIndicatorHide")},n=t.getDropControl().getDomRef().getBoundingClientRect(),r=D.getElementById(a).getDomRef().getBoundingClientRect(),s={width:n.left+n.width-(t.getDragControl().$().position().left+r.left),"z-index":1,opacity:.8},o=s.width;if(n.width>0){while(o<=0){o+=n.width}while(o>n.width){o-=n.width}}s["min-width"]=o;t.getDragControl().$().css(s);if(!t.getIndicator()){setTimeout(i,0)}else{i()}},drop:function(t){var a=Ue(e),i=t.getParameter("dragSession"),n=i.getDragControl(),r=a.getIntervalType(),s=a.getStartDate(),o=a.indexOfAggregation("_intervalPlaceholders",i.getDropControl()),l;if(r===ie.Hour){l=this._calcResizeNewHoursAppPos(s,n.getStartDate(),n.getEndDate(),o)}else if(r===ie.Day||r===ie.Week||(r===ie.OneMonth||r==="OneMonth")&&!a._isOneMonthsRowOnSmallSizes()){l=this._calcResizeNewDaysAppPos(s,n.getStartDate(),n.getEndDate(),o)}else if(r===ie.Month){l=this._calcResizeNewMonthsAppPos(s,n.getStartDate(),n.getEndDate(),o)}a.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");jQuery(i.getIndicator()).removeClass("sapUiDnDIndicatorHide");n.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(n.getEndDate().getTime()===l.endDate.getTime()){return}e.fireAppointmentResize({appointment:n,startDate:l.startDate,endDate:l.endDate,calendarRow:e})}.bind(this)});a.setProperty("groupName",le);return a};de.prototype._calcResizeNewHoursAppPos=function(e,t,a,i){var n=o._createUniversalUTCDate(k.getInstance(e.getTime()),null,true),r=15*60*1e3,s=o._createUniversalUTCDate(t,null,true),l=k.getInstance(n.setUTCMinutes(0,0,0)+(i+1)*r);if(l.getTime()<=s.getTime()){l=k.getInstance(s.getTime()+r)}return{startDate:o._createLocalDate(s,true),endDate:o._createLocalDate(l,true)}};de.prototype._calcResizeNewDaysAppPos=function(e,t,a,i){var n=o._createUniversalUTCDate(e,null,true),r=o._createUniversalUTCDate(t,null,true),s=k.getInstance(n.setUTCDate(n.getUTCDate()+i+1)),l={};l.startDate=o._createLocalDate(r);l.startDateTime=o._createLocalDate(r,true);l.endDate=o._createLocalDate(s);if(l.endDate<=l.startDate){l.endDate=o._createLocalDate(k.getInstance(s.setUTCDate(r.getUTCDate()+1)))}return{startDate:l.startDateTime,endDate:l.endDate}};de.prototype._calcResizeNewMonthsAppPos=function(e,t,a,i){var n=o._createUniversalUTCDate(e,null,true),r=o._createUniversalUTCDate(t,null,true),s=k.getInstance(n.setUTCMonth(n.getUTCMonth()+i+1,1));if(o._monthsBetween(r,s,true)<0){s=k.getInstance(s.setUTCFullYear(r.getUTCFullYear(),r.getUTCMonth()+1,1))}return{startDate:o._createLocalDate(r,true),endDate:o._createLocalDate(s)}};de.prototype._calcCreateNewAppHours=function(e,t,a){var[i,n]=[t,a].sort((e,t)=>e-t),r=o._createUniversalUTCDate(e,null,true),s=15*60*1e3,l=i,g=n+1,h=k.getInstance(r.setUTCMinutes(0,0,0)),d=k.getInstance(h.getTime()+l*s),p=k.getInstance(h.getTime()+g*s);return{startDate:o._createLocalDate(d,true),endDate:o._createLocalDate(p,true)}};de.prototype._calcCreateNewAppDays=function(e,t,a){var[i,n]=[t,a].sort((e,t)=>e-t),r=o._createUniversalUTCDate(e,null,true),s=i,l=n+1,g=k.getInstance(r.getTime()),h=k.getInstance(r.getTime());return{startDate:o._createLocalDate(k.getInstance(g.setUTCDate(g.getUTCDate()+s))),endDate:o._createLocalDate(k.getInstance(h.setUTCDate(h.getUTCDate()+l)))}};de.prototype._calcCreateNewAppMonths=function(e,t,a){var[i,n]=[t,a].sort((e,t)=>e-t),r=o._createUniversalUTCDate(e,null,true),s=i,l=n+1,g=k.getInstance(r.getTime()),h=k.getInstance(r.getTime());return{startDate:o._createLocalDate(k.getInstance(g.setUTCMonth(g.getUTCMonth()+s,1))),endDate:o._createLocalDate(k.getInstance(h.setUTCMonth(h.getUTCMonth()+l,1)))}};de.prototype._getConfigFromDragDropConfigAggregation=function(e,t){var a=e,i=a&&a.length;for(var n=0;n<i;n++){if(a[n].getGroupName()===t){return a[n]}}return null};de.prototype._createAppointmentsCreateConfig=function(e){var t=Ue(e),a=new R({targetAggregation:"_intervalPlaceholders",dragStart:function(a){if(!e.getEnableAppointmentsCreate()||t._isOneMonthsRowOnSmallSizes()||!t._isCreatingPerformed()){a.preventDefault();return}var i=a.getParameter("dragSession"),n=t.$().find(".sapUiCalendarRowAppsOverlay"),r=jQuery(i.getIndicator());setTimeout(function(){n.addClass("sapUiCalendarRowAppsOverlayDragging")},0);jQuery(document).one("dragend",function(){n.removeClass("sapUiCalendarRowAppsOverlayDragging");r.html("");r.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate")});a.getParameter("browserEvent").dataTransfer.setDragImage(Ve(),0,0)},dragEnter:function(e){var a=e.getParameter("dragSession"),i=a.getDropControl().getDomRef().getBoundingClientRect(),n=function(){var e=jQuery(a.getIndicator());e.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate")};var r=a.getData("text")?parseFloat(a.getData("text").split("|")[0]):0;if(r){if(r<=i.left){a.setIndicatorConfig({left:r,width:Math.max(i.left+i.width-r,i.width)})}else{a.setIndicatorConfig({left:i.left,width:Math.max(r-i.left+i.width,i.width)})}}else{a.setData("text",i.left+"|"+t.indexOfAggregation("_intervalPlaceholders",a.getDropControl()))}if(!a.getIndicator()){setTimeout(n,0)}else{n()}},drop:function(a){var i=a.getParameter("dragSession"),n=jQuery(i.getIndicator()),r=t.getIntervalType(),s=Ue(e).getStartDate(),o=parseInt(i.getData("text").split("|")[1]),l=t.indexOfAggregation("_intervalPlaceholders",i.getDropControl()),g;if(r===ie.Hour){g=this._calcCreateNewAppHours(s,o,l)}else if(r===ie.Day||r===ie.Week||(r===ie.OneMonth||r==="OneMonth")&&!t._isOneMonthsRowOnSmallSizes()){g=this._calcCreateNewAppDays(s,o,l)}else if(r===ie.Month){g=this._calcCreateNewAppMonths(s,o,l)}e.fireAppointmentCreate({startDate:g.startDate,endDate:g.endDate,calendarRow:e});n.html("");n.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate")}.bind(this)});a.setProperty("groupName",ge);return a};de.prototype._updateHeaderButtons=function(){var e=this.getViewKey(),t=this._getView(e,true),a=t&&t.getIntervalType(),i=k.getInstance(this._dateNav.getStart().getTime()),n=k.getInstance(this._dateNav.getEnd().getTime()),r=this.getMinDate()?k.getInstance(this.getMinDate().getTime()):undefined,s=this.getMaxDate()?k.getInstance(this.getMaxDate().getTime()):undefined;if(a!=="Hour"){r&&r.setHours(0,0,0,0);s&&s.setHours(23,59,59,999);i.setHours(0,0,0,0);n.setHours(23,59,59,999)}this._getHeader()._oPrevBtn.setEnabled(!r||i.getTime()>r.getTime());this._getHeader()._oNextBtn.setEnabled(!s||n.getTime()<s.getTime())};de.prototype._getSpecialDates=function(){var e=this.getSpecialDates();for(var t=0;t<e.length;t++){var a=e[t].getSecondaryType()===q.NonWorking&&e[t].getType()!==q.NonWorking||e[t].getSecondaryType()===q.Working&&e[t].getType()!==q.Working;if(a){var i=new u;i.setType(e[t].getSecondaryType());i.setStartDate(e[t].getStartDate());if(e[t].getEndDate()){i.setEndDate(e[t].getEndDate())}e.push(i)}}return e};function Ve(){var e=jQuery("<span></span>").addClass("sapUiCalAppResizeGhost");e.appendTo(document.body);setTimeout(function(){e.remove()},0);return e.get(0)}function Ne(e){var t=e.getId();return D.getElementById(t.substring(0,t.indexOf(he)))}function Ee(e){return D.getElementById(e.getId()+he)}function Le(e){var t=Ee(e);return t?t.getHeader():null}function Ue(e){var t=Ee(e);return t?t.getTimeline():null}function We(){const e=this.getSelectedRows();for(let t=0;t<e.length;t++){Ee(e[t]).setSelected(true)}}function xe(e){var t=[];var a=this.getRows();for(var i=0;i<a.length;i++){var n=a[i];var r=Ee(n);var s=r.getSelected();if(n.getSelected()!=s){n.setProperty("selected",s,true);t.push(n)}}if(!this.getSingleSelection()){je.call(this)}if(t.length>0){this.fireRowSelectionChange({rows:t})}}function Be(e){if(e<this._iBreakPointTablet){this._iSize=0}else if(e<this._iBreakPointDesktop){this._iSize=1}else{this._iSize=2}if(e<_e.PHONE){this._iSizeScreen=0}else if(e<_e.TABLET){this._iSizeScreen=1}else{this._iSizeScreen=2}}function ze(e){var t="sapMSize"+e,a,i;for(a=0;a<3;a++){i="sapMSize"+a;if(i===t){this.addStyleClass(i)}else{this.removeStyleClass(i)}}}function Ke(){var e=this._getViews();this._oIntervalTypeSelect.destroyItems();var t;var a;for(t=0;t<e.length;t++){var i=e[t];a=new W(this.getId()+"-"+t,{key:i.getKey(),text:i.getDescription(),tooltip:i.getTooltip()});this._oIntervalTypeSelect.addItem(a)}if(this._oIntervalTypeSelect.getItems().length>4){this._getHeader()._convertViewSwitchToSelect()}else{this._getHeader()._convertViewSwitchToSegmentedButton()}this._oIntervalTypeSelect.setVisible(!(e.length===1))}function Fe(e){var t=e.getParameter("selected");var a=this.getRows();if(t){a=this.getRows().filter(function(e){return!e.getSelected()})}this.selectAllRows(t);this.fireRowSelectionChange({rows:a})}function Je(e){var t=e.oSource;var a=e.getParameter("type");var i=this.getRows();var n;var r;var s;var o;var l=0;var g=0;var h;for(l=0;l<i.length;l++){n=i[l];if(Ue(n)==t){g=l;break}}switch(a){case"sapup":s=t.getFocusedAppointment();o=s.getStartDate();if(g>0){g--}r=i[g];Ue(r).focusNearestAppointment(o);break;case"sapdown":s=t.getFocusedAppointment();o=s.getStartDate();if(g<i.length-1){g++}r=i[g];Ue(r).focusNearestAppointment(o);break;case"saphome":if(g>0){r=i[0];h=new jQuery.Event(a);h._bPlanningCalendar=true;Ue(r).onsaphome(h)}break;case"sapend":if(g<i.length-1){r=i[i.length-1];h=new jQuery.Event(a);h._bPlanningCalendar=true;Ue(r).onsapend(h)}break;default:break}}function je(){if(this._oSelectAllCheckBox){var e=this.getRows();var t=this.getSelectedRows();if(e.length==t.length&&t.length>0){this._oSelectAllCheckBox.setSelected(true)}else{this._oSelectAllCheckBox.setSelected(false)}}}function Ye(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox()}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox)}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new F(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",Fe,this)}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var e=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(e<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox)}}else if(e<0||e>1){if(e>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox)}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1)}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox)}}}de.prototype._setSelectionMode=function(){var e=this.getAggregation("table");var t=e.getMode();var a;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){a=X.None}else{a=X.SingleSelectMaster}}else{a=X.MultiSelect}if(t!=a){e.setMode(a)}};de.prototype.calcIntervalOffset=function(e){var t=Date.UTC(e.getFullYear(),e.getMonth(),e.getDate());var a=this.getMinDate()||e;var i=Date.UTC(a.getFullYear(),a.getMonth(),a.getDate());return Math.round((t-i)/1e3/60/60/24/this._getView(this.getViewKey()).getIntervalSize())};de.prototype._getDateFromIndex=function(e){var t=k.getInstance(this.getMinDate());t.setDate(t.getDate()+e*this._getView(this.getViewKey()).getIntervalSize());return t};de.prototype._getRelativeInfo=function(){var e={},t=this._getView(this.getViewKey(),true);e.iIntervalSize=t.getIntervalSize();e.bIsRelative=t.getRelative();e.oMinDate=this.getMinDate();e._getDateFromIndex=this._getDateFromIndex.bind(this);e.intervalLabelFormatter=t.getIntervalLabelFormatter()?t.getIntervalLabelFormatter():function(e){return e};e._getIndexFromDate=this.calcIntervalOffset.bind(this);return e};function Ge(){return this._oTimesRow||this._oDatesRow||this._oMonthsRow||this._oWeeksRow||this._oOneMonthsRow}function $e(){if(!this._getHeader()){return 0}var e=this._getHeader().getDomRef(),t=0,a;if(e){a=e.getBoundingClientRect();t=parseInt(a.height)}return t}function qe(e,t,a){e.events=e.events||{};if(!e.events[t]){e.events[t]=a}else{var i=e.events[t];e.events[t]=function(){a.apply(this,arguments);i.apply(this,arguments)}}}return de});
//# sourceMappingURL=PlanningCalendar.js.map