/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/core/Element","sap/ui/core/Control","./library","./Toolbar","./AssociativeOverflowToolbar","./Button","./AdditionalTextButton","./Popover","./Title","./ToolbarSpacer","./SegmentedButton","sap/ui/core/Lib","sap/ui/unified/Calendar","sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CustomYearPicker","sap/ui/unified/calendar/IndexPicker","sap/base/i18n/date/CalendarType","sap/base/i18n/date/CalendarWeekNumbering","sap/ui/unified/calendar/CalendarDate","sap/ui/core/IconPool","sap/ui/core/InvisibleText","sap/ui/core/library","./PlanningCalendarHeaderRenderer","sap/ui/core/date/UI5Date"],function(e,t,i,o,r,a,n,s,l,c,p,h,d,u,g,_,P,f,y,T,C,A,m,k,v){"use strict";var b=o.ToolbarDesign;var S=i.extend("sap.m.PlanningCalendarHeader",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:""},startDate:{type:"object",group:"Data"},pickerText:{type:"string",group:"Data"},pickerTextInSecondaryType:{type:"string",group:"Data"},calendarWeekNumbering:{type:"sap.base.i18n.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null},_primaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"},_secondaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"}},aggregations:{actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},_actionsToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_navigationToolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"},_monthPicker:{type:"sap.ui.unified.internal.CustomMonthPicker",multiple:false,visibility:"hidden"},_yearPicker:{type:"sap.ui.unified.internal.CustomYearPicker",multiple:false,visibility:"hidden"},_indexPicker:{type:"sap.ui.unified.calendar.IndexPicker",multiple:false,visibility:"hidden"}},events:{pressPrevious:{},pressToday:{},pressNext:{},dateSelect:{},cancel:{},viewChange:{}},associations:{currentPicker:{type:"sap.ui.core.Control",multiple:false}}},renderer:k});var w=3;S.prototype.init=function(){var e=this.getId(),i=e+"-NavToolbar",o=d.getResourceBundleFor("sap.m"),l=this.getProperty("_primaryCalendarType"),c,p,h,f;this.setAggregation("_actionsToolbar",new a(e+"-ActionsToolbar",{design:b.Transparent}).addStyleClass("sapMPCHeadActionsToolbar").addContent(this._getOrCreateTitleControl()).addContent(this._getOrCreateToolbarSpacer()).addContent(this._getOrCreateViewSwitch()));this._oPrevBtn=new n(i+"-PrevBtn",{icon:C.getIconURI("slim-arrow-left"),tooltip:o.getText("PCH_NAVIGATE_BACKWARDS"),press:function(){this.firePressPrevious()}.bind(this)});this._oTodayBtn=new n(i+"-TodayBtn",{text:o.getText("PLANNINGCALENDAR_TODAY"),ariaLabelledBy:A.getStaticId("sap.m","PCH_NAVIGATE_TO_TODAY"),press:function(){this.firePressToday()}.bind(this)});this._oNextBtn=new n(i+"-NextBtn",{icon:C.getIconURI("slim-arrow-right"),tooltip:o.getText("PCH_NAVIGATE_FORWARD"),press:function(){this.firePressNext()}.bind(this)});p=new u(e+"-Cal",{calendarWeekNumbering:this.getCalendarWeekNumbering(),primaryCalendarType:l});p.attachEvent("select",this._handlePickerDateSelect,this);p.attachEvent("cancel",this._handlePickerCancelEvent,this);this.setAggregation("_calendarPicker",p);this._oCalendarAfterRenderDelegate={onAfterRendering:function(){if(this._oPopup&&this._oPopup.isOpen()){p.focus()}}.bind(this)};p.addDelegate(this._oCalendarAfterRenderDelegate);this._oCalendar=p;this.setAssociation("currentPicker",p);h=new g(e+"-MonthCal",{primaryCalendarType:l});h.attachEvent("select",this._handlePickerDateSelect,this);h.attachEvent("cancel",this._handlePickerCancelEvent,this);this.setAggregation("_monthPicker",h);this._oMonthPicker=h;f=new _(e+"-YearCal",{primaryCalendarType:l});f.attachEvent("select",this._handlePickerDateSelect,this);f.attachEvent("cancel",this._handlePickerCancelEvent,this);this.setAggregation("_yearPicker",f);this._oYearPicker=f;var y=new P(e+"-IndexPicker");y.attachEvent("select",this._handleIndexPickerSelect,this);this.setAggregation("_indexPicker",y);this._oIndexPicker=y;this._oPickerBtn=new s(i+"-PickerBtn",{text:this.getPickerText(),additionalText:this.getPickerTextInSecondaryType(),ariaHasPopup:m.aria.HasPopup.Dialog,ariaLabelledBy:A.getStaticId("sap.m","PCH_SELECT_RANGE"),press:function(){if(this.fireEvent("_pickerButtonPress",{},true)){var e=this.getStartDate()||v.getInstance(),i=this.getAssociation("currentPicker"),o;c=t.getElementById(i);if(c instanceof u){o=c.getMinDate();if(o&&o.getTime()>e.getTime()){e=o}}if(c.displayDate){c.displayDate(e)}c.setCalendarWeekNumbering&&c.setCalendarWeekNumbering(this.getCalendarWeekNumbering());this._openCalendarPickerPopup(c)}}.bind(this)});this.setAggregation("_navigationToolbar",new r(i,{design:b.Transparent,content:[this._oPrevBtn,this._oTodayBtn,this._oNextBtn,this._oPickerBtn]}).addStyleClass("sapMPCHeadNavToolbar"))};S.prototype.exit=function(){this._getActionsToolbar().removeAllContent();if(this._oTitle){if(this._oToolbarAfterRenderingDelegate){this._oTitle.removeDelegate(this._oToolbarAfterRenderingDelegate)}this._oTitle.destroy();this._oTitle=null}if(this._oToolbarSpacer){this._oToolbarSpacer.destroy();this._oToolbarSpacer=null}if(this._oViewSwitch){this._oViewSwitch.destroy();this._oViewSwitch=null}if(this._oPopup){if(this._oCalendarAfterRenderDelegate){this._oCalendar.removeDelegate(this._oCalendarAfterRenderDelegate)}this._oPopup.destroy();this._oPopup=null}if(this._oPrevBtn){this._oPrevBtn.destroy();this._oPrevBtn=null}if(this._oNextBtn){this._oNextBtn.destroy();this._oNextBtn=null}};S.prototype.onBeforeRendering=function(){var e=!!this.getActions().length||!!this.getTitle()||this._getOrCreateViewSwitch().getItems().length>1;var t=this.getProperty("_secondaryCalendarType");this._getActionsToolbar().setVisible(e);this.setPrimaryCalendarTypeToPickers(this.getProperty("_primaryCalendarType"));if(t){this.setSecondaryCalendarTypeToPickers(t)}};S.prototype.setTitle=function(e){const t=this._getOrCreateTitleControl();t.setText(e).setVisible(!!e);if(this._oToolbarAfterRenderingDelegate){t.removeDelegate(this._oToolbarAfterRenderingDelegate)}this._oToolbarAfterRenderingDelegate={onAfterRendering:function(){const e=this.getActions().find(e=>e.isA("sap.m.Title"));const i=this.getDomRef().querySelector(`[data-sap-ui='${t.getId()}']`);if(e&&i){i.setAttribute("id",e.getId())}}};t.addDelegate(this._oToolbarAfterRenderingDelegate,this);return this.setProperty("title",e)};S.prototype.addAction=function(e){if(!e){return this}this._getActionsToolbar().addContent(e);return this.addAggregation("actions",e)};S.prototype.insertAction=function(e,t){if(!e){return this}this._getActionsToolbar().insertContent(e,t+w);return this.insertAggregation("actions",e,t)};S.prototype.removeAction=function(e){if(!e){return this}this._getActionsToolbar().removeContent(e);return this.removeAggregation("actions",e)};S.prototype.removeAllActions=function(){var e=this._getActionsToolbar(),t=e.getContent();for(var i=w;i<t.length;i++){e.removeContent(t[i])}return this.removeAllAggregation("actions")};S.prototype.destroyActions=function(){var e=this._getActionsToolbar(),t=e.getContent(),i;for(var o=w;o<t.length;o++){i=e.removeContent(t[o]);i.destroy()}return this};S.prototype.updatePickerText=function(e){if(!e){return this}this.setPickerText(e.primaryType);this.setPickerTextInSecondaryType(e.secondaryType);return true};S.prototype.setPickerTextInSecondaryType=function(e){this.setProperty("pickerTextInSecondaryType",e);this._oPickerBtn.setAdditionalText(e);return this};S.prototype.setPickerText=function(e){if(!e){return this}this.setProperty("pickerText",e);this._oPickerBtn.setText(e);return this};S.prototype.setPrimaryCalendarTypeToPickers=function(e){this._oCalendar.setPrimaryCalendarType(e);this._oMonthPicker.setPrimaryCalendarType(e);this._oYearPicker.setPrimaryCalendarType(e)};S.prototype.setSecondaryCalendarTypeToPickers=function(e){this._oCalendar.setSecondaryCalendarType(e);this._oMonthPicker.setSecondaryCalendarType(e);this._oYearPicker.setSecondaryCalendarType(e)};S.prototype._getOrCreateTitleControl=function(){if(!this._oTitle){this._oTitle=new c(this.getId()+"-Title",{visible:false})}return this._oTitle};S.prototype._getOrCreateToolbarSpacer=function(){if(!this._oToolbarSpacer){this._oToolbarSpacer=new p(this.getId()+"-Spacer")}return this._oToolbarSpacer};S.prototype._getOrCreateViewSwitch=function(){if(!this._oViewSwitch){this._oViewSwitch=new h(this.getId()+"-ViewSwitch",{ariaLabelledBy:A.getStaticId("sap.m","PCH_VIEW_SWITCH")});this._oViewSwitch.attachEvent("selectionChange",this._handleViewSwitchChange,this);this.addDependent(this._oViewSwitch)}return this._oViewSwitch};S.prototype._convertViewSwitchToSelect=function(){this._oViewSwitch._bForcedSelectMode=true;this._oViewSwitch._toSelectMode()};S.prototype._convertViewSwitchToSegmentedButton=function(){this._oViewSwitch._bForcedSelectMode=false;this._oViewSwitch._toNormalMode()};S.prototype._getTodayButton=function(){return this._oTodayBtn};S.prototype._handlePickerDateSelect=function(){var e=this.getAssociation("currentPicker"),i=t.getElementById(e),o=i.getSelectedDates()[0].getStartDate();this.setStartDate(o);this._closeCalendarPickerPopup();this.fireDateSelect()};S.prototype._handleIndexPickerSelect=function(e){var t=this._oIndexPicker.getSelectedIndex();var i=v.getInstance(this._oCalendar.getMinDate());var o=this._getRelativeInfo();i.setDate(i.getDate()+t*o.iIntervalSize);this.setStartDate(i);this._closeCalendarPickerPopup();this.fireDateSelect()};S.prototype._handleViewSwitchChange=function(e){this.fireViewChange(e.getParameters())};S.prototype._openCalendarPickerPopup=function(t){var i,o,r;if(!this._oPopup){this._oPopup=this._createPopup()}i=this._oPopup.getContent();r=A.getStaticId("sap.m",this._getPopoverAccessibleName());this._oPopup.removeAllAssociation("ariaLabelledBy");this._oPopup.addAriaLabelledBy(r);if(i.length){o=this._oPopup.getContent()[0];if(o.isA("sap.ui.unified.internal.CustomYearPicker")){this.setAggregation("_yearPicker",this._oPopup.removeAllContent()[0])}else if(o.isA("sap.ui.unified.internal.CustomMonthPicker")){this.setAggregation("_monthPicker",this._oPopup.removeAllContent()[0])}else if(o.isA("sap.ui.unified.calendar.IndexPicker")){this.setAggregation("_indexPicker",this._oPopup.removeAllContent()[0])}else if(t!==o){this.setAggregation("_calendarPicker",this._oPopup.removeAllContent()[0])}}this._oPopup.addContent(t);this._oPopup.attachAfterOpen(function(){var t=this._oPopup.$();var i=Math.floor((t.width()-this._oPickerBtn.$().width())/2);this._oPopup.setOffsetX(e.getRTL()?i:-i);var o=this._oPickerBtn.$().height();this._oPopup.setOffsetY(this._oPopup._getCalculatedPlacement()==="Top"?o:-o);this._oPopup.getContent()[0].focus()},this);this._oPopup.openBy(this._oPickerBtn.getDomRef())};S.prototype._createPopup=function(){var e=new l({placement:"VerticalPreferredBottom",showHeader:false,showArrow:false,verticalScrolling:false});e.oPopup.setDurations(0,0);e.addDelegate({onsapescape:this.onsapescape},this);this._oPopup=e;return this._oPopup};S.prototype._getPopoverAccessibleName=function(){var e=t.getElementById(this.getAssociation("currentPicker")).getMetadata().getName();switch(e){case"sap.ui.unified.internal.CustomYearPicker":return"DATEPICKER_YEAR_POPOVER_ACCESSIBLE_NAME";case"sap.ui.unified.internal.CustomMonthPicker":return"DATEPICKER_MONTH_POPOVER_ACCESSIBLE_NAME";default:return"DATEPICKER_POPOVER_ACCESSIBLE_NAME"}};S.prototype.onsapescape=function(){if(this._oPopup){this._closeCalendarPickerPopup();if(this._oPickerBtn.getDomRef()){this._oPickerBtn.getDomRef().focus()}}};S.prototype._closeCalendarPickerPopup=function(){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close()}};S.prototype._handlePickerCancelEvent=function(){var e=this._oPickerBtn.getDomRef();this.fireCancel();this._closeCalendarPickerPopup();e&&e.focus()};S.prototype._getActionsToolbar=function(){return this.getAggregation("_actionsToolbar")};S.prototype._getNavigationToolbar=function(){return this.getAggregation("_navigationToolbar")};return S});
//# sourceMappingURL=PlanningCalendarHeader.js.map