/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Bar","./Button","./InstanceManager","./library","./Title","sap/base/i18n/Localization","sap/ui/dom/isElementCovered","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/delegate/ScrollEnablement","sap/ui/core/theming/Parameters","sap/ui/Device","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/core/library","sap/ui/core/Element","sap/ui/core/ResizeHandler","sap/ui/core/StaticArea","./PopoverRenderer","sap/ui/dom/containsOrEquals","sap/ui/dom/units/Rem","sap/ui/thirdparty/jquery","sap/ui/dom/getScrollbarSize","sap/ui/events/KeyCodes","sap/base/Log","sap/base/util/clamp","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/rect"],function(e,t,i,o,r,s,n,a,h,l,f,p,c,d,g,u,_,m,P,v,jQuery,y,w,C,O){"use strict";var H=o.PopupHelper;var B=d.OpenState;var R=o.PlacementType;var A=o.TitleAlignment;var S=a.extend("sap.m.Popover",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Behavior",defaultValue:R.Right},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},title:{type:"string",group:"Appearance",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},offsetX:{type:"int",group:"Appearance",defaultValue:0},offsetY:{type:"int",group:"Appearance",defaultValue:0},showArrow:{type:"boolean",group:"Appearance",defaultValue:true},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentMinWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enableScrolling:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},horizontalScrolling:{type:"boolean",group:"Misc",defaultValue:true},bounce:{type:"boolean",group:"Behavior",defaultValue:null,deprecated:true},resizable:{type:"boolean",group:"Dimension",defaultValue:false},ariaModal:{type:"boolean",group:"Misc",defaultValue:true,visibility:"hidden"},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:A.Auto},ariaRoleApplication:{type:"boolean",group:"Misc",defaultValue:false,visibility:"hidden"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.ui.core.Control",multiple:false},subHeader:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false},_internalHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},beginButton:{type:"sap.ui.core.Control",multiple:false},endButton:{type:"sap.ui.core.Control",multiple:false}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}}},designtime:"sap/m/designtime/Popover.designtime"},renderer:m});S._bIOS7=p.os.ios&&p.os.version>=7&&p.os.version<8&&p.browser.name==="sf";c.call(S.prototype,{header:{suffix:"intHeader"},subHeader:{selector:".sapMPopoverSubHeader .sapMIBar"},content:{suffix:"cont"},footer:{selector:".sapMPopoverFooter .sapMIBar"}});S.prototype.init=function(){this._marginTopInit=false;this._marginTop=48;this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._minDimensions={width:100,height:32};this._initialWindowDimensions={};this.oPopup=new h;this.oPopup.setShadow(true);this.oPopup.setAutoClose(true);this.oPopup.setAnimations(jQuery.proxy(this._openAnimation,this),jQuery.proxy(this._closeAnimation,this));this._placements=[R.Top,R.Right,R.Bottom,R.Left,R.Vertical,R.Horizontal,R.Auto,R.VerticalPreferedTop,R.VerticalPreferedBottom,R.HorizontalPreferedLeft,R.HorizontalPreferedRight,R.VerticalPreferredTop,R.VerticalPreferredBottom,R.HorizontalPreferredLeft,R.HorizontalPreferredRight,R.PreferredRightOrFlip,R.PreferredLeftOrFlip,R.PreferredTopOrFlip,R.PreferredBottomOrFlip];this._myPositions=["center bottom","begin center","center top","end center"];this._atPositions=["center top","end center","center bottom","begin center"];this._offsets=["0 -18","18 0","0 18","-18 0"];this._arrowOffset=18;this._followOfTolerance=32;this._scrollContentList=["sap.m.NavContainer","sap.m.Page","sap.m.ScrollContainer"];this._fnAdjustPositionAndArrow=jQuery.proxy(this._adjustPositionAndArrow,this);this._fnOrientationChange=jQuery.proxy(this._onOrientationChange,this);this._fnFollowOf=jQuery.proxy(function(e){var t=e.lastOfRect,i=e.currentOfRect;if(p.system.desktop&&this.oPopup.isTopmost()&&!this.getModal()&&n(this._getOpenByDomRef(),this.getDomRef())){this.close();return}if(!p.system.desktop||Math.abs(t.top-i.top)<=this._followOfTolerance&&Math.abs(t.left-i.left)<=this._followOfTolerance||Math.abs(t.top+t.height-i.top-i.height)<=this._followOfTolerance&&Math.abs(t.left+t.width-i.left-i.width)<=this._followOfTolerance){this.oPopup._applyPosition(this.oPopup._oLastPosition,true)}else{this.close()}},this);this.setFollowOf(true);this._initResponsivePaddingsEnablement();this._loadThemeParameters();this._oRestoreFocusDelegate={onBeforeRendering:function(){var e=g.closestTo(document.activeElement);this._sFocusControlId=e&&e.getId()},onAfterRendering:function(){if(this._sFocusControlId&&!P(this.getDomRef(),document.activeElement)){g.getElementById(this._sFocusControlId).focus()}}};var e=this;this.oPopup._applyPosition=function(t,i){var o=this.getOpenState(),r;if(o===B.CLOSING||o===B.CLOSED){return}if(i){e._storeScrollPosition()}e._preventDocumentElementScrolling();e._clearCSSStyles();var s=e._placements.indexOf(e.getPlacement());if(s>3&&!e._bPosCalced){e._calcPlacement();e._restoreDocumentElementScrolling();return}e._bPosCalced=false;if(e._oOpenBy instanceof g){t.of=e._getOpenByDomRef()}if(!t.of){C.warning("sap.m.Popover: in function applyPosition, the openBy element doesn't have any DOM output. "+e);e._restoreDocumentElementScrolling();return}if(!P(document.documentElement,t.of)&&t.of.id&&!(t.of.getRootNode()instanceof ShadowRoot)){r=jQuery(document.getElementById(t.of.id));if(r){t.of=r}else{C.warning("sap.m.Popover: in function applyPosition, the openBy element's DOM is already detached from DOM tree and can't be found again by the same id. "+e);e._restoreDocumentElementScrolling();return}}var n=jQuery(t.of).rect();var a=jQuery(e.getWithinAreaDomRef());if(i&&a.height()==e._initialWindowDimensions.height&&(n.top+n.height<=0||n.top>=a.height()||n.left+n.width<=0||n.left>=a.width())){e.close();e._restoreDocumentElementScrolling();return}var l=e.getDomRef("scroll");if(!p.system.desktop){jQuery(window).scrollLeft(0)}e._deregisterContentResizeHandler();h.prototype._applyPosition.call(this,t);e._fnAdjustPositionAndArrow();e._updateResizeHandlePlacement();e._restoreScrollPosition();e._registerContentResizeHandler(l);e._restoreDocumentElementScrolling()};this.oPopup.close=function(t){var i=typeof t==="boolean";var o=this.getOpenState();var r=e._oOpenBy&&e._oOpenBy.getDomRef&&!!e._oOpenBy.getDomRef();if(t!==true&&(this.touchEnabled||!(this._isFocusInsidePopup()&&r))&&this.isOpen()&&!(o===B.CLOSED||o===B.CLOSING)){e.fireBeforeClose({openBy:e._oOpenBy})}e._deregisterContentResizeHandler();e._resetSizes();if(this._sTimeoutId&&arguments.length>1){clearTimeout(this._sTimeoutId);this._sTimeoutId=null;var s=arguments[1];if(typeof s=="string"&&s=="autocloseBlur"&&this._isFocusInsidePopup()){return}}h.prototype.close.apply(this,i?[]:arguments);e.removeDelegate(e._oRestoreFocusDelegate)}};S.prototype.getWithinAreaDomRef=function(){return h.getWithinAreaDomRef()};S.prototype.onBeforeRendering=function(){var e,t,i,o=this.getHorizontalScrolling(),r=this.getVerticalScrolling(),s=!o||this.isPropertyInitial("horizontalScrolling"),n=!r||this.isPropertyInitial("verticalScrolling"),h=this.getCustomHeader()||this._internalHeader;if(this.hasStyleClass("sapUiPopupWithPadding")){C.warning("Usage of CSS class 'sapUiPopupWithPadding' is deprecated. Use 'sapUiContentPadding' instead",null,"sap.m.Popover")}if(!this._initialWindowDimensions.width||!this._initialWindowDimensions.height){i=jQuery(this.getWithinAreaDomRef());this._initialWindowDimensions={width:i.width(),height:i.height()}}this._hasSingleScrollableContent();if(!o&&!r){this._forceDisableScrolling=true}else if(s&&n&&this._singleScrollableContent){this._forceDisableScrolling=true;C.info("VerticalScrolling and horizontalScrolling in sap.m.Popover with ID "+this.getId()+" has been disabled because there's scrollable content inside")}else{this._forceDisableScrolling=false}if(!this._forceDisableScrolling){if(!this._oScroller){this._oScroller=new l(this,this.getId()+"-scroll",{horizontal:o,vertical:r,callBefore:true})}else{this._oScroller.setHorizontal(o);this._oScroller.setVertical(r)}}if(this._bContentChanged){this._bContentChanged=false;e=this._getSingleNavContent();t=this._getSinglePageContent();if(e&&!this.getModal()&&!p.system.phone){e.attachEvent("afterNavigate",function(e){var t=this.getDomRef();if(t){var i=this.$().firstFocusableDomRef()||t;i.focus()}},this)}if(e||t){t=t||e.getCurrentPage();if(t&&t._getAnyHeader){this.addStyleClass("sapMPopoverWithHeaderCont")}if(e){e.attachEvent("navigate",function(e){var t=e.getParameter("to");if(t instanceof a&&t.isA("sap.m.Page")){this.$().toggleClass("sapMPopoverWithHeaderCont",!!t._getAnyHeader())}},this)}}}this._setHeaderTitle();if(!p.system.desktop){this.setResizable(false)}if(h&&h.setTitleAlignment){h.setTitleAlignment(this.getTitleAlignment())}};S.prototype.onAfterRendering=function(){var e,t,i;if(!this._marginTopInit&&this.getShowArrow()){this._marginTop=2;if(this._oOpenBy){e=jQuery(this._getOpenByDomRef());if(!(e.closest("header.sapMIBar").length>0)){t=e.closest(".sapMPage");if(t.length>0){i=t.children("header.sapMIBar");if(i.length>0){this._marginTop+=i.outerHeight()}}}this._marginTopInit=true}}this._repositionOffset()};S.prototype.exit=function(){this._removeDocumentEventListeners();this._deregisterContentResizeHandler();p.resize.detachHandler(this._fnOrientationChange);i.removePopoverInstance(this);this.removeDelegate(this._oRestoreFocusDelegate);this._oRestoreFocusDelegate=null;this._sResizeHandleClass=null;if(this.oPopup){this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null}if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._internalHeader){this._internalHeader.destroy();this._internalHeader=null}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null}};S.prototype.openBy=function(e,t){if(!this.getVisible()){return this}var r=this.oPopup,s=this.oPopup.getOpenState(),n=this._getInitialFocusId(),a,l,f;a=e.getDomRef&&e.getDomRef()||e;f=jQuery(a).closest(".sapUiSizeCompact");this._bSizeCompact=o._bSizeCompact||!!f.length||this.hasStyleClass("sapUiSizeCompact");this._adaptPositionParams();if(s===B.OPEN||s===B.OPENING){if(this._oOpenBy===e){return this}else{var c=function(){r.detachClosed(c,this);this.openBy(e)};r.attachClosed(c,this);this._oPreviousFocus=null;this.close();return this}}if(!e){return this}if(p.support.touch){p.resize.attachHandler(this._fnOrientationChange)}if(!this._oOpenBy||e!==this._oOpenBy){this._oOpenBy=e}this._addDocumentEventListeners();this.fireBeforeOpen({openBy:this._oOpenBy});r.attachOpened(this._handleOpened,this);r.attachClosed(this._handleClosed,this);r.setInitialFocusId(n);l=this._placements.indexOf(this.getPlacement());if(l>-1){a=this._getOpenByDomRef();if(!a){C.error("sap.m.Popover id = "+this.getId()+": is opened by a control which isn't rendered yet.");return this}r.setExtraContent([e]);r.setContent(this);if(l<=3){r.setPosition(this._myPositions[l],this._atPositions[l],a,this._calcOffset(this._offsets[l]),"fit")}else{r._oPosition.of=a}var d=this;var g=function(){if(r.bIsDestroyed){return}if(r.getOpenState()===B.CLOSING){if(d._sOpenTimeout){clearTimeout(d._sOpenTimeout);d._sOpenTimeout=null}d._sOpenTimeout=setTimeout(g,150)}else{d._oPreviousFocus=h.getCurrentFocusInfo();d._preventDocumentElementScrolling();r.open();d._restoreDocumentElementScrolling();d.addDelegate(d._oRestoreFocusDelegate,d);if(!t){i.addPopoverInstance(d)}}};g()}else{C.error(this.getPlacement()+"is not a valid value! It can only be top, right, bottom or left")}return this};S.prototype.close=function(){var e=this.oPopup.getOpenState(),t,i;if(e===B.CLOSED||e===B.CLOSING){return this}this._removeDocumentEventListeners();this.fireBeforeClose({openBy:this._oOpenBy});this.oPopup.close(true);if(this._oPreviousFocus){i=document.activeElement||{};t=this._oPreviousFocus.sFocusId===g.getActiveElement()?.getId()||this._oPreviousFocus.sFocusId===i.id;if(!t){h.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null}}return this};S.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen()};S.prototype.setFollowOf=function(e){if(e){this.oPopup.setFollowOf(this._fnFollowOf)}else{this.oPopup.setFollowOf(false)}return this};S.prototype.onThemeChanged=function(){this._loadThemeParameters()};S.prototype._clearCSSStyles=function(){if(!this.getDomRef()){return}var e=this.getDomRef().style,t=this.$("cont"),i=t.children(".sapMPopoverScroll"),o=t[0].style,r=i[0].style,s=this._getActualContentWidth(),n=this._getActualContentHeight(),a=this.$("arrow"),h,l,f=jQuery(this.getWithinAreaDomRef());if(s.indexOf("%")>0){h=f.width();s=H.calcPercentageSize(s,h)}if(n.indexOf("%")>0){l=f.height();n=H.calcPercentageSize(n,l)}o.width=s||"";o.height=n||"";o.maxWidth="";o.maxHeight="";e.left="";e.right="";e.top="";e.bottom="";e.width=this.isResized()&&s?s:"";e.height="";r.width="";r.display="";a.removeClass("sapMPopoverArrRight sapMPopoverArrLeft sapMPopoverArrDown sapMPopoverArrUp sapMPopoverCrossArr sapMPopoverFooterAlignArr sapMPopoverHeaderAlignArr sapContrast sapContrastPlus");a.css({left:"",top:""})};S.prototype._onOrientationChange=function(){var e=this.oPopup&&this.oPopup.getOpenState()||{};if(e!==B.OPEN&&e!==B.OPENING){return}this.oPopup._applyPosition(this.oPopup._oLastPosition,true);this._includeScrollWidth()};S.prototype._includeScrollWidth=function(){var e=this._getActualContentWidth(),t=this.$(),i=Math.floor(window.innerWidth*.9),o=this.$("cont");if(!o[0]){return}if(p.system.desktop&&p.browser.safari){var r=o[0].clientHeight<o[0].scrollHeight;if(r&&(!e||e==="auto")&&o.width()<i){t.addClass("sapMPopoverVerticalScrollIncluded")}else{t.removeClass("sapMPopoverVerticalScrollIncluded")}}};S.prototype._handleOpened=function(){var e=this;this.oPopup.detachOpened(this._handleOpened,this);if(!p.support.touch){setTimeout(function(){!e.bIsDestroyed&&p.resize.attachHandler(e._fnOrientationChange)},0)}var t=this._getInitialFocusId(),i=g.getElementById(t),o=t?window.document.getElementById(t):null;if(i&&i.getFocusDomRef()){i.getFocusDomRef().focus()}else if(!i&&o){o.focus()}this.fireAfterOpen({openBy:this._oOpenBy})};S.prototype._handleClosed=function(){this.oPopup.detachClosed(this._handleClosed,this);p.resize.detachHandler(this._fnOrientationChange);i.removePopoverInstance(this);if(!this.oPopup._bModal&&!p.system.desktop&&document.activeElement&&!jQuery(document.activeElement).is(":visible")){document.activeElement.blur()}this.fireAfterClose({openBy:this._oOpenBy})};S.prototype.onfocusin=function(e){var t=e.target,i=this.$(),o=this.getId()+"-firstfe",r=this.getId()+"-middlefe",s=this.getId()+"-lastfe";if(t.id===o){var n=i.lastFocusableDomRef();if(n){n.focus()}else{document.getElementById(r).focus()}}else if(t.id===s){var a=i.firstFocusableDomRef();if(a){a.focus()}else{document.getElementById(r).focus()}}};S.prototype.onkeydown=function(e){var t=w,i=e.which||e.keyCode,o=e.altKey;this._isSpacePressed=this._isSpacePressed||t.SPACE===i;if(!this._isSpacePressed&&i===t.ESCAPE||o&&i===t.F4){if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return}this.close();e.stopPropagation();e.preventDefault()}};S.prototype.onkeyup=function(e){var t=w,i=e.which||e.keyCode;if(t.SPACE===i){this._isSpacePressed=false}};S.prototype._getResizeHandlePlacement=function(){if(this._resizeHandlePlacement){return this._resizeHandlePlacement}const e=this.getDomRef().querySelector(".sapMPopoverWrapper");const t=this._getOpenByDomRef();const i=2;const o=t.getBoundingClientRect();const r=e.getBoundingClientRect();let n=Math.floor(o.x+o.width/2);const a=Math.floor(o.y+o.height/2);let h=Math.floor(r.x+r.width/2);const l=Math.floor(r.y+r.height/2);if(s.getRTL()){n=-n;h=-h}switch(this._getCalculatedPlacement()){case R.Left:if(l>a+i){return"BottomLeft"}return"TopLeft";case R.Right:if(l+i<a){return"TopRight"}return"BottomRight";case R.Bottom:if(!this.getShowArrow()){return"BottomRight"}if(h+i<n){return"BottomLeft"}return"BottomRight";case R.Top:default:if(!this.getShowArrow()){return"TopRight"}if(h+i<n){return"TopLeft"}return"TopRight"}};S.prototype.onmousedown=function(e){if(!e.target.closest(".sapMPopoverResizeHandle")){return}const t=jQuery(document);const i=this.$();const o=this.$("cont");const r=o.height();const s=this.$("arrow");const n=this.$("scroll");const a=this._getCalculatedPlacement();const h=this._getPositionParams(i,s,o,n);const l=this._getContentDimensionsCss(h);i.addClass("sapMPopoverResizing");e.preventDefault();e.stopPropagation();const f={x:e.pageX,y:e.pageY,width:i.width(),height:r,maxWidth:parseFloat(l["max-width"]),maxHeight:parseFloat(l["max-height"]),footerHeaderHeight:i.height()-r,offsetX:this._getActualOffsetX(),offsetY:this._getActualOffsetY(),left:parseFloat(i.css("left")),top:parseFloat(i.css("top")),posParams:this._recalculateMargins(a,h)};const p=this.oPopup.getAutoClose();this.oPopup.setAutoClose(false);this._resizeHandlePlacement=this._getResizeHandlePlacement();t.on("mousemove.sapMPopover",e=>{this._resize(f,e)});t.on("mouseup.sapMPopover",()=>{i.removeClass("sapMPopoverResizing");t.off("mouseup.sapMPopover, mousemove.sapMPopover");this._resizeHandlePlacement=null;if(this.oPopup){this.oPopup.setAutoClose(p)}})};S.prototype._resize=function(e,t){this._resized=true;const i=this._getCalculatedPlacement();const o=this._getResizeHandlePlacement();const r=e.posParams;const n=r._fWithinAreaWidth;const a=r._fWithinAreaHeight;const h=s.getRTL();let l;let f=e.y-t.pageY;let p;let c;let d;let g;if(h){l=e.x-t.pageX}else{l=t.pageX-e.x}let u;let _;if(h){_=e.width+e.left-r._fPopoverMarginLeft;u=n-e.left-r._fPopoverMarginRight}else{u=e.width+e.left-r._fPopoverMarginLeft;_=n-e.left-r._fPopoverMarginRight}const m=e.height+e.top-r._fPopoverMarginTop;const P=a-e.footerHeaderHeight-e.top-r._fPopoverMarginBottom;if(!this.getShowArrow()&&(i===R.Top||i===R.Bottom)){if(i===R.Bottom){f=-f}this.resizedWidth=Math.max(e.width+l,this._minDimensions.width)+"px";this.resizedHeight=Math.max(e.height+f,this._minDimensions.height)+"px";this.invalidate();return}switch(i){case R.Top:c=O(e.height+f,this._minDimensions.height,m);if(o==="TopRight"){p=O(e.width+l,this._minDimensions.width,_);d=Math.max(0,e.offsetX+(p-e.width)/2)}else{p=O(e.width-l,this._minDimensions.width,u);d=Math.min(-1,e.offsetX+(e.width-p)/2)}this.resizedOffsetX=Math.round(d);break;case R.Bottom:c=O(e.height-f,this._minDimensions.height,P);if(o==="BottomRight"){p=O(e.width+l,this._minDimensions.width,_);d=Math.max(0,e.offsetX+(p-e.width)/2)}else{p=O(e.width-l,this._minDimensions.width,u);d=Math.min(-1,e.offsetX+(e.width-p)/2)}this.resizedOffsetX=Math.round(d);break;case R.Left:p=O(e.width-l,this._minDimensions.width,u);if(o==="TopLeft"){c=O(e.height+f,this._minDimensions.height,m);g=Math.min(0,e.offsetY+(e.height-c)/2)}else{c=O(e.height-f,this._minDimensions.height,P);g=Math.max(1,e.offsetY+(c-e.height)/2)}this.resizedOffsetY=Math.round(g);break;case R.Right:p=O(e.width+l,this._minDimensions.width,_);if(o==="TopRight"){c=O(e.height+f,this._minDimensions.height,m);g=Math.min(-1,e.offsetY+(e.height-c)/2)}else{c=O(e.height-f,this._minDimensions.height,P);g=Math.max(0,e.offsetY+(c-e.height)/2)}this.resizedOffsetY=Math.round(g);break}this.resizedWidth=`${p}px`;this.resizedHeight=`${c}px`;this.invalidate();this._calcPlacement()};S.prototype.isResized=function(){return this._resized};S.prototype._resetSizes=function(){this._resized=false;delete this.resizedOffsetX;delete this.resizedOffsetY;delete this.resizedWidth;delete this.resizedHeight};S.prototype._getActualContentWidth=function(){return this.resizedWidth!==undefined?this.resizedWidth:this.getContentWidth()};S.prototype._getActualContentHeight=function(){return this.resizedHeight!==undefined?this.resizedHeight:this.getContentHeight()};S.prototype._getActualOffsetX=function(){return this.resizedOffsetX!==undefined?this.resizedOffsetX:this.getOffsetX()};S.prototype._getActualOffsetY=function(){return this.resizedOffsetY!==undefined?this.resizedOffsetY:this.getOffsetY()};S.prototype._hasSingleNavContent=function(){return!!this._getSingleNavContent()};S.prototype._getSingleNavContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof a&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent()}if(e.length===1&&e[0]instanceof a&&e[0].isA("sap.m.NavContainer")){return e[0]}else{return null}};S.prototype._getSinglePageContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof a&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent()}if(e.length===1&&e[0]instanceof a&&e[0].isA("sap.m.Page")){return e[0]}else{return null}};S.prototype._hasSinglePageContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof a&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent()}if(e.length===1&&e[0]instanceof a&&e[0].isA("sap.m.Page")){return true}else{return false}};S.prototype._hasSingleScrollableContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof a&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent()}if(e.length===1&&e[0]instanceof a&&e[0].isA(this._scrollContentList)){this._singleScrollableContent=true}else{this._singleScrollableContent=false}};S.prototype._getOffsetX=function(){var e=this.getPlacement(),t=0;if(this._bHorizontalFlip){var i=this._getOpenByDomRef();var o=i!==undefined;var r=o?i.getBoundingClientRect().width:0;t=e===R.PreferredRightOrFlip?Math.abs(r):-Math.abs(r)}var n=s.getRTL();var a=t*(n?-1:1)+this._getActualOffsetX()*(n?-1:1);return a};S.prototype._getOffsetY=function(){var e=this.getPlacement(),t=0;if(this._bVerticalFlip){var i=this._getOpenByDomRef();var o=i!==undefined;var r=o?i.getBoundingClientRect().height:0;t=e==="PreferredTopOrFlip"?-Math.abs(r):Math.abs(r)}return t+this._getActualOffsetY()};S.prototype._calcOffset=function(e){var t=this._getOffsetX(),i=this._getOffsetY();var o=e.split(" ");return parseInt(o[0])+t+" "+(parseInt(o[1])+i)};S.prototype._calcPlacement=function(){var e=this.getPlacement();var t=this._getOpenByDomRef();switch(e){case R.Auto:this._calcAuto();break;case R.Vertical:case R.VerticalPreferedTop:case R.VerticalPreferredTop:case R.VerticalPreferedBottom:case R.VerticalPreferredBottom:case R.PreferredTopOrFlip:case R.PreferredBottomOrFlip:this._calcVertical();break;case R.Horizontal:case R.HorizontalPreferedLeft:case R.HorizontalPreferredLeft:case R.HorizontalPreferedRight:case R.HorizontalPreferredRight:case R.PreferredRightOrFlip:case R.PreferredLeftOrFlip:this._calcHorizontal();break}this._bPosCalced=true;var i=this._placements.indexOf(this._oCalcedPos);this.oPopup.setPosition(this._myPositions[i],this._atPositions[i],t,this._calcOffset(this._offsets[i]),"fit")};S.prototype._getDocHeight=function(){var e=document.body,t=document.documentElement,i=this.getWithinAreaDomRef(),o=i!==window?jQuery(i).offset():{top:0};return o.top+Math.max(e.scrollHeight,e.offsetHeight,t.clientHeight,t.offsetHeight)};S.prototype._calcVertical=function(){var e=jQuery(this._getOpenByDomRef());var t=e[0]!==undefined;var i=this.getPlacement()===R.VerticalPreferedTop||this.getPlacement()===R.VerticalPreferredTop;var o=this.getPlacement()===R.VerticalPreferedBottom||this.getPlacement()===R.VerticalPreferredBottom;var r=this.getPlacement()===R.PreferredTopOrFlip;var s=this.getPlacement()===R.PreferredBottomOrFlip;var n=t?e[0].getBoundingClientRect().top:0;var a=t?e[0].getBoundingClientRect().height:0;var h=this._getOffsetY();var l=n-this._marginTop+h;var f=this.$().outerHeight();var p=this._getDocHeight()-(e.offset().top+a+this._marginBottom+h);if(i&&l>f+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=R.Top}else if(r){if(l>f+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=R.Top}else{this._bVerticalFlip=true;this._oCalcedPos=R.Bottom}}else if(o&&p>f+this._arrowOffset){this._oCalcedPos=R.Bottom;this._bVerticalFlip=false}else if(s){if(p>f+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=R.Bottom}else{this._bVerticalFlip=true;this._oCalcedPos=R.Top}}else if(l>p){this._oCalcedPos=R.Top}else{this._oCalcedPos=R.Bottom}};S.prototype._calcHorizontal=function(){var e=jQuery(this._getOpenByDomRef());var t=e[0]!==undefined;var i=this.getPlacement()===R.HorizontalPreferedLeft||this.getPlacement()===R.HorizontalPreferredLeft;var o=this.getPlacement()===R.HorizontalPreferedRight||this.getPlacement()===R.HorizontalPreferredRight;var r=t?e[0].getBoundingClientRect().left:0;var n=t?e[0].getBoundingClientRect().width:0;var a=this._getOffsetX();var h=r-this._marginLeft+a;var l=r+n;var f=jQuery(this.getWithinAreaDomRef());var p=f.width()-l-this._marginRight-a;var c=this.$().outerWidth();var d=this.getPlacement()===R.PreferredLeftOrFlip;var g=this.getPlacement()===R.PreferredRightOrFlip;var u=s.getRTL();if(i&&h>c+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=u?R.Right:R.Left}else if(d){if(h>c+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=u?R.Right:R.Left}else{this._bHorizontalFlip=true;this._oCalcedPos=u?R.Left:R.Right}}else if(o&&p>c+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=u?R.Left:R.Right}else if(g){if(p>c+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=u?R.Left:R.Right}else{this._bHorizontalFlip=true;this._oCalcedPos=u?R.Right:R.Left}}else if(h>p){this._oCalcedPos=u?R.Right:R.Left}else{this._oCalcedPos=u?R.Left:R.Right}};S.prototype._calcAuto=function(){var e=jQuery(this.getWithinAreaDomRef());if(e.width()>e.height()){if(this._checkHorizontal()){this._calcHorizontal()}else if(this._checkVertical()){this._calcVertical()}else{this._calcBestPos()}}else if(this._checkVertical()){this._calcVertical()}else if(this._checkHorizontal()){this._calcHorizontal()}else{this._calcBestPos()}};S.prototype._checkHorizontal=function(){var e=jQuery(this._getOpenByDomRef());var t=e[0]!==undefined;var i=t?e[0].getBoundingClientRect().left:0;var o=t?e[0].getBoundingClientRect().width:0;var r=this._getOffsetX();var s=i-this._marginLeft+r;var n=i+o;var a=jQuery(this.getWithinAreaDomRef());var h=a.width()-n-this._marginRight-r;var l=this.$();var f=l.outerWidth()+this._arrowOffset;if(f<=s||f<=h){return true}};S.prototype._checkVertical=function(){var e=jQuery(this._getOpenByDomRef());var t=e[0]!==undefined;var i=t?e[0].getBoundingClientRect().top:0;var o=t?e[0].getBoundingClientRect().height:0;var r=this._getOffsetY();var s=i-this._marginTop+r;var n=this._getDocHeight()-e.offset().top-o-this._marginBottom-r;var a=this.$();var h=a.outerHeight()+this._arrowOffset;if(h<=s||h<=n){return true}};S.prototype._calcBestPos=function(){var e=this.$();var t=e.outerHeight();var i=e.outerWidth();var o=s.getRTL();var r=jQuery(this._getOpenByDomRef());var n=r[0]!==undefined;var a=n?r[0].getBoundingClientRect().left:0;var h=n?r[0].getBoundingClientRect().top:0;var l=n?r[0].getBoundingClientRect().width:0;var f=n?r[0].getBoundingClientRect().height:0;var p=this._getOffsetX();var c=this._getOffsetY();var d=h-this._marginTop+c;var g=this._getDocHeight()-r.offset().top-f-this._marginBottom-c;var u=a-this._marginLeft+p;var _=a+l;var m=jQuery(this.getWithinAreaDomRef());var P=m.width()-_-this._marginRight-p;var v=t*i;var y;var w;if(m.height()-this._marginTop-this._marginBottom>=t){y=t}else{y=m.height()-this._marginTop-this._marginBottom}if(m.width()-this._marginLeft-this._marginRight>=i){w=i}else{w=m.width()-this._marginLeft-this._marginRight}var C=y*u/v;var O=y*P/v;var H=w*d/v;var B=w*g/v;var A=Math.max(C,O);var S=Math.max(H,B);if(A>S){if(A===C){this._oCalcedPos=o?R.Right:R.Left}else if(A===O){this._oCalcedPos=o?R.Left:R.Right}}else if(S>A){if(S===H){this._oCalcedPos=R.Top}else if(S===B){this._oCalcedPos=R.Bottom}}else if(S===A){if(m.height()>m.width()){if(S===H){this._oCalcedPos=R.Top}else if(S===B){this._oCalcedPos=R.Bottom}}else{if(A===C){this._oCalcedPos=o?R.Right:R.Left}else if(A===O){this._oCalcedPos=o?R.Left:R.Right}}}};S.outerWidth=function(e,t){if(typeof window.SVGElement!=="undefined"&&e instanceof window.SVGElement){return e.getBoundingClientRect().width}return jQuery(e).outerWidth(!!t)};S.outerHeight=function(e,t){if(typeof window.SVGElement!=="undefined"&&e instanceof window.SVGElement){return e.getBoundingClientRect().height}return jQuery(e).outerHeight(!!t)};S.prototype._getPositionParams=function(e,t,i,o){var r=window.getComputedStyle(e[0]),s=window.getComputedStyle(i[0]),n=jQuery(window),a=this.getDomRef().clientHeight!==this.getDomRef().scrollHeight?y().width:0,h=jQuery(this.getWithinAreaDomRef()),l=h[0]!==window?h.offset():{top:0,left:0},f={};f._$popover=e;f._$parent=jQuery(this._getOpenByDomRef());f._$arrow=t;f._$content=i;f._$scrollArea=o;f._$header=e.children(".sapMPopoverHeader");f._$subHeader=e.children(".sapMPopoverSubHeader");f._$footer=e.children(".sapMPopoverFooter");f._fWindowTop=n.scrollTop();f._fWindowRight=n.width();f._fWindowBottom=S._bIOS7&&p.orientation.landscape&&window.innerHeight?window.innerHeight:n.height();f._fWindowLeft=n.scrollLeft();f._fWindowWidth=window.innerWidth;f._fWindowHeight=window.innerHeight;f._fWithinAreaWidth=Math.min(h.outerWidth(),f._fWindowWidth);f._fWithinAreaHeight=Math.min(h.outerHeight(),f._fWindowHeight);f._fDocumentWidth=f._fWindowLeft+f._fWindowRight;f._fDocumentHeight=f._fWindowTop+f._fWindowBottom;f._fArrowHeight=t.outerHeight(true);f._fPopoverWidth=S.outerWidth(e[0]);f._fPopoverInnerWidth=f._$scrollArea?f._$scrollArea.width()+a:0;f._fPopoverHeight=S.outerHeight(e[0]);f._fHeaderHeight=f._$header.length>0?f._$header.outerHeight(true):0;f._fSubHeaderHeight=f._$subHeader.length>0?f._$subHeader.outerHeight(true):0;f._fFooterHeight=f._$footer.length>0?f._$footer.outerHeight(true):0;f._fPopoverOffset=e.offset();f._fPopoverOffsetX=this._getOffsetX();f._fPopoverOffsetY=this._getOffsetY();f._fPopoverMarginTop=f._fWindowTop+this._marginTop+l.top+this._fThickShadowSize;f._fPopoverMarginLeft=f._fWindowLeft+this._marginLeft+l.left+this._fThickShadowSize;f._fPopoverMarginRight=f._fWindowWidth-l.left-f._fWithinAreaWidth+this._marginRight+this._fThickShadowSize;f._fPopoverMarginBottom=f._fWindowHeight-l.top-f._fWithinAreaHeight+this._marginBottom+this._fThickShadowSize;f._fPopoverBorderTop=parseFloat(r.borderTopWidth);f._fPopoverBorderRight=parseFloat(r.borderRightWidth);f._fPopoverBorderBottom=parseFloat(r.borderBottomWidth);f._fPopoverBorderLeft=parseFloat(r.borderLeftWidth);f._fContentMarginTop=parseFloat(s.marginTop);f._fContentMarginBottom=parseFloat(s.marginBottom);return f};S.prototype._recalculateMargins=function(e,t){var i;var o=s.getRTL();switch(e){case R.Left:if(o){t._fPopoverMarginLeft=t._$parent.offset().left+S.outerWidth(t._$parent[0],false)+this._arrowOffset-t._fPopoverOffsetX+this._fThickShadowSize}else{t._fPopoverMarginRight=t._fWindowWidth-t._$parent.offset().left+this._arrowOffset-t._fPopoverOffsetX+this._fThickShadowSize}break;case R.Right:if(o){t._fPopoverMarginRight=t._fWindowWidth-S.outerWidth(t._$parent[0],false)-t._$parent.offset().left+this._arrowOffset+this._fThickShadowSize}else{t._fPopoverMarginLeft=t._$parent.offset().left+S.outerWidth(t._$parent[0],false)+this._arrowOffset+t._fPopoverOffsetX+this._fThickShadowSize}break;case R.Top:i=t._fWindowHeight-t._$parent.offset().top+this._arrowOffset-t._fPopoverOffsetY+this._fThickShadowSize;t._fPopoverMarginBottom=i>t._fPopoverMarginBottom?i:t._fPopoverMarginBottom;break;case R.Bottom:t._fPopoverMarginTop=t._$parent.offset().top+S.outerHeight(t._$parent[0],false)+this._arrowOffset+t._fPopoverOffsetY+this._fThickShadowSize;break;default:break}return t};S.prototype._getPopoverPositionCss=function(e){var t,i,o,r,n=e._fDocumentWidth-e._fPopoverOffset.left-e._fPopoverWidth,a=e._fDocumentHeight-e._fPopoverOffset.top-e._fPopoverHeight,h=e._fDocumentWidth-e._fPopoverMarginRight-e._fPopoverMarginLeft<e._fPopoverWidth,l=e._fDocumentHeight-e._fPopoverMarginTop-e._fPopoverMarginBottom<e._fPopoverHeight,f=e._fPopoverOffset.left<e._fPopoverMarginLeft,p=this.getVerticalScrolling()&&e._fPopoverWidth!==e._fPopoverInnerWidth?y().width:0,c=n<e._fPopoverMarginRight+p,d=e._fPopoverOffset.top<e._fPopoverMarginTop,g=a<e._fPopoverMarginBottom,u=s.getRTL();if(h){t=e._fPopoverMarginLeft;i=e._fPopoverMarginRight}else if(f){t=e._fPopoverMarginLeft;if(u){i=""}}else if(c){i=e._fPopoverMarginRight;t=""}if(l){o=e._fPopoverMarginTop;r=e._fPopoverMarginBottom}else if(d){o=e._fPopoverMarginTop}else if(g){r=e._fPopoverMarginBottom;o=""}var _={top:o,bottom:r-e._fWindowTop,left:t,right:typeof i==="number"?i-e._fWindowLeft:i};return _};S.prototype._getContentDimensionsCss=function(e){var t={},i=this._getMaxContentWidth(e),o=this._getMaxContentHeight(e);o=Math.max(o,0);t["max-width"]=i+"px";t["max-height"]=o+"px";return t};S.prototype._getMaxContentWidth=function(e){var t=e._fPopoverBorderLeft+e._fPopoverBorderRight;return e._fDocumentWidth-e._fPopoverMarginLeft-e._fPopoverMarginRight-t};S.prototype._getMaxContentHeight=function(e){var t=e._fHeaderHeight+e._fSubHeaderHeight+e._fFooterHeight+e._fContentMarginTop+e._fContentMarginBottom+e._fPopoverBorderTop+e._fPopoverBorderBottom;return e._fDocumentHeight-e._fPopoverMarginTop-e._fPopoverMarginBottom-t};S.prototype._isHorizontalScrollbarNeeded=function(e){return this.getHorizontalScrolling()&&e._$scrollArea.outerWidth(true)<=e._$content.width()};S.prototype._getArrowOffsetCss=function(e,t){var i,o=s.getRTL();t._fPopoverWidth=t._$popover.outerWidth();t._fPopoverHeight=t._$popover.outerHeight();if(e===R.Left||e===R.Right){i=t._$parent.offset().top-t._$popover.offset().top-t._fPopoverBorderTop+t._fPopoverOffsetY+.5*(S.outerHeight(t._$parent[0],false)-t._$arrow.outerHeight(false));i=Math.max(i-this._getOffsetY(),this._arrowOffset);i=Math.min(i,t._fPopoverHeight-this._arrowOffset-t._$arrow.outerHeight());return{top:i}}else if(e===R.Top||e===R.Bottom){if(o){i=t._$popover.offset().left+S.outerWidth(t._$popover[0],false)-(t._$parent.offset().left+S.outerWidth(t._$parent[0],false))+t._fPopoverBorderRight+t._fPopoverOffsetX+.5*(S.outerWidth(t._$parent[0],false)-t._$arrow.outerWidth(false));i=Math.max(i-this._getOffsetX(),this._arrowOffset);i=Math.min(i,t._fPopoverWidth-this._arrowOffset-t._$arrow.outerWidth(false));return{right:i}}else{i=t._$parent.offset().left-t._$popover.offset().left-t._fPopoverBorderLeft+t._fPopoverOffsetX+.5*(S.outerWidth(t._$parent[0],false)-t._$arrow.outerWidth(false));i=Math.max(i-this._getOffsetX(),this._arrowOffset);i=Math.min(i,t._fPopoverWidth-this._arrowOffset-t._$arrow.outerWidth(false));return{left:i}}}};S.prototype._getArrowPositionCssClass=function(e){switch(e){case R.Left:return"sapMPopoverArrRight";case R.Right:return"sapMPopoverArrLeft";case R.Top:return"sapMPopoverArrDown";case R.Bottom:return"sapMPopoverArrUp"}};S.prototype._getArrowStyleCssClass=function(e){var t=e._$arrow.position(),i=e._$footer.position(),o=this._getSingleNavContent(),r=this._getSinglePageContent(),s=0;if(o||r){r=r||o.getCurrentPage();if(r){s=r._getAnyHeader().$().outerHeight()}}if(t.top+e._fArrowHeight<e._fHeaderHeight+e._fSubHeaderHeight||t.top+e._fArrowHeight<s){return"sapMPopoverHeaderAlignArr"}else if(t.top<e._fHeaderHeight+e._fSubHeaderHeight||t.top<s||e._$footer.length&&t.top+e._fArrowHeight>i.top&&t.top<i.top){return"sapMPopoverCrossArr"}else if(e._$footer.length&&t.top>i.top){return"sapMPopoverFooterAlignArr"}};S.prototype._getCalculatedPlacement=function(){return this._oCalcedPos||this.getPlacement()};S.prototype._adjustPositionAndArrow=function(){var e=this.oPopup.getOpenState();if(!(e===B.OPEN||e===B.OPENING)){return}this._beforeAdjustPositionAndArrowHook();var t=this.$(),i=this.$("arrow"),o=this.$("cont"),r=this.$("scroll"),s=this._getCalculatedPlacement(),n=this._getPositionParams(t,i,o,r);n=this._recalculateMargins(s,n);var a=this._getPopoverPositionCss(n),h=this._getContentDimensionsCss(n),l=this._isHorizontalScrollbarNeeded(n);t.css(a);o.css(h);if(l){r.css("display","block")}if(this.getShowArrow()){var f=this._getArrowOffsetCss(s,n),p=this._getArrowPositionCssClass(s),c,d;i.removeAttr("style");i.css(f);i.addClass(p);if(s===R.Top&&n._$footer&&n._$footer.length){d=true}if(s===R.Left||s===R.Right){c=this._getArrowStyleCssClass(n);if(c){i.addClass(c);if(c==="sapMPopoverFooterAlignArr"){d=true}}}if(d){i.addClass("sapContrast sapContrastPlus")}}this._afterAdjustPositionAndArrowHook()};S.prototype._updateResizeHandlePlacement=function(){if(!this.getResizable()){return}const e=this.getDomRef();const t=`sapMPopoverResizeHandle${this._getResizeHandlePlacement()}`;if(this._sResizeHandleClass){e.classList.remove(this._sResizeHandleClass)}e.classList.add(t);this._sResizeHandleClass=t};S.prototype._adaptPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;if(this._bSizeCompact){this._arrowOffset=this._fArrowOffsetCompactParameter}else{this._arrowOffset=this._fArrowOffsetParameter}this._offsets=[`0 -${this._arrowOffset}`,`${this._arrowOffset} 0`,`0 ${this._arrowOffset}`,`-${this._arrowOffset} 0`];this._myPositions=["center bottom","begin center","center top","end center"];this._atPositions=["center top","end center","center bottom","begin center"]}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin center","begin top","end center"];this._atPositions=["begin top","end center","begin bottom","begin center"]}};S.prototype._afterAdjustPositionAndArrowHook=function(){};S.prototype._beforeAdjustPositionAndArrowHook=function(){};S.prototype._isPopupElement=function(e){var t=this._getOpenByDomRef();return!!jQuery(e).closest(_.getDomRef()).length||!!jQuery(e).closest(t).length};S.prototype._getAnyHeader=function(){if(this.getCustomHeader()){return this.getCustomHeader()}else if(this.getShowHeader()){this._createInternalHeader();return this._internalHeader}};S.prototype._createInternalHeader=function(){if(!this._internalHeader){var t=this;this._internalHeader=new e(this.getId()+"-intHeader",{titleAlignment:this.getTitleAlignment()});this.setAggregation("_internalHeader",this._internalHeader);this._internalHeader.addEventDelegate({onAfterRendering:function(){t._restoreFocus()}});return true}else{return false}};S.prototype._onAnimationEnd=function(e,t,i){var o=null;var r=function(){t.off("webkitTransitionEnd transitionend");clearTimeout(o);setTimeout(function(){e()})};t.on("webkitTransitionEnd transitionend",r);o=setTimeout(r,i)};S.prototype._getAnimationDuration=function(){return this._fOpacityTransitionDuration};S.prototype._openAnimation=function(e,t,i){const o=this._getAnimationDuration();var r=this;setTimeout(function(){e.css("opacity",1);r._includeScrollWidth();setTimeout(()=>{if(!r.oPopup||r.oPopup.getOpenState()!==B.OPENING){return}i()},o)},p.browser.firefox?50:0)};S.prototype._closeAnimation=function(e,t,i){const o=this._getAnimationDuration();e.css("opacity",0);e.addClass("sapMPopoverOpacityTransition");this._onAnimationEnd(()=>{i();e.removeClass("sapMPopoverOpacityTransition")},e,o)};S.prototype._getInitialFocusId=function(){return this.getInitialFocus()||this._getFirstVisibleButtonId()||this._getFirstFocusableContentElementId()||this.getId()};S.prototype._getFirstVisibleButtonId=function(){var e=this.getBeginButton(),t=this.getEndButton(),i="";if(e&&e.getVisible()&&e.getEnabled()){i=e.getId()}else if(t&&t.getVisible()&&t.getEnabled()){i=t.getId()}return i};S.prototype._getFirstFocusableContentElementId=function(){var e="";var t=this.$("cont");var i=t.firstFocusableDomRef();if(i){e=i.id}return e};S.prototype._restoreFocus=function(){if(this.isOpen()){var e=this._getInitialFocusId(),t=g.getElementById(e),i=e?window.document.getElementById(e):null;if(t&&t.getFocusDomRef()){t.getFocusDomRef().focus()}else if(!t&&i){i.focus()}}};S.prototype._registerContentResizeHandler=function(e){if(!this._sResizeListenerId){this._sResizeListenerId=u.register(e||this.getDomRef("scroll"),this._fnOrientationChange)}};S.prototype._deregisterContentResizeHandler=function(){if(this._sResizeListenerId){u.deregister(this._sResizeListenerId);this._sResizeListenerId=null}};S.prototype._storeScrollPosition=function(){var e=this.$("cont");if(e.length>0){this._oScrollPosDesktop={x:e.scrollLeft(),y:e.scrollTop()}}};S.prototype._restoreScrollPosition=function(){if(!this._oScrollPosDesktop){return}var e=this.$("cont");if(e.length>0){e.scrollLeft(this._oScrollPosDesktop.x).scrollTop(this._oScrollPosDesktop.y);this._oScrollPosDesktop=null}};S.prototype._repositionOffset=function(){var e=this.oPopup.getOpenState(),t,i;if(!(e===B.OPEN)){return this}t=this.oPopup._oLastPosition;i=this._placements.indexOf(this.getPlacement());if(i===-1){return this}if(i<4){t.offset=this._calcOffset(this._offsets[i]);this.oPopup._applyPosition(t)}else{this._calcPlacement()}return this};S.prototype._getOpenByDomRef=function(){if(!this._oOpenBy){return null}if(this._oOpenBy instanceof g){return this._oOpenBy.getPopupAnchorDomRef&&this._oOpenBy.getPopupAnchorDomRef()||this._oOpenBy.getFocusDomRef()}else{return this._oOpenBy}};S.prototype._getAccessibilityOptions=function(){var e,t={},i=this._getAnyHeader(),o=this.getCustomHeader();t.role="dialog";t.modal=this.getProperty("ariaModal");if(!this.getShowHeader()||!i||!i.getVisible()){return t}var r=o?o.getId():this.getHeaderTitle().getId();e=Array.prototype.concat(r,this.getAssociation("ariaLabelledBy",[]));t.labelledby=e.join(" ");return t};S.prototype._setHeaderTitle=function(){if(!this._headerTitle){this._headerTitle=new r(this.getId()+"-title",{text:this.getTitle(),level:"H1"});this._createInternalHeader();this._internalHeader.addContentMiddle(this._headerTitle);return}if(this._headerTitle.getText()!==this.getTitle()){this._headerTitle.setText(this.getTitle())}};S.prototype.getHeaderTitle=function(){return this._headerTitle};S.prototype._loadThemeParameters=function(){this._fArrowOffsetParameter=v.toPx(f.get({name:"_sap_m_Popover_ArrowOffset",callback:e=>{this._fArrowOffsetParameter=v.toPx(e)}})||"0.5rem");this._fArrowOffsetCompactParameter=v.toPx(f.get({name:"_sap_m_Popover_CompactArrowOffset",callback:e=>{this._fArrowOffsetCompactParameter=v.toPx(e)}})||"0.5rem");this._fThickShadowSize=v.toPx(f.get({name:"_sap_m_Popover_ThickShadowSize",callback:e=>{this._fThickShadowSize=v.toPx(e)}})||"0.0625rem");this._fOpacityTransitionDuration=parseFloat(f.get({name:"_sap_m_Popover_OpacityTransitionDuration",callback:e=>{this._fOpacityTransitionDuration=parseFloat(e)*1e3}})||"0.2s")*1e3};S.prototype.setPlacement=function(e){this.setProperty("placement",e,true);this._bVerticalFlip=false;this._bHorizontalFlip=false;var t=this._placements.indexOf(e);if(t<=3){this._oCalcedPos=e}return this};S.prototype.setBeginButton=function(e){var t=this.getBeginButton();if(t===e){return this}this._createInternalHeader();this._beginButton=e;if(e){if(t){this._internalHeader.removeAggregation("contentLeft",t,true)}this._internalHeader.addAggregation("contentLeft",e)}else{this._internalHeader.removeContentLeft(t)}return this};S.prototype.setEndButton=function(e){var t=this.getEndButton();if(t===e){return this}this._createInternalHeader();this._endButton=e;this._internalHeader.removeContentRight(t);if(e){this._internalHeader.addContentRight(e)}return this};S.prototype.setLeftButton=function(e){if(!(e instanceof t)){e=g.getElementById(e)}this.setBeginButton(e);return this.setAssociation("leftButton",e)};S.prototype.setRightButton=function(e){if(!(e instanceof t)){e=g.getElementById(e)}this.setEndButton(e);return this.setAssociation("rightButton",e)};S.prototype.setModal=function(e,t){if(e===this.getModal()){return this}this.oPopup.setModal(e,("sapMPopoverBLayer "+(t||"")).trim());this.setProperty("modal",e,true);return this};S.prototype.setEnableScrolling=function(e){this.setHorizontalScrolling(e);this.setVerticalScrolling(e);this.setProperty("enableScrolling",e);return this};S.prototype._setAriaModal=function(e){return this.setProperty("ariaModal",e)};S.prototype.getScrollDelegate=function(){return this._oScroller};S.prototype._setAriaRoleApplication=function(e){return this.setProperty("ariaRoleApplication",e)};S.prototype.setAggregation=function(e,t,i){if(e==="beginButton"||e==="endButton"){var o="set"+e.charAt(0).toUpperCase()+e.slice(1);return this[o](t)}else{return a.prototype.setAggregation.apply(this,arguments)}};S.prototype.getAggregation=function(e,t){if(e==="beginButton"||e==="endButton"){var i=this["_"+e];return i||t||null}else{return a.prototype.getAggregation.apply(this,arguments)}};S.prototype.destroyAggregation=function(e,t){if(e==="beginButton"||e==="endButton"){var i=this["_"+e];if(i){i.destroy();this["_"+e]=null}}else{a.prototype.destroyAggregation.apply(this,arguments)}return this};S.prototype.invalidate=function(e){if(this.oPopup&&this.isOpen()&&this.oPopup.getOpenState()!==B.CLOSING){a.prototype.invalidate.apply(this,arguments)}return this};S.prototype.addAggregation=function(e,t,i){if(e==="content"){this._bContentChanged=true}a.prototype.addAggregation.apply(this,arguments)};S.prototype._getAllContent=function(){return this.getContent()};S.prototype._applyContextualSettings=function(){a.prototype._applyContextualSettings.call(this)};S.prototype._addDocumentEventListeners=function(){if(!this._bDocumentListenersAdded){this._bDocumentListenersAdded=true;this._fnHandleDocumentKeydown=e=>{if(this.oPopup.isTopmost()&&e.which===w.ESCAPE){this.close()}};document.addEventListener("keydown",this._fnHandleDocumentKeydown)}};S.prototype._removeDocumentEventListeners=function(){if(this._bDocumentListenersAdded){this._bDocumentListenersAdded=false;document.removeEventListener("keydown",this._fnHandleDocumentKeydown)}};S.prototype._preventDocumentElementScrolling=function(){const e=document.documentElement.scrollHeight>document.documentElement.clientHeight;if(!e){this._sDocumentElementOverflow=document.documentElement.style.overflow;document.documentElement.style.overflow="hidden"}};S.prototype._restoreDocumentElementScrolling=function(){if(this._sDocumentElementOverflow!==undefined){document.documentElement.style.overflow=this._sDocumentElementOverflow;delete this._sDocumentElementOverflow}};return S});
//# sourceMappingURL=Popover.js.map