/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/Device","sap/ui/core/Icon","sap/ui/core/Lib","sap/ui/core/ResizeHandler","sap/ui/core/ValueStateSupport","sap/ui/core/library","./ProgressIndicatorRenderer","sap/base/Log","sap/m/Popover","sap/m/Text"],function(e,t,r,a,i,o,s,n,l,p,u,c){"use strict";var h=n.TextDirection;var g=n.ValueState;var f=e.PlacementType;var d=t.extend("sap.m.ProgressIndicator",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:g.None},displayValue:{type:"string",group:"Appearance",defaultValue:null},percentValue:{type:"float",group:"Data",defaultValue:0},showValue:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:h.Inherit},displayOnly:{type:"boolean",group:"Behavior",defaultValue:false},displayAnimation:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/m/designtime/ProgressIndicator.designtime"},renderer:l});d.RESIZE_HANDLER_ID={SELF:"_sResizeHandlerId"};d.prototype.init=function(){this._bIEBrowser=r.browser.internet_explorer;this._fPercentValueDiff=0};d.prototype.onBeforeRendering=function(){this._deRegisterResizeHandler(d.RESIZE_HANDLER_ID.SELF)};d.prototype.onAfterRendering=function(){this._updateHoverableScenario();this._registerResizeHandler(d.RESIZE_HANDLER_ID.SELF,this,this._onResize.bind(this))};d.prototype.exit=function(){if(this._oPopoverText){this._oPopoverText.destroy();this._oPopoverText=null}this._deRegisterResizeHandler(d.RESIZE_HANDLER_ID.SELF)};d.prototype._registerResizeHandler=function(e,t,r){if(!this[e]){this[e]=o.register(t,r)}};d.prototype._deRegisterResizeHandler=function(e){if(this[e]){o.deregister(this[e]);this[e]=null}};d.prototype._onResize=function(e){this._updateHoverableScenario()};d.prototype.ontouchstart=function(e){if(this._isHoverable()){e.setMarked()}};d.prototype.ontap=function(e){var t;if(this._isHoverable()){t=this._getPopover();if(t.isOpen()){t.close()}else{t.openBy(this)}}};d.prototype.setShowValue=function(e){this.toggleStyleClass("sapMPINoValue",!e);return this.setProperty("showValue",e)};d.prototype._updateHoverableScenario=function(){var e=this.$(this.getPercentValue()>50?"textLeft":"textRight")[0],t=e&&e.offsetWidth,r=e&&e.scrollWidth;if(this._bIEBrowser){t+=1}this.toggleStyleClass("sapMPIHoverable",this.getDisplayValue()!==""&&t<r)};d.prototype._isHoverable=function(){return this.hasStyleClass("sapMPIHoverable")};d.prototype._getPopover=function(){var e;if(!this.getAggregation("_popover")){this._oPopoverText=new c({text:this.getDisplayValue()});e=new u(this.getId()+"-popover",{showHeader:false,placement:f.Bottom,content:[this._oPopoverText,new a({src:"sap-icon://decline",press:this._onPopoverCloseIconPress.bind(this)})]}).addStyleClass("sapMPIPopover");this.setAggregation("_popover",e,true)}return this.getAggregation("_popover")};d.prototype._onPopoverCloseIconPress=function(){this._getPopover().close()};d.prototype.setDisplayValue=function(e){this.setProperty("displayValue",e);if(this._oPopoverText){this._oPopoverText.setText(e)}return this};d.prototype.setPercentValue=function(e){var t=this,r=this.getDomRef(),a=e;e=parseFloat(e);if(!y(e)){if(e>100){e=100}else if(e<0){e=0}else{p.warning(this+": percentValue ("+a+") is not a valid number! The provided value will not be set!");return this}p.warning(this+": percentValue ("+a+") is not correct! Setting the percentValue to "+e)}if(this.getPercentValue()!==e){this._fPercentValueDiff=this.getPercentValue()-e;this.setProperty("percentValue",e);["sapMPIValueMax","sapMPIValueMin","sapMPIValueNormal","sapMPIValueGreaterHalf"].forEach(function(e){t.removeStyleClass(e)});this.addStyleClass(this._getCSSClassByPercentValue(e).join(" "));if(!r){return this}r.setAttribute("aria-valuenow",e);r.setAttribute("aria-valuetext",this._getAriaValueText({fPercent:e}));this._setText()}return this};d.prototype._setText=function(){this.toggleStyleClass("sapMPIValueGreaterHalf",this.getPercentValue()>50);return this};d.prototype._getCSSClassByPercentValue=function(e){if(e===100){return["sapMPIValueMax","sapMPIValueGreaterHalf"]}if(e===0){return["sapMPIValueMin"]}if(e<=50){return["sapMPIValueNormal"]}return["sapMPIValueNormal","sapMPIValueGreaterHalf"]};d.prototype._getAriaValueText=function(e){e.sText=e.sText||this.getDisplayValue();e.fPercent=e.fPercent||this.getPercentValue();e.sStateText=e.sStateText||this._getStateText();var t=e.sText||e.fPercent+"%";if(e.sStateText){t+=" "+e.sStateText}return t};d.prototype._getStateText=function(){return this.getEnabled()?s.getAdditionalText(this.getState()):""};d.prototype.getAccessibilityInfo=function(){var e=i.getResourceBundleFor("sap.m"),t=this.getDisplayValue(),r=t?t:e.getText("ACC_CTR_STATE_PROGRESS",[this.getPercentValue()]);return{role:"progressbar",type:e.getText("ACC_CTR_TYPE_PROGRESS"),description:r,focusable:this.getEnabled(),enabled:this.getEnabled()}};function y(e){return!isNaN(e)&&e>=0&&e<=100}return d});
//# sourceMappingURL=ProgressIndicator.js.map