/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/Device","./PullToRefreshRenderer","sap/ui/events/KeyCodes","sap/base/security/encodeXML","sap/ui/core/InvisibleText","sap/m/BusyIndicator","sap/m/ImageHelper"],function(t,jQuery,e,o,i,s,r,l,a,n,h){"use strict";var p=o.extend("sap.m.PullToRefresh",{metadata:{library:"sap.m",properties:{description:{type:"string",group:"Misc",defaultValue:null},showIcon:{type:"boolean",group:"Appearance",defaultValue:false},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true}},events:{refresh:{}}},renderer:s});p.ARIA_F5_REFRESH="PULL_TO_REFRESH_ARIA_F5";p.prototype.init=function(){this._bTouchMode=i.support.touch&&!i.system.combi;this._iState=0;this._sAriaF5Text=a.getStaticId("sap.m",p.ARIA_F5_REFRESH)};p.prototype._loadBI=function(){if(this.getVisible()&&!this._oBusyIndicator){this._oBusyIndicator=new n({size:"1.7rem"});this._oBusyIndicator.setParent(this)}};p.prototype._getAriaDescribedByReferences=function(){var t=this.getTooltip_AsString(),e=this._sAriaF5Text,o;if(t){o=a.getStaticId("sap.m",t);e+=" "+o}return e};p.prototype.onBeforeRendering=function(){this._loadBI();if(this._bTouchMode){jQuery(window).off("resize.sapMP2R",this.calculateTopTrigger);var t=this.getParent();this._oScroller=t&&t.getScrollDelegate?t.getScrollDelegate():null;if(this._oScroller){this._oScroller.setPullDown(this.getVisible()?this:null)}}};p.prototype.calculateTopTrigger=function(){this._iTopTrigger=1;if(this._oDomRef&&this._oDomRef.parentNode&&this._oDomRef.parentNode.parentNode&&this._oDomRef.parentNode.parentNode.offsetHeight<this._oDomRef.offsetHeight*1.5){this._iTopTrigger=this.getDomRef("T").offsetTop}};p.prototype.onAfterRendering=function(){this._oDomRef=this.getDomRef();if(this._bTouchMode){if(this._oScroller){this._oScroller.refresh()}if(this.getVisible()&&this._oScroller&&this._oScroller._bIScroll){jQuery(window).on("resize.sapMP2R",jQuery.proxy(this.calculateTopTrigger,this));this.calculateTopTrigger()}}};p.prototype.exit=function(){if(this._bTouchMode&&this._oScroller&&this._oScroller._bIScroll){jQuery(window).off("resize.sapMP2R",this.calculateTopTrigger)}if(this._oScroller){this._oScroller.setPullDown(null);this._oScroller=null}if(this._oCustomImage){this._oCustomImage.destroy();this._oCustomImage=null}if(this._oBusyIndicator){this._oBusyIndicator.destroy();this._oBusyIndicator=null}};p.prototype.doScrollMove=function(){if(!this._oScroller){return}var t=this._oDomRef;var e=this._oScroller._scroller;if(e.y>-this._iTopTrigger&&this._iState<1){this.setState(1);e.minScrollY=0}else if(e.y<-this._iTopTrigger&&this._iState===1){this.setState(0);e.minScrollY=-t.offsetHeight}};p.prototype.doPull=function(t){if(this._bTouchMode&&this._iState<2){this.setState(t>=-1?1:0)}};p.prototype.doRefresh=function(){this.setState(0)};p.prototype.doScrollEnd=function(){if(this._iState===1){this.setState(2);this.fireRefresh()}};p.prototype.setState=function(t){if(this._iState===t){return}this._iState=t;if(!this._oDomRef){return}var e=this.$();var o=e.find(".sapMPullDownText");var i=this._getRB();switch(t){case 0:e.toggleClass("sapMFlip",false).toggleClass("sapMLoading",false);o.html(i.getText(this._bTouchMode?"PULL2REFRESH_PULLDOWN":"PULL2REFRESH_REFRESH"));e.removeAttr("aria-live");e.find(".sapMPullDownInfo").html(l(this.getDescription()));break;case 1:e.toggleClass("sapMFlip",true);o.html(i.getText("PULL2REFRESH_RELEASE"));e.removeAttr("aria-live");break;case 2:e.toggleClass("sapMFlip",false).toggleClass("sapMLoading",true);this._oBusyIndicator.setVisible(true);o.html(i.getText("PULL2REFRESH_LOADING"));e.attr("aria-live","assertive");e.find(".sapMPullDownInfo").html(this._bTouchMode?i.getText("PULL2REFRESH_LOADING_LONG"):"");break}};p.prototype.getCustomIconImage=function(){var t={src:this.getCustomIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};var e=["sapMPullDownCIImg"];this._oCustomImage=h.getImageControl(null,this._oCustomImage,this,t,e);return this._oCustomImage};p.prototype.onclick=function(){if(!this._bTouchMode){this.setState(2);this.fireRefresh()}};p.prototype.onkeyup=function(t){if(t.which===r.SPACE&&this._iState===1){this.setState(2);this.fireRefresh()}};p.prototype.onkeydown=function(t){if(t.which===r.F5){this.onclick();t.stopPropagation();t.preventDefault()}else if(t.which===r.SHIFT){if(this._iState===1){this.setState(0);return}}};p.prototype.onsapenter=function(t){if(this._iState<1){this.setState(2);this.fireRefresh()}};p.prototype.onsapspace=function(t){t.preventDefault();if(this._iState<1){this.setState(1)}};p.prototype.hide=function(){this.setState(0);if(this._oScroller){this._oScroller.refresh()}};p.prototype.setVisible=function(t){if(this.getVisible()===t){return this}if(this._oDomRef&&this._oScroller&&this._oScroller._oControl){this._oScroller._oControl.invalidate()}return this.setProperty("visible",t)};p.prototype._getRB=function(){return t.getResourceBundleFor("sap.m")};return p});
//# sourceMappingURL=PullToRefresh.js.map