/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/base/i18n/Localization","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/StaticArea","sap/ui/core/theming/Parameters","./RatingIndicatorRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/LabelEnablement"],function(e,t,a,i,s,n,o,u,r,jQuery,l){"use strict";var p=e.RatingIndicatorVisualMode;var h=a.extend("sap.m.RatingIndicator",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},maxValue:{type:"int",group:"Behavior",defaultValue:5},value:{type:"float",group:"Behavior",defaultValue:0,bindable:"bindable"},iconSize:{type:"sap.ui.core.CSSSize",group:"Behavior",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},iconUnselected:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},iconHovered:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},visualMode:{type:"sap.m.RatingIndicatorVisualMode",group:"Behavior",defaultValue:p.Half},displayOnly:{type:"boolean",group:"Behavior",defaultValue:false},editable:{type:"boolean",group:"Behavior",defaultValue:true},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"int"}}},liveChange:{parameters:{value:{type:"float"}}}},designtime:"sap/m/designtime/RatingIndicator.designtime"},renderer:o});h.sizeMapppings={};h.iconPaddingMappings={};h.paddingValueMappping={};h.prototype.init=function(){this.allowTextSelection(false);this._iIconCounter=0;this._fHoverValue=0;this._oResourceBundle=i.getResourceBundleFor("sap.m")};h.prototype.setValue=function(e){var t=typeof e!=="string"?e:Number(e);t=this.validateProperty("value",t);if(t<0){return this}if(isNaN(t)){r.warning('Ignored new rating value "'+e+'" because it is NAN')}else if(this.$().length&&t>this.getMaxValue()){r.warning('Ignored new rating value "'+t+'" because it is out  of range (0-'+this.getMaxValue()+")")}else{t=this._roundValueToVisualMode(t);this.setProperty("value",t);this._fHoverValue=t}return this};h.prototype.onThemeChanged=function(e){this.invalidate()};h.prototype.onBeforeRendering=function(){var e=this.getValue();var t=this.getMaxValue();if(e>t){this.setValue(t);r.warning("Set value to maxValue because value is > maxValue ("+e+" > "+t+").")}else if(e<0){this.setValue(0);r.warning("Set value to 0 because value is < 0 ("+e+" < 0).")}var a=this.getIconSize();if(a){this._setRegularSizes(a)}else if(this.getDisplayOnly()){this._setDisplayOnlySizes()}else{this._setContentDensitySizes()}};h.prototype._isRequired=function(){return this.getRequired()||l.isRequired(this)};h.prototype._setDisplayOnlySizes=function(){var e="sapUiRIIconSizeDisplayOnly",t="sapUiRIIconPaddingDisplayOnly";if(h.sizeMapppings[e]&&h.paddingValueMappping[t]){this._iPxIconSize=h.sizeMapppings[e];this._iPxPaddingSize=h.paddingValueMappping[t];return}var a=Object.assign({sapUiRIIconSizeDisplayOnly:"1.5rem",sapUiRIIconPaddingDisplayOnly:"0.1875rem"},n.get({name:[e,t],callback:function(a){this.setIconAndPaddingSizes(e,t,a[e],a[t])}.bind(this)}));this.setIconAndPaddingSizes(e,t,a[e],a[t])};h.prototype._setContentDensitySizes=function(){var e=this._getDensityMode();var t="sapUiRIIconSize"+e;var a="sapUiRIIconPadding"+e;if(h.sizeMapppings[t]&&h.paddingValueMappping[a]){this._iPxIconSize=h.sizeMapppings[t];this._iPxPaddingSize=h.paddingValueMappping[a];return}var i=n.get({name:[t,a],callback:function(e){this.setIconAndPaddingSizes(t,a,e[t],e[a])}.bind(this)});if(i){this.setIconAndPaddingSizes(t,a,i[t],i[a])}};h.prototype._setRegularSizes=function(e){h.sizeMapppings[e]=h.sizeMapppings[e]||this._toPx(e);var t=h.sizeMapppings[e];h.iconPaddingMappings[t]=h.iconPaddingMappings[t]||"sapUiRIIconPadding"+this._getIconSizeLabel(t);var a=h.iconPaddingMappings[t];if(h.paddingValueMappping[a]){this._iPxIconSize=h.sizeMapppings[e];this._iPxPaddingSize=h.paddingValueMappping[a];return}var i=n.get({name:a,callback:function(t){this.setIconAndPaddingSizes(e,a,h.sizeMapppings[e],t)}.bind(this)});if(i){this.setIconAndPaddingSizes(e,a,h.sizeMapppings[e],i)}};h.prototype.setIconAndPaddingSizes=function(e,t,a,i){h.sizeMapppings[e]=this._toPx(a);h.paddingValueMappping[t]=this._toPx(i);this._iPxIconSize=h.sizeMapppings[e];this._iPxPaddingSize=h.paddingValueMappping[t]};h.prototype.onAfterRendering=function(){this._updateAriaValues()};h.prototype.exit=function(){this._iIconCounter=null;this._fStartValue=null;this._iPxIconSize=null;this._iPxPaddingSize=null;this._fHoverValue=null;this._oResourceBundle=null};h.prototype._getDensityMode=function(){var e=[{name:"Cozy",style:"sapUiSizeCozy"},{name:"Compact",style:"sapUiSizeCompact"},{name:"Condensed",style:"sapUiSizeCondensed"}],t,a,i;for(i in e){t=e[i].style;if(jQuery("html").hasClass(t)||jQuery("."+t).length>0){a=e[i].name}}return a||e[0].name};h.prototype._getIconSizeLabel=function(e){switch(true){case e>=32:return"L";case e>=24:return"M";case e>=22:return"S";case e>=12:return"XS";default:return"M"}};h.prototype._toPx=function(e){var t=Math.round(e),a;if(isNaN(t)){if(RegExp("^(auto|0)$|^[+-.]?[0-9].?([0-9]+)?(px|em|rem|ex|%|in|cm|mm|pt|pc)$").test(e)){a=jQuery("<div>&nbsp;</div>").css({display:"none",width:e,margin:0,padding:0,height:"auto","line-height":1,border:0,overflow:"hidden"}).appendTo(s.getDomRef());t=a.width();a.remove()}else{return false}}return Math.round(t)};h.prototype._updateUI=function(e,t){var a=this.$("sel"),i=this.$("unsel-wrapper"),s=this.$("hov"),n=this._iPxIconSize,o=this._iPxPaddingSize,u="px",l=this.getMaxValue(),p=e*n+(Math.round(e)-1)*o,h=l*(n+o)-o;this._fHoverValue=e;if(p<0){p=0}this._updateAriaValues(e);i.width(h-p+u);if(t){s.width(p+u);a.hide();s.show()}else{a.width(p+u);s.hide();a.show()}r.debug("Updated rating UI with value "+e+" and hover mode "+t)};h.prototype._updateAriaValues=function(e){var t=this.$();var a;if(e===undefined){a=this.getValue()}else{a=e}var i=this.getMaxValue();t.attr("aria-valuenow",a);t.attr("aria-valuemax",i);var s=this._oResourceBundle.getText("RATING_VALUEARIATEXT",[a,i]);t.attr("aria-valuetext",s)};h.prototype._calculateSelectedValue=function(e){var a=0,i=0,s=this.$(),n=(s.innerWidth()-s.width())/2,o,u=t.getRTL();if(e.targetTouches){o=e.targetTouches[0]}else{o=e}if(!o||!o.pageX){o=e;if((!o||!o.pageX)&&e.changedTouches){o=e.changedTouches[0]}}if(!o.pageX){return parseFloat(a)}if(o.pageX<s.offset().left){a=0}else if(o.pageX-s.offset().left>s.innerWidth()-n){a=this.getMaxValue()}else{i=(o.pageX-s.offset().left-n)/s.width();a=i*this.getMaxValue()}if(u){a=this.getMaxValue()-a}return this._roundValueToVisualMode(a,true)};h.prototype._roundValueToVisualMode=function(e,t){if(t){if(e<.25){e=0}else if(e<this.getMaxValue()-.4){e+=.4}e=Math.round(e)}else{if(this.getVisualMode()===p.Full){e=Math.round(e)}else if(this.getVisualMode()===p.Half){e=Math.round(e*2)/2}}return parseFloat(e)};h.prototype._getIncreasedValue=function(){var e=this.getMaxValue(),t=this.getValue()+this._getValueChangeStep();if(t>e){t=e}return t};h.prototype._getDecreasedValue=function(){var e=this.getValue()-this._getValueChangeStep();if(e<0){e=0}return e};h.prototype._getValueChangeStep=function(){var e=this.getVisualMode(),t;switch(e){case p.Full:t=1;break;case p.Half:if(this.getValue()%1===.5){t=.5}else{t=1}break;default:r.warning("VisualMode not supported",e)}return t};h.prototype.ontouchstart=function(e){if(e.which==2||e.which==3||!this.getEnabled()||this.getDisplayOnly()||!this.getEditable()){return}e.setMarked();if(!this._touchEndProxy){this._touchEndProxy=jQuery.proxy(this._ontouchend,this)}if(!this._touchMoveProxy){this._touchMoveProxy=jQuery.proxy(this._ontouchmove,this)}jQuery(document).on("touchend.sapMRI touchcancel.sapMRI mouseup.sapMRI",this._touchEndProxy);jQuery(document).on("touchmove.sapMRI mousemove.sapMRI",this._touchMoveProxy);this._fStartValue=this.getValue();var t=this._calculateSelectedValue(e);if(t>=0&&t<=this.getMaxValue()){this._updateUI(t,true);if(this._fStartValue!==t){this.fireLiveChange({value:t})}}};h.prototype._ontouchmove=function(e){if(e.isMarked("delayedMouseEvent")){return}e.preventDefault();if(this.getEnabled()){var t=this._calculateSelectedValue(e);if(t>=0&&t<=this.getMaxValue()){this._updateUI(t,true);if(this._fStartValue!==t){this.fireLiveChange({value:t});this._fStartValue=t}}}};h.prototype._ontouchend=function(e){if(e.isMarked("delayedMouseEvent")){return}if(this.getEnabled()){var t=this._calculateSelectedValue(e);if(this.getValue()===1&&t===1){t=0}this.setProperty("value",t,true);this._updateUI(t,false);if(this._fStartValue!==t){this.fireLiveChange({value:t});this.fireChange({value:t})}jQuery(document).off("touchend.sapMRI touchcancel.sapMRI mouseup.sapMRI",this._touchEndProxy);jQuery(document).off("touchmove.sapMRI mousemove.sapMRI",this._touchMoveProxy);delete this._fStartValue}};h.prototype.ontouchcancel=h.prototype.ontouchend;h.prototype.onsapincrease=function(e){var t=this._getIncreasedValue();this._handleKeyboardValueChange(e,t)};h.prototype.onsapdecrease=function(e){var t=this._getDecreasedValue();this._handleKeyboardValueChange(e,t)};h.prototype.onsaphome=function(e){var t=0;this._handleKeyboardValueChange(e,t)};h.prototype.onsapend=function(e){var t=this.getMaxValue();this._handleKeyboardValueChange(e,t)};h.prototype.onsapselect=function(e){var t;if(this.getValue()===this.getMaxValue()){t=0}else{t=this._getIncreasedValue()}this._handleKeyboardValueChange(e,t)};h.prototype.onkeyup=function(e){var t=this.getMaxValue();if(!this.getEnabled()||this.getDisplayOnly()||!this.getEditable()){return false}switch(e.which){case u.DIGIT_0:case u.NUMPAD_0:this.setValue(0);break;case u.DIGIT_1:case u.NUMPAD_1:this.setValue(1);break;case u.DIGIT_2:case u.NUMPAD_2:this.setValue(Math.min(2,t));break;case u.DIGIT_3:case u.NUMPAD_3:this.setValue(Math.min(3,t));break;case u.DIGIT_4:case u.NUMPAD_4:this.setValue(Math.min(4,t));break;case u.DIGIT_5:case u.NUMPAD_5:this.setValue(Math.min(5,t));break;case u.DIGIT_6:case u.NUMPAD_6:this.setValue(Math.min(6,t));break;case u.DIGIT_7:case u.NUMPAD_7:this.setValue(Math.min(7,t));break;case u.DIGIT_8:case u.NUMPAD_8:this.setValue(Math.min(8,t));break;case u.DIGIT_9:case u.NUMPAD_9:this.setValue(Math.min(9,t));break}};h.prototype._handleKeyboardValueChange=function(e,t){if(!this.getEnabled()||this.getDisplayOnly()||!this.getEditable()){return}if(t!==this.getValue()){this.setValue(t);this.fireLiveChange({value:t});this.fireChange({value:t})}if(e){e.preventDefault();e.stopPropagation()}};h.prototype.getAccessibilityInfo=function(){var e=i.getResourceBundleFor("sap.m");return{role:"slider",type:e.getText("ACC_CTR_TYPE_RATING"),description:e.getText("ACC_CTR_STATE_RATING",[this.getValue(),this.getMaxValue()]),focusable:this.getEnabled()&&!this.getDisplayOnly(),enabled:this.getEnabled(),editable:this.getEditable()}};return h});
//# sourceMappingURL=RatingIndicator.js.map