/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/m/Button","sap/ui/base/Interface","sap/ui/Device","sap/ui/core/ControlBehavior","sap/ui/core/Lib","sap/ui/core/library","./SelectionDetailsRenderer","sap/base/util/uid","sap/ui/core/Configuration"],function(t,e,o,i,a,n,r,s,p,g,h){"use strict";var l=e.extend("sap.m.SelectionDetails",{metadata:{library:"sap.m",defaultAggregation:"items",aggregations:{items:{type:"sap.m.SelectionDetailsItem",multiple:true,bindable:"bindable"},actions:{type:"sap.ui.core.Item",multiple:true},actionGroups:{type:"sap.ui.core.Item",multiple:true},_popover:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"},_button:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{beforeOpen:{},beforeClose:{},navigate:{parameters:{item:{type:"sap.m.SelectionDetailsItem"},direction:{type:"string"},content:{type:"sap.ui.core.Control"}}},actionPress:{parameters:{action:{type:"sap.ui.core.Item"},items:{type:"sap.m.SelectionDetailsItem"},level:{type:"sap.m.SelectionDetailsActionLevel"}}}}},renderer:p});l._MAX_ACTIONGROUPS=5;l._POPOVER_MAX_HEIGHT=500;l.prototype.init=function(){this._bWrapLabels=false;this._oRb=r.getResourceBundleFor("sap.m");this.setAggregation("_button",new o({id:this.getId()+"-button",type:t.ButtonType.Transparent,press:[this._onToolbarButtonPress,this]}),true);this._oItemFactory=null};l.prototype.onBeforeRendering=function(){this._updateButton()};l.prototype.onAfterRendering=function(){document.getElementById(this.getAggregation("_button").getId()).setAttribute("aria-haspopup","dialog")};l.prototype.exit=function(){this.detachSelectionHandler();this._oItemFactory=null;this._oChangeHandler=null};l.prototype.isOpen=function(){var t=this.getAggregation("_popover");return t?t.isOpen():false};l.prototype.isEnabled=function(){return this.getItems().length>0};l.prototype.close=function(){var t=this.getAggregation("_popover");if(t){t.close()}return this};l.prototype.navTo=function(t,e){if(this.isOpen()){sap.ui.require(["sap/m/Page","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Title"],this._handleNavLazy.bind(this,t,e))}return this};l.prototype.getWrapLabels=function(){return this._bWrapLabels};l.prototype.setWrapLabels=function(t){var e=this.getAggregation("_popover");this._bWrapLabels=t;if(e&&e.isOpen()){e.invalidate()}return this};l.prototype.setPopoverModal=function(t){this._getPopover().setModal(t);return this};l.prototype._handleNavLazy=function(t,e,o,i,a,n){var r=this.getId()+"-page-for-"+e.getId()+"-uid-"+g();this._setPopoverHeight(l._POPOVER_MAX_HEIGHT);var s=new o(r,{customHeader:this._getPageToolbar(i,a,n,true,t),content:[e]});this._oNavContainer.addPage(s);this._oNavContainer.to(r)};l.prototype._getPageToolbar=function(e,i,n,r,p){var g=new e({design:t.ToolbarDesign.Transparent}).addStyleClass("sapMSDPageHeader");if(r){var h=new o({icon:"sap-icon://nav-back",press:this._onBackButtonPress.bind(this),tooltip:this._oRb.getText("SELECTIONDETAILS_BACK_BUTTON")});g.addAggregation("content",h,true)}var l=new i;var c=new n({text:p,titleStyle:s.TitleLevel.H5});g.addAggregation("content",l,true);g.addAggregation("content",c,true);g.addAggregation("content",l.clone(),true);if(a.system.phone){g.addAggregation("content",this._getCloseButton(),true)}return g};l.prototype._setPopoverHeight=function(t){if(!a.system.phone){var e=this._getPopover(),o=e.$("cont"),i=this._getMaxPopoverHeight();t=Math.min(l._POPOVER_MAX_HEIGHT,t);e._oControl._deregisterContentResizeHandler();var r=n.getAnimationMode()!==h.AnimationMode.none;o.animate({height:Math.min(t,i)},r?100:0,function(){e.setProperty("contentHeight",t+"px",true);e._oControl._registerContentResizeHandler()})}};l.prototype._getMaxPopoverHeight=function(){var t=this._getPopover(),e=t.$(),o,i,n;if(!e.length){return 0}o=e.offset().top;i=a.resize.height;n=t._oControl;n._adaptPositionParams();return i-o-n._marginBottom};l.prototype._onBackButtonPress=function(){var t=this._oNavContainer.getCurrentPage().getContent()[0];this._oNavContainer.attachEventOnce("afterNavigate",function(){this.fireNavigate({item:this._oItemForNavigation,direction:"back",content:t})},this);this._oNavContainer.back();if(this._oNavContainer.getCurrentPage()===this._oInitialPage){this._setPopoverHeight(this._getInitialPageHeight())}};l.prototype._getCloseButton=function(){return new o({icon:"sap-icon://decline",press:this.close.bind(this)})};l.prototype._aFacadeMethods=["addCustomData","getCustomData","indexOfCustomData","insertCustomData","removeCustomData","removeAllCustomData","destroyCustomData","data","addEventDelegate","removeEventDelegate","close","isOpen","isEnabled","attachBeforeOpen","detachBeforeOpen","attachBeforeClose","detachBeforeClose","attachNavigate","detachNavigate","attachActionPress","detachActionPress","addAction","removeAction","removeAllActions","addActionGroup","removeActionGroup","removeAllActionGroups","navTo","getWrapLabels","setWrapLabels"];l.prototype.getFacade=function(){var t=new i(this,l.prototype._aFacadeMethods,true);t.getItems=this._getItemFacades.bind(this);this.getFacade=function(){return t};return t};l.prototype._getItemFacades=function(){var t=this.getItems();var e=[];for(var o=0;o<t.length;o++){e.push(t[o].getFacade())}return e};l.prototype._updateButton=function(){var t,e,o=this.getAggregation("_button"),i;if(this._oSelectionData&&this._oSelectionData.length>=0){e=this._oSelectionData.length}else{e=this.getItems().length}if(e>0){t=this._oRb.getText("SELECTIONDETAILS_BUTTON_TEXT_WITH_NUMBER",[e]);i=true}else{t=this._oRb.getText("SELECTIONDETAILS_BUTTON_TEXT");i=false}o.setText(t);o.setEnabled(i);o.setTooltip(t)};l.prototype._onToolbarButtonPress=function(){sap.ui.require(["sap/m/NavContainer","sap/m/ResponsivePopover","sap/m/Page","sap/m/Toolbar","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/m/List","sap/m/StandardListItem","sap/ui/layout/FixFlex","sap/m/ScrollContainer","sap/m/Title"],this._handlePressLazy.bind(this))};l.prototype._handlePressLazy=function(t,e,o,i,a,n,r,s,p,g,h,l){var c=this._getPopover(t,e,i,n,o,s,g,h,l);if(this._oItemFactory){this._callFactory()}this.fireBeforeOpen();this._addMainListItems();this._addActionGroupListItems(p);this._addListActions(a,n,r);this._oNavContainer.setProperty("defaultTransitionName","show",true);this._oNavContainer.to(this._oInitialPage);this._oNavContainer.setProperty("defaultTransitionName","slide",true);c.openBy(this.getAggregation("_button"));c.invalidate()};l.prototype._callFactory=function(){var t=this._oItemFactory.factory,e=this._oItemFactory.data,o=this._oSelectionData,i;this.fireEvent("beforeUpdate",{items:this.getItems()});this.destroyAggregation("items",true);for(var a=0;a<o.length;a++){i=t(o[a].displayData,o[a].data,o[a].context,e,o[a].shapeString);if(i){i._sMarkerShapeString=o[a].shapeString;this.addAggregation("items",i,true)}}this.fireEvent("afterUpdate",{items:this.getItems()})};l.prototype._getInitialPage=function(t,e,o,i){if(!this._oInitialPage){this._oInitialPage=new t(this.getId()+"-page",{showHeader:false,enableScrolling:false});if(a.system.phone){this._oInitialPage.setProperty("showHeader",true,true);this._oInitialPage.setAggregation("customHeader",this._getPageToolbar(e,o,i),true)}}return this._oInitialPage};l.prototype._getNavContainer=function(t){if(!this._oNavContainer){this._oNavContainer=new t(this.getId()+"-nav-container")}return this._oNavContainer};l.prototype._getPopover=function(e,o,i,a,n,r,s,p,g){var h=this.getAggregation("_popover"),l,c,u,d,_;if(!h){h=new o({id:this.getId()+"-popover",placement:t.PlacementType.Bottom,showHeader:false,contentWidth:"25rem",contentHeight:"500px",beforeClose:this.fireBeforeClose.bind(this)}).addStyleClass("sapMSD");h.setProperty=this._setPopoverProperty;c=this._getInitialPage(n,i,a,g);d=this._getActionGroupList(r);l=this._getNavContainer(e);_=this._getMainList(r);u=this._createMainContainer(s);u.setAggregation("flexContent",_,true);u.addAggregation("fixContent",d,true);c.addAggregation("content",u,true);l.addPage(c);h.addAggregation("content",l,true);h.addEventDelegate({onBeforeRendering:function(){this.getWrapLabels()?h.addStyleClass("sapMSDWrapLabels"):h.removeStyleClass("sapMSDWrapLabels")}.bind(this)});this.setAggregation("_popover",h,true)}return h};l.prototype._setPopoverProperty=function(t,o){var i=this._oControl.getMetadata().getProperty(t);if(i&&t==="modal"&&this._oControl.setModal){this._oControl.setModal(o)}else{this._oControl.setProperty.apply(this._oControl,arguments)}return e.prototype.setProperty.apply(this,arguments)};l.prototype._getInitialPageHeight=function(){var t=this._oInitialPage&&this._oInitialPage.getFooter(),e=this._oMainList.$().outerHeight(),o=this._oActionGroupList.$().outerHeight(),i=t&&t.$().outerHeight()||0;return e+o+i};l.prototype._createMainContainer=function(t){return new t(this.getId()+"-mainContainer",{fixFirst:false,minFlexSize:-1})};l.prototype._getMainList=function(t){if(!this._oMainList){this._oMainList=new t(this.getId()+"-list")}return this._oMainList};l.prototype._addMainListItems=function(){var t,e,o;this._oMainList.removeAllAggregation("items",true);e=this.getItems();for(t=0;t<e.length;t++){if(!e[t].hasListeners("_navigate")){e[t].attachEvent("_navigate",this._onNavigate,this)}if(!e[t].hasListeners("_actionPress")){e[t].attachEvent("_actionPress",this._onActionPress,this)}o=e[t]._getListItem();this._oMainList.addAggregation("items",o,true)}};l.prototype._getActionGroupList=function(t){if(!this._oActionGroupList){this._oActionGroupList=new t(this.getId()+"-actionGroupList",{showNoData:false})}return this._oActionGroupList};l.prototype._addActionGroupListItems=function(e){this._oActionGroupList.destroyAggregation("items",true);var o=this.getActionGroups(),i,a,n=Math.min(l._MAX_ACTIONGROUPS,o.length);for(a=0;a<n;a++){i=new e(this.getId()+"-actionGroup-"+a,{title:o[a].getText(),type:t.ListType.Navigation,press:[{action:o[a],level:t.SelectionDetailsActionLevel.Group},this._onActionPress,this]});if(a===0){i.addStyleClass("sapMSDFirstActionGroup")}this._oActionGroupList.addAggregation("items",i,true)}};l.prototype._addListActions=function(e,o,i){var a,n,r,s,p;this._oInitialPage.destroyAggregation("footer",true);if(!this.getActions().length){return}p=new e(this.getId()+"-action-toolbar").addStyleClass("sapContrast sapContrastPlus");this._oInitialPage.setAggregation("footer",p,true);p.addAggregation("content",new o,true);r=this.getActions();for(n=0;n<r.length;n++){s=r[n];a=new i(this.getId()+"-action-"+n,{text:s.getText(),enabled:s.getEnabled(),press:[{action:s,level:t.SelectionDetailsActionLevel.List},this._onActionPress,this]});p.addAggregation("content",a,true)}};l.prototype._onActionPress=function(t,e){this.fireActionPress({action:e&&e.action||t.getParameter("action"),items:t.getParameter("items")||this.getItems(),level:e&&e.level||t.getParameter("level")})};l.prototype._onNavigate=function(t){this._oItemForNavigation=t.getSource();this.fireNavigate({item:t.getSource(),direction:"to"})};l.prototype._handleSelectionChange=function(t){var e=t.getParameter("data");if(Array.isArray(e)){this._oSelectionData=e;this._updateButton()}};l.prototype.registerSelectionDetailsItemFactory=function(t,e){if(typeof t==="function"){e=t;t=undefined}if(typeof e==="function"){this._oItemFactory={factory:e,data:t}}return this};l.prototype.attachSelectionHandler=function(t,e){if(!this._oChangeHandler&&typeof t==="string"&&e&&typeof e.attachEvent==="function"){this._oChangeHandler={eventId:t,listener:e};e.attachEvent(t,this._handleSelectionChange,this)}return this};l.prototype.detachSelectionHandler=function(){if(this._oChangeHandler){this._oChangeHandler.listener.detachEvent(this._oChangeHandler.eventId,this._handleSelectionChange,this);this._oChangeHandler=null}return this};return l});
//# sourceMappingURL=SelectionDetails.js.map