/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/Theming","sap/m/Image","sap/m/ShellRenderer","sap/ui/util/Mobile","sap/base/Log","sap/ui/core/theming/Parameters"],function(e,t,o,r,a,i,p,n,s,u,l){"use strict";var g=a.TitleLevel;var h=o.extend("sap.m.Shell",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},logo:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},showLogout:{type:"boolean",group:"Behavior",defaultValue:true},headerRightText:{type:"string",group:"Data",defaultValue:null},appWidthLimited:{type:"boolean",group:"Appearance",defaultValue:true},backgroundColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1},homeIcon:{type:"object",group:"Misc",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:g.H1}},defaultAggregation:"app",aggregations:{app:{type:"sap.ui.core.Control",multiple:false}},events:{logout:{}}},renderer:n});h.prototype._getGlobalLogo=function(){return l.get({name:["sapUiGlobalLogo"],_restrictedParseUrls:true})};h.prototype.init=function(){i.attachApplied(this._onThemeChanged.bind(this));s.init({statusBar:"default",hideBrowser:true})};h.prototype._onThemeChanged=function(){var e=this.$("hdr"),t=this._getImageSrc();if(e.length&&t){this._getImage().setSrc(t)}};h.prototype.onBeforeRendering=function(){var e=this._getImageSrc();if(e){this._getImage().setSrc(e)}};h.prototype.onAfterRendering=function(){var e=this.getDomRef().parentNode;if(e&&!e._sapui5_heightFixed){e._sapui5_heightFixed=true;while(e&&e!==document.documentElement){if(e.getAttribute("data-sap-ui-root-content")){break}if(!e.style.height){e.style.height="100%"}e=e.parentNode}}this.$("content").css("height","")};h.prototype.exit=function(){if(this.oImg){this.oImg.destroy()}};h.prototype.ontap=function(e){if(e.target.className&&e.target.className.indexOf&&e.target.className.indexOf("sapMShellHeaderLogout")>-1){this.fireLogout()}};h.prototype.setTitle=function(e){this.$("hdrTxt").text(e);this.setProperty("title",e,true);return this};h.prototype.setHeaderRightText=function(e){this.setProperty("headerRightText",e,true);if(!e){e=""}this.$("hdrRightTxt").text(e).css("display",e?"inline":"none");return this};h.prototype.setAppWidthLimited=function(e){this.$().toggleClass("sapMShellAppWidthLimited",e);this.setProperty("appWidthLimited",e,true);return this};h.prototype.setBackgroundOpacity=function(e){if(e>1||e<0){u.warning("Invalid value "+e+" for Shell.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this}this.$("BG").css("opacity",e);return this.setProperty("backgroundOpacity",e,true)};h.prototype.setHomeIcon=function(e){this.setProperty("homeIcon",e,true);s.setIcons(e);return this};h.prototype._getImage=function(){if(!this.oImg){this.oImg=new p(this.getId()+"-logo",{decorative:false,alt:r.getResourceBundleFor("sap.m").getText("SHELL_ARIA_LOGO")});this.oImg.addStyleClass("sapMShellLogoImg")}return this.oImg};h.prototype._getImageSrc=function(){return this.getLogo()?this.getLogo():this._getGlobalLogo()};return h});
//# sourceMappingURL=Shell.js.map