/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/ui/core/Element","sap/ui/core/Theming","sap/ui/core/Lib","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/Month","sap/ui/core/IconPool","./PlanningCalendarLegend","sap/ui/core/InvisibleText","sap/ui/unified/library","sap/ui/core/date/UI5Date"],function(e,t,a,n,i,l,s,o,r,d,p,c,g){"use strict";var f=c.CalendarDayType;var u={apiVersion:2};u.render=function(e,t){var a=t._getCoreLocaleData();var n=t._getDensitySizes();e.openStart("div",t);e.attr("role","group");e.class("sapMSinglePCGrid");e.class("sapMSPCMonthGrid");e.openEnd();this.renderDayNames(e,t,a);e.openStart("div");e.class("sapMSinglePCGridContent");e.openEnd();this.renderCells(e,t,a,n);e.close("div");e.close("div")};u.renderCells=function(e,t,a,n){var l=t._getCells(),s=t._getVerticalLabels(),o=t._getColumns(),r=i.getResourceBundleFor("sap.ui.unified").getText("CALENDAR_WEEK"),d=[],p=[],c,g,f,u,v,D=[],S,_,C,y;for(C=0;C<t._getRows();C++){_=0;g=s[C];e.openStart("div");e.attr("role","grid");e.class("sapMSPCMonthWeek");e.openEnd();e.openStart("div");e.class("sapMSPCMonthWeekNumber");e.attr("role","row");e.attr("id",`${t.getId()}-week-${g}`);e.attr("aria-label",`${r} ${g}`);e.openEnd();e.openStart("span");e.attr("role","gridcell");e.openEnd();e.text(g);e.close("span");e.close("div");for(y=0;y<o;y++){c=C*o+y;f=l[c];u=t._getAppointmetsForADay(f);v=t._getPreviousAppointmetsForADay(f);D.push(v);S=t._aMoreCountPerDay[c];d.push(S);p.push(u);_=Math.max(_,t._aAppsLevelsPerDay[c].length)}e.openStart("div");e.class("sapMSPCMonthDays");e.class("sapMSPCMonthDaysMax"+_);e.attr("role","row");e.openEnd();e.openStart("div");e.attr("role","gridcell");e.openEnd();e.openStart("div");e.class("sapMSinglePCBlockers");e.class("sapUiCalendarRowVisFilled");e.attr("role","list");e.openEnd();for(y=0;y<o;y++){c=C*o+y;f=l[c];if(y===0){this.renderAppointments(e,t,D[c],y,d[c],n,C,f,l)}this.renderAppointments(e,t,p[c],y,d[c],n,C,f,l)}e.close("div");e.close("div");for(y=0;y<o;y++){c=C*o+y;f=l[c];this.renderDay(e,t,f,a,d[c],c,g)}e.close("div");e.close("div")}};u.renderDay=function(e,t,n,i,s,r,p){var c=t._getSpecialDates(),f=o.prototype._getDateTypes.call(t,n),u=t._getDateFormatter(),v=n.isSame(l.fromLocalJSDate(g.getInstance())),D,S,_;e.openStart("div");e.class("sapMSPCMonthDay");if(t._checkDateSelected(n)){e.class("sapMSPCMonthDaySelected")}if(v){e.class("sapMSPCMonthDayToday")}e.attr("role","gridcell");if(t._isNonWorkingDay(n)){e.class("nonWorkingTimeframe")}if(c){if(f&&f[0]){D=f[0];e.class("sapUiCalendarSpecialDay"+D.type);S=d.findLegendItemForItem(a.getElementById(t._sLegendId),D)}}e.attr("sap-ui-date",n.valueOf().toString());e.attr("tabindex",-1);e.attr("aria-labelledby",`${u.format(n.toLocalJSDate())}-Descr ${t.getId()}-week-${p}`);e.openEnd();this.renderDndPlaceholder(e,t.getAggregation("_appsPlaceholders")[r]);if(v){e.openStart("div");e.class("sapMSPCMonthNowMarker");e.openEnd()}e.openStart("div");e.class("specialDateIndicator");if(f[0]?.color){e.style("background-color",f[0].color)}e.openEnd();e.close("div");e.openStart("div");e.class("sapMSPCMonthDayNumber");e.openEnd();e.text(n.getDate());e.close("div");if(s){_=u.format(n.toLocalJSDate())+"-MoreLinkDesc";e.openStart("div");e.class("sapMSPCMonthLnkMore");e.openEnd();e.renderControl(t._getMoreLink(s,n,r,_));e.openStart("span",_);e.class("sapUiInvisibleText");e.openEnd();e.text(t._getMoreLinkDescription(s,n.toLocalJSDate()));e.close("span");e.close("div")}e.openStart("span",u.format(n.toLocalJSDate())+"-Descr");e.class("sapUiInvisibleText");e.openEnd();e.text(t._getCellStartInfo(n));if(t._sLegendId&&S){e.text(S)}if(t._doesContainAppointments(n)){e.text(t._getCellDescription())}e.close("span");if(v){e.close("div")}e.close("div")};u.renderAppointments=function(e,t,a,n,i,l,s,o,r){var d=t._getMaxAppointments(),p=i?d-2:d-1,c=t._getColumns(),g,f,u;for(var v=0;v<a.length;v++){f=a[v];g=t._getRowEndIndex(r,r.indexOf(o),c);if(f.level<=p){u=f._nextDay>g;if(f._nextDay===undefined||u){continue}this.renderAppointment(e,t,f,n,l,s,o)}else if(f._overflows){f.level=f._nextDayLevel;if(f._nextDay&&f._nextDayLevel<t._getMaxAppointments()-1){this.renderAppointment(e,t,f,f._nextDay,l,s,o)}}}};u.renderAppointment=function(e,a,i,s,o,r,d){var c=i.data,u=i.width,v=i.level,D=a._getCells(),S=a._getColumns(),_=c.getTooltip_AsString(),C=c.getType(),y=c.getColor(),m=c.getTitle(),h=c.getText(),A=c.getIcon(),b=c.getId(),E=c.getStartDate(),I=c.getEndDate(),M=c.getCustomContent(),x=!!M.length,T=!I||a._isAllDayAppointment(E,I),P=T?p.getStaticId("sap.ui.unified","CALENDAR_ALL_DAY_PREFIX"):p.getStaticId("sap.ui.unified","APPOINTMENT"),$=c.getParent().getEnableAppointmentsDragAndDrop(),L=d&&d.isSame(l.fromLocalJSDate(g.getInstance())),w={role:"listitem",labelledby:{value:P,append:true},selected:null},U=S-s-u,k=t.getRTL(),N=n.getTheme(),R=a._findStartDateIndex(D,i,a._iStartDayOffset),W=i._nextDay>R,O=D[i._nextDay],F=a._getDateColumn(D,O,S),J=a._getDateRow(D,O,S),H=J===r,B,V,z,G,K;if(i._overflows||H){if(!i._partRendered){i._partRendered=true;W=i._nextDay>R;s=F;U=S-F+1-u;K=l.fromLocalJSDate(I);z=a._getDateColumn(D,K,S);if(U>0||G){U=S-z-1;if(z<s||G){U=0}}}}if(i._overflows){v=i.level}if(N.includes("horizon")){if(L){V=N.indexOf("_hc")?.4375:.0625}else{V=N.indexOf("_hc")?.1875:.0625}}else{if(L){V=N.indexOf("_hc")?.3125:.0625}else{V=N.indexOf("_hc")?.125:.0625}}U=U<0?0:U;if(!x&&m){w["labelledby"].value=`${w["labelledby"].value} ${b}-${s}_${r}-Title`}w["labelledby"].value=`${w["labelledby"].value} ${b}-${s}_${r}-Descr`;if(!x&&h){w["labelledby"].value=`${w["labelledby"].value} ${b}-${s}_${r}-Text`}if(c.getTentative()){w["labelledby"].value=`${w["labelledby"].value} ${p.getStaticId("sap.ui.unified","APPOINTMENT_TENTATIVE")}`}if(c.getSelected()){w["describedby"]={value:p.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED"),append:true}}e.openStart("div",c.getId()+"-"+s+"_"+r);e.attr("draggable",$);e.attr("data-sap-ui-draggable",$);e.attr("data-sap-ui-related",c.getId());e.attr("data-sap-level",v);e.attr("data-sap-width",u);e.attr("tabindex",0);if(_){e.attr("title",_)}e.accessibilityState(c,w);e.class("sapMSinglePCAppointmentWrap");e.class("sapUiCalendarRowApps");if(!y&&C!==f.None){e.class("sapUiCalendarApp"+C)}if(y){if(t.getRTL()){e.style("border-right-color",y)}else{e.style("border-left-color",y)}}e.style(k?"right":"left","calc("+s*100/S+"% + "+V+"rem)");e.style(k?"left":"right","calc("+U*100/S+"% + "+V+"rem)");e.style("top",v*o.appHeight+o.cellHeaderHeight+"rem");e.openEnd();e.openStart("div");e.class("sapUiCalendarApp");if(c.getSelected()){e.class("sapUiCalendarAppSel")}if(c.getTentative()){e.class("sapUiCalendarAppTent")}if(A){e.class("sapUiCalendarAppWithIcon")}e.openEnd();e.openStart("div");e.class("sapUiCalendarAppCont");if(y&&!c.getSelected()){e.style("background-color",c._getCSSColorForBackground(y))}e.openEnd();if(i.hasPrevious<0||i._overflows||W){B=["sapUiCalendarAppArrowIconLeft","sapUiCalendarAppArrowIcon"];e.icon("sap-icon://arrow-left",B,{title:null,role:"img"})}if(!x&&A){B=["sapUiCalendarAppIcon"];var X={};X["id"]=`${b}-${s}_${r}-Icon`;X["title"]=null;X["role"]="presentation";e.icon(A,B,X)}if(!x&&m){e.openStart("span",`${b}-${s}_${r}-Title`);e.class("sapUiCalendarAppTitle");e.openEnd();e.text(m,true);e.close("span")}if(x){M.forEach(function(t){e.renderControl(t)})}if(i.hasNext<0){B=["sapUiCalendarAppArrowIconRight","sapUiCalendarAppArrowIcon"];e.icon("sap-icon://arrow-right",B,{title:null,role:"img"})}e.openStart("span",`${b}-${s}_${r}-Descr`);e.class("sapUiInvisibleText");e.openEnd();e.text(a._getAppointmentAnnouncementInfo(c));e.close("span");e.close("div");e.close("div");e.close("div")};u.renderDayNames=function(t,a,n){var i=a._getFirstDayOfWeek(),o=a.getId(),r,d=e.getCalendarType(),p=n.getDaysStandAlone("abbreviated",d),c=n.getDaysStandAlone("wide",d),f=g.getInstance(a.getStartDate()),u,v;f.setDate(f.getDate()-f.getDay()+i);u=l.fromLocalJSDate(f);t.openStart("div",`${o}-Names`);t.class("sapMSPCMonthDayNames");t.openEnd();for(var D=0;D<7;D++){v=(D+i)%7;r=`${o}-WH${v}`;t.openStart("div",r);t.class("sapUiCalWH");if(D===0){t.class("sapUiCalFirstWDay")}if(s._isWeekend(u,n)){t.class("sapUiCalItemWeekEnd")}u.setDate(u.getDate()+1);t.accessibilityState(null,{label:c[v]});t.openEnd();t.text(p[v%7]);t.close("div")}t.close("div")};u.renderDndPlaceholder=function(e,t){e.openStart("div");e.class("sapMSinglePCOverlay");e.openEnd();e.renderControl(t);e.close("div")};return u},true);
//# sourceMappingURL=SinglePlanningCalendarMonthGridRenderer.js.map