/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/InvisibleText","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/ResizeHandler","sap/base/Log","./library","./SliderTooltipContainer","./SliderTooltip","./SliderUtilities","./SliderRenderer","./ResponsiveScale","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes"],function(t,e,i,o,s,a,n,r,l,p,u,h,g,f,jQuery,d){"use strict";var c=l.touch;var v=e.extend("sap.m.Slider",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.ISemanticFormContent","sap.m.IToolbarInteractiveControl"],library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:""},min:{type:"float",group:"Data",defaultValue:0},max:{type:"float",group:"Data",defaultValue:100},step:{type:"float",group:"Data",defaultValue:1},progress:{type:"boolean",group:"Misc",defaultValue:true},value:{type:"float",group:"Data",defaultValue:0},showHandleTooltip:{type:"boolean",group:"Appearance",defaultValue:true},showAdvancedTooltip:{type:"boolean",group:"Appearance",defaultValue:false},inputsAsTooltips:{type:"boolean",group:"Appearance",defaultValue:false},enableTickmarks:{type:"boolean",group:"Appearance",defaultValue:false},handlePressed:{type:"boolean",defaultValue:false,group:"Appearance",visibility:"hidden"}},defaultAggregation:"scale",aggregations:{_tooltipContainer:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},scale:{type:"sap.m.IScale",multiple:false,singularName:"scale"},_defaultScale:{type:"sap.m.ResponsiveScale",multiple:false,visibility:"hidden"},_defaultTooltips:{type:"sap.m.SliderTooltipBase",multiple:true,visibility:"hidden"},customTooltips:{type:"sap.m.SliderTooltipBase",multiple:true},_handlesLabels:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"float"}}},liveChange:{parameters:{value:{type:"float"}}}},designtime:"sap/m/designtime/Slider.designtime"},renderer:g});i.apply(v.prototype,[true]);v.prototype._getUsedScale=function(){if(!this.getEnableTickmarks()){return}return this.getAggregation("scale")||this.getAggregation("_defaultScale")};v.prototype._syncScaleUsage=function(){var t=this.getEnableTickmarks(),e=this.getAggregation("scale"),i=this.getAggregation("_defaultScale");if(i&&!t||e&&i){this.destroyAggregation("_defaultScale",true)}if(t&&!e&&!i){this.setAggregation("_defaultScale",new f,true)}};v.prototype._showTooltipsIfNeeded=function(){if(this.getShowAdvancedTooltip()){this.getAggregation("_tooltipContainer").show(this);this.updateAdvancedTooltipDom(this.getValue())}};v.prototype._convertValueToRtlMode=function(t){return this.getMax()-t+this.getMin()};v.prototype._recalculateStyles=function(){var t=this.$();this._fSliderWidth=t.width();this._fSliderPaddingLeft=parseFloat(t.css("padding-left"));this._fSliderOffsetLeft=t.offset().left;this._fHandleWidth=this.$("handle").width()};v.prototype._validateProperties=function(){var t=this.getMin(),e=this.getMax(),i=this.getStep(),o=false,s=false;if(t>=e){o=true;s=true;r.warning("Warning: "+"Property wrong min: "+t+" >= max: "+e+" on ",this)}if(i<=0){r.warning("Warning: "+"The step could not be negative on ",this)}if(i>e-t&&!o){s=true;r.warning("Warning: "+"Property wrong step: "+i+" > max: "+e+" - "+"min: "+t+" on ",this)}return s};v.prototype._getPercentOfValue=function(t){return h.getPercentOfValue(t,this.getMin(),this.getMax())};v.prototype._getValueOfPercent=function(t){var e=this.getMin(),i=t*(this.getMax()-e)/100+e,o=this.toFixed(i,this.getDecimalPrecisionOfNumber(this.getStep()));return Number(o)};v.prototype._getToolbarInteractive=function(){return true};v.prototype._validateStep=function(t){if(typeof t==="undefined"){return 1}if(typeof t!=="number"){r.warning('Warning: "iStep" needs to be a number',this);return 0}if(Math.floor(t)===t&&isFinite(t)){return t}r.warning('Warning: "iStep" needs to be a finite interger',this);return 0};v.prototype._handleSliderResize=function(t){var e=this._getUsedScale();if(this.getEnableTickmarks()&&e&&e.handleResize){e.handleResize(t)}if(this.getShowAdvancedTooltip()){this._handleTooltipContainerResponsiveness()}};v.prototype._handleTooltipContainerResponsiveness=function(){this.getAggregation("_tooltipContainer").setWidth(this.$().width()+"px")};v.prototype.getDecimalPrecisionOfNumber=function(t){if(Math.floor(t)===t){return 0}var e=t.toString(),i=e.indexOf("."),o=e.indexOf("e-"),s=o!==-1,a=i!==-1;if(s){var n=+e.slice(o+2);if(a){return n+e.slice(i+1,o).length}return n}if(a){return e.length-i-1}return 0};v.prototype.toFixed=function(t,e){if(e===undefined){e=this.getDecimalPrecisionOfNumber(t)}if(e>20){e=20}else if(e<0){e=0}return t.toFixed(e)+""};v.prototype.setDomValue=function(e){var i=this.getDomRef(),o=this._formatValueByCustomElement(e),s=this.getAggregation("_tooltipContainer");if(!i){return}var a=Math.max(this._getPercentOfValue(+e),0)+"%",n=this.getDomRef("handle");if(this.getName()){this.getDomRef("input").setAttribute("value",o)}if(this.getProgress()){this.getDomRef("progress").style.width=a}n.style[t.getRTL()?"right":"left"]=a;if(this.getShowAdvancedTooltip()&&s.getDomRef()){this.updateAdvancedTooltipDom(e)}if(this.getShowHandleTooltip()&&!this.getShowAdvancedTooltip()){n.title=o}this._updateHandleAriaAttributeValues(n,e,o)};v.prototype._updateHandleAriaAttributeValues=function(t,e,i){if(this._isElementsFormatterNotNumerical(e)){t.setAttribute("aria-valuenow",e);t.setAttribute("aria-valuetext",i)}else{t.setAttribute("aria-valuenow",i);t.removeAttribute("aria-valuetext")}};v.prototype._formatValueByCustomElement=function(t,e){var i=this._getUsedScale(),o=this.getUsedTooltips()[0],s=""+t;if(e==="slider"){return s}if(this.getEnableTickmarks()&&i&&i.getLabel){s=""+i.getLabel(t,this)}if(e==="scale"){return s}if(this.getShowAdvancedTooltip()&&o&&o.getLabel){s=""+o.getLabel(t,this)}return s};v.prototype._isElementsFormatterNotNumerical=function(t){var e=this._formatValueByCustomElement(t);return isNaN(e)};v.prototype.updateAdvancedTooltipDom=function(t){var e=this.getUsedTooltips();this.updateTooltipsPositionAndState(e[0],parseFloat(t))};v.prototype.getUsedTooltips=function(){var t=this.getCustomTooltips(),e=this.getAggregation("_defaultTooltips")||[];return t.length?t:e};v.prototype.updateTooltipsPositionAndState=function(t,e){var i=this.getAggregation("_tooltipContainer");t.setValue(e);i.repositionTooltips(this.getMin(),this.getMax())};v.prototype.getClosestHandleDomRef=function(){return this.getDomRef("handle")};v.prototype._increaseValueBy=function(t){var e,i;if(this.getEnabled()){e=this.getValue();this.setValue(e+(t||1));i=this.getValue();if(e<i){this._fireChangeAndLiveChange({value:i})}}};v.prototype._decreaseValueBy=function(t){var e,i;if(this.getEnabled()){e=this.getValue();this.setValue(e-(t||1));i=this.getValue();if(e>i){this._fireChangeAndLiveChange({value:i})}}};v.prototype._getLongStep=function(){var t=this.getMin(),e=this.getMax(),i=this.getStep(),o=(e-t)/10,s=(e-t)/i;return s>10?o:i};v.prototype._fireChangeAndLiveChange=function(t){this.fireChange(t);this.fireLiveChange(t)};v.prototype.handleTooltipChange=function(t){var e=parseFloat(t.getParameter("value"));this.setValue(e);this._fireChangeAndLiveChange({value:e})};v.prototype._registerResizeHandler=function(){if(!this._parentResizeHandler){this._parentResizeHandler=n.register(this,this._handleSliderResize.bind(this))}};v.prototype._deregisterResizeHandler=function(){if(this._parentResizeHandler){n.deregister(this._parentResizeHandler);this._parentResizeHandler=null}};v.prototype.init=function(){var t;this._iActiveTouchId=-1;this._bSetValueFirstCall=true;this._fValueBeforeFocus=0;this._parentResizeHandler=null;this._oResourceBundle=s.getResourceBundleFor("sap.m");this._oTooltipContainer=null;t=new o({text:this._oResourceBundle.getText("SLIDER_HANDLE")});this.addAggregation("_handlesLabels",t)};v.prototype.exit=function(){if(this._oResourceBundle){this._oResourceBundle=null}if(this.getAggregation("_defaultTooltips")){this.destroyAggregation("_defaultTooltips")}this._deregisterResizeHandler()};v.prototype.onBeforeRendering=function(){var t=this._validateProperties();if(!t){this.setValue(this.getValue());this._sProgressValue=Math.max(this._getPercentOfValue(this.getValue()),0)+"%"}if(this.getShowAdvancedTooltip()){this.initAndSyncTooltips(["leftTooltip"])}this._deregisterResizeHandler();this._syncScaleUsage()};v.prototype.forwardProperties=function(t,e){t.forEach(function(t){e.setProperty(t,this.getProperty(t))},this)};v.prototype.forwardPropertiesToDefaultTooltips=function(t){var e=this.getAggregation("_defaultTooltips")||[];for(var i=0;i<t;i++){this.forwardProperties(["min","max","step"],e[i]);e[i].setWidth(this._getMaxTooltipWidth()+"px");e[i].setEditable(this.getInputsAsTooltips())}};v.prototype.associateCustomTooltips=function(t){this.destroyAggregation("_defaultTooltips",true);this._oTooltipContainer.removeAllAssociation("associatedTooltips",true);for(var e=0;e<t;e++){this._oTooltipContainer.addAssociation("associatedTooltips",this.getCustomTooltips()[e],true)}};v.prototype.assignDefaultTooltips=function(t){var e=this.getAggregation("_defaultTooltips")||[];if(e.length===0){this._oTooltipContainer.removeAllAssociation("associatedTooltips",true);t.forEach(function(t){this.initDefaultTooltip(t)},this)}this.forwardProperties(["enabled"],this._oTooltipContainer);this.forwardPropertiesToDefaultTooltips(t.length)};v.prototype.initAndSyncTooltips=function(t){var e=this.getCustomTooltips(),i=e.length,o=t.length;this.initTooltipContainer();if(i<o){this.assignDefaultTooltips(t)}else{if(i>o){r.warning("Warning: More than "+o+" Custom Tooltips are provided. Only the first will be used.")}this.associateCustomTooltips(o)}};v.prototype.initDefaultTooltip=function(t){var e=new u(this.getId()+"-"+t,{change:this.handleTooltipChange.bind(this)});this.getAggregation("_tooltipContainer").addAssociation("associatedTooltips",e,true);this.addAggregation("_defaultTooltips",e,true)};v.prototype.initTooltipContainer=function(){if(!this._oTooltipContainer){this._oTooltipContainer=new p;this.setAggregation("_tooltipContainer",this._oTooltipContainer,true)}};v.prototype._getMaxTooltipWidth=function(){var t=[Math.abs(this.getMin()),Math.abs(this.getMax())],e=t[0]>t[1]?0:1;return(t[e].toString().length+this.getDecimalPrecisionOfNumber(this.getStep())+1)*h.CONSTANTS.CHARACTER_WIDTH_PX};v.prototype.onAfterRendering=function(){if(this.getShowAdvancedTooltip()){this._recalculateStyles();this._handleTooltipContainerResponsiveness()}this._handleSliderResize({control:this});this._registerResizeHandler()};v.prototype.ontouchstart=function(e){var i=this.getMin(),o=e.targetTouches[0],s,a=this.getRenderer().CSS_CLASS,n="."+a;e.setMarked();if(e.target.className.indexOf("sapMInput")===-1){e.preventDefault()}this.focus();if(c.countContained(e.touches,this.getId())>1||!this.getEnabled()||e.button||e.srcControl!==this){return}this._iActiveTouchId=o.identifier;jQuery(document).on("touchend"+n+" touchcancel"+n+" mouseup"+n,this._ontouchend.bind(this)).on(e.originalEvent.type==="touchstart"?"touchmove"+n:"touchmove"+n+" mousemove"+n,this._ontouchmove.bind(this));var r=this.getClosestHandleDomRef();if(o.target!==r){setTimeout(r["focus"].bind(r),0)}this._recalculateStyles();this._fDiffX=this._fSliderPaddingLeft;this._fInitialValue=this.getValue();this.$("inner").addClass(a+"Pressed");this.setProperty("handlePressed",true);if(o.target===this.getDomRef("handle")){this._fDiffX=o.pageX-jQuery(r).offset().left+this._fSliderPaddingLeft-this._fHandleWidth/2}else{s=(o.pageX-this._fSliderPaddingLeft-this._fSliderOffsetLeft)/this._fSliderWidth*(this.getMax()-i)+i;if(t.getRTL()){s=this._convertValueToRtlMode(s)}this.setValue(s);s=this.getValue();if(this._fInitialValue!==s){this.fireLiveChange({value:s})}}};v.prototype._ontouchmove=function(e){e.setMarked();e.preventDefault();if(e.isMarked("delayedMouseEvent")||!this.getEnabled()||e.button){return}var i=this.getMin(),o=this.getValue(),s=c.find(e.changedTouches,this._iActiveTouchId),a=s?s.pageX:e.pageX,n=(a-this._fDiffX-this._fSliderOffsetLeft)/this._fSliderWidth*(this.getMax()-i)+i;if(t.getRTL()){n=this._convertValueToRtlMode(n)}this.setValue(n);n=this.getValue();if(o!==n){this.fireLiveChange({value:n})}};v.prototype._ontouchend=function(t){var e=this.getRenderer().CSS_CLASS,i="."+e;t.setMarked();if(t.isMarked("delayedMouseEvent")||!this.getEnabled()||t.button){return}jQuery(document).off(i);var o=this.getValue();this.setProperty("handlePressed",false);if(this._fInitialValue!==o){this.fireChange({value:o})}};v.prototype.onfocusin=function(t){this._fValueBeforeFocus=this.getValue();if(this.getShowAdvancedTooltip()){this.getAggregation("_tooltipContainer").show(this);this._setAriaControls();this.updateAdvancedTooltipDom(this.getValue())}};v.prototype._setAriaControls=function(){var t=this.getUsedTooltips()[0],e=this.getFocusDomRef();if(this.getInputsAsTooltips()&&t&&t.getDomRef()){e.setAttribute("aria-controls",t.getId())}};v.prototype.onfocusout=function(t){if(!this.getShowAdvancedTooltip()){return}var e=jQuery.contains(this.getDomRef(),t.relatedTarget),i=jQuery.contains(this.getAggregation("_tooltipContainer").getDomRef(),t.relatedTarget);if(e||i){return}this.getAggregation("_tooltipContainer").hide()};v.prototype.onmouseover=function(t){var e,i;if(this.getShowAdvancedTooltip()){this.getAggregation("_tooltipContainer").show(this);i=this.getAggregation("_tooltipContainer");e=jQuery.contains(i.getDomRef(),document.activeElement);this._setAriaControls();if(e){return}this.updateAdvancedTooltipDom(this.getValue())}};v.prototype.onmouseout=function(t){if(!this.getShowAdvancedTooltip()){return}var e=this.getAggregation("_tooltipContainer").getDomRef(),i=this.getDomRef(),o=jQuery.contains(i,document.activeElement),s=jQuery.contains(e,document.activeElement);if(!e||o||s){return}if(jQuery.contains(this.getDomRef(),t.toElement)||i===t.toElement){return}if(jQuery.contains(this.getAggregation("_tooltipContainer").getDomRef(),t.toElement)){return}this.getAggregation("_tooltipContainer").hide()};v.prototype.onkeydown=function(t){var e=this.getUsedTooltips();if(t.keyCode===h.CONSTANTS.F2_KEYCODE&&e[0]&&this.getInputsAsTooltips()){e[0].focus()}if(t.keyCode===d.SPACE){t.preventDefault()}};v.prototype.onsapincrease=function(t){var e,i;t.preventDefault();t.setMarked();if(this.getEnabled()){e=this.getValue();this.stepUp(1);i=this.getValue();if(e<i){this._fireChangeAndLiveChange({value:i})}}this._showTooltipsIfNeeded()};v.prototype.onsapincreasemodifiers=function(t){if(t.altKey){return}t.preventDefault();t.stopPropagation();t.setMarked();this._increaseValueBy(this._getLongStep());this._showTooltipsIfNeeded()};v.prototype.onsapdecrease=function(t){var e,i;t.preventDefault();t.setMarked();if(this.getEnabled()){e=this.getValue();this.stepDown(1);i=this.getValue();if(e>i){this._fireChangeAndLiveChange({value:i})}}this._showTooltipsIfNeeded()};v.prototype.onsapdecreasemodifiers=function(t){if(t.altKey){return}t.preventDefault();t.stopPropagation();t.setMarked();this._decreaseValueBy(this._getLongStep());this._showTooltipsIfNeeded()};v.prototype.onsapplus=function(t){var e,i;t.setMarked();if(this.getEnabled()){e=this.getValue();this.stepUp(1);i=this.getValue();if(e<i){this._fireChangeAndLiveChange({value:i})}}this._showTooltipsIfNeeded()};v.prototype.onsapminus=function(t){var e,i;t.setMarked();if(this.getEnabled()){e=this.getValue();this.stepDown(1);i=this.getValue();if(e>i){this._fireChangeAndLiveChange({value:i})}}this._showTooltipsIfNeeded()};v.prototype.onsapescape=function(){this.setValue(this._fValueBeforeFocus)};v.prototype.onsappageup=v.prototype.onsapincreasemodifiers;v.prototype.onsappagedown=v.prototype.onsapdecreasemodifiers;v.prototype.onsaphome=function(t){t.setMarked();var e=this.getMin();t.preventDefault();if(this.getEnabled()&&this.getValue()>e){this.setValue(e);this._fireChangeAndLiveChange({value:e})}this._showTooltipsIfNeeded()};v.prototype.onsapend=function(t){t.setMarked();var e=this.getMax();t.preventDefault();if(this.getEnabled()&&this.getValue()<e){this.setValue(e);this._fireChangeAndLiveChange({value:e})}this._showTooltipsIfNeeded()};v.prototype.getFocusDomRef=function(){return this.getDomRef("handle")};v.prototype.stepUp=function(t){return this.setValue(this.getValue()+this._validateStep(t)*this.getStep(),{snapValue:false})};v.prototype.stepDown=function(t){return this.setValue(this.getValue()-this._validateStep(t)*this.getStep(),{snapValue:false})};v.prototype.setValue=function(t,e){if(this._bSetValueFirstCall){this._bSetValueFirstCall=false;return this.setProperty("value",t,true)}var i=this.getMin(),o=this.getMax(),s=this.getStep(),a=this.getValue(),n,r=true,l;if(e){r=!!e.snapValue}if(typeof t!=="number"||!isFinite(t)){return this}l=Math.abs((t-i)%s);if(r&&l!==0){t=l*2>=s?t+s-l:t-l}if(t<i){t=i}else if(t>o){t=o}n=this.toFixed(t,this.getDecimalPrecisionOfNumber(s));t=Number(n);this.setProperty("value",t);if(a!==this.getValue()){this.setDomValue(n)}return this};v.prototype.getFormFormattedValue=function(){return this.getValue()};v.prototype.getFormValueProperty=function(){return"value"};v.prototype.getFormObservingProperties=function(){return["value"]};v.prototype.getFormRenderAsControl=function(){return false};return v});
//# sourceMappingURL=Slider.js.map