/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/date/CalendarWeekNumbering","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/Item","./DynamicDateOption","./Label","./RadioButton","./Select","./VBox","sap/ui/core/date/UniversalDateUtils","sap/ui/core/date/UniversalDate","sap/ui/core/date/UI5Date","sap/m/DynamicDateValueHelpUIType","./library"],function(e,t,a,s,r,n,T,E,D,A,S,c,i,R){"use strict";var o=a.VerticalAlign;var l=r.extend("sap.m.StandardDynamicDateOption",{metadata:{library:"sap.m",properties:{calendarWeekNumbering:{type:"sap.base.i18n.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null}}}});var N=1;var g=6e3;var u={DATE:"DATE",DATETIME:"DATETIME",DATERANGE:"DATERANGE",DATETIMERANGE:"DATETIMERANGE",TODAY:"TODAY",YESTERDAY:"YESTERDAY",TOMORROW:"TOMORROW",SPECIFICMONTH:"SPECIFICMONTH",SPECIFICMONTHINYEAR:"SPECIFICMONTHINYEAR",FIRSTDAYWEEK:"FIRSTDAYWEEK",LASTDAYWEEK:"LASTDAYWEEK",FIRSTDAYMONTH:"FIRSTDAYMONTH",LASTDAYMONTH:"LASTDAYMONTH",FIRSTDAYQUARTER:"FIRSTDAYQUARTER",LASTDAYQUARTER:"LASTDAYQUARTER",FIRSTDAYYEAR:"FIRSTDAYYEAR",LASTDAYYEAR:"LASTDAYYEAR",THISWEEK:"THISWEEK",THISMONTH:"THISMONTH",THISQUARTER:"THISQUARTER",THISYEAR:"THISYEAR",LASTWEEK:"LASTWEEK",LASTMONTH:"LASTMONTH",LASTQUARTER:"LASTQUARTER",LASTYEAR:"LASTYEAR",NEXTWEEK:"NEXTWEEK",NEXTMONTH:"NEXTMONTH",NEXTQUARTER:"NEXTQUARTER",NEXTYEAR:"NEXTYEAR",LASTMINUTES:"LASTMINUTES",LASTHOURS:"LASTHOURS",LASTDAYS:"LASTDAYS",LASTWEEKS:"LASTWEEKS",LASTMONTHS:"LASTMONTHS",LASTQUARTERS:"LASTQUARTERS",LASTYEARS:"LASTYEARS",NEXTMINUTES:"NEXTMINUTES",NEXTHOURS:"NEXTHOURS",NEXTDAYS:"NEXTDAYS",NEXTWEEKS:"NEXTWEEKS",NEXTMONTHS:"NEXTMONTHS",NEXTQUARTERS:"NEXTQUARTERS",NEXTYEARS:"NEXTYEARS",LASTMINUTESINCLUDED:"LASTMINUTESINCLUDED",LASTHOURSINCLUDED:"LASTHOURSINCLUDED",LASTDAYSINCLUDED:"LASTDAYSINCLUDED",LASTWEEKSINCLUDED:"LASTWEEKSINCLUDED",LASTMONTHSINCLUDED:"LASTMONTHSINCLUDED",LASTQUARTERSINCLUDED:"LASTQUARTERSINCLUDED",LASTYEARSINCLUDED:"LASTYEARSINCLUDED",NEXTMINUTESINCLUDED:"NEXTMINUTESINCLUDED",NEXTHOURSINCLUDED:"NEXTHOURSINCLUDED",NEXTDAYSINCLUDED:"NEXTDAYSINCLUDED",NEXTWEEKSINCLUDED:"NEXTWEEKSINCLUDED",NEXTMONTHSINCLUDED:"NEXTMONTHSINCLUDED",NEXTQUARTERSINCLUDED:"NEXTQUARTERSINCLUDED",NEXTYEARSINCLUDED:"NEXTYEARSINCLUDED",FROM:"FROM",TO:"TO",FROMDATETIME:"FROMDATETIME",TODATETIME:"TODATETIME",YEARTODATE:"YEARTODATE",DATETOYEAR:"DATETOYEAR",TODAYFROMTO:"TODAYFROMTO",QUARTER1:"QUARTER1",QUARTER2:"QUARTER2",QUARTER3:"QUARTER3",QUARTER4:"QUARTER4"};var I={SingleDates:1,DateRanges:2,Weeks:3,Months:4,Quarters:5,Years:6};var L={DATE:I.SingleDates,DATETIME:I.SingleDates,DATERANGE:I.DateRanges,DATETIMERANGE:I.DateRanges,TODAY:I.SingleDates,YESTERDAY:I.SingleDates,TOMORROW:I.SingleDates,SPECIFICMONTH:I.Months,SPECIFICMONTHINYEAR:I.Months,FIRSTDAYWEEK:I.SingleDates,LASTDAYWEEK:I.SingleDates,FIRSTDAYMONTH:I.SingleDates,LASTDAYMONTH:I.SingleDates,FIRSTDAYQUARTER:I.SingleDates,LASTDAYQUARTER:I.SingleDates,FIRSTDAYYEAR:I.SingleDates,LASTDAYYEAR:I.SingleDates,THISWEEK:I.Weeks,THISMONTH:I.Months,THISQUARTER:I.Quarters,THISYEAR:I.Years,LASTWEEK:I.Weeks,LASTMONTH:I.Months,LASTQUARTER:I.Quarters,LASTYEAR:I.Years,NEXTWEEK:I.Weeks,NEXTMONTH:I.Months,NEXTQUARTER:I.Quarters,NEXTYEAR:I.Years,LASTMINUTES:I.DateRanges,LASTHOURS:I.DateRanges,LASTDAYS:I.DateRanges,LASTWEEKS:I.DateRanges,LASTMONTHS:I.DateRanges,LASTQUARTERS:I.DateRanges,LASTYEARS:I.DateRanges,NEXTMINUTES:I.DateRanges,NEXTHOURS:I.DateRanges,NEXTDAYS:I.DateRanges,NEXTWEEKS:I.DateRanges,NEXTMONTHS:I.DateRanges,NEXTQUARTERS:I.DateRanges,NEXTYEARS:I.DateRanges,LASTMINUTESINCLUDED:I.DateRanges,LASTHOURSINCLUDED:I.DateRanges,LASTDAYSINCLUDED:I.DateRanges,LASTWEEKSINCLUDED:I.DateRanges,LASTMONTHSINCLUDED:I.DateRanges,LASTQUARTERSINCLUDED:I.DateRanges,LASTYEARSINCLUDED:I.DateRanges,NEXTMINUTESINCLUDED:I.DateRanges,NEXTHOURSINCLUDED:I.DateRanges,NEXTDAYSINCLUDED:I.DateRanges,NEXTWEEKSINCLUDED:I.DateRanges,NEXTMONTHSINCLUDED:I.DateRanges,NEXTQUARTERSINCLUDED:I.DateRanges,NEXTYEARSINCLUDED:I.DateRanges,FROM:I.DateRanges,TO:I.DateRanges,FROMDATETIME:I.DateRanges,TODATETIME:I.DateRanges,YEARTODATE:I.DateRanges,DATETOYEAR:I.DateRanges,TODAYFROMTO:I.DateRanges,QUARTER1:I.Quarters,QUARTER2:I.Quarters,QUARTER3:I.Quarters,QUARTER4:I.Quarters};var O=["LASTMINUTES","LASTHOURS","LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS"];var U=["NEXTMINUTES","NEXTHOURS","NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS"];var p=["LASTMINUTESINCLUDED","LASTHOURSINCLUDED","LASTDAYSINCLUDED","LASTWEEKSINCLUDED","LASTMONTHSINCLUDED","LASTQUARTERSINCLUDED","LASTYEARSINCLUDED"];var d=["NEXTMINUTESINCLUDED","NEXTHOURSINCLUDED","NEXTDAYSINCLUDED","NEXTWEEKSINCLUDED","NEXTMONTHSINCLUDED","NEXTQUARTERSINCLUDED","NEXTYEARSINCLUDED"];l.LastXKeys=O.concat(p);l.NextXKeys=U.concat(d);var M=t.getResourceBundleFor("sap.m");l.Keys=u;l.prototype.exit=function(){if(this.aValueHelpUITypes){while(this.aValueHelpUITypes.length){this.aValueHelpUITypes.pop().destroy()}delete this.aValueHelpUITypes}};l.prototype.getText=function(e){var t=this.getKey();var a=e._getOptions();var s=this.getValueHelpUITypes(e);var r=this._getOptionParams(O,a);var n=this._getOptionIncludedParams(p,a);var T=this._getOptionParams(U,a);var E=this._getOptionIncludedParams(d,a);if(r){s.push(r)}if(n){s.push(n)}if(T){s.push(T)}if(E){s.push(E)}switch(t){case u.LASTMINUTES:case u.LASTHOURS:case u.LASTDAYS:case u.LASTWEEKS:case u.LASTMONTHS:case u.LASTQUARTERS:case u.LASTYEARS:case u.NEXTMINUTES:case u.NEXTHOURS:case u.NEXTDAYS:case u.NEXTWEEKS:case u.NEXTMONTHS:case u.NEXTQUARTERS:case u.NEXTYEARS:case u.LASTMINUTESINCLUDED:case u.LASTHOURSINCLUDED:case u.LASTDAYSINCLUDED:case u.LASTWEEKSINCLUDED:case u.LASTMONTHSINCLUDED:case u.LASTQUARTERSINCLUDED:case u.LASTYEARSINCLUDED:case u.NEXTMINUTESINCLUDED:case u.NEXTHOURSINCLUDED:case u.NEXTDAYSINCLUDED:case u.NEXTWEEKSINCLUDED:case u.NEXTMONTHSINCLUDED:case u.NEXTQUARTERSINCLUDED:case u.NEXTYEARSINCLUDED:return this._getXPeriodTitle(s[1].getOptions());case u.FROMDATETIME:case u.TODATETIME:case u.DATETIMERANGE:return e._findOption(t)._bAdditionalTimeText?M.getText("DYNAMIC_DATE_"+t+"_TITLE")+" ("+M.getText("DYNAMIC_DATE_DATETIME_TITLE")+")":M.getText("DYNAMIC_DATE_"+t+"_TITLE");default:return M.getText("DYNAMIC_DATE_"+t+"_TITLE")}};l.prototype.getValueHelpUITypes=function(e){var t=this.getKey();if(!this.aValueHelpUITypes){switch(t){case u.TODAY:case u.YESTERDAY:case u.TOMORROW:case u.FIRSTDAYWEEK:case u.LASTDAYWEEK:case u.FIRSTDAYMONTH:case u.LASTDAYMONTH:case u.FIRSTDAYQUARTER:case u.LASTDAYQUARTER:case u.FIRSTDAYYEAR:case u.LASTDAYYEAR:case u.THISWEEK:case u.THISMONTH:case u.THISQUARTER:case u.THISYEAR:case u.LASTWEEK:case u.LASTMONTH:case u.LASTQUARTER:case u.LASTYEAR:case u.NEXTWEEK:case u.NEXTMONTH:case u.NEXTQUARTER:case u.NEXTYEAR:case u.YEARTODATE:case u.DATETOYEAR:case u.QUARTER1:case u.QUARTER2:case u.QUARTER3:case u.QUARTER4:this.aValueHelpUITypes=[];break;case u.DATETIME:case u.FROMDATETIME:case u.TODATETIME:this.aValueHelpUITypes=[new i({type:"datetime"})];break;case u.DATE:case u.FROM:case u.TO:this.aValueHelpUITypes=[new i({type:"date"})];break;case u.DATERANGE:this.aValueHelpUITypes=[new i({type:"daterange"})];break;case u.SPECIFICMONTH:this.aValueHelpUITypes=[new i({type:"month"})];break;case u.SPECIFICMONTHINYEAR:this.aValueHelpUITypes=[new i({type:"custommonth"})];break;case u.LASTMINUTES:case u.LASTHOURS:case u.LASTDAYS:case u.LASTWEEKS:case u.LASTMONTHS:case u.LASTQUARTERS:case u.LASTYEARS:case u.NEXTMINUTES:case u.NEXTHOURS:case u.NEXTDAYS:case u.NEXTWEEKS:case u.NEXTMONTHS:case u.NEXTQUARTERS:case u.NEXTYEARS:case u.LASTMINUTESINCLUDED:case u.LASTHOURSINCLUDED:case u.LASTDAYSINCLUDED:case u.LASTWEEKSINCLUDED:case u.LASTMONTHSINCLUDED:case u.LASTQUARTERSINCLUDED:case u.LASTYEARSINCLUDED:case u.NEXTMINUTESINCLUDED:case u.NEXTHOURSINCLUDED:case u.NEXTDAYSINCLUDED:case u.NEXTWEEKSINCLUDED:case u.NEXTMONTHSINCLUDED:case u.NEXTQUARTERSINCLUDED:case u.NEXTYEARSINCLUDED:this.aValueHelpUITypes=[new i({text:M.getText("DDR_LASTNEXTX_LABEL"),type:"int"})];break;case u.TODAYFROMTO:this.aValueHelpUITypes=[new i({text:M.getText("DDR_TODAYFROMTO_FROM_LABEL"),type:"int",additionalText:M.getText("DDR_TODAYFROMTO_TO_ADDITIONAL_LABEL")}),new i({text:M.getText("DDR_TODAYFROMTO_TO_LABEL"),type:"int",additionalText:M.getText("DDR_TODAYFROMTO_TO_ADDITIONAL_LABEL")})];break;case u.DATETIMERANGE:this.aValueHelpUITypes=[new i({text:M.getText("DDR_DATETIMERANGE_FROM_LABEL"),type:"datetime"}),new i({text:M.getText("DDR_DATETIMERANGE_TO_LABEL"),type:"datetime"})];break}}return this.aValueHelpUITypes.slice(0)};l.prototype.createValueHelpUI=function(e,t){var a=e._getOptions(),s=e.getValue()&&Object.assign({},e.getValue()),r=this.getValueHelpUITypes(e),T=[],E,D=e.getCalendarWeekNumbering();if(!e.aControlsByParameters){e.aControlsByParameters={}}e.aControlsByParameters[this.getKey()]=[];var A=this._getOptionParams(O,a);var S=this._getOptionIncludedParams(p,a);var c=this._getOptionParams(U,a);var i=this._getOptionIncludedParams(d,a);if(A){r.push(A)}if(S){r.push(S)}if(c){r.push(c)}if(i){r.push(i)}if(s&&s.values){s.values=s.values.map(function(e){return e})}for(var R=0;R<r.length;R++){E=null;if(r[R].getOptions()&&r[R].getOptions().length<=1&&r[R].getOptions().indexOf("included")!==-1){break}else if(r[R].getText()){E=new n({text:r[R].getText(),width:"100%"});T.push(E)}var l;switch(r[R].getType()){case"int":l=this._createIntegerControl(s,R,t);var N=s&&r[1]&&r[1].getOptions()&&(r[1].getOptions().indexOf(s.operator.slice(4).toLowerCase())!==-1||r[1].getOptions().indexOf(s.operator.slice(4).toLowerCase().replace("included",""))!==-1);if(N){l.setValue(s.values[R])}break;case"date":l=this._createDateControl(s,R,t,D);break;case"datetime":if(r.length===1){l=this._createDateTimeInnerControl(s,R,t,D)}else if(r.length===2){l=this._createDateTimeControl(s,R,t,D)}break;case"daterange":l=this._createDateRangeControl(s,R,t,D);break;case"month":l=this._createMonthControl(s,R,t);break;case"custommonth":l=this._createCustomMonthControl(s,R,t);break;case"options":l=this._createOptionsControl(s,R,t,r);break;case"included":l=this._createIncludedControl(s,t);break;default:break}T.push(l);E&&E.setLabelFor(l);if(r[R].getAdditionalText()){T.push(new n({vAlign:o.Bottom,text:r[R].getAdditionalText()}).addStyleClass("sapMDDRAdditionalLabel"))}e.aControlsByParameters[this.getKey()].push(l)}return T};l.prototype._createIntegerControl=function(e,t,a){var s=r.prototype._createIntegerControl.call(this,e,t,a);var n=this.getKey()==="TODAYFROMTO"?-g:N;var T=!e||this.getKey()!==e.operator;if(T){s.setValue(1)}s.setMin(n);s.setMax(g);return s};l.prototype._createOptionsControl=function(e,t,a,s){const r=s[t].getOptions();const n=r.map(function(e){let t=e;if(t.indexOf("included")!==-1){t=t.replace("included","")}if(r.indexOf(e)!==-1&&r.indexOf(t)!==-1&&t!==e){return""}return t.toUpperCase()});const T=n.filter(function(e){return e!==""});var D=new E({items:[T.map(Y)]});D.setSelectedKey(D.getAggregation("items")[0].getKey());if(e){const a=s[t].getOptions();for(let e=0;e<a.length;e++){if(a[e].indexOf("included")!==-1){a[e]=a[e].replace("included","")}const t=a.lastIndexOf(a[e]);if(e!==t){a.splice(t,1)}}var A=e.operator.slice(4).replace("INCLUDED",""),S=a.indexOf(A?.toLowerCase());if(S!==-1){D.setSelectedKey(A)}}if(a instanceof Function){D.attachChange(function(){a(this)},this)}return D};l.prototype._createIncludedControl=function(e,t){const a=new T({text:M.getText("DDR_LASTNEXTX_INCLUDE_LABEL"),groupName:`includedSelection-${this.getKey()}`});const s=new T({text:M.getText("DDR_LASTNEXTX_EXCLUDE_LABEL"),selected:true,groupName:`includedSelection-${this.getKey()}`});const r=new D({items:[s,new n({text:"",wrapping:true}),a,new n({text:"",wrapping:true})]});if(e&&e.operator.indexOf("INCLUDED")>-1){a.setSelected(true)}else{s.setSelected(true)}this._oInternalIncludedControl=r;if(t instanceof Function){a.attachSelect(function(){t(this)},this);s.attachSelect(function(){t(this)},this)}return r};l.prototype._getOptionParams=function(e,t){if(e.indexOf(this.getKey())!==-1){return new i({text:M.getText("DDR_LASTNEXTX_TIME_UNIT_LABEL"),type:"options",options:t?t.filter(function(t){return e.indexOf(t.getKey())!==-1||e.indexOf(t.getKey().replace("INCLUDED",""))!==-1}).map(function(e){return e.getKey().slice(4).toLowerCase()}):[]})}return undefined};l.prototype._getOptionIncludedParams=function(e,t){if(e.indexOf(this.getKey()+"INCLUDED")!==-1){return new i({text:M.getText("DDR_LASTNEXTX_TIME_PERIODS_LABEL"),type:"included",options:t?t.filter(function(t){return e.indexOf(t.getKey())!==-1}).map(function(e){return e.getKey().slice(4).toLowerCase()}):[]})}if(e.indexOf(this.getKey())!==-1){return new i({text:M.getText("DDR_LASTNEXTX_TIME_UNIT_LABEL"),type:"options",options:t?t.filter(function(t){return e.indexOf(t.getKey())!==-1}).map(function(e){return e.getKey().replace("INCLUDED","").slice(4).toLowerCase()}):[]})}return undefined};l.prototype.validateValueHelpUI=function(e){var t=this.getValueHelpUITypes();for(var a=0;a<t.length;a++){var s=e.aControlsByParameters[this.getKey()][a];switch(t[a].getType()){case"int":if(s._isLessThanMin(s.getValue())||s._isMoreThanMax(s.getValue())){return false}break;case"month":case"custommonth":case"date":case"daterange":if(!s.getSelectedDates()||s.getSelectedDates().length==0){return false}break;case"datetime":if(t.length===1){if(!s.getCalendar().getSelectedDates()||s.getCalendar().getSelectedDates().length==0){return false}}else if(!s.getDateValue()&&t.length===2){return false}break;case"options":if(s.getSelectedIndex()<0){return false}break;default:break}}return true};l.prototype.getValueHelpOutput=function(e){var t=e._getOptions();var a=this.getValueHelpUITypes(e),s=e.aControlsByParameters&&e.aControlsByParameters[this.getKey()]&&e.aControlsByParameters[this.getKey()].length>1,r=O.indexOf(this.getKey())!==-1||p.indexOf(this.getKey())!==-1,n=U.indexOf(this.getKey())!==-1||d.indexOf(this.getKey())!==-1,T={},E;if(r&&s){T.operator=t.filter(function(e){return this._shouldAddLastOrNextOption(t,e,O)}.bind(this))[e.aControlsByParameters[this.getKey()][1].getSelectedIndex()].getKey()}else if(n&&s){T.operator=t.filter(function(e){return this._shouldAddLastOrNextOption(t,e,U)}.bind(this))[e.aControlsByParameters[this.getKey()][1].getSelectedIndex()].getKey()}else{T.operator=this.getKey()}if(O.indexOf(this.getKey())!==-1||U.indexOf(this.getKey())!==-1){const t=e.getStandardOptions().indexOf(T.operator+"INCLUDED")>-1;const a=e.aControlsByParameters&&e.aControlsByParameters[this.getKey()]&&e.aControlsByParameters[this.getKey()][2]?.getItems()[2].getSelected();if(a&&t){T.operator=T.operator+"INCLUDED"}}T.values=[];if(!e.aControlsByParameters||!e.aControlsByParameters[this.getKey()]){return T}for(var D=0;D<a.length;D++){var A=e.aControlsByParameters[this.getKey()][D];switch(a[D].getType()){case"int":E=A.getValue();break;case"month":if(!A.getSelectedDates()||!A.getSelectedDates().length){return null}E=A.getSelectedDates()[0].getStartDate().getMonth();break;case"custommonth":if(!A.getSelectedDates()||!A.getSelectedDates().length){return null}E=[A.getSelectedDates()[0].getStartDate().getMonth(),A.getSelectedDates()[0].getStartDate().getFullYear()];break;case"date":if(!A.getSelectedDates().length){return null}E=A.getSelectedDates()[0].getStartDate();break;case"datetime":if(a.length===1){var S,c,i,R;i=A.getCalendar();R=A.getClocks();if(!i.getSelectedDates().length){return null}S=i.getSelectedDates()[0].getStartDate();c=R.getTimeValues();S.setHours(c.getHours(),c.getMinutes(),c.getSeconds());E=S}else if(a.length===2){if(!A.getDateValue()){return null}E=A.getDateValue()}break;case"daterange":if(!A.getSelectedDates().length){return null}var o=A.getSelectedDates()[0].getEndDate()||A.getSelectedDates()[0].getStartDate();E=[A.getSelectedDates()[0].getStartDate(),o];break;default:break}if(Array.isArray(E)){T.values=Array.prototype.concat.apply(T.values,E)}else{E!==null&&E!==undefined&&T.values.push(E)}}return T};l.prototype._shouldAddLastOrNextOption=function(e,t,a){let s=t.getKey();let r=0;if(s.indexOf("INCLUDED")!==-1){r++;s=s.replace("INCLUDED","")}for(let t=0;t<e.length;t++){if(e[t].getKey()===s){r++}}return a.indexOf(s)!==-1&&r===1};l.prototype._isLastOrNextOption=function(){const e=l.LastXKeys.concat(l.NextXKeys);return e.includes(this.getKey())};l.prototype.alignValueHelpUI=function(e){const t=e.aControlsByParameters[this.getKey()];const a=t[1];const s=a instanceof E;if(s&&this._isLastOrNextOption()&&a.getSelectableItems().length===1){a.setVisible(false);const t=e.aInputControls[2];t.setVisible(false)}const r=O.indexOf(this.getKey())!==-1&&e.aControlsByParameters[Object.keys(e.aControlsByParameters)[0]].length>1;const n=U.indexOf(this.getKey())!==-1&&e.aControlsByParameters[Object.keys(e.aControlsByParameters)[0]].length>1;const T=r||n;if(!T){return}const D=a.getSelectedKey();const A=this.getKey().slice(0,4)+D.toUpperCase();const S=t[2];const c=e.aInputControls[4];const i=t[0];const R=this.toDates({operator:A+"INCLUDED",values:[i.getValue()]});const o=this.toDates({operator:A,values:[i.getValue()]});const l=e._getDatesLabelFormatter().format(R);const N=e._getDatesLabelFormatter().format(o);S?.getItems()[1].setText(N);S?.getItems()[3].setText(l);if(e.getStandardOptions().indexOf(A+"INCLUDED")!==-1&&e.getStandardOptions().indexOf(A)!==-1){S?.setVisible(true);c?.setVisible(true)}else{S?.setVisible(false);c?.setVisible(false)}};l.prototype.getGroup=function(){return L[this.getKey()]};l.prototype.getGroupHeader=function(){return M.getText("DDR_OPTIONS_GROUP_"+L[this.getKey()])};l.prototype.format=function(e,t){return t.format(e,true)};l.prototype.parse=function(e,t){return t.parse(e,this.getKey())};l.prototype.toDates=function(e,t){if(!e){return null}var a=e.operator;var s=e.values[0]||0;switch(a){case"SPECIFICMONTH":var r=new S;r.setMonth(e.values[0]);r=A.getMonthStartDate(r);return A.getRange(0,"MONTH",r);case"SPECIFICMONTHINYEAR":var r=new S;r.setMonth(e.values[0]);r.setFullYear(e.values[1]);r=A.getMonthStartDate(r);return A.getRange(0,"MONTH",r);case"DATE":return A.getRange(0,"DAY",S.getInstance(e.values[0]));case"DATETIME":var n=new S.getInstance(e.values[0]);return[n,n];case"DATERANGE":var T=S.getInstance(e.values[0]);var E=S.getInstance(e.values[1]);return[A.resetStartTime(T),A.resetEndTime(E)];case"DATETIMERANGE":var T=S.getInstance(e.values[0]);var E=S.getInstance(e.values[1]);T.setMilliseconds(0);E.setMilliseconds(999);return[T,E];case"TODAY":return A.ranges.today();case"YESTERDAY":return A.ranges.yesterday();case"TOMORROW":return A.ranges.tomorrow();case"FIRSTDAYWEEK":return A.ranges.firstDayOfWeek(t);case"LASTDAYWEEK":return A.ranges.lastDayOfWeek(t);case"FIRSTDAYMONTH":return A.ranges.firstDayOfMonth();case"LASTDAYMONTH":return A.ranges.lastDayOfMonth();case"FIRSTDAYQUARTER":return A.ranges.firstDayOfQuarter();case"LASTDAYQUARTER":return A.ranges.lastDayOfQuarter();case"FIRSTDAYYEAR":return A.ranges.firstDayOfYear();case"LASTDAYYEAR":return A.ranges.lastDayOfYear();case"THISWEEK":return A.ranges.currentWeek(t);case"THISMONTH":return A.ranges.currentMonth();case"THISQUARTER":return A.ranges.currentQuarter();case"THISYEAR":return A.ranges.currentYear();case"LASTWEEK":return A.ranges.lastWeek(t);case"LASTMONTH":return A.ranges.lastMonth();case"LASTQUARTER":return A.ranges.lastQuarter();case"LASTYEAR":return A.ranges.lastYear();case"NEXTWEEK":return A.ranges.nextWeek(t);case"NEXTMONTH":return A.ranges.nextMonth();case"NEXTQUARTER":return A.ranges.nextQuarter();case"NEXTYEAR":return A.ranges.nextYear();case"LASTMINUTES":return A.ranges.lastMinutes(s);case"LASTHOURS":return A.ranges.lastHours(s);case"LASTDAYS":return A.ranges.lastDays(s);case"LASTWEEKS":return A.ranges.lastWeeks(s,t);case"LASTMONTHS":return A.ranges.lastMonths(s);case"LASTQUARTERS":return A.ranges.lastQuarters(s);case"LASTYEARS":return A.ranges.lastYears(s);case"LASTMINUTESINCLUDED":var D=A.ranges.lastMinutes(s-1);D[0].setSeconds(0);return D;case"LASTHOURSINCLUDED":var D=A.ranges.lastHours(s-1);D[0].setMinutes(0,0);return D;case"LASTDAYSINCLUDED":var D=A.ranges.lastDays(s-1);D[1]=S.getInstance(c.getInstance());return D;case"LASTWEEKSINCLUDED":var D=A.ranges.lastWeeks(s-1,t);D[1]=S.getInstance(c.getInstance());return D;case"LASTMONTHSINCLUDED":var D=A.ranges.lastMonths(s-1);D[1]=S.getInstance(c.getInstance());return D;case"LASTQUARTERSINCLUDED":var D=A.ranges.lastQuarters(s-1);D[1]=S.getInstance(c.getInstance());return D;case"LASTYEARSINCLUDED":var D=A.ranges.lastYears(s-1);D[1]=S.getInstance(c.getInstance());return D;case"NEXTMINUTES":return A.ranges.nextMinutes(s);case"NEXTHOURS":return A.ranges.nextHours(s);case"NEXTDAYS":return A.ranges.nextDays(s);case"NEXTWEEKS":return A.ranges.nextWeeks(s,t);case"NEXTMONTHS":return A.ranges.nextMonths(s);case"NEXTQUARTERS":return A.ranges.nextQuarters(s);case"NEXTYEARS":return A.ranges.nextYears(s);case"NEXTMINUTESINCLUDED":var D=A.ranges.nextMinutes(s-1);D[1].setSeconds(59);return D;case"NEXTHOURSINCLUDED":var D=A.ranges.nextHours(s-1);D[1].setMinutes(59,59);return D;case"NEXTDAYSINCLUDED":var D=A.ranges.nextDays(s-1);D[0]=S.getInstance(c.getInstance());return D;case"NEXTWEEKSINCLUDED":var D=A.ranges.nextWeeks(s-1,t);D[0]=S.getInstance(c.getInstance());return D;case"NEXTMONTHSINCLUDED":var D=A.ranges.nextMonths(s-1);D[0]=S.getInstance(c.getInstance());return D;case"NEXTQUARTERSINCLUDED":var D=A.ranges.nextQuarters(s-1);D[0]=S.getInstance(c.getInstance());return D;case"NEXTYEARSINCLUDED":var D=A.ranges.nextYears(s-1);D[0]=S.getInstance(c.getInstance());return D;case"FROM":return[S.getInstance(e.values[0])];case"TO":return[S.getInstance(e.values[0])];case"FROMDATETIME":var r=S.getInstance(e.values[0]);r.setMilliseconds(0);return[r];case"TODATETIME":var r=S.getInstance(e.values[0]);r.setMilliseconds(999);return[r];case"YEARTODATE":return A.ranges.yearToDate();case"DATETOYEAR":return A.ranges.dateToYear();case"TODAYFROMTO":if(e.values.length!==2){return[]}var i=e.values[0];var R=e.values[1];var T=i>=0?A.ranges.lastDays(i)[0]:A.ranges.nextDays(-i)[1];var E=R>=0?A.ranges.nextDays(R)[1]:A.ranges.lastDays(-R)[0];if(T.oDate.getTime()>E.oDate.getTime()){E=[T,T=E][0]}return[A.resetStartTime(T),A.resetEndTime(E)];case"QUARTER1":return A.ranges.quarter(1);case"QUARTER2":return A.ranges.quarter(2);case"QUARTER3":return A.ranges.quarter(3);case"QUARTER4":return A.ranges.quarter(4);default:return[]}};l.prototype.enhanceFormattedValue=function(){switch(this.getKey()){case"TODAY":case"YESTERDAY":case"TOMORROW":case"FIRSTDAYWEEK":case"LASTDAYWEEK":case"FIRSTDAYMONTH":case"LASTDAYMONTH":case"FIRSTDAYQUARTER":case"LASTDAYQUARTER":case"FIRSTDAYYEAR":case"LASTDAYYEAR":case"THISWEEK":case"THISMONTH":case"THISQUARTER":case"THISYEAR":case"LASTWEEK":case"LASTMONTH":case"LASTQUARTER":case"LASTYEAR":case"NEXTWEEK":case"NEXTMONTH":case"NEXTQUARTER":case"NEXTYEAR":case"YEARTODATE":case"DATETOYEAR":case"QUARTER1":case"QUARTER2":case"QUARTER3":case"QUARTER4":return true;default:return false}};l.prototype._getXPeriodTitle=function(e){var t,a=this.getKey();if(e.length===1){return M.getText("DYNAMIC_DATE_"+a+"_TITLE")}const s=e.map(function(t){let a=t;if(a.indexOf("included")!==-1){a=a.replace("included","")}if(e.indexOf(t)!==-1&&e.indexOf(a)!==-1&&a!==t){return""}return M.getText("DYNAMIC_DATE_"+a.toUpperCase())});const r=s.filter(function(e){return e!==""});t=r.join(" / ");if(a.indexOf("LAST")===0){return M.getText("DYNAMIC_DATE_LASTX_TITLE",[t])}if(a.indexOf("NEXT")===0){return M.getText("DYNAMIC_DATE_NEXTX_TITLE",[t])}};function Y(e){return new s({key:e.toUpperCase(),text:M.getText("DYNAMIC_DATE_"+e.toUpperCase())})}return l});
//# sourceMappingURL=StandardDynamicDateOption.js.map