/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/IconPool","sap/ui/core/theming/Parameters","sap/ui/Device","./library","./ListItemBase","./Image","./StandardListItemRenderer","sap/base/Log"],function(t,e,i,n,o,r,a,s,p,u){"use strict";var h=e.TextDirection;var l=e.ValueState;var f=a.extend("sap.m.StandardListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},description:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconInset:{type:"boolean",group:"Appearance",defaultValue:true},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},info:{type:"string",group:"Misc",defaultValue:null},infoState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:l.None},adaptTitleSize:{type:"boolean",group:"Appearance",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:h.Inherit},infoTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:h.Inherit},wrapping:{type:"boolean",group:"Behavior",defaultValue:false},infoStateInverted:{type:"boolean",group:"Appearance",defaultValue:false},wrapCharLimit:{type:"int",group:"Behavior",defaultValue:0}},aggregations:{avatar:{type:"sap.m.Avatar",multiple:false}},designtime:"sap/m/designtime/StandardListItem.designtime"},renderer:p});f.prototype.exit=function(){if(this._oImage){this._oImage.destroy("KeepDom")}a.prototype.exit.apply(this,arguments)};f.prototype.setIcon=function(t){var e=this.getIcon();this.setProperty("icon",t);if(this._oImage&&(!t||i.isIconURI(t)!=i.isIconURI(e))){this._oImage.destroy("KeepDom");this._oImage=undefined}return this};f.prototype.setAvatar=function(t){if(this.getAvatar()===t){return this}if(t){t.addStyleClass("sapMSLIAvatar");t.setDisplaySize=function(){return this}}this.setAggregation("avatar",t);return this};f.prototype.setWrapCharLimit=function(t){var e=this.getWrapCharLimit();if(e===t){return this}if(t<0){u.error("The property wrapCharLimit must be 0 or greater than 0 - "+this.getId());return this}this.setProperty("wrapCharLimit",t);return this};f.prototype._getImage=function(){var t=this._oImage;if(t){t.setSrc(this.getIcon());if(t.setDensityAware){t.setDensityAware(this.getIconDensityAware())}}else{t=i.createControlByURI({id:this.getId()+"-img",src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false},s).setParent(this,null,true)}var e=this.getIconInset()?"sapMSLIImg":"sapMSLIImgNoInset";t.addStyleClass(t instanceof s?e:e+"Icon",true);this._oImage=t;return this._oImage};f.prototype._getAvatar=function(){var t=this.getAvatar();var e=this.getIconInset()?r.AvatarSize.XS:r.AvatarSize.S;t.setProperty("displaySize",e,true);return t};f.prototype._activeHandlingInheritor=function(){if(this._oImage){var t=this.getActiveIcon();t&&this._oImage.setSrc(t)}};f.prototype._inactiveHandlingInheritor=function(){if(this._oImage){this._oImage.setSrc(this.getIcon())}};f.prototype.getContentAnnouncement=function(t){var e=this.getInfoState(),i=this.getTitle(),n,o=this.getDescription(),r,a,s,p=[],u=this.getInfo();if(this.getWrapping()){a=this.getDomRef("titleButton");s=this.getDomRef("descriptionButton");i=this._bTitleTextExpanded?i:this._getCollapsedText(i);o=this._bDescriptionTextExpanded?o:this._getCollapsedText(o);p.push(i);if(a){n=a.textContent+" "+t.getText("ACC_CTR_TYPE_BUTTON");n&&p.push(n)}p.push(o);if(s){r=s.textContent+" . "+t.getText("ACC_CTR_TYPE_BUTTON");r&&p.push(r)}}else{i&&p.push(i);o&&p.push(o)}u&&p.push(u);if(e!="None"&&e!=this.getHighlight()){p.push(t.getText("LIST_ITEM_STATE_"+e.toUpperCase()))}return p.join(" . ").trim()};f.prototype._measureInfoTextWidth=function(t){if(!f._themeInfo){f._themeInfo={}}var e=parseFloat(r.BaseFontSize)||16;if(!f._themeInfo.sFontFamily||t){f._themeInfo.sFontFamily=n.get({name:"sapUiFontFamily"})||"Arial"}if(!f._themeInfo.sFontStyleInfoStateInverted||t){f._themeInfo.sFontStyleInfoStateInverted="bold "+parseFloat(n.get({name:"sapMFontSmallSize"})||"0.75rem")*e+"px "+f._themeInfo.sFontFamily}if(!f._themeInfo.sFontStyle||t){f._themeInfo.sFontStyle=parseFloat(n.get({name:"sapMFontMediumSize"})||"0.875rem")*e+"px "+f._themeInfo.sFontFamily}if(!f._oCtx){f._oCtx=document.createElement("canvas").getContext("2d")}f._oCtx.font=f._themeInfo[this.getInfoStateInverted()?"sFontStyleInfoStateInverted":"sFontStyle"];return Math.ceil(f._oCtx.measureText(this.getInfo()).width)/e};f.prototype._getInfoTextMinWidth=function(t){if(this.getInfoStateInverted()&&t<=7.5){return t+.625+"rem"}if(t<=7.5){return t+"rem"}return"7.5rem"};f.prototype.ontap=function(t){this._checkExpandCollapse(t);return a.prototype.ontap.apply(this,arguments)};f.prototype.ontouchstart=function(t){var e=t.target&&t.target.id,i=this.getId();if(e===i+"-titleButton"||e===i+"-descriptionButton"){t.setMarked()}return a.prototype.ontouchstart.apply(this,arguments)};f.prototype.onsapspace=function(t){this._checkExpandCollapse(t,true);if(!t.isMarked()){return a.prototype.onsapspace.apply(this,arguments)}};f.prototype._checkExpandCollapse=function(t,e){var i=t.target,n=i&&i.id;if(n&&n===this.getId()+"-titleButton"){if(e){t.preventDefault()}t.setMarked();return this._toggleExpandCollapse("title",this._bTitleTextExpanded)}if(n&&n===this.getId()+"-descriptionButton"){if(e){t.preventDefault()}t.setMarked();return this._toggleExpandCollapse("description",this._bDescriptionTextExpanded)}};f.prototype._toggleExpandCollapse=function(e,i){var n=this.getDomRef(e+"Text"),o=this.getDomRef(e+"ThreeDots"),r=this.getDomRef(e+"Button"),a=e==="title"?this.getTitle():this.getDescription(),s=t.getResourceBundleFor("sap.m");if(!i){n.textContent=a;o.textContent=" ";r.textContent=s.getText("EXPANDABLE_TEXT_SHOW_LESS");i=true}else{n.textContent=this._getCollapsedText(a);o.textContent=" ... ";r.textContent=s.getText("EXPANDABLE_TEXT_SHOW_MORE");i=false}if(e==="title"){this._bTitleTextExpanded=i}else{this._bDescriptionTextExpanded=i}};f.prototype._getCollapsedText=function(t){return t.substr(0,this._getWrapCharLimit())};f.prototype._getWrapCharLimit=function(){return this.getWrapCharLimit()||(o.system.phone?100:300)};f.prototype.onThemeChanged=function(t){a.prototype.onThemeChanged.apply(this,arguments);var e=t.theme;if(!this._initialRender){this._initialRender=true;if(!f._themeInfo){f._themeInfo={}}if(!f._themeInfo.sCurrentTheme){f._themeInfo.sCurrentTheme=e}return}var i=this.getDomRef("info");if(i){var n;if(f._themeInfo.sCurrentTheme!==e){f._themeInfo.sCurrentTheme=e;n=this._measureInfoTextWidth(true)}else{n=this._measureInfoTextWidth()}i.style.minWidth=this._getInfoTextMinWidth(n)}};return f});
//# sourceMappingURL=StandardListItem.js.map