/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","sap/ui/base/EventProvider","sap/ui/core/InvisibleText","sap/ui/core/ValueStateSupport","sap/m/library","sap/ui/core/library","sap/m/List","sap/m/inputUtils/scrollToItem","sap/m/inputUtils/SuggestionsPopoverDialogMixin","sap/m/inputUtils/SuggestionsPopoverPopoverMixin"],function(t,e,s,i,a,o,n,r,u,l){"use strict";var p=a.ListMode;var d=a.ListSeparators;var c="sapMSuggestionsPopover",g="sapUiNoContentPadding";var f=o.ValueState;var h=e.extend("sap.m.SuggestionsPopover",{constructor:function(){e.apply(this,arguments);this._sPopoverContentWidth=null;this._sOldValueState=f.None;this._sAreaDescribedById=null;this._bLinkDelegateInitialised=false;if(t.system.phone){u.apply(h.prototype)}else{l.apply(h.prototype)}},destroy:function(){this._destroySuggestionPopup()}});h.M_EVENTS={SELECTION_CHANGE:"selectionChange"};h.prototype.isOpen=function(){var t=this.getPopover();return t&&t.isOpen()};h.prototype.setPopover=function(t){this._oPopover=t};h.prototype.getPopover=function(){return this._oPopover};h.prototype.destroyPopover=function(){if(this._oPopover){this._oPopover.destroy()}this._oPopover=null};h.prototype.setInputLabels=function(t){this._fnInputLabels=t};h.prototype.createSuggestionPopup=function(t,e,i){var a,o=this.getItemsContainer();e=e||[];a=this.createPopover(t,e,i);this.setPopover(a);a.addStyleClass(c);a.addStyleClass(g);a.addAriaLabelledBy(s.getStaticId("sap.m","INPUT_AVALIABLE_VALUES"));this._sAreaDescribedById=t.getValueStateLinksShortcutsId();if(t.getValueStateLinksForAcc().length>0){a.addAriaDescribedBy(this._sAreaDescribedById)}if(o){this.addContent(o)}this.setValueStateLinksDelegateInitialized(false)};h.prototype.initContent=function(t,e){var s=e,i=this.getPopover();if(!i){return}if(!s){s=new n(t+"-popup-list",{showNoData:false,mode:p.SingleSelectMaster,rememberSelections:false,width:"100%",showSeparators:d.None,busyIndicatorDelay:0});s.applyAriaRole("listbox")}this.addContent(s)};h.prototype._destroySuggestionPopup=function(){this.destroyPopover();this._oValueStateHeader=null};h.prototype.addContent=function(t){this.getPopover().addContent(t)};h.prototype.getItemsContainer=function(){var t=this.getPopover(),e=t&&t.getContent();return e&&e.filter(function(t){return t.isA("sap.m.List")&&t.getId().indexOf("-popup-list")>-1||t.isA("sap.m.Table")})[0]};h.prototype.handleListNavigation=function(e,s,i){var a=this.getPopover();if(s.isMarked()){return}if(!e.getEnabled()||!e.getEditable()){return}if(!a||!a.isOpen()){return}s.preventDefault();s.stopPropagation();var o=this.getItemsContainer(),n=e.hasStyleClass("sapMFocus"),u=o&&o.getItems().filter(function(t){return t.getVisible&&t.getVisible()}),l;const p=this.getSelectedListItemIndex();switch(s.type){case"sapdown":l=this.handleArrowDown(u,p,n,i);break;case"sapup":l=this.handleArrowUp(u,p,n);break;case"sapend":l=this.handleEnd(u);break;case"saphome":l=this.handleHome(u);break;case"sappagedown":l=this.handlePageDown(u,p);break;case"sappageup":l=this.handlePageUp(u,p);break}this.updateFocus(e,l);if(e.handleSelectionFromList){e.handleSelectionFromList(l)}else{this.handleSelectionFromList(l)}this.updateAriaActiveDescendant(e,l);if(t.system.desktop&&l){r(l,this.getPopover())}};h.prototype.handleArrowDown=function(t,e,s,i){if(s&&!i){return t[0]}if(!s&&!i){if(e===t.length-1){return t[e]}return t[e+1]}if(e===t.length-1&&i){return t[e]}return t[e+1]};h.prototype.handleArrowUp=function(t,e,s){if(s){return}if(e>0){return t[e-1]}};h.prototype.handleEnd=function(t){return t.length&&t[t.length-1]};h.prototype.handleHome=function(t){return t.length&&t[0]};h.prototype.handlePageDown=function(t,e){return t[Math.min(t.length-1,e+10)]};h.prototype.handlePageUp=function(t,e){if(e-10>=0){return t[e-10]}return t[0]};h.prototype.updateFocus=function(t,e){var s=this.getItemsContainer(),i=this.getFocusedListItem(),a=t._hasTabularSuggestions?.()??false;s&&s.removeStyleClass("sapMListFocus");i&&i.removeStyleClass("sapMLIBFocused");t.hasStyleClass("sapMFocus")&&t.removeStyleClass("sapMFocus");if(e){!a&&e.addStyleClass("sapMLIBFocused");a&&s.setFakeFocus(e);s.addStyleClass("sapMListFocus");this.updateListDataAttributes(s)}else{t.addStyleClass("sapMFocus")}};h.prototype.updateListDataAttributes=function(t){if(!t){return}var e=t.getVisibleItems();if(!e){return}e.forEach(function(t){var e=t.getDomRef();if(e&&e.hasAttribute("data-sap-ui-first-suggestion-item")){e.removeAttribute("data-sap-ui-first-suggestion-item")}if(e&&e.hasAttribute("data-sap-ui-last-suggestion-item")){e.removeAttribute("data-sap-ui-last-suggestion-item")}});if(e[0]){var s=e[0].getDomRef();s&&s.setAttribute("data-sap-ui-first-suggestion-item","")}if(e[e.length-1]){var i=e[e.length-1].getDomRef();i&&i.setAttribute("data-sap-ui-last-suggestion-item","")}};h.prototype.handleSelectionFromList=function(t){var e=this.getItemsContainer(),s=this.getFocusedListItem(),i=t&&t.isA("sap.m.GroupHeaderListItem");if(!t||i){e.removeSelections(true)}else{e.setSelectedItem(t,true)}this.fireEvent(h.M_EVENTS.SELECTION_CHANGE,{previousItem:s,newItem:t})};h.prototype.updateAriaActiveDescendant=function(t,e){var s=t.getFocusDomRef();if(t.hasStyleClass("sapMFocus")){s.removeAttribute("aria-activedescendant");return}if(e){s.setAttribute("aria-activedescendant",e.getId());return}};h.prototype.getFocusedListItem=function(){var t=this.getItemsContainer(),e=t&&t.getItems()||[];for(var s=0;s<e.length;s++){if(e[s].hasStyleClass("sapMLIBFocused")){return e[s]}}};h.prototype.getSelectedListItemIndex=function(){const t=this.getItemsContainer();const e=t&&t.getItems()||[];const s=e.filter(t=>t.getVisible&&t.getVisible());if(e.filter(t=>t.getSelected()).length){return s.findIndex(t=>t.getSelected())}return s.findIndex(t=>t.hasStyleClass("sapMLIBFocused"))};h.prototype.setValueStateActiveState=function(t){this.bMessageValueStateActive=t};h.prototype.getValueStateActiveState=function(){return this.bMessageValueStateActive};h.prototype.fnValueStateLinkDelegate=function(t,e,s){return{onsapup:function(e){t.getFocusDomRef().focus();this.handleListNavigation(t,e)},onsapdown:function(e){t.getFocusDomRef().focus();this.handleListNavigation(t,e)},onfocusout:function(t){if(!e.getDomRef().contains(t.relatedTarget)){s.forEach(function(t){t.getDomRef().setAttribute("tabindex","-1")})}this.setValueStateActiveState(false)},onfocusin:function(){s.forEach(function(t){t.getDomRef().setAttribute("tabindex","0")});this.setValueStateActiveState(true)}}};h.prototype.updateValueState=function(t,e,s,a=false){e=e||i.getAdditionalText(t);if(!this.getPopover()){return this}if(this.getInput()){this.getInput().setValueState(t)}var o=this._getValueStateHeader();o.setValueState(t);if(o&&typeof e==="string"){o.setText(e);this.updateAriaDescribedBy()}else if(o&&typeof e==="object"){o.setFormattedText(e);const t=e!==null?o.getFormattedText().getControls():[];this.updateAriaDescribedBy(t)}if(o){o.setValueState(s?t:f.None)}if(a){this.setValueStateLinksDelegateInitialized(false)}this._alignValueStateStyles(t);return this};h.prototype.updateAriaDescribedBy=function(t){if(!this.getPopover()){return}const e=this.getPopover().getAriaDescribedBy();const s=t||[];if(e.some(t=>t===this._sAreaDescribedById)&&s.length===0){this.getPopover().removeAriaDescribedBy(this._sAreaDescribedById)}else if(!e.some(t=>t===this._sAreaDescribedById)&&s.length>0){this.getPopover().addAriaDescribedBy(this._sAreaDescribedById)}};h.prototype._handleValueStateLinkNav=function(t,e){if(!this.getValueStateActiveState()||this.getValueStateActiveState()&&document.activeElement.tagName==="A"||this.getValueStateLinks().length===0){return}var s=this.getValueStateLinks(),i=this._getValueStateHeader(),a=s[s.length-1],o=s[0];e.preventDefault();if(this.getFocusedListItem()){this.getFocusedListItem().removeStyleClass("sapMLIBFocused")}o.focus();if(!this.getValueStateLinksDelegateInitialized()){s.forEach(function(e){e.removeEventDelegate(this.fnValueStateLinkDelegate(t,i,s),this)},this);s.forEach(function(e){e.addEventDelegate(this.fnValueStateLinkDelegate(t,i,s),this)},this);a.addDelegate({onsaptabnext:function(e){this.setValueStateActiveState(false);t.onsapfocusleave(e);this.getPopover().close();setTimeout(function(){t.closeValueStateMessage()},0)}},this);o.addDelegate({onsaptabprevious:function(e){e.preventDefault();t.getFocusDomRef().focus();this.setValueStateActiveState(false);t.removeStyleClass("sapMFocus")}},this);this.setValueStateLinksDelegateInitialized(true)}};h.prototype.getValueStateLinks=function(){var t=this._getValueStateHeader(),e=t&&typeof t.getFormattedText==="function"&&t.getFormattedText(),s=e&&typeof e.getControls==="function"&&e.getControls();return s||[]};h.prototype.getValueStateLinksDelegateInitialized=function(){return this._bLinkDelegateInitialised};h.prototype.setValueStateLinksDelegateInitialized=function(t){this._bLinkDelegateInitialised=t};h.prototype._alignValueStateStyles=function(t){var e=c+"ValueState",s=c+this._sOldValueState+"State",i=c+t+"State",a=this.getPopover();a.addStyleClass(e);a.removeStyleClass(s);a.addStyleClass(i);this._sOldValueState=t};h.prototype.decorateParent=function(t){t.addEventDelegate({onsaptabnext:this._handleValueStateLinkNav.bind(this,t),onsaptabprevious:this._handleValueStateLinkNav.bind(this,t)},this)};h.prototype.getInput=function(){return null};h.prototype.getPickerTitle=function(){return null};h.prototype.getOkButton=function(){return null};h.prototype.getCancelButton=function(){return null};h.prototype.getFilterSelectedButton=function(){return null};h.prototype.setOkPressHandler=function(){return null};h.prototype.setCancelPressHandler=function(){return null};h.prototype.setShowSelectedPressHandler=function(){return null};h.prototype.resizePopup=function(){};h.prototype._getValueStateHeader=function(){return null};h.prototype._createValueStateHeader=function(){return null};return h});
//# sourceMappingURL=SuggestionsPopover.js.map