/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/IconPool","sap/ui/core/Lib","sap/ui/core/RenderManager","sap/ui/core/util/ResponsivePaddingsEnablement","./TabContainerRenderer","./TabStrip","./TabStripItem","./Button","sap/ui/Device"],function(t,e,i,r,o,n,a,s,p,u,d,m){"use strict";var g=t.ButtonType;var l=t.PageBackgroundDesign;var c=e.extend("sap.m.TabContainer",{metadata:{library:"sap.m",properties:{showAddNewButton:{type:"boolean",group:"Misc",defaultValue:false},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:l.List}},aggregations:{items:{type:"sap.m.TabContainerItem",multiple:true,singularName:"item",bindable:"bindable"},_addNewButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_tabStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.m.TabContainerItem",multiple:false}},events:{itemClose:{allowPreventDefault:true,parameters:{item:{type:"sap.m.TabContainerItem"}}},itemSelect:{allowPreventDefault:true,parameters:{item:{type:"sap.m.TabContainerItem"}}},addNewButtonPress:{}},designtime:"sap/m/designtime/TabContainer.designtime",dnd:{draggable:false,droppable:true}},constructor:function(t,i){var r=[];if(!i&&typeof t==="object"){i=t}if(i&&Array.isArray(i["items"])){r=i["items"];delete i["items"]}e.prototype.constructor.apply(this,arguments);var o=new p(this.getId()+"--tabstrip",{hasSelect:true,itemSelect:function(t){var e=t.getParameter("item"),i=this._fromTabStripItem(e);this.setSelectedItem(i,t)}.bind(this),itemClose:function(t){var e=t.getParameter("item"),i=this._fromTabStripItem(e);t.preventDefault();if(this.fireItemClose({item:i})){if(!this.getBinding("items")){this.removeItem(i)}}}.bind(this)});this.setAggregation("_tabStrip",o,true);if(i&&i["showAddNewButton"]){this.setShowAddNewButton(true)}r.forEach(function(t){this.addItem(t)},this);this.data("sap-ui-fastnavgroup","true",true)},renderer:s});var h={name:"text",additionalText:"additionalText",icon:"icon",iconTooltip:"iconTooltip",modified:"modified"};a.call(c.prototype,{header:{selector:".sapMTabStripContainer"}});c.prototype.init=function(){this._initResponsivePaddingsEnablement()};c.prototype.onBeforeRendering=function(){if(this.getSelectedItem()){return}this._setDefaultTab()};c.prototype._getAddNewTabButton=function(){var t=this.getAggregation("_addNewButton");var e=o.getResourceBundleFor("sap.m");if(!t){t=new d({type:g.Transparent,tooltip:e.getText("TABCONTAINER_ADD_NEW_TAB"),icon:r.getIconURI("add"),press:function(){this.getParent().getParent().fireAddNewButtonPress()}});t.addStyleClass("sapMTSAddNewTabBtn");this.setAggregation("_addNewButton",t,true)}return t};c.prototype._getTabStrip=function(){return this.getAggregation("_tabStrip")};c.prototype._fromTabStripItem=function(t){var e=this.getItems()||[],i=e.length,r=0;for(;r<i;r++){if(e[r].getId()===t.getKey()){return e[r]}}return null};c.prototype._toTabStripItem=function(t){var e=0,i=t,r,o,n=this._getTabStrip();if(!n){return null}r=n.getItems();o=r.length;if(typeof t==="object"){i=t.getId()}for(;e<o;e++){if(r[e].getKey()===i){return r[e]}}return null};c.prototype._getSelectedItemContent=function(){var t=this._getTabStrip(),e=this.getSelectedItem(),r=i.getElementById(e),o=this._toTabStripItem(r);if(t){t.setSelectedItem(o)}return r?r.getContent():null};c.prototype._moveToNextItem=function(t){if(!this._getTabStrip()._oItemNavigation){return}var e=this.getItems().length,i=this._getTabStrip()._oItemNavigation.getFocusedIndex(),r=e===i?--i:i,o=this.getItems()[r],n=function(){if(this._getTabStrip()._oItemNavigation){this._getTabStrip()._oItemNavigation.focusItem(r)}},a=document.activeElement.classList;if(t){this.setSelectedItem(o);this.fireItemSelect({item:o})}if(a.contains("sapMTabStripSelectListItemCloseBtn")||a.contains("sapMTabStripItem")){setTimeout(n.bind(this),0)}};c.prototype._attachItemPropertyChanged=function(t){t.attachItemPropertyChanged(function(t){var e=t["mParameters"].propertyKey;if(h[e]){e=h[e];var i=this._toTabStripItem(t.getSource());var r="set"+e.substr(0,1).toUpperCase()+e.substr(1);i&&i[r](t["mParameters"].propertyValue)}}.bind(this))};c.prototype.removeItem=function(t){var e=this._getTabStrip(),i,r;if(typeof t==="undefined"||t===null){return null}t=this.removeAggregation("items",t);i=t.getId()===this.getSelectedItem();r=this._toTabStripItem(t);if(r.getId()===e.getSelectedItem()){e.removeAllAssociation("selectedItem",true)}e.removeItem(r);this._moveToNextItem(i);return t};c.prototype.addAggregation=function(t,i,r){if(t==="items"){this._attachItemPropertyChanged(i)}return e.prototype.addAggregation.call(this,t,i,r)};c.prototype.insertAggregation=function(t,i,r,o){if(t==="items"){this._attachItemPropertyChanged(i)}return e.prototype.insertAggregation.call(this,t,i,r,o)};c.prototype.addItem=function(t){this.addAggregation("items",t,false);this._getTabStrip().addItem(this._setupTabStripItem(t));return this};c.prototype.destroyItems=function(){this._getTabStrip().destroyItems();this.setAssociation("selectedItem",null);return this.destroyAggregation("items")};c.prototype.insertItem=function(t,e){this._getTabStrip().insertItem(this._setupTabStripItem(t),e);return this.insertAggregation("items",t,e)};c.prototype.removeAllItems=function(){this._getTabStrip().removeAllItems();this.setSelectedItem(null);return this.removeAllAggregation("items")};c.prototype.setAddButton=function(t){return this._getTabStrip().setAddButton(t)};c.prototype.getAddButton=function(){return this._getTabStrip().getAddButton()};c.prototype.setShowAddNewButton=function(t){this.setProperty("showAddNewButton",t,true);if(m.system.phone){t?this.addStyleClass("sapUiShowAddNewButton"):this.removeStyleClass("sapUiShowAddNewButton")}var e=this._getTabStrip();if(e){e.setAddButton(t?this._getAddNewTabButton():null)}return this};c.prototype.setSelectedItem=function(t,e){if(this.fireItemSelect({item:t})){var i=this._getTabStrip();if(t&&i){i.setSelectedItem(this._toTabStripItem(t));this._rerenderContent(t.getContent())}this.setAssociation("selectedItem",t,true);return this}if(e){e.preventDefault()}return this};c.prototype._setupTabStripItem=function(t){var e=t._getTabStripItem();if(e){e.setKey(t.getId());e.setText(t.getName());e.setAdditionalText(t.getAdditionalText());e.setIcon(t.getIcon());e.setIconTooltip(t.getIconTooltip());e.setModified(t.getModified());e.setTooltip(t.getTooltip())}return e};c.prototype._rerenderContent=function(t){var e=this.$("content"),i;if(!t||e.length<=0){return}i=(new n).getInterface();for(var r=0;r<t.length;r++){i.renderControl(t[r])}i.flush(e[0]);i.destroy()};c.prototype._setDefaultTab=function(){var t=this.getItems()[0]||null;this.setSelectedItem(t);return t};["addCustomData","getCustomData","destroyCustomData","indexOfCustomData","insertCustomData","removeAllCustomData","removeCustomData","data"].forEach(function(t){c.prototype[t]=function(){var e=this._getTabStrip();if(e&&e[t]){var i=e[t].apply(e,arguments);return i===e?this:i}}});return c});
//# sourceMappingURL=TabContainer.js.map