/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./library","sap/base/i18n/Localization","sap/ui/core/Control","sap/ui/core/library","sap/ui/Device","sap/m/HyphenationSupport","./TextRenderer"],function(e,t,i,r,n,o,a){"use strict";var p=r.TextAlign;var s=r.TextDirection;var l=e.WrappingType;var u=e.EmptyIndicatorMode;var g=i.extend("sap.m.Text",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.ui.core.IFormContent","sap.ui.core.ISemanticFormContent","sap.m.IHyphenation","sap.m.IToolbarInteractiveControl","sap.ui.core.ILabelable"],library:"sap.m",properties:{text:{type:"string",group:"Data",defaultValue:"",bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:s.Inherit},wrapping:{type:"boolean",group:"Appearance",defaultValue:true},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:l.Normal},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:p.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxLines:{type:"int",group:"Appearance",defaultValue:null},renderWhitespace:{type:"boolean",group:"Appearance",defaultValue:false},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:u.Off}},designtime:"sap/m/designtime/Text.designtime"},renderer:a});g.prototype.normalLineHeight=1.2;g.prototype.cacheLineHeight=true;g.prototype.ellipsis="...";g.hasNativeLineClamp="webkitLineClamp"in document.documentElement.style;g.setNodeValue=function(e,t){t=t||"";var i=e.childNodes;if(i.length===1&&i[0].nodeType===window.Node.TEXT_NODE){i[0].nodeValue=t}else{e.textContent=t}};g.prototype.getText=function(e){var t=this.getProperty("text");if(e){return t.replace(/\r\n|\n\r|\r/g,"\n")}return t};g.prototype.hasMaxLines=function(){return this.getWrapping()&&this.getMaxLines()>1};g.prototype.getTextDomRef=function(){if(!this.getVisible()){return null}if(this.hasMaxLines()){return this.getDomRef("inner")}return this.getDomRef()};g.prototype.canUseNativeLineClamp=function(){if(!g.hasNativeLineClamp){return false}if(this.getTextDirection()==s.RTL){return false}if(this.getTextDirection()==s.Inherit&&t.getRTL()){return false}return true};g.prototype.getLineHeight=function(e){if(this.cacheLineHeight&&this._fLineHeight){return this._fLineHeight}e=e||this.getTextDomRef();if(!e){return 0}var t=window.getComputedStyle(e),i=t.lineHeight,r;if(/px$/i.test(i)){r=parseFloat(i)}else if(/^normal$/i.test(i)){r=parseFloat(t.fontSize)*this.normalLineHeight}else{r=parseFloat(t.fontSize)*parseFloat(i)}if(!n.browser.firefox){r=Math.floor(r)}if(this.cacheLineHeight&&r){this._fLineHeight=r}return r};g.prototype.getClampHeight=function(e){e=e||this.getTextDomRef();return this.getMaxLines()*this.getLineHeight(e)};g.prototype.clampHeight=function(e){e=e||this.getTextDomRef();if(!e){return 0}var t=this.getClampHeight(e);if(t){e.style.maxHeight=t+"px"}return t};g.prototype.clampText=function(e,t,i){e=e||this.getTextDomRef();if(!e){return}var r;var n=this.getText(true);var o=this.getClampHeight(e);t=t||0;i=i||n.length;g.setNodeValue(e,n.slice(0,i));if(e.scrollHeight>o){var a=e.style,p=a.height,s=this.ellipsis,l=s.length;a.height=o+"px";while(i-t>l){r=t+i>>1;g.setNodeValue(e,n.slice(0,r-l)+s);if(e.scrollHeight>o){i=r}else{t=r}}if(e.scrollHeight>o&&t>0){r=t;e.textContent=n.slice(0,r-l)+s}a.height=p}return r};g.prototype.getAccessibilityInfo=function(){return{description:this.getText()}};g.prototype._getToolbarInteractive=function(){return false};g.prototype.getTextsToBeHyphenated=function(){return{main:this.getText(true)}};g.prototype.getDomRefsForHyphenatedTexts=function(){return{main:this.getTextDomRef()}};g.prototype.getFormFormattedValue=function(){return this.getText()};g.prototype.getFormValueProperty=function(){return"text"};g.prototype.getFormObservingProperties=function(){return["text"]};g.prototype.getFormRenderAsControl=function(){return true};g.prototype.hasLabelableHTMLElement=function(){return false};o.mixInto(g.prototype);return g});
//# sourceMappingURL=Text.js.map