/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/base/i18n/Localization","sap/ui/core/library","sap/ui/core/Control","./TileContentRenderer","sap/ui/core/Lib","sap/m/Button"],function(t,e,i,r,a,n,o){"use strict";var s=t.Priority;var l=t.LoadState;var p=t.GenericTileMode;var g=t.ButtonType;var u=r.extend("sap.m.TileContent",{metadata:{library:"sap.m",properties:{footer:{type:"string",group:"Appearance",defaultValue:null},footerColor:{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},size:{type:"sap.m.Size",group:"Appearance",defaultValue:"Auto",deprecated:true},unit:{type:"string",group:"Data",defaultValue:null},disabled:{type:"boolean",group:"Behavior",defaultValue:false},frameType:{type:"sap.m.FrameType",group:"Appearance",defaultValue:"Auto"},priority:{type:"sap.m.Priority",group:"Misc",defaultValue:s.None},priorityText:{type:"string",group:"Misc",defaultValue:null},state:{type:"sap.m.LoadState",group:"Misc",defaultValue:l.Loaded}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false,bindable:"bindable"}}},renderer:a});u.prototype.init=function(){this._bRenderFooter=true;this._bRenderContent=true;this._bStateSetManually=false};u.prototype.onBeforeRendering=function(){var t=this.mProperties.hasOwnProperty("state");if(t&&!this._bStateSetManually){if(this.getParent()&&this.getParent().isA("sap.m.GenericTile")){if(this.getParent().getState()===l.Failed){this.setState(l.Loaded)}else if(this.getParent().getState()===l.Disabled){this.setState(l.Loaded);this.setDisabled(this.getState()===l.Disabled)}}}else{if(this.getParent()&&this.getParent().isA("sap.m.GenericTile")){if(this.getParent().getState()===l.Failed){this.setState(l.Loaded)}else if(this.getParent().getState()===l.Disabled){this.setState(l.Loaded);this.setDisabled(this.getState()===l.Disabled)}else{this.setState(this.getParent().getState())}}this._bStateSetManually=true}if(this.getContent()&&this._oDelegate){if(this.getDisabled()){this.getContent().addDelegate(this._oDelegate)}else{this.getContent().removeDelegate(this._oDelegate)}}};u.prototype.onAfterRendering=function(){var t=this.getContent();if(t){const o=this.getParent();if(o&&o.isA("sap.m.GenericTile")){o._applyCssStyle(this)}var e=this.$();var i=e.find("*");var r=e.attr("title")||"";var a=t.getTooltip_AsString()||"";if(r===a){r=""}var n="";i.toArray().forEach(function(t){if(t.title){n=n.concat(t.title+" ")}});if(n.trim()!==0){a=a+" "+n}if(a&&a.trim().length!==0){if(this._getFooterText().trim()!==0){a=a+"\n"+this._getFooterText()}r.trim().length!==0?e.attr("title",r+"\n"+a):e.attr("title",a)}if(this.getParent()&&this.getParent().isA("sap.m.ActionTile")&&this.getContent().isA("sap.m.FormattedText")&&this.getContent().getDomRef()){this._applyStyleClassesOnContent(this.getContent().getDomRef())}i.removeAttr("title").off("mouseenter")}};u.prototype._getContentType=function(){if(this.getContent()){var t=this.getContent().getMetadata().getName();if(t==="sap.m.NewsContent"||t==="sap.suite.ui.commons.NewsContent"){return"News"}}};u.prototype._getFooterText=function(){var t=n.getResourceBundleFor("sap.m");var i=this.getFooter();var r=this.getUnit();if(r){if(i){if(e.getRTL()){return t.getText("TILECONTENT_FOOTER_TEXT",[i,r])}else{return t.getText("TILECONTENT_FOOTER_TEXT",[r,i])}}else{return r}}else{return i}};u.prototype.getAltText=function(){var t="";var e=true;var i=this.getContent();var r=this.getParent();var a=this.getPriorityText();if(a&&this.getPriority()!==s.None){t+=a;e=false}if(i&&i.getVisible()){var n=i.getDomRef();if(i.getAltText){t+=i.getAltText();e=false}else if(i.getTooltip_AsString()){t+=i.getTooltip_AsString();e=false}else if(r&&r.isA("sap.m.ActionTile")&&n){t+=(e?"":"\n")+this._getInnerText(n);e=false}else if(r&&r.isA("sap.m.GenericTile")&&r.getMode()===p.ActionMode){if(i.isA("sap.m.Text")){t+=(e?"":"\n")+i.getText();e=false}else if(n&&i.isA("sap.m.FormattedText")){t+=(e?"":"\n")+n.innerText;e=false}}}if(this.getUnit()){t+=(e?"":"\n")+this.getUnit();e=false}if(this.getFooter()){t+=(e?"":"\n")+this.getFooter()}return t};u.prototype._getInnerText=function(t){var e="";var i=[].slice.call(t.children);i.forEach(function(t,i){e+=t.innerText+"\n"});return e.trim()};u.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var e="";if(typeof t==="string"||t instanceof String){return t}e=this.getAltText();return e?e:""};u.prototype.setRenderFooter=function(t){this._bRenderFooter=t;return this};u.prototype.setRenderContent=function(t){this._bRenderContent=t;return this};u.prototype._applyStyleClassesOnContent=function(t){var e=this._filterElements(t.childNodes);e.forEach(function(t){var e=t.tagName==="P"&&t.innerHTML.includes("br");if(e){t.classList.add("sapMbrPresent")}})};u.prototype._filterElements=function(t){return[].slice.call(t).filter(function(t){return t.nodeType===1})};u.prototype.setPriority=function(t){var e=this._getPriorityBadge();e?.setType(this._getPriorityButtonType(t));e?.setIcon(this._getPriorityBadgeIcon(t));this.setProperty("priority",t);return this};u.prototype.setPriorityText=function(t){var e=this._getPriorityBadge();e?.setText(t);e?.setTooltip(t);this.setProperty("priorityText",t);return this};u.prototype._getPriorityButtonType=function(t){switch(t){case s.VeryHigh:case s.High:return g.Reject;case s.Medium:return g.Attention;default:return g.Default}};u.prototype._getPriorityBadgeIcon=function(t){switch(t){case s.VeryHigh:case s.High:return"sap-icon://alert";case s.Medium:return"sap-icon://high-priority";default:return"sap-icon://information"}};u.prototype._getPriorityBadge=function(){var t=this.getPriority();var e=this.getPriorityText();if(t&&t!==s.None&&e){if(!this._priorityBadge){this._priorityBadge=new o(this.getId()+"-priority",{type:this._getPriorityButtonType(t),icon:this._getPriorityBadgeIcon(t),text:e,tooltip:e,width:"auto"}).addStyleClass("sapUiSizeCompact sapMGTPriorityBadge");this._priorityBadge._bExcludeFromTabChain=true;this.addDependent(this._priorityBadge)}return this._priorityBadge}};return u});
//# sourceMappingURL=TileContent.js.map