/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Configuration","./TimePickerClockRenderer","sap/ui/Device","sap/ui/core/ControlBehavior","sap/ui/thirdparty/jquery"],function(e,t,i,s,o,jQuery){"use strict";var a=1e3;var n=e.extend("sap.m.TimePickerClock",{metadata:{library:"sap.m",properties:{enabled:{type:"boolean",group:"Misc",defaultValue:true},itemMin:{type:"int",group:"Data",defaultValue:-1},itemMax:{type:"int",group:"Data",defaultValue:-1},label:{type:"string",group:"Appearance",defaultValue:null},fractions:{type:"boolean",group:"Appearance",defaultValue:true},lastItemReplacement:{type:"int",group:"Data",defaultValue:-1},prependZero:{type:"boolean",group:"Appearance",defaultValue:false},selectedValue:{type:"int",group:"Data",defaultValue:-1},hoveredValue:{type:"int",group:"Data",defaultValue:-1},displayStep:{type:"int",group:"Data",defaultValue:5},valueStep:{type:"int",group:"Data",defaultValue:1},support2400:{type:"boolean",group:"Misc",defaultValue:false},skipAnimation:{type:"boolean",group:"Misc",defaultValue:false},fadeIn:{type:"boolean",group:"Misc",defaultValue:false},fadeOut:{type:"boolean",group:"Misc",defaultValue:false}},events:{change:{parameters:{value:{type:"int"},stringValue:{type:"string"},finalChange:{type:"boolean"}}}}},renderer:i});n.prototype.init=function(){this._onMouseWheel=this._onMouseWheel.bind(this);this._bFinalChange=false};n.prototype.onBeforeRendering=function(){var e=this.getDomRef();if(e){this._bFocused=e.contains(document.activeElement);this._detachEvents()}if(this.getSupport2400()&&this._get24HoursVisible()===undefined){this._save2400State()}};n.prototype.onAfterRendering=function(){this._attachEvents()};n.prototype.exit=function(){this._detachEvents()};n.prototype.onThemeChanged=function(e){this.invalidate()};n.prototype.setSelectedValue=function(e){var t=this.getLastItemReplacement(),i=this.getItemMax();if(!this.getSupport2400()){if(e===0){e=i}if(e===i&&t!==-1){e=t}}this.setProperty("selectedValue",e);this.fireChange({value:e,stringValue:this._getStringValue(e),finalChange:this._bFinalChange});this._bFinalChange=false;return this};n.prototype.getSelectedValue=function(){var e=this.getProperty("selectedValue"),t=this.getLastItemReplacement();if(this.getSupport2400()&&this._get24HoursVisible()&&e===this.getItemMax()&&t!==-1){e=t}return parseInt(e)};n.prototype._getStringValue=function(e){var t=e.toString();if(this.getPrependZero()){t=t.padStart(2,"0")}return t};n.prototype._save2400State=function(){this._set24HoursVisible(this.getSupport2400()&&this.getSelectedValue()===0?false:true)};n.prototype._set24HoursVisible=function(e){if(this.getSupport2400()){this._is24HoursVisible=e;this.setLastItemReplacement(e?24:0)}else{this._is24HoursVisible=false}};n.prototype._get24HoursVisible=function(){return this.getSupport2400()?this._is24HoursVisible:false};n.prototype._markToggleAsSelected=function(e){this._selectToggledElement=e;return this};n.prototype._attachEvents=function(){var e=this._getClockCoverContainerDomRef();this.$().on(s.browser.firefox?"DOMMouseScroll":"mousewheel",this._onMouseWheel);document.addEventListener("mouseup",jQuery.proxy(this._onMouseOutUp,this),false);if(e){if(s.system.combi||s.system.phone||s.system.tablet){e.addEventListener("touchstart",jQuery.proxy(this._onTouchStart,this),false);e.addEventListener("touchmove",jQuery.proxy(this._onTouchMove,this),false);e.addEventListener("touchend",jQuery.proxy(this._onTouchEnd,this),false)}if(s.system.desktop||s.system.combi){e.addEventListener("mousedown",jQuery.proxy(this._onTouchStart,this),false);e.addEventListener("mousemove",jQuery.proxy(this._onTouchMove,this),false);e.addEventListener("mouseup",jQuery.proxy(this._onTouchEnd,this),false);e.addEventListener("mouseout",jQuery.proxy(this._onMouseOut,this),false)}}};n.prototype._detachEvents=function(){var e=this._getClockCoverContainerDomRef();this.$().off(s.browser.firefox?"DOMMouseScroll":"mousewheel",this._onMouseWheel);document.removeEventListener("mouseup",jQuery.proxy(this._onMouseOutUp,this),false);if(e){if(s.system.combi||s.system.phone||s.system.tablet){e.removeEventListener("touchstart",jQuery.proxy(this._onTouchStart,this),false);e.removeEventListener("touchmove",jQuery.proxy(this._onTouchMove,this),false);e.removeEventListener("touchend",jQuery.proxy(this._onTouchEnd,this),false)}if(s.system.desktop||s.system.combi){e.removeEventListener("mousedown",jQuery.proxy(this._onTouchStart,this),false);e.removeEventListener("mousemove",jQuery.proxy(this._onTouchMove,this),false);e.removeEventListener("mouseup",jQuery.proxy(this._onTouchEnd,this),false);e.removeEventListener("mouseout",jQuery.proxy(this._onMouseOut,this),false)}}};n.prototype._getClockCoverContainerDomRef=function(){return this.getDomRef("cover")};n.prototype._onMouseOutUp=function(e){this._mouseOrTouchDown=false};n.prototype._onMouseOut=function(e){this.setHoveredValue(-1)};n.prototype.modifyValue=function(e){var t=this.getSelectedValue(),i=this.getLastItemReplacement(),s=this.getItemMin(),o=this.getItemMax(),a=this.getValueStep(),n;if(t%a!==0){n=e?Math.ceil(t/a)*a:Math.floor(t/a)*a;a=Math.abs(t-n)}if(this.getSupport2400()&&!this._get24HoursVisible()){s=0;o=23;i=-1}if(t===i){t=o}if(e){t+=a;if(t>o){t=this.getSupport2400()?s:t-o}}else{t-=a;if(t<s){t=o}}this.setSelectedValue(t)};n.prototype._onMouseWheel=function(e){var t=e.originalEvent,i=t.detail?-t.detail>0:t.wheelDelta>0;e.preventDefault();if(!this._mouseOrTouchDown){this.modifyValue(i)}};n.prototype._onTouchStart=function(e){this._cancelTouchOut=false;if(!this.getEnabled()||e.type==="mousedown"&&e.button!==0||this.getFadeOut()){return}this._iMovSelectedValue=this.getSelectedValue();this._calculateDimensions();this._x=e.type==="touchstart"?e.touches[0].pageX:e.pageX;this._y=e.type==="touchstart"?e.touches[0].pageY:e.pageY;this._calculatePosition(this._x,this._y);if(this.getSupport2400()&&e.type==="touchstart"&&(this._iSelectedValue===24||this._iSelectedValue===0)){this._resetLongTouch();this._startLongTouch()}this._mouseOrTouchDown=true};n.prototype._onTouchMove=function(e){if(this.getFadeOut()){return}e.preventDefault();if(this._mouseOrTouchDown){this._x=e.type==="touchmove"?e.touches[0].pageX:e.pageX;this._y=e.type==="touchmove"?e.touches[0].pageY:e.pageY;this._calculatePosition(this._x,this._y);if(this.getEnabled()&&this._iSelectedValue!==-1&&this._iSelectedValue!==this._iMovSelectedValue){this.setSelectedValue(this._iSelectedValue);this._iMovSelectedValue=this._iSelectedValue;if(this.getSupport2400()&&e.type==="touchmove"&&(this._iSelectedValue===24||this._iSelectedValue===0)){this._resetLongTouch();this._startLongTouch()}}}else if(e.type==="mousemove"){if(!this._dimensionParameters){this._calculateDimensions()}this._x=e.pageX;this._y=e.pageY;this._calculatePosition(this._x,this._y)}};n.prototype._onTouchEnd=function(e){if(!this._mouseOrTouchDown||this.getFadeOut()){return}this._mouseOrTouchDown=false;e.preventDefault();if(!this.getEnabled()||this._iSelectedValue===-1){return}if(e.type==="touchend"){this._resetLongTouch()}if(!this._cancelTouchOut){this._bFinalChange=true;this.setSelectedValue(this._iSelectedValue)}};n.prototype._resetLongTouch=function(){if(this._longTouchId){clearTimeout(this._longTouchId)}};n.prototype._startLongTouch=function(){this._longTouchId=setTimeout(function(){var e=this._iSelectedValue;this._longTouchId=null;if(e===0||e===24){this._toggle2400()}}.bind(this),a)};n.prototype._toggle2400=function(e){var t=this._get24HoursVisible(),i=t?0:24;this._cancelTouchOut=true;this._set24HoursVisible(!t);this.setLastItemReplacement(i);if(!e){this._iMovSelectedValue=i;this.setSelectedValue(i)}return this};n.prototype._getItemsCount=function(e){return this.getItemMax()-this.getItemMin()+1};n.prototype._getAngleStep=function(e){const t=this._getItemsCount();return t===12?6:360/this._getItemsCount()};n.prototype._calculateDimensions=function(){const e=this._getClockCoverContainerDomRef();if(!e){return}const t=window.pageXOffset||document.documentElement.scrollLeft,i=window.pageYOffset||document.documentElement.scrollTop,s=Math.round(e.offsetHeight/2),o=jQuery(".sapMTPCDot").first().outerHeight(true),a=jQuery(".sapMTPCNumber").first().outerHeight(true),n=e.getBoundingClientRect();this._dimensionParameters={radius:s,centerX:s,centerY:s,dotHeight:o,numberHeight:a,radiusMax:s,radiusMin:s-a*1.6-1,offsetX:n.left+t,offsetY:n.top+i}};n.prototype._calculatePosition=function(e,t){var i=this.getItemMax(),s=this.getLastItemReplacement(),o=this.getValueStep(),a=e-this._dimensionParameters.offsetX+1-this._dimensionParameters.radius,n=t-this._dimensionParameters.offsetY+1-this._dimensionParameters.radius,u=a>=0?0:180,r=Math.atan(n/a)*180/Math.PI+90+u,h=this._getAngleStep(true),l=Math.sqrt(a*a+n*n),p=Math.round((r===0?360:r)/h/o)*h*o,c=l<=this._dimensionParameters.radiusMax&&l>this._dimensionParameters.radiusMin,f=360/this._getItemsCount()/h,d=this.getSupport2400(),_=this._get24HoursVisible();if(p===0){p=360}if(c){this._iSelectedValue=Math.round(p/h/f/o)*o;if(this._iSelectedValue===0&&s===-1){this._iSelectedValue=i}if(d&&!_&&this._iSelectedValue===24){this._iSelectedValue=0}}else{this._iSelectedValue=-1}if(this._iSelectedValue===i&&s!==-1){this._iSelectedValue=s}this.setHoveredValue(c?this._iSelectedValue:-1)};n.prototype._setEnabled=function(e){this.setEnabled(e);if(e){this.$().removeClass("sapMTPDisabled")}else{this.$().addClass("sapMTPDisabled")}return this};return n});
//# sourceMappingURL=TimePickerClock.js.map