/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./TimePickerInternals","./TimePickerClock","./ToggleButton","./SegmentedButton","./SegmentedButtonItem","./TimePickerClocksRenderer","./ToggleButtonRenderer","sap/ui/core/Renderer","sap/ui/events/KeyCodes","sap/ui/Device","sap/ui/core/library","sap/ui/thirdparty/jquery","sap/ui/core/date/UI5Date"],function(t,e,s,i,n,o,a,l,r,c,u,jQuery,h){"use strict";var g=1e3;var d=u.TextDirection;var _=t.extend("sap.m.TimePickerClocks",{metadata:{properties:{skipAnimation:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{_buttons:{type:"sap.m.internal.ToggleSpinButton",multiple:true,visibility:"hidden"},_clocks:{type:"sap.m.TimePickerClock",multiple:true,visibility:"hidden"}}},renderer:o});var p=l.extend(a);p.apiVersion=2;p.render=function(t,e){var s=e.getId(),i=e.getType(),n=e.getEnabled(),o=e.getWidth(),a=e._getTooltip(),l=e._getText(),r=e.getTextDirection(),u=c.browser.internet_explorer||c.browser.edge,h=r===d.Inherit&&!u;t.openStart("div",e);t.class("sapMBtnBase");t.class("sapMBtn");var g=this.generateAccProps(e);g["pressed"]=null;g["valuemin"]=e.getMin();g["valuemax"]=e.getMax();g["valuenow"]=parseInt(e.getText());g["label"]=a;g["valuetext"]=parseInt(e.getText()).toString()+" "+a;g["role"]="spinbutton";t.accessibilityState(e,g);if(!n){t.attr("disabled","disabled");t.class("sapMBtnDisabled")}if(o!=""||o.toLowerCase()==="auto"){t.style("width",o);t.style("min-width","2.25rem")}if(a){t.attr("title",a)}t.attr("tabindex","0");t.openEnd();t.openStart("span",s+"-inner");t.class("sapMBtnInner");if(e._isHoverable()){t.class("sapMBtnHoverable")}if(n){t.class("sapMFocusable");if(u){t.class("sapMIE")}}if(l){t.class("sapMBtnText")}if(e.getPressed()){t.class("sapMToggleBtnPressed")}if(i!==""){t.class("sapMBtn"+i)}t.openEnd();if(l){t.openStart("span",s+"-content");t.class("sapMBtnContent");if(r!==d.Inherit){t.attr("dir",r.toLowerCase())}t.openEnd();if(h){t.openStart("bdi",s+"-BDI-content");t.openEnd()}t.text(l);if(h){t.close("bdi")}t.close("span")}if(u&&n){t.openStart("span");t.class("sapMBtnFocusDiv");t.openEnd();t.close("span")}t.close("span");if(a){t.openStart("span",s+"-tooltip");t.class("sapUiInvisibleText");t.openEnd();t.text(a);t.close("span")}t.close("div")};var f=s.extend("sap.m.internal.ToggleSpinButton",{metadata:{library:"sap.m",properties:{label:{type:"string",defaultValue:""},min:{type:"int",defaultValue:0},max:{type:"int",defaultValue:0}}},renderer:p});_.prototype.init=function(){t.prototype.init.apply(this,arguments)};_.prototype.onAfterRendering=function(){if(!this._clickAttached){this._attachClickEvent()}this._clockConstraints=this._getClocksConstraints()};_.prototype.onkeyup=function(t){var e=t.which||t.keyCode;if(e===r.CONTROL){t.preventDefault();if(this._clockIndexes.H===this._getActiveClockIndex()&&this.getSupport2400()&&this._ctrlKeyDown===1){this._getActiveClock()._toggle2400(true)._markToggleAsSelected(false)}this._ctrlKeyDown=0}else if(e===r.SPACE){this._spaceKeyDown=false}};_.prototype.onkeydown=function(t){var e=t.which||t.keyCode,s=t.key,i=this.getAggregation("_clocks"),n=this._getActiveClock(),o=this._getActiveClockIndex(),a=this.getSupport2400(),l=["0","1","2","3","4","5","6","7","8","9",":"],c,u,h,g="",d,_,p,f=0,k=-1,m=t.srcControl&&t.srcControl.getMetadata().getName().indexOf("ToggleSpinButton")===-1?false:true;if(this._clockIndexes.H===o&&a&&e===r.CONTROL&&!this._ctrlKeyDown){t.preventDefault();this._ctrlKeyDown=1;n._toggle2400(true)._markToggleAsSelected(true)}else if(e===r.ENTER){if(!m){return}if(typeof this._parentAcceptCallback==="function"){this._parentAcceptCallback()}}else if((e===r.ARROW_UP||e===r.ARROW_DOWN)&&!t.altKey&&!t.metaKey){n&&n.getEnabled()&&n.modifyValue(e===r.ARROW_UP);t.preventDefault()}else if((e===r.PAGE_UP||e===r.PAGE_DOWN)&&!t.altKey&&!t.metaKey){t.preventDefault();if(!t.shiftKey&&!t.ctrlKey){n=this._getHoursClock()}else if(t.shiftKey&&!t.ctrlKey){n=this._getMinutesClock()}else{n=this._getSecondsClock()}n&&n.getEnabled()&&n.modifyValue(e===r.PAGE_UP);n&&this._switchClock(this._getClockIndex(n),true)}else if(e===r.P||e===r.A){t.preventDefault();c=this._getFormatButton();c&&c.setSelectedKey(e===r.P?"pm":"am")}else if(e===r.SPACE&&!this._spaceKeyDown){if(!m){return}t.preventDefault();this._spaceKeyDown=true;h=n.getSelectedValue();u=n._get24HoursVisible()?24:0;if(this._clockIndexes.H===o&&a&&h!==u&&(h===24||h===0)){n.setSelectedValue(u)}this._kbdBuffer="";this._resetCooldown(true);setTimeout(function(){this._switchNextClock(true,true)}.bind(this),0)}else if(l.indexOf(s)!==-1){this._exactMatch=null;this._resetCooldown(true);if(s===":"){this._kbdBuffer="";this._resetCooldown(true);this._switchNextClock(true,true)}else if(this._clockConstraints[o]){g=this._kbdBuffer+s;d=parseInt(g);if(this._clockConstraints[o].step===1){if(d>this._clockConstraints[o].max){i[o].setSelectedValue(parseInt(this._kbdBuffer));this._switchNextClock(false,true);this._kbdBuffer=s;o=this._getActiveClockIndex();i[o].setSelectedValue(parseInt(s));this._resetCooldown(true)}else{this._kbdBuffer=g;i[o].setSelectedValue(parseInt(this._kbdBuffer));if(this._kbdBuffer.length===2||parseInt(this._kbdBuffer+"0")>this._clockConstraints[o].max){this._resetCooldown(this._kbdBuffer.length===2?false:true);this._kbdBuffer="";this._switchNextClock(false,true)}}}else{for(_=this._clockConstraints[o].min;_<=this._clockConstraints[o].max;_++){if(_%this._clockConstraints[o].step===0){p=_.toString();if(g===p.substr(0,g.length)||d===_){f++;k=f===1?_:-1;if(d===_){this._exactMatch=_}}}}if(f===1){i[o].setSelectedValue(k);this._exactMatch=null;this._kbdBuffer="";this._resetCooldown(true);this._switchNextClock(false,true)}else if(g.length===2){this._exactMatch=null;this._kbdBuffer="";this._resetCooldown(true)}else{this._kbdBuffer=g}}}}};_.prototype.setValue=function(e){var s=this._getHoursClock(),i=this._getValueFormatPattern(),n=i.indexOf("HH"),o=i.indexOf("H"),a=s&&s.getSelectedValue()===24,l=t._isHoursValue24(e,n,o),r;if(a&&this._isFormatSupport24()&&!l){e=t._replaceZeroHoursWith24(e,n,o)}e=this.validateProperty("value",e);this.setProperty("value",e,true);if(e){r=this._parseValue(l?t._replace24HoursWithZero(e,n,o):e)}if(r){this._setTimeValues(r,l)}return this};_.prototype.getTimeValues=function(){var t=this._getHoursClock(),e=this._getMinutesClock(),s=this._getSecondsClock(),i=this._getFormatButton(),n=null,o=null,a=h.getInstance();if(t){n=parseInt(t.getSelectedValue())}if(i){o=i.getSelectedKey()}if(o==="am"&&n===12){n=0}else if(o==="pm"&&n!==12){n+=12}if(n!==null){a.setHours(n.toString())}if(e){a.setMinutes(e.getSelectedValue())}if(s){a.setSeconds(s.getSelectedValue())}return a};_.prototype.prepareForOpen=function(){const t=this.getAggregation("_clocks"),e=this.getAggregation("_buttons");this.setSkipAnimation(true);if(t.length){this._activeClock=0;t.forEach((t,s)=>{t.setSkipAnimation(s===0).setFadeOut(false).setFadeIn(s===0);e[s].setPressed(s===0)})}return this};_.prototype._attachClickEvent=function(){var t=this.getDomRef();t.addEventListener("click",jQuery.proxy(this._focusActiveButton,this),false);this._clickAttached=true};_.prototype._focusActiveButton=function(){var t=this.getAggregation("_buttons"),e=this._getActiveClockIndex();t&&t[e]&&t[e].focus()};_.prototype._showFirstClock=function(){var t=this.getAggregation("_buttons"),e=0;if(t&&t[e]){t[e].setPressed(true);this._switchClock(e,true);t[e].focus();this._activeClock=e}};_.prototype._setAcceptCallback=function(t){this._parentAcceptCallback=t};_.prototype._resetCooldown=function(t){if(g===0){return}if(this._typeCooldownId){clearTimeout(this._typeCooldownId)}if(t){this._startCooldown()}};_.prototype._startCooldown=function(){if(g===0){return}this._typeCooldownId=setTimeout(function(){this._kbdBuffer="";this._typeCooldownId=null;if(this._exactMatch){this._getActiveClock().setSelectedValue(this._exactMatch);this._exactMatch=null}}.bind(this),g)};_.prototype._switchNextClock=function(t,e){let s=this._getActiveClockIndex();const i=this.getAggregation("_clocks"),n=i.length,o=this._getActiveClock(),a=s;if(!i){return}if(this._clockIndexes.H===s&&this.getSupport2400()){o._save2400State();if(o.getSelectedValue()===24){return}}do{s++;if(s>=n){s=t?0:n-1}}while(!o.getEnabled()&&s!==a&&(t||s<n-1));this._ctrlKeyDown=0;if(s!==a&&i[s].getEnabled()){this._switchClock(s,e)}};_.prototype._getClocksConstraints=function(){var t=this.getAggregation("_clocks"),e=this.getSupport2400(),s=[],i,n,o,a,l;if(t){for(l=0;l<t.length;l++){i=t[l].getItemMin();n=t[l].getItemMax();o=t[l].getValueStep();a=t[l].getLastItemReplacement();if(a!==-1&&a<i){i=a;if(n!==24||!e){n--}}else if(n===24&&e){i=0}s[l]={min:i,max:n,step:o,prependZero:t[l].getPrependZero()}}}return s};_.prototype._getActiveClockIndex=function(){return this._activeClock||0};_.prototype._getActiveClock=function(){var t=this._getActiveClockIndex(),e=this.getAggregation("_clocks");return e&&e[t]?e[t]:null};_.prototype._setTimeValues=function(t,e){var s=this._getHoursClock(),i=this._getMinutesClock(),n=this._getSecondsClock(),o=this._getMinutesButton(),a=this._getSecondsButton(),l=this._getFormatButton(),r=this.getValueFormat(),c,u=null,g=!this._isFormatSupport24()&&r.indexOf("B")!==-1,d=r.indexOf("a")!==-1||r==="";t=t||h.getInstance();if(Object.prototype.toString.call(t)!=="[object Date]"||isNaN(t)){throw new Error("Date must be a JavaScript or UI5Date date object; "+this)}if(!e){var _=this._formatValue(t,true);this.setProperty("value",_,true);c=t.getHours()}else{c=24}if((d||g)&&l){u=c>=12?"pm":"am";c=c>12?c-12:c;c=c===0?12:c;l&&l.setSelectedKey(u)}s&&s.setSelectedValue(c);i&&i.setSelectedValue(t.getMinutes());n&&n.setSelectedValue(t.getSeconds());s&&this.getSupport2400()&&s._save2400State();if(e){i&&i.setSelectedValue(0).setEnabled(false);n&&n.setSelectedValue(0).setEnabled(false);o&&o.setEnabled(false);a&&a.setEnabled(false)}else{i&&i.setEnabled(true);n&&n.setEnabled(true);o&&o.setEnabled(true);a&&a.setEnabled(true)}};_.prototype._getHoursClock=function(){var t=this.getAggregation("_clocks");return t&&this._clockIndexes&&t[this._clockIndexes.H]?t[this._clockIndexes.H]:null};_.prototype._getMinutesClock=function(){var t=this.getAggregation("_clocks");return t&&this._clockIndexes&&t[this._clockIndexes.M]?t[this._clockIndexes.M]:null};_.prototype._getSecondsClock=function(){var t=this.getAggregation("_clocks");return t&&this._clockIndexes&&t[this._clockIndexes.S]?t[this._clockIndexes.S]:null};_.prototype._getHoursButton=function(){var t=this.getAggregation("_buttons");return t&&this._clockIndexes&&t[this._clockIndexes.H]?t[this._clockIndexes.H]:null};_.prototype._getMinutesButton=function(){var t=this.getAggregation("_buttons");return t&&this._clockIndexes&&t[this._clockIndexes.M]?t[this._clockIndexes.M]:null};_.prototype._getSecondsButton=function(){var t=this.getAggregation("_buttons");return t&&this._clockIndexes&&t[this._clockIndexes.S]?t[this._clockIndexes.S]:null};_.prototype._destroyControls=function(){this.destroyAggregation("_buttons");this.destroyAggregation("_clocks");this.destroyAggregation("_buttonAmPm")};_.prototype._createControls=function(){var s=this._getDisplayFormatPattern(),n=this.getId(),o=this._isFormatSupport24(),a=this.getSupport2400(),l=0,r=0,c=0,u="",h=-1,g,d,_,p,k,m=0,C,x,S,b=false,y,I,v={hours:this._oResourceBundle.getText("TIMEPICKER_LBL_HOURS"),minutes:this._oResourceBundle.getText("TIMEPICKER_LBL_MINUTES"),seconds:this._oResourceBundle.getText("TIMEPICKER_LBL_SECONDS"),ampm:this._oResourceBundle.getText("TIMEPICKER_AMPM_BUTTON_TOOLTIP")};this._clockIndexes={};if(s===undefined){return}g=s.indexOf("HH");d=s.indexOf("H");if(g!==-1){C=true;b=true;h=a?24:0;x=0;S=23}else if(d!==-1){C=true;h=a?24:0;x=0;S=23}else if(s.indexOf("hh")!==-1){C=true;b=true;x=1;S=12}else if(s.indexOf("h")!==-1){C=true;x=1;S=12}if(C){this.addAggregation("_clocks",new e(n+"-clockH",{label:v["hours"],selectedValue:l,itemMin:1,itemMax:o?24:12,valueStep:1,displayStep:o?2:1,fractions:o,lastItemReplacement:h,prependZero:b,support2400:a}));if(a){S++}this.addAggregation("_buttons",new f(n+"-btnH",{tooltip:v["hours"],min:x,max:S}));this._clockIndexes.H=m++}if(s.indexOf("m")!==-1){if(s.indexOf("mm")!==-1){h=0;b=true}else{h=0;b=false}this.addAggregation("_clocks",new e(n+"-clockM",{label:v["minutes"],selectedValue:r,itemMin:1,itemMax:60,valueStep:this.getMinutesStep(),lastItemReplacement:h,prependZero:b}));this.addAggregation("_buttons",new f(n+"-btnM",{tooltip:v["minutes"],min:0,max:59}));this._clockIndexes.M=m++}if(s.indexOf("s")!==-1){if(s.indexOf("ss")!==-1){h=0;b=true}else{h=0;b=false}this.addAggregation("_clocks",new e(n+"-clockS",{label:v["seconds"],selectedValue:c,itemMin:1,itemMax:60,valueStep:this.getSecondsStep(),lastItemReplacement:h,prependZero:b}));this.addAggregation("_buttons",new f(n+"-btnS",{tooltip:v["seconds"],min:0,max:59}));this._clockIndexes.S=m++}if(s.indexOf("a")!==-1||s.indexOf("B")!==-1&&!this._isFormatSupport24()){this.setAggregation("_buttonAmPm",new i(n+"-format",{items:[new sap.m.SegmentedButtonItem({text:this._sAM,key:"am"}),new sap.m.SegmentedButtonItem({text:this._sPM,key:"pm"})],selectedKey:u,tooltip:v["ampm"]}))}if(!this.getAggregation("_nowButton")){this.setAggregation("_nowButton",this._getCurrentTimeButton())}p=this.getAggregation("_buttons");k=this.getAggregation("_clocks");this._clockCount=k?k.length:0;if(this._clockCount){k[0].setSkipAnimation(this.getSkipAnimation()).setFadeIn(true)}for(m=0;m<this._clockCount;m++){this._attachEvents(k[m],p[m])}y=this.getValue();if(y){_=t._isHoursValue24(y,g,d);I=this._parseValue(_?t._replace24HoursWithZero(y,g,d):y);if(I){this._setTimeValues(I,_)}}};_.prototype._attachEvents=function(t,e){t.attachChange(function(t){var e=t.getParameter("value"),s=t.getParameter("finalChange"),i=t.getParameter("stringValue"),n=this.getAggregation("_buttons"),o=t.getParameter("id").slice(-1);n[this._clockIndexes[o]]&&n[this._clockIndexes[o]].setText(i);if(o==="H"){this._handleHoursChange(t)}if(!s){return}if(!this.getSupport2400()||e!==24){setTimeout(function(){this._switchNextClock(false)}.bind(this),0)}}.bind(this));e.attachPress(function(t){var e=t.getParameter("id").slice(-1),s=this.getAggregation("_clocks"),i=this.getAggregation("_buttons");if(s[this._clockIndexes[e]].getEnabled()){i[this._clockIndexes[e]].setPressed(true);this._switchClock(this._clockIndexes[e],this.getSkipAnimation())}}.bind(this));e.onfocusin=function(t){var e=t.target.id.slice(-1),s=this.getAggregation("_clocks");if(s[this._clockIndexes[e]].getEnabled()){this._switchClock(this._clockIndexes[e])}}.bind(this)};_.prototype._switchClock=function(t,e){if(this._activeClock===t){return}const s=this._getActiveClock(),i=this.getAggregation("_clocks")[t],n=this.getAggregation("_buttons");if(t!==this._activeClock){s._save2400State()}if(this.getSkipAnimation()&&t!==0&&this._activeClock===0&&i){s.setSkipAnimation(false);this.setSkipAnimation(false)}if(i&&e){s.setFadeIn(false);this._activeClock!==undefined&&n[this._activeClock].setPressed(false);i.setSkipAnimation(true).setFadeIn(true);this._activeClock=t;n[t].setPressed(true);n[t].focus()}else{s.getDomRef().querySelector(".sapMTPCItems .sapMTPCNumber").addEventListener("animationend",jQuery.proxy(this._swapClocks,this,this._activeClock,t),{once:true});s.setSkipAnimation(false).setFadeOut(true)}};_.prototype._swapClocks=function(t,e){const s=this.getAggregation("_clocks"),i=this.getAggregation("_buttons"),n=s[t],o=s[e],a=t!==undefined&&s[t];if(a){n.setFadeIn(false).setFadeOut(false).setSkipAnimation(false);i[t].setPressed(false)}this._activeClock=e;o.setFadeIn(true);i[e].setPressed(true);i[e].focus()};_.prototype._getClockIndex=function(t){return this._clockIndexes[t.getId().slice(-1)]};_.prototype._handleHoursChange=function(t){var e=parseInt(t.getParameter("value")),s=this._getMinutesClock(),i=this._getSecondsClock(),n=this._getMinutesButton(),o=this._getSecondsButton();if(!this.getSupport2400()){return}this._ctrlKeyDown=this._ctrlKeyDown?2:0;if(e===24){if(s&&s.getEnabled()){this._sMinutes=s.getSelectedValue();this._setControlValueAndEnabled(s,n,0,false)}if(i&&i.getEnabled()){this._sSeconds=i.getSelectedValue();this._setControlValueAndEnabled(i,o,0,false)}}else{if(s&&!s.getEnabled()){this._setControlValueAndEnabled(s,n,this._sMinutes,true)}if(i&&!i.getEnabled()){this._setControlValueAndEnabled(i,o,parseInt(this._sSeconds),true)}}this._getHoursButton().focus()};_.prototype._setControlValueAndEnabled=function(t,e,s,i){t.setSelectedValue(parseInt(s));t.setEnabled(i);e.setEnabled(i)};_.prototype._formatNumberToString=function(t,e,s,i){var n;if(e&&t<10){n=t.toString().padStart(2,"0")}else if(t===s&&i!==""){n=i}else{n=t.toString()}return n};return _});
//# sourceMappingURL=TimePickerClocks.js.map