/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/date/CalendarType","sap/ui/core/Lib","sap/ui/core/Control","sap/ui/model/type/Date","sap/ui/model/odata/type/ODataType","sap/ui/core/format/DateFormat","sap/ui/core/LocaleData","sap/ui/core/Locale","./library","./Button","sap/ui/core/date/UI5Date","./TimePickerInternalsRenderer"],function(t,e,r,o,n,i,s,a,u,p,l,c,y){"use strict";var g=1,h=p.ButtonType;var _=o.extend("sap.m.TimePickerInternals",{metadata:{library:"sap.m",properties:{localeId:{type:"string",group:"Data"},displayFormat:{type:"string",group:"Appearance"},minutesStep:{type:"int",group:"Misc",defaultValue:g},secondsStep:{type:"int",group:"Misc",defaultValue:g},value:{type:"string",group:"Data",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},support2400:{type:"boolean",group:"Misc",defaultValue:false},showCurrentTimeButton:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{_buttonAmPm:{type:"sap.m.SegmentedButton",multiple:false,visibility:"hidden"},_nowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}},renderer:y});_.prototype.init=function(){var e=new u(t.getLanguageTag()),o=a.getInstance(e),n=o.getDayPeriods("abbreviated"),i=o.getTimePattern("medium");this._oResourceBundle=r.getResourceBundleFor("sap.m");this._sAM=n[0];this._sPM=n[1];this._kbdBuffer="";this.setDisplayFormat(i);this._setTimeValues();this._sMinutes;this._sSeconds;this._clickAttached;this._setAriaLabel(this._oResourceBundle.getText("TIMEPICKER_CLOCK_DIAL_LABEL"));this._setAriaRoleDescription(this._oResourceBundle.getText("TIMEPICKER_INPUTS_ROLE_DESCRIPTION"))};_.prototype.exit=function(){this._destroyControls();this.destroyAggregation("_texts");if(this._oNowButton){this._oNowButton.destroy();this._oNowButton=null}};_.prototype.setDisplayFormat=function(t){this.setProperty("displayFormat",t,true);this._destroyControls();this._createControls();return this};_.prototype.setLocaleId=function(t){var e,r;t=this.validateProperty("localeId",t);this.setProperty("localeId",t,true);if(t){e=new u(t);r=a.getInstance(e).getDayPeriods("abbreviated");this._sAM=r[0];this._sPM=r[1];this._destroyControls();this._createControls()}return this};_.prototype.setSupport2400=function(t){this.setProperty("support2400",t,true);this._destroyControls();this._createControls();return this};_.prototype.setMinutesStep=function(t){this.setProperty("minutesStep",t,true);this._destroyControls();this._createControls();return this};_.prototype.setSecondsStep=function(t){this.setProperty("secondsStep",t,true);this._destroyControls();this._createControls();return this};_.prototype.setShowCurrentTimeButton=function(t){this._getCurrentTimeButton().setVisible(t);return this.setProperty("showCurrentTimeButton",t)};_.prototype._destroyControls=function(){};_.prototype._createControls=function(){};_.prototype._setTimeValues=function(t,e){};_.prototype._checkStyle=function(t){return t==="short"||t==="medium"||t==="long"||t==="full"};_.prototype._getDisplayFormatPattern=function(){var t=this.getDisplayFormat();if(this._checkStyle(t)){t=this._getLocaleBasedPattern(t)}return t};_.prototype._getValueFormatPattern=function(){var t=this._getBoundValueTypePattern()||this.getValueFormat()||"medium";if(this._checkStyle(t)){t=this._getLocaleBasedPattern(t)}return t};_.prototype._getLocaleBasedPattern=function(e){return a.getInstance(new u(t.getLanguageTag())).getTimePattern(e)};_.prototype._getFormatButton=function(){return this.getAggregation("_buttonAmPm")};_.prototype._parseValue=function(t){return this._getFormatter().parse(t)};_.prototype._getFormatter=function(){var r=this._getBoundValueTypePattern(),o=false,n=this.getBinding("value"),i;if(n&&n.oType&&n.oType.oOutputFormat){o=!!n.oType.oOutputFormat.oFormatOptions.relative;i=n.oType.oOutputFormat.oFormatOptions.calendarType}if(!r){r=this.getValueFormat()||"medium";i=e.Gregorian}if(!i){i=t.getCalendarType()}return this._getFormatterInstance(r,o,i)};_.prototype._getBoundValueTypePattern=function(){var t=this.getBinding("value"),e=t&&t.getType&&t.getType();if(e instanceof n){return e.getOutputPattern()}if(e instanceof i&&e.oFormat){return e.oFormat.oFormatOptions.pattern}return undefined};_.prototype._getFormatterInstance=function(t,e,r,o){var n;if(this._checkStyle(t)){n=this._getFormatInstance({style:t,strictParsing:true,relative:e,calendarType:r})}else{n=this._getFormatInstance({pattern:t,strictParsing:true,relative:e,calendarType:r})}return n};_.prototype._getFormatInstance=function(t,e){return s.getTimeInstance(t)};_.prototype._formatValue=function(t){if(t){return this._getFormatter().format(t)}return""};_.prototype._isFormatSupport24=function(){var t=this._getDisplayFormatPattern();return t.indexOf("HH")!==-1||t.indexOf("H")!==-1};_.prototype._formatNumberToString=function(t,e,r,o){var n;if(e&&t<10){n="0"+t}else if(t===r&&o!==""){n=o}else{n=t.toString()}return n};_.prototype._setAriaLabel=function(t){this._sAriaLabel=t;return this};_.prototype._getAriaLabel=function(){return this._sAriaLabel};_.prototype._setAriaRoleDescription=function(t){this._sAriaRoleDescription=t;return this};_.prototype._getAriaRoleDescription=function(){return this._sAriaRoleDescription};_._replaceZeroHoursWith24=function(t,e,r){var o=2,n=" ",i=e,s=t.charAt(r)===n,a=s?1:0;var u=/[1-9]/g;if(r===-1){return t}if(e===-1){o=1;i=r}var p=t.substring(0,i)+t.substring(i+a+o);if(u.test(p)){return t}t=t.replace(/[0-9]/g,"0");return t.substring(0,i)+"24"+t.substring(i+a+o)};_._replace24HoursWithZero=function(t,e,r){var o=2,n=e;if(e===-1){o=1;n=r}return t.substr(0,n)+f(0,o)+t.substr(n+2)};_._isHoursValue24=function(t,e,r){if(e===-1&&r===-1){return false}var o=e;if(e===-1){o=r}return t.substr(o,2)==="24"};_.prototype._getCurrentTimeButton=function(){if(!this._oNowButton){this._oNowButton=new l(this.getId()+"-now",{icon:"sap-icon://present",tooltip:this._oResourceBundle.getText("TIMEPICKER_TOOLTIP_NOW"),type:h.Transparent,visible:false,press:function(){this._setTimeValues(c.getInstance())}.bind(this)}).addStyleClass("sapMTPNow")}return this._oNowButton};function f(t,e){var r="";for(var o=0;o<e;o++){r+=t}return r}return _});
//# sourceMappingURL=TimePickerInternals.js.map