/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","./TimePickerSliderRenderer","sap/ui/core/ControlBehavior","sap/ui/core/IconPool","sap/ui/Device","sap/ui/core/Lib","sap/ui/events/KeyCodes","sap/m/Button","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(e,t,i,s,n,o,a,r,jQuery,l){"use strict";var h=e.extend("sap.m.TimePickerSlider",{metadata:{library:"sap.m",properties:{selectedValue:{type:"string",defaultValue:null},isCyclic:{type:"boolean",defaultValue:true},label:{type:"string",defaultValue:null},isExpanded:{type:"boolean",defaultValue:false}},aggregations:{items:{type:"sap.m.VisibleItem",multiple:true,singularName:"item"},_arrowUp:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_arrowDown:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{expanded:{},collapsed:{}}},renderer:t});var d=i.getAnimationMode();var p=d!==l.AnimationMode.none&&d!==l.AnimationMode.minimal;var f=p?200:0;var u=50;var c=32;var g=32;h.prototype.init=function(){this._bIsDrag=null;this._selectionOffset=0;this._mousedown=false;this._dragSession=null;this._iSelectedItemIndex=-1;this._animatingSnap=false;this._iSelectedIndex=-1;this._animating=false;this._intervalId=null;this._maxScrollTop=null;this._minScrollTop=null;this._marginTop=null;this._marginBottom=null;this._bOneTimeValueSelectionAnimation=false;this._bEnabled=true;if(n.system.desktop){this._fnHandleTypeValues=y.call(this)}this._initArrows()};h.prototype.exit=function(){this._detachEvents();var e=this._getSliderContainerDomRef();if(e){e.stop()}if(this._intervalId){clearInterval(this._intervalId);this._intervalId=null}};h.prototype.onBeforeRendering=function(){this._detachEvents()};h.prototype.onAfterRendering=function(){if(n.system.phone){setTimeout(this._afterExpandCollapse.bind(this),0)}else{this._afterExpandCollapse()}this._attachEvents()};h.prototype.onThemeChanged=function(e){this.invalidate()};h.prototype.fireTap=function(e){var t,i,s;if(!this.getIsExpanded()){if(n.system.desktop){this.focus()}else{this.setIsExpanded(true)}}else{t=e.srcElement||e.originalTarget;if(t&&t.tagName.toLowerCase()==="li"){i=jQuery(t).text();s=I.call(this,i);this._iClickedIndex=Array.prototype.slice.call(t.parentElement.children).indexOf(t);this._bOneTimeValueSelectionAnimation=true;this.setSelectedValue(s);this._fireSelectedValueChange(s)}else{this._addSelectionStyle();this.focus()}}};h.prototype.setSelectedValue=function(e){var t=m(this._getVisibleItems(),function(t){return t.getKey()===e}),i=this,s,n,o,a;if(t===-1){return this}if(this.getDomRef()){n=this._getSliderContainerDomRef();o=this._getItemHeightInPx();a=this._getContentRepeat();if(t*o>=this._selectionOffset){s=this._getVisibleItems().length*Math.floor(a/2)+t}else{s=this._getVisibleItems().length*Math.ceil(a/2)+t}if(this._bOneTimeValueSelectionAnimation){n.scrollTop((s-this._iClickedIndex+this._iSelectedItemIndex)*o-this._selectionOffset);this._animatingSnap=true;n.animate({scrollTop:s*o-this._selectionOffset},f,"linear",function(){n.clearQueue();i._animatingSnap=false;i._bOneTimeValueSelectionAnimation=false})}else{n.scrollTop(s*o-this._selectionOffset)}this._removeSelectionStyle();this._iSelectedItemIndex=s;this._addSelectionStyle()}return this.setProperty("selectedValue",e,true)};h.prototype.setIsExpanded=function(e,t){this.setProperty("isExpanded",e,true);if(!this.getDomRef()){return this}var i=this.$();if(e){i.addClass("sapMTPSliderExpanded");if(n.system.phone){setTimeout(function(){this._updateDynamicLayout(e);if(!t){this.fireExpanded({ctrl:this})}}.bind(this),0)}else{this._updateDynamicLayout(e);if(!t){this.fireExpanded({ctrl:this})}}}else{this._stopAnimation();if(this._animatingSnap===true){this._animatingSnap=false;this._getSliderContainerDomRef().stop(true);if(this._animatingTargetIndex!==null&&this._animatingTargetIndex!==undefined){this._scrollerSnapped(this._animatingTargetIndex);this._animatingTargetIndex=null}else if(this._iSelectedIndex!==-1){this._scrollerSnapped(this._iSelectedIndex)}}i.removeClass("sapMTPSliderExpanded");this._updateMargins(e);if(n.system.phone){setTimeout(this._afterExpandCollapse.bind(this),0)}else{this._afterExpandCollapse()}if(!t){this.fireCollapsed({ctrl:this})}}return this};h.prototype.onfocusin=function(e){if(!this.getIsExpanded()){this.setIsExpanded(true)}};h.prototype.onfocusout=function(e){var t=e.relatedTarget?e.relatedTarget.id:null,i=[this.getAggregation("_arrowUp").getId(),this.getAggregation("_arrowDown").getId()];if(t&&i.indexOf(t)!==-1){return}if(n.system.desktop&&this.getIsExpanded()){this.setIsExpanded(false)}};h.prototype._onmousewheel=function(e){var t,i,s;e.preventDefault();e.stopPropagation();if(!this.getIsExpanded()||this._intervalId){return false}t=e.originalEvent;i=t.detail?-t.detail>0:t.wheelDelta>0;s=t.detail?-t.detail/3:t.wheelDelta/120;if(!s){return false}this._handleWheelScroll(i,s)};h.prototype._handleWheelScroll=function(e,t){var i=e?Math.ceil:Math.floor,s;if(!this._aWheelDeltas){this._aWheelDeltas=[]}this._aWheelDeltas.push(t);if(!this._bWheelScrolling){this._bWheelScrolling=true;this._intervalId=setInterval(function(){if(!this._aWheelDeltas.length){clearInterval(this._intervalId);this._intervalId=null;this._bWheelScrolling=false}else{s=this._aWheelDeltas[0];this._aWheelDeltas=[];s=i(s);if(s){this._offsetSlider(s)}}}.bind(this),150)}return false};h.prototype.onsappageup=function(e){if(this.getIsExpanded()){var t=this._getVisibleItems()[0],i=t.getKey();this.setSelectedValue(i);this._fireSelectedValueChange(i)}};h.prototype.onsappagedown=function(e){if(this.getIsExpanded()){var t=this._getVisibleItems()[this._getVisibleItems().length-1],i=t.getKey();this.setSelectedValue(i);this._fireSelectedValueChange(i)}};h.prototype.onsapup=function(e){if(this.getIsExpanded()){this._offsetValue(-1)}};h.prototype.onsapdown=function(e){if(this.getIsExpanded()){this._offsetValue(1)}};h.prototype.onkeydown=function(e){var t=e.which||e.keyCode,i=a;if(t>=i.NUMPAD_0&&t<=i.NUMPAD_9){t=this._convertNumPadToNumKeyCode(t)}if(t>=i.A&&t<=i.Z||t>=i.DIGIT_0&&t<=i.DIGIT_9){this._fnHandleTypeValues(e.timeStamp,t)}};h.prototype._getSliderContainerDomRef=function(){return this.$().find(".sapMTimePickerSlider")};h.prototype._getContentRepeat=function(){var e;if(this.getIsCyclic()){e=Math.ceil(u/this._getVisibleItems().length);e=Math.max(e,3)}else{e=1}return e};h.prototype._getItemHeightInPx=function(){return this.$("content").find("li:not(.TPSliderItemHidden)")[0].getBoundingClientRect().height};h.prototype._updateSelectionFrameLayout=function(){var e,t,i,s,o=this.$().offset(),a=o?o.top:0,r=this.$().parents(".sapMTimePickerContainer").offset(),l=r?r.top:0;if(this.getDomRef()){s=this._getItemHeightInPx();e=this.$().find(".sapMTPPickerSelectionFrame");i=a-l;t=(this.$().height()-s+c)/2+i;e.css("top",t);if(n.system.phone){setTimeout(this._afterExpandCollapse.bind(this),0)}else{this._afterExpandCollapse()}}};h.prototype._updateStepAndValue=function(e,t){var i=0,s,n;for(n=0;n<this.getItems().length;n++){if(n%t!==0&&n!==e){this.getItems()[n].setVisible(false)}else{this.getItems()[n].setVisible(true);i++}}if(i>2&&i<13&&this.getDomRef()){s=this.$().find(".sapMTimePickerSlider");s.className="";jQuery(s).addClass("sapMTimePickerSlider SliderValues"+i.toString())}this.setIsCyclic(i>2);this.setSelectedValue(e.toString())};h.prototype._updateMargins=function(e){var t=this._getItemHeightInPx(),i,s,n,o,a,r,l,h;if(this.getDomRef()){t=this._getItemHeightInPx();i=this.$().find(".SliderValues3,.SliderValues4,.SliderValues5,.SliderValues6,.SliderValues7,.SliderValues8,.SliderValues9,.SliderValues10,.SliderValues11,.SliderValues12");if(!i.length){return}if(e){s=this._getVisibleItems().length;n=t*Math.floor(s/2);o=t*Math.ceil(s/2);r=this.$().parents().hasClass("sapUiSizeCompact")?g:0;a=(this.$().height()-t+c)/2;l=a-n-c-r;h=this.$().height()-a-o-r;l=Math.max(l,0);h=Math.max(h,0)}else{l=0;h=0}i.css("margin-top",l);i.css("margin-bottom",h)}};h.prototype._updateDynamicLayout=function(e){this._updateMargins(e);this._updateSelectionFrameLayout()};h.prototype._getSelectionFrameTopOffset=function(){var e=this._getSliderContainerDomRef().find(".sapMTPPickerSelectionFrame"),t=e.offset();return t.top};h.prototype._animateScroll=function(e){var t=this._getSliderContainerDomRef(),i=t.scrollTop(),s=25,n=t.height(),o=this.$("content").height(),a=200,r=n+a,l=this._getContentRepeat(),h=this.getIsCyclic(),d=.9,p=.05,u=this;this._intervalId=setInterval(function(){u._animating=true;i=i-e*s;if(h){i=u._getUpdatedCycleScrollTop(n,o,i,r,l)}else{if(i>u._maxScrollTop){i=u._maxScrollTop;e=0}if(i<u._minScrollTop){i=u._minScrollTop;e=0}}t.scrollTop(i);e*=d;if(Math.abs(e)<p){var a=u._getItemHeightInPx();var c=u._selectionOffset?u._selectionOffset%a:0;var g=Math.round((i+c)/a)*a-c;clearInterval(u._intervalId);u._intervalId=null;u._animating=null;u._iSelectedIndex=Math.round((i+u._selectionOffset)/a);u._animatingSnap=true;t.animate({scrollTop:g},f,"linear",function(){t.clearQueue();u._animatingSnap=false;if(t.css("visibility")==="visible"){u._scrollerSnapped(u._iSelectedIndex)}})}},s)};h.prototype._stopAnimation=function(){if(this._animating){clearInterval(this._intervalId);this._intervalId=null;this._animating=null}};h.prototype._startDrag=function(e){if(!this._dragSession){this._dragSession={};this._dragSession.positions=[]}this._dragSession.pageY=e;this._dragSession.startTop=this._getSliderContainerDomRef().scrollTop()};h.prototype._doDrag=function(e,t){if(this._dragSession){this._dragSession.offsetY=e-this._dragSession.pageY;this._dragSession.positions.push({pageY:e,timeStamp:t});if(this._dragSession.positions.length>20){this._dragSession.positions.splice(0,10)}if(this._bIsDrag){this._getSliderContainerDomRef().scrollTop(this._dragSession.startTop-this._dragSession.offsetY)}}};h.prototype._endDrag=function(e,t){if(this._dragSession){var i,s;for(var n=this._dragSession.positions.length-1;n>=0;n--){i=t-this._dragSession.positions[n].timeStamp;s=e-this._dragSession.positions[n].pageY;if(i>100){break}}var o=s/i;if(this._animating){clearInterval(this._intervalId);this._intervalId=null;this._animating=null}this._dragSession=null;this._animateScroll(o)}};h.prototype._afterExpandCollapse=function(){var e=this.getSelectedValue(),t=this._getSelectionFrameTopOffset(),i=this._getSliderContainerDomRef(),s=i.offset(),n,o,a,r;this._selectionOffset=t-s.top;if(!this.getIsCyclic()){o=this.$("content");r=this._getItemHeightInPx();a=this.$().height();if(this.getIsExpanded()){this._minScrollTop=0;this._marginTop=t-s.top;this._maxScrollTop=r*(this._getVisibleItems().length-1);n=i.height();this._marginBottom=n-this._marginTop-r;if(this._marginBottom<0){this._marginBottom=a-this._marginTop-r}o.css("margin-top",this._marginTop);o.css("margin-bottom",this._marginBottom)}else{this._marginBottom=a-r;o.css("margin-top",0);o.css("margin-bottom",this._marginBottom)}this._selectionOffset=0}if(!this.getIsExpanded()){this._selectionOffset=0}this.setSelectedValue(e)};h.prototype._getUpdatedCycleScrollTop=function(e,t,i,s,n){var o=t-i-e;while(o<s){i=i-t/n;o=t-i-e}while(i<s){i=i+t/n}return i};h.prototype._scrollerSnapped=function(e){var t=e,i=this._getVisibleItems().length,s;while(t>=i){t=t-i}if(!this.getIsCyclic()){t=e}s=this._getVisibleItems()[t].getKey();this.setSelectedValue(s);this._fireSelectedValueChange(s)};h.prototype._updateScroll=function(){var e=this.getSelectedValue();if(e!==this._getVisibleItems()[0].getKey()&&this._getSliderContainerDomRef().scrollTop()+(this._selectionOffset?this._selectionOffset:0)===0){this.setSelectedValue(e);this._fireSelectedValueChange(e)}};h.prototype._addSelectionStyle=function(){var e=this.$("content").find("li:not(.TPSliderItemHidden)"),t=e.eq(this._iSelectedItemIndex).text(),i,s;if(!t){return}s=t;if(s&&s.length>1&&s.indexOf("0")===0){s=s.substring(1)}e.eq(this._iSelectedItemIndex).addClass("sapMTimePickerItemSelected");i=this.getDomRef("valDescription");if(i.textContent!==s){i.textContent=s}};h.prototype._removeSelectionStyle=function(){var e=this.$("content").find("li:not(.TPSliderItemHidden)");e.eq(this._iSelectedItemIndex).removeClass("sapMTimePickerItemSelected")};h.prototype._attachEvents=function(){var e=this._getSliderContainerDomRef()[0];if(n.system.combi){e.addEventListener("touchstart",jQuery.proxy(_,this),false);e.addEventListener("touchmove",jQuery.proxy(S,this),false);document.addEventListener("touchend",jQuery.proxy(v,this),false);e.addEventListener("mousedown",jQuery.proxy(_,this),false);document.addEventListener("mousemove",jQuery.proxy(S,this),false);document.addEventListener("mouseup",jQuery.proxy(v,this),false)}else{if(n.system.phone||n.system.tablet){e.addEventListener("touchstart",jQuery.proxy(_,this),false);e.addEventListener("touchmove",jQuery.proxy(S,this),false);document.addEventListener("touchend",jQuery.proxy(v,this),false)}else{e.addEventListener("mousedown",jQuery.proxy(_,this),false);document.addEventListener("mousemove",jQuery.proxy(S,this),false);document.addEventListener("mouseup",jQuery.proxy(v,this),false)}}};h.prototype._detachEvents=function(){var e=this._getSliderContainerDomRef()[0];if(e==null){return}if(n.system.combi){e.removeEventListener("touchstart",jQuery.proxy(_,this),false);e.removeEventListener("touchmove",jQuery.proxy(S,this),false);document.removeEventListener("touchend",jQuery.proxy(v,this),false);e.removeEventListener("mousedown",jQuery.proxy(_,this),false);document.removeEventListener("mousemove",jQuery.proxy(S,this),false);document.removeEventListener("mouseup",jQuery.proxy(v,this),false)}else{if(n.system.phone||n.system.tablet){e.removeEventListener("touchstart",jQuery.proxy(_,this),false);e.removeEventListener("touchmove",jQuery.proxy(S,this),false);document.removeEventListener("touchend",jQuery.proxy(v,this),false)}else{e.removeEventListener("mousedown",jQuery.proxy(_,this),false);document.removeEventListener("mousemove",jQuery.proxy(S,this),false);document.removeEventListener("mouseup",jQuery.proxy(v,this),false)}}};h.prototype._offsetValue=function(e){var t=this._getSliderContainerDomRef(),i,s=this._getItemHeightInPx(),n,o,a=this.getIsCyclic(),r=this;this._stopAnimation();if(this._animatingSnap===true){this._animatingSnap=false;this._getSliderContainerDomRef().stop(true);if(this._animatingTargetIndex!==null){this._scrollerSnapped(this._animatingTargetIndex);this._animatingTargetIndex=null}else if(this._iSelectedIndex!==-1){this._scrollerSnapped(this._iSelectedIndex)}}o=this._iSelectedItemIndex+e;i=t.scrollTop();n=i+e*s;if(!a){if(o<0||o>=this._getVisibleItems().length){return}if(n>this._maxScrollTop){n=this._maxScrollTop}if(n<this._minScrollTop){n=this._minScrollTop}}this._animatingSnap=true;this._animatingTargetIndex=o;t.animate({scrollTop:n},f,"linear",function(){t.clearQueue();r._animatingSnap=false;r._animatingTargetIndex=null;if(t.css("visibility")==="visible"){r._scrollerSnapped(o)}})};h.prototype._offsetSlider=function(e){var t=this._getSliderContainerDomRef().scrollTop(),i=this,s=i._getSliderContainerDomRef().height(),n=i.$("content").height(),o=200,a=s+o,r=i._getContentRepeat(),l=i.getIsCyclic(),h=i._getItemHeightInPx();t=t-e*h;if(l){t=i._getUpdatedCycleScrollTop(s,n,t,a,r)}else{if(t>i._maxScrollTop){t=i._maxScrollTop}if(t<i._minScrollTop){t=i._minScrollTop}}i._getSliderContainerDomRef().scrollTop(t);i._iSelectedIndex=Math.round((t+i._selectionOffset)/h);i._scrollerSnapped(i._iSelectedIndex)};h.prototype._initArrows=function(){var e=this,t,i,n=o.getResourceBundleFor("sap.m");t=new r({icon:s.getIconURI("slim-arrow-up"),press:function(t){e._offsetValue(-1)},tooltip:n.getText("TIMEPICKER_TOOLTIP_UP"),type:"Transparent"});t.addEventDelegate({onAfterRendering:function(){t.$().attr("tabindex",-1)}});this.setAggregation("_arrowUp",t);i=new r({icon:s.getIconURI("slim-arrow-down"),press:function(t){e._offsetValue(1)},tooltip:n.getText("TIMEPICKER_TOOLTIP_DOWN"),type:"Transparent"});i.addStyleClass("sapMTimePickerItemArrowDown");i.addEventDelegate({onAfterRendering:function(){i.$().attr("tabindex",-1)}});this.setAggregation("_arrowDown",i)};h.prototype._convertNumPadToNumKeyCode=function(e){var t=a;if(e>=t.NUMPAD_0&&e<=t.NUMPAD_9){e-=48}return e};function m(e,t){if(e==null){throw new TypeError("findIndex called with null or undefined array")}if(typeof t!=="function"){throw new TypeError("predicate must be a function")}var i=e.length;var s=arguments[1];var n;for(var o=0;o<i;o++){n=e[o];if(t.call(s,n,o,e)){return o}}return-1}var _=function(e){var t=e.touches&&e.touches.length?e.touches[0].pageY:e.pageY;this._bIsDrag=false;if(!this.getIsExpanded()){return}this._stopAnimation();this._startDrag(t);if(!n.system.desktop){e.preventDefault()}this._mousedown=true};var S=function(e){var t=e.touches&&e.touches.length?e.touches[0].pageY:e.pageY;if(!this._mousedown||!this.getIsExpanded()){return}if(!this._bIsDrag&&this._dragSession&&this._dragSession.positions.length){var i=this._dragSession.positions.some(function(e){return Math.abs(e.pageY-t)>5});if(i){this._bIsDrag=true}}this._doDrag(t,e.timeStamp);this._mousedown=true};var v=function(e){var t=e.changedTouches&&e.changedTouches.length?e.changedTouches[0].pageY:e.pageY;if(this._bIsDrag===false){this.fireTap(e);this._dragSession=null}this._bIsDrag=true;if(!this.getIsExpanded()){this._dragSession=null;return}this._endDrag(t,e.timeStamp);this._mousedown=false};var I=function(e){var t=this._getVisibleItems();var i=m(t,function(t){return t.getText()===e});return t[i]?t[i].getKey():""};var y=function(){var e=-1,t=-1,i=1e3,s="",n=function(n,o){var a;if(e+i<n){s=""}else{if(t!==-1){clearTimeout(t);t=-1}}s+=String.fromCharCode(o).toLowerCase();a=this._getVisibleItems().filter(function(e){return e.getKey().indexOf(s)===0});if(a.length>1){t=setTimeout(function(){this.setSelectedValue(s);s="";t=-1}.bind(this),i)}else if(a.length===1){this.setSelectedValue(a[0].getKey());s=""}else{s=""}e=n};return n};h.prototype._getVisibleItems=function(){return this.getItems().filter(function(e){return e.getVisible()})};h.prototype._setEnabled=function(e){this._bEnabled=e;if(e){this.$().removeClass("sapMTPDisabled");this.$().attr("tabindex",0)}else{this.$().addClass("sapMTPDisabled");this.$().attr("tabindex",-1)}return this};h.prototype._getEnabled=function(e){return this._bEnabled};h.prototype._fireSelectedValueChange=function(e){this.fireEvent("_selectedValueChange",{value:e})};return h});
//# sourceMappingURL=TimePickerSlider.js.map