/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/date/CalendarType","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/Control","sap/ui/model/type/Date","sap/ui/model/odata/type/ODataType","sap/ui/core/format/DateFormat","./TimePickerSlider","./TimePickerSlidersRenderer","./VisibleItem","sap/ui/core/LocaleData","sap/ui/Device","sap/ui/core/Locale","sap/ui/thirdparty/jquery","sap/ui/core/date/UI5Date"],function(e,t,i,r,s,n,o,a,l,u,d,p,g,h,jQuery,c){"use strict";var f=1;var _=s.extend("sap.m.TimePickerSliders",{metadata:{library:"sap.m",properties:{localeId:{type:"string",group:"Data"},displayFormat:{type:"string",group:"Appearance"},labelText:{type:"string"},minutesStep:{type:"int",group:"Misc",defaultValue:f},secondsStep:{type:"int",group:"Misc",defaultValue:f},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"},value:{type:"string",group:"Data",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},support2400:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{_columns:{type:"sap.m.TimePickerSlider",multiple:true,visibility:"hidden"}},events:{change:{parameters:{value:{type:"string"}}}}},renderer:u});_.prototype.init=function(){var t=new h(e.getLanguageTag()),i=p.getInstance(t),r=i.getDayPeriods("abbreviated"),s=i.getTimePattern("medium");this._fnLayoutChanged=jQuery.proxy(this._onOrientationChanged,this);g.resize.attachHandler(this._fnLayoutChanged);this._sAM=r[0];this._sPM=r[1];this._onSliderExpanded=this._onSliderExpanded.bind(this);this._onSliderCollapsed=this._onSliderCollapsed.bind(this);this.setDisplayFormat(s);this._setTimeValues();this._iMinutes;this._iSeconds};_.prototype.exit=function(){this.$().off(g.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);g.resize.detachHandler(this._fnOrientationChanged)};_.prototype.onAfterRendering=function(){this.$().off(g.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);this.$().on(g.browser.firefox?"DOMMouseScroll":"mousewheel",jQuery.proxy(this._onmousewheel,this));this.$().on("selectstart",m);if(this._getShouldOpenSliderAfterRendering()){if(g.system.desktop){this._getFirstSlider().setIsExpanded(true)}}};_.prototype.setLocaleId=function(e){var t,i;e=this.validateProperty("localeId",e);this.setProperty("localeId",e,true);if(e){t=new h(e);i=p.getInstance(t).getDayPeriods("abbreviated");this._sAM=i[0];this._sPM=i[1];this._destroyColumns();this._setupLists()}return this};_.prototype.setSupport2400=function(e){this.setProperty("support2400",e,true);this._destroyColumns();this._setupLists();return this};_.prototype.setDisplayFormat=function(e){this.setProperty("displayFormat",e,true);this._destroyColumns();this._setupLists();return this};_.prototype.setMinutesStep=function(e){e=Math.max(f,e||f);this.setProperty("minutesStep",e,true);this._destroyColumns();this._setupLists();return this};_.prototype.setSecondsStep=function(e){e=Math.max(f,e||f);this.setProperty("secondsStep",e,true);this._destroyColumns();this._setupLists();return this};_.prototype.setValue=function(e){var t=this._getHoursSlider(),i=this._getValueFormatPattern(),r=i.indexOf("HH"),s=i.indexOf("H"),n=t&&t.getSelectedValue()==="24",o=_._isHoursValue24(e,r,s);if(n&&this._isFormatSupport24()&&!o){e=_._replaceZeroHoursWith24(e,r,s)}e=this.validateProperty("value",e);this.setProperty("value",e,true);var a;if(e){a=this._parseValue(o?_._replace24HoursWithZero(e,r,s):e)}if(a){this._setTimeValues(a,o)}return this};_.prototype.getTimeValues=function(){var e=this._getHoursSlider(),t=this._getMinutesSlider(),i=this._getSecondsSlider(),r=this._getFormatSlider(),s=null,n=null,o=c.getInstance();if(e){s=parseInt(e.getSelectedValue())}if(r){n=r.getSelectedValue()}if(n==="am"&&s===12){s=0}else if(n==="pm"&&s!==12){s+=12}if(s!==null){o.setHours(s.toString())}if(t){o.setMinutes(t.getSelectedValue())}if(i){o.setSeconds(i.getSelectedValue())}return o};_.prototype.collapseAll=function(){var e=this.getAggregation("_columns");if(e){for(var t=0;t<e.length;t++){if(e[t].getIsExpanded()){e[t].setIsExpanded(false)}}}return this};_.prototype.openFirstSlider=function(){var e=this._getFirstSlider();e.setIsExpanded(true);e.focus();return this};_.prototype._setTimeValues=function(e,t){var i=this._getHoursSlider(),r=this._getMinutesSlider(),s=this._getSecondsSlider(),n=this._getFormatSlider(),o,a=null;e=e||c.getInstance();if(Object.prototype.toString.call(e)!=="[object Date]"||isNaN(e)){throw new Error("Date must be a JavaScript date object; "+this)}if(!t){var l=this._formatValue(e,true);this.setProperty("value",l,true);o=e.getHours()}else{o=24}if(n){a=o>=12?"pm":"am";o=o>12?o-12:o;o=o===0?12:o}i&&i.setSelectedValue(o.toString());r&&r._updateStepAndValue(e.getMinutes(),this.getMinutesStep());s&&s._updateStepAndValue(e.getSeconds(),this.getSecondsStep());n&&n.setSelectedValue(a);if(t){this._disableSlider(r);r&&r.setSelectedValue("0");this._disableSlider(s);s&&s.setSelectedValue("0")}else{this._enableSlider(r);this._enableSlider(s)}};_.prototype._updateSlidersValues=function(){var e=this.getAggregation("_columns");if(e){for(var t=0;t<e.length;t++){e[t]._updateScroll()}}};_.prototype.onsaphome=function(e){var t=this._getFirstSlider(),i=this._getCurrentSlider();if(i&&document.activeElement===i.getDomRef()&&this._isSliderEnabled(t)){t.focus()}};_.prototype.onsapend=function(e){var t=this._getLastSlider(),i=this._getCurrentSlider();if(i&&document.activeElement===i.getDomRef()&&this._isSliderEnabled(t)){t.focus()}};_.prototype.onsapleft=function(e){var t,i=this._getCurrentSlider(),r=-1,s=-1,n=this.getAggregation("_columns");if(i&&document.activeElement===i.getDomRef()){r=n.indexOf(i);s=r>0?r-1:n.length-1;t=n[s];if(this._isSliderEnabled(t)){t.focus()}}};_.prototype.onsapright=function(e){var t,i=this._getCurrentSlider(),r=-1,s=-1,n=this.getAggregation("_columns");if(i&&document.activeElement===i.getDomRef()){r=n.indexOf(i);s=r<n.length-1?r+1:0;t=n[s];if(this._isSliderEnabled(t)){t.focus()}}};_.prototype._onmousewheel=function(e){var t=this._getCurrentSlider();if(t){t._onmousewheel(e)}};_.prototype._onOrientationChanged=function(){var e=this.getAggregation("_columns");if(!e){return}for(var t=0;t<e.length;t++){if(e[t].getIsExpanded()){e[t]._updateSelectionFrameLayout()}}};_.prototype._generatePickerListValues=function(e,t,i,r){var s=[],n;for(var o=e;o<=t;o+=1){if(o<10&&r){n="0"+o.toString()}else{n=o.toString()}var a=new d({key:o.toString(),text:n});if(o%i!==0){a.setVisible(false)}s.push(a)}return s};_.prototype._checkStyle=function(e){return e==="short"||e==="medium"||e==="long"||e==="full"};_.prototype._getDisplayFormatPattern=function(){var e=this.getDisplayFormat();if(this._checkStyle(e)){e=this._getLocaleBasedPattern(e)}return e};_.prototype._getValueFormatPattern=function(){var e=this._getBoundValueTypePattern()||this.getValueFormat()||"medium";if(this._checkStyle(e)){e=this._getLocaleBasedPattern(e)}return e};_.prototype._getLocaleBasedPattern=function(t){return p.getInstance(new h(e.getLanguageTag())).getTimePattern(t)};_.prototype._destroyColumns=function(){var e=this.getAggregation("_columns");if(e){this.destroyAggregation("_columns")}};_.prototype._setupLists=function(){var e=r.getResourceBundleFor("sap.m"),t=e.getText("TIMEPICKER_LBL_HOURS"),i=e.getText("TIMEPICKER_LBL_MINUTES"),s=e.getText("TIMEPICKER_LBL_SECONDS"),n=e.getText("TIMEPICKER_LBL_AMPM"),o=this.getMinutesStep(),a=this.getSecondsStep(),u=this._getDisplayFormatPattern();if(u===undefined){return}var p=false,g=false,h,c;if(u.indexOf("HH")!==-1){p=true;h=0;c=this.getSupport2400()?24:23;g=true}else if(u.indexOf("H")!==-1){p=true;h=0;c=this.getSupport2400()?24:23}else if(u.indexOf("hh")!==-1){p=true;h=1;c=12;g=true}else if(u.indexOf("h")!==-1){p=true;h=1;c=12}if(p){this.addAggregation("_columns",new l(this.getId()+"-listHours",{items:this._generatePickerListValues(h,c,1,g),expanded:this._onSliderExpanded,collapsed:this._onSliderCollapsed,label:t}).attachEvent("_selectedValueChange",this._handleHoursChange,this))}if(u.indexOf("m")!==-1){var f=this._generatePickerListValues(0,59,o,true);this.addAggregation("_columns",new l(this.getId()+"-listMins",{items:f,expanded:this._onSliderExpanded,collapsed:this._onSliderCollapsed,label:i}))}if(u.indexOf("s")!==-1){var f=this._generatePickerListValues(0,59,a,true);this.addAggregation("_columns",new l(this.getId()+"-listSecs",{items:f,expanded:this._onSliderExpanded,collapsed:this._onSliderCollapsed,label:s}))}if(u.indexOf("a")!==-1){this.addAggregation("_columns",new l(this.getId()+"-listFormat",{items:[new d({key:"am",text:this._sAM}),new d({key:"pm",text:this._sPM})],expanded:this._onSliderExpanded,collapsed:this._onSliderCollapsed,label:n,isCyclic:false}).addStyleClass("sapMTimePickerSliderShort"))}var _,S=this.getValue();if(S){_=this._parseValue(S)}if(_){this._setTimeValues(_)}};_.prototype._getCurrentSlider=function(){var e=this.getAggregation("_columns");if(e){for(var t=0;t<e.length;t++){if(e[t].getIsExpanded()){return e[t]}}}return null};_.prototype._getHoursSlider=function(){return i.getElementById(this.getId()+"-listHours")||null};_.prototype._getMinutesSlider=function(){return i.getElementById(this.getId()+"-listMins")||null};_.prototype._getSecondsSlider=function(){return i.getElementById(this.getId()+"-listSecs")||null};_.prototype._getFormatSlider=function(){return i.getElementById(this.getId()+"-listFormat")||null};_.prototype._getFirstSlider=function(){return this.getAggregation("_columns")[0]||null};_.prototype._getLastSlider=function(){var e=this.getAggregation("_columns");return e[e.length-1]||null};_.prototype._parseValue=function(e){return this._getFormatter().parse(e)};_.prototype._isSliderEnabled=function(e){return e._getEnabled()};_.prototype._getFormatter=function(){var i=this._getBoundValueTypePattern(),r=false,s=this.getBinding("value"),n;if(s&&s.oType&&s.oType.oOutputFormat){r=!!s.oType.oOutputFormat.oFormatOptions.relative;n=s.oType.oOutputFormat.oFormatOptions.calendarType}if(!i){i=this.getValueFormat()||"medium";n=t.Gregorian}if(!n){n=e.getCalendarType()}return this._getFormatterInstance(i,r,n)};_.prototype._getBoundValueTypePattern=function(){var e=this.getBinding("value"),t=e&&e.getType&&e.getType();if(t instanceof n){return t.getOutputPattern()}if(t instanceof o&&t.oFormat){return t.oFormat.oFormatOptions.pattern}return undefined};_.prototype._getFormatterInstance=function(e,t,i,r){var s;if(this._checkStyle(e)){s=this._getFormatInstance({style:e,strictParsing:true,relative:t,calendarType:i})}else{s=this._getFormatInstance({pattern:e,strictParsing:true,relative:t,calendarType:i})}return s};_.prototype._getFormatInstance=function(e,t){return a.getTimeInstance(e)};_.prototype._formatValue=function(e){if(e){return this._getFormatter().format(e)}return""};_.prototype._onSliderExpanded=function(e){var t=this.getAggregation("_columns");for(var i=0;i<t.length;i++){if(t[i]!==e.oSource&&t[i].getIsExpanded()){t[i].setIsExpanded(false)}}};_.prototype._onSliderCollapsed=function(e){var t=this.getTimeValues();this.setValue(this._formatValue(t,true));this.fireChange({value:this.getValue()})};_.prototype._getShouldOpenSliderAfterRendering=function(){return this._shouldOpenSliderAfterRendering};_.prototype._setShouldOpenSliderAfterRendering=function(e){this._shouldOpenSliderAfterRendering=e;return this};_.prototype._isFormatSupport24=function(){var e=this._getDisplayFormatPattern();return e.indexOf("HH")!==-1||e.indexOf("H")!==-1};_.prototype._disableSlider=function(e){if(e){e._setEnabled(false)}return this};_.prototype._enableSlider=function(e){if(e){e._setEnabled(true)}return this};_.prototype._handleHoursChange=function(e){var t=e.getParameter("value"),i=this._getMinutesSlider(),r=this._getSecondsSlider();if(this.getSupport2400()){if(t==="24"){if(i&&i._getEnabled()){this._iMinutes=i.getSelectedValue();this._disableSlider(i);i.setSelectedValue("0")}if(r&&r._getEnabled()){this._iSeconds=r.getSelectedValue();this._disableSlider(r);r.setSelectedValue("0")}}else{if(i&&!i._getEnabled()){this._enableSlider(i);i.setSelectedValue(this._iMinutes)}if(r&&!r._getEnabled()){this._enableSlider(r);r.setSelectedValue(this._iSeconds)}}}};_._replaceZeroHoursWith24=function(e,t,i){var r=2,s=t;if(t===-1){r=1;s=i}return e.substr(0,s)+"24"+e.substr(s+r)};_._replace24HoursWithZero=function(e,t,i){var r=2,s=t;if(t===-1){r=1;s=i}return e.substr(0,s)+S(0,r)+e.substr(s+2)};_._isHoursValue24=function(e,t,i){if(t===-1&&i===-1){return false}var r=t;if(t===-1){r=i}return e.substr(r,2)==="24"};function S(e,t){var i="";for(var r=0;r<t;r++){i+=e}return i}function m(){return false}return _});
//# sourceMappingURL=TimePickerSliders.js.map