/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/base/i18n/Localization","sap/m/Button","sap/m/List","sap/m/StandardListItem","sap/m/ResponsivePopover","sap/ui/core/ControlBehavior","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/ResizeHandler","./TokenizerRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/Theming","sap/ui/core/theming/Parameters","sap/ui/dom/jquery/scrollLeftRTL"],function(e,t,o,i,n,s,r,a,l,d,h,p,u,c,f,g,T,k,_,m){"use strict";var y="sapUiNoContentPadding";var v=e.TokenizerRenderMode;var b=e.PlacementType;var R=e.ListMode;var I=e.ListType;var S=e.ButtonType;var M=a.extend("sap.m.Tokenizer",{metadata:{library:"sap.m",properties:{editable:{type:"boolean",group:"Misc",defaultValue:true},enabled:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},renderMode:{type:"string",group:"Misc",defaultValue:v.Narrow},hiddenTokensCount:{type:"int",group:"Misc",defaultValue:0,visibility:"hidden"}},defaultAggregation:"tokens",aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},_tokensInfo:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tokenChange:{deprecated:true,parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{deprecated:true,allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenDelete:{parameters:{tokens:{type:"sap.m.Token[]"},keyCode:{type:"number"}}},renderModeChange:{parameters:{renderMode:{type:"string"}}}}},renderer:f});var C=d.getResourceBundleFor("sap.m");M.prototype.init=function(){this.allowTextSelection(false);this._oTokensWidthMap={};this._oIndicator=null;this._bShouldRenderTabIndex=null;this._oScroller=new h(this,this.getId()+"-scrollContainer",{horizontal:true,vertical:false,nonTouchScrolling:true});this._fFontSizeRatio=1;if(r.isAccessibilityEnabled()){var e=new u({text:C.getText("TOKENIZER_ARIA_NO_TOKENS")});this.setAggregation("_tokensInfo",e)}this.attachEvent("delete",function(e){var t=e.getSource();var o=this.getSelectedTokens();var i=!!o.length&&o[o.indexOf(t)+1]||o[o.indexOf(t)-1];this._fireCompatibilityEvents(t,o);this.fireEvent("tokenDelete",{tokens:[t]});if(i){i.focus()}e.cancelBubble()},this);this._bThemeApplied=false;this._handleThemeApplied=()=>{this._bThemeApplied=true;_.detachApplied(this._handleThemeApplied)};_.attachApplied(this._handleThemeApplied)};M.prototype._fireCompatibilityEvents=function(e,t){this.fireTokenChange({type:M.TokenChangeType.Removed,token:e,tokens:t.length?t:[e],addedTokens:[],removedTokens:t.length?t:[e]});this.fireTokenUpdate({type:M.TokenChangeType.Removed,addedTokens:[],removedTokens:t.length?t:[e]})};M.prototype._handleNMoreIndicatorPress=function(){this._bIsOpenedByNMoreIndicator=true;this._togglePopup(this.getTokensPopup())};M.prototype._getTokensList=function(){if(!this._oTokensList){this._oTokensList=new i({width:"auto",mode:R.Delete}).attachDelete(this._handleListItemDelete,this).attachItemPress(this._handleListItemPress,this)}return this._oTokensList};M.prototype._setPopoverMode=function(e){var t=this.getTokensPopup();var o={showArrow:true,placement:b.VerticalPreferredBottom};t.setShowArrow(o.showArrow);t.setPlacement(o.placement);this._getTokensList().setMode(e)};M.prototype._fillTokensList=function(e,t){e.destroyItems();t=t?t:function(){return true};this.getTokens().filter(t).forEach(function(t){e.addItem(this._mapTokenToListItem(t))},this)};M.prototype._handleListItemDelete=function(e){var t=e.getParameter("listItem");var o=t&&t.data("tokenId");var i;i=this.getTokens().filter(function(e){return e.getId()===o&&e.getEditable()})[0];if(i){this.fireTokenUpdate({addedTokens:[],removedTokens:[i],type:M.TokenUpdateType.Removed});this.fireTokenDelete({tokens:[i]});this._adjustTokensVisibility()}};M.prototype._handleListItemPress=function(e){var t=e.getParameter("listItem");var o=t&&t.data("tokenId");var i=this.getTokens().filter(function(e){return e.getId()===o})[0];if(i){i.firePress()}};M.prototype.getTokensPopup=function(){var e=this._getTokensList();if(this._oPopup){return this._oPopup}this._oPopup=new s({showArrow:true,showHeader:p.system.phone,placement:b.Auto,offsetX:0,offsetY:3,horizontalScrolling:false,title:this._getDialogTitle(),content:this._getTokensList()}).attachBeforeOpen(function(){var t=this.getEditable()?120:32,o=this._oPopup,i=function(){var e=this.getDomRef()&&this.getDomRef().parentElement;var t="Cozy";if(!e){return t}if(e.closest(".sapUiSizeCompact")!==null||document.body.classList.contains("sapUiSizeCompact")){t="Compact"}return t}.bind(this),n=new Promise(function(e){m.get({name:["_sap_m_Tokenizer_FontSizeRatio"+i()],callback:function(t){var o=parseFloat(t);if(isNaN(o)){e(this._fFontSizeRatio);return}e(o)}.bind(this)})}.bind(this));if(o.getContent&&!o.getContent().length){o.addContent(e)}this._fillTokensList(e);t+=Object.keys(this._oTokensWidthMap).map(function(e){return this._oTokensWidthMap[e]},this).sort(function(e,t){return e-t}).pop()||0;n.then(function(e){t+=Math.ceil(t*(1-e));o.setContentWidth(t+"px")})},this).attachAfterClose(this.afterPopupClose,this).attachAfterOpen(function(){var t=e.getItems();this.setRenderMode(v.Loose);this.fireRenderModeChange({renderMode:"Loose"});if(t.length){t[0].focus()}},this);this.addDependent(this._oPopup);this._oPopup.addStyleClass(y);this._oPopup.addStyleClass("sapMTokenizerTokensPopup");if(p.system.phone){this._oPopup.setEndButton(new o({text:C.getText("SUGGESTIONSPOPOVER_CLOSE_BUTTON"),type:S.Emphasized,press:function(){this._oPopup.close()}.bind(this)}))}return this._oPopup};M.prototype.afterPopupClose=function(){if(!this.checkFocus()){this.setRenderMode(v.Narrow);this.fireRenderModeChange({renderMode:"Narrow"})}};M.prototype._getDialogTitle=function(){var e=d.getResourceBundleFor("sap.m");var t=this.getAriaLabelledBy().map(function(e){return l.getElementById(e)});return t.length?t[0].getText?.():e.getText("COMBOBOX_PICKER_TITLE")};M.prototype._togglePopup=function(e,t){var o=t||this.getDomRef(),i=e.isOpen(),n=this.getEditable();this._setPopoverMode(n?R.Delete:R.None);if(i){e.close()}else{e.openBy(o)}};M.prototype._mapTokenToListItem=function(e){if(!e){return null}var t=new n({selected:true,wrapping:true,type:I.Active,wrapCharLimit:1e4}).data("tokenId",e.getId());var o=function(e){this._togglePopup(this.getTokensPopup());if(this.getTokens().length&&this._bIsOpenedByNMoreIndicator){this.getTokens()[0].focus();this._bIsOpenedByNMoreIndicator=false}};t.setTitle(e.getText());t.addDelegate({onkeydown:function(e){e.preventDefault();if(!((e.ctrlKey||e.metaKey)&&e.which===T.I)&&e.which!==T.ESCAPE){return}this._togglePopup(this.getTokensPopup());if(this.getTokens().length&&this._bIsOpenedByNMoreIndicator){this.getTokens()[0].focus();this._bIsOpenedByNMoreIndicator=false}},onsapshow:o,onsaphide:o},this);return t};M.prototype._getPixelWidth=function(){var e=this.getMaxWidth(),t,o=this.getDomRef(),i;if(!o){return}i=parseInt(this.$().css("padding-left"));if(e.indexOf("px")===-1){t=o.clientWidth}else{t=parseInt(this.getMaxWidth())}return t-i};M.prototype._adjustTokensVisibility=function(){if(!this.getDomRef()){return}var e=this._getPixelWidth(),t=this._getVisibleTokens(),o=t.length,i,n,s,r=-1;t.some(function(t,i){e=e-this._oTokensWidthMap[t.getId()];if(e<=1&&o===1||e<0){r=i;return true}else{n=e;return false}},this);if(o===1&&r!==-1){this.setFirstTokenTruncated(true);return}else if(o===1&&t[0].getTruncated()){this.setFirstTokenTruncated(false)}if(r>-1){for(s=0;s<o;s++){if(s>=r){t[s].addStyleClass("sapMHiddenToken")}else{t[s].removeStyleClass("sapMHiddenToken")}}this._handleNMoreIndicator(o-r);i=this._oIndicator.width();if(i>=n){r=r-1;this._handleNMoreIndicator(o-r);t[r].addStyleClass("sapMHiddenToken")}this._setHiddenTokensCount(o-r)}else{this._setHiddenTokensCount(0);this._showAllTokens()}};M.prototype.setFirstTokenTruncated=function(e){var t=this.getTokens()[0];t&&t.setTruncated(e);if(e){this.addStyleClass("sapMTokenizerOneLongToken")}else{this.removeStyleClass("sapMTokenizerOneLongToken")}return this};M.prototype.hasOneTruncatedToken=function(){return this.getTokens().length===1&&this.getTokens()[0].getTruncated()};M.prototype._handleNMoreIndicator=function(e){if(!this.getDomRef()){return this}if(e){var t="MULTIINPUT_SHOW_MORE_TOKENS";if(e===this._getVisibleTokens().length){if(e===1){t="TOKENIZER_SHOW_ALL_ITEM"}else{t="TOKENIZER_SHOW_ALL_ITEMS"}}this._oIndicator.html(C.getText(t,[e]))}return this};M.prototype._getVisibleTokens=function(){return this.getTokens().filter(function(e){return e.getVisible()})};M.prototype._showAllTokens=function(){this._getVisibleTokens().forEach(function(e){e.removeStyleClass("sapMHiddenToken")})};M.prototype.getScrollDelegate=function(){return this._oScroller};M.prototype.scrollToEnd=function(){var e=this.getDomRef(),o=t.getRTL(),i=this.getTokens()[0]&&this.getTokens()[0].getDomRef()&&this.getTokens()[0].getDomRef()===document.activeElement,n,s;if(!this.getDomRef()||i){return}s=this.$().find(".sapMTokenizerScrollContainer")[0];n=s.scrollWidth;if(o){n*=-1}e.scrollLeft=n};M.prototype._registerResizeHandler=function(){if(!this._sResizeHandlerId){this._sResizeHandlerId=c.register(this.getDomRef(),this._handleResize.bind(this))}};M.prototype._handleResize=function(){this._useCollapsedMode(this.getRenderMode())};M.prototype.setPixelWidth=function(e){if(typeof e!=="number"){k.warning("Tokenizer.setPixelWidth called with invalid parameter. Expected parameter of type number.");return}this.setWidth(e+"px");if(this._oScroller){this._oScroller.refresh()}};M.prototype.scrollToStart=function(){var e=this.getDomRef();if(!e){return}e.scrollLeft=0};M.prototype.getScrollWidth=function(){if(!this.getDomRef()){return 0}return this.$().children(".sapMTokenizerScrollContainer")[0].scrollWidth};M.prototype.onBeforeRendering=function(){var e=this.getTokens();if(e.length!==1){this.setFirstTokenTruncated(false)}e.forEach(function(t,o){t.setProperty("editableParent",this.getEditable()&&this.getEnabled());t.setProperty("posinset",o+1);t.setProperty("setsize",e.length)},this);this._setTokensAria()};M.prototype.onAfterRendering=function(){var e=this.getRenderMode();var t=this._getTokenToFocus();this._oIndicator=this.$().find(".sapMTokenizerIndicator");if(this._bThemeApplied){this._storeTokensSizes()}this._useCollapsedMode(e);this._registerResizeHandler();if(!this.getEnabled()&&this.getTokens().length){this.getTokens().forEach(function(e){if(!e.getDomRef()){return}e.getDomRef().setAttribute("tabindex","-1")})}if(t&&t.getDomRef()&&this.getEffectiveTabIndex()){t.getDomRef().setAttribute("tabindex","0")}if(this._bFocusFirstToken){this.scrollToStart();this._bFocusFirstToken=false;return}if(e===v.Loose&&this._nMoreIndicatorPressed){this.scrollToEnd()}};M.prototype.onThemeChanged=function(){this._storeTokensSizes();this._useCollapsedMode(this.getRenderMode())};M.prototype._storeTokensSizes=function(){var e=this.getTokens();e.forEach(function(e){if(e.getDomRef()&&!e.$().hasClass("sapMHiddenToken")&&!e.getTruncated()){this._oTokensWidthMap[e.getId()]=e.$().outerWidth(true)}},this)};M.prototype._getTokenToFocus=function(){var e=this._getVisibleTokens();return e.find(e=>e.getSelected())||e[0]};M.prototype._useCollapsedMode=function(e){var t=this._getVisibleTokens();if(!t.length){this._setHiddenTokensCount(0);return}if(e===v.Narrow){this._adjustTokensVisibility()}else{this._setHiddenTokensCount(0);this._showAllTokens()}};M.prototype.onsapfocusleave=function(e){if(document.activeElement===this.getDomRef()||!this.checkFocus()){this._oSelectionOrigin=null}if(!this.checkFocus()){this._bFocusFirstToken=true;this.setRenderMode(v.Narrow);this.fireRenderModeChange({renderMode:"Narrow"})}};M.prototype.onsapbackspace=function(e){var t=this.getSelectedTokens();var o=this.getTokens().filter(function(e){return e.getFocusDomRef()===document.activeElement})[0];var i=this.getTokens();var n=t.length?t:[o];var s=!!t.length&&i[t.indexOf(o)+1]||i[t.indexOf(o)-1];e.preventDefault();if(s){s.focus()}return this.fireTokenDelete({tokens:n,keyCode:e.which})};M.prototype.onsapdelete=M.prototype.onsapbackspace;M.prototype.onkeydown=function(e){var t;var o=(e.ctrlKey||e.metaKey)&&e.which===T.I;if(!this.getEnabled()){return}if(e.which===T.TAB){this._changeAllTokensSelection(false)}if((e.ctrlKey||e.metaKey)&&e.which===T.A){t=this.getSelectedTokens().length<this._getVisibleTokens().length;if(this._getVisibleTokens().length>0){this.focus();this._changeAllTokensSelection(t);e.preventDefault();e.stopPropagation()}}if((e.ctrlKey||e.metaKey)&&(e.which===T.C||e.which===T.INSERT)){this._copy()}if((e.ctrlKey||e.metaKey)&&e.which===T.X||e.shiftKey&&e.which===T.DELETE){if(this.getEditable()){this._cut()}else{this._copy()}}if(o){e.preventDefault();e.stopPropagation();this._togglePopup(this.getTokensPopup());return}};M.prototype.onsaphide=function(e){this._togglePopup(this.getTokensPopup())};M.prototype.onsapshow=M.prototype.onsaphide;M.prototype._shouldPreventModifier=function(e){var t=p.os.macintosh&&e.metaKey;var o=p.os.windows&&e.altKey;return t||o};M.prototype.onsappreviousmodifiers=function(e){if(!this._shouldPreventModifier(e)){this.onsapprevious(e)}};M.prototype.onsapnextmodifiers=function(e){if(!this._shouldPreventModifier(e)){this.onsapnext(e)}};M.prototype.onsaphomemodifiers=function(e){this._selectRange(false);this.scrollToStart()};M.prototype.onsappageupmodifiers=function(e){this._selectRange(false);this.scrollToStart()};M.prototype.onsapendmodifiers=function(e){this._selectRange(true);this.scrollToEnd()};M.prototype.onsappagedownmodifiers=function(e){this._selectRange(true);this.scrollToEnd()};M.prototype._selectRange=function(e){var t={},o=this._getVisibleTokens(),i=l.closestTo(document.activeElement),n=o.indexOf(i);if(!i||!i.isA("sap.m.Token")){return}if(e){t.start=n;t.end=o.length-1}else{t.start=0;t.end=n}if(t.start<t.end){for(var s=t.start;s<=t.end;s++){o[s].setSelected(true)}}};M.prototype._copy=function(){this._fillClipboard("copy")};M.prototype._fillClipboard=function(e){var t=this.getSelectedTokens();var o=t.map(function(e){return e.getText()}).join("\r\n");var i=function(e){if(e.clipboardData){e.clipboardData.setData("text/plain",o)}else{e.originalEvent.clipboardData.setData("text/plain",o)}e.preventDefault()};document.addEventListener(e,i);document.execCommand(e);document.removeEventListener(e,i)};M.prototype._cut=function(){var e=this.getSelectedTokens();this._fillClipboard("cut");this.fireTokenChange({type:M.TokenChangeType.Removed,token:e,tokens:e,addedTokens:[],removedTokens:e});this.fireTokenUpdate({type:M.TokenChangeType.Removed,addedTokens:[],removedTokens:e});this.fireTokenDelete({tokens:e})};M.prototype._ensureTokenVisible=function(e){if(!e||!e.getDomRef()||!this.getDomRef()){return}var o=this.$().offset().left,i=this.$().width(),n=e.$().offset().left,s=t.getRTL(),r=s?parseInt(e.$().css("margin-left")):parseInt(e.$().css("margin-right")),a=parseInt(e.$().css("border-left-width"))+parseInt(e.$().css("border-right-width")),l=e.$().width()+r+a,d=s?this.$().scrollLeftRTL():this.$().scrollLeft(),h=d-o+n,p=d+(n-o+l-i);if(this._getVisibleTokens().indexOf(e)===0){this.$().scrollLeft(0);return}if(n<o){s?this.$().scrollLeftRTL(h):this.$().scrollLeft(h)}if(n-o+l>i){s?this.$().scrollLeftRTL(p):this.$().scrollLeft(p)}};M.prototype.onfocusin=function(e){this.setRenderMode(v.Loose);this.fireRenderModeChange({renderMode:"Loose"});this._bFocusFirstToken=e.srcControl===this.getTokens()[0];if(!this._bFocusFirstToken&&!this._bTokenToBeDeleted){this._ensureTokenVisible(e.srcControl)}};M.prototype.onmousedown=function(e){this._bTokenToBeDeleted=e.target.matches(".sapMTokenIcon, .sapMTokenIcon *")};M.prototype.ontap=function(e){var t=e.shiftKey,o=e.ctrlKey||e.metaKey,i=e.getMark("tokenTap"),n=e.getMark("tokenDeletePress"),s=this._getVisibleTokens(),r,a,l,d,h;if(n||!i||!t&&o){this._oSelectionOrigin=null;return}if(!t){this._oSelectionOrigin=i;this._changeAllTokensSelection(false,i,true)}r=i;if(this._oSelectionOrigin){r=this._oSelectionOrigin}else{this._oSelectionOrigin=r}if(i&&this.hasOneTruncatedToken()){this._handleNMoreIndicatorPress();return}a=this.indexOfToken(r);l=this.indexOfToken(i);d=Math.min(a,l);h=Math.max(a,l);s.forEach(function(e,o){if(o>=d&&o<=h&&t){e.setSelected(i.getSelected())}})};M.prototype.onsapprevious=function(e){var t=this._getVisibleTokens(),o=t.length;e.preventDefault();if(o===0){return}var i=l.closestTo(document.activeElement);var n=i?t.indexOf(i):-1;if(n===0){e.setMarked("forwardFocusToParent");return}var s,r;if(n>0){s=t[n-1];this._ensureTokenVisible(s);s.focus()}else{s=t[t.length-1];this._ensureTokenVisible(s);s.focus({preventScroll:true})}if(e.shiftKey){r=t[n];s.setSelected(true);r.setSelected(true)}e.setMarked()};M.prototype.onsapnext=function(e){var t=this._getVisibleTokens(),o=t.length;e.preventDefault();if(o===0){return}var i=l.closestTo(document.activeElement);var n=i?t.indexOf(i):-1;var s=t[n+1];this._ensureTokenVisible(s);if(n<o-1){var r=t[n];s.focus();if(e.shiftKey){s.setSelected(true);r.setSelected(true)}}else{e.setMarked("forwardFocusToParent");return}e.setMarked()};M.prototype.addValidator=function(e){k.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this)};M.prototype.removeValidator=function(e){k.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this)};M.prototype.removeAllValidators=function(){k.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this)};M.prototype.addValidateToken=function(e){k.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this)};M.prototype._parseString=function(e){return e.split(/\r\n|\r|\n/g)};M.prototype.checkFocus=function(){var e=g(this.getTokensPopup().getDomRef(),document.activeElement);return this.getDomRef()&&g(this.getDomRef(),document.activeElement)||e};M.prototype.selectAllTokens=function(e){if(e===undefined){e=true}this._changeAllTokensSelection(e);return this};M.prototype._changeAllTokensSelection=function(e,t,o){var i=this._getVisibleTokens();i.filter(function(e){return e!==t}).forEach(function(t){t.setSelected(e)});if(!o){this._doSelect()}return this};M.prototype.getSelectedTokens=function(){return this._getVisibleTokens().filter(function(e){return e.getSelected()})};["onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(e){M.prototype[e]=function(t){if(e==="onsaphome"||e==="onsappageup"){var o=this.getTokens().filter(function(e){return e.getDomRef()&&!e.getDomRef().classList.contains("sapMHiddenToken")});o.length&&o[0].focus();this.scrollToStart();t.preventDefault();return}var i=this._getVisibleTokens(),n=i[i.length-1];if(n.getDomRef()!==document.activeElement){n.focus();this.scrollToEnd();t.stopPropagation()}else{t.setMarked("forwardFocusToParent")}t.preventDefault()}});M.prototype.setShouldRenderTabIndex=function(e){this._bShouldRenderTabIndex=e};M.prototype.getEffectiveTabIndex=function(){return this._bShouldRenderTabIndex===null?!!this.getTokens().length:this._bShouldRenderTabIndex};M.prototype.onclick=function(e){if(!this.getEnabled()){return}this._nMoreIndicatorPressed=!this.hasOneTruncatedToken()&&!this.hasStyleClass("sapMTokenizerIndicatorDisabled")&&e.target.classList.contains("sapMTokenizerIndicator");if(this._nMoreIndicatorPressed){this._handleNMoreIndicatorPress()}};M.prototype.ontouchstart=function(e){e.setMarked();if(p.browser.chrome&&window.getSelection()){window.getSelection().removeAllRanges()}};M.prototype.exit=function(){this._deregisterResizeHandler();if(this._oTokensList){this._oTokensList.destroy();this._oTokensList=null}if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._oPopup){this._oPopup.destroy();this._oPopup=null}this._oTokensWidthMap=null;this._oIndicator=null;this._aTokenValidators=null;this._bShouldRenderTabIndex=null;this._bThemeApplied=false};M.prototype._deregisterResizeHandler=function(){if(this._sResizeHandlerId){c.deregister(this._sResizeHandlerId);delete this._sResizeHandlerId}};M.prototype._setTokensAria=function(){var e=this._getVisibleTokens().length;var t;var o="";var i="";var n={0:"TOKENIZER_ARIA_NO_TOKENS",1:"TOKENIZER_ARIA_CONTAIN_ONE_TOKEN"};if(r.isAccessibilityEnabled()){t=this.getAggregation("_tokensInfo");i=n[e]?n[e]:"TOKENIZER_ARIA_CONTAIN_SEVERAL_TOKENS";o=C.getText(i,[e]);t.setText(o)}};M.prototype._doSelect=function(){if(this.checkFocus()&&this._bCopyToClipboardSupport){var e=document.activeElement;var t=window.getSelection();t.removeAllRanges();if(this.getSelectedTokens().length){var o=document.createRange();o.selectNodeContents(this.getDomRef("clip"));t.addRange(o)}if(window.clipboardData&&e.id===this.getId()+"-clip"&&this.getDomRef()){this.getDomRef().focus()}}};M.prototype._setHiddenTokensCount=function(e){e=this.validateProperty("hiddenTokensCount",e);return this.setProperty("hiddenTokensCount",e)};M.prototype.getHiddenTokensCount=function(){return this.getProperty("hiddenTokensCount")};M.prototype.getTokensInfoId=function(){return this.getAggregation("_tokensInfo").getId()};M.prototype._handleBackspace=function(e,t){var o=this.getTokens();if(o[e-1]){return o[e-1].focus()}return t()};M.prototype._handleDelete=function(e,t){var o=this.getTokens();if(o[e+1]){return o[e+1].focus()}return t()};M.prototype.focusToken=function(e,t,o){var i=this.getTokens();var n=t.keyCode;var s=t.keyCode===T.BACKSPACE;if(i.length===0){return}if(!n){return}if(s){return this._handleBackspace(e,o)}return this._handleDelete(e,o)};M.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};M.TokenUpdateType={Added:"added",Removed:"removed"};return M});
//# sourceMappingURL=Tokenizer.js.map