/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ListItemBase","./library","sap/ui/core/IconPool","sap/ui/core/Icon","./TreeItemBaseRenderer","sap/ui/core/Lib","sap/ui/events/KeyCodes"],function(e,t,r,o,n,i,s){"use strict";var p=t.ListMode;var a=e.extend("sap.m.TreeItemBase",{metadata:{library:"sap.m"},renderer:n});a.prototype.ExpandedIconURI=r.getIconURI("navigation-down-arrow");a.prototype.CollapsedIconURI=r.getIconURI("navigation-right-arrow");a.prototype.getTree=function(){var e=this.getParent();if(e&&e.isA("sap.m.Tree")){return e}};a.prototype.getList=a.prototype.getTree;a.prototype.informTree=a.prototype.informList;a.prototype.getItemNodeContext=function(){var e=this.getTree();var t=this._getTreeBindingProxy();var r=null;if(t){r=t.getNodeByIndex(e.indexOfItem(this))}return r};a.prototype.getParentNode=function(){if(this.isTopLevel()){return}var e=this.getTree(),t=this.getLevel(),r=null,o=e.indexOfItem(this)-1,n=e.getItems(),i;while(o>=0){i=n[o].getLevel();if(i===t-1){r=n[o];break}o--}return r};a.prototype.getParentNodeContext=function(){return this.getItemNodeContext().parent};a.prototype.isLeaf=function(){var e=this.getTree(),t=this._getTreeBindingProxy();if(t){var r=e.indexOfItem(this);return t.isLeaf(r)}return false};a.prototype.isTopLevel=function(){return this.getLevel()===0};a.prototype.getLevel=function(){return(this.getItemNodeContext()||{}).level};a.prototype.getExpanded=function(){var e=this.getTree(),t=this._getTreeBindingProxy();if(!e||!t){return false}var r=e.indexOfItem(this);return t.isExpanded(r)};a.prototype.setSelected=function(t){e.prototype.setSelected.apply(this,arguments);var r=this.getTree();var o=r?r.getBinding("items"):null;var n=-1;if(r&&o){n=r.indexOfItem(this);if(r.getMode()===p.SingleSelect){o.setSelectedIndex(n)}if(r.getMode()===p.MultiSelect){if(t){o.addSelectionInterval(n,n)}else{o.removeSelectionInterval(n,n)}}}return this};a.prototype._getExpanderControl=function(){var e=this.CollapsedIconURI,t=i.getResourceBundleFor("sap.m"),r=t.getText("TREE_ITEM_EXPAND_NODE");if(this.getExpanded()){e=this.ExpandedIconURI;r=t.getText("TREE_ITEM_COLLAPSE_NODE")}if(this._oExpanderControl){this._oExpanderControl.setSrc(e);this._oExpanderControl.setTooltip(r);return this._oExpanderControl}this._oExpanderControl=new o({id:this.getId()+"-expander",src:e,tooltip:r,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMTreeItemBaseExpander").attachPress(function(e){this.informTree("ExpanderPressed")},this);return this._oExpanderControl};a.prototype.invalidate=function(){e.prototype.invalidate.apply(this,arguments);this._bInvalidated=true};a.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);this._bInvalidated=false};a.prototype.setBindingContext=function(){e.prototype.setBindingContext.apply(this,arguments);this.invalidate();return this};a.prototype._getPadding=function(){var e=this.getTree(),t=this.getLevel(),r=0,o;if(e){o=e.getDeepestLevel()}if(o<t){e._iDeepestLevel=t;o=e._iDeepestLevel}if(o<2){r=t*1.5}else if(o===2){r=t*1}else if(o<6){r=t*.5}else{r=t*.25}return r};a.prototype.onsapplus=function(e){this.informTree("ExpanderPressed",true)};a.prototype.onsapminus=function(e){this.informTree("ExpanderPressed",false)};a.prototype.onsapright=function(e){if(e.srcControl!==this||this.isLeaf()){return}if(!this.getExpanded()){this.informTree("ExpanderPressed",true)}else{e.keyCode=s.ARROW_DOWN}};a.prototype.onsapleft=function(e){if(e.srcControl!==this||this.isTopLevel()&&!this.getExpanded()){return}if(!this.isLeaf()){if(this.getExpanded()){this.informTree("ExpanderPressed",false)}else{this.getParentNode().focus()}}else{this.getParentNode().focus()}};a.prototype.onsapbackspace=function(e){if(e.srcControl!==this){return}if(!this.isTopLevel()){this.getParentNode().focus()}};a.prototype.getAccessibilityType=function(e){return e.getText("ACC_CTR_TYPE_TREEITEM")};a.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this.destroyControls(["Expander"])};a.prototype.onlongdragover=function(e){this.informTree("LongDragOver")};a.prototype._getTreeBindingProxy=function(){var e=this.getTree();if(e){return e._oProxy}};return a});
//# sourceMappingURL=TreeItemBase.js.map