/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/model/json/JSONModel","sap/ui/model/base/ManagedObjectModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/base/ManagedObjectObserver","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/core/Item","sap/ui/layout/HorizontalLayout","sap/ui/layout/Grid","sap/m/SearchField","sap/m/RadioButton","sap/m/ColumnListItem","sap/m/Column","sap/m/Text","sap/m/Bar","sap/m/Table","sap/m/Page","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/m/CheckBox","sap/m/Dialog","sap/m/Input","sap/m/Label","sap/m/Title","sap/m/ResponsivePopover","sap/m/SelectList","sap/m/ObjectIdentifier","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/VBox","sap/m/HBox","sap/m/IllustratedMessage","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/library","sap/m/library"],function(e,t,i,a,s,o,n,r,l,h,g,u,d,p,f,c,_,m,y,M,T,v,V,A,I,S,b,C,N,D,x,E,R,O,w,P,F,L,K,B,G,k){"use strict";var U=k.OverflowToolbarPriority;var $=k.ButtonType;var H=k.FlexAlignItems;var j=k.PlacementType;var z=k.PopinDisplay;var X=k.ScreenSize;var W=k.ListKeyboardMode;var q=k.Sticky;var Y=G.ValueState;var J=G.TextAlign;var Q=G.TitleLevel;const Z=k.IllustratedMessageSize;var ee=h.extend("sap.m.VariantManagement",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.m.IOverflowToolbarContent","sap.m.IToolbarInteractiveControl"],library:"sap.m",designtime:"sap/m/designtime/VariantManagement.designtime",properties:{supportDefault:{type:"boolean",group:"Misc",defaultValue:true},supportFavorites:{type:"boolean",group:"Misc",defaultValue:true},supportApplyAutomatically:{type:"boolean",group:"Misc",defaultValue:true},supportPublic:{type:"boolean",group:"Misc",defaultValue:true},supportContexts:{type:"boolean",group:"Misc",defaultValue:false},selectedKey:{type:"string",group:"Misc",defaultValue:""},defaultKey:{type:"string",group:"Misc",defaultValue:""},showSaveAs:{type:"boolean",group:"Misc",defaultValue:true},creationAllowed:{type:"boolean",group:"Misc",defaultValue:true},showFooter:{type:"boolean",group:"Misc",defaultValue:true},modified:{type:"boolean",group:"Misc",defaultValue:false},popoverTitle:{type:"string",group:"Misc",defaultValue:""},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},level:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:Q.Auto},titleStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:Q.Auto},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},_displayTextForExecuteOnSelectionForStandardVariant:{type:"string",group:"Misc",defaultValue:"",visibility:"hidden"},_showAsText:{type:"boolean",group:"Misc",defaultValue:false,visibility:"hidden"},_selectStategyForSameItem:{type:"boolean",group:"Misc",defaultValue:true,visibility:"hidden"},_standardKey:{type:"string",group:"Misc",defaultValue:"",visibility:"hidden"}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.VariantItem",multiple:true,singularName:"item"}},events:{save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},def:{type:"boolean"},public:{type:"boolean"},contexts:{type:"object[]"},tile:{type:"boolean"}}},cancel:{},manageCancel:{},manage:{parameters:{renamed:{type:"sap.m.VariantManagementRename[]"},deleted:{type:"string[]"},exe:{type:"sap.m.VariantManagementExe[]"},fav:{type:"sap.m.VariantManagementFav[]"},def:{type:"string"},contexts:{type:"object[]"}}},select:{parameters:{key:{type:"string"}}}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t).style("max-width",t.getMaxWidth()).class("sapMVarMngmt").openEnd();e.renderControl(t.oVariantLayout);e.close("div")}}});ee.INNER_MODEL_NAME="$sapMInnerVariants";ee.MAX_NAME_LEN=100;ee.COLUMN_FAV_IDX=0;ee.COLUMN_NAME_IDX=1;ee.COLUMN_DEFAULT_IDX=3;ee.prototype.init=function(){h.prototype.init.apply(this,arguments);this._oRb=t.getResourceBundleFor("sap.m");this._oManagedObjectModel=new a(this);this.setModel(this._oManagedObjectModel,"$mVariants");this._oObserver=new n(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["items"]})};ee.prototype._observeChanges=function(e){var t;if(e.type==="aggregation"){if(e.name==="items"){t=e.child;switch(e.mutation){case"insert":if(!this._oObserver.isObserved(t,{properties:["title","favorite","executeOnSelect","contexts"]})){this._oObserver.observe(t,{properties:["title","favorite","executeOnSelect","contexts"]})}if(this.getSelectedKey()===t.getKey()){this.refreshTitle()}break;case"remove":if(this._oObserver.isObserved(t,{properties:["title","favorite","executeOnSelect","contexts"]})){this._oObserver.unobserve(t,{properties:["title","favorite","executeOnSelect","contexts"]})}break;default:B.error("operation "+e.mutation+" not yet implemented")}}}else if(e.type==="property"){if(e.object.isA&&e.object.isA("sap.m.VariantItem")){t=e.object;if(t){if(this.getSelectedKey()===t.getKey()){this.refreshTitle()}if(!this.oManagementTable||this.oManagementTable.getItems&&this.oManagementTable.getItems().length===0){if(e.name==="title"){t._setOriginalTitle(e.current)}else if(e.name==="favorite"){t._setOriginalFavorite(e.current)}else if(e.name==="executeOnSelect"){t._setOriginalExecuteOnSelect(e.current)}else if(e.name==="contexts"){t._setOriginalContexts(e.current)}}}}}};ee.prototype.applySettings=function(e,t){h.prototype.applySettings.apply(this,arguments);this._createInnerModel();this._initializeControl()};ee.prototype.getDisplayTextForExecuteOnSelectionForStandardVariant=function(){return this.getProperty("_displayTextForExecuteOnSelectionForStandardVariant")};ee.prototype.setDisplayTextForExecuteOnSelectionForStandardVariant=function(e){this.setProperty("_displayTextForExecuteOnSelectionForStandardVariant",e);return this};ee.prototype.setShowAsText=function(e){this.setProperty("_showAsText",e);this._reCreateVariantTextControl();return this};ee.prototype.getShowAsText=function(){return this.getProperty("_showAsText")};ee.prototype.setShowFooter=function(e){this.setProperty("showFooter",e);return this};ee.prototype.setDefaultKey=function(e){this.setProperty("defaultKey",e);return this};ee.prototype.setPopoverTitle=function(e){this.setProperty("popoverTitle",e);return this};ee.prototype._createVariantTextControl=function(){var e=this.getShowAsText()?y:D;var t=new e(this.getId()+"-text",{text:{path:"/selectedKey",model:"$mVariants",formatter:function(e){var t="";if(e){t=this.getSelectedVariantText(e);this._setInvisibleText(t,this.getModified())}return t}.bind(this)}});if(t.isA("sap.m.Title")){t.bindProperty("level",{path:"/level",model:"$mVariants"});t.bindProperty("titleStyle",{path:"/titleStyle",model:"$mVariants"})}t.addStyleClass("sapMVarMngmtClickable");t.addStyleClass("sapMVarMngmtTitle");return t};ee.prototype._initializeControl=function(){if(this.oVariantInvisibleText){return}this.oVariantInvisibleText=new l;this.oVariantText=this._createVariantTextControl();var e=new y(this.getId()+"-modified",{text:"*",visible:{path:"/modified",model:"$mVariants",formatter:function(e){var t=this.getSelectedKey();if(t){this._setInvisibleText(this.getSelectedVariantText(t),e)}return e===null||e===undefined?false:e}.bind(this)}});e.setVisible(false);e.addStyleClass("sapMVarMngmtModified");e.addStyleClass("sapMVarMngmtClickable");this.oVariantPopoverTrigger=new I(this.getId()+"-trigger",{icon:"sap-icon://slim-arrow-down",type:$.Transparent,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_TRIGGER_TT"),enabled:{path:"/isDesignMode",model:ee.INNER_MODEL_NAME,formatter:function(e){return!e}}});this.oVariantPopoverTrigger.addAriaLabelledBy(this.oVariantInvisibleText);this.oVariantPopoverTrigger.addStyleClass("sapMVarMngmtClickable");this.oVariantLayout=new d({content:[this.oVariantText,e,this.oVariantPopoverTrigger]});this.oVariantLayout.addStyleClass("sapMVarMngmtLayout");this.oVariantLayout.addStyleClass("sapMVarMngmtLayoutModifiedHidden");e.setVisible(false);this.oVariantModifiedText=e;this.oVariantInvisibleText.toStatic();this.addDependent(this.oVariantLayout)};ee.prototype._reCreateVariantTextControl=function(){if(!this.getShowAsText()&&this.oVariantText&&this.oVariantText.isA("sap.m.Title)")){return}if(!this.getShowAsText()&&this.oVariantText&&this.oVariantText.isA("sap.m.Text)")){return}if(this.oVariantText){this.oVariantLayout.removeContent(0);this.oVariantText.destroy()}var e=this._createVariantTextControl();this.oVariantLayout.insertContent(e,0);this.oVariantText=e};ee.prototype.getOverflowToolbarConfig=function(){return{canOverflow:false,invalidationEvents:["save","manage","select"]}};ee.prototype.getTitle=function(){return this.oVariantText};ee.prototype.refreshTitle=function(){if(this.oVariantText){this.oVariantText.getBinding("text").refresh(true)}};ee.prototype._setInvisibleText=function(e,t){var i;if(e){if(t){i="VARIANT_MANAGEMENT_SEL_VARIANT_MOD";this.oVariantLayout.removeStyleClass("sapMVarMngmtLayoutModifiedHidden")}else{i="VARIANT_MANAGEMENT_SEL_VARIANT";this.oVariantLayout.addStyleClass("sapMVarMngmtLayoutModifiedHidden")}this.oVariantInvisibleText.setText(this._oRb.getText(i,[e]))}};ee.prototype._createInnerModel=function(){var e=new i({showCreateTile:false,isDesignMode:false,hasNoData:false});this.setModel(e,ee.INNER_MODEL_NAME)};ee.prototype._getShowCreateTile=function(){return this._getInnerModelProperty("/showCreateTile")};ee.prototype._setShowCreateTile=function(e){this._setInnerModelProperty("/showCreateTile",e)};ee.prototype.getDesignMode=function(){return this._getInnerModelProperty("/isDesignMode")};ee.prototype.setDesignMode=function(e){this._setInnerModelProperty("/isDesignMode",e)};ee.prototype.setHasNoData=function(e){this._setInnerModelProperty("/hasNoData",e)};ee.prototype._setInnerModelProperty=function(e,t){var i=this.getModel(ee.INNER_MODEL_NAME);if(i){i.setProperty(e,t)}};ee.prototype._getInnerModelProperty=function(e){var t=this.getModel(ee.INNER_MODEL_NAME);if(t){return t.getProperty(e)}return null};ee.prototype._getItems=function(){return this.getItems()};ee.prototype.getSelectedVariantText=function(e){var t=this._getItemByKey(e);if(t){return t.getTitle()}return""};ee.prototype.getStandardVariantKey=function(){var e=this.getProperty("_standardKey");if(!e){return this._getFirstVisibleVariant()}return e};ee.prototype.setStandardVariantKey=function(e){this.setProperty("_standardKey",e)};ee.prototype._getFirstVisibleVariant=function(){var e=this._getItems();for(var t=0;t<e.length;t++){if(!this._isItemDeleted(e[t])){if(this.getSupportFavorites()){if(e[t].getFavorite()){return e[t].getKey()}}else{return e[t].getKey()}}}return null};ee.prototype._clearDeletedItems=function(){this._aDeletedItems=[]};ee.prototype._addDeletedItem=function(e){var t=e.getKey();if(this._aDeletedItems.indexOf(t)<0){this._aDeletedItems.push(t)}};ee.prototype._getDeletedItems=function(){return this._aDeletedItems};ee.prototype._clearRenamedItems=function(){this._aRenamedItems=[]};ee.prototype._addRenamedItem=function(e){var t=e.getKey();if(this._aRenamedItems.indexOf(t)<0){this._aRenamedItems.push(t)}};ee.prototype._removeRenamedItem=function(e){var t=e.getKey();var i=this._aRenamedItems.indexOf(t);if(i>=0){this._aRenamedItems.splice(i,1)}};ee.prototype._getRenamedItems=function(){return this._aRenamedItems};ee.prototype.getItemByKey=function(e){return this._getItemByKey(e)};ee.prototype._getItemByKey=function(e){var t=null;var i=this._getItems();if(i){i.some(function(i){if(i.getKey()===e){t=i}return t!==null})}return t};ee.prototype._obtainControl=function(t){if(t&&t.target&&t.target.id){var i=t.target.id;var a=i.indexOf("-inner");if(a>0){i=i.substring(0,a)}return e.getElementById(i)}return null};ee.prototype.handleOpenCloseVariantPopover=function(e){if(!this.bPopoverOpen){this._oCtrlRef=this._obtainControl(e);this._openVariantList()}else if(this.oVariantPopOver&&this.oVariantPopOver.isOpen()){this.oVariantPopOver.close()}else if(this.getInErrorState()&&this.oErrorVariantPopOver&&this.oErrorVariantPopOver.isOpen()){this.oErrorVariantPopOver.close()}};ee.prototype.getFocusDomRef=function(){return this.oVariantPopoverTrigger.getFocusDomRef()};ee.prototype.onclick=function(e){if(this.getDesignMode()){return}if(this.oVariantPopoverTrigger&&!this.bPopoverOpen){this.oVariantPopoverTrigger.focus()}this.handleOpenCloseVariantPopover(e)};ee.prototype.onkeyup=function(e){if(e.which===K.F4||e.which===K.SPACE||e.altKey===true&&e.which===K.ARROW_UP||e.altKey===true&&e.which===K.ARROW_DOWN){this._oCtrlRef=this._obtainControl(e);this._openVariantList()}};ee.prototype.onAfterRendering=function(){if(this.oVariantText){this.oVariantText.$().off("mouseover").on("mouseover",function(){this.oVariantPopoverTrigger.addStyleClass("sapMVarMngmtTriggerBtnHover")}.bind(this));this.oVariantText.$().off("mouseout").on("mouseout",function(){this.oVariantPopoverTrigger.removeStyleClass("sapMVarMngmtTriggerBtnHover")}.bind(this))}};ee.prototype._openInErrorState=function(){var e;if(!this.oErrorVariantPopOver){e=new P({fitContainer:true,alignItems:H.Center,items:[new g({size:"4rem",color:"lightgray",src:"sap-icon://message-error"}),new D({titleStyle:Q.H2,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT1")}),new y({textAlign:J.Center,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT2")})]});e.addStyleClass("sapMVarMngmtErrorPopover");this.oErrorVariantPopOver=new x(this.getId()+"-errorpopover",{title:{path:"/popoverTitle",model:"$mVariants"},contentWidth:"400px",placement:j.VerticalPreferredBottom,content:[new v(this.getId()+"-errorselpage",{showSubHeader:false,showNavButton:false,showHeader:false,content:[e]})],afterOpen:function(){this.bPopoverOpen=true}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false}.bind(this),200)}}.bind(this),contentHeight:"300px"});this.oErrorVariantPopOver.attachBrowserEvent("keyup",function(e){if(e.which===32){this.oErrorVariantPopOver.close()}}.bind(this))}if(this.bPopoverOpen){return}this.oErrorVariantPopOver.openBy(this.oVariantLayout)};ee.prototype._createIllustratedMessages=function(){if(!this._oNoDataIllustratedMessage||this._oNoDataIllustratedMessage.bIsDestroyed){this._oNoDataIllustratedMessage=new L({title:this._oRb.getText("VARIANT_MANAGEMENT_NODATA"),description:this._oRb.getText("VARIANT_MANAGEMENT_NODATA_DESCR"),enableVerticalResponsiveness:true,illustrationSize:Z.Auto,illustrationType:k.IllustratedMessageType.NoEntries})}if(!this._oNoDataFoundIllustratedMessage||this._oNoDataFoundIllustratedMessage.bIsDestroyed){this._oNoDataFoundIllustratedMessage=new L({title:this._oRb.getText("VARIANT_MANAGEMENT_NODATA_FOUND"),description:this._oRb.getText("VARIANT_MANAGEMENT_NODATA_FOUND_DESCR"),enableVerticalResponsiveness:true,illustrationSize:Z.Auto,illustrationType:k.IllustratedMessageType.NoSearchResults});this._oNoDataFoundIllustratedMessage.addStyleClass("sapMVarMngmtIllustratedMessage")}};ee.prototype._createVariantList=function(){if(this.oVariantPopOver){return}this._createIllustratedMessages();this.oVariantManageBtn=new I(this.getId()+"-manage",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGE"),enabled:true,press:function(){this._openManagementDialog()}.bind(this),layoutData:new w({priority:U.Low})});this.oVariantSaveBtn=new I(this.getId()+"-mainsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),press:function(){this._handleVariantSave()}.bind(this),visible:{parts:[{path:"$mVariants>/creationAllowed"},{path:"$mVariants>/modified"},{path:"$mVariants>/selectedKey"}],formatter:function(e,t,i){var a=false;var s=this._getItemByKey(i);if(s){a=s.getChangeable()}return e&&t&&a}.bind(this)},type:$.Emphasized,layoutData:new w({priority:U.Low})});this.oVariantSaveAsBtn=new I(this.getId()+"-saveas",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVEAS"),press:function(){this._openSaveAsDialog()}.bind(this),layoutData:new w({priority:U.Low}),visible:{parts:[{path:"$mVariants>/creationAllowed"},{path:"$mVariants>/showSaveAs"}],formatter:function(e,t){return e&&t}}});this.oVariantList=new E(this.getId()+"-list",{selectedKey:{path:"/selectedKey",model:"$mVariants"},visible:{path:"/hasNoData",model:ee.INNER_MODEL_NAME,formatter:function(e){return!e}},itemPress:function(e){var t=null;if(e&&e.getParameters()){var i=e.getParameters().item;if(i){t=i.getKey()}}if(t){this.setCurrentVariantKey(t);this.oVariantPopOver.close()}}.bind(this)});this.oVariantListInvisibleText=new l({text:this._oRb.getText("VARIANT_MANAGEMENT_VIEW_LIST")});this.oVariantListInvisibleText.toStatic();this.oVariantList.addAriaLabelledBy(this.oVariantListInvisibleText);this.oNodataTextLayout=new P(this.getId()+"-no-data",{visible:{path:"/hasNoData",model:ee.INNER_MODEL_NAME},fitContainer:true,items:[this._oNoDataFoundIllustratedMessage]});var e=new u({key:"{$mVariants>key}",text:"{$mVariants>title}"});this.oVariantList.bindAggregation("items",{path:"/items",model:"$mVariants",template:e});this._oSearchField=new f(this.getId()+"-search");this._oSearchField.attachLiveChange(function(e){this._triggerSearch(e,this.oVariantList)}.bind(this));this.oVariantSelectionPage=new v(this.getId()+"-selpage",{subHeader:new V({content:[this._oSearchField]}),content:[this.oVariantList,this.oNodataTextLayout],footer:new O({content:[new A(this.getId()+"-spacer"),this.oVariantSaveBtn,this.oVariantSaveAsBtn,this.oVariantManageBtn]}),showNavButton:false,showHeader:false});this.oVariantSelectionPage.bindProperty("showFooter",{path:"/showFooter",model:"$mVariants"});this.oVariantPopOver=new x(this.getId()+"-popover",{title:{path:"/popoverTitle",model:"$mVariants"},titleAlignment:"Auto",contentWidth:"400px",placement:j.VerticalPreferredBottom,resizable:true,content:[this.oVariantSelectionPage],afterOpen:function(){this.bPopoverOpen=true}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false}.bind(this),200)}}.bind(this),contentHeight:"300px"});this.oVariantPopOver.addStyleClass("sapMVarMngmtPopover");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oVariantPopOver.addStyleClass("sapUiSizeCompact")}this.addDependent(this.oVariantPopOver);this.oVariantPopOver.isPopupAdaptationAllowed=function(){return false}};ee.prototype.setCurrentVariantKey=function(e){var t=this.getItemByKey(e);if(t){var i=this.getProperty("_selectStategyForSameItem");if(i||!i&&this.getSelectedKey()!==e){this.setSelectedKey(e);this.setModified(false);this.fireSelect({key:e})}}else{B.error("setCurrentVariantKey called with unknown key:'"+e+"'")}};ee.prototype._determineEmphasizedFooterButton=function(){if(this.oVariantSaveBtn.getVisible()){this.oVariantSaveBtn.setType($.Emphasized);this.oVariantSaveAsBtn.setType($.Default)}else{this.oVariantSaveAsBtn.setType($.Emphasized)}};ee.prototype.setModified=function(e){this.setProperty("modified",e);return this};ee.prototype._openVariantList=function(){if(this.getInErrorState()){this._openInErrorState();return}if(this.bPopoverOpen){return}this._createVariantList();this._oSearchField.setValue("");const e=this.oVariantList.getBinding("items");e.attachChange(function(e){this.setHasNoData(this.oVariantList.getItems().length===0)}.bind(this));e.filter(this._getFilters());if(this.oVariantList.getItems().length<1){this.oNodataTextLayout.removeAllItems();this.oNodataTextLayout.addItem(this._oNoDataIllustratedMessage)}this.oVariantSelectionPage.setShowSubHeader(this.oVariantList.getItems().length>9);this._determineEmphasizedFooterButton();var t=this.oVariantList.getSelectedItem();if(t){this.oVariantPopOver.setInitialFocus(t.getId())}var i=this._oCtrlRef?this._oCtrlRef:this.oVariantLayout;this._oCtrlRef=null;this.oVariantPopOver.openBy(i)};ee.prototype._triggerSearch=function(e,t){if(!e){return}var i=e.getParameters();if(!i){return}var a=i.newValue?i.newValue:"";var n=new s({path:"title",operator:o.Contains,value1:a});t.getBinding("items").filter(this._getFilters(n));if(t.getItems().length<1){if(this.oNodataTextLayout.getItems().length===0||this.oNodataTextLayout.getItems().length>0&&this.oNodataTextLayout.getItems()[0]!==this._oNoDataFoundIllustratedMessage){if(!this._oNoDataFoundIllustratedMessage.hasStyleClass("sapMVarMngmtIllustratedMessage")){this._oNoDataFoundIllustratedMessage.toggleStyleClass("sapMVarMngmtIllustratedMessage")}this.oNodataTextLayout.removeAllItems();this.oNodataTextLayout.addItem(this._oNoDataFoundIllustratedMessage)}}};ee.prototype._createSaveAsDialog=function(){if(!this.oSaveAsDialog){this.oInputName=new C(this.getId()+"-name",{liveChange:function(){this._checkVariantNameConstraints(this.oInputName)}.bind(this)});var e=new N(this.getId()+"-namelabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")});e.setLabelFor(this.oInputName);e.addStyleClass("sapMVarMngmtSaveDialogLabel");this.oDefault=new S(this.getId()+"-default",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASDEFAULT"),visible:{path:"/supportDefault",model:"$mVariants"},select:function(e){if(this._sStyleClass){if(e.getParameter("selected")){var t=this._getContextInfoChanges();if(this._isRestricted(t)){this.oDefault.setValueState(Y.Error);this.oDefault.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NO_DEFAULT_ON_RESTRICTED_VIEWS"));this.oDefault.focus()}else{this.oDefault.setValueState(Y.None);this.oDefault.setValueStateText("")}}else if(this.oDefault.getValueState()!=Y.None){this.oDefault.setValueState(Y.None);this.oDefault.setValueStateText("")}}}.bind(this),width:"100%"});this.oPublic=new S(this.getId()+"-public",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASPUBLIC"),visible:{path:"/supportPublic",model:"$mVariants"},width:"100%"});this.oExecuteOnSelect=new S(this.getId()+"-execute",{text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),visible:{path:"/supportApplyAutomatically",model:"$mVariants"},width:"100%"});this.oCreateTile=new S(this.getId()+"-tile",{text:this._oRb.getText("VARIANT_MANAGEMENT_CREATETILE"),enabled:true,visible:{path:"/showCreateTile",model:ee.INNER_MODEL_NAME},width:"100%"});this.oSaveSave=new I(this.getId()+"-variantsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),type:$.Emphasized,press:function(){if(!this._bSaveOngoing){this._checkVariantNameConstraints(this.oInputName);if(this.oInputName.getValueState()==="Error"){this.oInputName.focus();return}this._bSaveOngoing=true;this._bSaveCanceled=false;var e=this._handleVariantSaveAs(this.oInputName.getValue());if(!e){this._bSaveOngoing=false}}}.bind(this),enabled:true});var t=new p({defaultSpan:"L12 M12 S12"});t.addContent(this.oDefault);t.addContent(this.oPublic);t.addContent(this.oExecuteOnSelect);t.addContent(this.oCreateTile);this.oSaveAsDialog=new b(this.getId()+"-savedialog",{title:this._oRb.getText("VARIANT_MANAGEMENT_SAVEDIALOG"),afterClose:function(){this._bSaveOngoing=false;if(this._sStyleClass){this.setSupportPublic(this._bShowPublic);this.oSaveAsDialog.removeStyleClass(this._sStyleClass);if(this._oRolesComponentContainer){this.oSaveAsDialog.removeContent(this._oRolesComponentContainer)}this._sStyleClass=undefined;this._oRolesComponentContainer=null}}.bind(this),beginButton:this.oSaveSave,endButton:new I(this.getId()+"-variantcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:this._cancelPressed.bind(this)}),content:[e,this.oInputName,t],stretch:r.system.phone});this.oSaveAsDialog.isPopupAdaptationAllowed=function(){return false};this.oSaveAsDialog.addStyleClass("sapUiContentPadding");this.oSaveAsDialog.addStyleClass("sapMVarMngmtSaveDialog");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oSaveAsDialog.addStyleClass("sapUiSizeCompact")}this.addDependent(this.oSaveAsDialog)}};ee.prototype._cancelPressed=function(){this._bSaveCanceled=true;this.fireCancel();this.oSaveAsDialog.close()};ee.prototype._getSelectedContexts=function(){return this._oRolesComponentContainer.getComponentInstance().getSelectedContexts()};ee.prototype._setSelectedContexts=function(e){if(!e||Object.keys(e).length===0){e={role:[]}}this._oRolesComponentContainer.getComponentInstance().setSelectedContexts(e)};ee.prototype._isInErrorContexts=function(){return this._oRolesComponentContainer.getComponentInstance().hasErrorsAndShowErrorMessage()};ee.prototype._isRestricted=function(e){if(!e){e={role:[]}}return e.role&&e.role.length>0};ee.prototype._determineRolesSpecificText=function(e,t){if(t){t.setText(this._oRb.getText(this._isRestricted(e.getContexts())?"VARIANT_MANAGEMENT_VISIBILITY_RESTRICTED":"VARIANT_MANAGEMENT_VISIBILITY_NON_RESTRICTED"))}};ee.prototype._checkAndAddRolesContainerToManageDialog=function(){if(this._oRolesComponentContainer&&this._oRolesDialog){var e=null;this._oRolesDialog.getContent().some(function(t){if(t===this._oRolesComponentContainer){e=t;return true}return false}.bind(this));if(!e){this._oRolesDialog.addContent(this._oRolesComponentContainer)}}};ee.prototype._createRolesDialog=function(){if(!this._oRolesDialog){this._oRolesDialog=new b(this.getId()+"-roledialog",{draggable:true,resizable:true,contentWidth:"40%",title:this._oRb.getText("VARIANT_MANAGEMENT_SELECTROLES_DIALOG"),beginButton:new I(this.getId()+"-rolesave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),type:$.Emphasized,press:function(){if(!this._checkAndCreateContextInfoChanges(this._oCurrentContextsKey,this._oTextControl)){return}this._oRolesDialog.close()}.bind(this)}),endButton:new I(this.getId()+"-rolecancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._oRolesDialog.close()}.bind(this)}),content:[this._oRolesComponentContainer],stretch:r.system.phone});this._oRolesDialog.setParent(this);this._oRolesDialog.addStyleClass("sapUiContentPadding");this._oRolesDialog.addStyleClass(this._sStyleClass);this._oRolesDialog.isPopupAdaptationAllowed=function(){return false}}this._checkAndAddRolesContainerToManageDialog()};ee.prototype._openRolesDialog=function(e,t){this._createRolesDialog();this._oCurrentContextsKey=e.getKey();this._oTextControl=t;this._setSelectedContexts(e.getContexts());this._oRolesDialog.open()};ee.prototype._checkAndCreateContextInfoChanges=function(e,t){if(e){if(this._oRolesComponentContainer){try{if(!this._isInErrorContexts()){var i=this._getSelectedContexts();var a=this._getItemByKey(e);if(a){a.setContexts(i);this._determineRolesSpecificText(a,t);this._checkDefaultEnabled(a)}}else{return false}}catch(e){return false}}return true}return false};ee.prototype._checkAndAddRolesContainerToSaveAsDialog=function(){if(this._oRolesComponentContainer&&this.oSaveAsDialog){var e=null;this.oSaveAsDialog.getContent().some(function(t){if(t===this._oRolesComponentContainer){e=t;return true}return false}.bind(this));this._setSelectedContexts({role:[]});if(!e){this.oSaveAsDialog.addContent(this._oRolesComponentContainer)}}};ee.prototype.openSaveAsDialog=function(e,t){this._openSaveAsDialog(true);this.oSaveAsDialog.addStyleClass(e);this._sStyleClass=e;this._bShowPublic=this.getSupportPublic();this.setSupportPublic(false);if(t){Promise.all([t]).then(function(e){this._oRolesComponentContainer=e[0];this.setSupportContexts(!!this._oRolesComponentContainer);this._checkAndAddRolesContainerToSaveAsDialog();this.oSaveAsDialog.open()}.bind(this))}else{this.oSaveAsDialog.open()}};ee.prototype._openSaveAsDialog=function(e){this._createSaveAsDialog();this.setSupportContexts(false);this.oInputName.setValue(this.getSelectedVariantText(this.getSelectedKey()));this.oInputName.setEnabled(true);this.oInputName.setValueState(Y.None);this.oInputName.setValueStateText(null);this.oDefault.setEnabled(true);this.oDefault.setSelected(false);if(this.oDefault.getValueState()!==Y.None){this.oDefault.setValueState(Y.None);this.oDefault.setValueStateText("")}this.oPublic.setSelected(false);this.oExecuteOnSelect.setSelected(false);this.oCreateTile.setSelected(false);if(this.oVariantPopOver){this.oVariantPopOver.close()}if(!e){this.oSaveAsDialog.open()}};ee.prototype._handleVariantSaveAs=function(e){var t=null;var i=e.trim();if(i===""){this.oInputName.setValueState(Y.Error);this.oInputName.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return false}var a=this._getContextInfoChanges();var s=this._isRestricted(a);if(s&&this.oDefault.getSelected()){this.oDefault.setValueState(Y.Error);this.oDefault.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NO_DEFAULT_ON_RESTRICTED_VIEWS"));this.oDefault.focus();return false}else if(!s){var o=this.oDefault.getValueState()!==Y.None;this.oDefault.setValueState(Y.None);this.oDefault.setValueStateText("");if(o){return false}}if(this.oSaveAsDialog){this.oSaveAsDialog.close()}var n={key:t,name:i,overwrite:false,def:this.oDefault.getSelected(),execute:this.oExecuteOnSelect.getSelected(),public:this.getSupportPublic()?this.oPublic.getSelected():undefined,contexts:a};if(this._getShowCreateTile()&&this.oCreateTile){n.tile=this.oCreateTile.getSelected()}this.destroyManageDialog();this.fireSave(n);return true};ee.prototype._getContextInfoChanges=function(){if(this._oRolesComponentContainer){try{if(!this._isInErrorContexts()){return this._getSelectedContexts()}}catch(e){return undefined}}return undefined};ee.prototype._handleVariantSave=function(){var e=this._getItemByKey(this.getSelectedKey());var t=false;if(this.getDefaultKey()===e.getKey()){t=true}if(this.oVariantPopOver){this.oVariantPopOver.close()}this.fireSave({name:e.getTitle(),overwrite:true,key:e.getKey(),def:t})};ee.prototype.destroyManageDialog=function(){if(this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined}};ee.prototype.openManagementDialog=function(e,t,i){if(e&&this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined}if(t){this._sStyleClass=t;this._bShowPublic=this.getSupportPublic();this.setSupportPublic(false);this.setSupportContexts(false)}if(i){Promise.all([i]).then(function(e){this._oRolesComponentContainer=e[0];this.setSupportContexts(!!this._oRolesComponentContainer);this._openManagementDialog();if(this._sStyleClass){this.oManagementDialog.addStyleClass(this._sStyleClass)}}.bind(this))}else{this._openManagementDialog();if(this._sStyleClass){this.oManagementDialog.addStyleClass(this._sStyleClass)}}};ee.prototype._triggerSearchInManageDialog=function(e,t){if(!e){return}var i=e.getParameters();if(!i){return}var a;if(i.query){a=i.query}else{a=i.newValue?i.newValue:""}this._triggerSearchInManageDialogByValue(a,t)};ee.prototype._triggerSearchInManageDialogByValue=function(e,t){var i=[this._getVisibleFilter(),new s({filters:[new s({path:"title",operator:o.Contains,value1:e}),new s({path:"author",operator:o.Contains,value1:e})],and:false})];t.getBinding("items").filter(i);if(this.oManagementTable.getItems().length<1){if(this._oNoDataFoundIllustratedMessage.hasStyleClass("sapMVarMngmtIllustratedMessage")){this._oNoDataFoundIllustratedMessage.toggleStyleClass("sapMVarMngmtIllustratedMessage")}this.oManagementTable.setNoData(this._oNoDataFoundIllustratedMessage)}this._bRebindRequired=true};ee.prototype.getManageDialog=function(){return this.oManagementDialog};ee.prototype._createManagementDialog=function(){if(!this.oManagementDialog||this.oManagementDialog.bIsDestroyed){this._createIllustratedMessages();this.oManagementTable=new T(this.getId()+"-managementTable",{contextualWidth:"Auto",fixedLayout:false,growing:true,noData:this._oNoDataIllustratedMessage,keyboardMode:W.Navigation,sticky:[q.ColumnHeaders],columns:[new m({header:new l({text:this._oRb.getText("VARIANT_MANAGEMENT_FAVORITE_COLUMN")}),width:"3rem",visible:{path:"/supportFavorites",model:"$mVariants"}}),new m({header:new y({text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")}),width:"16rem"}),new m({header:new y({text:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTTYPE"),wrappingType:"Hyphenated"}),visible:{path:"/supportPublic",model:"$mVariants"},demandPopin:true,popinDisplay:z.Inline,minScreenWidth:X.Tablet}),new m({header:new y({text:this._oRb.getText("VARIANT_MANAGEMENT_DEFAULT"),wrappingType:"Hyphenated"}),hAlign:J.Center,demandPopin:true,popinDisplay:z.Block,minScreenWidth:X.Tablet,visible:{path:"/supportDefault",model:"$mVariants"}}),new m({header:new y({text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),wrappingType:"Hyphenated"}),hAlign:this.getDisplayTextForExecuteOnSelectionForStandardVariant()?J.Begin:J.Center,demandPopin:true,popinDisplay:z.Block,minScreenWidth:X.Tablet,visible:{path:"/supportApplyAutomatically",model:"$mVariants"}}),new m({header:new y({text:this._oRb.getText("VARIANT_MANAGEMENT_VISIBILITY"),wrappingType:"Hyphenated"}),width:"8rem",demandPopin:true,popinDisplay:z.Inline,minScreenWidth:X.Tablet,visible:{path:"/supportContexts",model:"$mVariants"}}),new m({header:new y({text:this._oRb.getText("VARIANT_MANAGEMENT_AUTHOR"),wrappingType:"Hyphenated"}),demandPopin:true,popinDisplay:z.Block,minScreenWidth:X.Tablet}),new m({header:new l({text:this._oRb.getText("VARIANT_MANAGEMENT_ACTION_COLUMN")}),hAlign:J.Center}),new m({visible:false})]});this.oManagementSave=new I(this.getId()+"-managementsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),enabled:true,type:$.Emphasized,press:function(){if(this._handleManageSavePressed()&&this.oManagementDialog){this.oManagementDialog.close()}}.bind(this)});this.oManagementCancel=new I(this.getId()+"-managementcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._resumeManagementTableBinding();this._handleManageCancelPressed();if(this.oManagementDialog){this.oManagementDialog.close()}}.bind(this)});this.oManagementDialog=new b(this.getId()+"-managementdialog",{contentWidth:"64%",resizable:true,draggable:true,title:this._oRb.getText("VARIANT_MANAGEMENT_MANAGEDIALOG"),beginButton:this.oManagementSave,endButton:this.oManagementCancel,afterClose:function(){if(this._sStyleClass){this.setSupportPublic(this._bShowPublic,true);this.oManagementDialog.removeStyleClass(this._sStyleClass);this._sStyleClass=undefined;this._oRolesComponentContainer=null}}.bind(this),content:[this.oManagementTable],stretch:r.system.phone});this.oManagementDialog.isPopupAdaptationAllowed=function(){return false};this._oSearchFieldOnMgmtDialog=new f;this._oSearchFieldOnMgmtDialog.attachLiveChange(function(e){this._triggerSearchInManageDialog(e,this.oManagementTable)}.bind(this));this._oSearchFieldOnMgmtDialog.attachSearch(function(e){this._triggerSearchInManageDialog(e,this.oManagementTable)}.bind(this));var e=new M(this.getId()+"-mgmHeaderSearch",{contentMiddle:[this._oSearchFieldOnMgmtDialog]});this.oManagementDialog.setSubHeader(e);this.oManagementDialog.setInitialFocus(this._oSearchFieldOnMgmtDialog);if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oManagementDialog.addStyleClass("sapUiSizeCompact")}this.addDependent(this.oManagementDialog);this.oManagementTable.bindAggregation("items",{path:"/items",model:"$mVariants",factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});this._bRebindRequired=false}};ee.prototype._setFavoriteIcon=function(e,t){if(e){e.setSrc(t?"sap-icon://favorite":"sap-icon://unfavorite");e.setTooltip(this._oRb.getText(t?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP"));e.setAlt(this._oRb.getText(t?"VARIANT_MANAGEMENT_FAV_DEL_ACC":"VARIANT_MANAGEMENT_FAV_ADD_ACC"))}};ee.prototype._checkDefaultEnabled=function(e){var t=true;if(this._isRestricted(e.getContexts())){t=false;if(e.getKey()===this.getDefaultKey()){this.setDefaultKey(this.getStandardVariantKey())}}var i=this._getRowForKey(e.getKey());if(i){i.getCells()[ee.COLUMN_DEFAULT_IDX].setEnabled(t);this._toggleIconActivityState(i.getCells()[0],e,false)}};ee.prototype._templateFactoryManagementDialog=function(e,t){var i=null;var a;var s;var o;var n;var r=t.getObject();if(!r){B.error("couldn't obtain the item for '"+t.getPath()+"'");return undefined}var l=this._determineIndex(t.getPath());if(l<0){B.error("couldn't obtain item position for '"+t.getPath()+"'");return undefined}var h=this.getId()+"-manage";var u="$mVariants";var d=function(e){var t=e.oSource.getBindingContext(u).getObject();this._handleManageTitleChange(e.oSource,t)}.bind(this);var p=function(e){var t=e.oSource.getBindingContext(u).getObject();this._handleManageTitleChange(e.oSource,t)}.bind(this);var f=function(e){this._handleManageDefaultVariantChange(e.oSource,e.oSource.getBindingContext(u).getObject(),e.getParameters().selected)}.bind(this);var m=function(e){this._handleManageDeletePressed(e.oSource.getBindingContext(u).getObject());this._reCheckVariantNameConstraints()}.bind(this);var M=function(e){this._handleManageFavoriteChanged(e.oSource,e.oSource.getBindingContext(u).getObject())}.bind(this);var T=function(e){var t=e.oSource.getBindingContext(u).getObject();this._openRolesDialog(t,e.oSource.getParent().getItems()[0])}.bind(this);if(r.getRename()){s=new C(h+"-input-"+l,{liveChange:d,change:p,value:"{"+u+">title}"});if(r.getTitle()!==r._getOriginalTitle()){this._verifyVariantNameConstraints(s,r.getKey(),r.getTitle())}}else{s=new R(h+"-text-"+l,{title:"{"+u+">title}"});if(i){s.setTooltip(i)}}a=new I(h+"-del-"+l,{icon:"sap-icon://decline",enabled:true,type:$.Transparent,press:m,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_DELETE"),visible:r.getRemove()});var v=new g(h+"-fav-"+l,{src:{path:"favorite",model:u,formatter:function(e){return e?"sap-icon://favorite":"sap-icon://unfavorite"}},tooltip:{path:"favorite",model:u,formatter:function(e){return this._oRb.getText(e?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP")}.bind(this)},press:M,decorative:false});if(this.getStandardVariantKey()===r.getKey()||this.getDefaultKey()===r.getKey()){this._setIconStyleClass(v,"sapMVarMngmtFavNonInteractiveColor")}else{this._setIconStyleClass(v,"sapMVarMngmtFavColor")}if(this.getDisplayTextForExecuteOnSelectionForStandardVariant()&&this.getStandardVariantKey()===r.getKey()){o=new S(h+"-exe-"+l,{wrapping:true,text:"{"+u+">/_displayTextForExecuteOnSelectionForStandardVariant}",selected:"{"+u+">executeOnSelect}"})}else{o=new S(h+"-exe-"+l,{text:"",selected:"{"+u+">executeOnSelect}"})}var V;if(this._sStyleClass&&this.getSupportContexts()&&r.getKey()!==this.getStandardVariantKey()){V=new y({wrapping:false});this._determineRolesSpecificText(r,V);var A=new g({src:"sap-icon://edit",press:T});A.addStyleClass("sapMVarMngmtRolesEdit");A.setTooltip(this._oRb.getText("VARIANT_MANAGEMENT_VISIBILITY_ICON_TT"));n=new F(h+"-role-"+l,{items:[V,A]})}else{n=new y}var b=new c(h+"-def-"+l,{groupName:this.getId(),select:f,selected:{path:"/defaultKey",model:u,formatter:function(e){return r.getKey()===e}}});if(V&&this._isRestricted(r.getContexts())){b.setEnabled(false);if(this.getDefaultKey()===r.getKey()){this.setDefaultKey(this.getStandardVariantKey())}}var N=new _({cells:[v,s,new y(h+"-type-"+l,{text:{path:"sharing",model:u,formatter:function(e){return this._oRb.getText(e==="private"?"VARIANT_MANAGEMENT_PRIVATE":"VARIANT_MANAGEMENT_PUBLIC")}.bind(this)},textAlign:"Center"}),b,o,n,new y(h+"-author-"+l,{text:"{"+u+">author}",textAlign:"Begin",wrappingType:"Hyphenated"}),a,new y({text:"{"+u+">key}"})]});if(this._isItemDeleted(r)){N.setVisible(false)}return N};ee.prototype._openManagementDialog=function(){this._clearDeletedItems();this._clearRenamedItems();this._createManagementDialog();if(this.oVariantPopOver){this.oVariantPopOver.close()}this._suspendManagementTableBinding();this._sDefaultKey=this.getDefaultKey();this._sOriginalDefaultKey=this._sDefaultKey;this._oSearchFieldOnMgmtDialog.setValue("");if(this._bRebindRequired){this._bRebindRequired=false;if(!this.oManagementTable.getBinding("items")){this.oManagementTable.bindAggregation("items",{path:"/items",model:"$mVariants",factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()})}else{this.oManagementTable.getBinding("items").filter(this._getVisibleFilter())}}if(this.oManagementTable.getItems().length<1){this.oManagementTable.setNoData(this._oNoDataIllustratedMessage)}this.oManagementDialog.open()};ee.prototype._toggleIconActivityState=function(e,t,i){if(!e){return}if(!t||t.getKey()===this.getStandardVariantKey()){return}if(i&&e.hasStyleClass("sapMVarMngmtFavColor")){e.removeStyleClass("sapMVarMngmtFavColor");this._setIconStyleClass(e,"sapMVarMngmtFavNonInteractiveColor")}else if(e.hasStyleClass("sapMVarMngmtFavNonInteractiveColor")){e.removeStyleClass("sapMVarMngmtFavNonInteractiveColor");this._setIconStyleClass(e,"sapMVarMngmtFavColor")}};ee.prototype._setIconStyleClass=function(e,t){if(e){e.addStyleClass(t);e.setNoTabStop(t==="sapMVarMngmtFavNonInteractiveColor")}};ee.prototype._handleManageTitleChange=function(e,t){this._checkVariantNameConstraints(e,t.getKey());this._addRenamedItem(t)};ee.prototype._handleManageDefaultVariantChange=function(e,t,i){var a=t.getKey();if(e){var s=e.getParent().getCells()[ee.COLUMN_FAV_IDX];if(i){if(this.getSupportFavorites()&&!t.getFavorite()){t.setFavorite(true);var o=this._getRowForKey(t.getKey());if(o){var n=o.getCells();if(n){s=n[ee.COLUMN_FAV_IDX];this._setFavoriteIcon(s,true);n[ee.COLUMN_FAV_IDX+3].focus()}}}this.setDefaultKey(a)}this._toggleIconActivityState(s,t,i)}};ee.prototype._handleManageCancelPressed=function(){if(this._getDeletedItems().length>0){this._getDeletedItems().forEach(function(e){var t=this._getRowForKey(e);if(t&&!t.getVisible()){t.setVisible(true)}}.bind(this));this._clearDeletedItems()}this._resetToOriginal();if(this._sOriginalDefaultKey!==this.getDefaultKey()){var e=this.getDefaultKey();this.setDefaultKey(this._sOriginalDefaultKey);if(e!==this.getStandardVariantKey()){var t=this._getRowForKey(e);if(t){var i=t.getCells()[ee.COLUMN_FAV_IDX];this._toggleIconActivityState(i,this._getItemByKey(e),false)}}}this._clearRenamedItems();this._bRebindRequired=true;if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate()}this.fireManageCancel()};ee.prototype._handleManageFavoriteChanged=function(e,t){if(this.getStandardVariantKey()===t.getKey()){return}if(this.getDefaultKey()===t.getKey()&&t.getFavorite()){return}t.setFavorite(!t.getFavorite());var i=this._getRowForKey(t.getKey());if(i){i.getCells()[ee.COLUMN_FAV_IDX].focus()}};ee.prototype._handleManageDeletePressed=function(e){var t=e.getKey();if(!e.getRemove()){return}this._addDeletedItem(e);if(t===this.getDefaultKey()){this.setDefaultKey(this.getStandardVariantKey());if(this.getSupportFavorites()){var i=this._getItemByKey(this.getStandardVariantKey());if(i&&!i.getFavorite()){var a=this._getRowForKey(this.getStandardVariantKey());if(a){i.setFavorite(true);this._setFavoriteIcon(a.getCells()[ee.COLUMN_FAV_IDX],true)}}}}var s=this._getRowForKey(e.getKey());if(s){s.setVisible(false)}this.oManagementCancel.focus()};ee.prototype._collectManageData=function(){var e={};var t=this.getDefaultKey();if(t!==this._sOriginalDefaultKey){e.def=t}this.getItems().forEach(function(t){const i=this._isItemDeleted(t);if(i){if(!e.deleted){e.deleted=[]}e.deleted.push(t.getKey())}if(!i&&t.getFavorite()!==t._getOriginalFavorite()){if(!e.fav){e.fav=[]}e.fav.push({key:t.getKey(),visible:t.getFavorite()});t._setOriginalFavorite(t.getFavorite())}if(!i&&t.getTitle()!==t._getOriginalTitle()){if(!e.renamed){e.renamed=[]}e.renamed.push({key:t.getKey(),name:t.getTitle()});t._setOriginalTitle(t.getTitle())}if(!i&&t.getExecuteOnSelect()!==t._getOriginalExecuteOnSelect()){if(!e.exe){e.exe=[]}e.exe.push({key:t.getKey(),exe:t.getExecuteOnSelect()});t._setOriginalExecuteOnSelect(t.getExecuteOnSelect())}if(!i&&this._hasContextsChanged(t)){if(!e.contexts){e.contexts=[]}e.contexts.push({key:t.getKey(),contexts:t.getContexts()});t._setOriginalContexts(t.getContexts())}}.bind(this));return e};ee.prototype._resetToOriginal=function(){this.getItems().forEach(function(e){e.setTitle(e._getOriginalTitle());e.setFavorite(e._getOriginalFavorite());e.setExecuteOnSelect(e._getOriginalExecuteOnSelect());e.setContexts(e._getOriginalContexts())})};ee.prototype._hasContextsChanged=function(e){return JSON.stringify(e.getContexts())!==JSON.stringify(e._getOriginalContexts())};ee.prototype._handleManageSavePressed=function(){if(this._anyInErrorState(this.oManagementTable)){return false}if(this._getDeletedItems().length>0){this._bRebindRequired=true}if(this._getRenamedItems().length>0){this._bRebindRequired=true;if(this._getRenamedItems().indexOf(this.getSelectedKey())>=0){var e=this.oVariantText.getBinding("text");if(e){e.checkUpdate(true)}}}if(this._bRebindRequired){this.oManagementTable.unbindItems()}this.fireManage(this._collectManageData());if(this.oManagementDialog){this._resumeManagementTableBinding()}return true};ee.prototype._resumeManagementTableBinding=function(){if(this.oManagementTable){var e=this.oManagementTable.getBinding("items");if(e){e.resume()}}};ee.prototype._suspendManagementTableBinding=function(){if(this.oManagementTable){var e=this.oManagementTable.getBinding("items");if(e){e.suspend()}}};ee.prototype._focusOnFirstInputInErrorState=function(e){if(e){e.getItems().some(function(e){var t=e.getCells()[ee.COLUMN_NAME_IDX];if(t&&t.getValueState&&t.getValueState()===Y.Error){t.getDomRef().scrollIntoView();t.focus();return true}return false})}};ee.prototype._isItemDeleted=function(e){const t=this._getDeletedItems();if(!e||!t){return false}return t.indexOf(e.getKey())>-1};ee.prototype._anyInErrorStateManageTable=function(e){var t=false;if(e){e.getItems().some(function(e){if(e.getVisible()){var i=e.getCells()[ee.COLUMN_NAME_IDX];if(i&&i.getValueState&&i.getValueState()===Y.Error){t=true}}return t})}return t};ee.prototype._anyInErrorState=function(e){if(this._anyInErrorStateManageTable(e)){return true}var t=this._getRenamedItems();for(var i=t.length-1;i>=0;i--){var a=this._getItemByKey(t[i]);if(a){if(a.getTitle()===a._getOriginalTitle()){this._removeRenamedItem(a)}}}var s=false;this._getRenamedItems().some(function(e,t){var i=this._getItemByKey(e);if(i){s=this._checkIsDuplicateInModel(i.getTitle(),e)}return s}.bind(this));if(s){this._oSearchFieldOnMgmtDialog.setValue("");this._triggerSearchInManageDialogByValue("",e);this._focusOnFirstInputInErrorState(e)}return s};ee.prototype._getRowForKey=function(e){var t=null;if(this.oManagementTable){this.oManagementTable.getItems().some(function(i){var a=i.getCells()[0].getParent();var s=this.getModel("$mVariants").getObject(a.getBindingContextPath());if(e===s.getKey()){t=i}return t!==null}.bind(this))}return t};ee.prototype._determineIndex=function(e){var t=-1;var i=e.indexOf("/",1);if(i>0){t=parseInt(e.substring(i+1))}return t};ee.prototype._getFilters=function(e){var t=[];if(e){t.push(e)}t.push(this._getVisibleFilter());if(this.getSupportFavorites()){t.push(this._getFavoriteFilter())}return t};ee.prototype._getVisibleFilter=function(){return new s({path:"visible",operator:o.EQ,value1:true})};ee.prototype._getFavoriteFilter=function(){return new s({path:"favorite",operator:o.EQ,value1:true})};ee.prototype._verifyVariantNameConstraints=function(e,t,i){if(!e){return}var a=i||e.getValue();a=a.trim();if(!this._checkIsDuplicate(a,t)){if(a===""){e.setValueState(Y.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"))}else if(a.indexOf("{")>-1){e.setValueState(Y.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NOT_ALLOWED_CHAR",["{"]))}else if(a.length>ee.MAX_NAME_LEN){e.setValueState(Y.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_MAX_LEN",[ee.MAX_NAME_LEN]))}else{e.setValueState(Y.None);e.setValueStateText(null)}}else{e.setValueState(Y.Error);if(this._oSearchFieldOnMgmtDialog&&this._oSearchFieldOnMgmtDialog.getValue()){e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE_SAVE"))}else{e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE"))}}};ee.prototype._checkVariantNameConstraints=function(e,t){this._verifyVariantNameConstraints(e,t);if(this.oManagementDialog&&this.oManagementDialog.isOpen()){this._reCheckVariantNameConstraints()}};ee.prototype._reCheckVariantNameConstraints=function(){var e;var t=false;if(this.oManagementTable){e=this.oManagementTable.getItems();e.some(function(e){var i=e.getBindingContext("$mVariants").getObject();if(i&&i.getVisible()){var a=e.getCells()[ee.COLUMN_NAME_IDX];if(a&&a.getValueState&&a.getValueState()===Y.Error){this._verifyVariantNameConstraints(a,i.getKey());if(a.getValueState()===Y.Error){t=true}}}return t}.bind(this))}return t};ee.prototype._checkIsDuplicate=function(e,t){if(this.oManagementDialog&&this.oManagementDialog.isOpen()){var i=this._checkIsDuplicateInManageTable(e,t);if(this._oSearchFieldOnMgmtDialog&&this._oSearchFieldOnMgmtDialog.getValue()&&i){return i}}return this._checkIsDuplicateInModel(e,t)};ee.prototype._checkIsDuplicateInModel=function(e,t){var i=false;var a=this._getItems();var s=e.toLowerCase();a.some(function(e){if(e.getTitle().toLowerCase()===s){if(t&&t===e.getKey()){return false}i=true}return i});return i};ee.prototype._checkIsDuplicateInManageTable=function(e,t){var i;var a=false;var s=e.toLowerCase();if(this.oManagementTable){i=this.oManagementTable.getItems();i.some(function(e){var i;var o=e.getBindingContext("$mVariants").getObject();if(o&&o.getVisible()){var n=e.getCells()[ee.COLUMN_NAME_IDX];if(n&&o.getKey()!==t){if(n.isA("sap.m.Input")){i=n.getValue().toLowerCase()}else{i=n.getTitle().toLowerCase()}if(i===s){a=true}}}return a})}return a};ee.prototype._getToolbarInteractive=function(){return true};ee.prototype.exit=function(){var e;this._oObserver.disconnect();this._oObserver=undefined;h.prototype.exit.apply(this,arguments);this._clearDeletedItems();this._clearRenamedItems();if(this.oVariantInvisibleText&&!this.oVariantInvisibleText._bIsBeingDestroyed){this.oVariantInvisibleText.destroy(true);this.oVariantInvisibleText=undefined}if(this.oVariantListInvisibleText&&!this.oVariantListInvisibleText._bIsBeingDestroyed){this.oVariantListInvisibleText.destroy(true);this.oVariantListInvisibleText=undefined}if(this.oDefault&&!this.oDefault._bIsBeingDestroyed){this.oDefault.destroy()}this.oDefault=undefined;if(this.oPublic&&!this.oPublic._bIsBeingDestroyed){this.oPublic.destroy()}this.oPublic=undefined;if(this.oExecuteOnSelect&&!this.oExecuteOnSelect._bIsBeingDestroyed){this.oExecuteOnSelect.destroy()}this.oExecuteOnSelect=undefined;if(this.oCreateTile&&!this.oCreateTile._bIsBeingDestroyed){this.oCreateTile.destroy()}this.oCreateTile=undefined;this._oRb=undefined;this.oVariantList=undefined;this.oVariantSelectionPage=undefined;this.oVariantLayout=undefined;this.oVariantText=undefined;this.oVariantModifiedText=undefined;this.oVariantPopoverTrigger=undefined;this._oSearchField=undefined;this._oSearchFieldOnMgmtDialog=undefined;this._sDefaultKey=undefined;this._oCtrlRef=undefined;if(this._oNoDataIllustratedMessage&&!this._oNoDataIllustratedMessage.bIsDestroyed){this._oNoDataIllustratedMessage.destroy()}if(this._oNoDataFoundIllustratedMessage&&!this._oNoDataFoundIllustratedMessage.bIsDestroyed){this._oNoDataFoundIllustratedMessage.destroy()}this._oNoDataIllustratedMessage=undefined;this._oNoDataFoundIllustratedMessage=undefined;e=this.getModel(ee.INNER_MODEL_NAME);if(e){e.destroy()}if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();this._oManagedObjectModel=undefined}this._oRolesComponentContainer=null;if(this._oRolesDialog&&!this._oRolesDialog._bIsBeingDestroyed){this._oRolesDialog.destroy();this._oRolesDialog=null}};return ee});
//# sourceMappingURL=VariantManagement.js.map