/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/IconPool","sap/ui/core/Lib","./Toolbar","./CheckBox","./SearchField","./List","./StandardListItem","./Dialog","./Button","./ToggleButton","./Title","./NavContainer","./Bar","./SegmentedButton","./Page","./ViewSettingsItem","sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectObserver","sap/ui/base/EventProvider","sap/ui/Device","sap/ui/core/InvisibleText","./ViewSettingsDialogRenderer","sap/m/GroupHeaderListItem","sap/ui/base/Object","sap/ui/core/StaticArea","sap/base/Log","sap/ui/core/library","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Focusable"],function(t,e,i,s,r,n,o,l,a,g,h,u,d,p,_,c,f,m,I,S,y,b,T,v,C,L,P,F,E,B,jQuery){"use strict";var D=t.ListMode;var A=t.ListType;var w=t.StringFilterOperator;var O=t.TitleAlignment;var V=t.ButtonType;var G=B.TitleLevel;var N="-list-item";var x=e.extend("sap.m.ViewSettingsDialog",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Behavior",defaultValue:null},sortDescending:{type:"boolean",group:"Behavior",defaultValue:false},groupDescending:{type:"boolean",group:"Behavior",defaultValue:false},filterSearchOperator:{type:"sap.m.StringFilterOperator",group:"Behavior",defaultValue:w.StartsWith},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:O.Auto}},aggregations:{sortItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"sortItem",bindable:"bindable"},groupItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"groupItem",bindable:"bindable"},filterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"filterItem",bindable:"bindable"},presetFilterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"presetFilterItem",bindable:"bindable"},customTabs:{type:"sap.m.ViewSettingsCustomTab",multiple:true,singularName:"customTab",bindable:"bindable"}},associations:{selectedSortItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedGroupItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedPresetFilterItem:{type:"sap.m.ViewSettingsItem",multiple:false}},events:{confirm:{parameters:{sortItem:{type:"sap.m.ViewSettingsItem"},sortDescending:{type:"boolean"},groupItem:{type:"sap.m.ViewSettingsItem"},groupDescending:{type:"boolean"},presetFilterItem:{type:"sap.m.ViewSettingsItem"},filterItems:{type:"sap.m.ViewSettingsItem[]"},filterKeys:{type:"object",deprecated:true},filterCompoundKeys:{type:"object"},filterString:{type:"string"}}},cancel:{},resetFilters:{},reset:{},filterDetailPageOpened:{parameters:{parentFilterItem:{type:"sap.m.ViewSettingsFilterItem"}}},beforeClose:{allowPreventDefault:true}}},renderer:C});x.prototype.init=function(){var t=this.getId();this._rb=r.getResourceBundleFor("sap.m");this._sDialogWidth="350px";this._sDialogHeight="434px";this._bAppendedToUIArea=false;this._showSubHeader=false;this._filterDetailList=undefined;this._vContentPage=-1;this._oContentItem=null;this._oPreviousState={};this._sCustomTabsButtonsIdPrefix="-custom-button-";this._sTitleLabelId=t+"-title";this._sFilterDetailTitleLabelId=t+"-detailtitle";this._oFiltersSelectedOnly={};this._oKeylessFilters={};this._aggregationToListItems("sortItems",{text:{listProp:"title"},selected:{},wrapping:{}},{tooltip:{}},{type:A.Active},{mode:D.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(t){var e=t.getParameter("listItem"),i=this.getSortItems(),s=this._getVSItem(e),r;s.setProperty("selected",t.getParameter("selected"),true,false);this.setAssociation("selectedSortItem",s,true);for(r=0;r<i.length;r++){if(s!==i[r]){i[r].setProperty("selected",false,true,false)}}this._checkResetStatus()}.bind(this)})};x.prototype.exit=function(){this._rb=null;this._sDialogWidth=null;this._sDialogHeight=null;this._bAppendedToUIArea=null;this._showSubHeader=null;this._vContentPage=null;this._oContentItem=null;this._oPreviousState=null;this._sortContent=null;this._groupContent=null;this._filterContent=null;this._sCustomTabsButtonsIdPrefix=null;this._fnFilterSearchCallback=null;this._oKeylessFilters=null;if(this._bAppendedToUIArea&&this._dialog){var t=F.getUIArea();t.removeContent(this._dialog,true)}if(this._dialog){this._dialog.destroy();this._dialog=null}if(this._navContainer){this._navContainer.destroy();this._navContainer=null}if(this._titleLabel){this._titleLabel.destroy();this._titleLabel=null}if(this._page1){this._page1.destroy();this._page1=null}if(this._header){this._header.destroy();this._header=null}if(this._resetButton){this._resetButton.destroy();this._resetButton=null}if(this._subHeader){this._subHeader.destroy();this._subHeader=null}if(this._segmentedButton){this._segmentedButton.destroy();this._segmentedButton=null}if(this._sortButton){this._sortButton.destroy();this._sortButton=null}if(this._groupButton){this._groupButton.destroy();this._groupButton=null}if(this._filterButton){this._filterButton.destroy();this._filterButton=null}if(this._sortList){this._sortList.destroy();this._sortList=null}if(this._sortOrderList){this._sortOrderList.destroy();this._sortOrderList=null}if(this._oGroupingNoneItem){this._oGroupingNoneItem.destroy();this._oGroupingNoneItem=null}if(this._groupList){this._groupList.destroy();this._groupList=null}if(this._groupOrderList){this._groupOrderList.destroy();this._groupOrderList=null}if(this._presetFilterList){this._presetFilterList.destroy();this._presetFilterList=null}if(this._filterList){this._filterList.destroy();this._filterList=null}if(this._page2){this._page2.destroy();this._page2=null}if(this._detailTitleLabel){this._detailTitleLabel.destroy();this._detailTitleLabel=null}if(this._filterDetailList){this._filterDetailList.destroy();this._filterDetailList=null}if(this._oStringFilter){this._oStringFilter=null}if(this._oSelectedFilterKeys){this._oSelectedFilterKeys=null}};x.prototype._aggregationToListItems=function(t,e,i,s,r){var n=this._getListType(t),o="_"+n+"List";if(!this.mToList){this.mToList={}}this.mToList[n]={itemPropertyMap:e,itemAggregationMap:i,listItemOptions:s,listOptions:r,listName:o}};x.prototype._getListType=function(t){return t.replace("Items","")};x.prototype._createList=function(t){var e=this.getId()+"-"+t+"list",i=new a(e,this.mToList[t].listOptions),s=this._createGroupHeaderItem(t);i.addItemGroup(undefined,s);this[this.mToList[t].listName]=i;return i};x.prototype._createGroupHeaderItem=function(t){return new L({title:this._rb.getText("VIEWSETTINGS_"+t.toUpperCase()+"_OBJECT")})};x.prototype._getList=function(t){if(!this.mToList||!this.mToList[t]){return}return this[this.mToList[t].listName]};x.prototype._createListItem=function(t,e){var i=this.mToList[t].listItemOptions,s=this.mToList[t].itemPropertyMap,r=this.mToList[t].itemAggregationMap,n,o;for(var l in s){if(s.hasOwnProperty(l)){n=s[l].listProp||l;i[n]=this._createListItemPropertyValue(t,l,e)}}for(var a in r){if(r.hasOwnProperty(a)){i[a]=e.getAggregation(a)}}o=new g(i).data("item",e);return o};x.prototype._createListItemPropertyValue=function(t,e,i){var s=S.escapeSettingsValue(i.getMetadata().getAllProperties()[e].get(i)),r=this.mToList[t].itemPropertyMap[e].fn;return r?r(s):s};x.prototype._getListItem=function(t,e){var i=this._getList(t).getItems().filter(function(t){return t.data("item")===e});return i.length?i[0]:null};x.prototype._getVSItem=function(t){return t.data("item")};x.prototype.addCustomTab=function(t){var e=t.getId();if(e==="sort"||e==="filter"||e==="group"){throw'Id "'+e+'" is reserved and cannot be used as custom tab id.'}this.addAggregation("customTabs",t);return this};x.prototype.invalidate=function(){if(this._dialog&&(!arguments[0]||arguments[0]&&arguments[0].getId()!==this.getId()+"-dialog")){this._dialog.invalidate(arguments)}};x.prototype.addStyleClass=function(){var t=this._getDialog();t.addStyleClass.apply(t,arguments);return this};x.prototype.removeStyleClass=function(){var t=this._getDialog();t.removeStyleClass.apply(t,arguments);return this};x.prototype.toggleStyleClass=function(){var t=this._getDialog();t.toggleStyleClass.apply(t,arguments);return this};x.prototype.hasStyleClass=function(){var t=this._getDialog();return t.hasStyleClass.apply(t,arguments)};x.prototype.getDomRef=function(){if(this._dialog){return this._dialog.getDomRef.apply(this._dialog,arguments)}else{return null}};x.prototype.setTitle=function(t){this._getTitleLabel().setText(t);this.setProperty("title",t);return this};x.prototype.setTitleAlignment=function(t){this.setProperty("titleAlignment",t);if(this._page1){this._page1.setTitleAlignment(t)}if(this._page2){this._page2.setTitleAlignment(t)}return this};x.prototype.addAggregation=function(t,i,s){e.prototype.addAggregation.apply(this,arguments);var r=this._getListType(t);if(this.mToList[r]){var n=this._createListItem(r,i);var o=this._getList(r);if(!o){o=this._createList(r)}else if(!o.getItems().length){o.addItemGroup(undefined,this._createGroupHeaderItem(r))}o.addItem(n);this._attachItemPropertyChange(r,i)}else{this._attachItemEventHandlers(t,i)}if(t==="filterItems"){this._observeItem(i)}return this};x.prototype.insertAggregation=function(t,i,s,r){e.prototype.insertAggregation.apply(this,arguments);var n=this._getListType(t);if(this.mToList[n]){var o=this._createListItem(n,i);var l=this._getList(n);if(!l){l=this._createList(n);l.insertItem(o,s)}else if(!l.getItems().length){l.addItemGroup(undefined,this._createGroupHeaderItem(n));l.insertItem(o,s+1)}else{l.insertItem(o,s)}this._attachItemPropertyChange(n,i)}else{this._attachItemEventHandlers(t,i)}if(t==="filterItems"){this._observeItem(i)}return this};x.prototype.removeAggregation=function(t,i,s){K.call(this,t,i);var r=e.prototype.removeAggregation.apply(this,arguments);var n=this._getListType(t);if(this.mToList[n]){var o=this._getListItem(n,r);var l=this._getList(n);var a=l.removeItem(o);a.destroy();this._detachItemPropertyChange(r)}if(t==="filterItems"){this._unobserveItem(r);if(!this.getFilterItems().length){this._disconnectAndDestroyFilterItemsObserver()}}return r};x.prototype.removeAllAggregation=function(t,i){K.call(this);var s=e.prototype.removeAllAggregation.apply(this,arguments);var r=this._getListType(t);if(this.mToList[r]){var n=this._getList(r);if(n){var o=n.removeAllItems();o.forEach(function(t){t.destroy()})}s.forEach(function(t){this._detachItemPropertyChange(t)},this)}if(t==="filterItems"){this._disconnectAndDestroyFilterItemsObserver()}return s};x.prototype.destroyAggregation=function(t,i){K.call(this);e.prototype.destroyAggregation.apply(this,arguments);var s=this._getListType(t);if(this.mToList[s]){var r=this._getList(s);if(r){r.destroyItems()}}if(t==="filterItems"){this._disconnectAndDestroyFilterItemsObserver()}return this};x.prototype._detachItemPropertyChange=function(t){delete b.getEventList(t)["itemPropertyChanged"]};x.prototype._attachItemPropertyChange=function(t,e){e.attachEvent("itemPropertyChanged",function i(s){var r,n,o,l,a,g;r=this._getListItem(t,e);n=s.getParameter("propertyKey");if(!this.mToList[t].itemPropertyMap[n]){return}o=this.mToList[t].itemPropertyMap[n].listProp||n;l=s.getParameter("propertyValue");a=this.mToList[t].itemPropertyMap[n].fn;g=a?a(l):l;r.getMetadata().getAllProperties()[o].set(r,g)},this)};x.prototype._getFilterItemsObserver=function(){if(!this._oFilterItemsObserver){this._oFilterItemsObserver=new y(function(){if(this._oSelectedFilterKeys){this.setSelectedFilterCompoundKeys(this._oSelectedFilterKeys)}}.bind(this))}return this._oFilterItemsObserver};x.prototype._observeItem=function(t){this._getFilterItemsObserver().observe(t,{aggregations:["items"]})};x.prototype._unobserveItem=function(t){this._getFilterItemsObserver().unobserve(t,{aggregations:["items"]})};x.prototype._disconnectAndDestroyFilterItemsObserver=function(){if(this._oFilterItemsObserver){this._oFilterItemsObserver.disconnect();this._oFilterItemsObserver.destroy();this._oFilterItemsObserver=null}};x.prototype._attachItemEventHandlers=function(t,e){if(t!=="groupItems"&&t!=="filterItems"){return this}var i=t.replace("Items","");i=i.charAt(0).toUpperCase()+i.slice(1);e.attachEvent("itemPropertyChanged",function(t,e){if(t==="filterItems"&&e.getParameter("changedItem").getParent().getMetadata().getName()==="sap.m.ViewSettingsFilterItem"){if(e.getParameter("propertyKey")!=="selected"){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem)}}else{if(this._filterDetailList){var s=this._filterDetailList.getItems();s.forEach(function(t){if(t.data("item").getId()===e.getParameter("changedItem").getId()){t.setSelected(e.getParameter("propertyValue"))}});this._updateSelectAllCheckBoxState()}}this._updateFilterCounters()}else{if(typeof this["_init"+i+"Content"]==="function"){this["_init"+i+"Content"]()}if(typeof this["_init"+i+"Items"]==="function"){if(e.getParameter("propertyKey")==="selected"&&e.getParameter("propertyValue")===true){this.setAssociation("selectedGroupItem",e.getParameter("changedItem"),true)}this["_init"+i+"Items"]()}}}.bind(this,t));e.attachEvent("filterDetailItemsAggregationChange",function(t){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem)}}.bind(this));return this};x.prototype._setFilterDetailTitle=function(t){var e=this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")+" "+t.getText();this._getDetailTitleLabel().setText(e);this._toggleDialogTitle(this._sFilterDetailTitleLabelId)};x.prototype._toggleDialogTitle=function(t){var e=this._getDialog(),i=e.getAriaLabelledBy(),s=[this._sTitleLabelId,this._sFilterDetailTitleLabelId];if(s.indexOf(t)===-1&&i.indexOf(t)>-1){return this}for(var r in s){e.removeAriaLabelledBy(s[r])}e.addAriaLabelledBy(t);return this};x.prototype.updateAggregation=function(t){e.prototype.updateAggregation.apply(this,arguments);if(t!=="groupItems"&&t!=="filterItems"){return this}var i=t.replace("Items","");i=i.charAt(0).toUpperCase()+i.slice(1);if(typeof this["_init"+i+"Content"]==="function"){this["_init"+i+"Content"]()}if(typeof this["_init"+i+"Items"]==="function"){this["_init"+i+"Items"]()}};x.prototype.addSortItem=function(t){this.addAggregation("sortItems",t);if(this.getSelectedSortItem()===t.getId()||this.getSelectedSortItem()===t.getKey()){t.setSelected(true)}if(t.getSelected()){this.setAssociation("selectedSortItem",t,true)}return this};x.prototype.addGroupItem=function(t){this.addAggregation("groupItems",t);if(this.getSelectedGroupItem()===t.getId()||this.getSelectedGroupItem()===t.getKey()){t.setSelected(true)}if(t.getSelected()){this.setAssociation("selectedGroupItem",t,true)}return this};x.prototype.addPresetFilterItem=function(t){this.addAggregation("presetFilterItems",t);if(t.getSelected()){this.setSelectedPresetFilterItem(t)}return this};x.prototype.setSelectedSortItem=function(t){var e=this.getSortItems(),s=0,r=M(t,e);if(!r&&typeof t==="string"){r=i.getElementById(t)}if(!r||H(r)){for(s=0;s<e.length;s++){if(!r||e[s].getId()!==r.getId()){e[s].setProperty("selected",false,true)}}if(r&&r.getProperty("selected")!==true){r.setProperty("selected",true,true)}if(this._getDialog().isOpen()){this._updateListSelection(this._sortList,r)}}this.setAssociation("selectedSortItem",r||t,true);return this};x.prototype.setSelectedGroupItem=function(t){var e=this.getGroupItems(),s=0,r=M(t,e);if(!r&&typeof t==="string"){r=i.getElementById(t)}if(!r&&!t){r=this._oGroupingNoneItem;this.setAssociation("selectedGroupItem",r,true);return this}if(H(r)){for(s=0;s<e.length;s++){e[s].setProperty("selected",false,true)}r.setProperty("selected",true,true);if(this._getDialog().isOpen()){this._updateListSelection(this._groupList,r)}}this.setAssociation("selectedGroupItem",r||t,true);return this};x.prototype.setSelectedPresetFilterItem=function(t){var e=this.getPresetFilterItems(),i=0,s=M(t,e,"Could not set selected preset filter item. Item is not found: '"+t+"'");if(H(s)||s===null){for(i=0;i<e.length;i++){e[i].setProperty("selected",false,true)}if(s!==null){s.setProperty("selected",true,true)}this._clearSelectedFilters();this.setAssociation("selectedPresetFilterItem",s,true)}return this};x.prototype.open=function(t){if(!this.getParent()&&!this._bAppendedToUIArea){var e=F.getUIArea();e.addContent(this._getDialog(),true);this._bAppendedToUIArea=true}if(t&&this._vContentPage===3){setTimeout(this._getNavContainer()["to"].bind(this._getNavContainer(),this._getPage1().getId(),"show"),0)}this._initDialogContent(t);this._oPreviousState={sortItem:i.getElementById(this._getSelectedSortItem()),sortDescending:this.getSortDescending(),groupItem:i.getElementById(this._getSelectedGroupItem()),groupDescending:this.getGroupDescending(),presetFilterItem:i.getElementById(this.getSelectedPresetFilterItem()),filterKeys:this.getSelectedFilterKeys(),filterCompoundKeys:this.getSelectedFilterCompoundKeys(),navPage:this._getNavContainer().getCurrentPage(),contentPage:this._vContentPage,contentItem:this._oContentItem};if(!this._oInitialState){this._oInitialState={sortItem:this._getSelectedSortItem(),sortDescending:this.getSortDescending(),groupItem:this._getSelectedGroupItem(),groupDescending:this.getGroupDescending(),presetFilterItem:this.getSelectedPresetFilterItem()}}if(T.system.desktop){this._getDialog().attachEventOnce("afterOpen",this._focusFirstListItem,this)}this._checkResetStatus();this._getDialog().open();return this};x.prototype._focusFirstListItem=function(){var t=this._getNavContainer().getCurrentPage(),e;if(t){e=t.$("cont").firstFocusableDomRef();if(e){if(jQuery(e).hasClass("sapMListUl")){var i=jQuery(e).find(".sapMLIB");i.length&&i[0].focus();return}e.focus()}}};x.prototype.getSelectedFilterItems=function(){var t=[],e=this.getFilterItems(),i,s=true,r=0,n;for(;r<e.length;r++){if(P.isObjectA(e[r],"sap.m.ViewSettingsCustomItem")){if(e[r].getSelected()){t.push(e[r])}}else if(P.isObjectA(e[r],"sap.m.ViewSettingsFilterItem")){i=e[r].getItems();s=e[r].getMultiSelect();for(n=0;n<i.length;n++){if(i[n].getSelected()){t.push(i[n]);if(!s){break}}}}}return t};x.prototype.getSelectedFilterString=function(){var t="",e,s=this.getSelectedPresetFilterItem(),r=this.getFilterItems(),n,o=true,l,a=0,g;if(s){t=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+i.getElementById(s).getText())}else{for(;a<r.length;a++){l=false;if(P.isObjectA(r[a],"sap.m.ViewSettingsCustomItem")){if(r[a].getSelected()){l=true;t+=r[a].getText()+", "}}else if(P.isObjectA(r[a],"sap.m.ViewSettingsFilterItem")){n=r[a].getItems();o=r[a].getMultiSelect();e="";for(g=0;g<n.length;g++){if(n[g].getSelected()){l=true;e+=n[g].getText()+", ";if(!o){break}}}e=e.substring(0,e.length-2);if(l){e=" ("+e+")";t+=r[a].getText()+e+", "}}}t=t.substring(0,t.length-2);if(t){t=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+t)}}return t};x.prototype.getSelectedFilterKeys=function(){var t={},e=this.getSelectedFilterItems(),i=0;for(;i<e.length;i++){t[e[i].getKey()]=e[i].getSelected()}return t};x.prototype.getSelectedFilterCompoundKeys=function(){var t={},e=this.getSelectedFilterItems(),i,s,r,n;this._oKeylessFilters={};for(i=0;i<e.length;i++){n=e[i];if(P.isObjectA(n,"sap.m.ViewSettingsCustomItem")){s=n.getKey();t[s]=n.getSelected()}else{s=n.getKey();r=n.getParent().getKey();if(!t[r]){t[r]={}}t[r][s]=n.getSelected();if(s===""){if(!this._oKeylessFilters[r]){this._oKeylessFilters[r]={}}this._oKeylessFilters[r][n.getText()]=true}}}return t};x.prototype.setSelectedFilterKeys=function(t){var e=this.getFilterItems(),i={},s,r,n,o,l;if(Object.keys(t).length){this._clearPresetFilter()}for(var a in t){s=null;if(t.hasOwnProperty(a)){for(n=0;n<e.length;n++){if(P.isObjectA(e[n],"sap.m.ViewSettingsCustomItem")){if(e[n].getKey()===a){s=e[n];e[n].setProperty("selected",t[a],true)}}else if(P.isObjectA(e[n],"sap.m.ViewSettingsFilterItem")){i=e[n].getItems();r=e[n].getMultiSelect();for(o=0;o<i.length;o++){if(i[o].getKey()===a){s=i[o];if(!r){for(l=0;l<i.length;l++){i[l].setProperty("selected",false,true)}}break}}}if(s){break}}if(s===null){E.warning('Cannot set state for key "'+a+'" because there is no filter with these keys');continue}s.setProperty("selected",t[a],true)}}return this};x.prototype.setSelectedFilterCompoundKeys=function(t){var e=this.getFilterItems(),i,s,r,n,o,l,a,g,h,u;this._oSelectedFilterKeys=t;if(Object.keys(t).length){this._clearPresetFilter();for(i in t){n=null;for(u=0;u<e.length;u++){s=e[u].getKey();if(s===i){n=e[u];break}}if(P.isObjectA(n,"sap.m.ViewSettingsCustomItem")){n.setProperty("selected",t[i],true)}else if(P.isObjectA(n,"sap.m.ViewSettingsFilterItem")){o=t[i];l=n.getItems();a=n.getMultiSelect();h=false;for(u=0;u<l.length;u++){s=l[u].getKey();r=l[u].getText();if(s!==""&&o[s]||s===""&&this._oKeylessFilters[i]&&this._oKeylessFilters[i][r]){g=h?false:o[s]}else{g=false}l[u].setProperty("selected",g,true);if(g&&!a){h=true}}}}}return this};x.prototype._checkForInnerCustomItems=function(t){for(var e=0;e<t.length;e++){if(t[e].isA("sap.m.ViewSettingsCustomItem")){return true}}return false};x.prototype._checkForCustomItems=function(){var t=this.getSortItems(),e=this.getGroupItems(),i=this.getFilterItems(),s=this.getPresetFilterItems();return this.getAggregation("customTabs").length||t.length&&this._checkForInnerCustomItems(t)||e.length&&this._checkForInnerCustomItems(e)||i.length&&this._checkForInnerCustomItems(i)||s.length&&this._checkForInnerCustomItems(s)};x.prototype._checkResetStatus=function(){var t=false,e=this.getSelectedFilterItems();if(this._checkForCustomItems()){t=true}else{if(this._oInitialState){if(e.length>0){t=true}if(this._oInitialState.sortItem!==this._getSelectedSortItem()||this._oInitialState.sortDescending!==this.getSortDescending()){t=true}if(this._oInitialState.groupItem&&this._oInitialState.groupItem!==this._getSelectedGroupItem()||this._oInitialState.groupDescending!==this.getGroupDescending()){t=true}if(this._oInitialState.presetFilterItem!==undefined&&this.getSelectedPresetFilterItem()!==null){t=true}}}if(this._resetButton){this._resetButton.setEnabled(t)}if(this._detailResetButton){this._detailResetButton.setEnabled(t)}};x.prototype._globalReset=function(){var t=this._checkForCustomItems();this.clearFilters();this.setSelectedSortItem(i.getElementById(this._oInitialState.sortItem));this.setSortDescending(this._oInitialState.sortDescending);this._updateListSelection(this._sortOrderList,this._oInitialState.sortDescending);this._oInitialState.groupItem!==undefined&&this.setSelectedGroupItem(i.getElementById(this._oInitialState.groupItem));this.setGroupDescending(this._oInitialState.groupDescending);this._updateListSelection(this._groupOrderList,this._oInitialState.groupDescending);if(T.system.desktop){if(!t&&this._filterList&&this._filterList.getDomRef()){this._getNavContainer().attachEventOnce("afterNavigate",this._focusFirstListItem,this)}else if(!t&&(this._sortList&&this._sortList.getDomRef()||this._groupList&&this._groupList.getDomRef())){this._focusFirstListItem()}}this._checkResetStatus();this.fireReset()};x.prototype._getDialog=function(){var t=this;if(this._dialog===undefined){this._dialog=new h(this.getId()+"-dialog",{ariaLabelledBy:this._sTitleLabelId,showHeader:false,stretch:T.system.phone,verticalScrolling:true,horizontalScrolling:false,contentWidth:this._sDialogWidth,contentHeight:this._sDialogHeight,content:this._getNavContainer(),titleAlignment:this.getTitleAlignment(),beginButton:new u(this.getId()+"-acceptbutton",{text:this._rb.getText("VIEWSETTINGS_ACCEPT"),type:V.Emphasized}).attachPress(this._onConfirm,this),endButton:new u(this.getId()+"-cancelbutton",{text:this._rb.getText("VIEWSETTINGS_CANCEL")}).attachPress(this._onCancel,this)}).addStyleClass("sapMVSD");this.addDependent(this._dialog);var e=this._dialog.onsapescape;this._dialog.onsapescape=function(i){if(e){e.call(t._dialog,i)}t._onCancel()};this._dialog.onsapentermodifiers=function(e){if(e.shiftKey&&!e.ctrlKey&&!e.altKey){t._pressBackButton()}}}return this._dialog};x.prototype._getNavContainer=function(){if(this._navContainer===undefined){this._navContainer=new _(this.getId()+"-navcontainer",{pages:[]})}return this._navContainer};x.prototype._getTitleLabel=function(){if(this._titleLabel===undefined){this._titleLabel=new p(this._sTitleLabelId,{text:this._rb.getText("VIEWSETTINGS_TITLE"),level:G.H1}).addStyleClass("sapMVSDTitle")}return this._titleLabel};x.prototype._getResetButton=function(){if(!this._resetButton){this._resetButton=new u(this.getId()+"-resetbutton",{press:function(){this._globalReset()}.bind(this),text:this._rb.getText("VIEWSETTINGS_RESET")})}return this._resetButton};x.prototype._getDetailResetButton=function(){if(this._detailResetButton===undefined){this._detailResetButton=new u(this.getId()+"-detailresetbutton",{press:function(){this._globalReset()}.bind(this),text:this._rb.getText("VIEWSETTINGS_RESET")})}return this._detailResetButton};x.prototype._getDetailTitleLabel=function(){if(this._detailTitleLabel===undefined){this._detailTitleLabel=new p(this.getId()+"-detailtitle",{text:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY"),level:G.H1}).addStyleClass("sapMVSDTitle")}return this._detailTitleLabel};x.prototype._getHeader=function(){if(this._header===undefined){this._header=new c({titleAlignment:this.getTitleAlignment(),contentMiddle:[this._getTitleLabel()]}).addStyleClass("sapMVSDBar")}return this._header};x.prototype._getSubHeader=function(){if(this._subHeader===undefined){this._subHeader=new c({contentLeft:[this._getSegmentedButton()]}).addStyleClass("sapMVSDBar")}return this._subHeader};x.prototype._getSegmentedButton=function(){var t=this,e=this.getCustomTabs(),i=e.length,s=0;if(this._segmentedButton===undefined){this._segmentedButton=new f({selectionChange:function(r){var n=r.getSource().getSelectedButton();if(n===t.getId()+"-sortbutton"){t._switchToPage(0)}else if(n===t.getId()+"-groupbutton"){t._switchToPage(1)}else if(n===t.getId()+"-filterbutton"){t._switchToPage(2)}else{for(s=0;s<i;s++){var o=e[s],l=t.getId()+t._sCustomTabsButtonsIdPrefix+o.getId();if(!t._isEmptyTab(o)&&n===l){t._switchToPage(o.getId());break}}}E.info("press event segmented: "+r.getParameter("id"))}}).addStyleClass("sapMVSDSeg");this._segmentedButton._bPreventWidthRecalculationOnAfterRendering=true}return this._segmentedButton};x.prototype._getSortButton=function(){if(this._sortButton===undefined){this._sortButton=new u(this.getId()+"-sortbutton",{icon:s.getIconURI("sort"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_SORT")})}return this._sortButton};x.prototype._getGroupButton=function(){if(this._groupButton===undefined){this._groupButton=new u(this.getId()+"-groupbutton",{icon:s.getIconURI("group-2"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_GROUP")})}return this._groupButton};x.prototype._getFilterButton=function(){if(this._filterButton===undefined){this._filterButton=new u(this.getId()+"-filterbutton",{icon:s.getIconURI("filter"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_FILTER")})}return this._filterButton};x.prototype._getPage1=function(t){if(this._page1===undefined&&!t){this._page1=new m(this.getId()+"-page1",{title:this._rb.getText("VIEWSETTINGS_TITLE"),titleAlignment:this.getTitleAlignment(),customHeader:this._getHeader()});this._getNavContainer().addPage(this._page1)}return this._page1};x.prototype._getPage2=function(){var t,e,i,r=this.getTitleAlignment();if(this._page2===undefined){e=new u(this.getId()+"-backbutton",{icon:s.getIconURI("nav-back"),press:[this._pressBackButton,this]});i=this._getDetailResetButton();t=new c({titleAlignment:r,contentLeft:[e],contentMiddle:[this._getDetailTitleLabel()],contentRight:[i]}).addStyleClass("sapMVSDBar");this._page2=new m(this.getId()+"-page2",{title:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY"),titleAlignment:r,customHeader:t});this._getNavContainer().addPage(this._page2)}return this._page2};x.prototype._initFilterDetailItems=function(t){if(!P.isObjectA(t,"sap.m.ViewSettingsFilterItem")){return}var e;var i=t.getMultiSelect();var s=t.getItems();var r=this;if(this._filterDetailList){this._filterDetailList.destroy()}this._getPage2().removeAllAggregation("content");this._filterDetailList=new a({mode:i?D.MultiSelect:D.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(e){var s,n=e.getParameter("listItems"),o,l=0,a;r._clearPresetFilter();if(i){this._updateSelectAllCheckBoxState()}if(n.length>1&&i){o=t.getItems();for(;l<o.length;l++){for(var g=0;g<n.length;g++){if(o[l].getKey()===n[g].getCustomData()[0].getValue().getKey()){o[l].setProperty("selected",n[g].getSelected(),true)}}}}else{s=e.getParameter("listItem").data("item");if(!t.getMultiSelect()){o=t.getItems();for(;l<o.length;l++){if(o[l].getId()!==s.getId()){o[l].setProperty("selected",false,true)}}}a=e.getParameter("listItem").getSelected();if(s.getProperty("selected")!==a){s.setProperty("selected",a,true)}}this._checkResetStatus()}.bind(this),ariaLabelledBy:this._sFilterDetailTitleLabelId});for(var o=0;o<s.length;o++){e=new g({title:S.escapeSettingsValue(s[o].getText()),type:A.Active,selected:s[o].getSelected(),tooltip:s[o].getTooltip(),wrapping:s[o].getWrapping()}).data("item",s[o]);this._filterDetailList.addItem(e)}this._filterSearchField=this._getFilterSearchField(this._filterDetailList);this._showOnlySelectedButton=this._getShowOnlySelectedButton();this._searchBar=new n({content:[this._filterSearchField.addStyleClass("sapMVSDFilterSearchField").addStyleClass("sapMTBShrinkItem"),this._showOnlySelectedButton]});this._getPage2().addContent(this._searchBar);this._getPage2().getCustomHeader().addStyleClass("sapMVSDBarWithSearch");if(i){this._selectAllCheckBox=this._createSelectAllCheckbox(s,this._filterDetailList);if(this._filterDetailList.getItems().length===0){this._selectAllCheckBox.setEnabled(false)}this._filterDetailList.setHeaderToolbar(new n({content:[this._selectAllCheckBox]}).addStyleClass("sapMVSDFilterHeaderToolbar"))}this._setFilterDetailItemsVisibility(this._filterDetailList,true);this._getPage2().addContent(this._filterDetailList)};x.prototype._initSortContent=function(){if(this._sortContent){return}this._vContentPage=-1;this._sortOrderList=new a(this.getId()+"-sortorderlist",{mode:D.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(t){this.setProperty("sortDescending",t.getParameter("listItem").data("item"),true);this._checkResetStatus()}.bind(this),ariaLabelledBy:this._sTitleLabelId});this._sortOrderList.addItemGroup(undefined,new L({title:this._rb.getText("VIEWSETTINGS_SORT_BY")}));this._sortOrderList.addItem(new g({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._sortOrderList.addItem(new g({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._sortList.addAriaLabelledBy(this._sTitleLabelId);this._sortContent=[this._sortOrderList,this._sortList]};x.prototype._initGroupItems=function(){var t,e,i=this.getGroupItems(),s=this._rb.getText("VIEWSETTINGS_GROUP_OBJECT");this._groupList.destroyItems();if(i.length){this._groupList.addItemGroup(undefined,new L({title:s}));i.forEach(function(e){t=new g({id:e.getId()+N,title:S.escapeSettingsValue(e.getText()),type:A.Active,selected:e.getSelected(),tooltip:e.getTooltip(),wrapping:e.getWrapping()}).data("item",e);this._groupList.addItem(t)},this);if(!this._oGroupingNoneItem||this._oGroupingNoneItem.bIsDestroyed){e=!!this._getSelectedGroupItem();this._oGroupingNoneItem=new I({text:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!e,itemPropertyChanged:function(){this._initGroupContent();this._initGroupItems()}.bind(this)});!e&&this.setAssociation("selectedGroupItem",this._oGroupingNoneItem,true)}t=new g({id:this._oGroupingNoneItem.getId()+N,title:this._oGroupingNoneItem.getText(),type:A.Active,selected:this._oGroupingNoneItem.getSelected(),wrapping:this._oGroupingNoneItem.getWrapping()}).data("item",this._oGroupingNoneItem);this._groupList.addItem(t)}};x.prototype._initGroupContent=function(){if(this._groupContent){return}this._vContentPage=-1;this._groupOrderList=new a(this.getId()+"-grouporderlist",{mode:D.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(t){this.setProperty("groupDescending",t.getParameter("listItem").data("item"),true);this._checkResetStatus()}.bind(this),ariaLabelledBy:this._sTitleLabelId});this._groupOrderList.addItemGroup(undefined,new L({title:this._rb.getText("VIEWSETTINGS_GROUP_BY")}));this._groupOrderList.addItem(new g({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._groupOrderList.addItem(new g({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._groupList=new a(this.getId()+"-grouplist",{mode:D.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(t){var e=t.getParameter("listItem").data("item");this.setSelectedGroupItem(e);this._checkResetStatus()}.bind(this),ariaLabelledBy:this._sTitleLabelId});this._groupContent=[this._groupOrderList,this._groupList]};x.prototype._initFilterItems=function(){var t,e,i,s=this,r=this._rb.getText("VIEWSETTINGS_FILTER_BY");this._presetFilterList.destroyItems();t=this.getPresetFilterItems();if(t.length){t.forEach(function(t){i=new g({id:t.getId()+N,title:S.escapeSettingsValue(t.getText()),type:A.Active,selected:t.getSelected(),tooltip:t.getTooltip(),wrapping:t.getWrapping()}).data("item",t);this._presetFilterList.addItem(i)},this)}if(t.length){i=new g({id:this._presetFilterList.getId()+"-none"+N,title:this._rb.getText("VIEWSETTINGS_NONE_ITEM_FILTER"),selected:!!this.getSelectedPresetFilterItem()});this._presetFilterList.addItem(i)}this._filterList.destroyItems();e=this.getFilterItems();this._filterList.addItemGroup(undefined,new L({title:r}));if(e.length){e.forEach(function(t){i=new g({id:t.getId()+N,title:S.escapeSettingsValue(t.getText()),type:A.Active,tooltip:t.getTooltip(),wrapping:t.getWrapping(),press:function(t){return function(e){if(s._navContainer.getCurrentPage().getId()!==s.getId()+"-page2"){s._switchToPage(3,t);s._prevSelectedFilterItem=this;setTimeout(s._navContainer["to"].bind(s._navContainer,s.getId()+"-page2","slide"),0)}if(T.system.desktop&&s._filterDetailList&&s._filterDetailList.getItems()[0]){s._getNavContainer().attachEventOnce("afterNavigate",function(){s._filterDetailList.getItems()[0].focus()})}}}(t)}).data("item",t);this._filterList.addItem(i)},this)}};x.prototype._initFilterContent=function(){if(this._filterContent){return}this._vContentPage=-1;this._presetFilterList=new a(this.getId()+"-predefinedfilterlist",{mode:D.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(t){var e=t.getParameter("listItem").data("item");if(e){e.setProperty("selected",t.getParameter("listItem").getSelected(),true)}this.setAssociation("selectedPresetFilterItem",e,true);this._clearSelectedFilters();this._checkResetStatus()}.bind(this)});this._filterList=new a(this.getId()+"-filterlist",{ariaLabelledBy:this._sTitleLabelId});this._filterContent=[this._presetFilterList,this._filterList]};x.prototype._initDialogContent=function(t){var e=!!this.getSortItems().length,i=!!this.getGroupItems().length,s=!!this.getPresetFilterItems().length,r=!!this.getFilterItems().length;if(e){this._initSortContent()}if(i){this._initGroupContent();this._initGroupItems()}if(s||r){this._initFilterContent();this._initFilterItems()}this._updateDialogState(t);this._updateListSelections()};x.prototype._getTabButton=function(t,e){var s=e+t.getId(),r=i.getElementById(s);if(r){return r}else{return new u({id:s,icon:t.getIcon(),tooltip:t.getTooltip()})}};x.prototype._updateDialogState=function(t){var e=!!this.getSortItems().length,i=!!this.getGroupItems().length,s=!!this.getPresetFilterItems().length,r=!!this.getFilterItems().length,n=!!this.getCustomTabs().length,o=this._getSegmentedButton(),l=null,a=false,g={sort:0,group:1,filter:2};o.removeAllButtons();if(this._filterContent){this._presetFilterList.setVisible(true);this._filterList.setVisible(true)}if(e){o.addButton(this._getSortButton())}if(s||r){o.addButton(this._getFilterButton());if(!s){this._presetFilterList.setVisible(false)}if(!r){this._filterList.setVisible(false)}}if(i){o.addButton(this._getGroupButton())}if(n){this.getCustomTabs().forEach(function(t){if(!this._isEmptyTab(t)){var e=this.getId()+this._sCustomTabsButtonsIdPrefix,i=this._getTabButton(t,e);o.addButton(i)}}.bind(this))}this._showSubHeader=this._hasSubHeader();if(t===undefined&&this._vContentPage!==-1){t=this._vContentPage;switch(t){case 0:t="sort";break;case 1:t="group";break;case 2:t="filter";break}}if(t===this._vContentPage&&this._vContentPage===3){this._vContentPage=-1;this._switchToPage(3,this._oContentItem)}else{t=this._determineValidPageId(t);for(var h in g){if(t===h){a=true;l=this.getId()+"-"+t+"button";t=g[h];break}}if(!a){l=this.getId()+this._sCustomTabsButtonsIdPrefix+t}this._getSegmentedButton().setSelectedButton(l);this._switchToPage(t);if(this._getNavContainer().getCurrentPage()!==this._getPage1()){this._getNavContainer().to(this._getPage1().getId())}}};x.prototype._determineValidPageId=function(t){var e="sort",i=false,s=[];s=this._fetchValidPagesIds();if(s.length){e=s[0]}else{E.warning("No available pages to load - missing items.")}if(!t){t=e}else{s.filter(function(e){if(e===t){i=true;return false}return true});if(!i){t=e}}return t};x.prototype._fetchValidPagesIds=function(){var t,e=this.getCustomTabs(),i=e.length,s=[];var r=["sort","filter","group"];r.forEach(function(t){if(this._isValidPredefinedPageId(t)){s.push(t)}},this);for(t=0;t<i;t++){var n=e[t];if(!this._isEmptyTab(n)){s.push(n.getId())}}return s};x.prototype._isEmptyTab=function(t){return!(t.getContent().length||this._vContentPage===t.getId()&&this._getPage1().getContent().length)};x.prototype._isValidPredefinedPageId=function(t){if(!t){E.warning("Missing mandatory parameter.");return false}var e=false;switch(t){case"sort":e=!!this.getSortItems().length;break;case"filter":e=!!this.getFilterItems().length||!!this.getPresetFilterItems().length;break;case"group":e=!!this.getGroupItems().length;break}return e};x.prototype._pressBackButton=function(){if(this._vContentPage===3){this._updateFilterCounters();this._getNavContainer().attachEventOnce("afterNavigate",function(){if(this._prevSelectedFilterItem){this._prevSelectedFilterItem.focus()}},this);setTimeout(this._getNavContainer()["back"].bind(this._getNavContainer()),0);this._switchToPage(2);this._segmentedButton.setSelectedButton(this._filterButton)}};x.prototype.setModel=function(t,i){if(this._vContentPage===3&&this._oContentItem){k.call(this)}return e.prototype.setModel.call(this,t,i)};x.prototype.removeFilterItem=function(t){var e="";if(this._vContentPage===3&&this._oContentItem){if(typeof t==="object"){e=t.getId()}else if(typeof t==="string"){e=t}else if(typeof t==="number"){e=this.getFilterItems()[t].getId()}if(this._oContentItem.getId()===e){k.call(this)}}return this.removeAggregation("filterItems",t)};x.prototype.removeAllFilterItems=function(){if(this._vContentPage===3&&this._oContentItem){k.call(this)}return this.removeAllAggregation("filterItems")};x.prototype.setFilterSearchCallback=function(t){this._fnFilterSearchCallback=t;return this};x.prototype._switchToPage=function(t,e){var s=0,r=this._getTitleLabel(),n=this._getHeader(),o=this._getSubHeader();this._checkResetStatus();this._getPage2().getCustomHeader().removeStyleClass("sapMVSDBarWithSearch");if(W.call(this)){K.call(this)}n.removeAllContentRight();o.removeAllContentRight();this._vContentPage=t;this._oContentItem=e;if(t!==3){this._getPage1().removeAllAggregation("content",true);this._addResetButtonToPage1()}else if(t===3){this._getPage2().removeAllAggregation("content",true)}if(this.getTitle()){r.setText(this.getTitle())}else if(this._hasSubHeader()){r.setText(this._rb.getText("VIEWSETTINGS_TITLE"))}this._toggleDialogTitle(this._sTitleLabelId);switch(t){case 1:if(!this._showSubHeader&&!this.getTitle()){r.setText(this._rb.getText("VIEWSETTINGS_TITLE_GROUP"))}for(;s<this._groupContent.length;s++){this._getPage1().addContent(this._groupContent[s])}break;case 2:if(!this._showSubHeader&&!this.getTitle()){r.setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTER"))}this._updateListSelection(this._presetFilterList,i.getElementById(this.getSelectedPresetFilterItem()));this._updateFilterCounters();for(;s<this._filterContent.length;s++){this._getPage1().addContent(this._filterContent[s])}break;case 3:this._setFilterDetailTitle(e);if(P.isObjectA(e,"sap.m.ViewSettingsCustomItem")&&e.getCustomControl()){this._clearPresetFilter();this._getPage2().addContent(e.getCustomControl())}else if(P.isObjectA(e,"sap.m.ViewSettingsFilterItem")&&e.getItems()){this._initFilterDetailItems(e)}break;case 0:if(!this._getPage1().getSubHeader()&&!this.getTitle()){r.setText(this._rb.getText("VIEWSETTINGS_TITLE_SORT"))}if(this._sortContent){for(;s<this._sortContent.length;s++){this._getPage1().addContent(this._sortContent[s])}}break;default:this._getPage1().removeAllAggregation("content",true);var l="VIEWSETTINGS_TITLE";var a=this.getCustomTabs();if(a.length<2){l=a[0].getTitle()}if(!this._getPage1().getSubHeader()&&!this.getTitle()){r.setText(l)}a.forEach(function(e){if(e.getId()===t){e.getContent().forEach(function(t){t.addStyleClass("sapMVSDCustomTabContent");this._getPage1().addContent(t)},this)}},this);break}if(t===3){this.fireFilterDetailPageOpened({parentFilterItem:e})}};x.prototype._createSelectAllCheckbox=function(t,e){var i=false;if(t&&t.length!==0){i=t.every(function(t){return t.getSelected()})}var s=new o({text:this._rb.getText("COLUMNSPANEL_SELECT_ALL"),selected:i,select:function(t){var i=t.getParameter("selected");e.getItems().filter(function(t){return t.getVisible()}).forEach(function(t){var e=t.data("item");e.setSelected(i)});this._checkResetStatus()}.bind(this)});return s};x.prototype._updateSelectAllCheckBoxState=function(){var t=false,e=this._filterDetailList.getItems(),i=[];if(!this._selectAllCheckBox){return}if(e&&e.length!==0){i=e.filter(function(t){return t.getVisible()})}if(i.length!==0){this._selectAllCheckBox.setEnabled(true);t=i.every(function(t){return t.getSelected()})}else{this._selectAllCheckBox.setEnabled(false)}this._selectAllCheckBox.setSelected(t)};x.prototype._visibilityBySearchField=function(t){var e=this._filterSearchField.getValue(),i=this._getStringFilter(),s=i(e,t.getTitle());return s};x.prototype._visibilityByToggleButton=function(t){var e=this._showOnlySelectedButton.getPressed()?t.getSelected():true;return e};x.prototype._getFilterSearchField=function(t){var e=new l({liveChange:function(){this._setFilterDetailItemsVisibility(t)}.bind(this)});return e};x.prototype._setFilterDetailItemsVisibility=function(t,e){t.getItems().forEach(function(t){t.setVisible(this._visibilityByToggleButton(t)&&(e||this._visibilityBySearchField(t)))}.bind(this));this._updateSelectAllCheckBoxState()};x.prototype._getShowOnlySelectedButton=function(){var t=this._oContentItem&&this._oFiltersSelectedOnly[this._oContentItem.getId()]?true:false,e=new d({icon:s.getIconURI("multi-select"),tooltip:this._rb.getText("SHOW_SELECTED_ONLY"),type:V.Transparent,pressed:t,press:function(){var t=this._showOnlySelectedButton.getPressed(),e=this._oContentItem.getId();if(t){this._oFiltersSelectedOnly[e]=true}else{delete this._oFiltersSelectedOnly[e]}this._setFilterDetailItemsVisibility(this._filterDetailList)}.bind(this)});return e};x.prototype._getStringFilter=function(){if(this._fnFilterSearchCallback){return this._fnFilterSearchCallback}if(!this._oStringFilter||this._oStringFilter.sOperator!==this.getFilterSearchOperator()){this._oStringFilter=new j(this.getFilterSearchOperator())}return this._oStringFilter.filter.bind(this._oStringFilter)};x.prototype._updateListSelections=function(){this._updateListSelection(this._sortList,i.getElementById(this._getSelectedSortItem()));this._updateListSelection(this._sortOrderList,this.getSortDescending());this._updateListSelection(this._groupList,i.getElementById(this._getSelectedGroupItem()));this._updateListSelection(this._groupOrderList,this.getGroupDescending());this._updateListSelection(this._presetFilterList,i.getElementById(this.getSelectedPresetFilterItem()));this._updateFilterCounters()};x.prototype._updateListSelection=function(t,e){var i,s=0,r;if(!t){return false}i=t.getItems();t.removeSelections();for(;s<i.length;s++){r=i[s].isA("sap.m.GroupHeaderListItem");if(!r&&(i[s].data("item")===e||i[s].data("item")===null)){t.setSelectedItem(i[s],e&&e.getSelected?e.getSelected():true);return true}}return false};x.prototype._updateFilterCounters=function(){var t=this._filterList?this._filterList.getItems():[],e,i,s=0,r=0,n;for(;r<t.length;r++){e=t[r].data("item");s=0;if(e){if(P.isObjectA(e,"sap.m.ViewSettingsCustomItem")){s=e.getFilterCount()}else if(P.isObjectA(e,"sap.m.ViewSettingsFilterItem")){s=0;i=e.getItems();for(n=0;n<i.length;n++){if(i[n].getSelected()){s++}}}}t[r].setCounter(s)}};x.prototype._clearSelectedFilters=function(){var t=this.getFilterItems(),e,i=0,s;for(;i<t.length;i++){if(P.isObjectA(t[i],"sap.m.ViewSettingsFilterItem")){e=t[i].getItems();for(s=0;s<e.length;s++){e[s].setProperty("selected",false,true)}}t[i].setProperty("selected",false,true)}if(this._vContentPage===2&&this._getDialog().isOpen()){this._updateFilterCounters()}};x.prototype._clearPresetFilter=function(){if(this.getSelectedPresetFilterItem()){this.setSelectedPresetFilterItem(null)}};x.prototype._calculateNumberOfPages=function(){var t=0,e=!!this.getSortItems().length,i=!!this.getGroupItems().length,s=!!this.getPresetFilterItems().length,r=!!this.getFilterItems().length;if(e){t++}if(s||r){t++}if(i){t++}this.getCustomTabs().forEach(function(e){if(!this._isEmptyTab(e)){t++}},this);return t};x.prototype._hasSubHeader=function(){return!(this._calculateNumberOfPages()<2)};function k(){this._vContentPage=2;this._oContentItem=null;this._navContainer.to(this._getPage1().getId(),"show")}function R(t,e){var i,s;for(i=0;i<t.length;i++){if(t[i].getKey()===e){s=t[i];break}}return s}function M(t,e,i){var s;if(typeof t==="string"){s=R(e,t);if(!s&&i){E.error(i)}}else{s=t}return s}function H(t){return t&&P.isObjectA(t,"sap.m.ViewSettingsItem")}x.prototype._onConfirm=function(t){var e=this._getDialog(),s=this,r=function(){var t,e,n=s._getSelectedGroupItem();if(!s._oGroupingNoneItem||n!=s._oGroupingNoneItem.getId()){e=i.getElementById(n)}s._toggleDialogTitle(s._sTitleLabelId);t={sortItem:i.getElementById(s._getSelectedSortItem()),sortDescending:s.getSortDescending(),groupItem:e,groupDescending:s.getGroupDescending(),presetFilterItem:i.getElementById(s.getSelectedPresetFilterItem()),filterItems:s.getSelectedFilterItems(),filterKeys:s.getSelectedFilterKeys(),filterCompoundKeys:s.getSelectedFilterCompoundKeys(),filterString:s.getSelectedFilterString()};s._dialog.detachAfterClose(r);s.fireConfirm(t)};if(!s.fireBeforeClose()){return}e.attachAfterClose(r);e.close()};x.prototype._onCancel=function(t){var e=this,i=this._getDialog(),s=function(){e._toggleDialogTitle(e._sTitleLabelId);e.setSelectedSortItem(e._oPreviousState.sortItem);e.setSortDescending(e._oPreviousState.sortDescending);e.setSelectedGroupItem(e._oPreviousState.groupItem);e.setGroupDescending(e._oPreviousState.groupDescending);e.setSelectedPresetFilterItem(e._oPreviousState.presetFilterItem);e._clearSelectedFilters();e.setSelectedFilterCompoundKeys(e._oPreviousState.filterCompoundKeys);if(e._navContainer.getCurrentPage()!==e._oPreviousState.navPage){setTimeout(e._navContainer["to"].bind(e._navContainer,e._oPreviousState.navPage.getId(),"show"),0)}e._switchToPage(e._oPreviousState.contentPage,e._oPreviousState.contentItem);e._dialog.detachAfterClose(s);e.fireCancel()};i.attachAfterClose(s);i.close()};x.prototype.clearFilters=function(){this._clearSelectedFilters();this._clearPresetFilter();this.fireResetFilters();this._updateFilterCounters();if(this._vContentPage===3){setTimeout(this._getNavContainer()["to"].bind(this._getNavContainer(),this._getPage1().getId()),0);this._switchToPage(2);this._getSegmentedButton().setSelectedButton(this._getFilterButton())}this._updateListSelection(this._presetFilterList,i.getElementById(this.getSelectedPresetFilterItem()));return this};x.prototype._addResetButtonToPage1=function(){var t=this._getHeader(),e=this._getSubHeader(),i=this._getResetButton();if(this._showSubHeader){if(!this._getPage1().getSubHeader()){this._getPage1().setSubHeader(e)}}else{if(this._getPage1().getSubHeader()){this._getPage1().setSubHeader()}}t.addContentRight(i)};x.prototype._applyContextualSettings=function(){e.prototype._applyContextualSettings.call(this)};x.prototype._getSelectedSortItem=function(){var t=this.getSelectedSortItem(),e=M(t,this.getSortItems())||i.getElementById(t);if(H(e)){return e.getId()}};x.prototype._getSelectedGroupItem=function(){var t=this.getSelectedGroupItem(),e=M(t,this.getGroupItems())||i.getElementById(t);if(H(e)){return e.getId()}};function K(t,e){if(!this._getPage1(true)){return}if(t==="customTabs"&&e){if(e.getMetadata().getName()===this.getMetadata().getManagedAggregation(t).type&&this._vContentPage===e.getId()){var i=this._getPage1().getContent();i.forEach(function(t){e.addAggregation("content",t,true)})}}else if(!t&&!e){var i=this._getPage1().getContent();this.getCustomTabs().forEach(function(t){if(this._vContentPage===t.getId()){i.forEach(function(e){t.addAggregation("content",e,true)})}},this)}}function W(){var t=[-1,0,1,2,3];return this._getPage1().getContent().length&&t.indexOf(this._vContentPage)===-1}x.prototype.setBusy=function(t){this._getDialog().setBusy(t);return this};var j=function(t){this.sOperator=t||w.StartsWith;switch(this.sOperator){case w.Equals:this.fnOperator=U;break;case w.Contains:this.fnOperator=Y;break;case w.StartsWith:this.fnOperator=q;break;case w.AnyWordStartsWith:this.fnOperator=z;break;default:E.warning("Unknown string compare operator. Use values from sap.m.StringFilterOperator. Default operator should be used.");this.fnOperator=Y;break}};j.prototype.filter=function(t,e){if(!t){return true}if(!e){return false}e=e.toLowerCase();t=t.toLowerCase();return this.fnOperator(t,e)};function U(t,e){return e===t}function Y(t,e){return e.indexOf(t)>-1}function q(t,e){return e.indexOf(t)===0}function z(t,e){var i=new RegExp(".*\\b"+t+".*");return i.test(e)}return x});
//# sourceMappingURL=ViewSettingsDialog.js.map