/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/InvisibleText","./WizardStepRenderer","./Button","sap/ui/events/F6Navigation","sap/ui/thirdparty/jquery","./TitlePropagationSupport","sap/base/Log","sap/ui/core/Lib","sap/ui/core/library"],function(t,e,i,s,n,o,r,jQuery,a,u,p,l){"use strict";var h=l.TitleLevel;var d=e.extend("sap.m.WizardStep",{metadata:{properties:{title:{type:"string",group:"Appearance",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},validated:{type:"boolean",group:"Behavior",defaultValue:true},optional:{type:"boolean",group:"Appearance",defaultValue:false},_titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:h.H3,visibility:"hidden"}},events:{complete:{},activate:{}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_nextButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{subsequentSteps:{type:"sap.m.WizardStep",multiple:true,singularName:"subsequentStep"},nextStep:{type:"sap.m.WizardStep",multiple:false}}},renderer:n});var c=t.ButtonType;a.call(d.prototype,"content",function(){return this.getId()+"-Title"});d.prototype.init=function(){this._oResourceBundle=p.getResourceBundleFor("sap.m");this._oNumberInvisibleText=new s({id:this.getId()+"-NumberedTitle"}).toStatic();this._createNextButton();this._initTitlePropagationSupport()};d.prototype._createNextButton=function(){this._oNextButton=new o(this.getId()+"-nextButton",{text:this._oResourceBundle.getText("WIZARD_STEP")+2,type:c.Emphasized,press:this._complete.bind(this)}).addStyleClass("sapMWizardNextButtonVisible");this.setAggregation("_nextButton",this._oNextButton)};d.prototype.setWizardContext=function(t){["bLast","bReviewStep","sButtonText","bParentAllowsButtonShow"].forEach(function(e){if(typeof t[e]!=="undefined"){this[e]=t[e]}}.bind(this));this._oNextButton.setText(this.sButtonText);this.setLast(this.bLast);this.setButtonVisibility()};d.prototype._getNumberInvisibleText=function(){return this._oNumberInvisibleText};d.prototype._setNumberInvisibleText=function(t){return this._oNumberInvisibleText.setText(this._oResourceBundle.getText("WIZARD_STEP")+t+" "+this.getTitle())};d.prototype.setValidated=function(t){this.setProperty("validated",t,true);this.setButtonVisibility();return this};d.prototype.setNextStep=function(t){this.setAssociation("nextStep",t,true);var e=this._getWizardParent();if(e!==null){e._checkCircularReference(this._getNextStepReference());e._updateProgressNavigator()}return this};d.prototype.onsapskipforward=function(t){t.preventDefault();const e=new jQuery.Event("keydown");e.target=t.target;e.key="F6";if(this._oNextButton.hasStyleClass("sapMWizardNextButtonVisible")){this._oNextButton.focus()}else{r.handleF6GroupNavigation(e)}};d.prototype.setTitle=function(t){var e=this._getWizardParent();this.setProperty("title",t);if(e){e._updateProgressNavigator()}return this};d.prototype.setVisible=function(t){this.setProperty("visible",t,true);u.warning("Don't use the set visible method for wizard steps. If you need to show/hide steps based on some condition - use the branching property of the Wizard instead.");return this};d.prototype._isLeaf=function(){if(this.getNextStep()===null&&this.getSubsequentSteps().length===0){return true}return false};d.prototype._isBranched=function(){return this.getSubsequentSteps().length>1};d.prototype._getNextStepReference=function(){if(this.getNextStep()!==null){return i.getElementById(this.getNextStep())}if(this.getSubsequentSteps().length===1){return i.getElementById(this.getSubsequentSteps()[0])}return null};d.prototype._containsSubsequentStep=function(t){return this.getSubsequentSteps().some(function(e){return e===t})};d.prototype._getWizardParent=function(){var t=this.getParent();while(t&&!t.isA("sap.m.Wizard")){t=t.getParent()}return t};d.prototype.setLast=function(t){this.bLast=t;this.toggleStyleClass("sapMWizardLastActivatedStep",t);this.setButtonVisibility()};d.prototype.setButtonVisibility=function(){var t=this.getValidated()&&this.bParentAllowsButtonShow&&this.bLast;if(typeof t==="undefined"){return}this.displayButton(t)};d.prototype.displayButton=function(t){this._oNextButton.toggleStyleClass("sapMWizardNextButtonHidden",!t);this._oNextButton.toggleStyleClass("sapMWizardNextButtonVisible",t);this._oNextButton.setVisible(t)};d.prototype._activate=function(){this.setLast(true);this.addStyleClass("sapMWizardStepActivated");this.fireActivate()};d.prototype._deactivate=function(){this.removeStyleClass("sapMWizardStepActivated")};d.prototype._complete=function(){var t=this._getWizardParent();this.setLast(this.bReviewStep||false);this.fireComplete();if(t!==null){t._handleNextButtonPress()}};d.prototype.exit=function(){this._oNumberInvisibleText.destroy();this._oNumberInvisibleText=null};return d});
//# sourceMappingURL=WizardStep.js.map