/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/m/Button","sap/m/Bar","sap/m/Title","sap/m/MessageBox","sap/ui/Device","sap/m/Dialog","sap/m/ResponsivePopover","sap/m/p13n/Container","sap/m/p13n/AbstractContainerItem","sap/m/library","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/syncStyleClass","sap/ui/model/json/JSONModel"],(t,e,o,n,s,i,r,a,l,p,c,h,u,g,d,_)=>{"use strict";const{P13nPopupMode:P}=c;const{TitleLevel:C}=g;const f=t.extend("sap.m.p13n.Popup",{metadata:{library:"sap.m",properties:{title:{type:"string"},mode:{type:"sap.m.P13nPopupMode",defaultValue:P.Dialog},warningText:{type:"string"},reset:{type:"function"}},aggregations:{panels:{type:"sap.m.p13n.IContent",multiple:true},additionalButtons:{type:"sap.m.Button",multiple:true}},events:{close:{parameters:{reason:{type:"string"}}}}},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.style("height","100%");t.openEnd();t.renderControl(e.getAggregation("_content"));t.close("div")}}});f.prototype.LOCALIZATION_MODEL="$p13nPopupLocalization";f.prototype.init=function(){t.prototype.init.apply(this,arguments);this._aPanels=[];this._aCustomStyles=[];this.oResourceBundle=u.getResourceBundleFor("sap.m");const e=new _({confirmText:this.oResourceBundle.getText("p13n.POPUP_OK"),cancelText:this.oResourceBundle.getText("p13n.POPUP_CANCEL"),resetText:this.oResourceBundle.getText("p13n.POPUP_RESET")});this.setModel(e,this.LOCALIZATION_MODEL)};f.prototype.isOpen=function(){return!!this._bIsOpen};f.prototype.setMode=function(t){this.setProperty("mode",t);if(this._oPopup){this._oPopup.removeAllContent();this._oPopup.destroy();const t=this._createContainer();this.addDependent(t);this._oPopup=t}return this};f.prototype.setReset=function(t){if(this._oPopup){const t=this._oPopup.getCustomHeader();if(t){t.destroy()}this._oPopup.setCustomHeader(this._createTitle());this._oPopup.invalidate()}this.setProperty("reset",t);return this};f.prototype.open=function(t,e){if(!t&&this.getMode()==="Popover"){throw new Error("Please provide a source control!")}if(!this._oPopup){const t=this._createContainer(e);this.addDependent(t);this._oPopup=t;this._aCustomStyles.forEach(t=>{if(!this._oPopup.hasStyleClass(t)){this._oPopup.addStyleClass(t)}})}if(this.getMode()==="Dialog"){this._oPopup.open()}else{this._oPopup.openBy(t)}if(e?.activePanel){this._getContainer(true).switchView(e.activePanel)}const o=this.getParent();if(o&&o.hasStyleClass instanceof Function&&o.hasStyleClass("sapUiSizeCompact")&&!this._oPopup.hasStyleClass("sapUiSizeCompact")){this._oPopup.addStyleClass("sapUiSizeCompact")}const n=this.getResetButton();if(n){n.setEnabled(e?.enableReset)}this._bIsOpen=true};f.prototype.addStyleClass=function(t){this._aCustomStyles.push(t);this._oPopup?.addStyleClass(t);return this};f.prototype.removeStyleClass=function(t){this._aCustomStyles.splice(this._aCustomStyles.indexOf(t),1);this._oPopup?.removeStyleClass(t)};f.prototype.addPanel=function(t,e){const o=t.getBindingInfo("title");let n;if(o&&o.parts){n={parts:o.parts}}if(t.attachChange instanceof Function){t.attachChange(t=>{this.getResetButton()?.setEnabled(true)})}this._getContainer().addView(new p({key:e||t.getId(),text:n||(t.getTitle instanceof Function?t.getTitle():undefined),content:t}));this._aPanels.push(t);return this};f.prototype.removePanel=function(t){this._aPanels.splice(this._aPanels.indexOf(t),1);this._getContainer().removeView(this._getContainer().getView(t));return this};f.prototype.removeAllPanels=function(){this.getPanels().forEach(t=>{this.removePanel(t)})};f.prototype.getPanels=function(){return this._aPanels};f.prototype.getResetButton=function(){return h.getElementById(this.getId()+"-resetBtn")};f.prototype._createContainer=function(t){t=t?t:{};const e=this["_create"+this.getMode()].call(this,t);e.addStyleClass("sapMP13nPopup");e.isPopupAdaptationAllowed=()=>false;return e};f.prototype._createResponsivePopover=function(t){const e=this.getPanels();const o=e.length>1;const n=new a(this.getId()+"-responsivePopover",{title:this.getTitle(),horizontalScrolling:t.hasOwnProperty("horizontalScrolling")?t.horizontalScrolling:false,verticalScrolling:!o&&!(e[0]&&e[0].getVerticalScrolling instanceof Function&&e[0].getVerticalScrolling()),contentWidth:t.contentWidth?t.contentWidth:"30rem",resizable:t.hasOwnProperty("resizable")?t.resizable:true,contentHeight:t.contentHeight?t.contentHeight:"35rem",placement:t.placement?t.placement:"Bottom",content:o?this._getContainer():e[0],afterClose:()=>{this._onClose(n,"AutoClose")}});n.setCustomHeader(this._createTitle());return n};f.prototype._createDialog=function(t){const o=this.getPanels();const n=o.length>1;let s;if(o.length>0){const t=o[0];s=t.getInitialFocusedControl&&t.getInitialFocusedControl();if(!s&&n){s=this._getContainer()._getTabBar().getItems()[0]}}const a=new r(this.getId()+"-dialog",{initialFocus:s,title:this.getTitle(),horizontalScrolling:t.hasOwnProperty("horizontalScrolling")?t.horizontalScrolling:false,verticalScrolling:!n&&!(o[0]&&o[0].getVerticalScrolling instanceof Function&&o[0].getVerticalScrolling()),contentWidth:t.contentWidth?t.contentWidth:"40rem",contentHeight:t.contentHeight?t.contentHeight:"55rem",draggable:true,resizable:true,stretch:i.system.phone,content:n?this._getContainer():o[0],escapeHandler:()=>{this._onClose(a,"Escape")},buttons:[new e(this.getId()+this._getIdPrefix()+"-confirmBtn",{text:t.confirm?.text??`{${this.LOCALIZATION_MODEL}>/confirmText}`,type:"Emphasized",press:()=>{this._onClose(a,"Ok")}}),new e(this.getId()+this._getIdPrefix()+"-cancelBtn",{text:`{${this.LOCALIZATION_MODEL}>/cancelText}`,press:()=>{this._onClose(a,"Cancel")}})]});a.setCustomHeader(this._createTitle());this.getAdditionalButtons().forEach(t=>{a.addButton(t)});return a};f.prototype._getIdPrefix=()=>"";f.prototype._createTitle=function(){const t=this.getReset();const i=this.getTitle();const r=this.getWarningText();const a=this;let l;if(t instanceof Function){l=new o({contentLeft:[new n({text:i,level:C.H1})]});l.addContentRight(new e(this.getId()+"-resetBtn",{text:`{${this.LOCALIZATION_MODEL}>/resetText}`,press:function(e){const o=e.getSource().getParent().getParent();const n=o.getParent();const i=r;s.warning(i,{actions:[s.Action.OK,s.Action.CANCEL],emphasizedAction:s.Action.OK,onClose:i=>{if(i===s.Action.OK){o.getButtons()[0].focus();e.getSource().setEnabled(false);a._resetPanels();t(n)}}})}}))}return l};f.prototype._resetPanels=function(){this.getPanels().forEach(t=>{if(t.onReset instanceof Function){t.onReset()}})};f.prototype._getContainer=function(t){if(!this._oContainer){this._oContainer=new l}if(this._oContainer.getViews().length>1&&!t){this._oContainer.switchView(this._oContainer.getViews()[1].getKey())}return this._oContainer};f.prototype._onClose=function(t,e){t.close();this._bIsOpen=false;this.fireClose({reason:e})};f.prototype.onlocalizationChanged=function(){this._onLocalizationChanged()};f.prototype.onLocalizationChanged=function(){this._onLocalizationChanged()};f.prototype._onLocalizationChanged=function(){this.oResourceBundle=u.getResourceBundleFor("sap.m");this.getModel(this.LOCALIZATION_MODEL).setProperty("/confirmText",this.oResourceBundle.getText("p13n.POPUP_OK"));this.getModel(this.LOCALIZATION_MODEL).setProperty("/cancelText",this.oResourceBundle.getText("p13n.POPUP_CANCEL"));this.getModel(this.LOCALIZATION_MODEL).setProperty("/resetText",this.oResourceBundle.getText("p13n.POPUP_RESET"))};f.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._oPopup){this._oPopup.destroy()}this._aPanels=null;this._aCustomStyles=null};return f});
//# sourceMappingURL=Popup.js.map