/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/HBox","sap/m/VBox","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/Icon","sap/m/Text","sap/m/Column","sap/m/Table","sap/m/library","sap/m/ToolbarSpacer","sap/m/Button","sap/m/BadgeCustomData","sap/m/Switch","sap/m/Popover","sap/ui/layout/HorizontalLayout","sap/ui/layout/VerticalLayout","sap/m/OverflowToolbar","sap/ui/model/Filter","sap/base/util/merge","sap/ui/core/InvisibleText","sap/ui/core/Popup"],(t,e,o,s,i,n,r,l,a,h,p,c,d,u,_,g,m,y,C,f,S,T,I,L)=>{"use strict";const{IconColor:M}=r;const{ListKeyboardMode:E,FlexJustifyContent:P,FlexAlignItems:O,MultiSelectMode:v,ButtonType:w,ListType:D,PlacementType:A,BadgeAnimationType:B}=c;const N=t.extend("sap.m.p13n.SelectionPanel",{metadata:{library:"sap.m",properties:{title:{type:"string",defaultValue:n.getResourceBundleFor("sap.m").getText("p13n.DEFAULT_TITLE_SELECTION")},showHeader:{type:"boolean",defaultValue:false},enableCount:{type:"boolean",defaultValue:false},fieldColumn:{type:"string",defaultValue:""},activeColumn:{type:"string",defaultValue:""},itemFactory:{type:"function"},multiSelectMode:{type:"sap.m.MultiSelectMode",defaultValue:v.ClearAll}}},renderer:{apiVersion:2}});t.prototype.REDUNDANT_ITEMS_ATTRIBUTE="isRedundant";N.prototype.init=function(){t.prototype.init.apply(this,arguments);this.getModel(this.P13N_MODEL).setProperty("/showSelected",false);this.getModel(this.P13N_MODEL).setProperty("/hideDescriptions",true);this.getModel(this.LOCALIZATION_MODEL).setProperty("/showSelectedText",this._getResourceText("p13n.SHOW_SELECTED"));this.getModel(this.LOCALIZATION_MODEL).setProperty("/hideDescriptionsText",this._getResourceText("p13n.HIDE_DESCRIPTIONS"));this.getModel(this.LOCALIZATION_MODEL).setProperty("/fieldColumn",this._getResourceText("p13n.DEFAULT_DESCRIPTION"));if(this.isPropertyInitial("fieldColumn")){this.bindProperty("fieldColumn",{model:this.LOCALIZATION_MODEL,path:`/fieldColumn`})}};N.prototype.applySettings=function(){t.prototype.applySettings.apply(this,arguments);this._setTemplate(this._getListTemplate());this.addStyleClass("sapMSelectionPanel");this._aInitializedFields=[];this._bShowFactory=false;this.addStyleClass("SelectionPanelHover");this._displayColumns();this._updateMovement(this.getEnableReorder());this._oListControl.setMultiSelectMode(this.getMultiSelectMode())};N.prototype.setMultiSelectMode=function(t){this._oListControl.setMultiSelectMode(t);return this.setProperty("multiSelectMode",t)};N.prototype.setItemFactory=function(t){this.setProperty("itemFactory",t);this._oListControl.setGrowing(!!t);return this};N.prototype._getListTemplate=function(){const t=new o({selected:"{"+this.P13N_MODEL+">"+this.PRESENCE_ATTRIBUTE+"}",type:{path:this.P13N_MODEL+">"+this.PRESENCE_ATTRIBUTE,formatter:t=>t&&!this._bShowFactory?D.Active:D.Inactive},cells:[new i({items:[new e({wrapping:true,required:"{"+this.P13N_MODEL+">required}",tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">label}"})]}),new s({justifyContent:P.Center,items:[new l({src:"sap-icon://circle-task-2",size:"0.5rem",color:M.Neutral,visible:{path:this.P13N_MODEL+">active",formatter:function(t){if(t){return true}else{return false}}}})]})]});if(this.getActiveColumn()){const e=new I({text:{path:this.P13N_MODEL+">active",formatter:t=>t?this._getResourceText("p13n.ACTIVESTATE_ACTIVE"):this._getResourceText("p13n.ACTIVESTATE_INACTIVE")}});t.getCells()[1].addItem(e)}return t};N.prototype.setActiveColumn=function(t){this.setProperty("activeColumn",t);this._setTemplate(this._getListTemplate());this._displayColumns();return this};N.prototype.setFieldColumn=function(t){this.setProperty("fieldColumn",t);this._displayColumns();return this};N.prototype._getListFilterLayout=function(){const t=this.getP13nData()??[];const e=t.some(t=>t[this.REDUNDANT_ITEMS_ATTRIBUTE]);if(!e){const t=new u({press:t=>{const e=this.getModel(this.P13N_MODEL).getProperty("/showSelected");this.getModel(this.P13N_MODEL).setProperty("/showSelected",!e);this._triggerFilter();this._updateShowSelectedButton()},text:`{${this.LOCALIZATION_MODEL}>/showSelectedText}`});this._updateShowSelectedButton();return t}else{const t=new u({icon:"sap-icon://filter",type:w.Transparent,press:e=>{this._getFilterPopover().openBy(t)}});t.addCustomData(new _({key:"badge",value:{parts:[{path:this.P13N_MODEL+">/showSelected"},{path:this.P13N_MODEL+">/hideDescriptions"}],formatter:(t,e)=>[t,e].filter(Boolean).length},visible:true,animation:B.None}));const e=new y({content:[t]});return e}};N.prototype.setShowHeader=function(t){if(t){this._oListControl.setHeaderToolbar(new f({content:[this._getSearchField(),new d,this._getListFilterLayout()]}))}this.setProperty("showHeader",t);return this};N.prototype._triggerFilter=function(){const t=this.getModel(this.P13N_MODEL).getProperty("/showSelected");const e=this.getModel(this.P13N_MODEL).getProperty("/hideDescriptions");this._filterList(t,this._sSearch,e)};N.prototype._updateShowSelectedButton=function(){const t=this._getResourceText("p13n.SHOW_SELECTED");const e=this._getResourceText("p13n.SHOW_ALL");const o=this.getModel(this.P13N_MODEL).getProperty("/showSelected");this.getModel(this.LOCALIZATION_MODEL).setProperty("/showSelectedText",o?e:t)};N.prototype._getFilterPopover=function(){const t=this.getDependents().find(t=>t.isA("sap.m.Popover"));if(t){return t}const o=new e({text:`{${this.LOCALIZATION_MODEL}>/showSelectedText}`});o.addStyleClass("sapMSelectionPanelFilters");const n=new e({text:`{${this.LOCALIZATION_MODEL}>/hideDescriptionsText}`});n.addStyleClass("sapMSelectionPanelFilters");const r=new g({state:`{${this.P13N_MODEL}>/showSelected}`,ariaLabelledBy:o,customTextOn:" ",customTextOff:" ",change:this._triggerFilter.bind(this)});const l=new g({state:`{${this.P13N_MODEL}>/hideDescriptions}`,ariaLabelledBy:n,customTextOn:" ",customTextOff:" ",change:this._triggerFilter.bind(this)});const a=new s({alignItems:O.Center,items:[n,l]});a.addStyleClass("sapMSelectionPanelFiltersContainer");const h=new s({alignItems:O.Center,items:[o,r]});h.addStyleClass("sapMSelectionPanelFiltersContainer");const p=new i({alignItems:O.End,items:[a,h]});p.addStyleClass("sapMSelectionPanelFiltersPopover");const c=new m({title:this._getResourceText("p13n.FILTERS_POPOVER_TITLE"),placement:A.Bottom,content:[p],beforeOpen:function(t){const e=t.getSource();e.setFollowOf(true)},afterOpen:function(t){const e=t.getSource();e.setFollowOf(false)}});this.addDependent(c);return c};N.prototype.getSelectedFields=function(){const t=[];this._loopItems(this._oListControl,(e,o)=>{if(e.getSelected()){t.push(o)}});return t};N.prototype._filterList=function(t,e,o){let s=[],i=[],n=[];if(t){i=new S(this.PRESENCE_ATTRIBUTE,"EQ",true)}if(o){const t=new S(this.PRESENCE_ATTRIBUTE,"EQ",true);const e=new S(this.REDUNDANT_ITEMS_ATTRIBUTE,"NE",true);n=new S([t,e],false)}if(e){s=new S("label","Contains",e)}this._oListControl.getBinding("items").filter(new S([].concat(i,s,n),true))};N.prototype._onSearchFieldLiveChange=function(t){this._sSearch=t.getSource().getValue();this._filterList(this.getModel(this.P13N_MODEL).getProperty("/showSelected"),this._sSearch,this.getModel(this.P13N_MODEL).getProperty("/hideDescriptions"))};N.prototype._handleActivated=function(t){if(this._oHoveredItem!==t||!t.getMultiSelectControl()?.getSelected()){this._removeMoveButtons()}if(this._oHoveredItem&&!this._oHoveredItem.bIsDestroyed&&this._oHoveredItem.getBindingContextPath()){const t=!!this._getP13nModel().getProperty(this._oHoveredItem.getBindingContextPath()).active;const[e]=this._oHoveredItem.getCells()[1].getItems();e.setVisible(t)}const e=t.getCells()[1]?.getItems()[0];if(t.getSelected()&&e){e.setVisible(false)}if(this._oHoveredItem===t&&this._oLastSelectedItem!==t&&t.getMultiSelectControl()?.getEnabled()){return}this._oHoveredItem=t;this._oLastSelectedItem=null;if(t.getMultiSelectControl()?.getEnabled()&&t.getMultiSelectControl()?.getSelected()||!t.getMultiSelectControl()){this._updateEnableOfMoveButtons(t,false);this._addMoveButtons(t)}};N.prototype._removeMoveButtons=function(){const t=this._getMoveButtonContainer();if(t){t.removeItem(this._getMoveTopButton());t.removeItem(this._getMoveUpButton());t.removeItem(this._getMoveDownButton());t.removeItem(this._getMoveBottomButton())}};N.prototype._getMoveButtonContainer=function(){if(this._oMoveBottomButton&&this._oMoveBottomButton.getParent()&&this._oMoveBottomButton.getParent().isA("sap.m.FlexBox")){return this._oMoveBottomButton.getParent()}};N.prototype.showFactory=function(t){this._bShowFactory=t;this._displayColumns();this._oListControl.getItems().forEach(e=>{e.setType(t?"Inactive":"Active")});if(t){this.removeStyleClass("SelectionPanelHover");this._oListControl.setKeyboardMode(E.Edit);this._addFactoryControl()}else{this.addStyleClass("SelectionPanelHover");this._oListControl.setKeyboardMode(E.Navigation);this._removeFactoryControl()}};N.prototype._loopItems=function(t,e){t.getItems().forEach(t=>{const o=t.getBindingContextPath();const s=this._getP13nModel().getProperty(o).name;e.call(this,t,s)})};N.prototype.setP13nData=function(e){if(this.getEnableCount()){e=T([],e);this._oListControl.removeSelections()}t.prototype.setP13nData.call(this,e);this._updateCount();this._removeMoveButtons();this._oSelectedItem=null;this.setShowHeader(this.getShowHeader());const o=e.some(t=>t[this.REDUNDANT_ITEMS_ATTRIBUTE]);if(o){this._triggerFilter()}return this};N.prototype.onReset=function(){t.prototype.onReset.apply(this,arguments);this._sSearch="";this.getModel(this.P13N_MODEL).setProperty("/showSelected",false);this._updateShowSelectedButton()};N.prototype._updateCount=function(){this._getP13nModel().setProperty("/selectedItems",this._oListControl.getSelectedContexts(true).length)};N.prototype._selectTableItem=function(e,o){t.prototype._selectTableItem.apply(this,arguments);this._updateCount()};N.prototype._removeFactoryControl=function(){this._oListControl.getItems().forEach(t=>{const e=t.getCells()[0];if(e.getItems().length>1){e.removeItem(e.getItems()[1])}});this.removeStyleClass("sapUiMDCAFLabelMarkingList");return this._aInitializedFields};N.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveButtonContainer()?.getParent();t.prototype._moveSelectedItem.apply(this,arguments)};N.prototype._getShowFactory=function(){return this._bShowFactory};N.prototype._updateMovement=function(e){t.prototype._updateMovement.apply(this,arguments);this._displayColumns()};N.prototype._displayColumns=function(){const t=[this.getFieldColumn()];const e=this.getEnableReorder()||this.getActiveColumn();if(!this._bShowFactory&&e){t.push(new h({width:"30%",hAlign:"Center",vAlign:"Middle",header:new a({text:this.getActiveColumn()})}))}this._setPanelColumns(t)};N.prototype._setPanelColumns=function(e){this._sText=e[0];const o=this.getEnableCount();if(o){const t=new h({header:new a({text:{parts:[{path:this.P13N_MODEL+">/selectedItems"},{path:this.P13N_MODEL+">/items"}],formatter:(t,e)=>this._sText+" "+this._getResourceText("p13n.HEADER_COUNT",[t,e instanceof Array?e.length:0])}})});e[0]=t}t.prototype._setPanelColumns.apply(this,arguments)};N.prototype._addFactoryControl=function(t){this._oListControl.getItems().forEach(t=>{const e=t.getBindingContext(this.P13N_MODEL);const o=this.getItemFactory().call(this,e);const s=t.getCells()[0];const i=s.getItems()[0];if(i){i.setLabelFor(o)}s.addItem(o)});this.addStyleClass("sapUiMDCAFLabelMarkingList")};N.prototype._createInnerListControl=function(){const t=new p(this.getId()+"-innerSelectionPanelTable",Object.assign({growing:false,growingThreshold:25,growingScrollToLoad:true,updateStarted:()=>{this._removeMoveButtons();this._removeFactoryControl()},updateFinished:()=>{if(this._getShowFactory()){this._addFactoryControl()}}},this._getListControlConfig()));const e=t.onItemFocusIn;t.onItemFocusIn=function(o,s){if(this.getEnableReorder()){this._handleActivated(o)}e.apply(t,arguments)}.bind(this);return t};N.prototype.filterContent=function(t){if(this._oListControl.getBinding("items")){this._oListControl.getBinding("items").filter(t,true)}};N.prototype._addMoveButtons=function(t){const e=t;if(!e){return}const o=this._getP13nModel().getProperty(e.getBindingContextPath())[this.PRESENCE_ATTRIBUTE];if(o){e.getCells()[1].addItem(this._getMoveTopButton());e.getCells()[1].addItem(this._getMoveUpButton());e.getCells()[1].addItem(this._getMoveDownButton());e.getCells()[1].addItem(this._getMoveBottomButton())}};N.prototype._updateLocalizationTexts=function(){this.getModel(this.LOCALIZATION_MODEL).setProperty("/showSelectedText",this._getResourceText("p13n.SHOW_SELECTED"));this.getModel(this.LOCALIZATION_MODEL).setProperty("/showAllText",this._getResourceText("p13n.SHOW_ALL"));this.getModel(this.LOCALIZATION_MODEL).setProperty("/hideDescriptionsText",this._getResourceText("p13n.HIDE_DESCRIPTIONS"));this.getModel(this.LOCALIZATION_MODEL).setProperty("/fieldColumn",this._getResourceText("p13n.DEFAULT_DESCRIPTION"));this._updateShowSelectedButton()};N.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._aInitializedFields=null;this._oHoveredItem=null;this._bShowFactory=null;this._sSearch=null};return N});
//# sourceMappingURL=SelectionPanel.js.map