/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./PluginBase","sap/base/i18n/Localization","sap/base/util/deepEqual","sap/ui/events/KeyCodes","sap/ui/core/Element","sap/m/library","sap/ui/core/InvisibleRenderer"],function(e,t,o,i,n,s,l){"use strict";const r=s.ListMode;const c=250;const a=c*2;const h={ROW:"row",COL:"col"};const g={Cell:"Cell",Other:"Other",Ignore:"Ignore"};var u=e.extend("sap.m.plugins.CellSelector",{metadata:{library:"sap.m",properties:{rangeLimit:{type:"int",group:"Behavior",defaultValue:200},enabled:{type:"boolean",defaultValue:true}},events:{selectionChange:{}}}});u.findOn=e.findOn;const d={onkeydown:function(e){if(!this._bSelecting){return}if(I(e,i.A,true,true)||I(e,i.A,false,true)&&e.isMarked(this.getConfig("eventClearedAll"))){if(m(e.target,this.getConfig("selectableCells"))){this.removeSelection();e.preventDefault()}}else if(I(e,i.SPACE,true,false)||I(e,i.SPACE,false,true)){e.preventDefault()}}};const f={onBeforeRendering:function(){this._iBtt=this.getConfig("isBottomToTop",this.getControl())?-1:1;if(this._oResizer){this._oResizer.remove();this._oResizer=null}},onAfterRendering:function(){this._deregisterEvents();this._registerEvents();this._bSelecting&&!this._bMouseDown&&this.removeSelection();this._bSelecting&&this._selectCells();this._bRenderResizer=this.getConfig("shouldRenderResizer",this.getControl())},onsapupmodifiers:function(e){this._onsaparrowmodifiers(e,h.ROW,-1,0)},onsapdownmodifiers:function(e){this._onsaparrowmodifiers(e,h.ROW,1,0)},onsapspace:function(e){if(m(e.target,this.getConfig("selectableCells"))){e.preventDefault()}},onsapleftmodifiers:function(e){this._onsaparrowmodifiers(e,h.COL,0,-1)},onsaprightmodifiers:function(e){this._onsaparrowmodifiers(e,h.COL,0,1)},onsapescape:function(e){if(e.isMarked()){return}if(this._bSelecting&&m(e.target,this.getConfig("selectableCells"))){this.removeSelection();e.preventDefault();e.stopPropagation()}},onkeyup:function(e){if(e.isMarked()||!this.getConfig("isSupported",this.getControl(),this)){return}if(I(e,i.SPACE,true,false)){const t=this._bSelecting?this._getNormalizedBounds(this._oSession.mSource,this._oSession.mTarget):{};const o=this.getConfig("getCellInfo",this.getControl(),e.target,this._oPreviousCell);if(!this._inSelection(e.target)){t.from=t.to={};t.from.rowIndex=t.to.rowIndex=o.rowIndex}this.getConfig("selectRows",this.getControl(),t.from.rowIndex,t.to.rowIndex,o.rowIndex);e.setMarked();e.preventDefault()}else if(I(e,i.SPACE,false,false)){if(!m(e.target,this.getConfig("selectableCells"))){return}this._oPreviousCell=null;this._startSelection(e,false);e.setMarked()}},onmousedown:function(e){if(e.isMarked?.()||e.button!=0){return}var t=this._getSelectableCell(e.target);if(!t){return}const o=this.getConfig("getCellInfo",this.getControl(),t,this._oPreviousCell);this._bMouseDown=true;if(e.shiftKey){if(this._oPreviousCell?.rowIndex!==o.rowIndex||this._oPreviousCell?.colIndex!==o.colIndex){window.getSelection().removeAllRanges();if(this._oOriginCell){this._selectCells(this._oOriginCell,o);e.preventDefault();e.setMarked?.()}}}this._mClickedCell=this._oPreviousCell=o;if(e.ctrlKey||e.metaKey){this._startSelection(e);if(this._mClickedCell){this.getConfig("focusCell",this.getControl(),this._mClickedCell)}}},onmouseup:function(e){clearTimeout(this._iTimer);this._bMouseDown=false;this._bBorderDown=false;this._mClickedCell=undefined;this._bScrolling=false;this._mTempCell=undefined;this._oHoveredCell=undefined;this._endSelection(e);this._clearScroller();setTimeout(()=>{this._startTarget=null},0)},onclick:function(e){var t=this._getSelectableCell(e.target);if(t&&this._startTarget===t){e.stopPropagation()}}};function C(){return t.getRTL()?-1:1}u.prototype.init=function(){this._iRtl=C()};u.prototype.onLocalizationChanged=function(){this._iRtl=C();this._iBtt=this.getConfig("isBottomToTop",this.getControl())?-1:1;this.removeSelection()};u.prototype.onActivate=function(e){e.addDelegate(f,true,this);e.addDelegate(d,false,this);this._oSession={cellRefs:[],cellTypes:[]};this._iBtt=this.getConfig("isBottomToTop",this.getControl())?-1:1;this._mTimeouts={};this._fnControlUpdate=function(e){if(this._bScrolling){this._scrollSelect(this._oSession.scrollForward,this._oSession.isVertical,e)}else{if(!this._oSession.mSource||!this._oSession.mTarget){return}this._drawSelection(this._oSession.mSource,this._oSession.mTarget)}}.bind(this);this._fnOnMouseEnter=this._onmouseenter.bind(this);this._fnOnMouseOut=this._onmouseout.bind(this);this._fnOnMouseMove=this._onmousemove.bind(this);this._fnOnMouseUp=f.onmouseup.bind(this);this._fnOnClick=f.onclick.bind(this);this._fnRemoveSelection=this.removeSelection.bind(this);this._registerEvents();this._onSelectableChange()};u.prototype.onDeactivate=function(e){e.removeDelegate(f,this);e.removeDelegate(d,this);if(this._oSession){this.removeSelection();this._oSession=null;this._mTimeouts=null}this._deregisterEvents();this._onSelectableChange()};u.prototype.exit=function(){if(this.getControl()&&!this.getControl().isDestroyed()&&this._oSession){this.removeSelection()}this._deregisterEvents();this._oSession=null;this._mTimeouts=null;e.prototype.exit.call(this)};u.prototype.isSelectable=function(){return this.isActive()?this.getConfig("isSupported",this.getControl(),this):false};u.prototype.hasSelection=function(){return Boolean(this._bSelecting&&this._oSession?.mSource)};u.prototype._onSelectableChange=function(){this.getPlugin("sap.m.plugins.CopyProvider")?.onCellSelectorSelectableChange(this)};u.prototype._onSelectionChange=function(){this.fireSelectionChange()};u.prototype._registerEvents=function(){var e=this.getControl();if(e){this.getConfig("scrollEvent")&&e.attachEvent(this.getConfig("scrollEvent"),this._fnControlUpdate);this.getConfig("attachSelectionChange",e,this._fnRemoveSelection);this.getConfig("attachBindingUpdate",e,this);var t=e.getDomRef(this.getConfig("scrollArea"));if(t){t.addEventListener("mouseleave",this._fnOnMouseOut);t.addEventListener("mouseenter",this._fnOnMouseEnter);t.addEventListener("mousemove",this._fnOnMouseMove);t.addEventListener("click",this._fnOnClick)}}document.addEventListener("mouseup",this._fnOnMouseUp)};u.prototype._deregisterEvents=function(){var e=this.getControl();if(e){this.getConfig("scrollEvent")&&e.detachEvent(this.getConfig("scrollEvent"),this._fnControlUpdate);this.getConfig("detachSelectionChange",e,this._fnRemoveSelection);this.getConfig("detachBindingUpdate",e,this._fnOnBindingUpdate);var t=e.getDomRef(this.getConfig("scrollArea"));if(t){t.removeEventListener("mouseleave",this._fnOnMouseOut);t.removeEventListener("mouseenter",this._fnOnMouseEnter);t.removeEventListener("mousemove",this._fnOnMouseMove);t.removeEventListener("click",this._fnOnClick)}}document.removeEventListener("mouseup",this._fnOnMouseUp)};u.prototype.getSelectionRange=function(e){if(!this._bSelecting){return null}var t=this._getNormalizedBounds(this._oSession.mSource,this._oSession.mTarget);if(isNaN(t.from.rowIndex)||isNaN(t.to.rowIndex)){return null}var o=this.getConfig("numberOfColumns",this.getControl(),true)-1;t.from.colIndex=Math.max(t.from.colIndex,0);t.to.colIndex=this._oSession.cellTypes.includes(g.Other)?o:Math.min(t.to.colIndex,o);t.from.rowIndex=Math.max(t.from.rowIndex,0);if(e){t.ignoredRows=[];const e=this.getSelectedRowContexts();e.forEach((e,o)=>{const i=t.from.rowIndex+o;if(_(this._getBinding(),e,i)){t.ignoredRows.push(i)}})}delete t.from.type;delete t.to.type;return t};u.prototype.getSelectedRowContexts=function(){var e=this.getSelectionRange();if(!e){return[]}return this.getConfig("getSelectedRowContexts",this.getControl(),e.from.rowIndex,e.to.rowIndex,this.getRangeLimit())};u.prototype.getSelection=function(e){var t=this.getSelectionRange();if(!t){return{rows:[],columns:[]}}var o=this.getConfig("getSelectedRowContexts",this.getControl(),t.from.rowIndex,t.to.rowIndex,this.getRangeLimit());if(e){o=o.filter((e,o)=>!_(this._getBinding(),e,o+t.from.rowIndex))}var i=this.getConfig("getVisibleColumns",this.getControl(),true).slice(t.from.colIndex,t.to.colIndex+1);if(this.getControl().getParent().isA("sap.ui.mdc.Table")){i=i.map(function(e){return n.getElementById(e.getId().replace(/\-innerColumn$/,""))})}return{rows:o,columns:i}};u.prototype.removeSelection=function(){this._clearSelection();const e=this._oSession?.mSource||this._oSession?.mTarget;this._bSelecting=false;this._mClickedCell=this._oPreviousCell=this._oHoveredCell=this._oOriginCell=null;this._oSession={cellRefs:[],cellTypes:[]};if(e){this._onSelectionChange()}};u.prototype._onsaparrowmodifiers=function(e,t,o,i){if(!this._shouldBeHandled(e)||!e.shiftKey||!this._getSelectableCell(e.target)||e.ctrlKey||e.metaKey||e.altKey){this._oPreviousCell=undefined;return}var n=this._getSelectableCell(e.target);if(!n){return}var s=this.getConfig("getCellInfo",this.getControl(),n,this._oPreviousCell);if(s.rowIndex<0||s.colIndex<0){return}if(!this._inSelection(e.target)||!this._oSession.mSource||!this._oSession.mTarget){if(this.getConfig("isRowSelected",this.getControl(),s.rowIndex)){return}this._oSession.mSource=this._oSession.mTarget=s;this._oPreviousCell=null}if(s.type==g.Ignore){if(t==h.COL||!this._oPreviousCell){return}s.colIndex=this._oPreviousCell.colIndex}this._oPreviousCell=s;var l=this._getNormalizedBounds(this._oSession.mSource,this._oSession.mTarget);const{from:r,to:c,focus:a}=this._getUpdatedBounds(o*this._iBtt,i*this._iRtl,s);if(a[t+"Index"]<0||a.colIndex>=this.getConfig("numberOfColumns",this.getControl())){return}this.getConfig("focusCell",this.getControl(),a,true,o>0);if(t==h.ROW&&(s.rowIndex==l.from.rowIndex||s.rowIndex==l.to.rowIndex)||t==h.COL&&(s.colIndex==l.from.colIndex||s.colIndex==l.to.colIndex)){this._bSelecting=true;this._selectCells(r,c)}e.setMarked();e.preventDefault();e.stopPropagation()};u.prototype._onmousemove=function(e){function t(){if(this._bBorderDown&&!this._bScrolling){var t=this._oSession.border;var o={colIndex:isNaN(t.colIndex)?0:i.colIndex-t.colIndex,rowIndex:isNaN(t.rowIndex)?0:i.rowIndex-t.rowIndex};if(o.rowIndex!=0||o.colIndex!=0){const{from:e,to:i}=this._getUpdatedBounds(o.rowIndex,o.colIndex,t);this._selectCells(e,i)}}else{this._startSelection(e,true)}this.getConfig("focusCell",this.getControl(),i,false);this._oPreviousCell=i;this._oHoveredCell=i}if(this._bSelecting&&!this._bMouseDown&&this._bRenderResizer){const t=this._getNormalizedBounds(this._oSession.mSource,this._oSession.mTarget);this._updateResizers(t,e.clientX,e.clientY)}var o=this._getSelectableCell(e.target);if(!o||!this._bMouseDown){return}clearTimeout(this._iTimer);e.stopImmediatePropagation();var i=this.getConfig("getCellInfo",this.getControl(),o,this._oPreviousCell);if(i.rowIndex<0||i.colIndex<0){return}const n=i.rowIndex==this._oPreviousCell?.rowIndex&&i.colIndex==this._oPreviousCell?.colIndex;if(n||i.type==g.Ignore){return}if(i.type==g.Other&&this._oHoveredCell?.rowIndex==i.rowIndex&&this._oHoveredCell?.colIndex==i.colIndex){return}window.getSelection().removeAllRanges();if(!this._oSession.mSource&&!this._oSession.mTarget){this._oSession.mSource=this._oSession.mTarget=this._mClickedCell}this._oHoveredCell=null;if(this._oPreviousCell&&this._oPreviousCell.type!=i.type){this._iTimer=setTimeout(t.bind(this),c);return}if(this._mClickedCell&&this._mClickedCell.type==g.Other&&this._oPreviousCell?.type==g.Cell&&i.type==g.Other){this._iTimer=setTimeout(t.bind(this),a)}else{if(i.type==g.Other&&this._mClickedCell.type!=g.Other){const e=this._getNormalizedBounds(this._oSession.mSource,this._oSession.mTarget);this._mTempCell=this._mClickedCell;this._mClickedCell=e.from}else{this._mClickedCell=this._mTempCell??this._mClickedCell}t.call(this)}};u.prototype._onmouseout=function(e){var t=this.getControl().getDomRef(this.getConfig("scrollArea"));if(!t||!this._bMouseDown){return}var o=t.getBoundingClientRect();var i,n;this._bScrolling=false;if(e.clientY>o.bottom||e.clientY<o.top){this._oSession.scrollForward=i=e.clientY>o.bottom;this._oSession.isVertical=n=true;this._bScrolling=true}if(e.clientX>o.right||e.clientX<o.left){this._oSession.scrollForward=i=e.clientX>o.right;this._oSession.isVertical=n=false;this._bScrolling=true}if(this._bScrolling){this._doScroll(i,n,e)}};u.prototype._onmouseenter=function(e){this._bScrolling=false;this._clearScroller()};u.prototype._doScroll=function(e,t,o){this._clearScroller();if(this._bScrolling){this.getConfig("scroll",this.getControl(),e,t);this._mTimeouts.scrollTimerId=setTimeout(this._doScroll.bind(this,e,t),a);if(!t){this._scrollSelect(e,t,o)}}};u.prototype._scrollSelect=function(e,t,o){if(!this._bSelecting){return}var i=this._getNormalizedBounds(this._oSession.mSource,this._oSession.mTarget);if(this._bScrolling){var n=t?h.ROW:h.COL;var s={row:0,col:0};var l=e?"to":"from";s[n]=e?1:-1;let o=i[l];if(this._bBorderDown){o=this._oSession.border}const{from:r,to:c}=this._getUpdatedBounds(s[h.ROW],s[h.COL],o);this._selectCells(r,c)}};u.prototype._clearScroller=function(){if(this._mTimeouts.scrollTimerId){window.clearTimeout(this._mTimeouts.scrollTimerId);this._mTimeouts.scrollTimerId=null}};u.prototype._onborderdown=function(e){this._oSession.border=Object.assign({},this._oCurrentBorder);this._bBorderDown=true;this._bMouseDown=true};u.prototype._getSelectableCell=function(e){if(!e){return}return e.closest(this.getConfig("selectableCells"))};u.prototype._inSelection=function(e){var t=this.getConfig("getCellInfo",this.getControl(),e,this._oPreviousCell);if(!t||!this._oSession.mSource||!this._oSession.mTarget){return false}var o=this._getNormalizedBounds(this._oSession.mSource,this._oSession.mTarget);const i=!(t.rowIndex<o.from.rowIndex||t.rowIndex>o.to.rowIndex||t.colIndex<o.from.colIndex||t.colIndex>o.to.colIndex);const n=t.type==g.Other&&this._oSession.cellTypes.includes(g.Other);return i||n};u.prototype._startSelection=function(e,t){if(!this._shouldBeHandled(e)){return}var o=this._getSelectableCell(e.target);if(!o){return}if(!this._bSelectionInProgress){this.getConfig("onSelectionStart",this.getControl(),e);this._bSelectionInProgress=true;if(this._oPreviousCell){this._startTarget=this.getConfig("getCellRef",this.getControl(),this._oPreviousCell)}}if(this._inSelection(o)&&!t){this.removeSelection()}else{var i=this.getConfig("getCellInfo",this.getControl(),o,this._oPreviousCell);var n=this._mClickedCell?this._mClickedCell:i;this._bSelecting=true;this._oSession.mSource=i;this._selectCells(n,i);this._oPreviousCell=i;this._oOriginCell=n}e.preventDefault();e.setMarked&&e.setMarked()};u.prototype._endSelection=function(e){if(!this._bSelectionInProgress){return}this._bSelectionInProgress=false;var t=this._getSelectableCell(e.target);if(!t){return}this.getConfig("onSelectionEnd",this.getControl(),e)};u.prototype._getUpdatedBounds=function(e,t,o){var i=this._getNormalizedBounds(this._oSession.mSource,this._oSession.mTarget);var n=Object.assign({},o);var s=n.rowIndex==i.from.rowIndex?"from":"to";var l=n.colIndex==i.from.colIndex?"from":"to";i[s].rowIndex=Math.max(i[s].rowIndex+e,0);i[l].colIndex=Math.max(i[l].colIndex+t,0);const r=this.getConfig("getCellRef",this.getControl(),i[l]);if(r){i[l].type=this.getConfig("getCellType",this.getControl(),r)}if(!this._bBorderDown){n.rowIndex=Math.max(0,n.rowIndex+e);n.colIndex=Math.max(0,n.colIndex+t)}else{this._oSession.border.rowIndex+=e;this._oSession.border.colIndex+=t}return{from:i.from,to:i.to,focus:n}};u.prototype._selectCells=function(e,t){if(!this._bSelecting){return}e=e?e:this._oSession.mSource;t=t?t:this._oSession.mTarget;this._oSession.cellTypes=[e.type];if(!this._oSession.cellTypes.includes(t.type)){this._oSession.cellTypes.push(t.type)}if(t.rowIndex==Infinity||e.rowIndex==Infinity){this.getConfig("loadContexts",this.getControl(),Math.max(Math.min(e,t),0),this.getRangeLimit())}this._drawSelection(e,t);if(!o(this._oSession.mSource,e)||!o(this._oSession.mTarget,t)){this._oSession.mSource=e;this._oSession.mTarget=t;this._onSelectionChange()}};u.prototype._drawSelection=function(e,t){const o=!isFinite(e.rowIndex)||!isFinite(t.rowIndex);const i=this._getNormalizedBounds(e,t,o);if(!i.from||!i.to){return}this._clearSelection();this._oSession.cellRefs=[];const n=this._oSession.cellTypes.includes(g.Other);for(var s=i.from.rowIndex;s<=i.to.rowIndex;s++){if(this._oSession.cellTypes.includes(g.Cell)){for(var l=i.from.colIndex;l<=i.to.colIndex;l++){const e={rowIndex:s,colIndex:l};var r=this.getConfig("getCellRef",this.getControl(),e);if(r){const t=this.getConfig("drawCellBorder",this.getControl(),r,e,i);this._oSession.cellRefs.push(...t)}}}if(n){const e=this.getConfig("numberOfColumns",this.getControl())-1;const t={rowIndex:s,colIndex:e};const o=this.getConfig("getCellRef",this.getControl(),t);if(o){const e=this.getConfig("drawCellBorder",this.getControl(),o,t,i);this._oSession.cellRefs.push(...e)}}}};u.prototype._updateResizers=function(e,t,o){var i=this._getResizer();if(this._iRtl==-1){const t=e.from.colIndex;e.from.colIndex=e.to.colIndex;e.to.colIndex=t}var n=this.getConfig("getCellRef",this.getControl(),e.from,false),s=this.getConfig("getCellRef",this.getControl(),e.to,false);var l={0:false,1:false};if(!n){l[0]=true;n=this.getConfig("getCellRef",this.getControl(),e.from,true)}if(!s){l[1]=true;s=this.getConfig("getCellRef",this.getControl(),e.to,true)}if(!n||!s){return}var r=n.getBoundingClientRect(),c=s.getBoundingClientRect(),a=this.getControl().getDomRef().getBoundingClientRect();var g={x:{0:r.left-a.left,1:c.left+c.width-a.left},y:{0:r.top-a.top,1:c.top+c.height-a.top}};var u={x:{0:t-r.left,1:t-c.right},y:{0:o-r.top,1:o-c.bottom}};var d=0;d|=Math.abs(u.x[0])<Math.abs(u.x[1])?0:1;d|=Math.abs(u.y[0])<Math.abs(u.y[1])?0:2;var f=Math.abs(u.x[d&1]),C=Math.abs(u.y[d>>1&1]);if(f>10&&C>10||f>10&&l[d>>1&1]){return}i.style.left=f<=10?g.x[d&1]+"px":g.x[0]+"px";i.style.top=C<=10?g.y[d>>1&1]+"px":g.y[0]+"px";i.style.width=f<=10?"":c.right-r.left+"px";i.style.height=f<=10?c.bottom-r.top+"px":"";const m=f<=10,_=C<=10;i.classList.toggle("sapMPluginsVerticalBorder",m);i.classList.toggle("sapMPluginsHorizontalBorder",_);i.classList.toggle("sapMPluginsEdge",m&&_);i.classList.toggle("sapMPluginsNESW",m&&_&&(d==2||d==1));i.classList.toggle("sapMPluginsNWSE",m&&_&&(d==3||d==0));this._oCurrentBorder={};if(m){this._oCurrentBorder.colIndex=d&1?e.to.colIndex:e.from.colIndex;this._oCurrentBorder.type=h.COL}if(_){this._oCurrentBorder.rowIndex=d>>1&1?e.to.rowIndex:e.from.rowIndex;this._oCurrentBorder.type=h.ROW}};u.prototype._getResizer=function(){if(!this._oResizer){this._oResizer=document.createElement("div");this._oResizer.setAttribute("id","cs-rsz");this._oResizer.classList.add("sapMPluginsCellSelectorRsz");this._oResizer.addEventListener("mousedown",this._onborderdown.bind(this));if(this.getControl().getDomRef()){this.getControl().getDomRef().appendChild(this._oResizer)}}return this._oResizer};u.prototype._clearSelection=function(){this._oSession?.cellRefs?.forEach(function(e){e.classList.remove("sapMPluginsCellSelectorSelected","sapMPluginsCellSelectorTop","sapMPluginsCellSelectorBottom","sapMPluginsCellSelectorLeft","sapMPluginsCellSelectorRight");e.removeAttribute("aria-selected")});var e=this._getResizer();e.style.left="-10000px";e.style.top="-10000px"};u.prototype._getNormalizedBounds=function(e,t,o){const i=this.getConfig("numberOfColumns",this.getControl());const n=this.getRangeLimit()==0?this.getConfig("getRowCount",this.getControl()):this.getRangeLimit();let s=Math.max(e.rowIndex,t.rowIndex),l=Math.max(e.colIndex,t.colIndex);if(o){s=Math.min(n,s);l=Math.min(i,l)}return{from:{rowIndex:Math.max(0,Math.min(e.rowIndex,t.rowIndex)),colIndex:Math.max(0,Math.min(e.colIndex,t.colIndex)),type:e.type},to:{rowIndex:s,colIndex:l,type:t.type}}};u.prototype._shouldBeHandled=function(e){return!e.isMarked?.()&&this.getConfig("isSupported",this.getControl(),this)};u.prototype._getBinding=function(){return this.getConfig("getBinding",this.getControl())};function m(e,t){return e.matches(t)}function _(e,t,o){const i=e?.getNodeByIndex?.(o)??t;if(e?.nodeHasChildren){return e.nodeHasChildren(i)}return!(i.getProperty("@ui5.node.isExpanded")===undefined)}function p(e,t,o,i){if(o&&e[0]){return i(e[0])>t?e[0]:e[e.length-1]}return e.find(e=>i(e)==t)}function S(e,t){let o=e?.$().closest(t)[0];if(!o&&!e.getVisible()){const i=document.getElementById(l.createInvisiblePlaceholderId(e));o=i?.closest(t)}return o}function I(e,t,o,i){return e.keyCode==t&&e.shiftKey==o&&(e.ctrlKey==i||e.metaKey==i)}function v(e,t){return e.getDragDropConfig().some(e=>e.getSourceAggregation?.()==t&&e.getEnabled())}e.setConfigs({"sap.ui.table.Table":{selectableCells:".sapUiTableDataCell",scrollArea:"tableCCnt",scrollEvent:"firstVisibleRowChanged",eventClearedAll:"sapUiTableClearAll",onActivate:function(e,t){e.attachEvent("_change",t,this._onPropertyChange);e.attachEvent("EventHandlerChange",t,this._onEventHandlerChange)},onDeactivate:function(e,t){e.detachEvent("_change",this._onPropertyChange);e.detachEvent("EventHandlerChange",this._onEventHandlerChange)},_onPropertyChange:function(e,t){e.getParameter("name")=="selectionBehavior"&&t._onSelectableChange()},_onEventHandlerChange:function(e,t){e.getParameter("EventId")=="cellClick"&&t._onSelectableChange()},isSupported:function(e,t){return!e.hasListeners("cellClick")&&!v(e,"rows")},isBottomToTop:function(e){return false},getVisibleColumns:function(e){return e.getColumns().filter(function(e){return e.getDomRef()})},numberOfColumns:function(e,t){return this.getVisibleColumns(e).length},getRowCount:function(e){return e._getTotalRowCount()},getCellRef:function(e,t,o){const i=p(e.getRows(),t.rowIndex,o,e=>e?.getIndex());const n=this.getVisibleColumns(e)[t.colIndex];if(!i||!n){return null}return S(i.getCells().filter(e=>e.getDomRef()||!e.getVisible())[t.colIndex],this.selectableCells)},getCellInfo:function(e,t){return{rowIndex:n.closestTo(t,true).getIndex(),colIndex:this.getVisibleColumns(e).indexOf(n.getElementById(t.getAttribute("data-sap-ui-colid"))),type:this.getCellType(e,t)}},getCellType:function(e,t){const o=n.closestTo(t,true);let i=g.Cell;if(o.isGroupHeader()){i=g.Ignore}return i},getSelectedRowContexts:function(e,t,o,i){if(o==Infinity){var n=e.getBinding("rows").getAllCurrentContexts().length-1;o=Math.min(o,t+i-1,n)}var s=[];for(var l=t;l<=o;l++){s.push(e.getContextByIndex(l))}return s},selectRows:function(e,t,o,i){var n=this._getSelectionOwner(e);var s=e.getSelectionMode();if(s=="None"){return false}else if(s=="Single"){t=o=i}if(n.addSelectionInterval&&n.removeSelectionInterval){for(let e=t;e<=o;e++){const t=n.isIndexSelected?.(e)??false;if(t){n.removeSelectionInterval(e,e)}else{n.addSelectionInterval(e,e)}}return true}var l=e.getRows().filter(function(e){return e.getIndex()>=t&&e.getIndex()<=o});l.forEach(t=>{n.setSelected(t,!this.isRowSelected(e,t))});return true},isRowSelected:function(e,t){var o=this._getSelectionOwner(e);if(typeof t==="number"){t=e.getRows().find(function(e){return e.getIndex()==t})}let i=o.isIndexSelected?.(t);if(t){i=o.isSelected?.(t)}return i??false},focusCell:function(e,t,o,i){var n=this.getCellRef(e,t);if(!n){this.scroll(e,i,true);return}n.focus()},scroll:function(e,t,o){if(o){var i=e.getFirstVisibleRow();var n=t?i+1:i-1;if(n>=0&&n!=i){e.setFirstVisibleRow(n);return Promise.resolve()}}else{var s=e._getScrollExtension().getHorizontalScrollbar();var l=Math.pow(-1,+!t)*10;s.scrollLeft=Math.max(0,s.scrollLeft+l);return Promise.resolve()}return false},attachSelectionChange:function(e,t){var o=this._getSelectionOwner(e);if(o.attachSelectionChange){o.attachSelectionChange(t);return}o.attachRowSelectionChange(t)},detachSelectionChange:function(e,t){var o=this._getSelectionOwner(e);if(o.detachSelectionChange){o.detachSelectionChange(t);return}o.detachRowSelectionChange(t)},attachBindingUpdate:function(e,t){e.attachEvent("_rowsUpdated",t,this._fnOnRowsUpdated)},detachBindingUpdate:function(e,t){e.detachEvent("_rowsUpdated",this._fnOnRowsUpdated)},_fnOnRowsUpdated:function(e,t){if(["collapse","expand"].includes(e.getParameter("reason"))){t.removeSelection()}},_getSelectionOwner:function(t){return e.getPlugin(t,"sap.ui.table.plugins.SelectionPlugin")||t},getBinding:function(e){return e.getBinding("rows")},shouldRenderResizer:function(e){return true},drawCellBorder:function(e,t,o,i){const n=this.isBottomToTop(e)?"sapMPluginsCellSelectorBottom":"sapMPluginsCellSelectorTop";const s=this.isBottomToTop(e)?"sapMPluginsCellSelectorTop":"sapMPluginsCellSelectorBottom";t.classList.toggle(n,o.rowIndex==i.from.rowIndex);t.classList.toggle(s,o.rowIndex==i.to.rowIndex);t.classList.toggle("sapMPluginsCellSelectorRight",o.colIndex==i.to.colIndex);t.classList.toggle("sapMPluginsCellSelectorLeft",o.colIndex==i.from.colIndex);t.classList.toggle("sapMPluginsCellSelectorSelected",true);t.setAttribute("aria-selected","true");return[t]},loadContexts:function(e,t,o){var i=e.getBinding("rows");if(!i||i.isA("sap.ui.model.ClientListBinding")){return}i.getContexts(Math.max(0,t),Math.max(1,o),0,true)}},"sap.m.Table":{selectableCells:".sapMLIBFocusable, .sapMListTblCell, .sapMListTblSubRowCell, .sapMListTblSubCnt",scrollArea:"listUl",eventClearedAll:"sapMTableClearAll",onActivate:function(e,t){e.attachEvent("_change",t,this._onPropertyChange);e.attachEvent("EventHandlerChange",t,this._onEventHandlerChange)},onDeactivate:function(e,t){e.detachEvent("_change",this._onPropertyChange);e.detachEvent("EventHandlerChange",this._onEventHandlerChange)},_onPropertyChange:function(e,t){e.getParameter("name")=="mode"&&t._onSelectableChange()},_onEventHandlerChange:function(e,t){e.getParameter("EventId")=="itemPress"&&t._onSelectableChange()},_getVisibleItems:function(e){return e.getVisibleItems()},isSupported:function(e,t){return e.getMode()!=r.SingleSelectMaster&&!v(e,"items")},isBottomToTop:function(e){return e.getGrowingDirection()=="Upwards"},getVisibleColumns:function(e,t){return e.getColumns(true).filter(function(e){const o=t&&e.isPopin();return e.getVisible()&&(e.getDomRef()&&!e.isPopin()||o)})},numberOfColumns:function(e,t){var o=this.getVisibleColumns(e,t).length;return t?o:o+e.hasPopin()},getRowCount:function(e){return this._getVisibleItems(e).length},getCellRef:function(e,t,o){const i=this._getVisibleItems(e);const n=p(e.getItems(),t.rowIndex,o,e=>i.indexOf(e));const s=this.getVisibleColumns(e)[t.colIndex];if(!n||!s){return null}if(n.isGroupHeader()){return n.getDomRef()}if(e.hasPopin()&&t.colIndex==this.numberOfColumns(e)-1){return n.$Popin()[0].querySelector(".sapMListTblSubRowCell")}return S(n.getCells()[s.getInitialOrder()],this.selectableCells)},getCellInfo:function(e,t,o){const i=this.getVisibleColumns(e);const s=n.getElementById(t.getAttribute("data-sap-ui-column"));const l=this.getCellType(e,t);let r=i.indexOf(s);if(l==g.Other){r=this.numberOfColumns(e)-1}if(l==g.Ignore){r=o?.colIndex??r}return{rowIndex:this._getVisibleItems(e).indexOf(n.closestTo(t,true)),colIndex:r,type:l}},getCellType:function(e,t){const o=n.getElementById(t.getAttribute("data-sap-ui-column"));const i=n.closestTo(t,true);if(!i){return}if(i.isGroupHeader?.()){return g.Ignore}const s=t.classList.contains("sapMListTblSubRowCell")||t.classList.contains("sapMListTblSubCnt")||t.classList.contains("sapMListTblSubRow");if(!o&&s){return g.Other}return g.Cell},getSelectedRowContexts:function(e,t,o,i){const n=this._getVisibleItems(e);if(o==Infinity){const e=n.length;o=Math.min(o,t+i-1,e)}return n.slice(t,o+1).filter(e=>!e.isGroupHeader?.()).map(t=>t?.getBindingContext(e.getBindingInfo("items")?.model))},selectRows:function(e,t,o,i){var n=e.getMode();if(n=="Delete"||n=="None"){return false}else if(n=="Single"){t=o=i}const s=this._getVisibleItems(e);for(let i=t;i<o;i++){e.setSelectedItem(s[i],!this.isRowSelected(e,s[i]))}e.setSelectedItem(s[o],!this.isRowSelected(e,s[o]),true);return true},isRowSelected:function(e,t){if(typeof t==="number"){t=this._getVisibleItems(e)[t]}return t.getSelected()},focusCell:function(e,t,o,i){if(o){return}this.getCellRef(e,t)?.focus()},scroll:function(e,t,o){return Promise.resolve()},attachSelectionChange:function(e,t){e.attachSelectionChange(t)},detachSelectionChange:function(e,t){e.detachSelectionChange(t)},attachBindingUpdate:function(e,t){e.attachUpdateFinished(t,this._fnOnUpdateFinished)},detachBindingUpdate:function(e,t){e.detachUpdateFinished(this._fnOnUpdateFinished)},_fnOnUpdateFinished:function(e,t){if(["Sort","Filter"].includes(e.getParameter("reason"))){t.removeSelection()}},getBinding:function(e){return e.getBinding("items")},shouldRenderResizer:function(e){return!e.hasPopin()},drawCellBorder:function(e,t,o,i){const n=e.hasPopin();const s=n&&i.to.colIndex==this.numberOfColumns(e)-1;const l=this.isBottomToTop(e)?"sapMPluginsCellSelectorBottom":"sapMPluginsCellSelectorTop";const r=this.isBottomToTop(e)?"sapMPluginsCellSelectorTop":"sapMPluginsCellSelectorBottom";t.classList.toggle(l,o.rowIndex==i.from.rowIndex||n);t.classList.toggle(r,o.rowIndex==i.to.rowIndex||n);t.classList.toggle("sapMPluginsCellSelectorRight",o.colIndex==i.to.colIndex||s&&o.colIndex==i.to.colIndex-1);t.classList.toggle("sapMPluginsCellSelectorLeft",o.colIndex==i.from.colIndex||s&&o.colIndex==i.to.colIndex);t.classList.toggle("sapMPluginsCellSelectorSelected",true);t.setAttribute("aria-selected","true");return[t]},onSelectionStart:function(e,t){if(t.type.startsWith("mouse")){e.getItems().forEach(function(e){e.setActive(false);e.getDomRef().classList.remove("sapMLIBHoverable")})}},onSelectionEnd:function(e,t){if(t.type.startsWith("mouse")){e.getItems().forEach(function(e){if(e.isActionable()){e.getDomRef().classList.add("sapMLIBHoverable")}})}}}},u);return u});
//# sourceMappingURL=CellSelector.js.map