/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./PluginBase","sap/base/Log","sap/base/strings/formatMessage","sap/base/security/encodeXML","sap/m/OverflowToolbarButton","../library","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/Device"],function(t,e,n,o,i,s,l,a,r){"use strict";const c=s.plugins.CopyPreference;const u=t.extend("sap.m.plugins.CopyProvider",{metadata:{library:"sap.m",properties:{extractData:{type:"function",invalidate:false},copySparse:{type:"boolean",defaultValue:false,invalidate:false},excludeContext:{type:"function",invalidate:false},visible:{type:"boolean",defaultValue:true,invalidate:false},copyPreference:{type:"sap.m.plugins.CopyPreference",defaultValue:c.Cells,invalidate:false}},events:{copy:{allowPreventDefault:true,parameters:{data:{type:"any[][]"}}}}}});function p(){return Boolean(r.system.desktop&&window.ClipboardItem&&navigator.clipboard?.write)}function h(t){return t!=null}function g(t,e){if(h(t)){e.push(...[].concat(t))}}function f(t){if(!h(t)){return""}const e=String(t).replaceAll("\r\n","\n").replaceAll("\t","    ");return o(e).replaceAll("&#x20;","&nbsp;").replaceAll("&#xa;","<br>")}function d(t){if(!h(t)){return""}const e=String(t);return/\n|\r|\t/.test(e)?'"'+e.replaceAll('"','""')+'"':e}u.findOn=t.findOn;u.prototype._shouldManageExtractData=function(){const t=this.getControl();const e=this.getParent();return t!==e&&e.indexOfDependent(this)==-1};u.prototype.isApplicable=function(){if(this._shouldManageExtractData()){if(this.getExtractData()){throw new Error("extractData property must not be defined for "+this)}if(!this.getParent().getColumnClipboardSettings){throw new Error("getColumnClipboardSettings method must be defined for "+this.getParent())}}else if(!this.getExtractData()){throw new Error("extractData property must be defined for "+this)}return true};u.prototype.onActivate=function(t){this._oDelegate={onkeydown:this.onkeydown,onBeforeRendering:this.onBeforeRendering};t.addEventDelegate(this._oDelegate,this);this._shouldManageExtractData()&&this.setExtractData(this._extractData.bind(this));this._handleCellSelectorSelectionChange();this._handleControlSelectionChange();this._updateCopyButtonVisibility();this._updateCopyButtonEnabled()};u.prototype.onDeactivate=function(t){t.removeEventDelegate(this._oDelegate,this);this._oDelegate=null;this._shouldManageExtractData()&&this.setExtractData();this._handleCellSelectorSelectionChange();this._handleControlSelectionChange();this._updateCopyButtonEnabled()};u.prototype.setVisible=function(t){this.setProperty("visible",t,true);this._updateCopyButtonVisibility();return this};u.prototype.setParent=function(){t.prototype.setParent.apply(this,arguments);if(!this.getParent()&&this._oCopyButton){this._oCopyButton.destroy(true);this._oCopyButton=null}};u.prototype.getCopyButton=function(t){if(!this._oCopyButton){const e=a.getResourceBundleFor("sap.m");const n=e.getText("COPYPROVIDER_COPY");this._oCopyButton=new i({icon:"sap-icon://copy",enabled:this._getEffectiveEnabled(),visible:this._getEffectiveVisible(),text:n,tooltip:n,press:this.copySelectionData.bind(this,true),...t});sap.ui.require(["sap/ui/core/ShortcutHintsMixin"],t=>{if(this._oCopyButton){t.addConfig(this._oCopyButton,{message:e.getText(r.os.macintosh?"COPYPROVIDER_SHORTCUT_MAC":"COPYPROVIDER_SHORTCUT_WIN")},this.getParent())}})}return this._oCopyButton};u.prototype.exit=function(){if(this._oCopyButton){this._oCopyButton.destroy(true);this._oCopyButton=null}if(this._mColumnClipboardSettings){this._mColumnClipboardSettings=null}};u.prototype.getSelectionData=function(e=false){const n=this.getControl();const o=this.getExtractData();if(!n||!o){return[]}let i=this.getConfig("selectableColumns",n);if(!i.length){return[]}if(n.getParent().isA("sap.ui.mdc.Table")){i=i.map(function(t){return l.getElementById(t.getId().replace(/\-innerColumn$/,""))})}let s=[];const a=[];const r=this.getCopySparse();const u=this.getExcludeContext();const f=t.getPlugin(this.getParent(),"sap.m.plugins.CellSelector")??t.getPlugin(n,"sap.m.plugins.CellSelector");const d=f&&f.getSelectionRange();const C=d?f.getSelectedRowContexts():[];const y=Boolean(C.length);const S=y||r;this._iSelectedRows=0;this._iSelectedCells=0;if(this.getCopyPreference()==c.Full||!y){s=this.getConfig("selectedContexts",n,S);Object.assign(a,s);this._iSelectedRows=s.filter(Boolean).length}if(y){Object.assign(a,Array(d.from.rowIndex).concat(C));this._iSelectedCells=C.length*(Math.abs(d.to.colIndex-d.from.colIndex)+1)}const b=[];const _=[];let m=false;if(e&&!p()){e=false}for(let t=0;t<a.length;t++){const n=a[t];if(!n){if(r){if(_.length){_.push(Array(_[0].length))}if(m&&b.length){b.push(Array(b[0].length))}}}else if(u&&u(n)){continue}else{const l=[];const a=[];const c=n==s[t];i.forEach((t,i)=>{if(c||i>=d?.from.colIndex&&i<=d?.to.colIndex){const i=o(n,t,e);if(!h(i)){return}if(e&&i.hasOwnProperty("html")){m=true;g(i.html,l)}if(m&&i.hasOwnProperty("text")){g(i.text,a)}else{g(i,a)}}else if(s.length){a.push(undefined);l.push(undefined)}});if(m&&(r||l.some(h))){b.push(l)}if(r||a.some(h)){_.push(a)}}}return m?{text:_,html:b}:_};u.prototype.copySelectionData=function(t){const e=this.getSelectionData(true);const n=e.text||e;if(!n.length||t&&!this.fireCopy({data:n},true)){return Promise.resolve()}if(!navigator.clipboard){throw new Error(this+" requires a secure context in order to access the clipboard API.")}const o=e.html||[];const i=n.map(t=>t.map(d).join("\t")).join("\n");if(!o.length){return navigator.clipboard.writeText(i).then(()=>{this._notifyUser()})}const s="text/html";const l="text/plain";const a="<table><tr>"+o.map(t=>"<td>"+t.map(f).join("</td><td>")+"</td>").join("</tr><tr>")+"</tr></table>";const r=new ClipboardItem({[l]:new Blob([i],{type:l}),[s]:new Blob([a],{type:s})});return navigator.clipboard.write([r]).then(()=>{this._notifyUser()})};u.prototype.onCellSelectorSelectableChange=function(t){this._handleCellSelectorSelectionChange(t);this._updateCopyButtonVisibility()};u.prototype.onBeforeRendering=function(){this._handleControlSelectionChange();this._updateCopyButtonVisibility()};u.prototype.onkeydown=function(t){if(t.isMarked()||t.code!="KeyC"||!(t.ctrlKey||t.metaKey)||!t.target.matches(this.getConfig("allowForCopySelector"))||!this._isControlSelectable()){return}const e=window.getSelection();if(e.toString()&&e.containsNode(t.target,true)){return}t.setMarked();t.preventDefault();this.copySelectionData(true)};u.prototype._handleControlSelectionChange=function(){const t=this.getControl();this.getConfig("detachSelectionChange",t,this._updateCopyButtonEnabled,this);if(this.isActive()&&this.getConfig("isSelectable",t)){this.getConfig("attachSelectionChange",t,this._updateCopyButtonEnabled,this)}};u.prototype._handleCellSelectorSelectionChange=function(t){t??=this.getPlugin("sap.m.plugins.CellSelector");if(!t){return}t.detachEvent("selectionChange",this._updateCopyButtonEnabled,this);if(this.isActive()&&t.isSelectable()){t.attachEvent("selectionChange",this._updateCopyButtonEnabled,this)}};u.prototype._isControlSelectable=function(){return Boolean(this.getConfig("isSelectable",this.getControl())||this.getPlugin("sap.m.plugins.CellSelector")?.isSelectable())};u.prototype._hasControlSelection=function(){return Boolean(this.getConfig("hasSelection",this.getControl())||this.getPlugin("sap.m.plugins.CellSelector")?.hasSelection())};u.prototype._getEffectiveVisible=function(){return this.getVisible()?this._isControlSelectable():false};u.prototype._updateCopyButtonVisibility=function(){this._oCopyButton?.setVisible(this._getEffectiveVisible())};u.prototype._getEffectiveEnabled=function(){return this.isActive()?this._hasControlSelection():false};u.prototype._updateCopyButtonEnabled=function(){this._oCopyButton?.setEnabled(this._getEffectiveEnabled())};u.prototype._extractData=function(t,o,i){if(!this._mColumnClipboardSettings){this._mColumnClipboardSettings=new WeakMap}let s=this._mColumnClipboardSettings.get(o);if(s===undefined){s=this.getParent().getColumnClipboardSettings(o);this._mColumnClipboardSettings.set(o,s)}if(!s){return}const l=s.properties.map(function(n,o){let i=t.getProperty(n);const l=s.types[o];if(l){try{i=l.formatValue(i,"string")}catch(t){e.error(this+': Formatting error during copy "'+t.message+'"')}}return h(i)?i:""});const a=s.unitFormatter;if(a){l[0]=a(l[0],l[1])}if(!i){return l}let r=l.some(String)?n(s.template,l).trim():"";if(r[0]=="("&&/^\([0-9]+\)$/.test(r)){r=r.slice(1,-1)}return{text:l,html:r}};u.prototype._notifyUser=function(){const t=this._iSelectedRows;const e=this._iSelectedCells;const n=this.getCopyPreference()==="Cells";return new Promise(o=>{sap.ui.require(["sap/m/MessageToast"],i=>{let s;if(t&&!e){s=t==1?"ROW_SINGLE":"ROW_MULTI"}else if(e&&(!t||n)){s=e==1?"CELL_SINGLE":"CELL_MULTI"}else if(t>0&&e>0){s="ROW_AND_CELL"}if(s){const t=a.getResourceBundleFor("sap.m");const e=t.getText("COPYPROVIDER_SELECT_"+s+"_MSG");i.show(e)}o()})})};t.setConfigs({"sap.m.Table":{_oWM:new WeakMap,allowForCopySelector:".sapMLIBFocusable,.sapMLIBSelectM,.sapMLIBSelectS,.sapMListTblCell",selectedContexts:function(t,e){const n=[];const o=t.getBindingInfo("items");t.getItems(true).forEach(function(t,i){if(t.isSelectable()&&t.getVisible()){if(t.getSelected()){const s=o?t.getBindingContext(o.model):t;const l=e?i:n.length;n[l]=s}}});return n},selectableColumns:function(t){return t.getRenderedColumns()},isSelectable:function(t){return t.getMode().includes("Select")},hasSelection:function(t){return Boolean(t.getSelectedItem())},attachSelectionChange:function(t,e,n){const o={onBeforeRendering:e};this._oWM.set(t,o);t.addEventDelegate(o,n);t.attachUpdateFinished(e,n);t.attachEvent("itemSelectedChange",e,n)},detachSelectionChange:function(t,e,n){const o=this._oWM.get(t);t.removeEventDelegate(o,n);t.detachUpdateFinished(e,n);t.detachEvent("itemSelectedChange",e,n)}},"sap.ui.table.Table":{allowForCopySelector:".sapUiTableCell",selectedContexts:function(e,n){const o=t.getPlugin(e,"sap.ui.table.plugins.SelectionPlugin")||e;if(o.getSelectedContexts){return o.getSelectedContexts()}const i=[];o.getSelectedIndices().forEach(function(t){const o=e.getContextByIndex(t);if(o){const e=n?t:i.length;i[e]=o}});return i},selectableColumns:function(t){return t.getColumns().filter(function(t){return t.getDomRef()})},isSelectable:function(t){return t.getSelectionMode()!="None"},hasSelection:function(t){return t._getSelectionPlugin().getSelectedCount()>0},attachSelectionChange:function(t,e,n){t._getSelectionPlugin().attachSelectionChange(e,n);t.attachRowsUpdated(e,n)},detachSelectionChange:function(t,e,n){t._getSelectionPlugin()?.detachSelectionChange(e,n);t.detachRowsUpdated(e,n)}}},u);return u});
//# sourceMappingURL=CopyProvider.js.map