/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./PluginBase","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/util/PasteHelper","sap/ui/Device"],function(e,t,n,a,s){"use strict";var r=e.extend("sap.m.plugins.PasteProvider",{metadata:{library:"sap.m",associations:{pasteFor:{type:"sap.ui.core.Control",multiple:false}},events:{paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"},text:{type:"string"}}}}}});var o=null;var i=null;var u="[data-sap-ui-pasteregion]";r.findOn=e.findOn;r.prototype.onActivate=function(e){e.attachEvent(this.getConfig("pressEvent"),this._onPress,this)};r.prototype.onDeactivate=function(e){e.detachEvent(this.getConfig("pressEvent"),this._onPress,this)};r.prototype._onPress=function(){if(o){o.close()}i=this;var e=navigator.clipboard;if(e&&e.readText){e.readText().then(function(e){l(e);i=null},f)}else{f()}};function l(e){var t=a.getClipboardText(e);if(!t){return}var n={text:t};Object.defineProperty(n,"data",{get:a.getPastedDataAs2DArray.bind(a,t)});if(!i.firePaste(n)){return}var s=p();if(!s){return}var r=new ClipboardEvent("paste",{clipboardData:new DataTransfer,bubbles:true});r.clipboardData.setData("text",t);s.dispatchEvent(r)}function p(){var e=t.getElementById(i.getPasteFor());var n=e&&e.getDomRef();if(!n){return}if(n.matches(u)){return n}else{return n.querySelector(u)||n}}function c(e){var t=p();t&&t.classList.toggle("sapMPluginsPasteProviderHighlight",e)}function f(){var e=i.getControl();if(o){return o.openBy(e)}sap.ui.require(["sap/ui/core/HTML","sap/ui/core/Icon","sap/m/Popover"],function(t,a,r){var u,p=n.getResourceBundleFor("sap.m");var f=s.system.desktop&&!s.os.ios&&!s.os.android;if(f){var g=p.getText("PASTEPROVIDER_SHORTCUT_"+(s.os.name=="mac"?"MAC":"WIN"));u=p.getText("PASTEPROVIDER_DESKTOP_MSG",['<span class="sapMPluginsPasteProviderShortCut">'+g+"</span>"])}else{u=p.getText("PASTEPROVIDER_MOBILE_MSG")}var v=new t({content:'<div contenteditable="true" class="sapMPluginsPasteProviderMessage">'+u+"</div>",preferDOM:false});o=new r({title:p.getText("PASTEPROVIDER_TITLE"),showArrow:f,horizontalScrolling:false,verticalScrolling:false,placement:"Auto",content:v,initialFocus:v.getId(),beginButton:new a({src:"sap-icon://message-information"}),beforeOpen:function(){c(true)},beforeClose:function(){c(false);i=null}});o.addEventDelegate({onpaste:function(e){e.preventDefault();l(e.originalEvent);o.close()},onkeypress:function(e){e.preventDefault()}});o.openBy(e)})}e.setConfigs({"sap.m.Button":{pressEvent:"press",onActivate:function(e,a){if(!e.getText()&&!e.getIcon()&&!e.getTooltip_AsString()){const r=n.getResourceBundleFor("sap.m");const o=r.getText("PASTEPROVIDER_PASTE");e.setTooltip(o).setIcon("sap-icon://paste");if(e.isA("sap.m.OverflowToolbarButton")){e.setText(o)}sap.ui.require(["sap/ui/core/ShortcutHintsMixin"],function(n){n.addConfig(e,{message:r.getText(s.os.macintosh?"PASTEPROVIDER_SHORTCUT_MAC":"PASTEPROVIDER_SHORTCUT_WIN")},t.getElementById(a.getPasteFor())||e)})}}}},r);return r});
//# sourceMappingURL=PasteProvider.js.map