/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./PluginBase","sap/ui/core/Element","sap/base/Log","sap/ui/core/Lib","sap/ui/unified/FileUploader","sap/m/upload/UploaderHttpRequestMethod","sap/m/upload/UploadItem","sap/base/util/deepEqual","sap/m/library","sap/m/IllustratedMessageType","sap/m/IllustratedMessage","sap/m/IllustratedMessageSize","sap/m/upload/UploaderTableItem","sap/ui/core/dnd/DragDropInfo","sap/ui/core/dnd/DropInfo","sap/m/upload/FilePreviewDialog","sap/ui/base/Event","sap/m/Dialog","sap/m/Label","sap/m/Input","sap/m/MessageBox","sap/m/Button","sap/ui/core/Core","sap/m/Text","sap/m/VBox","sap/ui/model/BindingMode"],function(e,t,i,o,a,n,r,l,s,p,u,d,g,f,c,h,m,_,T,y,D,C,P,I,F,b){"use strict";var U=e.extend("sap.m.plugins.UploadSetwithTable",{metadata:{library:"sap.m",properties:{fileTypes:{type:"string[]",defaultValue:null},maxFileNameLength:{type:"int",defaultValue:null},maxFileSize:{type:"float",defaultValue:null},mediaTypes:{type:"string[]",defaultValue:null},uploadUrl:{type:"string",defaultValue:null},httpRequestMethod:{type:"sap.m.upload.UploaderHttpRequestMethod",defaultValue:n.Post},multiple:{type:"boolean",group:"Behavior",defaultValue:false},uploadButtonInvisible:{type:"boolean",group:"Appearance",defaultValue:false},uploadEnabled:{type:"boolean",defaultValue:true},itemValidationHandler:{type:"function",defaultValue:null},directory:{type:"boolean",group:"Behavior",defaultValue:false},cloudFilePickerEnabled:{type:"boolean",group:"Behavior",defaultValue:false},cloudFilePickerServiceUrl:{type:"sap.ui.core.URI",group:"Data",defaultValue:""},cloudFilePickerButtonText:{type:"string",defaultValue:""},fileNameValidationConfig:{type:"object",defaultValue:null}},aggregations:{uploader:{type:"sap.m.upload.UploaderTableItem",multiple:false},headerFields:{type:"sap.ui.core.Item",multiple:true,singularName:"headerField"},rowConfiguration:{type:"sap.m.upload.UploadItemConfiguration",multiple:false},noDataIllustration:{type:"sap.m.IllustratedMessage",multiple:false}},defaultAggregation:"rowConfiguration",associations:{previewDialog:{type:"sap.m.upload.FilePreviewDialog",multiple:false},actions:{type:"sap.m.upload.ActionsPlaceholder",multiple:true}},events:{itemRenamed:{parameters:{item:{type:"sap.m.upload.UploadItem"}}},beforeUploadStarts:{parameters:{item:{type:"sap.m.upload.UploadItem"}},allowPreventDefault:true},uploadCompleted:{parameters:{item:{type:"sap.m.upload.UploadItem"},response:{type:"string"},readyState:{type:"string"},status:{type:"string"},responseXML:{type:"string"},responseText:{type:"string"},headers:{type:"object"}}},fileTypeMismatch:{parameters:{item:{type:"sap.m.upload.UploadItem"}}},fileNameLengthExceeded:{parameters:{item:{type:"sap.m.upload.UploadItem"}}},fileSizeExceeded:{parameters:{item:{type:"sap.m.upload.UploadItem"}}},mediaTypeMismatch:{parameters:{item:{type:"sap.m.upload.UploadItem"}}},beforeInitiatingItemUpload:{parameters:{item:{type:"sap.m.upload.UploadItem"}}},onActivated:{parameters:{oPlugin:{type:"sap.m.plugins.UploadSetwithTable"}}},onDeactivated:{parameters:{control:{type:"sap.ui.core.Control"}}}}}});var E=s.UploadState;var w=s.UploadSetwithTableActionPlaceHolder;U.findOn=e.findOn;U.DEFAULT_INVALID_FILENAME_CHARACTERSET='\\:/*?"<>|[]{}@#$';const v={onAfterRendering:function(){this.getConfig("setIsTableBound",this.getControl());this.getConfig("setModelName",this.getControl())}};U.prototype.init=function(){this._oRb=o.getResourceBundleFor("sap.m");S()};U.prototype.onActivate=function(e){this._filesTobeUploaded=[];this._filePreviewDialogControl=null;e.addDelegate(v,false,this);this.getConfig("setPluginDefaultSettings",this.getControl(),this);this._setActions();this.fireOnActivated({oPlugin:this})};U.prototype.onDeactivate=function(e){this.getConfig("cleanupPluginInstanceSettings",e,this);this.fireOnDeactivated({control:e})};U.prototype.exit=function(){this.getConfig("cleanupPluginInstanceSettings",this.getControl(),this);e.prototype.exit.call(this)};U.prototype.setParent=function(){e.prototype.setParent.apply(this,arguments)};U.prototype.setFileTypes=function(e){var t=e||null;if(typeof t==="string"){t=t.split(",")}t=(t||[]).map(function(e){return e?e.toLowerCase():""});if(!l(this.getFileTypes(),t)){this.setProperty("fileTypes",t,true);this.getDefaultFileUploader().setFileType(t)}return this};U.prototype.setMaxFileNameLength=function(e){if(this.getMaxFileNameLength()!==e){this.setProperty("maxFileNameLength",e,true);this.getDefaultFileUploader().setMaximumFilenameLength(e)}return this};U.prototype.setMaxFileSize=function(e){if(this.getMaxFileSize()!==e){this.setProperty("maxFileSize",e,true);this.getDefaultFileUploader().setMaximumFileSize(e)}return this};U.prototype.setMediaTypes=function(e){var t=e||null;if(typeof t==="string"){t=t.split(",")}t=(t||[]).map(function(e){return e?e.toLowerCase():""});if(!l(this.getMediaTypes(),t)){this.setProperty("mediaTypes",t,true);this.getDefaultFileUploader().setMimeType(t)}return this};U.prototype.setUploadButtonInvisible=function(e){if(e!==this.getUploadButtonInvisible()){var t=!e;this.getDefaultFileUploader().setVisible(t);this.setProperty("uploadButtonInvisible",e,true)}return this};U.prototype.setMultiple=function(e){if(this.getMultiple()!==e){this.setProperty("multiple",e);this.getDefaultFileUploader().setMultiple(e)}return this};U.prototype.setUploadEnabled=function(e){if(e!==this.getUploadEnabled()){this.getDefaultFileUploader().setEnabled(e);if(e&&!this._oDragDropConfig){this.getConfig("setDragDropConfig",this.getControl(),this)}else if(!e){this.getConfig("resetDragDropConfig",this.getControl(),this)}this.setProperty("uploadEnabled",e,false)}return this};U.prototype.setDirectory=function(e){if(this.getDirectory()!==e){this.setProperty("directory",e);this.getDefaultFileUploader().setDirectory(e);if(e){this.setProperty("multiple",false)}}return this};U.prototype.setNoDataIllustration=function(e){this._vNoDataIllustration=e;this.getConfig("setDefaultIllustrations",this.getControl(),this);return this};U.prototype.getNoDataIllustration=function(){return this._vNoDataIllustration};U.prototype.setFileNameValidationConfig=function(e){if(e===undefined||e===null){this.setProperty("fileNameValidationConfig",null);return this}if(typeof e!=="object"){throw new Error("fileNameValidationConfig must be a non-null object with mode and characters properties")}const t=Object.keys(e);const i=["mode","characters"];const o=i.filter(e=>!t.includes(e));const a=t.filter(e=>!i.includes(e));if(o.length>0||a.length>0){throw new Error(`fileNameValidationConfig must contain only the following properties: ${i.join(", ")}. `+(o.length>0?`Missing: ${o.join(", ")}. `:"")+(a.length>0?`Unexpected: ${a.join(", ")}.`:""))}const n=["include","exclude","override"];if(typeof e.mode!=="string"||!n.includes(e.mode)){throw new Error(`fileNameValidationConfig.mode must be one of ${n.join(", ")}`)}if(typeof e.characters!=="string"){throw new Error("fileNameValidationConfig.characters must be a string.")}this.setProperty("fileNameValidationConfig",e);return this};U.prototype.getDefaultFileUploader=function(){var e=this._oRb.getText("UPLOADSET_WITH_TABLE_UPLOADBUTTON_TEXT");if(!this._oFileUploader){this._oFileUploader=new a(this.getId()+"-uploader",{buttonOnly:true,buttonText:e,tooltip:e,iconOnly:false,enabled:this.getUploadEnabled(),icon:"",iconFirst:false,style:"Transparent",name:"UploadSetwithTableFileUploader",sameFilenameAllowed:true,fileType:this.getFileTypes(),mimeType:this.getMediaTypes(),maximumFilenameLength:this.getMaxFileNameLength(),maximumFileSize:this.getMaxFileSize(),multiple:this.getDirectory()?false:this.getMultiple(),useMultipart:false,sendXHR:true,change:[this._onFileUploaderChange,this],typeMissmatch:[this._fireFileTypeMismatch,this],fileSizeExceed:[this._fireFileSizeExceed,this],filenameLengthExceed:[this._fireFilenameLengthExceed,this],visible:!this.getUploadButtonInvisible(),directory:this.getDirectory()})}return this._oFileUploader};U.getIconForFileType=function(e,t){return r._getIconByMimeType(e,t)};U.prototype.registerUploaderEvents=function(e){e.attachUploadStarted(this._onUploadStarted.bind(this));e.attachUploadCompleted(this._onUploadCompleted.bind(this));e.attachUploadProgressed(this._onUploadProgressed.bind(this));e.attachUploadTerminated(this._onUploadAborted.bind(this))};U.prototype.fileSelectionHandler=function(){var e=this.getDefaultFileUploader();if(e&&e.oFileUpload&&e.oFileUpload.click){e.oFileUpload.click()}};U.getFileSizeWithUnits=function(e){var t=1024;var i=t*1024;var o=i*1024;if(typeof e==="number"){if(e<i){return(e/t).toFixed(2)+" KB"}else if(e<o){return(e/i).toFixed(2)+" MB"}else{return(e/o).toFixed(2)+" GB"}}return e};U.prototype.uploadItemViaUrl=function(e,t,i){var o=new File([new Blob([])],e);var a=new r({uploadState:E.Ready});a._setFileObject(o);a.setFileName(o.name);a.setUrl(t);i.then(()=>this._initateItemUpload(a).bind(this)).catch(()=>a.destroy());return a};U.prototype.uploadItemWithoutFile=function(e){var t=new File([new Blob([])],"-");var i=new r({uploadState:E.Ready});i._setFileObject(t);i.setFileName(t.name);e.then(()=>this._initateItemUpload(i)).catch(()=>i.destroy());return i};U.prototype.openFilePreview=function(e){const t=this.getRowConfiguration();if(!t){i.error("Row configuration is not set for the plugin. File preview is not possible.");return}this.getConfig("openFilePreview",e,this.getControl(),this)};U.prototype.download=function(e,t){const o=this.getRowConfiguration();if(!o){i.error("Row configuration is not set for the plugin. Download is not possible.");return}this.getConfig("download",{oBindingContext:e,bAskForLocation:t},this.getControl(),this)};U.prototype.renameItem=async function(e){const t=this.getRowConfiguration();if(!t){i.error("Row configuration is not set for the plugin. Rename action is not possible.");return}if(e){const t=await this.getItemForContext(e,true);const i=this._getFileRenameDialog(t);i.open()}};U.prototype._getFileRenameDialog=function(e){const t=r._splitFileName(e.getFileName());let i=this.getMaxFileNameLength();const o=t.extension?t.extension.length+1:0;i=i?i:0;let a=i-o;a=a<0?0:a;const n=new y({type:s.InputType.Text,value:t.name,width:"75%",maxLength:a,liveChange:[this._handleItemNameValidation,this]});n.addStyleClass("sapUiTinyMarginTop");n.addStyleClass("sapUiMediumMarginBegin");const l=t.extension?`.${t.extension}`:"";const p=new I({text:l});p.addStyleClass("sapUiTinyMarginBegin");p.addStyleClass("sapUiTinyMarginTop");const u=new T({text:this._oRb.getText("UPLOADSET_WITH_TABLE_DOCUMENT_RENAME_INPUT_LABEL"),labelFor:n.getId(),required:true});u.addStyleClass("sapUiMediumMarginTop");u.addStyleClass("sapUiMediumMarginBegin");u.addStyleClass("sapUiSmallMarginEnd");const d=new F({items:[u]});var g=new _({title:this._oRb.getText("UPLOADSET_WITH_TABLE_DOCUMENT_RENAME_DIALOG_TEXT"),contentWidth:"33.375rem",contentHeight:"10.125rem",content:[d,n,p],beginButton:new C({type:s.ButtonType.Emphasized,text:this._oRb.getText("UPLOADSET_WITH_TABLE_DOCUMENT_RENAME_APPLY_BUTTON_TEXT"),press:this._handleItemRenameConfirmation.bind(this),enabled:n.getValueState()!=="Error"}),endButton:new C({text:this._oRb.getText("UPLOADSET_WITH_TABLE_CANCELBUTTON_TEXT"),press:this._handleItemRenameCancel.bind(this)}),customData:{key:"item",value:e},afterClose:function(){g.destroy()},escapeHandler:e=>{e?.reject()}});return g};U.prototype._handleItemRenameCancel=function(e){const t=e.getSource().getParent();const i=t.getContent()[1];const o=t&&t.data?t.data().item:null;const a=r._splitFileName(o.getFileName());if(o&&i&&a.name!==i.getValue()){D.warning(this._oRb.getText("UPLOADSET_WITH_TABLE_DOCUMENT_RENAME_DISCARD_POPUP_CHANGES_TEXT"),{actions:[this._oRb.getText("UPLOADSET_WITH_TABLE_DOCUMENT_RENAME_SAVE_BUTTON_TEXT"),this._oRb.getText("UPLOADSET_WITH_TABLE_DOCUMENT_RENAME_DISCARD_CHANGES_BUTTON_TEXT")],emphasizedAction:this._oRb.getText("UPLOADSET_WITH_TABLE_DOCUMENT_RENAME_SAVE_BUTTON_TEXT"),onClose:e=>{if(e!==this._oRb.getText("UPLOADSET_WITH_TABLE_DOCUMENT_RENAME_SAVE_BUTTON_TEXT")){t.close()}else{var i=t.getBeginButton();var o=new m("click",i);i.firePress(o)}}})}else{t.close()}};U.prototype._handleItemRenameConfirmation=function(e){const t=e.getSource().getParent();const i=t.getContent()[1];if(i&&i.getValueState()==="Error"){i.focus(i);i.setShowValueStateMessage(true);return}const o=t&&t.data?t.data().item:null;const a=r._splitFileName(o.getFileName());if(o&&a.name!==i.getValue()){if(a&&a.extension){o.setFileName(i.getValue()+"."+a.extension)}else{o.setFileName(i.getValue())}t.close();this.fireItemRenamed({item:o})}else{t.close()}};U.prototype._handleItemNameValidation=function(e){const t=e.getSource();let i=t.getValue();i=i.trim();if(i===""){t.setProperty("valueState","Error",true);t.setValueStateText(this._oRb.getText("UPLOADSET_WITH_TABLE_DOCUMENT_RENAME_EMPTY_NAME_VALIDATION_ERROR_MESSAGE"));t.setShowValueStateMessage(true);return}const o=this._getFileNameValidationChracters();const a=o.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&");const n=new RegExp(`[${a}]`);if(n.test(i)){t.setShowValueStateMessage(true);t.setProperty("valueState","Error",true);t.setValueStateText(this._oRb.getText("UPLOADSET_WITH_TABLE_DOCUMENT_RENAME_SPLC_VALIDATION_ERROR_MESSAGE",[o]))}else{t.setShowValueStateMessage(false);t.setProperty("valueState","None",true)}};U.prototype._getFileNameValidationChracters=function(){const{mode:e,characters:t}=this.getFileNameValidationConfig()||{};switch(e){case"include":{const e=[...new Set((U.DEFAULT_INVALID_FILENAME_CHARACTERSET+t).split(""))];const i=e.join("");return i}case"exclude":{const e=[...new Set(t.split(""))];const o=e.join("");return i(U.DEFAULT_INVALID_FILENAME_CHARACTERSET,o)}case"override":return t;default:return U.DEFAULT_INVALID_FILENAME_CHARACTERSET}function i(e,t){for(var i of t){e=e.split(i).join("")}return e}};U.prototype._onFileUploaderChange=function(e){var t=e.getParameter("files");if(t&&t.length){this._processSelectedFileObjects(t)}};U.prototype._processSelectedFileObjects=function(e){var t=[];for(var o=0;o<e.length;o++){t.push(e[o])}t.forEach(e=>{var o=new r({uploadState:E.Ready});this._setInitialFileSettings({item:o,file:e,fileList:t});if(this.getItemValidationHandler()&&typeof this.getItemValidationHandler()==="function"){const e={oItem:o,iTotalItemsForUpload:t.length,oSource:this};var a=this.getItemValidationHandler()(e);if(a&&a instanceof Promise){a.then(e=>{if(e instanceof r){this._initateItemUpload(e)}}).catch(e=>{if(e&&this._oItemToUpdate&&e instanceof r&&e.getId()===this._oItemToUpdate.getId()){this._oItemToUpdate=null}})}else{o.destroy();i.error("Invalid usage, missing Promise: ItemValidationHandler callback expects Promise to be returned.")}}else{this._initateItemUpload(o)}})};U.prototype._setInitialFileSettings=function(e){const{item:t}=e;let i=e.file;const o=i.name;const a=i.type;if(!a){const e=r._splitFileName(o,true);const a=e?.extension;switch(a){case r.FILETYPES.VDS:i=new File([i],o,{type:r.MEDIATYPES.VDS});t.setMediaType(r.MEDIATYPES.VDS);break;default:break}}t.setParent(this);t._setFileObject(i);t.setFileName(o)};U.prototype._fireFileTypeMismatch=function(e){var t=this.getMediaTypes();var i=this.getFileTypes();var o=e.getParameter("fileType");var a=e.getParameter("mimeType");var n=!!t&&t.length>0&&!!a&&t.indexOf(a)===-1;var l=!!i&&i.length>0&&!!o&&i.indexOf(o)===-1;var s=[new Blob([])];var p={type:e.getParameter("mimeType"),webkitRelativePath:"",name:e.getParameter("fileName")};var u=new File(s,e.getParameter("fileName"),p);var d=new r;d._setFileObject(u);d.setFileName(u.name);if(n){this.fireMediaTypeMismatch({item:d})}else if(l){this.fireFileTypeMismatch({item:d})}};U.prototype._fireFilenameLengthExceed=function(e){var t=new r;t.setFileName(e.getParameter("fileName"));this.fireFileNameLengthExceeded({item:t})};U.prototype._fireFileSizeExceed=function(e){var t=new r;t.setFileName(e.getParameter("fileName"));this.fireFileSizeExceeded({item:t})};U.prototype._onUploadStarted=function(e){var t=e.getParameter("item");t.setUploadState(E.Uploading)};U.prototype._onUploadCompleted=function(e){var t=e.getParameter("item"),i=e.getParameter("responseXHR"),o=null;if(i.responseXML){o=i.responseXML.documentElement.textContent}var a={item:t,response:i.response,responseXML:o,responseText:i.responseText,readyState:i.readyState,status:i.status,headers:i.headers};if(this._oItemToUpdate){this._oItemToUpdate.setFileName(t.getFileName());this._oItemToUpdate._setFileObject(t.getFileObject());this._oItemToUpdate=null}t.setUploadState(E.Complete);this.fireUploadCompleted(a)};U.prototype._onUploadProgressed=function(e){var t=e.getParameter("item");t.fireUploadProgress({loaded:e.getParameter("loaded"),total:e.getParameter("total")})};U.prototype._uploadItemIfGoodToGo=function(e){if(e.getUploadState()===E.Ready&&!e._isRestricted()){if(this.fireBeforeUploadStarts({item:e})){const t=this.getHeaderFields()?.length?this.getHeaderFields():[];const i=e.getHeaderFields()?.length?e.getHeaderFields():[];const o=[...t,...i];this._getActiveUploader().uploadItem(e,o)}}};U.prototype._getActiveUploader=function(){return this.getUploader()||this._getImplicitUploader()};U.prototype._getImplicitUploader=function(){if(!this._oUploader){this._oUploader=new g({httpRequestMethod:this.getHttpRequestMethod()});this._oUploader.setUploadUrl(this.getUploadUrl());this.registerUploaderEvents(this._oUploader);this.addDependent(this._oUploader)}return this._oUploader};U.prototype._initateItemUpload=function(e){this.fireBeforeInitiatingItemUpload({item:e});if(this._oItemToUpdate){this._oItemToUpdate=e}this._uploadItemIfGoodToGo(e)};U.prototype._onDropFile=function(e){e.preventDefault();if(!this.getUploadEnabled()){i.error("Upload is not enabled, to continue uploading with drag and drop of files enable property 'UploadEnabled' ");return}let t=e.getParameter("browserEvent")?.dataTransfer?.items||[];t=Array.from(t);t=t.filter(function(e){return e.webkitGetAsEntry()?true:false});const o=t.map(function(e){const t=e.webkitGetAsEntry();return{entryType:t&&t.isFile?"File":"Directory"}});if(t&&t.length>1&&!this.getMultiple()&&!this.getDirectory()){const e=this._oRb.getText("UPLOADSET_WITH_TABLE_MULTIPLE_RESTRICTED");i.warning("Multiple files upload is retsricted for this multiple property set");D.error(e);return}else if(t&&t.length>1&&this.getMultiple()&&!a("File",o)){const e=this._oRb.getText("UPLOADSET_WITH_TABLE_DIRECTORY_RESTRICTED");i.warning("Multiple files upload is retsricted, drag & drop only files");D.error(e);return}if(t&&t.length&&!this.getDirectory()&&a("Directory",o)){const e=this._oRb.getText("UPLOADSET_WITH_TABLE_DIRECTORY_RESTRICTED");i.warning("Directory of files upload is retsricted for this directory property set");D.error(e);return}else if(t&&t.length&&this.getDirectory()&&!a("Directory",o)){const e=this._oRb.getText("UPLOADSET_WITH_TABLE_DROP_DIRECTORY_ALLOWED");i.warning("Directory of files upload is retsricted, drag & drop only directories here.");D.error(e);return}if(t&&t.length){this._getFilesFromDataTransferItems(t).then(e=>{const t=this.getDefaultFileUploader();if(e&&e.length&&t?._areFilesAllowed(e)){this._processSelectedFileObjects(e)}})}function a(e,t){return t.every(function(t){return t.entryType===e})}};U.prototype._onDragEnterFile=function(e){var t=e.getParameter("dragSession");var i=t.getDragControl();if(i){e.preventDefault()}};U.prototype._getFilesFromDataTransferItems=function(e){const t=[];return new Promise((o,a)=>{const n=[];for(let t=0;t<e.length;t++){n.push(i(e[t]?.webkitGetAsEntry()))}Promise.all(n).then(e=>{o(t)},e=>{a(e)})});function i(e){return new Promise((o,a)=>{if(e.isFile){e.file(e=>{t.push(e);o(e)},e=>{a(e)})}else if(e.isDirectory){const t=e.createReader();t.readEntries(function(e){const t=[];for(let o=0;o<e.length;o++){t.push(i(e[o]))}o(Promise.all(t))})}})}};U.prototype._getCloudFilePickerButton=function(){this._oCloudFilePickerButton=new C({text:this.getCloudFilePickerButtonText()?this.getCloudFilePickerButtonText():this._oRb.getText("UPLOAD_SET_DEFAULT_CFP_BUTTON_TEXT"),press:this._invokeCloudFilePicker.bind(this)});return this._oCloudFilePickerButton};U.prototype._itemSelectedCallback=function(e){var t=e.getParameter("item");switch(t.getText()){case this.getCloudFilePickerButtonText()?this.getCloudFilePickerButtonText():this._oRb.getText("UPLOAD_SET_DEFAULT_CFP_BUTTON_TEXT"):this._oMenuButton.detachEvent("defaultAction",this.fileSelectionHandler.bind(this)).attachEvent("defaultAction",this._invokeCloudFilePicker.bind(this));this._invokeCloudFilePicker();this._oMenuButton.setText(t.getText());break;case this._oRb.getText("UPLOAD_SET_DEFAULT_LFP_BUTTON_TEXT"):this._oMenuButton.detachEvent("defaultAction",this._invokeCloudFilePicker.bind(this)).attachEvent("defaultAction",this.fileSelectionHandler.bind(this));this.fileSelectionHandler();this._oMenuButton.setText(t.getText());break}};U.prototype._invokeCloudFilePicker=function(){var e=null;if(this._cloudFilePickerControl){e=this._getCloudFilePickerInstance();e.open()}else{this._loadCloudFilePickerDependency().then(t=>{this._cloudFilePickerControl=t;e=this._getCloudFilePickerInstance();e.open()}).catch(e=>{i.error(e)})}return e};U.prototype._onCloudPickerFileChange=function(e){var t=e.getParameters();var i=[];if(t&&t.selectedFiles){t.selectedFiles.forEach(e=>{i.push(this._createFileFromCloudPickerFile(e))})}this._processNewCloudPickerFileObjects(i)};U.prototype._createFileFromCloudPickerFile=function(e){var t=[new Blob([])];var i={type:e.getFileShareItemContentType(),size:e.getFileShareItemContentSize(),webkitRelativePath:"",name:e.getFileShareItemName()};var o=new File(t,e.getFileShareItemName(),i);return{file:o,fileShareProperties:e.mProperties}};U.prototype._processNewCloudPickerFileObjects=function(e){e.forEach(t=>{var o=t.file;const a=t.fileShareProperties;var n=new r({uploadState:E.Ready});n.setParent(this);n._setFileObject(o);n.setFileName(o.name);if(o&&a){n._setCloudFileInfo(a)}if(this.getItemValidationHandler()&&typeof this.getItemValidationHandler()==="function"){const t={oItem:n,iTotalItemsForUpload:e.length,oSource:this};var l=this.getItemValidationHandler()(t);if(l&&l instanceof Promise){l.then(e=>{if(e instanceof r){this._initateItemUpload(e)}}).catch(e=>{if(e&&this._oItemToUpdate&&e instanceof r&&e.getId()===this._oItemToUpdate.getId()){this._oItemToUpdate=null}})}else{n.destroy();i.error("Invalid usage, missing Promise: ItemValidationHandler callback expects Promise to be returned.")}}else{this._initateItemUpload(n)}})};U.prototype._loadCloudFilePickerDependency=function(){return new Promise((e,t)=>{P.loadLibrary("sap.suite.ui.commons",{async:true}).then(function(i){sap.ui.require(["sap/suite/ui/commons/CloudFilePicker"],function(t){e(t)},function(e){t(e)})}).catch(function(){t("CloudFilePicker Control not available.")})})};U.prototype._initiateFilePreview=function(e,i){if(!this.getPreviewDialog()){const e=new h;this.setPreviewDialog(e)}this._filePreviewDialogControl=t.getElementById(this.getPreviewDialog());if(this._filePreviewDialogControl){this._filePreviewDialogControl._previewItem=e;this._filePreviewDialogControl._items=i;this._filePreviewDialogControl._open()}};U.prototype._getActionToReplacePlaceholder=function(e){switch(e){case w.UploadButtonPlaceholder:return!this.getUploadButtonInvisible()?this.getDefaultFileUploader():null;case w.CloudFilePickerButtonPlaceholder:return this.getCloudFilePickerEnabled()?this._getCloudFilePickerButton():null;default:break}return null};U.prototype._setActions=function(){const e=this.getActions();e.forEach(e=>{const i=t.getElementById(e);i?.setAggregation("_actionButton",this._getActionToReplacePlaceholder(i.getPlaceholderFor()),true)})};U.prototype._initiateFileDownload=function(e,t){return this._getActiveUploader?this._getActiveUploader().download(e,[],t):false};U.prototype._getDefaultNoDataIllustration=function(){const e=new u({illustrationType:p.DragFilesToUpload,illustrationSize:d.Small,title:this._oRb.getText("UPLOADSET_WITH_TABLE_NO_DATA_TEXT"),description:this._oRb.getText("UPLOADSET_WITH_TABLE_NO_DATA_DESCRIPTION")});e.addStyleClass("sapMUSTP-IllustratedMessage-container");return e};U.prototype.getItemsMap=function(e){return new Promise((t,i)=>{const o=e.map(async e=>{const t=await this.getItemForContext(e);return t});Promise.all(o).then(e=>t(e))})};U.prototype.getItemForContext=async function(e,t=false){const i=this.getConfig("getModelName");const o=this.getRowConfiguration();const a=new r({customData:[new sap.ui.core.CustomData({key:"path",value:e.getPath()}),new sap.ui.core.CustomData({key:"context",value:e})]});a.setParent(this);if(i){a.setBindingContext(e,i)}else{a.setBindingContext(e)}if(o?._fileNameValidator(e)){await this.bindItemProperty(a,{property:"fileName",propertyPath:o.getFileNamePath(),modelName:i,value:e?.getProperty(o.getFileNamePath())},t)}if(o?._urlValidator(e)){await this.bindItemProperty(a,{property:"url",propertyPath:o.getUrlPath(),modelName:i,value:e?.getProperty(o.getUrlPath())},t)}if(o?._mediaTypeValidator(e)){await this.bindItemProperty(a,{property:"mediaType",propertyPath:o.getMediaTypePath(),modelName:i,value:e?.getProperty(o.getMediaTypePath())},t)}if(o?._uploadUrlValidator(e)){await this.bindItemProperty(a,{property:"uploadUrl",propertyPath:o.getUploadUrlPath(),modelName:i,value:e?.getProperty(o.getUploadUrlPath())},t)}if(o?._previewableValidator(e)){await this.bindItemProperty(a,{property:"previewable",propertyPath:o.getPreviewablePath(),modelName:i,value:e?.getProperty(o.getPreviewablePath())},t)}if(o?._fileSizeValidator(e)){await this.bindItemProperty(a,{property:"fileSize",propertyPath:o.getFileSizePath(),modelName:i,value:e?.getProperty(o.getFileSizePath())},t)}if(o?._isTrustedSourcePathValidator(e)){await this.bindItemProperty(a,{property:"isTrustedSource",propertyPath:o.getIsTrustedSourcePath(),modelName:i,value:e?.getProperty(o?.getIsTrustedSourcePath())},t)}return a};U.prototype.bindItemProperty=function(e,t,i=false){const{property:o,propertyPath:a,modelName:n}=t;return new Promise((t,r)=>{const l={path:n?`${n}>${a}`:a,mode:i?b.OneWay:b.TwoWay,events:{change:function(){e?.getBinding(o)?.detachChange(e=>{});t()}}};e.bindProperty(o,l)})};U.prototype._onUploadAborted=function(e){var t=e.getParameter("item");t.setUploadState(E.Error);t.fireUploadTerminated({item:t})};U.prototype._handleUploadTermination=function(e){this._getActiveUploader().terminateItem(e)};U.prototype._terminateItemUpload=function(e){if(e&&e instanceof r){this._getActiveUploader()?.terminateItem(e)}};function S(){e.setConfigs({"sap.ui.mdc.Table":{_sModelName:undefined,_bIsTableBound:false,setPluginDefaultSettings:function(e,t){if(t.getUploadEnabled()){this.setDragDropConfig(e,t)}this.setDefaultIllustrations(e,t)},setIsTableBound:function(e){const t=e?._oTable;if(t&&(t?.getBinding("rows")||t?.getBinding("items"))){this._bIsTableBound=true}else{this._bIsTableBound=false}},getIsTableBound:function(){return this._bIsTableBound},setModelName:function(e){const t=e?._oTable;if(t?.isA("sap.m.Table")){this._sModelName=t?.getBindingInfo("items")?.model}else if(t?.isA("sap.ui.table.Table")){this._sModelName=t?.getBindingInfo("rows")?.model}},getModelName:function(){return this._sModelName},setDragDropConfig:function(e,t){sap.ui.require(["sap/ui/mdc/table/DragDropConfig"],i=>{const o=t._oDragDropConfig=new i({droppable:true});o.attachDrop(t._onDropFile.bind(t));e.addDragDropConfig(o)},()=>{i.error("Failed to load MDC library for Drag and Drop configuration.")})},resetDragDropConfig:function(e,t){if(t&&e&&t._oDragDropConfig){e.removeDragDropConfig(t._oDragDropConfig);t._oDragDropConfig=null}},setDefaultIllustrations:function(e,t){const i=t?.getNoDataIllustration();if(e&&t){if(!i){t._illustratedMessage=t._getDefaultNoDataIllustration()}else{t._illustratedMessage=i}e.setNoData(t._illustratedMessage)}},cleanupPluginInstanceSettings:function(e,t){if(e){e.setNoData(null)}if(t){t.setPreviewDialog(null);t._illustratedMessage=null}if(t._oDragDropConfig&&e){e.removeDragDropConfig(t._oDragDropConfig);t._oDragDropConfig=null}},openFilePreview:async function(e,t,i){const o=i.getRowConfiguration();const a=this.getTableContexts(t?._oTable);let n=[];if(a?.length){n=await i.getItemsMap(a,o);const t=n.find(t=>t?.data("path")===e.getPath());if(t){i._initiateFilePreview(t,n)}}},download:async function(e,t){const{oBindingContext:i,bAskForLocation:o}=e;const a=await t.getItemForContext(i);if(a&&a.getUrl()){return t._initiateFileDownload(a,o)}return false},getTableContexts:function(e){if(e?.isA("sap.m.Table")){return e.getBinding("items").getCurrentContexts()}else if(e?.isA("sap.ui.table.Table")){return e?.getBinding("rows")?.getCurrentContexts()}return null}},"sap.m.Table":{_sModelName:undefined,_bIsTableBound:false,setPluginDefaultSettings:function(e,t){if(t.getUploadEnabled()){this.setDragDropConfig(e,t)}this.setDefaultIllustrations(e,t)},setIsTableBound:function(e){if(e?.getBinding("items")){this._bIsTableBound=true}else{this._bIsTableBound=false}},getIsTableBound:function(){return this._bIsTableBound},setModelName:function(e){if(e?.isA("sap.m.Table")){this._sModelName=e?.getBindingInfo("items")?.model}},getModelName:function(){return this._sModelName},setDragDropConfig:function(e,t){var i=t._oDragDropConfig=new f({sourceAggregation:"items",targetAggregation:"items"});var o=t._oDropConfig=new c({dropEffect:"Move",dropPosition:"OnOrBetween",dragEnter:[t?._onDragEnterFile,t],drop:[t?._onDropFile,t]});e?.addDragDropConfig(i);e?.addDragDropConfig(o)},resetDragDropConfig:function(e,t){if(t&&e){e.removeDragDropConfig(t._oDragDropConfig);e.removeDragDropConfig(t._oDropConfig);t._oDragDropConfig=null;t._oDropConfig=null}},setDefaultIllustrations:function(e,t){const i=t?.getNoDataIllustration();if(e&&t){if(!i){t._illustratedMessage=t._getDefaultNoDataIllustration()}else{t._illustratedMessage=i}e.setNoData(t._illustratedMessage)}},cleanupPluginInstanceSettings:function(e,t){if(e){e.setNoData(null)}if(t){t.setPreviewDialog(null);t._illustratedMessage=null}if(t._oDragDropConfig&&e){e.removeDragDropConfig(t._oDragDropConfig);t._oDragDropConfig=null}},openFilePreview:async function(e,t,i){const o=i.getRowConfiguration();const a=this.getTableContexts(t);let n=[];if(a?.length){n=await i.getItemsMap(a,o)}const r=n.find(t=>t?.data("path")===e.getPath());if(r){i._initiateFilePreview(r,n)}},download:async function(e,t){const{oBindingContext:i,bAskForLocation:o}=e;const a=await t.getItemForContext(i);if(a&&a.getUrl()){return t._initiateFileDownload(a,o)}return false},getTableContexts:function(e){return e?.getBinding("items")?.getCurrentContexts()||null}},"sap.ui.table.Table":{_sModelName:undefined,_bIsTableBound:false,setPluginDefaultSettings:function(e,t){if(t.getUploadEnabled()){this.setDragDropConfig(e,t)}this.setDefaultIllustrations(e,t)},setIsTableBound:function(e){if(e?.getBinding("rows")){this._bIsTableBound=true}else{this._bIsTableBound=false}},getIsTableBound:function(){return this._bIsTableBound},setModelName:function(e){if(e?.isA("sap.ui.table.Table")){this._sModelName=e?.getBindingInfo("rows")?.model}},getModelName:function(){return this._sModelName},setDragDropConfig:function(e,t){var i=t._oDragDropConfig=new f({sourceAggregation:"rows",targetAggregation:"rows"});var o=t._oDropConfig=new c({dropEffect:"Move",dropPosition:"OnOrBetween",dragEnter:[t?._onDragEnterFile,t],drop:[t?._onDropFile,t]});e?.addDragDropConfig(i);e?.addDragDropConfig(o)},resetDragDropConfig:function(e,t){if(t&&e){e.removeDragDropConfig(t._oDragDropConfig);e.removeDragDropConfig(t._oDropConfig);t._oDragDropConfig=null;t._oDropConfig=null}},setDefaultIllustrations:function(e,t){const i=t?.getNoDataIllustration();if(e&&t){if(!i){t._illustratedMessage=t._getDefaultNoDataIllustration()}else{t._illustratedMessage=i}e.setNoData(t._illustratedMessage)}},cleanupPluginInstanceSettings:function(e,t){if(e){e.setNoData(null)}if(t){t.setPreviewDialog(null);t._illustratedMessage=null}if(t._oDragDropConfig&&e){e.removeDragDropConfig(t._oDragDropConfig);t._oDragDropConfig=null}},openFilePreview:async function(e,t,i){const o=i.getRowConfiguration();const a=this.getTableContexts(t);let n=[];if(a?.length){n=await i.getItemsMap(a,o);const t=n.find(t=>t?.data("path")===e.getPath());if(t){i._initiateFilePreview(t,n)}}},download:async function(e,t){const{oBindingContext:i,bAskForLocation:o}=e;const a=await t.getItemForContext(i);if(a&&a.getUrl()){return t._initiateFileDownload(a,o)}return false},getTableContexts:function(e){return e?.getBinding("rows")?.getCurrentContexts()||null}}},U)}return U});
//# sourceMappingURL=UploadSetwithTable.js.map