/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/ResponsivePopover","sap/m/Button","sap/m/OverflowToolbar","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Title","sap/m/List","sap/m/InputListItem","sap/m/CustomListItem","sap/m/Label","sap/m/IllustratedMessage","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/m/library","sap/ui/Device","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/StaticArea","sap/ui/layout/form/Form","sap/ui/layout/form/FormContainer","sap/ui/layout/form/FormElement","sap/ui/layout/form/ResponsiveGridLayout","sap/ui/layout/GridData","sap/ui/thirdparty/jquery","sap/ui/dom/containsOrEquals","sap/ui/events/ControlEvents","sap/base/strings/capitalize","sap/m/p13n/AbstractContainerItem","sap/m/p13n/Container","sap/m/table/columnmenu/MenuBase","sap/m/table/columnmenu/MenuRenderer"],function(t,e,i,o,s,n,r,a,u,l,c,h,p,g,f,_,d,m,v,y,I,C,L,b,E,jQuery,A,k,w,B,Q,S,T){"use strict";var M=v.aria.HasPopup;var P=g.table.columnmenu.Category;var O=S.extend("sap.m.table.columnmenu.Menu",{metadata:{library:"sap.m",defaultAggregation:"quickActions",properties:{showTableSettingsButton:{type:"boolean",defaultValue:false}},aggregations:{quickActions:{type:"sap.m.table.columnmenu.QuickActionBase"},items:{type:"sap.m.table.columnmenu.ItemBase"},_quickActions:{type:"sap.m.table.columnmenu.QuickActionBase",visibility:"hidden"},_items:{type:"sap.m.table.columnmenu.ItemBase",visibility:"hidden"}},events:{tableSettingsPressed:{}}},renderer:T});var N="$default";var x=M.Dialog;O.prototype.init=function(){this.fAnyEventHandlerProxy=jQuery.proxy(function(t){if(!this.isOpen()||!this.getDomRef()||t.type!="mousedown"&&t.type!="touchstart"){return}this.handleOuterEvent(this.getId(),t)},this)};O.prototype.openBy=function(t,e){if(this.isOpen()&&t===this._oIsOpenBy){return}var i=true;var o=t;if(!(t instanceof d)){o=d.closestTo(t,true)}if(!e){i=this.fireBeforeOpen({openBy:o})}if(!i){return}const s=()=>{this._initPopover();this._oQuickSortList=this._initQuickActionList(P.Sort);this._oQuickFilterList=this._initQuickActionList(P.Filter);this._oQuickGroupList=this._initQuickActionList(P.Group);this._oQuickAggregateList=this._initQuickActionList(P.Aggregate);this._oQuickGenericList=this._initQuickActionList(P.Generic);this._initItemsContainer();if(!this.getParent()){y.getUIArea().addContent(this,true)}if(this._getAllEffectiveQuickActions().length===0&&this._getAllEffectiveItems().length===0){this._initIllustratedMessage()}this._oPopover.setInitialFocus(this._oQuickSortList||this._oQuickFilterList||this._oQuickGroupList||this._oQuickAggregateList||this._oQuickGenericList||this._oItemsContainer);this._oPopover.openBy(t);this._oIsOpenBy=t;k.bindAnyEvent(this.fAnyEventHandlerProxy)};if(this.isOpen()){this._oPopover.attachEventOnce("afterClose",s);this.close()}else{s()}};O.prototype.setShowTableSettingsButton=function(t){this.setProperty("showTableSettingsButton",t,true);if(!this._oPopover){return this}if(this._oPopover.getEndButton()&&!t){this._oPopover.getEndButton().destroy();this._oPopover.setEndButton(null)}else{this._oPopover.setEndButton(R(this))}return this};function R(t){return new e({icon:"sap-icon://action-settings",tooltip:t._getResourceText("table.COLUMNMENU_TABLE_SETTINGS"),press:()=>{t._oPopover.close();t.fireTableSettingsPressed()}})}O.prototype.getAriaHasPopupType=function(){return x};O.prototype.isOpen=function(){return this._oPopover?this._oPopover.isOpen():false};O.prototype.close=function(){this._previousView=null;if(this._oPopover&&this._oPopover.isOpen()){if(this._oQuickSortList){this.removeDependent(this._oQuickSortList);this._oQuickSortList.destroy();this._oQuickSortList=null}if(this._oQuickFilterList){this.removeDependent(this._oQuickFilterList);this._oQuickFilterList.destroy();this._oQuickFilterList=null}if(this._oQuickGroupList){this.removeDependent(this._oQuickGroupList);this._oQuickGroupList.destroy();this._oQuickGroupList=null}if(this._oQuickAggregateList){this.removeDependent(this._oQuickAggregateList);this._oQuickAggregateList.destroy();this._oQuickAggregateList=null}if(this._oQuickGenericList){this.removeDependent(this._oQuickGenericList);this._oQuickGenericList.destroy();this._oQuickGenericList=null}if(this._oItemsContainer){this.removeDependent(this._oItemsContainer);this._oItemsContainer.destroy();this._oItemsContainer=null}y.getUIArea().removeContent(this,true);this._oPopover.close();k.unbindAnyEvent(this.fAnyEventHandlerProxy)}};O.prototype._onPopoverAfterClose=function(){this.fireAfterClose()};O.prototype.exit=function(){S.prototype.exit.apply(this,arguments);if(this._oPopover){delete this._oPopover}if(this._oQuickSortList){delete this._oQuickSortList}if(this._oQuickFilterList){delete this._oQuickFilterList}if(this._oQuickGroupList){delete this._oQuickGroupList}if(this._oQuickAggregateList){delete this._oQuickAggregateList}if(this._oQuickGenericList){delete this._oQuickGenericList}if(this._oItemsContainer){delete this._oItemsContainer}if(this._oIsOpenBy){delete this._oIsOpenBy}if(this._oIllustratedMessage){this._oIllustratedMessage.destroy();delete this._oIllustratedMessage}k.unbindAnyEvent(this.fAnyEventHandlerProxy)};O.prototype._initPopover=function(){if(this._oPopover){return}this._oPopover=new t({showArrow:false,showHeader:f.system.phone,placement:g.PlacementType.VerticalPreferredBottom,content:new D({control:this,height:true}),horizontalScrolling:false,verticalScrolling:true,afterClose:[this._onPopoverAfterClose,this],customHeader:new i({content:[new n({text:this._getResourceText("table.COLUMNMENU_TITLE")}),new s,new e({icon:"sap-icon://decline",tooltip:this._getResourceText("table.COLUMNMENU_CLOSE"),press:()=>{this._oPopover.close()}})]}).addStyleClass("sapMTBHeader-CTX")});if(this.getShowTableSettingsButton()){this._oPopover.setEndButton(R(this))}this.addDependent(this._oPopover);this._oPopover.addStyleClass("sapMTCMenuPopup");this._oPopover.addEventDelegate({onsapfocusleave:this.handleFocusLeave},this);this._oPopover._oControl.oPopup.setAutoClose(false)};O.prototype.handleFocusLeave=function(t){if(!this.isOpen()){return}if(t.relatedControlId&&(!A(this.getDomRef(),jQuery(document.getElementById(t.relatedControlId)).get(0))&&!V(this,d.getElementById(t.relatedControlId)))){this.close()}};O.prototype.handleOuterEvent=function(t,e){var i=f.support.touch||f.system.combi;if(i&&(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose"))){return}if(e.type=="mousedown"||e.type=="touchstart"){if(!A(this.getDomRef(),e.target)&&!A(this._oPopover.getDomRef(),e.target)&&!V(this,d.closestTo(e.target))){this.close()}}};function V(t,e){if(!t||!e){return false}var i=e.getParent();if(!i){return false}else if(i===t){return true}return V(t,i)}O.prototype._initItemsContainer=function(){var t=this._getAllEffectiveItems();var e=this._hasItems();if(e&&!this._oItemsContainer){this._createItemsContainer()}t.forEach(t=>{this._addView(t)})};var D=_.extend("sap.m.table.columnmenu.AssociativeControl",{metadata:{library:"sap.m",final:true,properties:{height:{type:"boolean",defaultValue:false}},associations:{control:{type:"sap.ui.core.Control"}}},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);e.getHeight()&&t.style("height","100%");t.openEnd();t.renderControl(d.getElementById(e.getControl()));t.close("div")}},addAriaLabelledBy:function(t){const e=d.getElementById(this.getControl());e?.removeAllAssociation("ariaLabelledBy");e?.addAriaLabelledBy?.(t);return this},getAriaLabelledBy:function(){const t=d.getElementById(this.getControl());return t?.getAriaLabelledBy?.()||[]}});O.prototype._addView=function(t){var e=new B({content:new D({control:t.getContent(),height:true}),key:t.getId(),text:t.getLabel(),icon:t.getIcon(),type:t.isA("sap.m.table.columnmenu.ActionItem")?g.ListType.Active:g.ListType.Navigation});this._oItemsContainer.addView(e);this._setItemVisibility(t,t.getVisible())};O.prototype._createItemsContainer=function(){this._oBtnCancel=new e({text:this._getResourceText("table.COLUMNMENU_CANCEL"),press:[function(){var t=this._oItemsContainer.getCurrentViewKey();if(this._fireEvent(d.getElementById(t),"cancel")){this.close()}},this]});this._oBtnOk=new e({text:this._getResourceText("table.COLUMNMENU_CONFIRM"),type:g.ButtonType.Emphasized,press:[function(){var t=this._oItemsContainer.getCurrentViewKey();if(this._fireEvent(d.getElementById(t),"confirm")){this.close()}},this]});this._oItemsContainer=new Q({listLayout:true,defaultView:N,footer:new o({content:[new s,this._oBtnOk,this._oBtnCancel]}),beforeViewSwitch:[function(t){var e=t.getParameters();this.invalidate();if(e.target!=="$default"){var i=this._oItemsContainer.getView(e.target);var o=this._getItemFromContainerItem(i);if(o&&!this._fireEvent(o,"press")){t.preventDefault()}}},this],afterViewSwitch:[function(t){var e=this.getDependents();if(e){e.forEach(function(t){if(t&&t.isA("sap.ui.core.Control")){t.invalidate()}})}var i=t.getParameters();this._oItemsContainer.getLayout().setShowFooter(i.target!=="$default");this._previousView=i.source;if(i.target!=="$default"){var o=this._oItemsContainer.getView(i.target);if(o){var s=this._getItemFromContainerItem(o);this._updateButtonState(s);this._focusItem()}}else{this._focusItem()}},this]});const t=this._hasQuickActions()?this._getResourceText("table.COLUMNMENU_LIST_ITEMS_TITLE"):this._getResourceText("table.COLUMNMENU_LIST_ITEMS_ONLY_TITLE");this._oItemsContainer.setListHeader(new i({content:[new n({text:t})]}));this._oItemsContainer.getHeader().addContentRight(new e({text:this._getResourceText("table.COLUMNMENU_RESET"),press:[function(){this._fireEvent(d.getElementById(this._oItemsContainer.getCurrentViewKey()),"reset",false)},this]}));this.addDependent(this._oItemsContainer)};O.prototype._fireEvent=function(t,e,i){var o=t["on"+w(e)];if(i!==false){var s=jQuery.Event(e);o.call(t,s);return!s.isDefaultPrevented()}else{o.call(t);return true}};O.prototype._getResourceText=function(t,e){this.oResourceBundle=this.oResourceBundle?this.oResourceBundle:m.getResourceBundleFor("sap.m");return t?this.oResourceBundle.getText(t,e):this.oResourceBundle};var U={};U[P.Sort]=0;U[P.Filter]=1;U[P.Group]=2;U[P.Aggregate]=3;U[P.Generic]=4;O.prototype._getAllEffectiveQuickActions=function(t){var e=(this.getAggregation("_quickActions")||[]).concat(this.getQuickActions());e=e.reduce(function(t,e){return t.concat(e?e.getEffectiveQuickActions():[])},[]);if(!t){e.sort(function(t,e){return U[t.getCategory()]-U[e.getCategory()]})}return e};O.prototype._hasQuickActions=function(){return this._getAllEffectiveQuickActions(true).length>0};O.prototype._getAllEffectiveItems=function(){var t=(this.getAggregation("_items")||[]).concat(this.getItems());return t.reduce(function(t,e){return t.concat(e.getEffectiveItems())},[]).filter(function(t){return t.getVisible()})};O.prototype._hasItems=function(){return this._getAllEffectiveItems().length>0};O.prototype._getItemFromContainerItem=function(t){return this._getAllEffectiveItems().find(function(e){return e.getId()===t.getKey()})};O.prototype._updateButtonState=function(t){if(!this._oItemsContainer){return}if(this._oItemsContainer.getCurrentViewKey()===N){return}this._oItemsContainer.getHeader().getContentRight()[0].setVisible(t.getButtonSettings()["reset"]["visible"]);this._oItemsContainer.getHeader().getContentRight()[0].setEnabled(t.getButtonSettings()["reset"]["enabled"]);this._oBtnOk.setVisible(t.getButtonSettings()["confirm"]["visible"]);this._oBtnCancel.setVisible(t.getButtonSettings()["cancel"]["visible"])};O.prototype._focusItem=function(){if(this._previousView==N){this._oItemsContainer._getNavBackBtn().focus()}else{var t=this._oItemsContainer?._getNavigationList().getItems().find(function(t){return t.getVisible()&&t._key===this._previousView}.bind(this));t&&t.focus()}};O.prototype._setItemVisibility=function(t,e){if(!this._oItemsContainer){return}var i=this._oItemsContainer?._getNavigationList().getItems();var o=i.find(function(e){return e._key==t.getId()});o?.setVisible(e)};function G(){return this._getAllEffectiveQuickActions(true).filter(function(t){return t.getVisible()&&t.getCategory()!==P.Generic}).length>0}O.prototype._initQuickActionList=function(t){var e;var o=this._getAllEffectiveQuickActions().filter(function(e){return e.getVisible()&&e.getCategory()===t});const s=t===P.Generic&&!G.call(this)?this._getResourceText("table.COLUMNMENU_QUICK_GENERIC_ONLY_TITLE"):this._getResourceText("table.COLUMNMENU_QUICK_"+t.toUpperCase()+"_TITLE");if(o.length){e=new r({headerToolbar:new i({content:[new n({text:s})]}),keyboardMode:"Edit",items:[]});o.map(function(t){if(t.getContent()?.length===1&&t.getContent()[0].isA("sap.ui.core.IFormContent")){e.addItem(new a({contentSize:t.getContentSize(),label:t.getLabel(),content:H([].concat(t.getContent()))}))}else{e.addItem(new u({content:F(t)}))}});this.addDependent(e)}return e};function F(t){var e=new l({text:t.getLabel(),layoutData:new E({span:"XL4 L4 M4 S12"}),wrapping:true,width:"100%"});var i=t.getContent()||[];var o=new C;var s=new I({layout:new b({breakpointM:600,labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,columnsL:1,columnsM:1,adjustLabelSpan:false}),formContainers:[o]});var n=[];i.forEach(function(t,o){var s,r,a,u;if(t.getLayoutData()){s=t.getLayoutData().clone()}else{r="L8 M8 S12";a="";if(o>0||o==0&&i.length>1){r="L4 M4 S6";if(o!=0&&(o+1)%2>0){a="L4 M4 S0"}}s=new E({span:r,indent:a})}t.removeAllAssociation("ariaLabelledBy");t.addAssociation("ariaLabelledBy",e.getId());u=new D({control:t.setWidth("100%")});u.setLayoutData(s);n.push(u)},this);o.addFormElement(new L({label:e,fields:n}));return s}function H(t){var e=[];t.forEach(function(t){var i=new D({control:t});e.push(i)});return e}O.prototype._initIllustratedMessage=function(){if(this._oIllustratedMessage){return}this._oIllustratedMessage=new c({title:this._getResourceText("table.COLUMNMENU_EMPTY"),illustrationType:h.NoColumnsSet,illustrationSize:p.ExtraSmall,enableDefaultTitleAndDescription:false});this.addDependent(this._oIllustratedMessage)};return O});
//# sourceMappingURL=Menu.js.map