/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/HTML","sap/m/Button","sap/m/Image","sap/m/PDFViewer","sap/m/Dialog","sap/m/IllustratedMessage","sap/m/IllustratedMessageType","sap/m/Carousel","sap/base/Log","sap/ui/core/Lib","sap/m/VBox","sap/m/Bar","sap/m/Title","sap/ui/core/Control"],function(e,t,i,s,o,n,a,r,l,c,u,g,d,h,p,_){"use strict";const m=g.getResourceBundleFor("sap.m");const f={Png:"image/png",Bmp:"image/bmp",Jpeg:"image/jpeg",Gif:"image/gif",Txt:"text/plain",Pdf:"application/pdf",ChromePdf:"application/x-google-chrome-pdf",Mpeg:"video/mpeg",Mp4:"video/mp4",Quicktime:"video/quicktime",MsVideo:"video/x-msvideo",Vds:"model/vnd.sap.vds"};const C=t.extend("sap.m.upload.FilePreviewDialog",{metadata:{library:"sap.m",properties:{showCarouselArrows:{type:"boolean",defaultValue:true},maxFileSizeforPreview:{type:"float",defaultValue:null},customPageContentHandler:{type:"function",defaultValue:null}},defaultAggregation:"additionalFooterButtons",aggregations:{additionalFooterButtons:{type:"sap.m.Button",multiple:true}}},_previewItem:null,_items:[],_aCachedPageIndexs:[],init:function(){this._oRichTextEditor=null;this._oDialog=null;this._oViewer=null;this._oContentResource=null;this._oCarouselItems=null},exit:function(){this._oRichTextEditor=null;this._oDialog=null;this._oViewer=null;this._oContentResource=null;this._oCarouselItems=null;this._aCachedPageIndexs=[]},_open:async function(){const e=this._items;if(e?.length&&this._previewItem){this._oCarousel=await this._createCarousel();if(!this._oDialog){this._oDialog=this._createDialog()}else{var t=this._oDialog?.getCustomHeader()?.getContentLeft()[0];t?.setText(this._previewItem?.getFileName()||"");this._oDialog.removeAllContent();this._oDialog.insertContent(this._oCarousel)}this.fireEvent("beforePreviewDialogOpen",{oDialog:this._oDialog});this._oDialog.open()}},_loadVkDependency:function(){return new Promise(function(t,i){e.loadLibrary("sap.ui.vk",{async:true}).then(()=>{sap.ui.require(["sap/ui/vk/Viewer","sap/ui/vk/ContentResource"],(e,i)=>{t({viewer:e,contentResource:i})},e=>{i(e)})}).catch(()=>{i("sap.ui.vk.Viewer Control not available.")})})},_loadRichTextEditorDependency:function(){return new Promise((t,i)=>{e.loadLibrary("sap.ui.richtexteditor",{async:true}).then(()=>{sap.ui.require(["sap/ui/richtexteditor/RichTextEditor"],e=>{t(e)},e=>{i(e)})}).catch(()=>{i("RichTextEditor Control not available.")})})},_createIllustratedMessage:function(e){const t=new r({illustrationType:l.NoData,title:e,description:m.getText("FILE_PREVIEW_DIALOG_NO_PREVIEW_AVAILABLE_MSG"),enableVerticalResponsiveness:true});return t},_createVdsViewer:async function(e){if(!this.oViewer||!this._oContentResource){try{const e=await this._loadVkDependency();this._oViewer=e.viewer;this._oContentResource=e.contentResource}catch(e){u.error(e);return null}}const t=new this._oViewer({contentResources:[new this._oContentResource({source:e.getUrl(),sourceType:"vds"})]});return t},_createRichTextEditor:async function(e){if(!this._oRichTextEditor){try{const e=await this._loadRichTextEditorDependency();this._oRichTextEditor=e}catch(e){u.error(e);return null}}const t=new this._oRichTextEditor({height:"100%",width:"100%",editable:false,busy:true});t.attachReady(function(){t.setBusy(false)});const i=new XMLHttpRequest;i.open("GET",e.getUrl(),false);i.send(null);const s=i.responseText;t.setValue(s);return t},_createCarousel:async function(){const e=this._previewItem;let t=this._oCarouselItems=!this.getShowCarouselArrows()?[this._previewItem]:this._items;let i="";let s=null;t=t?.filter(e=>e?.isA("sap.m.upload.UploadSetwithTableItem")||e?.isA("sap.m.upload.UploadItem"));const o=t.map(async t=>{let o=null;if(t?.getId()===e.getId()&&t.getPreviewable()&&this.isFileSizeWithinMaxLimit(t)){const e=await this.getPageContent(t);o=this._getContainerControl(e)}else{const e=this._getPlaceHolderControl(t);o=this._getContainerControl(e)}o=!this.isFileSizeWithinMaxLimit(t)?this._getMaxSizePageIllustration(t):o;i=t?.getId()===e?.getId()?o?.getId():i;s=t?.getId()===e?.getId()?o:s;if(t?.getId()===e?.getId()){this._aCachedPageIndexs.push(this.get)}return o});const n=await Promise.all(o);const a=new c({showPageIndicator:this.getShowCarouselArrows()?true:false,pages:[n],activePage:i,pageChanged:async e=>{const i=n.findIndex(function(t){return t.sId===e.getParameter("newActivePageId")});const s=a.getPages()[i];if(!this._aCachedPageIndexs.includes(i)){const e=await this.getPageContent(t[i],n[i]);s.removeAllItems();s.addItem(e);this._aCachedPageIndexs.push(i)}const o=t[i].getFileName();var r=this._oDialog?.getCustomHeader()?.getContentLeft()[0];r?.setText(o)}});if(s&&i){const e=a?.indexOfPage(s);if(e>-1){this._aCachedPageIndexs?.push(e)}}if(!this.getShowCarouselArrows()){a.ontouchstart=a.ontouchmove=a.ontouchend=e=>{e.preventDefault()}}a.addStyleClass("sapMFilePreviewDialogCarousel");return a},getPageContent:async function(e,s){const a=e.getMediaType();let r=this._createIllustratedMessage(e.getFileName());switch(a?.toLowerCase()){case f.Png:case f.Bmp:case f.Jpeg:case f.Gif:{const t=new o({src:e.getUrl()}).addStyleClass("image-scale");return t}case f.Txt:{const t=await this._createRichTextEditor(e);if(t){r=t}return r}case f.Pdf:case f.ChromePdf:{r=new n({source:e.getUrl(),showDownloadButton:false,isTrustedSource:e?.getIsTrustedSource()});r.setBusy(true);return r}case f.Mpeg:case f.Mp4:case f.Quicktime:case f.MsVideo:{const t=new i({content:`<video controls width='100%' height='100%' src=${e.getUrl()}>`});return t}case f.Tiff:case f.Vds:{const t=await this._createVdsViewer(e);if(t){r=t;return r}break}default:if(this.getCustomPageContentHandler()&&typeof this.getCustomPageContentHandler()==="function"){const i=this.getCustomPageContentHandler()(e);if(i&&i instanceof Promise){try{const e=await i;if(e instanceof t||e instanceof _){r=e}}catch(e){return r}}}return r}return r},_getPlaceHolderControl:function(e){return this._createIllustratedMessage(e.getFileName())},_getContainerControl:function(e){const t=new d({items:[e],fitContainer:true,alignItems:"Center",justifyContent:"Center",alignContent:"Center",renderType:"Bare"});return t},_createDialog:function(){const e=this._getActiveUploadSetwithTableItem();const t=new a({customHeader:new h({contentLeft:[new p({text:e.getFileName()}).addStyleClass("sapMDialogTitle")]}),content:this._oCarousel,horizontalScrolling:false,verticalScrolling:false,contentWidth:"auto",contentHeight:"80vh",buttons:[this.getAdditionalFooterButtons(),new s({text:m.getText("UPLOAD_SET_TABLE_FILE_PREVIEW_DIALOG_DOWNLOAD"),press:()=>{this._getActiveUploadSetwithTableItem().download(true)}}),new s({text:m.getText("UPLOAD_SET_TABLE_FILE_PREVIEW_DIALOG_CLOSE"),press:()=>{this._oCarousel.destroyPages();this._oDialog.close();this._aCachedPageIndexs=[]}})]});return t},_getActiveUploadSetwithTableItem:function(){const e=this._oCarousel.getActivePage();const t=this._oCarousel.getPages();const i=t.findIndex(t=>t.sId===e);return this._oCarouselItems[i]},isFileSizeWithinMaxLimit:function(e){let t=this.getMaxFileSizeforPreview();const i=e&&e.getFileSize?e.getFileSize():0;if(!t||!i){return true}t=t*C.MEGABYTE;return i<=t},_getMaxSizePageIllustration:function(e){const t=new r({illustrationType:l.NoData,title:e?.getFileName(),description:m.getText("FILE_PREVIEW_DIALOG_MAX_PREVIEW_SIZE_EXCEEDED",[this.getMaxFileSizeforPreview()]),enableVerticalResponsiveness:true});return t}});C.MEGABYTE=1048576;return C});
//# sourceMappingURL=FilePreviewDialog.js.map