/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/core/Element"],function(e,t){"use strict";const r=t.extend("sap.m.upload.UploadItemConfiguration",{metadata:{library:"sap.m",properties:{fileNamePath:{type:"string",defaultValue:null},mediaTypePath:{type:"string",defaultValue:null},urlPath:{type:"string",defaultValue:null},uploadUrlPath:{type:"string",defaultValue:null},previewablePath:{type:"string",defaultValue:null},fileSizePath:{type:"string",defaultValue:null},isTrustedSourcePath:{type:"string",defaultValue:null}}}});r.prototype._fileNameValidator=function(t){const r=this.getFileNamePath();if(!r){return false}const a=t?.getProperty(r);if(typeof a==="string"){return true}e.error(`Invalid file name value at ${t.getPath()}. Expected string.`);return false};r.prototype._mediaTypeValidator=function(t){const r=this.getMediaTypePath();if(!r){return false}const a=t?.getProperty(r);if(typeof a==="string"){return true}e.error(`Invalid media type value at ${t.getPath()}. Expected string.`);return false};r.prototype._urlValidator=function(t){const r=this.getUrlPath();if(!r){return false}const a=t?.getProperty(r);if(typeof a==="string"){return true}e.error(`Invalid url value at ${t.getPath()}. Expected string.`);return false};r.prototype._uploadUrlValidator=function(t){const r=this.getUploadUrlPath();if(!r){return false}const a=t?.getProperty(r);if(typeof a==="string"){return true}e.error(`Invalid upload URL value at ${t.getPath()}. Expected string.`);return false};r.prototype._previewableValidator=function(t){const r=this.getPreviewablePath();if(!r){return false}const a=t?.getProperty(r);if(typeof a==="boolean"){return true}else if(typeof a==="string"){if(a.toLowerCase()==="true"||a.toLowerCase()==="false"){return true}}e.error(`Invalid previewable value at ${t.getPath()}. Expected string.`);return false};r.prototype._fileSizeValidator=function(t){const r=this.getFileSizePath();if(!r){return false}const a=t?.getProperty(r);if(typeof a==="number"){return true}else if(typeof a==="string"){const e=parseFloat(a);if(!isNaN(e)){return false}}e.error(`Invalid file Size value at ${t.getPath()}. Expected number.`);return false};r.prototype._isTrustedSourcePathValidator=function(t){const r=this.getIsTrustedSourcePath();if(!r){return false}const a=t?.getProperty(r);if(typeof a==="boolean"){return true}else if(typeof a==="string"){if(a.toLowerCase()==="true"||a.toLowerCase()==="false"){return true}}e.error(`Invalid isTrustedSource value at ${t.getPath()}. Expected Boolean.`);return false};return r});
//# sourceMappingURL=UploadItemConfiguration.js.map