/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/core/library","sap/ui/core/Element","sap/ui/core/Icon","sap/ui/core/IconPool","sap/ui/core/HTML","sap/m/library","sap/m/Button","sap/m/CustomListItem","sap/m/Image","sap/m/Input","sap/m/Label","sap/m/Link","sap/m/ProgressIndicator","sap/m/VBox","sap/m/HBox","sap/ui/core/Lib","sap/ui/core/InvisibleText"],function(t,e,i,s,o,n,a,r,l,h,d,p,_,u,c,g,m,f){"use strict";var y=a.UploadType;var b=i.extend("sap.m.upload.UploadSetItem",{metadata:{library:"sap.m",properties:{enabledRemove:{type:"boolean",defaultValue:true},enabledEdit:{type:"boolean",defaultValue:true},fileName:{type:"string",defaultValue:null},mediaType:{type:"string",defaultValue:null},thumbnailUrl:{type:"string",defaultValue:null},uploadState:{type:"sap.m.UploadState",defaultValue:null},url:{type:"string",defaultValue:null},visibleRemove:{type:"boolean",defaultValue:true},visibleEdit:{type:"boolean",defaultValue:true},uploadUrl:{type:"string",defaultValue:null},selected:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.m.ObjectAttribute",multiple:true,singularName:"attribute"},markers:{type:"sap.m.ObjectMarker",multiple:true,singularName:"marker"},statuses:{type:"sap.m.ObjectStatus",multiple:true,singularName:"status"},markersAsStatus:{type:"sap.m.ObjectStatus",multiple:true,singularName:"markerAsStatus"},headerFields:{type:"sap.ui.core.Item",multiple:true,singularName:"headerField"}},events:{openPressed:{parameters:{item:{type:"sap.m.upload.UploadSetItem"}},allowPreventDefault:true},removePressed:{parameters:{item:{type:"sap.m.upload.UploadSetItem"}},allowPreventDefault:true}}}});var I=a.UploadState,T=a.FlexJustifyContent,E=e.ValueState;var B=n.extend("sap.m.upload.DynamicItemContent",{metadata:{library:"sap.m",associations:{item:{type:"sap.m.upload.UploadSetItem"}}},renderer:{apiVersion:2,render:function(t,e){var s=e.getAssociation("item");var o=i.getElementById(s);t.openStart("div");t.class("sapMUCTextContainer");e._item=o;if(this._bInEditMode){t.class("sapMUCEditMode")}t.attr("id",e.getId());t.openEnd();t.openStart("div").class("sapMUSTextInnerContainer").openEnd();t.renderControl(o._bInEditMode?o._getFileNameEdit():o._getFileNameLink());o._renderMarkers(t);o._renderMarkersAsStatus(t);t.close("div");o._renderAttributes(t);o._renderStatuses(t);t.close("div");o._renderButtons(t)}}});B.prototype.getAccessibilityInfo=function(){var t=[];if(this._item._bInEditMode){t=[this._item._getConfirmRenameButton(),this._item._getCancelRenameButton()]}else{t=[this._item._getRestartButton(),this._item._getEditButton(),this._item._getDeleteButton(),this._item._getTerminateButton()]}return{children:[this._item._bInEditMode?this._item._getFileNameEdit():this._item._getFileNameLink(),...this._item.getMarkers(),...this._item.getMarkersAsStatus(),...this._item.getAttributes(),...this._item.getStatuses(),...t]}};b.MEGABYTE=1048576;b.IMAGE_FILE_ICON="sap-icon://card";b.prototype.init=function(){this._oRb=m.getResourceBundleFor("sap.m");this._oListItem=null;this._oIcon=null;this._oFileNameLink=null;this._oFileNameEdit=null;this._oDynamicContent=null;this._oRestartButton=null;this._oEditButton=null;this._oDeleteButton=null;this._oTerminateButton=null;this._oConfirmRenameButton=null;this._oCancelRenameButton=null;this._oProgressBox=null;this._oProgressIndicator=null;this._oStateLabel=null;this._oProgressLabel=null;this._oFileObject=null;this._fFileSize=null;this._bInEditMode=false;this._bContainsError=false;this._bFileTypeRestricted=false;this._bNameLengthRestricted=false;this._bSizeRestricted=false;this._bMediaTypeRestricted=false;this._sUploadType=y.Native};b.prototype.setFileName=function(t){var e;if(this.getFileName()!==t){this.setProperty("fileName",t,true);if(this.getParent()){this._getFileNameLink().setText(t);e=b._splitFileName(t);this._getFileNameEdit().setValue(e.name);this._checkNameLengthRestriction(this.getParent().getMaxFileNameLength());this._checkTypeRestriction(this.getParent().getFileTypes())}}return this};b.prototype.setUploadState=function(t){var e=this._getProgressIndicator(),i=this._getStateLabel(),s=t!==I.Complete,o=t===I.Uploading;this.setProperty("uploadState",t,true);e.setVisible(s);i.setVisible(s);this._getProgressLabel().setVisible(s);switch(t){case I.Complete:e.setState(E.None);i.setText("");break;case I.Error:e.setState(E.Error);i.setText(this._oRb.getText("UPLOAD_SET_ITEM_ERROR_STATE"));break;case I.Ready:e.setState(E.None);i.setText(this._oRb.getText("UPLOAD_SET_ITEM_READY_STATE"));break;case I.Uploading:e.setState(E.Information);i.setText(this._oRb.getText("UPLOAD_SET_ITEM_UPLOADING_STATE"));break}if(this.getParent()){this._getRestartButton().setVisible(t===I.Error);if(this.getVisibleEdit()){this._getEditButton().setVisible(!o)}if(this.getVisibleRemove()){this._getDeleteButton().setVisible(!o)}this._getTerminateButton().setVisible(this.getParent().getTerminationEnabled()&&o)}return this};b.prototype.setEnabledRemove=function(t){if(this.getEnabledRemove()!==t){this.setProperty("enabledRemove",t,true);if(this.getParent()){this._getDeleteButton().setEnabled(t)}}return this};b.prototype.setVisibleRemove=function(t){if(this.getVisibleRemove()!==t){this.setProperty("visibleRemove",t,true);if(this.getParent()){this._getDeleteButton().setVisible(t)}}return this};b.prototype.setEnabledEdit=function(t){if(this.getEnabledEdit()!==t){this.setProperty("enabledEdit",t,true);if(this.getParent()){this._getEditButton().setEnabled(t);if(!t){this.getParent().handleItemGetDisabled(this)}}}return this};b.prototype.setVisibleEdit=function(t){if(this.getVisibleEdit()!==t){this.setProperty("visibleEdit",t,true);if(this.getParent()){this._getEditButton().setVisible(t);if(!t){this.getParent().handleItemGetDisabled(this)}}}return this};b.prototype.setThumbnailUrl=function(t){if(this.getThumbnailUrl()!=t){this.setProperty("thumbnailUrl",t,true);if(this._oListItem&&t){for(var e=0;e<this._oListItem.getContent().length;e++){var i=this._oListItem.getContent()[e];if(i&&i.isA(["sap.ui.core.Icon","sap.m.Image"])){this._oListItem.removeContent(i);if(this._oIcon){this._oIcon.destroy();this._oIcon=null}this._oIcon=o.createControlByURI({id:this.getId()+"-thumbnail",src:t,decorative:false},h);this._oIcon.addStyleClass("sapMUCItemImage sapMUCItemIcon");this._oListItem.insertContent(this._oIcon,0)}}}}return this};b.prototype.setSelected=function(t){if(this.getSelected()!==t){this.setProperty("selected",t,true);this.fireEvent("selected")}return this};b.prototype.getFileObject=function(){return this._oFileObject};b.prototype.getListItem=function(){return this._getListItem()};b.prototype.setProgress=function(t){var e;this._getProgressLabel().setText(t+"%");e=this.$("-busyIndicator");if(t===100){e.attr("aria-label",this._oRb.getText("UPLOAD_SET_UPLOAD_COMPLETED"))}else{e.attr("aria-valuenow",t)}this._getProgressIndicator().setPercentValue(t);return this};b.prototype.download=function(e){var i=this.getParent();if(!i){t.warning("Download cannot proceed without a parent association.");return false}return i._getActiveUploader().downloadItem(this,[],e)};b.prototype.isRestricted=function(){return this._isRestricted()};b.prototype.getEditState=function(){return this._bInEditMode};b.prototype.getUploadType=function(){return this._sUploadType};b.prototype._handleFileNamePressed=function(t){t.preventDefault();if(this.fireOpenPressed({item:this})){a.URLHelper.redirect(this.getUrl(),true)}};b.prototype._getListItem=function(){if(!this._oListItem){this._oListItem=new l(this.getId()+"-listItem",{content:[this._getIcon(),this._getDynamicContent(),this._getProgressBox()],selected:this.getSelected()});this._oListItem.addStyleClass("sapMUCItem");this._oListItem.setTooltip(this.getTooltip_Text())}return this._oListItem};b.prototype._setFileObject=function(t){this._oFileObject=t;if(t){this._fFileSize=t.size/b.MEGABYTE;this.setMediaType(t.type)}else{this._fFileSize=null;this.setMediaType(null)}if(this.getParent()){this._checkSizeRestriction(this.getParent().getMaxFileSize());this._checkMediaTypeRestriction(this.getParent().getMediaTypes())}};b.prototype._getIcon=function(){if(!this._oIcon){if(this.getThumbnailUrl()){this._oIcon=o.createControlByURI({id:this.getId()+"-thumbnail",src:this.getThumbnailUrl(),decorative:false},h);this._oIcon.addStyleClass("sapMUCItemImage sapMUCItemIcon")}else{this._oIcon=new s(this.getId()+"-icon",{src:this._getIconByMimeType(this.getMediaType()),decorative:false,useIconTooltip:false});this._oIcon.addStyleClass("sapMUCItemIcon")}this.addDependent(this._oIcon)}return this._oIcon};b.prototype._getIconByMimeType=function(t){var e=["image/png","image/tiff","image/bmp","image/jpeg","image/gif"];if(t){if(e.indexOf(t)===-1){return o.getIconForMimeType(t)}return this._getIconByFileType()}else{return this._getIconByFileType()}};b.prototype._getIconByFileType=function(){var t=b._splitFileName(this.getFileName()).extension;if(!t){return"sap-icon://document"}switch(t.toLowerCase()){case"bmp":case"jpg":case"jpeg":case"png":return b.IMAGE_FILE_ICON;case"csv":case"xls":case"xlsx":return"sap-icon://excel-attachment";case"doc":case"docx":case"odt":return"sap-icon://doc-attachment";case"pdf":return"sap-icon://pdf-attachment";case"ppt":case"pptx":return"sap-icon://ppt-attachment";case"txt":return"sap-icon://document-text";default:return"sap-icon://document"}};b.prototype._getFileNameLink=function(){if(!this._oFileNameLink){this._oFileNameLink=new _({id:this.getId()+"-fileNameLink",press:[this,this._handleFileNamePressed,this],wrapping:true,href:this.getUrl()});this._oFileNameLink.setText(this.getFileName());this._oFileNameLink.addStyleClass("sapMUCFileName");this._oFileNameLink.addStyleClass("sapMUSFileName");this.addDependent(this._oFileNameLink)}this._oFileNameLink.setEnabled(!!this.getUrl());return this._oFileNameLink};b.prototype._getDynamicContent=function(){if(!this._oDynamicContent){this._oDynamicContent=new B({item:this});this.addDependent(this._oDynamicContent)}return this._oDynamicContent};b.prototype._getRestartButton=function(){var t=this.getParent();if(!this._oRestartButton){this._oRestartButton=new r({id:this.getId()+"-restartButton",icon:"sap-icon://refresh",type:a.ButtonType.Standard,visible:this.getUploadState()===I.Error,tooltip:this._oRb.getText("UPLOAD_SET_RESTART_BUTTON_TEXT"),press:[this,t._handleItemRestart,t]});this.addDependent(this._oRestartButton)}return this._oRestartButton};b.prototype._getEditButton=function(){var t=this.getParent();if(!this._oEditButton){this._oInvisibleText=new f;this._oInvisibleText.toStatic();this._oEditButton=new r({id:this.getId()+"-editButton",icon:"sap-icon://edit",type:a.ButtonType.Standard,enabled:this.getEnabledEdit(),visible:this.getVisibleEdit(),tooltip:this._oRb.getText("UPLOAD_SET_EDIT_BUTTON_TEXT"),press:[this,t._handleItemEdit,t]});this._oEditButton.addStyleClass("sapMUCEditBtn");this.addDependent(this._oEditButton);this._oEditButton.addAriaLabelledBy(this._oInvisibleText.getId());this._oInvisibleText.setText("Button"+this._oRb.getText("UPLOAD_SET_EDIT_BUTTON_TEXT"))}return this._oEditButton};b.prototype._getFileNameEdit=function(){var t;if(!this._oFileNameEdit){t=b._splitFileName(this.getFileName());this._oFileNameEdit=new d({id:this.getId()+"-fileNameEdit",type:a.InputType.Text});this._oFileNameEdit.addStyleClass("sapMUCEditBox");this._oFileNameEdit.setFieldWidth("75%");this._oFileNameEdit.setDescription(t.extension);this.addDependent(this._oFileNameEdit)}return this._oFileNameEdit};b._checkDoubleFileName=function(t,e){if(e.length===0||!t){return false}var i=e.length;t=t.replace(/^\s+/,"");for(var s=0;s<i;s++){if(t===e[s].getProperty("fileName")){return true}}return false};b._findById=function(t,e){for(var i=0;i<e.length;i++){if(e[i].getId()===t){return e[i]}}return null};b.prototype._setInEditMode=function(t){if(t&&!this._bInEditMode){var e=b._splitFileName(this.getFileName()),i=this.getParent().getMaxFileNameLength(),s=e.extension?e.extension.length+1:0;i=i?i:0;var o=i-s;o=o<0?0:o;this._getFileNameEdit().setProperty("maxLength",o,true);this._getFileNameEdit().setValue(e.name)}this._bInEditMode=t;this._setContainsError(false);this._getFileNameEdit().setShowValueStateMessage(false);this._getFileNameEdit().setProperty("valueState","None",true);this.invalidate()};b.prototype._getContainsError=function(){return this._bContainsError};b.prototype._setUploadType=function(t){this._sUploadType=t};b.prototype._setContainsError=function(t){this._bContainsError=t};b._splitFileName=function(t,e){var i={};var s=/(?:\.([^.]+))?$/;var o=s.exec(t);if(!o[0]){o[0]="";i.name=t}else{i.name=t?t.slice(0,t.indexOf(o[0])):""}if(e){i.extension=o[0]}else{i.extension=o[1]}return i};b.prototype._getDeleteButton=function(){var t=this.getParent();if(!this._oDeleteButton){this._oInvisibleText=new f;this._oInvisibleText.toStatic();this._oDeleteButton=new r({id:this.getId()+"-deleteButton",icon:"sap-icon://delete",type:a.ButtonType.Standard,enabled:this.getEnabledRemove(),visible:this.getVisibleRemove(),tooltip:this._oRb.getText("UPLOAD_SET_DELETE_BUTTON_TEXT"),press:[this,t._handleItemDelete,t]});this._oDeleteButton.addStyleClass("sapMUCDeleteBtn");this.addDependent(this._oDeleteButton);this._oDeleteButton.addAriaLabelledBy(this._oInvisibleText.getId());this._oInvisibleText.setText("Button"+this._oRb.getText("UPLOAD_SET_DELETE_BUTTON_TEXT"))}return this._oDeleteButton};b.prototype._getTerminateButton=function(){var t=this.getParent();if(!this._oTerminateButton){this._oTerminateButton=new r({id:this.getId()+"-terminateButton",icon:"sap-icon://stop",type:a.ButtonType.Standard,visible:t.getTerminationEnabled()&&this.getUploadState()===I.Uploading,tooltip:this._oRb.getText("UPLOAD_SET_TERMINATE_BUTTON_TEXT"),press:[this,t._handleTerminateRequest,t]});this._oTerminateButton.addStyleClass("sapMUCDeleteBtn");this.addDependent(this._oTerminateButton)}return this._oTerminateButton};b.prototype._getConfirmRenameButton=function(){var t=this.getParent();if(!this._oConfirmRenameButton){this._oConfirmRenameButton=new r({id:this.getId()+"-okButton",text:this._oRb.getText("UPLOAD_SET_RENAME_BUTTON_TEXT"),type:a.ButtonType.Transparent,press:[this,t._handleItemEditConfirmation,t]});this._oConfirmRenameButton.addStyleClass("sapMUCOkBtn");this.addDependent(this._oConfirmRenameButton)}return this._oConfirmRenameButton};b.prototype._getCancelRenameButton=function(){var t=this.getParent();if(!this._oCancelRenameButton){this._oCancelRenameButton=new r({id:this.getId()+"-cancelButton",text:this._oRb.getText("UPLOAD_SET_CANCEL_BUTTON_TEXT"),type:a.ButtonType.Transparent,press:[this,t._handleItemEditCancelation,t]});this._oCancelRenameButton.addStyleClass("sapMUCCancelBtn");this.addDependent(this._oCancelRenameButton)}return this._oCancelRenameButton};b.prototype._getProgressBox=function(){if(!this._oProgressBox){this._oProgressBox=new c({id:this.getId()+"-progressBox",items:[this._getProgressIndicator(),new g({justifyContent:T.SpaceBetween,items:[this._getStateLabel(),this._getProgressLabel()]})],width:"20%"});this._oProgressBox.addStyleClass("sapMUSProgressBox");this.addDependent(this._oProgressBox)}if(this._oProgressBox){this._oProgressBox.setVisible(this.getUploadState()!==I.Complete)}return this._oProgressBox};b.prototype._getProgressIndicator=function(){if(!this._oProgressIndicator){this._oProgressIndicator=new u({id:this.getId()+"-progressIndicator",percentValue:0,state:E.Information,visible:this.getUploadState()!==I.Complete});this._oProgressIndicator.addStyleClass("sapMUSProgressIndicator")}return this._oProgressIndicator};b.prototype._getStateLabel=function(){if(!this._oStateLabel){this._oStateLabel=new p({id:this.getId()+"-stateLabel",text:"Uploading",visible:this.getUploadState()!==I.Complete})}return this._oStateLabel};b.prototype._getProgressLabel=function(){if(!this._oProgressLabel){this._oProgressLabel=new p({id:this.getId()+"-progressLabel",visible:this.getUploadState()!==I.Complete});this.setProgress(0);this.addDependent(this._oProgressLabel)}return this._oProgressLabel};b.prototype._renderAttributes=function(t){if(this.getAttributes().length===0){return}var e=false;t.openStart("div").class("sapMUCAttrContainer").openEnd();this.getAttributes().forEach(function(i,s){if(e&&i.getVisible()){t.openStart("div").class("sapMUCSeparator").openEnd();t.text(" · ").close("div")}e=e||i.getVisible();t.renderControl(i.addStyleClass("sapMUCAttr"))});t.close("div")};b.prototype._renderMarkers=function(t){if(this.getMarkers().length>0){t.openStart("div").class("sapMUSObjectMarkerContainer").openEnd();this.getMarkers().forEach(function(e){t.renderControl(e.addStyleClass("sapMUCObjectMarker"))});t.close("div")}};b.prototype._renderMarkersAsStatus=function(t){if(this.getMarkersAsStatus().length>0){t.openStart("div").class("sapMUSObjectMarkersAsStatusContainer").openEnd();this.getMarkersAsStatus().forEach(function(e){t.renderControl(e.addStyleClass("sapMUCObjectMarkersAsStatus"))});t.close("div")}};b.prototype._renderStatuses=function(t){if(this.getStatuses().length===0){return}var e=false;t.openStart("div").class("sapMUCStatusContainer").openEnd();this.getStatuses().forEach(function(i,s){if(e&&i.getVisible()){t.openStart("div").class("sapMUCSeparator").openEnd();t.text(" · ").close("div")}e=e||i.getVisible();t.renderControl(i)});t.close("div")};b.prototype._renderStateAndProgress=function(t){t.renderControl(this._getProgressBox())};b.prototype._renderButtons=function(t){var e;if(this._bInEditMode){e=[this._getConfirmRenameButton(),this._getCancelRenameButton()]}else{e=[this._getRestartButton(),this._getEditButton(),this._getDeleteButton(),this._getTerminateButton()]}if(e.length>0){t.openStart("div").class("sapMUSButtonContainer").openEnd();e.forEach(function(i,s){if(s<e.length){i.addStyleClass("sapMUCFirstButton")}t.renderControl(i)});t.close("div")}};b.prototype._checkTypeRestriction=function(t){var e=b._splitFileName(this.getFileName()),i=!!this.getFileName()&&!!t&&t.length>0&&e.extension&&t.indexOf(e.extension.toLowerCase())===-1;if(i!==this._bFileTypeRestricted){this._bFileTypeRestricted=i;this.invalidate();if(i&&this.getParent()){this.getParent().fireFileTypeMismatch({item:this})}}};b.prototype._checkNameLengthRestriction=function(t){var e=t&&!!this.getFileName()&&this.getFileName().length>t;if(e!==this._bNameLengthRestricted){this._bNameLengthRestricted=e;this.invalidate();if(e&&this.getParent()){this.getParent().fireFileNameLengthExceeded({item:this})}}};b.prototype._checkSizeRestriction=function(t){var e=t&&this._fFileSize>t;if(e!==this._bSizeRestricted){this._bSizeRestricted=e;this.invalidate();if(e&&this.getParent()){this.getParent().fireFileSizeExceeded({item:this,fileSize:this._fFileSize})}}};b.prototype._checkMediaTypeRestriction=function(t){var e=!!t&&t.length>0&&!!this.getMediaType()&&t.indexOf(this.getMediaType())===-1;if(e!==this._bMediaTypeRestricted){this._bMediaTypeRestricted=e;this.invalidate();if(e&&this.getParent()){this.getParent().fireMediaTypeMismatch({item:this})}}};b.prototype._isRestricted=function(){return this._bFileTypeRestricted||this._bNameLengthRestricted||this._bSizeRestricted||this._bMediaTypeRestricted};b.prototype.exit=function(){if(this._oProgressIndicator){this._oProgressIndicator.destroy();this._oProgressIndicator=null}if(this._oStateLabel){this._oStateLabel.destroy();this._oStateLabel=null}if(this._oProgressBox){this._oProgressBox.destroy();this._oProgressBox=null}if(this._oListItem){this._oListItem.destroy();this._oListItem=null}if(this._oIcon){this._oIcon.destroy();this._oIcon=null}if(this._oDynamicContent){this._oDynamicContent.destroy();this._oDynamicContent=null}};b.prototype._reset=function(){if(this._oListItem){this._oListItem.destroy();this._oListItem=null}this._oListItem=null;if(this._oIcon){this.removeDependent(this._oIcon);this._oIcon.destroy();this._oIcon=null}if(this._oFileNameLink){this.removeDependent(this._oFileNameLink);this._oFileNameLink.destroy();this._oFileNameLink=null}if(this._oProgressBox){this._oProgressBox.destroy();this.removeDependent(this._oProgressBox);this._oProgressBox=null}if(this._oProgressIndicator){this._oProgressIndicator.destroy();this.removeDependent(this._oProgressIndicator);this._oProgressIndicator=null}if(this._oStateLabel){this._oStateLabel.destroy();this.removeDependent(this._oStateLabel);this._oStateLabel=null}if(this._oProgressLabel){this._oProgressLabel.destroy();this.removeDependent(this._oProgressLabel);this._oProgressLabel=null}if(this._oDynamicContent){this._oDynamicContent.destroy();this._oDynamicContent=null}};return b});
//# sourceMappingURL=UploadSetItem.js.map